/******************************************************************************
* FILE:         db.cpp
* PROJECT:      
* SW-COMPONENT: datapool
*------------------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 08.03.12  | CM-AI/VW32 kollai  | initial version
*
*******************************************************************************/
#include <sys/fcntl.h>
#include <unistd.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_DPPERSACCESS
#define DP_S_IMPORT_INTERFACE_DPTRACE
#define DP_S_IMPORT_INTERFACE_DPMASTER
#include "dp_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_MASTER_TRACE_CLASS
#include "trcGenProj/Header/dpmaster.cpp.trc.h"
#endif

#define MINIMUM(a,b) ((a > b)?(b):(a))


dp_tclDatapoolMaster* dp_tclDatapoolMaster::_poInstance=NULL;

dp_tclDatapoolMaster* dp_tclDatapoolMaster::pGetInstance() 
{
   if (_poInstance==NULL) 
   {
     OSAL_tMQueueHandle VhMasterQueueHandle;
	   //check if master exist
     tS32 s32Ret = OSAL_s32MessageQueueOpen(DP_STR_MASTER_NAME, OSAL_EN_READWRITE, &VhMasterQueueHandle);
     if (s32Ret != OSAL_OK) 
	   {
        _poInstance = new dp_tclDatapoolMaster();		
     } 
	   else 
	   { //close resource      
       OSAL_s32MessageQueueClose(VhMasterQueueHandle);
     }
   }
   return _poInstance;
}


dp_tclDatapoolMaster::dp_tclDatapoolMaster():_u32ClientAckCounter(0) 
{
   _bTerminate = FALSE;

   _u32LockState = DP_U32_LOCK_MODE_NONE;
   _u32LockOwner = 0xffffffff;

   _poPersMemAccessHdl = NULL;

   // create my msgbox
   if (OSAL_ERROR == OSAL_s32MessageQueueCreate(DP_STR_MASTER_NAME,DP_MASTER_MAILBOX_MAX_MESSAGE_COUNT,sizeof(TDpPoolMsg), OSAL_EN_READWRITE,&_hMasterQueueHandle))
   {
      ETG_TRACE_FATAL(("dp_tclDatapoolMaster():: Failed to create master message queue: %s.", DP_STR_MASTER_NAME));
      _hMasterQueueHandle = OSAL_C_INVALID_HANDLE;
   }

   //create thread
   OSAL_trThreadAttribute  rAttr;

   rAttr.szName = (tC8*)DP_STR_MASTER_NAME;//lint !e1773  Attempt to cast away const (or volatile)
   rAttr.s32StackSize = 10000; 
   rAttr.u32Priority = 0;//NCG3D-103823:Modifies RT prio to nice level.
   rAttr.pfEntry = (OSAL_tpfThreadEntry)vDpMainThread;
   rAttr.pvArg = (tPVoid)this;

   _hThreadId = OSAL_ThreadSpawn(&rAttr);

   if ( _hThreadId == OSAL_ERROR ) 
   {
       ETG_TRACE_FATAL(("dp_tclDatapoolMaster():: Unable to spawn Main thread %d.", OSAL_u32ErrorCode()));
   }
   else
   {
       tS32 s32ReturnValue = OSAL_s32ThreadPriority(_hThreadId,-10);//NCG3D-103823:Modifies RT prio to nice level.
       if(s32ReturnValue != OSAL_OK)
       {
           ETG_TRACE_FATAL(("dp_tclDatapoolMaster()::change threadpriority failed %d", OSAL_u32ErrorCode()));
       }
       else
       {
           ETG_TRACE_USR4(("dp_tclDatapoolMaster():: change threadpriority success"));
       }
   }
}

dp_tclDatapoolMaster::~dp_tclDatapoolMaster() 
{
   _poPersMemAccessHdl = NULL;
   //the process, which includes the master thread, should be exist.
   ETG_TRACE_FATAL(("~dp_tclDatapoolMaster(): The master thread should be exists !!!"));	
   ETG_TRACE_ERRMEM(("DATAPOOL_MASTER:~dp_tclDatapoolMaster(): The master thread should be exists"));
   if (_hMasterQueueHandle != OSAL_C_INVALID_HANDLE)
   {
      OSAL_s32MessageQueueClose(_hMasterQueueHandle);
      OSAL_s32MessageQueueDelete(DP_STR_MASTER_NAME);
      _hMasterQueueHandle = OSAL_C_INVALID_HANDLE;
   }   
}

tVoid dp_tclDatapoolMaster::vInitInstance(dp_tclDpPersMemAccess* poPersMem) 
{
   _poPersMemAccessHdl = poPersMem;   
}

tVoid dp_tclDatapoolMaster::vDpMainThread(tVoid *pvArg)
{
   tBool         VbSyncPoolsDone=FALSE;
   tBool         VbRegTraceDone=FALSE;
   dp_tclTraceIf VDpTrace;

   dp_tclDatapoolMaster * myRef = (dp_tclDatapoolMaster*)pvArg;

   ETG_TRACE_USR4(("vDpMainThread():: Main thread is running."));
   myRef->vLoadDpReg();

   /*try to init callback function*/
   if(VDpTrace.vTracePlugIn()==OSAL_OK)
   {
     VbRegTraceDone=TRUE;
	   ETG_TRACE_USR4(("vDpMainThread():: Master register callback at thread startup"));
   }
   
   while(!(myRef->_bTerminate))
   {
     tU32		 u32Prio;
	   tU32       u32WaitTime=OSAL_C_U32_INFINITE;
     TDpPoolMsg oMsg;
      
	   /* set check time, if pool synchonization for SCC and NOR not done*/
	   if (VbSyncPoolsDone==FALSE)
	   {
	     u32WaitTime=DP_U32_CHECK_MASTER_SYNC_PERS_DATA_DELAY;
	   }
     // wait for a message
     // writes the received OSALMsgHandle in the message object
     tS32 s32ReadBytes = OSAL_s32MessageQueueWait(myRef->_hMasterQueueHandle,(tU8*)&oMsg,sizeof(TDpPoolMsg),&u32Prio,u32WaitTime);
     if (s32ReadBytes > 0) 
	   { 
	     ETG_TRACE_USR1(("vDpMainThread():: Message received: %d (AckCounter: %d).", oMsg.eCmd, myRef->_u32ClientAckCounter));
       //check message type 
       switch (oMsg.eCmd) 
       {
         case eRegisterClient:
         {
           TDpClient tNewClient;
           tChar VszMyProcResourceName[DP_MAX_LEN_NAME_RESOURCE];
           memset(VszMyProcResourceName,0,DP_MAX_LEN_NAME_RESOURCE);
           strncpy(VszMyProcResourceName,oMsg.u.tRegMaster.strProzess,DP_MAX_LEN_NAME_RESOURCE-1); //last byte should be zero
           tS32 s32Ret = OSAL_s32MessageQueueOpen(VszMyProcResourceName, OSAL_EN_READWRITE, &tNewClient._hQueueHandle);
			if (s32Ret != OSAL_ERROR) 
			{
				tNewClient._tPid=oMsg.u.tRegMaster.tPid;
				tNewClient._bValid=TRUE;
				ETG_TRACE_USR4(("vDpMainThread():: add client and open remote message queue: %s\n", oMsg.u.tRegMaster.strProzess));
				myRef->oDpClients[oMsg.u.tRegMaster.strProzess] = tNewClient;
				ETG_TRACE_USR4(("vDpMainThread():: number clients %d\n",myRef->oDpClients.size()));
			} 
			else 
			{
				ETG_TRACE_USR4(("vDpMainThread():: failed to open remote message queue: %s -> client not added to map\n", oMsg.u.tRegMaster.strProzess));
			}
         }break;
				 case eUnregisterClient:
				 {
            TMapDpClient::iterator ViPos;
				    ETG_TRACE_USR4(("vDpMainThread():: eUnregisterClient number clients %d ",myRef->oDpClients.size()));				
            ViPos=myRef->oDpClients.find(oMsg.u.strData);
					  if (ViPos != myRef->oDpClients.end()) 
					  {
              ETG_TRACE_USR4(("vDpMainThread():: close message queue and remove client: %s\n", ViPos->first.c_str()));					
						  if(OSAL_OK != OSAL_s32MessageQueueClose(ViPos->second._hQueueHandle))
						  {
						    ETG_TRACE_FATAL(("vDpMainThread():: close message queue fails: %s\n", ViPos->first.c_str()));	
						  }
						  myRef->oDpClients.erase(ViPos);		
						  //if this the last registered process => exist thread
						  if(myRef->oDpClients.size()==0)
						  { //break loop
						    myRef->_bTerminate=TRUE;
						  }
					  }
					  ETG_TRACE_USR4(("vDpMainThread():: number clients %d\n",myRef->oDpClients.size()));
					}break;
          case eStoreAllPools:
          {//iterate through client map and send store command
            if (myRef->_u32ClientAckCounter == 0) 
            {
              TDpPoolMsg oNewMsg = {eClientStorePool, {0}};
              ETG_TRACE_USR4(("vDpMainThread():: send message to store pool to clients"));
              myRef->bBroardcastMsg(&oNewMsg, TRUE);
            } 
            else 
            {//currently storing is active -> send busy back to clients
              TDpPoolMsg oNewMsg = {eErrBusy, {0}};
              ETG_TRACE_FATAL(("vDpMainThread():: FAILED to store because sync call already in process."));
              myRef->bBroardcastMsg(&oNewMsg);
            }
            myRef->vStoreDpReg();
          }break;
          case eLockPool:
          {
            if (  (oMsg.u.au32Data[0] != DP_U32_LOCK_MODE_SETDEF) 
                &&(oMsg.u.au32Data[0] != DP_U32_LOCK_MODE_MASTER)
                &&(oMsg.u.au32Data[0] != DP_U32_LOCK_MODE_END_USER)) 
					  {
              ETG_TRACE_FATAL(("vDpMainThread():: FAILED to lock because lock type unknown: %d.", oMsg.u.au32Data[0]));
              TDpPoolMsg oNewMsg = {eErrParamType, {0}};
              myRef->bBroardcastMsg(&oNewMsg);
            } 
					  else 
					  {
              if (myRef->_u32ClientAckCounter == 0) 
						  {
                if (  (myRef->_u32LockState == DP_U32_LOCK_MODE_NONE) 
                    ||(myRef->_u32LockOwner == oMsg.u.au32Data[1]))
							  {  //iterate through client map and send store command
                  TDpPoolMsg oNewMsg = {eClientLockPool, {oMsg.u.au32Data[0]}};
                  myRef->_u32LockOwner = oMsg.u.au32Data[1];
                  myRef->_u32LockState = oMsg.u.au32Data[0];
                  myRef->bBroardcastMsg(&oNewMsg, TRUE);
                } 
							  else 
							  {  //here an error message should be send back
                  ETG_TRACE_FATAL(("vDpMainThread():: FAILED to lock because already locked by 0x%08x.", myRef->_u32LockOwner));
                  TDpPoolMsg oNewMsg = {eErrAlreadyLocked, {0}};
                  myRef->bBroardcastMsg(&oNewMsg);
                }
              } 
						  else 
						  {  //here an error message should be send back
                ETG_TRACE_FATAL(("vDpMainThread():: FAILED to lock because sync call already in process."));
                TDpPoolMsg oNewMsg = {eErrBusy, {0}};
                myRef->bBroardcastMsg(&oNewMsg);
              }
            }
          }break;
          case eUnlockPool:
          {
            if (myRef->_u32ClientAckCounter == 0) 
            {
              if (myRef->_u32LockState == DP_U32_LOCK_MODE_NONE) 
              {//pool isn't locked -> bcast success
                TDpPoolMsg oNewMsg = {eClientAllPoolsUnlocked, {0}};
                myRef->bBroardcastMsg(&oNewMsg);
                myRef->_u32LockOwner = 0xffffffff;
              } 
              else if (myRef->_u32LockOwner == oMsg.u.u32Data)
              {
                TDpPoolMsg oNewMsg = {eClientUnlockPool, {oMsg.u.u32Data}};
                myRef->bBroardcastMsg(&oNewMsg, TRUE);
                myRef->_u32LockOwner = 0xffffffff;
                myRef->_u32LockState = DP_U32_LOCK_MODE_NONE;
              } 
              else 
              {
                ETG_TRACE_FATAL(("vDpMainThread():: FAILED to unlock because locked by 0x%08x.", myRef->_u32LockOwner));
                TDpPoolMsg oNewMsg = {eErrAlreadyLocked, {0}};
                myRef->bBroardcastMsg(&oNewMsg);
              }
            }
            else 
            {//here an error message should be send back
              ETG_TRACE_FATAL(("vDpMainThread():: FAILED to unlock because Unlock/Lock already in process."));
              TDpPoolMsg oNewMsg = {eErrBusy, {0}};
              myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eDefSet: 				
          {
            if (  (oMsg.u.au32Data[0] != DP_DEFSET_USER) 
               && (oMsg.u.au32Data[0] != DP_DEFSET_TEF)
               && (oMsg.u.au32Data[0] != DP_DEFSET_CUSTOMER)
	             && (oMsg.u.au32Data[0] != DP_DEFSET_END_USER)
	             && (oMsg.u.au32Data[0] != DP_DEFSET_END_USER_BANK)
               ) 
            {
                  ETG_TRACE_FATAL(("vDpMainThread():: FAILED to DefSet because type unknown: %d.", oMsg.u.au32Data[0]));
                  TDpPoolMsg oNewMsg = {eErrParamType, {0}};
                  myRef->bBroardcastMsg(&oNewMsg);
            } 
            else 
            {
              if (myRef->_u32ClientAckCounter == 0) 
	            {  //iterate through client map and send store command
		            TDpPoolMsg oNewMsg = {eClientDefSet,{0}};  
		            oNewMsg.u.au32Data[0]=oMsg.u.au32Data[0];
		            oNewMsg.u.au32Data[1]=oMsg.u.au32Data[1];   	
		            myRef->bBroardcastMsg(&oNewMsg,TRUE);
              } 
	            else 
	            {  //here an error message should be send back
                  ETG_TRACE_FATAL(("vDpMainThread():: FAILED to trigger DefSet because DefSet already in process."));
                  TDpPoolMsg oNewMsg = {eErrBusy, {0}};
                  myRef->bBroardcastMsg(&oNewMsg);
              }
            }
          }break;			    
          case eCalcHash:
          { //iterate through client map and send store command
            if (myRef->_u32ClientAckCounter == 0) 
            {
               TDpPoolMsg oNewMsg = {eClientCalcHash, {0}};
               ETG_TRACE_USR4(("vDpMainThread():: send message to store pool to clients"));
               myRef->bBroardcastMsg(&oNewMsg, TRUE);

            } 
            else 
            {  //currently storing is active -> send busy back to clients
               TDpPoolMsg oNewMsg = {eErrBusy, {0}};
               ETG_TRACE_FATAL(("vDpMainThread():: FAILED to store because sync call already in process."));
               myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eTracePools:
          {//iterate through client map and send trace hsitory command
            TDpPoolMsg oNewMsg = {eClientTracePool, {oMsg.u.u32Data}};
            myRef->bBroardcastMsg(&oNewMsg);
          }break;
          case eTraceElement:
          {  //iterate through client map and send trace hsitory command
            TDpPoolMsg oNewMsg = {eClientTraceElement, {0}};
            OSAL_szStringNCopy(oNewMsg.u.strData, oMsg.u.strData, DP_MAX_LEN_NAME_ELEMENT);
            myRef->bBroardcastMsg(&oNewMsg);
          }break;
          case eTraceHistory:
          { //iterate through client map and send trace hsitory command
             TDpPoolMsg oNewMsg = {eClientTraceHistory, {0}};
             myRef->bBroardcastMsg(&oNewMsg);
          }break;
          case eAckPoolStored:
          {
            myRef->_u32ClientAckCounter--;
            ETG_TRACE_USR4(("vDpMainThread():: waiting for %d 'eAckPoolStored'.", myRef->_u32ClientAckCounter));
            if (myRef->_u32ClientAckCounter == 0) 
            {  //iterate through client map and send store command
               TDpPoolMsg oNewMsg = {eClientAllPoolsStored, {0}};
               myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eAckPoolLocked:
          {
            myRef->_u32ClientAckCounter--;
            if (myRef->_u32ClientAckCounter == 0) 
            {  //iterate through client map and send store command
               TDpPoolMsg oNewMsg = {eClientAllPoolsLocked, {0}};
               myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eAckPoolUnlocked:
          {
            myRef->_u32ClientAckCounter--;
            if (myRef->_u32ClientAckCounter == 0) 
            {//iterate through client map and send store command
               TDpPoolMsg oNewMsg = {eClientAllPoolsUnlocked, {0}};
               myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eAckDefSet:
          {
            myRef->_u32ClientAckCounter--;
            if (myRef->_u32ClientAckCounter == 0) 
            {//iterate through client map and send store command
              TDpPoolMsg oNewMsg = {eClientAllDefSetsReady, {0}};
              ETG_TRACE_USR4(("vDpMainThread():: All ack received, send 'eClientAllDefSetsReady' to indicate DefSet is finished to all clients"));
              myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;			      
          case eAckHashCalc:
          {
            myRef->_u32ClientAckCounter--;
            if (myRef->_u32ClientAckCounter == 0) 
            {//iterate through client map and send store command
              TDpPoolMsg oNewMsg = {eClientHashReady, {0}};
              tU32 u32NumberOfHashes = ((tU32)myRef->oDpHash.size());
              if (u32NumberOfHashes == 0) 
              {
                u32NumberOfHashes = 1;
              }
              tU8* pau8Data = new tU8[sizeof(tHashVal)*u32NumberOfHashes];
              if (pau8Data != NULL) 
              {
                tHashVal* ptHash = (tHashVal*)pau8Data;
                ETG_TRACE_USR4(("vDpMainThread():: All ack received, send 'eClientCalcHash' to indicate DefSet is finished to all clients"));
                TMapDpHash::iterator pos;
                for (pos = myRef->oDpHash.begin(); pos != myRef->oDpHash.end(); ++pos) 
                {
                  ETG_TRACE_USR1(("vDpMainThread():: HASH: %08x%08x%08x%08x%08x -> '%s'.",
                  pos->second.u32Hash[0],
                  pos->second.u32Hash[1],
                  pos->second.u32Hash[2],
                  pos->second.u32Hash[3],
                  pos->second.u32Hash[4],
                  pos->first.c_str()));
                  memmove((tVoid*)ptHash, (tU8*)&pos->second.u32Hash[0], sizeof(tHashVal));
                  ptHash++;
                }
                myRef->_poPersMemAccessHdl->bGenHash(pau8Data, ((tU32)sizeof(tHashVal))*((tU32)myRef->oDpHash.size()), oNewMsg.u.tHash.tValue.u32Hash);
                ETG_TRACE_USR1(("vDpMainThread():: DP HASH: %08x%08x%08x%08x%08x.",
                oNewMsg.u.tHash.tValue.u32Hash[0],
                oNewMsg.u.tHash.tValue.u32Hash[1],
                oNewMsg.u.tHash.tValue.u32Hash[2],
                oNewMsg.u.tHash.tValue.u32Hash[3],
                oNewMsg.u.tHash.tValue.u32Hash[4]));
                ETG_TRACE_USR1(("vDpMainThread():: All ack received, send 'eClientCalcHash' to indicate DefSet is finished to all clients"));
                delete[] pau8Data;
                pau8Data = NULL;/*Bug 123144: Safe handling*/
              }
              //store
              myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eAckUpdatePool:
          { 
            myRef->_u32ClientAckCounter--;
            if (myRef->_u32ClientAckCounter == 0) 
            {//iterate through client map and send store command               
              OSAL_s32ThreadWait(0); // --> call will reschedule by using pthread_yield()
              TDpPoolMsg oNewMsg = {eClientAllUpdatePoolReady, {0}};
              ETG_TRACE_USR4(("vDpMainThread():: All ack received, send 'eClientAllUpdatePoolReady' to indicate UpdatePool is finished to all clients"));
              myRef->bBroardcastMsg(&oNewMsg);					
            }
          }break;          
          case eHashValue:
          { //add new hash
            myRef->oDpHash[oMsg.u.tHash.strFile] = oMsg.u.tHash.tValue;
          }break;
          case ePoolChanged:
          {  //iterate through client map and send trace hsitory command
            OSAL_s32ThreadWait(0); // --> call will reschedule by using pthread_yield()
            TDpPoolMsg oNewMsg = {eClientUpdatePool, {oMsg.u.u32Data}};
            myRef->bBroardcastMsg(&oNewMsg,TRUE);
          }break;
		case eBankAction: 
		{ 
			if (myRef->_u32ClientAckCounter == 0) 
			{  
				  TDpPoolMsg oNewMsg = {eClientBankAction,{0}};  
				  oNewMsg.u.au32Data[0]=oMsg.u.au32Data[0];
				  oNewMsg.u.au32Data[1]=oMsg.u.au32Data[1];   	
				  myRef->bBroardcastMsg(&oNewMsg,TRUE);
			} 
			else 
			{  //here an error message should be send back
				ETG_TRACE_FATAL(("vDpMainThread():: FAILED to trigger eBankAction because global pool action already in process."));
				TDpPoolMsg oNewMsg = {eErrBusy, {0}};
				myRef->bBroardcastMsg(&oNewMsg);
			}
         }break;
		case eAckBankAction:
		{
			 myRef->_u32ClientAckCounter--;
			ETG_TRACE_USR4(("vDpMainThread():: waiting for %d 'eAckBankAction'.", myRef->_u32ClientAckCounter));
			if (myRef->_u32ClientAckCounter == 0) 
			{  
				TDpPoolMsg oNewMsg = {eClientAllBankActionsReady, {0}};
				myRef->bBroardcastMsg(&oNewMsg);
			}
		}break;
          case eEndUserCopy:
          {
            if (myRef->_u32ClientAckCounter == 0) 
					  {  
						  TDpPoolMsg oNewMsg = {eClientEndUserCopy,{0}};  
						  oNewMsg.u.au32Data[0]=oMsg.u.au32Data[0];
						  oNewMsg.u.au32Data[1]=oMsg.u.au32Data[1];   	
						  myRef->bBroardcastMsg(&oNewMsg,TRUE);
            } 
					  else 
					  {  //here an error message should be send back
              ETG_TRACE_FATAL(("vDpMainThread():: FAILED to trigger eEndUserCopy because global pool action already in process."));
              TDpPoolMsg oNewMsg = {eErrBusy, {0}};
              myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          case eAckEndUserCopy:
					{
					  myRef->_u32ClientAckCounter--;
            ETG_TRACE_USR4(("vDpMainThread():: waiting for %d 'eAckEndUserCopy'.", myRef->_u32ClientAckCounter));
            if (myRef->_u32ClientAckCounter == 0) 
					  {  
              TDpPoolMsg oNewMsg = {eClientAllEndUserCopyReady, {0}};
              myRef->bBroardcastMsg(&oNewMsg);
            }
          }break;
          default:
            ETG_TRACE_USR4(("vDpMainThread():: Unknown command in message: %d.", oMsg.eCmd));
          break;
        }
      }
      else if(s32ReadBytes == 0) 
      {	//no message received -> must be timeout: check if sync persistent done
	      tU32 u32CurrentTime = OSAL_ClockGetElapsedTime();	  
		    if(u32CurrentTime>DP_U32_STARTUP_SYNC_TIME)
		    {		  
		      VbSyncPoolsDone=TRUE;
		      /*sync persistent pools (backup, normal data) for V850 and NOR*/
		      myRef->_poPersMemAccessHdl->vSynchronizePersDataWithBackup();
		      ETG_TRACE_USR4(("vDpMainThread():: vSynchronizePersDataWithBackup at time %d",u32CurrentTime));
        }
		    /*try to init callback function*/
        if(VbRegTraceDone==FALSE)
		    {		
	        if(VDpTrace.vTracePlugIn()==OSAL_OK)
		      {
            VbRegTraceDone=TRUE;
			      ETG_TRACE_USR4(("vDpMainThread():: register callback at time %d",u32CurrentTime));
          }
        }
      } 
	    else 
      {
         ETG_TRACE_USR4(("vDpMainThread():: OSAL_s32MessageQueueWait returned with %08x.", s32ReadBytes));
      }
   }
   ETG_TRACE_USR4(("vDpMainThread():: call OSAL_vThreadExit"));
   OSAL_vThreadExit();
}

tBool dp_tclDatapoolMaster::bBroardcastMsg(TDpPoolMsg* pMsg, tBool bSync) 
{
   tBool bRet = TRUE;
   TMapDpClient::iterator pos;
   for (pos = oDpClients.begin(); pos != oDpClients.end(); ++pos) 
   {
      if(pos->second._bValid==TRUE)
	    {
        if(bCheckProcessExist(pos->first.c_str(),pos->second._tPid)==TRUE)
	      {
          ETG_TRACE_USR4(("bBroardcastMsg():: send msg with cmd %d to client : %s.", pMsg->eCmd, pos->first.c_str()));
          bRet = bPostClientMessage(pMsg, pos->second._hQueueHandle);
          if (bSync && bRet) 
	        {
	          _u32ClientAckCounter++;
	        }
	      }
	      else
	      {//mark client to invalid       
          pos->second._bValid=FALSE;
	      }
	    }
   }
   ETG_TRACE_USR4(("bBroardcastMsg():: value clientAckCounter: %d",_u32ClientAckCounter));
   return bRet;
}

tBool dp_tclDatapoolMaster::bPostClientMessage(TDpPoolMsg* pMsg, OSAL_tMQueueHandle hQueueHandle) const 
{
   tBool               bSuccess = FALSE;
   tS32	s32Ret = OSAL_s32MessageQueuePost(hQueueHandle,(tCU8*)pMsg,sizeof(TDpPoolMsg), OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST);

   if(s32Ret == OSAL_OK)
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}

tBool dp_tclDatapoolMaster::bCheckProcessExist(const char* PpStrProzess,OSAL_tProcessID PtPid)
{
  tBool  VbSuccess = FALSE;
  int    ViFileHandle;
  char   VcPathProcess[OSAL_C_U32_MAX_PATHLENGTH]={0};
  char   VszPrcName[DP_MAX_LEN_NAME_PROCESS]={0};

  //check process exist 
  snprintf(VcPathProcess,OSAL_C_U32_MAX_PATHLENGTH,"/proc/%d/cmdline",(tS32)PtPid);//Bug247896: Fixes compiler warnings.
  if((ViFileHandle = open(VcPathProcess, O_RDONLY,0)) != -1)
  { //check name
    tS32 Vs32Lenght=(tS32)read(ViFileHandle,VcPathProcess,OSAL_C_U32_MAX_PATHLENGTH);
    if(Vs32Lenght>0)	
    {
      char *VcpPosFile;
      VcpPosFile=strrchr(VcPathProcess,'/');
      if(VcpPosFile!=NULL)
      {
        memset(VszPrcName,0,DP_MAX_LEN_NAME_PROCESS);
        memmove(VszPrcName,PpStrProzess,MINIMUM((DP_MAX_LEN_NAME_PROCESS-1),strlen(PpStrProzess))); //Bug:256661-Fix for Exception: SIGSEGV
        char *VcpPosProzessName=strchr(VszPrcName,'_');
        if(VcpPosProzessName!=NULL)
        {
            VcpPosProzessName++;
            VcpPosFile++;
            //ETG_TRACE_USR1(("bCheckProcessExist():: process name %s",VcpPosProzessName));
            //ETG_TRACE_USR1(("bCheckProcessExist():: process name in file %s",VcpPosFile));         
            if(strncmp(VcpPosFile,VcpPosProzessName,strlen(VcpPosProzessName))==0)
            {
                VbSuccess=TRUE;
            }
        }
      }
    }
    close(ViFileHandle);
  } 
  if(VbSuccess==FALSE)
  {  //error memory entry
      ETG_TRACE_FATAL(("bCheckProcessExist():: Process(PID:%d,'%s' doesn't exist!!!!.",PtPid,PpStrProzess));
      ETG_TRACE_ERRMEM(("DATAPOOL_MASTER:bCheckProcessExist():: Process(PID:%d,'%s' doesn't exist!!!!.",PtPid,PpStrProzess));
  }
  return(VbSuccess);
}

//EOF
