/**
 * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        Creator of the Datapool; The creator function would be called in the attach function
 *               of the library
 * @addtogroup   Datapool main
 * @{
 */
#include <fcntl.h>	   /* For O_* constants */
#include <sys/stat.h>  /* For mode constants */
#include <semaphore.h> /* For semaphore */
#include <errno.h>
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_DPMASTER
#define DP_S_IMPORT_INTERFACE_DPPERSACCESS
#define DP_S_IMPORT_INTERFACE_DPENDUSER
#define DP_S_IMPORT_INTERFACE_DPSEM
#include "dp_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_TRACE_CLASS
#include "trcGenProj/Header/dpcreator.cpp.trc.h"
#endif

#define DP_SEM_NAME_INIT         "DP-SemInit"
#define DP_SEM_NAME_INIT_IN_SHM  "/dev/shm/sem.DP-SemInit"

dp_tclDpCreator* dp_tclDpCreator::_poInstance = NULL;

//must be called once before using DP
dp_tclDpCreator* dp_tclDpCreator::pCreateInstance() 
{
   if (_poInstance == NULL) {
      _poInstance = new dp_tclDpCreator();
   }
   return _poInstance;
}

void dp_tclDpCreator::vDestroyInstance() 
{
   if (_poInstance != NULL) 
   {	   
     delete _poInstance;
	   _poInstance=NULL;
   }
}

dp_tclDpCreator::dp_tclDpCreator() 
{
   sem_t*      VSemLockInit;      
   dp_tclDpSem VmyDpSem;
   /* protect against initializing race, the second process has to wait until this is finished*/
   /* Linux Programmer's Manual: 
      If O_CREAT is specified in oflag, then the semaphore is created if it does not
      already exist. If both O_CREAT and O_EXCL are
      specified in oflag, then an error is returned if a semaphore with the given
      name already exists.*/
   /* try to create semaphore with name;(if success semaphore's value is set to zeror)*/
   VSemLockInit = sem_open(DP_SEM_NAME_INIT, O_EXCL | O_CREAT, VmyDpSem.s32GetAccessRight(), 0);
   if(VSemLockInit != SEM_FAILED)
   { /* no error; semaphore create => first attach */    
     /*set access rights to Group "eco_pdd*/
     VmyDpSem.s32ChangeGroupAccess(DP_KIND_RES_SEM,-1,DP_SEM_NAME_INIT_IN_SHM);			
     _poPersMem = new dp_tclDpPersMemAccess();   
     /*create master*/
     _poMaster = dp_tclDatapoolMaster::pGetInstance();
     if (_poMaster != NULL) 
     {
        _poMaster->vInitInstance(_poPersMem);
     }
   }
   else
   { /* open semaphore*/
     VSemLockInit= sem_open(DP_SEM_NAME_INIT, 0);
     if(VSemLockInit != SEM_FAILED)
     { /* lock semaphore*/
        if(sem_wait(VSemLockInit)!=0)
           ETG_TRACE_ERR(("dp_tclDpEndUser(): vInitInstance(): sem_wait %d",errno));//coverity error
     }
     _poPersMem = new dp_tclDpPersMemAccess(); 
     _poMaster=NULL;
   }
   _poDpClient = dp_tclDatapool::pCreateInstance();
   if (_poDpClient != NULL) 
   {
      _poDpClient->vInitInstance(_poPersMem);
   } 
   else 
   {
      ETG_TRACE_FATAL(("dp_tclDpCreator(): COUNDN'T CREATE DATAPOOL CLIENT!!!!!."));
   }  
   #ifdef DP_FEATURE_UNDEF_ELEMENT
   /*init undef element*/
   _poDpUndef = dp_tclDpUndef::pGetInstance();
   if(_poDpUndef!=NULL) 
   {
     _poDpUndef->vInitInstance(_poPersMem);
   }
   #endif
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   /*init end user element*/
   _poDpEndUser = dp_tclDpEndUser::pGetInstance();
   if(_poDpEndUser!=NULL) 
   {
     _poDpEndUser->vInitInstance(_poPersMem);
   }
   #endif
   /* init finished, let's go! */
   if(VSemLockInit != SEM_FAILED)
   {
     sem_post(VSemLockInit);
   }
}

dp_tclDpCreator::~dp_tclDpCreator() 
{
   ETG_TRACE_USR4(("dp_tclDpCreator(): destructor"));
   if (_poDpClient)  delete _poDpClient;
   if (_poMaster)    delete _poMaster;
   if (_poPersMem)   delete _poPersMem;
   #ifdef DP_FEATURE_UNDEF_ELEMENT
   if (_poDpUndef)   delete _poDpUndef;
   #endif
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   if (_poDpEndUser) delete _poDpEndUser;
   #endif
}


//EOF
