/******************************************************************************
* FILE:         dpIfFunctions.cpp
* PROJECT:
* SW-COMPONENT: datapool
*------------------------------------------------------------------------------
*
* DESCRIPTION:
*
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                        | Modification
* 24.10.11  | CM-AI/VW32 kollai             | initial version
* 19.04.18  | Sureya Gunasekaran(RBEI/ECF2) | added raw eMMC support 
*           |                               | in DP_s32InitUndefElement
*******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//#define DP_API_IF_EXPORT
#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_DPENDUSER
#include "dp_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_TRACE_CLASS
#include "trcGenProj/Header/dpIfFunctions.cpp.trc.h"
#endif

#ifdef DP_DATAPOOL_SHARED_LIB
void __attribute__((constructor)) datapool_process_attach(void)
{
   ET_TRACE_OPEN;
   ETG_TRACE_FATAL(("[%d ms] datapool_process_attach()", OSAL_ClockGetElapsedTime()));
   (tVoid)dp_tclDpCreator::pCreateInstance();
   ETG_TRACE_FATAL(("[%d ms] datapool_process_attach() ready", OSAL_ClockGetElapsedTime()));
}
void __attribute__((destructor)) datapool_process_detach(void)
{
   ETG_TRACE_FATAL(("function call: datapool_process_detach()"));

}
DP_API_EXPORT tVoid DP_vCreateDatapool(tVoid)
{
}
#else
DP_API_EXPORT tVoid DP_vCreateDatapool(tVoid)
{
   ET_TRACE_OPEN;
   ETG_TRACE_FATAL(("[%d ms] DP_vCreateDatapool()", OSAL_ClockGetElapsedTime()));
   (tVoid)dp_tclDpCreator::pCreateInstance();
   ETG_TRACE_FATAL(("[%d ms] DP_vCreateDatapool() ready", OSAL_ClockGetElapsedTime()));
}
#endif

DP_API_EXPORT tVoid DP_vDestroyDatapool(tU32* pData)
{
   ETG_TRACE_USR4(("function call: DP_vDestroyDatapool() %p", pData));
   if (pData == NULL)
   {
      dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
      if (myDp)
      {
         myDp->bUnregisterMaster();
         myDp->bStopThreadWait();
         dp_tclDpCreator::vDestroyInstance();
      }
   }
}

DP_API_EXPORT tS32 DP_s32SetElement(tU32 u32PoolId, dp_tclBaseElement* pDpElement, tU16 u16AccessId)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   tS32 s32Ret = DP_S32_NO_ERR;
   if (myDp)
   {
      myDp->vSetTraceConfiguration();
      s32Ret = myDp->s32SetElement(u32PoolId, pDpElement, u16AccessId);
   }
   return s32Ret;
}

DP_API_EXPORT tS32 DP_s32GetElement(tU32 u32PoolId, dp_tclBaseElement* pDpElement, tU16 u16AccessId)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   tS32 s32Ret = DP_S32_NO_ERR;
   if (myDp)
   {
      myDp->vSetTraceConfiguration();
      s32Ret = myDp->s32GetElement(u32PoolId, pDpElement, u16AccessId);
   }
   return s32Ret;
}

DP_API_EXPORT tBool DP_bReloadPool(tU32 u32PoolId)
{
   tBool bRet = FALSE;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();

   if (myDp)
   {
      bRet = myDp->bReloadPool(u32PoolId);
   }
   return bRet;
}

DP_API_EXPORT tBool DP_bAddNotification(tU32 u32PoolId, const tChar* strElementName, tVoid* pvCallback, tU32 u32Event, tU16 u16AccessId)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   tBool bRet = FALSE;
   if (myDp)
   {
      bRet = myDp->bAddNotification(u32PoolId, strElementName, pvCallback, u32Event, u16AccessId);
   }
   return bRet;
}

DP_API_EXPORT tBool DP_bRemoveNotification(tU32 u32PoolId, const tChar* strElementName, tVoid* pvCallback, tU32 u32Event, tU16 u16AccessId)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   tBool bRet = FALSE;
   if (myDp)
   {
      myDp->vRemoveNotification(u32PoolId, strElementName, pvCallback, u32Event, u16AccessId);
      bRet = TRUE;
   }
   return bRet;
}

DP_API_EXPORT tVoid DP_vTracePoolElement(tU32 u32PoolId)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      myDp->vTracePool(u32PoolId);
   }
   return;
}

DP_API_EXPORT tVoid DP_vTracePoolElementByName(const tChar* pcName)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      myDp->vTraceElementByName(pcName);
   }
   return;
}

DP_API_EXPORT tVoid DP_vEnableElementForTrace(const tChar* pcName)
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      myDp->vEnableElementForTrace(pcName);
   }
   return;
}

DP_API_EXPORT tVoid DP_vTracePoolHistory()
{
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      myDp->vHistoryTrace();
   }
   return;
}

DP_API_EXPORT tS32 DP_s32StoreNow(tU32 u32AccessId, tU32 u32Timeout)
{
   tS32 sRet = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      sRet = myDp->s32StoreNowSync(u32AccessId, u32Timeout);
   }
   return sRet;
}

DP_API_EXPORT tS32 DP_s32SetDefault(tU32 u32AccessId, tU32 u32DefType, tU32 u32Timeout)
{
   tS32 sRet = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      myDp->vSetTraceConfiguration();
      sRet = myDp->s32SetDefault(u32AccessId, u32DefType, 0, u32Timeout);
   }
   return sRet;
}

DP_API_EXPORT tS32  DP_s32SetConfig(tU32 u32PoolId, tU32 u32AccessId, tU32 u32Timeout)
{
   tS32 sRet = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      sRet = myDp->s32SetConfig(u32PoolId, u32AccessId, u32Timeout);
   }
   return sRet;
}

DP_API_EXPORT tS32 DP_s32Lock(tU32 u32AccessId, tU32 u32LockType, tU32 u32Timeout)
{
   tS32 sRet = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      sRet = myDp->s32Lock(u32AccessId, u32LockType, u32Timeout);
   }
   return sRet;
}

DP_API_EXPORT tS32 DP_s32Unlock(tU32 u32AccessId, tU32 u32Timeout)
{
   tS32 sRet = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp) {
      sRet = myDp->s32Unlock(u32AccessId, u32Timeout);
   }
   return sRet;
}

DP_API_EXPORT tS32 DP_s32CalcHash(tU32* pu32Data, tU32 u32DataLen, tU32 u32AccessId, tU32 u32Timeout)
{
   tS32 sRet = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp) {
      sRet = myDp->s32CalcHash(pu32Data, u32DataLen, u32AccessId, u32Timeout);
   }
   return sRet;
}

//store pool now
DP_API_EXPORT tS32 DP_s32StorePoolNow(tU32 u32PoolId, tU32 u32AccessId)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
   dp_tclDatapool* myDp = dp_tclDatapool::pGetInstance();
   if (myDp)
   {
      Vs32Ret = myDp->s32StorePoolNow(u32PoolId, u32AccessId);
   }
   return Vs32Ret;
}
// ****************************************************************************
// ********   for undefined element
// ****************************************************************************
DP_API_EXPORT tS32  DP_s32InitUndefElement(const tChar* cUserName, const tChar* cPoolName, eDpLocation peLocation, dp_tclBaseElement* pDpElement)
{
#ifdef DP_FEATURE_UNDEF_ELEMENT
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
   /*check parameter*/
   if ((cUserName == NULL) || (cPoolName == NULL) || (pDpElement == NULL) || (peLocation == eDpLocation_RAW_NOR) || (peLocation == eDpLocation_V850) || (peLocation == eDpLocation_PDD_KERNEL) || (peLocation == eDpLocation_RAW_EMMC))
   {
      Vs32Ret = DP_S32_ERR_WRONG_PARAM;
   }
   else
   {
      dp_tclDatapool*     VpoMyDpUndef = dp_tclDatapool::pGetInstance();
      if (VpoMyDpUndef)
      {
         Vs32Ret = VpoMyDpUndef->s32InitUndefElement(cUserName, cPoolName, peLocation, pDpElement);
      }
   }
   return(Vs32Ret);
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cUserName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cPoolName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(peLocation);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pDpElement);
   return(DP_S32_ERR_NOT_SUPPORTED);
#endif
}

DP_API_EXPORT tS32  DP_s32SetUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName, tU8* pu8WriteBuffer, tS32 s32Size)
{
#ifdef DP_FEATURE_UNDEF_ELEMENT
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
   /*check parameter*/
   if ((cUserName == NULL) || (cPoolName == NULL) || (pcElementName == NULL) || (pu8WriteBuffer == NULL) || (s32Size <= 0))
   {
      Vs32Ret = DP_S32_ERR_WRONG_PARAM;
   }
   else
   {
      dp_tclDatapool*     VpoMyDpUndef = dp_tclDatapool::pGetInstance();
      if (VpoMyDpUndef)
      {
         Vs32Ret = VpoMyDpUndef->s32SetUndefElement(cUserName, cPoolName, pcElementName, pu8WriteBuffer, s32Size);
      }
   }
   return(Vs32Ret);
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cUserName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cPoolName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pcElementName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pu8WriteBuffer);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(s32Size);
   return(DP_S32_ERR_NOT_SUPPORTED);
#endif
}

DP_API_EXPORT tS32  DP_s32GetUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName, tU8* pu8ReadBuffer, tS32 s32Size)
{
#ifdef DP_FEATURE_UNDEF_ELEMENT
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
   /*check parameter*/
   if ((cUserName == NULL) || (cPoolName == NULL) || (pcElementName == NULL) || (pu8ReadBuffer == NULL) || (s32Size <= 0))
   {
      Vs32Ret = DP_S32_ERR_WRONG_PARAM;
   }
   else
   {
      dp_tclDatapool*     VpoMyDpUndef = dp_tclDatapool::pGetInstance();
      if (VpoMyDpUndef)
      {
         Vs32Ret = VpoMyDpUndef->s32GetUndefElement(cUserName, cPoolName, pcElementName, pu8ReadBuffer, s32Size);
      }
   }
   return(Vs32Ret);
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cUserName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cPoolName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pcElementName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pu8ReadBuffer);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(s32Size);
   return(DP_S32_ERR_NOT_SUPPORTED);
#endif
}

DP_API_EXPORT tS32  DP_s32DeleteUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName)
{
#ifdef DP_FEATURE_UNDEF_ELEMENT
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
   /*check parameter*/
   if ((cUserName == NULL) || (cPoolName == NULL) || (pcElementName == NULL))
   {
      Vs32Ret = DP_S32_ERR_WRONG_PARAM;
   }
   else
   {
      dp_tclDatapool*     VpoMyDpUndef = dp_tclDatapool::pGetInstance();
      if (VpoMyDpUndef)
      {
         Vs32Ret = VpoMyDpUndef->s32DeleteUndefElement(cUserName, cPoolName, pcElementName);
      }
   }
   return(Vs32Ret);
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cUserName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(cPoolName);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pcElementName);
   return(DP_S32_ERR_NOT_SUPPORTED);
#endif
}

// ****************************************************************************
// ********   for end user
// ****************************************************************************
DP_API_EXPORT tS32  DP_s32SetEndUser(tU8 u8EndUser, tU16 u16AccessId)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDpEndUser*    VpoMyDpEndUser = dp_tclDpEndUser::pGetInstance();
   if (VpoMyDpEndUser)
   {
      Vs32Ret = VpoMyDpEndUser->s32SetEndUser(u8EndUser, u16AccessId);
   }
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u8EndUser);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u16AccessId);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32  DP_s32GetEndUser(tU8& u8EndUser)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDpEndUser*    VpoMyDpEndUser = dp_tclDpEndUser::pGetInstance();
   if (VpoMyDpEndUser)
   {
      Vs32Ret = VpoMyDpEndUser->s32GetEndUser(u8EndUser);
   }
#else 
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u8EndUser);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32  DP_s32CopyEndUser(tU8 u8EndUserFrom, tU8 u8EndUserTo, tU16 Pu16AccessId, tU32 Pu32Timeout)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDatapool*     VpoMyDp = dp_tclDatapool::pGetInstance();
   if (VpoMyDp)
   {
      VpoMyDp->vSetTraceConfiguration();
      Vs32Ret = VpoMyDp->s32CopyEndUser(u8EndUserFrom, u8EndUserTo, Pu16AccessId, Pu32Timeout);
   }
#else 
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u8EndUserFrom);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u8EndUserTo);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu16AccessId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu32Timeout);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32 DP_s32GetElementEndUser(tU8 Pu8EndUser, tU32 Pu32PoolId, const tChar* PcPoolName, eDpLocation PeLocation, tU32 Pu32Version, dp_tclBaseElement* PpDpElement, tU16 Pu16AccessId)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDpEndUser*    VpoMyDpEndUser = dp_tclDpEndUser::pGetInstance();
   if (VpoMyDpEndUser)
   {
      tU8 Vu8EndUser;
      Vs32Ret = VpoMyDpEndUser->s32GetEndUser(Vu8EndUser);
      /*check user*/
      if (Vu8EndUser == Pu8EndUser)
      { /*get current element*/
         Vs32Ret = DP_s32GetElement(Pu32PoolId, PpDpElement, Pu16AccessId);
      }
      else
      { /*get element from file*/
         Vs32Ret = VpoMyDpEndUser->s32GetElementFromFile(Pu8EndUser, Pu32PoolId, PcPoolName, PeLocation, Pu32Version, PpDpElement, Pu16AccessId);
      }
   }
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu8EndUser);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu32PoolId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(PeLocation);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu32Version);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(PpDpElement);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu16AccessId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(PcPoolName);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32 DP_s32LoadBankToCurrentEndUser(tU8 Pu8Bank, tU16 Pu16AccessId, tU32 Pu32Timeout)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDatapool*     VpoMyDp = dp_tclDatapool::pGetInstance();
   if (VpoMyDp)
   { // bank 0xFF invalid
      if (Pu8Bank == DP_U8_NO_BANK_ACTION)
      {
         Vs32Ret = DP_S32_ERR_WRONG_PARAM;
      }
      else
      {
         VpoMyDp->vSetTraceConfiguration();
         Vs32Ret = VpoMyDp->s32EndUserBank(Pu8Bank, Pu16AccessId, dp_tclDatapool::eDPEndUserBankLoad, Pu32Timeout);
      }
   }
#else 
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu8Bank);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu16AccessId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu32Timeout);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32 DP_s32SaveCurrentEndUserToBank(tU8 Pu8Bank, tU16 Pu16AccessId, tU32 Pu32Timeout)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDatapool*     VpoMyDp = dp_tclDatapool::pGetInstance();
   if (VpoMyDp)
   { // bank 0xFF invalid
      if (Pu8Bank == DP_U8_NO_BANK_ACTION)
      {
         Vs32Ret = DP_S32_ERR_WRONG_PARAM;
      }
      else
      {
         VpoMyDp->vSetTraceConfiguration();
         Vs32Ret = VpoMyDp->s32EndUserBank(Pu8Bank, Pu16AccessId, dp_tclDatapool::eDPEndUserBankSave, Pu32Timeout);
      }
   }
#else 
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu8Bank);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu16AccessId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu32Timeout);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32  DP_s32GetBank(tU8& Pu8Bank)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDpEndUser*    VpoMyDpEndUser = dp_tclDpEndUser::pGetInstance();
   if (VpoMyDpEndUser)
   {
      Vs32Ret = VpoMyDpEndUser->s32GetBank(Pu8Bank);
   }
#else 
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu8Bank);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32 DP_s32SetEndUserDefault(tU8 Pu8EndUser, tU16 Pu16AccessId, tU32 u32Timeout)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDatapool*     VpoMyDp = dp_tclDatapool::pGetInstance();
   if (VpoMyDp)
   { //call s32SetDefault
      VpoMyDp->vSetTraceConfiguration();
      Vs32Ret = VpoMyDp->s32SetDefault(Pu16AccessId, DP_DEFSET_END_USER, Pu8EndUser, u32Timeout);
   }
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu8EndUser);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu16AccessId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u32Timeout);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tS32 DP_s32SetBankDefault(tU8 Pu8Bank, tU16 Pu16AccessId, tU32 u32Timeout)
{
   tS32 Vs32Ret = DP_S32_ERR_UNKNOWN;
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDatapool*     VpoMyDp = dp_tclDatapool::pGetInstance();
   if (VpoMyDp)
   { // bank 0xFF invalid
      if (Pu8Bank == DP_U8_NO_BANK_ACTION)
      {
         Vs32Ret = DP_S32_ERR_WRONG_PARAM;
      }
      else
      {//call s32SetDefault
         VpoMyDp->vSetTraceConfiguration();
         Vs32Ret = VpoMyDp->s32SetDefault(Pu16AccessId, DP_DEFSET_END_USER_BANK, Pu8Bank, u32Timeout);
      }
   }
#else
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu8Bank);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Pu16AccessId);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u32Timeout);
   Vs32Ret = DP_S32_ERR_NOT_SUPPORTED;
#endif
   return(Vs32Ret);
}

DP_API_EXPORT tVoid DP_vSetPoolInitCallback(DP_tpvInitPoolCallback pInitCallback, tU32 u32PoolId)
{
   dp_tclDatapool*     VpoMyDp = dp_tclDatapool::pGetInstance();
   if (VpoMyDp)
   {
      ETG_TRACE_USR4(("DP_vSetPoolInitCallback()--> called for pool: 0x%08x", u32PoolId));
      VpoMyDp->vSetPoolInitCallback(pInitCallback, u32PoolId);
   }
}

/*only for oedt test*/
#ifdef DP_U32_POOL_ID_PDDDPTESTENDUSER
DP_API_EXPORT tVoid  DP_vEnableReloadEndUserSharedMemory(tVoid)
{
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   dp_tclDpEndUser*    VpoMyDpEndUser = dp_tclDpEndUser::pGetInstance();
   if (VpoMyDpEndUser)
   {
      VpoMyDpEndUser->vEnableReloadEndUserSharedMemory();
   }
#endif
}
#endif
//EOF
