/*****************************************************************************
* FILE:         dispvidctrl_ServiceSyncdisplayIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// dispvidctrl_tclServiceSyncdisplayIfIncludes: user specific code start
#include "I_dispvidctrl_tclEarlyIf.h"
#include "I_dispvidctrl_tclSyncHandler.h"
// dispvidctrl_tclServiceSyncdisplayIfIncludes: user specific code end

#include "dispvidctrl_ServiceSyncdisplayIf.h"
#include "I_dispvidctrl_ServiceSyncdisplay.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_SERVER_SYNCDISPLAY
#include "trcGenProj/Header/dispvidctrl_ServiceSyncdisplayIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceSyncdisplayIf::
*             dispvidctrl_tclServiceSyncdisplayIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceSyncdisplayIf::dispvidctrl_tclServiceSyncdisplayIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclServiceSyncdisplayIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf() entered."));
   _poServerRef = OSAL_NULL;

   // dispvidctrl_tclServiceSyncdisplayIfConstructor: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceSyncdisplayIf::
*             ~dispvidctrl_tclServiceSyncdisplayIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceSyncdisplayIf::~dispvidctrl_tclServiceSyncdisplayIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclServiceSyncdisplayIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // dispvidctrl_tclServiceSyncdisplayIfDestructor: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ServiceSyncdisplayIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     SYNCDISPLAY_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Idispvidctrl_tclServiceSyncdisplay*>(_cpoMain->getHandler("Idispvidctrl_tclServiceSyncdisplay"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclServiceSyncdisplayIfvGetReferences: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf::vStartCommunication() entered."));
   // dispvidctrl_tclServiceSyncdisplayIfvStartCommunication: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclServiceSyncdisplayIfvHandleMessage: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclServiceSyncdisplayIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::vTraceInfo()
{
   // dispvidctrl_tclServiceSyncdisplayIfvTraceInfo: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf::onServiceAvailable() entered."));

   // dispvidctrl_tclServiceSyncdisplayIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplayIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplayIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplayIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclServiceSyncdisplayIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfvOnServiceUnavailable: user specific code end
}


tVoid dispvidctrl_tclServiceSyncdisplayIf::onSetFirstScreenReadyMStart(tU8 T_tU8_ScreenType) {

   // onSetFirstScreenReadyMStart: user specific code start
   ETG_TRACE_FATAL(("dispvidctrl_tclServiceSyncdisplayIf::onSetFirstScreenReadyMStart() entered."));
   (tVoid) T_tU8_ScreenType;
   I_dispvidctrl_tclSyncHandler* poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
   if (poSyncHandler) { 
       poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerHmiReady, TRUE);

   }
   sendSetFirstScreenReadyMResult();
   // onSetFirstScreenReadyMStart: user specific code end
}
tVoid dispvidctrl_tclServiceSyncdisplayIf::onSetAnimationRunMStart(tU8 T_tU8_PlayRun) {

   // onSetAnimationRunMStart: user specific code start
   (tVoid) T_tU8_PlayRun;
   I_dispvidctrl_tclSyncHandler* poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
   if (poSyncHandler) { 
       poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerAnimation, TRUE);

   }
   sendSetAnimationRunMResult();
   // onSetAnimationRunMStart: user specific code end
}
tVoid dispvidctrl_tclServiceSyncdisplayIf::onSetAnimationStopMStart(tU8 T_tU8_PlayStop) {

   // onSetAnimationStopMStart: user specific code start
   (tVoid) T_tU8_PlayStop;
   // onSetAnimationStopMStart: user specific code end
}

tVoid dispvidctrl_tclServiceSyncdisplayIf::sendEarlyVideoLayerStatusStatus(syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendEarlyVideoLayerStatusStatus(eEarlyVideoLayerStatus);
}

tVoid dispvidctrl_tclServiceSyncdisplayIf::sendAnimationStatusStatus(syncdisplay_fi_tcl_e8_Animation_Status T_e8_Animation_Status) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAnimationStatusStatus(T_e8_Animation_Status);
}



tVoid dispvidctrl_tclServiceSyncdisplayIf::sendSetFirstScreenReadyMResult() {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetFirstScreenReadyMResult();
}

tVoid dispvidctrl_tclServiceSyncdisplayIf::sendSetAnimationRunMResult() {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetAnimationRunMResult();
}

tVoid dispvidctrl_tclServiceSyncdisplayIf::sendSetAnimationStopMResult() {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetAnimationStopMResult();
}





// dispvidctrl_tclServiceSyncdisplayIfdispvidctrl_ServiceSyncdisplayIf: user specific code start
// dispvidctrl_tclServiceSyncdisplayIfdispvidctrl_ServiceSyncdisplayIf: user specific code end

//EOF
