/*****************************************************************************
* FILE:         dispvidctrl_ServiceSyncdisplay.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ServiceSyncdisplay_H_
#define __dispvidctrl_ServiceSyncdisplay_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ServiceSyncdisplay.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclServiceSyncdisplay_Include: user specific code start
// dispvidctrl_tclServiceSyncdisplay_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclServiceSyncdisplayCallbackIF;

class dispvidctrl_tclServiceSyncdisplay : public Idispvidctrl_tclServiceSyncdisplay
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   dispvidctrl_tclServiceSyncdisplay(tVoid); 
   dispvidctrl_tclServiceSyncdisplay(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclServiceSyncdisplay();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclServiceSyncdisplayCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclServiceSyncdisplayDeclarations: user specific code start
   // dispvidctrl_tclServiceSyncdisplayDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclServiceSyncdisplay' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclServiceSyncdisplay& operator = (const dispvidctrl_tclServiceSyncdisplay &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "dispvidctrl_tclServiceSyncdisplay"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   dispvidctrl_tclServiceSyncdisplayCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendEarlyVideoLayerStatusStatus(syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus);
   virtual tVoid sendAnimationStatusStatus(syncdisplay_fi_tcl_e8_Animation_Status T_e8_Animation_Status);


   virtual tVoid onSetFirstScreenReadyMStart(tU8 T_tU8_ScreenType);
   virtual tVoid vHandleSetFirstScreenReadyOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetAnimationRunMStart(tU8 T_tU8_PlayRun);
   virtual tVoid vHandleSetAnimationRunOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetAnimationStopMStart(tU8 T_tU8_PlayStop);
   virtual tVoid vHandleSetAnimationStopOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendSetFirstScreenReadyMResult();
   virtual tVoid sendSetAnimationRunMResult();
   virtual tVoid sendSetAnimationStopMResult();

   virtual void vGetEarlyVideoLayerStatusMsg(syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& oStatus) {
      oStatus.eEarlyVideoLayerStatus = _tEarlyVideoLayerStatus_eEarlyVideoLayerStatus;
   }
   virtual void vGetAnimationStatusMsg(syncdisplay_mainfi_tclMsgAnimationStatusStatus& oStatus) {
      oStatus.T_e8_Animation_Status = _tAnimationStatus_T_e8_Animation_Status;
   }
   virtual void vGetSetFirstScreenReadyMsg(syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& oMethodStart) {
      oMethodStart.T_tU8_ScreenType = _tSetFirstScreenReady_T_tU8_ScreenType;
   }
   virtual void vGetSetAnimationRunMsg(syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& oMethodStart) {
      oMethodStart.T_tU8_PlayRun = _tSetAnimationRun_T_tU8_PlayRun;
   }
   virtual void vGetSetAnimationStopMsg(syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& oMethodStart) {
      oMethodStart.T_tU8_PlayStop = _tSetAnimationStop_T_tU8_PlayStop;
   }

private:
   // Add status information properties.
   syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status _tEarlyVideoLayerStatus_eEarlyVideoLayerStatus;

   syncdisplay_fi_tcl_e8_Animation_Status _tAnimationStatus_T_e8_Animation_Status;

   tU8 _tSetFirstScreenReady_T_tU8_ScreenType;
   tU8 _tSetAnimationRun_T_tU8_PlayRun;
   tU8 _tSetAnimationStop_T_tU8_PlayStop;
   tclMethodResultManager _oMemSetFirstScreenReady;
   tclMethodResultManager _oMemSetAnimationRun;
   tclMethodResultManager _oMemSetAnimationStop;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclServiceSyncdisplay) 

// dispvidctrl_tclServiceSyncdisplayDeclarationsPart2: user specific code start
// dispvidctrl_tclServiceSyncdisplayDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ServiceSyncdisplay_H_


