/*****************************************************************************
* FILE:         dispvidctrl_ServiceSyncdisplay.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// dispvidctrl_tclServiceSyncdisplayIncludes: user specific code start
#include "I_dispvidctrl_tclSyncHandler.h"
// dispvidctrl_tclServiceSyncdisplayIncludes: user specific code end

#include "dispvidctrl_ServiceSyncdisplay.h"
#include "dispvidctrl_ServiceSyncdisplayCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_SERVER_SYNCDISPLAY
#include "trcGenProj/Header/dispvidctrl_ServiceSyncdisplay.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SYNCDISPLAY_SERVICE_ID              97
#define SYNCDISPLAY_FI_MAJOR_VERSION        1
#define SYNCDISPLAY_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclServiceSyncdisplay, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SYNCDISPLAY_MAINFI_C_U16_SETFIRSTSCREENREADY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetFirstScreenReadyOpMStart)
   ON_MESSAGE_SVCDATA(SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONRUN, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetAnimationRunOpMStart)
   ON_MESSAGE_SVCDATA(SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONSTOP, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetAnimationStopOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceSyncdisplay::
*             dispvidctrl_tclServiceSyncdisplay(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceSyncdisplay::dispvidctrl_tclServiceSyncdisplay(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclServiceSyncdisplay(poMainAppl, SYNCDISPLAY_SERVICE_ID, SYNCDISPLAY_FI_MAJOR_VERSION, SYNCDISPLAY_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay() entered."));
   _poCallbackIf = OSAL_NULL;

   _tSetFirstScreenReady_T_tU8_ScreenType = 0;
   _tSetAnimationRun_T_tU8_PlayRun = 0;
   _tSetAnimationStop_T_tU8_PlayStop = 0;

   // dispvidctrl_tclServiceSyncdisplayConstructor: user specific code start
   _tEarlyVideoLayerStatus_eEarlyVideoLayerStatus.enType = syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status::FI_EN_VIDEOLAYER_ANIMATION_NOT_YET_STARTED;
   _tAnimationStatus_T_e8_Animation_Status.enType        = syncdisplay_fi_tcl_e8_Animation_Status::FI_EN_ANIMATION_NOT_YET_STARTED;
   // dispvidctrl_tclServiceSyncdisplayConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceSyncdisplay::
*             ~dispvidctrl_tclServiceSyncdisplay(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceSyncdisplay::~dispvidctrl_tclServiceSyncdisplay(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclServiceSyncdisplay() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclServiceSyncdisplayDestructor: user specific code start
   // dispvidctrl_tclServiceSyncdisplayDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ServiceSyncdisplay.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     SYNCDISPLAY_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay::vGetReferences() entered."));
   // dispvidctrl_tclServiceSyncdisplayvGetReferences: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay::vStartCommunication() entered."));
   // dispvidctrl_tclServiceSyncdisplayvStartCommunication: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclServiceSyncdisplayvHandleMessage: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclServiceSyncdisplayvHandleTraceMessage: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      EarlyVideoLayerStatus (SYNCDISPLAY_MAINFI_C_U16_EARLYVIDEOLAYERSTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AnimationStatus (SYNCDISPLAY_MAINFI_C_U16_ANIMATIONSTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetFirstScreenReady (SYNCDISPLAY_MAINFI_C_U16_SETFIRSTSCREENREADY) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetAnimationRun (SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONRUN) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetAnimationStop (SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONSTOP) -> Opcode: MethodStart, MethodResult, Error, "));

   // dispvidctrl_tclServiceSyncdisplayvTraceInfo: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclServiceSyncdisplayvOnServiceAvailable: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceSyncdisplay::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceSyncdisplay::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclServiceSyncdisplayvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclServiceSyncdisplayvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclServiceSyncdisplay
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool dispvidctrl_tclServiceSyncdisplay
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case SYNCDISPLAY_MAINFI_C_U16_EARLYVIDEOLAYERSTATUS:
      {
         syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus oStatus;

         oStatus.eEarlyVideoLayerStatus = _tEarlyVideoLayerStatus_eEarlyVideoLayerStatus;

         // CaseEarlyVideoLayerStatusStatus_Pre: user specific code start
         // CaseEarlyVideoLayerStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, SYNCDISPLAY_FI_MAJOR_VERSION);

         // CaseEarlyVideoLayerStatusStatus: user specific code start
         // CaseEarlyVideoLayerStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case SYNCDISPLAY_MAINFI_C_U16_ANIMATIONSTATUS:
      {
         syncdisplay_mainfi_tclMsgAnimationStatusStatus oStatus;

         oStatus.T_e8_Animation_Status = _tAnimationStatus_T_e8_Animation_Status;

         // CaseAnimationStatusStatus_Pre: user specific code start
         // CaseAnimationStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, SYNCDISPLAY_FI_MAJOR_VERSION);

         // CaseAnimationStatusStatus: user specific code start
         // CaseAnimationStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclServiceSyncdisplay
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool dispvidctrl_tclServiceSyncdisplay
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("dispvidctrl_tclServiceSyncdisplay:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid dispvidctrl_tclServiceSyncdisplay::sendEarlyVideoLayerStatusStatus(syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus)
{

   _tEarlyVideoLayerStatus_eEarlyVideoLayerStatus = eEarlyVideoLayerStatus;


   ETG_TRACE_USR4(("sendEarlyVideoLayerStatusStatus() called."));
   eUpdateClients(SYNCDISPLAY_MAINFI_C_U16_EARLYVIDEOLAYERSTATUS);
}
tVoid dispvidctrl_tclServiceSyncdisplay::sendAnimationStatusStatus(syncdisplay_fi_tcl_e8_Animation_Status T_e8_Animation_Status)
{

   _tAnimationStatus_T_e8_Animation_Status = T_e8_Animation_Status;


   ETG_TRACE_USR4(("sendAnimationStatusStatus() called."));
   eUpdateClients(SYNCDISPLAY_MAINFI_C_U16_ANIMATIONSTATUS);
}



tVoid dispvidctrl_tclServiceSyncdisplay::vHandleSetFirstScreenReadyOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, SYNCDISPLAY_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetFirstScreenReady_T_tU8_ScreenType = oMStart.T_tU8_ScreenType;



            // Remember that we have to send an answer to this request
            _oMemSetFirstScreenReady.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetFirstScreenReadyMStart(oMStart.T_tU8_ScreenType);
            if (_poCallbackIf) _poCallbackIf->onSetFirstScreenReadyMStart(oMStart.T_tU8_ScreenType);
            // vHandleSetFirstScreenReadyOpMStart: user specific code start
            // vHandleSetFirstScreenReadyOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetFirstScreenReadyOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceSyncdisplay::onSetFirstScreenReadyMStart(tU8 T_tU8_ScreenType) {

   // onSetFirstScreenReadyMStart: user specific code start
   (tVoid) T_tU8_ScreenType;
   I_dispvidctrl_tclSyncHandler* poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
   if (poSyncHandler) { 
       poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerHmiReady, TRUE);

   }
   // onSetFirstScreenReadyMStart: user specific code end
}
tVoid dispvidctrl_tclServiceSyncdisplay::sendSetFirstScreenReadyMResult() {
   if (_oMemSetFirstScreenReady.bIsPending() == TRUE) {
      syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult  oMResult;
      //the data content



      _oMemSetFirstScreenReady.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetFirstScreenReady.u16GetSourceAppID(), 
         _oMemSetFirstScreenReady.u16GetRegisterID(), 
         _oMemSetFirstScreenReady.u16GetCMDCounter(), 
         (tU16) SYNCDISPLAY_MAINFI_C_U16_SETFIRSTSCREENREADY, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetFirstScreenReadyMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SYNCDISPLAY_MAINFI_C_U16_SETFIRSTSCREENREADY, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceSyncdisplay::vHandleSetAnimationRunOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, SYNCDISPLAY_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetAnimationRun_T_tU8_PlayRun = oMStart.T_tU8_PlayRun;



            // Remember that we have to send an answer to this request
            _oMemSetAnimationRun.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetAnimationRunMStart(oMStart.T_tU8_PlayRun);
            if (_poCallbackIf) _poCallbackIf->onSetAnimationRunMStart(oMStart.T_tU8_PlayRun);
            // vHandleSetAnimationRunOpMStart: user specific code start
            // vHandleSetAnimationRunOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetAnimationRunOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceSyncdisplay::onSetAnimationRunMStart(tU8 T_tU8_PlayRun) {

   // onSetAnimationRunMStart: user specific code start
   (tVoid) T_tU8_PlayRun;
   // onSetAnimationRunMStart: user specific code end
}
tVoid dispvidctrl_tclServiceSyncdisplay::sendSetAnimationRunMResult() {
   if (_oMemSetAnimationRun.bIsPending() == TRUE) {
      syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult  oMResult;
      //the data content



      _oMemSetAnimationRun.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetAnimationRun.u16GetSourceAppID(), 
         _oMemSetAnimationRun.u16GetRegisterID(), 
         _oMemSetAnimationRun.u16GetCMDCounter(), 
         (tU16) SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONRUN, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetAnimationRunMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONRUN, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceSyncdisplay::vHandleSetAnimationStopOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, SYNCDISPLAY_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetAnimationStop_T_tU8_PlayStop = oMStart.T_tU8_PlayStop;



            // Remember that we have to send an answer to this request
            _oMemSetAnimationStop.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetAnimationStopMStart(oMStart.T_tU8_PlayStop);
            if (_poCallbackIf) _poCallbackIf->onSetAnimationStopMStart(oMStart.T_tU8_PlayStop);
            // vHandleSetAnimationStopOpMStart: user specific code start
            // vHandleSetAnimationStopOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetAnimationStopOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceSyncdisplay::onSetAnimationStopMStart(tU8 T_tU8_PlayStop) {

   // onSetAnimationStopMStart: user specific code start
   (tVoid) T_tU8_PlayStop;
   // onSetAnimationStopMStart: user specific code end
}
tVoid dispvidctrl_tclServiceSyncdisplay::sendSetAnimationStopMResult() {
   if (_oMemSetAnimationStop.bIsPending() == TRUE) {
      syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult  oMResult;
      //the data content



      _oMemSetAnimationStop.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetAnimationStop.u16GetSourceAppID(), 
         _oMemSetAnimationStop.u16GetRegisterID(), 
         _oMemSetAnimationStop.u16GetCMDCounter(), 
         (tU16) SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONSTOP, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetAnimationStopMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONSTOP, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// dispvidctrl_tclServiceSyncdisplaydispvidctrl_ServiceSyncdisplay: user specific code start
// dispvidctrl_tclServiceSyncdisplaydispvidctrl_ServiceSyncdisplay: user specific code end

//EOF
