/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ServiceDimmingCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __dimming_main_fi_CALLBACKIF_H_
#define __dimming_main_fi_CALLBACKIF_H_

class dispvidctrl_tclServiceDimmingCallbackIF
{
   public:
       virtual ~dispvidctrl_tclServiceDimmingCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tBool onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(tU8 DayLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(tU8 NightLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(tU8 CockpitDimmingSliderOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

       virtual tVoid onFI_VD_DIMMING_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode) = 0;
       virtual tVoid onDIM_INFO_SetDimmingModeMStart(dimming_fi_tcl_e8_DIM_Mode DimmingMode) = 0;
       virtual tVoid onDIM_INFO_SetEmulationModeMStart(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode) = 0;
       virtual tVoid onDIM_INFO_SetDimmingStateMStart(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus) = 0;
       virtual tVoid onDIM_INFO_GetDimmingStateMStart(tU8 LUN) = 0;
       virtual tVoid onDIM_INFO_SetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) = 0;
       virtual tVoid onDIM_INFO_GetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN) = 0;
       virtual tVoid onDIM_INFO_GetPWMBrightnessMStart() = 0;
       virtual tVoid onDIM_KEYB_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) = 0;
       virtual tVoid onDIM_KEYB_SetDimmingPWMMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) = 0;
       virtual tVoid onDIM_DISP_SetDriverInitalizedMStart(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized) = 0;
       virtual tVoid onDIM_DISP_SetScreenContentAvailableMStart(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable) = 0;
       virtual tVoid onDIM_DISP_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) = 0;
       virtual tVoid onDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) = 0;
       virtual tVoid onDIM_DISP_SetBrightnessLevelMStart(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel) = 0;
       virtual tVoid onDIM_DISP_SetBrightnessLevelExtendedMStart(tU8 BrightnessLevelExtended) = 0;
       virtual tVoid onDIM_DISP_SetVideoBrightnessLevelMStart(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight) = 0;
       virtual tVoid onDIM_DISP_SetContrastLevelMStart(tU8 Contrast) = 0;
       virtual tVoid onDIM_DISP_SetBlackLevelMStart(tU8 BlackLevel) = 0;
       virtual tVoid onDIM_DISP_SetYCurveLevelMStart(tU8 YCurveLevel) = 0;
       virtual tVoid onDIM_DISP_SetTintLevelMStart(tU8 TintLevel) = 0;
       virtual tVoid onDIM_DISP_SetColorLevelMStart(tU8 ColorLevel) = 0;
       virtual tVoid onDIM_DIAG_SetBrightnessInputTypeMStart(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType) = 0;
       virtual tVoid onDIM_DISP_SetCSCContrastLevelMStart(tU8 ContrastLevel) = 0;
       virtual tVoid onDIM_DISP_SetCSCBlackLevelMStart(tU8 BlackLevel) = 0;
       virtual tVoid onDIM_DISP_SetCSCGammaLevelMStart(tU8 GammaLevel) = 0;
       virtual tVoid onDIM_DISP_SetCSCSaturationLevelMStart(tU8 SaturationLevel) = 0;
       virtual tVoid onDIM_DISP_SetCSCColorLevelMStart(tU8 ColorLevel) = 0;
       virtual tVoid onDIM_SECOND_DISP_SetDispParameterMStart(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue) = 0;
       virtual tVoid onDIM_SECOND_DISP_SetDispOnOffMStart(tU8 u8DisplayState) = 0;
       virtual tVoid onDIM_SECOND_DISP_HardwareVersionMStart() = 0;
       virtual tVoid onDIM_SECOND_DISP_SoftwareVersionMStart() = 0;
       virtual tVoid onDIM_SECOND_DISP_GetALLParamMStart() = 0;
};

#endif //__dimming_main_fi_CALLBACKIF_H_


