/*****************************************************************************
* FILE:         dispvidctrl_ServiceDimming.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ServiceDimming_H_
#define __dispvidctrl_ServiceDimming_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ServiceDimming.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclServiceDimming_Include: user specific code start
#include "dispvidctrl_tclSecondDisp.h"
// dispvidctrl_tclServiceDimming_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclServiceDimmingCallbackIF;

class dispvidctrl_tclServiceDimming : public Idispvidctrl_tclServiceDimming
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   dispvidctrl_tclServiceDimming(tVoid); 
   dispvidctrl_tclServiceDimming(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclServiceDimming();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclServiceDimmingCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclServiceDimmingDeclarations: user specific code start
   // dispvidctrl_tclServiceDimmingDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclServiceDimming' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclServiceDimming& operator = (const dispvidctrl_tclServiceDimming &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "dispvidctrl_tclServiceDimming"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   dispvidctrl_tclServiceDimmingCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendDIM_INFO_CarIlluminationDataStatus(dimming_fi_tcl_e8_DIM_Status IlluminationSwitch, dimming_fi_tcl_u16_DIM_Permille IlluminationBrightness);
   virtual tVoid sendDIM_INFO_LightSensorBrightnessStatus(dimming_fi_tcl_e8_DIM_Status SensorAvail, dimming_fi_tcl_u16_DIM_Permille SensorBrightness);
   virtual tVoid sendDIM_INFO_DimmingModeStatus(dimming_fi_tcl_e8_DIM_Mode Config, dimming_fi_tcl_e8_DIM_Mode Car, dimming_fi_tcl_e8_DIM_Mode Status);
   virtual tVoid sendDIM_INFO_EmulationModeStatus(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode);
   virtual tVoid sendDIM_INFO_ITCStatus(tU16 ITC);
   virtual tVoid sendDIM_INFO_PWMBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille PWMBrightness);
   virtual tVoid sendDIM_INFO_CANBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille CANBrightness);
   virtual tVoid sendDIM_KEYB_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_KEYB_HalfclassStatus(dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_A, dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_B, tU8 ADC_CFG_A, tU8 ADC_CFG_B, tU16 ADC_A, tU16 ADC_B, tU16 PWM_HC_A, tU16 PWM_HC_B);
   virtual tVoid sendDIM_DISP_DriverInitalizedStatus(dimming_fi_tcl_e8_DIM_Status DriverInitialized);
   virtual tVoid sendDIM_DISP_ScreenContentAvailableStatus(dimming_fi_tcl_e8_DIM_Status ContentAvailable);
   virtual tVoid sendDIM_DISP_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_DISP_BacklightStatus(dimming_fi_tcl_e8_DIM_Status BacklightStatus);
   virtual tVoid sendDIM_DISP_TemperatureInfoStatus(dimming_fi_tcl_s16_DIM_Temperature PanelTemp, dimming_fi_tcl_s16_DIM_Temperature AmbientTemp, dimming_fi_tcl_e8_DIM_WarningLevel WarningLevel, tU16 CriticalLevelTimeout, tU16 CriticalLevelElapsed);
   virtual tVoid sendDIM_DISP_SizeStatus(dimming_fi_tcl_e8_DIM_DisplaySize Size);
   virtual tVoid sendDIM_DISP_BrightnessLevelStatus(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel);
   virtual tVoid sendDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature);
   virtual tVoid sendDIM_DISP_BrightnessLevelExtendedStatus(tU8 BrightnessLevelExtended);
   virtual tVoid sendDIM_DISP_VideoBrightnessLevelStatus(tU8 VideoBrightnessLevel);
   virtual tVoid sendDIM_DISP_ContrastLevelStatus(tU8 Contrast);
   virtual tVoid sendDIM_DISP_BlackLevelStatus(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_YCurveLevelStatus(tU8 YCurveLevel);
   virtual tVoid sendDIM_DISP_TintLevelStatus(tU8 TintLevel);
   virtual tVoid sendDIM_DISP_ColorLevelStatus(tU8 Color);
   virtual tVoid sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(tU8 DayLuminosityOffset);
   virtual tVoid sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(tU8 NightLuminosityOffset);
   virtual tVoid sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(tU8 CockpitDimmingSliderOffset);
   virtual tVoid sendDIM_DIAG_VariantStatus(tU8 Variant);
   virtual tVoid sendDIM_DIAG_BrightnessInputTypeStatus(dimming_fi_tcl_e8_DIM_InputConfiguration InputConfiguration);
   virtual tVoid sendDIM_DISP_CSCContrastLevelStatus(tU8 ContrastLevel);
   virtual tVoid sendDIM_DISP_CSCBlackLevelStatus(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_CSCGammaLevelStatus(tU8 GammaLevel);
   virtual tVoid sendDIM_DISP_CSCSaturationLevelStatus(tU8 SaturationLevel);
   virtual tVoid sendDIM_DISP_CSCColorLevelStatus(tU8 ColorLevel);
   virtual tVoid sendDIM_SECOND_DISP_AllDisplayParamStatus(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel);
   virtual tVoid sendDIM_SECOND_DISP_SelfDiagnosisResultStatus(tU16 u16SelfDiagResult );

   virtual tBool onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(tU8 DayLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(tU8 NightLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(tU8 CockpitDimmingSliderOffset, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid onFI_VD_DIMMING_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode);
   virtual tVoid vHandleFI_VD_DIMMING_DEFAULTOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_SetDimmingModeMStart(dimming_fi_tcl_e8_DIM_Mode DimmingMode);
   virtual tVoid vHandleDIM_INFO_SetDimmingModeOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_SetEmulationModeMStart(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode);
   virtual tVoid vHandleDIM_INFO_SetEmulationModeOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_SetDimmingStateMStart(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus);
   virtual tVoid vHandleDIM_INFO_SetDimmingStateOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_GetDimmingStateMStart(tU8 LUN);
   virtual tVoid vHandleDIM_INFO_GetDimmingStateOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_SetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid vHandleDIM_INFO_SetDimmingBrightnessOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_GetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN);
   virtual tVoid vHandleDIM_INFO_GetDimmingBrightnessOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_INFO_GetPWMBrightnessMStart();
   virtual tVoid vHandleDIM_INFO_GetPWMBrightnessOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_KEYB_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid vHandleDIM_KEYB_SetDimmingOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_KEYB_SetDimmingPWMMStart(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid vHandleDIM_KEYB_SetDimmingPWMOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetDriverInitalizedMStart(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized);
   virtual tVoid vHandleDIM_DISP_SetDriverInitalizedOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetScreenContentAvailableMStart(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable);
   virtual tVoid vHandleDIM_DISP_SetScreenContentAvailableOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid vHandleDIM_DISP_SetDimmingOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);
   virtual tVoid vHandleDIM_DISP_SwitchBacklightOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetBrightnessLevelMStart(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel);
   virtual tVoid vHandleDIM_DISP_SetBrightnessLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetBrightnessLevelExtendedMStart(tU8 BrightnessLevelExtended);
   virtual tVoid vHandleDIM_DISP_SetBrightnessLevelExtendedOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetVideoBrightnessLevelMStart(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight);
   virtual tVoid vHandleDIM_DISP_SetVideoBrightnessLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetContrastLevelMStart(tU8 Contrast);
   virtual tVoid vHandleDIM_DISP_SetContrastLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetBlackLevelMStart(tU8 BlackLevel);
   virtual tVoid vHandleDIM_DISP_SetBlackLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetYCurveLevelMStart(tU8 YCurveLevel);
   virtual tVoid vHandleDIM_DISP_SetYCurveLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetTintLevelMStart(tU8 TintLevel);
   virtual tVoid vHandleDIM_DISP_SetTintLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetColorLevelMStart(tU8 ColorLevel);
   virtual tVoid vHandleDIM_DISP_SetColorLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DIAG_SetBrightnessInputTypeMStart(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType);
   virtual tVoid vHandleDIM_DIAG_SetBrightnessInputTypeOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetCSCContrastLevelMStart(tU8 ContrastLevel);
   virtual tVoid vHandleDIM_DISP_SetCSCContrastLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetCSCBlackLevelMStart(tU8 BlackLevel);
   virtual tVoid vHandleDIM_DISP_SetCSCBlackLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetCSCGammaLevelMStart(tU8 GammaLevel);
   virtual tVoid vHandleDIM_DISP_SetCSCGammaLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetCSCSaturationLevelMStart(tU8 SaturationLevel);
   virtual tVoid vHandleDIM_DISP_SetCSCSaturationLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_DISP_SetCSCColorLevelMStart(tU8 ColorLevel);
   virtual tVoid vHandleDIM_DISP_SetCSCColorLevelOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_SECOND_DISP_SetDispParameterMStart(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue);
   virtual tVoid vHandleDIM_SECOND_DISP_SetDispParameterOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_SECOND_DISP_SetDispOnOffMStart(tU8 u8DisplayState);
   virtual tVoid vHandleDIM_SECOND_DISP_SetDispOnOffOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_SECOND_DISP_HardwareVersionMStart();
   virtual tVoid vHandleDIM_SECOND_DISP_HardwareVersionOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_SECOND_DISP_SoftwareVersionMStart();
   virtual tVoid vHandleDIM_SECOND_DISP_SoftwareVersionOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onDIM_SECOND_DISP_GetALLParamMStart();
   virtual tVoid vHandleDIM_SECOND_DISP_GetALLParamOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendFI_VD_DIMMING_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus);
   virtual tVoid sendDIM_INFO_SetDimmingModeMResult(dimming_fi_tcl_e8_DIM_Mode DimmingMode);
   virtual tVoid sendDIM_INFO_SetEmulationModeMResult(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode);
   virtual tVoid sendDIM_INFO_SetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus);
   virtual tVoid sendDIM_INFO_GetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingState);
   virtual tVoid sendDIM_INFO_SetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_INFO_GetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_INFO_GetPWMBrightnessMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_KEYB_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_KEYB_SetDimmingPWMMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_DISP_SetDriverInitalizedMResult(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized);
   virtual tVoid sendDIM_DISP_SetScreenContentAvailableMResult(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable);
   virtual tVoid sendDIM_DISP_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);
   virtual tVoid sendDIM_DISP_SetBrightnessLevelMResult(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel);
   virtual tVoid sendDIM_DISP_SetBrightnessLevelExtendedMResult(tU8 BrightnessLevelExtended);
   virtual tVoid sendDIM_DISP_SetVideoBrightnessLevelMResult(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight);
   virtual tVoid sendDIM_DISP_SetContrastLevelMResult(tU8 BrightnessLevelExtended);
   virtual tVoid sendDIM_DISP_SetBlackLevelMResult(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_SetYCurveLevelMResult(tU8 YCurveLevel);
   virtual tVoid sendDIM_DISP_SetTintLevelMResult(tU8 TintLevel);
   virtual tVoid sendDIM_DISP_SetColorLevelMResult(tU8 ColorLevel);
   virtual tVoid sendDIM_DIAG_SetBrightnessInputTypeMResult(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType);
   virtual tVoid sendDIM_DISP_SetCSCContrastLevelMResult(tU8 ContrastLevel);
   virtual tVoid sendDIM_DISP_SetCSCBlackLevelMResult(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_SetCSCGammaLevelMResult(tU8 GammaLevel);
   virtual tVoid sendDIM_DISP_SetCSCSaturationLevelMResult(tU8 SaturationLevel);
   virtual tVoid sendDIM_DISP_SetCSCColorLevelMResult(tU8 ColorLevel);
   virtual tVoid sendDIM_SECOND_DISP_SetDispParameterMResult(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue);
   virtual tVoid sendDIM_SECOND_DISP_SetDispOnOffMResult(tU8 u8DisplayState);
   virtual tVoid sendDIM_SECOND_DISP_HardwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo HW_VersionInfo);
   virtual tVoid sendDIM_SECOND_DISP_SoftwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo SW_VersionInfo);
   virtual tVoid sendDIM_SECOND_DISP_GetALLParamMResult();

   virtual void vGetDIM_INFO_CarIlluminationDataMsg(dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& oStatus) {
      oStatus.IlluminationSwitch = _tDIM_INFO_CarIlluminationData_IlluminationSwitch;
      oStatus.IlluminationBrightness = _tDIM_INFO_CarIlluminationData_IlluminationBrightness;
   }
   virtual void vGetDIM_INFO_LightSensorBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& oStatus) {
      oStatus.SensorAvail = _tDIM_INFO_LightSensorBrightness_SensorAvail;
      oStatus.SensorBrightness = _tDIM_INFO_LightSensorBrightness_SensorBrightness;
   }
   virtual void vGetDIM_INFO_DimmingModeMsg(dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& oStatus) {
      oStatus.Config = _tDIM_INFO_DimmingMode_Config;
      oStatus.Car = _tDIM_INFO_DimmingMode_Car;
      oStatus.Status = _tDIM_INFO_DimmingMode_Status;
   }
   virtual void vGetDIM_INFO_EmulationModeMsg(dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& oStatus) {
      oStatus.EmulationMode = _tDIM_INFO_EmulationMode_EmulationMode;
   }
   virtual void vGetDIM_INFO_ITCMsg(dimming_mainfi_tclMsgDIM_INFO_ITCStatus& oStatus) {
      oStatus.ITC = _tDIM_INFO_ITC_ITC;
   }
   virtual void vGetDIM_INFO_PWMBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& oStatus) {
      oStatus.PWMBrightness = _tDIM_INFO_PWMBrightness_PWMBrightness;
   }
   virtual void vGetDIM_INFO_CANBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& oStatus) {
      oStatus.CANBrightness = _tDIM_INFO_CANBrightness_CANBrightness;
   }
   virtual void vGetDIM_KEYB_BrightnessMsg(dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& oStatus) {
      oStatus.Brightness = _tDIM_KEYB_Brightness_Brightness;
   }
   virtual void vGetDIM_KEYB_HalfclassMsg(dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& oStatus) {
      oStatus.Halfclass_A = _tDIM_KEYB_Halfclass_Halfclass_A;
      oStatus.Halfclass_B = _tDIM_KEYB_Halfclass_Halfclass_B;
      oStatus.ADC_CFG_A = _tDIM_KEYB_Halfclass_ADC_CFG_A;
      oStatus.ADC_CFG_B = _tDIM_KEYB_Halfclass_ADC_CFG_B;
      oStatus.ADC_A = _tDIM_KEYB_Halfclass_ADC_A;
      oStatus.ADC_B = _tDIM_KEYB_Halfclass_ADC_B;
      oStatus.PWM_HC_A = _tDIM_KEYB_Halfclass_PWM_HC_A;
      oStatus.PWM_HC_B = _tDIM_KEYB_Halfclass_PWM_HC_B;
   }
   virtual void vGetDIM_DISP_DriverInitalizedMsg(dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& oStatus) {
      oStatus.DriverInitialized = _tDIM_DISP_DriverInitalized_DriverInitialized;
   }
   virtual void vGetDIM_DISP_ScreenContentAvailableMsg(dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& oStatus) {
      oStatus.ContentAvailable = _tDIM_DISP_ScreenContentAvailable_ContentAvailable;
   }
   virtual void vGetDIM_DISP_BrightnessMsg(dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& oStatus) {
      oStatus.Brightness = _tDIM_DISP_Brightness_Brightness;
   }
   virtual void vGetDIM_DISP_BacklightMsg(dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& oStatus) {
      oStatus.BacklightStatus = _tDIM_DISP_Backlight_BacklightStatus;
   }
   virtual void vGetDIM_DISP_TemperatureInfoMsg(dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& oStatus) {
      oStatus.PanelTemp = _tDIM_DISP_TemperatureInfo_PanelTemp;
      oStatus.AmbientTemp = _tDIM_DISP_TemperatureInfo_AmbientTemp;
      oStatus.WarningLevel = _tDIM_DISP_TemperatureInfo_WarningLevel;
      oStatus.CriticalLevelTimeout = _tDIM_DISP_TemperatureInfo_CriticalLevelTimeout;
      oStatus.CriticalLevelElapsed = _tDIM_DISP_TemperatureInfo_CriticalLevelElapsed;
   }
   virtual void vGetDIM_DISP_SizeMsg(dimming_mainfi_tclMsgDIM_DISP_SizeStatus& oStatus) {
      oStatus.Size = _tDIM_DISP_Size_Size;
   }
   virtual void vGetDIM_DISP_BrightnessLevelMsg(dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& oStatus) {
      oStatus.BrightnessLevel = _tDIM_DISP_BrightnessLevel_BrightnessLevel;
   }
   virtual void vGetDIM_DISP_PanelTemperatureMsg(dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& oStatus) {
      oStatus.Temperature = _tDIM_DISP_PanelTemperature_Temperature;
   }
   virtual void vGetDIM_DISP_BrightnessLevelExtendedMsg(dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& oStatus) {
      oStatus.BrightnessLevelExtended = _tDIM_DISP_BrightnessLevelExtended_BrightnessLevelExtended;
   }
   virtual void vGetDIM_DISP_VideoBrightnessLevelMsg(dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& oStatus) {
      oStatus.VideoBrightnessLevel = _tDIM_DISP_VideoBrightnessLevel_VideoBrightnessLevel;
   }
   virtual void vGetDIM_DISP_ContrastLevelMsg(dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& oStatus) {
      oStatus.Contrast = _tDIM_DISP_ContrastLevel_Contrast;
   }
   virtual void vGetDIM_DISP_BlackLevelMsg(dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& oStatus) {
      oStatus.BlackLevel = _tDIM_DISP_BlackLevel_BlackLevel;
   }
   virtual void vGetDIM_DISP_YCurveLevelMsg(dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& oStatus) {
      oStatus.YCurveLevel = _tDIM_DISP_YCurveLevel_YCurveLevel;
   }
   virtual void vGetDIM_DISP_TintLevelMsg(dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& oStatus) {
      oStatus.TintLevel = _tDIM_DISP_TintLevel_TintLevel;
   }
   virtual void vGetDIM_DISP_ColorLevelMsg(dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& oStatus) {
      oStatus.Color = _tDIM_DISP_ColorLevel_Color;
   }
   virtual void vGetDIM_DISP_DAY_LUMINOSITY_OFFSETMsg(dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& oStatus) {
      oStatus.DayLuminosityOffset = _tDIM_DISP_DAY_LUMINOSITY_OFFSET_DayLuminosityOffset;
   }
   virtual void vGetDIM_DISP_NIGHT_LUMINOSITY_OFFSETMsg(dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& oStatus) {
      oStatus.NightLuminosityOffset = _tDIM_DISP_NIGHT_LUMINOSITY_OFFSET_NightLuminosityOffset;
   }
   virtual void vGetDIM_DISP_COCKPIT_SLIDER_OFFSETMsg(dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& oStatus) {
      oStatus.CockpitDimmingSliderOffset = _tDIM_DISP_COCKPIT_SLIDER_OFFSET_CockpitDimmingSliderOffset;
   }
   virtual void vGetDIM_DIAG_VariantMsg(dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& oStatus) {
      oStatus.Variant = _tDIM_DIAG_Variant_Variant;
   }
   virtual void vGetDIM_DIAG_BrightnessInputTypeMsg(dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& oStatus) {
      oStatus.InputConfiguration = _tDIM_DIAG_BrightnessInputType_InputConfiguration;
   }
   virtual void vGetDIM_DISP_CSCContrastLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& oStatus) {
      oStatus.ContrastLevel = _tDIM_DISP_CSCContrastLevel_ContrastLevel;
   }
   virtual void vGetDIM_DISP_CSCBlackLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& oStatus) {
      oStatus.BlackLevel = _tDIM_DISP_CSCBlackLevel_BlackLevel;
   }
   virtual void vGetDIM_DISP_CSCGammaLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& oStatus) {
      oStatus.GammaLevel = _tDIM_DISP_CSCGammaLevel_GammaLevel;
   }
   virtual void vGetDIM_DISP_CSCSaturationLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& oStatus) {
      oStatus.SaturationLevel = _tDIM_DISP_CSCSaturationLevel_SaturationLevel;
   }
   virtual void vGetDIM_DISP_CSCColorLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& oStatus) {
      oStatus.ColorLevel = _tDIM_DISP_CSCColorLevel_ColorLevel;
   }
   virtual void vGetDIM_SECOND_DISP_AllDisplayParamMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& oStatus) {
      oStatus.u8BlackLevel = _tDIM_SECOND_DISP_AllDisplayParam_u8BlackLevel;
      oStatus.u8Brightness = _tDIM_SECOND_DISP_AllDisplayParam_u8Brightness;
      oStatus.u8Color = _tDIM_SECOND_DISP_AllDisplayParam_u8Color;
      oStatus.u8Contrast = _tDIM_SECOND_DISP_AllDisplayParam_u8Contrast;
      oStatus.u8Tint = _tDIM_SECOND_DISP_AllDisplayParam_u8Tint;
      oStatus.u8GammaLevel = _tDIM_SECOND_DISP_AllDisplayParam_u8GammaLevel;
   }
   virtual void vGetDIM_SECOND_DISP_SelfDiagnosisResultMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& oStatus) {
      oStatus.u16SelfDiagResult  = _tDIM_SECOND_DISP_SelfDiagnosisResult_u16SelfDiagResult ;
   }
   virtual void vGetFI_VD_DIMMING_DEFAULTMsg(dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& oMethodStart) {
      oMethodStart.DefaultSettingsGroup = _tFI_VD_DIMMING_DEFAULT_DefaultSettingsGroup;
      oMethodStart.DefaultSettingsMode = _tFI_VD_DIMMING_DEFAULT_DefaultSettingsMode;
   }
   virtual void vGetDIM_INFO_SetDimmingModeMsg(dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& oMethodStart) {
      oMethodStart.DimmingMode = _tDIM_INFO_SetDimmingMode_DimmingMode;
   }
   virtual void vGetDIM_INFO_SetEmulationModeMsg(dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& oMethodStart) {
      oMethodStart.EmulationMode = _tDIM_INFO_SetEmulationMode_EmulationMode;
   }
   virtual void vGetDIM_INFO_SetDimmingStateMsg(dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& oMethodStart) {
      oMethodStart.LUN = _tDIM_INFO_SetDimmingState_LUN;
      oMethodStart.DimmingStatus = _tDIM_INFO_SetDimmingState_DimmingStatus;
   }
   virtual void vGetDIM_INFO_GetDimmingStateMsg(dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& oMethodStart) {
      oMethodStart.LUN = _tDIM_INFO_GetDimmingState_LUN;
   }
   virtual void vGetDIM_INFO_SetDimmingBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& oMethodStart) {
      oMethodStart.LUN = _tDIM_INFO_SetDimmingBrightness_LUN;
      oMethodStart.Brightness = _tDIM_INFO_SetDimmingBrightness_Brightness;
   }
   virtual void vGetDIM_INFO_GetDimmingBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& oMethodStart) {
      oMethodStart.LUN = _tDIM_INFO_GetDimmingBrightness_LUN;
   }
   virtual void vGetDIM_INFO_GetPWMBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetDIM_KEYB_SetDimmingMsg(dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& oMethodStart) {
      oMethodStart.Brightness = _tDIM_KEYB_SetDimming_Brightness;
   }
   virtual void vGetDIM_KEYB_SetDimmingPWMMsg(dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& oMethodStart) {
      oMethodStart.Brightness = _tDIM_KEYB_SetDimmingPWM_Brightness;
   }
   virtual void vGetDIM_DISP_SetDriverInitalizedMsg(dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& oMethodStart) {
      oMethodStart.SetDriverInitialized = _tDIM_DISP_SetDriverInitalized_SetDriverInitialized;
   }
   virtual void vGetDIM_DISP_SetScreenContentAvailableMsg(dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& oMethodStart) {
      oMethodStart.SetScreenContentAvailable = _tDIM_DISP_SetScreenContentAvailable_SetScreenContentAvailable;
   }
   virtual void vGetDIM_DISP_SetDimmingMsg(dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& oMethodStart) {
      oMethodStart.Brightness = _tDIM_DISP_SetDimming_Brightness;
   }
   virtual void vGetDIM_DISP_SwitchBacklightMsg(dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& oMethodStart) {
      oMethodStart.SwitchBacklight = _tDIM_DISP_SwitchBacklight_SwitchBacklight;
   }
   virtual void vGetDIM_DISP_SetBrightnessLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& oMethodStart) {
      oMethodStart.BrightnessLevel = _tDIM_DISP_SetBrightnessLevel_BrightnessLevel;
   }
   virtual void vGetDIM_DISP_SetBrightnessLevelExtendedMsg(dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& oMethodStart) {
      oMethodStart.BrightnessLevelExtended = _tDIM_DISP_SetBrightnessLevelExtended_BrightnessLevelExtended;
   }
   virtual void vGetDIM_DISP_SetVideoBrightnessLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& oMethodStart) {
      oMethodStart.VideoBrightnessLevelDay = _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelDay;
      oMethodStart.VideoBrightnessLevelNight = _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelNight;
   }
   virtual void vGetDIM_DISP_SetContrastLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& oMethodStart) {
      oMethodStart.Contrast = _tDIM_DISP_SetContrastLevel_Contrast;
   }
   virtual void vGetDIM_DISP_SetBlackLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& oMethodStart) {
      oMethodStart.BlackLevel = _tDIM_DISP_SetBlackLevel_BlackLevel;
   }
   virtual void vGetDIM_DISP_SetYCurveLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& oMethodStart) {
      oMethodStart.YCurveLevel = _tDIM_DISP_SetYCurveLevel_YCurveLevel;
   }
   virtual void vGetDIM_DISP_SetTintLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& oMethodStart) {
      oMethodStart.TintLevel = _tDIM_DISP_SetTintLevel_TintLevel;
   }
   virtual void vGetDIM_DISP_SetColorLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& oMethodStart) {
      oMethodStart.ColorLevel = _tDIM_DISP_SetColorLevel_ColorLevel;
   }
   virtual void vGetDIM_DIAG_SetBrightnessInputTypeMsg(dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& oMethodStart) {
      oMethodStart.SetBrightnessInputType = _tDIM_DIAG_SetBrightnessInputType_SetBrightnessInputType;
   }
   virtual void vGetDIM_DISP_SetCSCContrastLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& oMethodStart) {
      oMethodStart.ContrastLevel = _tDIM_DISP_SetCSCContrastLevel_ContrastLevel;
   }
   virtual void vGetDIM_DISP_SetCSCBlackLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& oMethodStart) {
      oMethodStart.BlackLevel = _tDIM_DISP_SetCSCBlackLevel_BlackLevel;
   }
   virtual void vGetDIM_DISP_SetCSCGammaLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& oMethodStart) {
      oMethodStart.GammaLevel = _tDIM_DISP_SetCSCGammaLevel_GammaLevel;
   }
   virtual void vGetDIM_DISP_SetCSCSaturationLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& oMethodStart) {
      oMethodStart.SaturationLevel = _tDIM_DISP_SetCSCSaturationLevel_SaturationLevel;
   }
   virtual void vGetDIM_DISP_SetCSCColorLevelMsg(dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& oMethodStart) {
      oMethodStart.ColorLevel = _tDIM_DISP_SetCSCColorLevel_ColorLevel;
   }
   virtual void vGetDIM_SECOND_DISP_SetDispParameterMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& oMethodStart) {
      oMethodStart.e16FunctionId = _tDIM_SECOND_DISP_SetDispParameter_e16FunctionId;
      oMethodStart.u16ParameterValue = _tDIM_SECOND_DISP_SetDispParameter_u16ParameterValue;
   }
   virtual void vGetDIM_SECOND_DISP_SetDispOnOffMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& oMethodStart) {
      oMethodStart.u8DisplayState = _tDIM_SECOND_DISP_SetDispOnOff_u8DisplayState;
   }
   virtual void vGetDIM_SECOND_DISP_HardwareVersionMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetDIM_SECOND_DISP_SoftwareVersionMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetDIM_SECOND_DISP_GetALLParamMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }

private:
   // Add status information properties.
   dimming_fi_tcl_e8_DIM_Status _tDIM_INFO_CarIlluminationData_IlluminationSwitch;

   dimming_fi_tcl_u16_DIM_Permille _tDIM_INFO_CarIlluminationData_IlluminationBrightness;

   dimming_fi_tcl_e8_DIM_Status _tDIM_INFO_LightSensorBrightness_SensorAvail;

   dimming_fi_tcl_u16_DIM_Permille _tDIM_INFO_LightSensorBrightness_SensorBrightness;

   dimming_fi_tcl_e8_DIM_Mode _tDIM_INFO_DimmingMode_Config;

   dimming_fi_tcl_e8_DIM_Mode _tDIM_INFO_DimmingMode_Car;

   dimming_fi_tcl_e8_DIM_Mode _tDIM_INFO_DimmingMode_Status;

   dimming_fi_tcl_e8_DIM_EmulationMode _tDIM_INFO_EmulationMode_EmulationMode;

   tU16 _tDIM_INFO_ITC_ITC;

   dimming_fi_tcl_u16_DIM_Permille _tDIM_INFO_PWMBrightness_PWMBrightness;

   dimming_fi_tcl_u16_DIM_Permille _tDIM_INFO_CANBrightness_CANBrightness;

   dimming_fi_tcl_u16_DIM_Permille _tDIM_KEYB_Brightness_Brightness;

   dimming_fi_tcl_u8_DIM_Halfclasses _tDIM_KEYB_Halfclass_Halfclass_A;

   dimming_fi_tcl_u8_DIM_Halfclasses _tDIM_KEYB_Halfclass_Halfclass_B;

   tU8 _tDIM_KEYB_Halfclass_ADC_CFG_A;

   tU8 _tDIM_KEYB_Halfclass_ADC_CFG_B;

   tU16 _tDIM_KEYB_Halfclass_ADC_A;

   tU16 _tDIM_KEYB_Halfclass_ADC_B;

   tU16 _tDIM_KEYB_Halfclass_PWM_HC_A;

   tU16 _tDIM_KEYB_Halfclass_PWM_HC_B;

   dimming_fi_tcl_e8_DIM_Status _tDIM_DISP_DriverInitalized_DriverInitialized;

   dimming_fi_tcl_e8_DIM_Status _tDIM_DISP_ScreenContentAvailable_ContentAvailable;

   dimming_fi_tcl_u16_DIM_Permille _tDIM_DISP_Brightness_Brightness;

   dimming_fi_tcl_e8_DIM_Status _tDIM_DISP_Backlight_BacklightStatus;

   dimming_fi_tcl_s16_DIM_Temperature _tDIM_DISP_TemperatureInfo_PanelTemp;

   dimming_fi_tcl_s16_DIM_Temperature _tDIM_DISP_TemperatureInfo_AmbientTemp;

   dimming_fi_tcl_e8_DIM_WarningLevel _tDIM_DISP_TemperatureInfo_WarningLevel;

   tU16 _tDIM_DISP_TemperatureInfo_CriticalLevelTimeout;

   tU16 _tDIM_DISP_TemperatureInfo_CriticalLevelElapsed;

   dimming_fi_tcl_e8_DIM_DisplaySize _tDIM_DISP_Size_Size;

   dimming_fi_tcl_e8_DIM_BrightnessLevel _tDIM_DISP_BrightnessLevel_BrightnessLevel;

   dimming_fi_tcl_s16_DIM_Temperature _tDIM_DISP_PanelTemperature_Temperature;

   tU8 _tDIM_DISP_BrightnessLevelExtended_BrightnessLevelExtended;

   tU8 _tDIM_DISP_VideoBrightnessLevel_VideoBrightnessLevel;

   tU8 _tDIM_DISP_ContrastLevel_Contrast;

   tU8 _tDIM_DISP_BlackLevel_BlackLevel;

   tU8 _tDIM_DISP_YCurveLevel_YCurveLevel;

   tU8 _tDIM_DISP_TintLevel_TintLevel;

   tU8 _tDIM_DISP_ColorLevel_Color;

   tU8 _tDIM_DISP_DAY_LUMINOSITY_OFFSET_DayLuminosityOffset;

   tU8 _tDIM_DISP_NIGHT_LUMINOSITY_OFFSET_NightLuminosityOffset;

   tU8 _tDIM_DISP_COCKPIT_SLIDER_OFFSET_CockpitDimmingSliderOffset;

   tU8 _tDIM_DIAG_Variant_Variant;

   dimming_fi_tcl_e8_DIM_InputConfiguration _tDIM_DIAG_BrightnessInputType_InputConfiguration;

   tU8 _tDIM_DISP_CSCContrastLevel_ContrastLevel;

   tU8 _tDIM_DISP_CSCBlackLevel_BlackLevel;

   tU8 _tDIM_DISP_CSCGammaLevel_GammaLevel;

   tU8 _tDIM_DISP_CSCSaturationLevel_SaturationLevel;

   tU8 _tDIM_DISP_CSCColorLevel_ColorLevel;

   tU8 _tDIM_SECOND_DISP_AllDisplayParam_u8BlackLevel;

   tU8 _tDIM_SECOND_DISP_AllDisplayParam_u8Brightness;

   tU8 _tDIM_SECOND_DISP_AllDisplayParam_u8Color;

   tU8 _tDIM_SECOND_DISP_AllDisplayParam_u8Contrast;

   tU8 _tDIM_SECOND_DISP_AllDisplayParam_u8Tint;

   tU16 _tDIM_SECOND_DISP_AllDisplayParam_u8GammaLevel;

   tU16 _tDIM_SECOND_DISP_SelfDiagnosisResult_u16SelfDiagResult ;

   tU8 _tFI_VD_DIMMING_DEFAULT_DefaultSettingsGroup;
   tU8 _tFI_VD_DIMMING_DEFAULT_DefaultSettingsMode;
   dimming_fi_tcl_e8_DIM_Mode _tDIM_INFO_SetDimmingMode_DimmingMode;
   dimming_fi_tcl_e8_DIM_EmulationMode _tDIM_INFO_SetEmulationMode_EmulationMode;
   tU8 _tDIM_INFO_SetDimmingState_LUN;
   dimming_fi_tcl_e8_DIM_Status _tDIM_INFO_SetDimmingState_DimmingStatus;
   tU8 _tDIM_INFO_GetDimmingState_LUN;
   dimming_fi_tcl_u8_DIM_LUN _tDIM_INFO_SetDimmingBrightness_LUN;
   dimming_fi_tcl_u16_DIM_Permille _tDIM_INFO_SetDimmingBrightness_Brightness;
   dimming_fi_tcl_u8_DIM_LUN _tDIM_INFO_GetDimmingBrightness_LUN;
   dimming_fi_tcl_u16_DIM_Permille _tDIM_KEYB_SetDimming_Brightness;
   dimming_fi_tcl_u16_DIM_Permille _tDIM_KEYB_SetDimmingPWM_Brightness;
   dimming_fi_tcl_e8_DIM_Status _tDIM_DISP_SetDriverInitalized_SetDriverInitialized;
   dimming_fi_tcl_e8_DIM_Status _tDIM_DISP_SetScreenContentAvailable_SetScreenContentAvailable;
   dimming_fi_tcl_u16_DIM_Permille _tDIM_DISP_SetDimming_Brightness;
   dimming_fi_tcl_e8_DIM_Status _tDIM_DISP_SwitchBacklight_SwitchBacklight;
   dimming_fi_tcl_e8_DIM_BrightnessLevel _tDIM_DISP_SetBrightnessLevel_BrightnessLevel;
   tU8 _tDIM_DISP_SetBrightnessLevelExtended_BrightnessLevelExtended;
   tU8 _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelDay;
   tU8 _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelNight;
   tU8 _tDIM_DISP_SetContrastLevel_Contrast;
   tU8 _tDIM_DISP_SetBlackLevel_BlackLevel;
   tU8 _tDIM_DISP_SetYCurveLevel_YCurveLevel;
   tU8 _tDIM_DISP_SetTintLevel_TintLevel;
   tU8 _tDIM_DISP_SetColorLevel_ColorLevel;
   dimming_fi_tcl_e8_DIM_InputConfiguration _tDIM_DIAG_SetBrightnessInputType_SetBrightnessInputType;
   tU8 _tDIM_DISP_SetCSCContrastLevel_ContrastLevel;
   tU8 _tDIM_DISP_SetCSCBlackLevel_BlackLevel;
   tU8 _tDIM_DISP_SetCSCGammaLevel_GammaLevel;
   tU8 _tDIM_DISP_SetCSCSaturationLevel_SaturationLevel;
   tU8 _tDIM_DISP_SetCSCColorLevel_ColorLevel;
   dimming_fi_tcl_SecondDispFunctionID _tDIM_SECOND_DISP_SetDispParameter_e16FunctionId;
   tU16 _tDIM_SECOND_DISP_SetDispParameter_u16ParameterValue;
   tU8 _tDIM_SECOND_DISP_SetDispOnOff_u8DisplayState;
   tclMethodResultManager _oMemFI_VD_DIMMING_DEFAULT;
   tclMethodResultManager _oMemDIM_INFO_SetDimmingMode;
   tclMethodResultManager _oMemDIM_INFO_SetEmulationMode;
   tclMethodResultManager _oMemDIM_INFO_SetDimmingState;
   tclMethodResultManager _oMemDIM_INFO_GetDimmingState;
   tclMethodResultManager _oMemDIM_INFO_SetDimmingBrightness;
   tclMethodResultManager _oMemDIM_INFO_GetDimmingBrightness;
   tclMethodResultManager _oMemDIM_INFO_GetPWMBrightness;
   tclMethodResultManager _oMemDIM_KEYB_SetDimming;
   tclMethodResultManager _oMemDIM_KEYB_SetDimmingPWM;
   tclMethodResultManager _oMemDIM_DISP_SetDriverInitalized;
   tclMethodResultManager _oMemDIM_DISP_SetScreenContentAvailable;
   tclMethodResultManager _oMemDIM_DISP_SetDimming;
   tclMethodResultManager _oMemDIM_DISP_SwitchBacklight;
   tclMethodResultManager _oMemDIM_DISP_SetBrightnessLevel;
   tclMethodResultManager _oMemDIM_DISP_SetBrightnessLevelExtended;
   tclMethodResultManager _oMemDIM_DISP_SetVideoBrightnessLevel;
   tclMethodResultManager _oMemDIM_DISP_SetContrastLevel;
   tclMethodResultManager _oMemDIM_DISP_SetBlackLevel;
   tclMethodResultManager _oMemDIM_DISP_SetYCurveLevel;
   tclMethodResultManager _oMemDIM_DISP_SetTintLevel;
   tclMethodResultManager _oMemDIM_DISP_SetColorLevel;
   tclMethodResultManager _oMemDIM_DIAG_SetBrightnessInputType;
   tclMethodResultManager _oMemDIM_DISP_SetCSCContrastLevel;
   tclMethodResultManager _oMemDIM_DISP_SetCSCBlackLevel;
   tclMethodResultManager _oMemDIM_DISP_SetCSCGammaLevel;
   tclMethodResultManager _oMemDIM_DISP_SetCSCSaturationLevel;
   tclMethodResultManager _oMemDIM_DISP_SetCSCColorLevel;
   tclMethodResultManager _oMemDIM_SECOND_DISP_SetDispParameter;
   tclMethodResultManager _oMemDIM_SECOND_DISP_SetDispOnOff;
   tclMethodResultManager _oMemDIM_SECOND_DISP_HardwareVersion;
   tclMethodResultManager _oMemDIM_SECOND_DISP_SoftwareVersion;
   tclMethodResultManager _oMemDIM_SECOND_DISP_GetALLParam;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclServiceDimming) 

// dispvidctrl_tclServiceDimmingDeclarationsPart2: user specific code start
// dispvidctrl_tclServiceDimmingDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ServiceDimming_H_


