/*****************************************************************************
* FILE:         dispvidctrl_ServiceDimming.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// dispvidctrl_tclServiceDimmingIncludes: user specific code start
// dispvidctrl_tclServiceDimmingIncludes: user specific code end

#include "dispvidctrl_ServiceDimming.h"
#include "dispvidctrl_ServiceDimmingCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_SERVER_DIMMING
#include "trcGenProj/Header/dispvidctrl_ServiceDimming.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define DIMMING_SERVICE_ID              39
#define DIMMING_FI_MAJOR_VERSION        4
#define DIMMING_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclServiceDimming, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_FI_VD_DIMMING_DEFAULT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleFI_VD_DIMMING_DEFAULTOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_SetDimmingModeOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_SETEMULATIONMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_SetEmulationModeOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGSTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_SetDimmingStateOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGSTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_GetDimmingStateOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGBRIGHTNESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_SetDimmingBrightnessOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGBRIGHTNESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_GetDimmingBrightnessOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_INFO_GETPWMBRIGHTNESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_INFO_GetPWMBrightnessOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_KEYB_SetDimmingOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMINGPWM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_KEYB_SetDimmingPWMOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETDRIVERINITALIZED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetDriverInitalizedOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETSCREENCONTENTAVAILABLE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetScreenContentAvailableOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETDIMMING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetDimmingOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SwitchBacklightOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetBrightnessLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVELEXTENDED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetBrightnessLevelExtendedOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETVIDEOBRIGHTNESSLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetVideoBrightnessLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCONTRASTLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetContrastLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETBLACKLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetBlackLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETYCURVELEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetYCurveLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETTINTLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetTintLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCOLORLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetColorLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DIAG_SETBRIGHTNESSINPUTTYPE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DIAG_SetBrightnessInputTypeOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCONTRASTLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetCSCContrastLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCBLACKLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetCSCBlackLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCGAMMALEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetCSCGammaLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCSATURATIONLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetCSCSaturationLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCOLORLEVEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_DISP_SetCSCColorLevelOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPPARAMETER, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_SECOND_DISP_SetDispParameterOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPONOFF, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_SECOND_DISP_SetDispOnOffOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_HARDWAREVERSION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_SECOND_DISP_HardwareVersionOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SOFTWAREVERSION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_SECOND_DISP_SoftwareVersionOpMStart)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_GETALLPARAM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDIM_SECOND_DISP_GetALLParamOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceDimming::
*             dispvidctrl_tclServiceDimming(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceDimming::dispvidctrl_tclServiceDimming(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclServiceDimming(poMainAppl, DIMMING_SERVICE_ID, DIMMING_FI_MAJOR_VERSION, DIMMING_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming() entered."));
   _poCallbackIf = OSAL_NULL;

   _tDIM_INFO_ITC_ITC = 0;
   _tDIM_KEYB_Halfclass_ADC_CFG_A = 0;
   _tDIM_KEYB_Halfclass_ADC_CFG_B = 0;
   _tDIM_KEYB_Halfclass_ADC_A = 0;
   _tDIM_KEYB_Halfclass_ADC_B = 0;
   _tDIM_KEYB_Halfclass_PWM_HC_A = 0;
   _tDIM_KEYB_Halfclass_PWM_HC_B = 0;
   _tDIM_DISP_TemperatureInfo_CriticalLevelTimeout = 0;
   _tDIM_DISP_TemperatureInfo_CriticalLevelElapsed = 0;
   _tDIM_DISP_BrightnessLevelExtended_BrightnessLevelExtended = 0;
   _tDIM_DISP_VideoBrightnessLevel_VideoBrightnessLevel = 0;
   _tDIM_DISP_ContrastLevel_Contrast = 0;
   _tDIM_DISP_BlackLevel_BlackLevel = 0;
   _tDIM_DISP_YCurveLevel_YCurveLevel = 0;
   _tDIM_DISP_TintLevel_TintLevel = 0;
   _tDIM_DISP_ColorLevel_Color = 0;
   _tDIM_DISP_DAY_LUMINOSITY_OFFSET_DayLuminosityOffset = 0;
   _tDIM_DISP_NIGHT_LUMINOSITY_OFFSET_NightLuminosityOffset = 0;
   _tDIM_DISP_COCKPIT_SLIDER_OFFSET_CockpitDimmingSliderOffset = 0;
   _tDIM_DIAG_Variant_Variant = 0;
   _tDIM_DISP_CSCContrastLevel_ContrastLevel = 0;
   _tDIM_DISP_CSCBlackLevel_BlackLevel = 0;
   _tDIM_DISP_CSCGammaLevel_GammaLevel = 0;
   _tDIM_DISP_CSCSaturationLevel_SaturationLevel = 0;
   _tDIM_DISP_CSCColorLevel_ColorLevel = 0;
   _tDIM_SECOND_DISP_AllDisplayParam_u8BlackLevel = 0;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Brightness = 0;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Color = 0;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Contrast = 0;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Tint = 0;
   _tDIM_SECOND_DISP_AllDisplayParam_u8GammaLevel = 0;
   _tDIM_SECOND_DISP_SelfDiagnosisResult_u16SelfDiagResult  = 0;
   _tFI_VD_DIMMING_DEFAULT_DefaultSettingsGroup = 0;
   _tFI_VD_DIMMING_DEFAULT_DefaultSettingsMode = 0;
   _tDIM_INFO_SetDimmingState_LUN = 0;
   _tDIM_INFO_GetDimmingState_LUN = 0;
   _tDIM_DISP_SetBrightnessLevelExtended_BrightnessLevelExtended = 0;
   _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelDay = 0;
   _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelNight = 0;
   _tDIM_DISP_SetContrastLevel_Contrast = 0;
   _tDIM_DISP_SetBlackLevel_BlackLevel = 0;
   _tDIM_DISP_SetYCurveLevel_YCurveLevel = 0;
   _tDIM_DISP_SetTintLevel_TintLevel = 0;
   _tDIM_DISP_SetColorLevel_ColorLevel = 0;
   _tDIM_DISP_SetCSCContrastLevel_ContrastLevel = 0;
   _tDIM_DISP_SetCSCBlackLevel_BlackLevel = 0;
   _tDIM_DISP_SetCSCGammaLevel_GammaLevel = 0;
   _tDIM_DISP_SetCSCSaturationLevel_SaturationLevel = 0;
   _tDIM_DISP_SetCSCColorLevel_ColorLevel = 0;
   _tDIM_SECOND_DISP_SetDispParameter_u16ParameterValue = 0;
   _tDIM_SECOND_DISP_SetDispOnOff_u8DisplayState = 0;

   // dispvidctrl_tclServiceDimmingConstructor: user specific code start
   // dispvidctrl_tclServiceDimmingConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceDimming::
*             ~dispvidctrl_tclServiceDimming(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceDimming::~dispvidctrl_tclServiceDimming(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclServiceDimming() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclServiceDimmingDestructor: user specific code start
   // dispvidctrl_tclServiceDimmingDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ServiceDimming.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     DIMMING_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming::vGetReferences() entered."));
   // dispvidctrl_tclServiceDimmingvGetReferences: user specific code start
   // dispvidctrl_tclServiceDimmingvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming::vStartCommunication() entered."));
   // dispvidctrl_tclServiceDimmingvStartCommunication: user specific code start
   // dispvidctrl_tclServiceDimmingvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclServiceDimmingvHandleMessage: user specific code start
   // dispvidctrl_tclServiceDimmingvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclServiceDimmingvHandleTraceMessage: user specific code start
   // dispvidctrl_tclServiceDimmingvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_CarIlluminationData (DIMMING_MAINFI_C_U16_DIM_INFO_CARILLUMINATIONDATA) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_LightSensorBrightness (DIMMING_MAINFI_C_U16_DIM_INFO_LIGHTSENSORBRIGHTNESS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_DimmingMode (DIMMING_MAINFI_C_U16_DIM_INFO_DIMMINGMODE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_EmulationMode (DIMMING_MAINFI_C_U16_DIM_INFO_EMULATIONMODE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_ITC (DIMMING_MAINFI_C_U16_DIM_INFO_ITC) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_PWMBrightness (DIMMING_MAINFI_C_U16_DIM_INFO_PWMBRIGHTNESS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_INFO_CANBrightness (DIMMING_MAINFI_C_U16_DIM_INFO_CANBRIGHTNESS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_KEYB_Brightness (DIMMING_MAINFI_C_U16_DIM_KEYB_BRIGHTNESS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_KEYB_Halfclass (DIMMING_MAINFI_C_U16_DIM_KEYB_HALFCLASS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_DriverInitalized (DIMMING_MAINFI_C_U16_DIM_DISP_DRIVERINITALIZED) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_ScreenContentAvailable (DIMMING_MAINFI_C_U16_DIM_DISP_SCREENCONTENTAVAILABLE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_Brightness (DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_Backlight (DIMMING_MAINFI_C_U16_DIM_DISP_BACKLIGHT) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_TemperatureInfo (DIMMING_MAINFI_C_U16_DIM_DISP_TEMPERATUREINFO) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_Size (DIMMING_MAINFI_C_U16_DIM_DISP_SIZE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_BrightnessLevel (DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESSLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_PanelTemperature (DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_BrightnessLevelExtended (DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESSLEVELEXTENDED) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_VideoBrightnessLevel (DIMMING_MAINFI_C_U16_DIM_DISP_VIDEOBRIGHTNESSLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_ContrastLevel (DIMMING_MAINFI_C_U16_DIM_DISP_CONTRASTLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_BlackLevel (DIMMING_MAINFI_C_U16_DIM_DISP_BLACKLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_YCurveLevel (DIMMING_MAINFI_C_U16_DIM_DISP_YCURVELEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_TintLevel (DIMMING_MAINFI_C_U16_DIM_DISP_TINTLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_ColorLevel (DIMMING_MAINFI_C_U16_DIM_DISP_COLORLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_DAY_LUMINOSITY_OFFSET (DIMMING_MAINFI_C_U16_DIM_DISP_DAY_LUMINOSITY_OFFSET) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_NIGHT_LUMINOSITY_OFFSET (DIMMING_MAINFI_C_U16_DIM_DISP_NIGHT_LUMINOSITY_OFFSET) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_COCKPIT_SLIDER_OFFSET (DIMMING_MAINFI_C_U16_DIM_DISP_COCKPIT_SLIDER_OFFSET) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DIAG_Variant (DIMMING_MAINFI_C_U16_DIM_DIAG_VARIANT) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DIAG_BrightnessInputType (DIMMING_MAINFI_C_U16_DIM_DIAG_BRIGHTNESSINPUTTYPE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_CSCContrastLevel (DIMMING_MAINFI_C_U16_DIM_DISP_CSCCONTRASTLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_CSCBlackLevel (DIMMING_MAINFI_C_U16_DIM_DISP_CSCBLACKLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_CSCGammaLevel (DIMMING_MAINFI_C_U16_DIM_DISP_CSCGAMMALEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_CSCSaturationLevel (DIMMING_MAINFI_C_U16_DIM_DISP_CSCSATURATIONLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_CSCColorLevel (DIMMING_MAINFI_C_U16_DIM_DISP_CSCCOLORLEVEL) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DIM_SECOND_DISP_AllDisplayParam (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_ALLDISPLAYPARAM) -> Opcode: Get, UpReg, RelUpReg, Status, "));
   ETG_TRACE_FATAL(("Property support:      DIM_SECOND_DISP_SelfDiagnosisResult (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SELFDIAGNOSISRESULT) -> Opcode: Get, UpReg, RelUpReg, Status, "));
   ETG_TRACE_FATAL(("Method   support:      FI_VD_DIMMING_DEFAULT (DIMMING_MAINFI_C_U16_FI_VD_DIMMING_DEFAULT) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_SetDimmingMode (DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGMODE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_SetEmulationMode (DIMMING_MAINFI_C_U16_DIM_INFO_SETEMULATIONMODE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_SetDimmingState (DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGSTATE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_GetDimmingState (DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGSTATE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_SetDimmingBrightness (DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGBRIGHTNESS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_GetDimmingBrightness (DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGBRIGHTNESS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_INFO_GetPWMBrightness (DIMMING_MAINFI_C_U16_DIM_INFO_GETPWMBRIGHTNESS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_KEYB_SetDimming (DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMING) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_KEYB_SetDimmingPWM (DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMINGPWM) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetDriverInitalized (DIMMING_MAINFI_C_U16_DIM_DISP_SETDRIVERINITALIZED) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetScreenContentAvailable (DIMMING_MAINFI_C_U16_DIM_DISP_SETSCREENCONTENTAVAILABLE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetDimming (DIMMING_MAINFI_C_U16_DIM_DISP_SETDIMMING) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SwitchBacklight (DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetBrightnessLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetBrightnessLevelExtended (DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVELEXTENDED) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetVideoBrightnessLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETVIDEOBRIGHTNESSLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetContrastLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCONTRASTLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetBlackLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETBLACKLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetYCurveLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETYCURVELEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetTintLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETTINTLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetColorLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCOLORLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DIAG_SetBrightnessInputType (DIMMING_MAINFI_C_U16_DIM_DIAG_SETBRIGHTNESSINPUTTYPE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetCSCContrastLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCONTRASTLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetCSCBlackLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCBLACKLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetCSCGammaLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCGAMMALEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetCSCSaturationLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCSATURATIONLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SetCSCColorLevel (DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCOLORLEVEL) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_SECOND_DISP_SetDispParameter (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPPARAMETER) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_SECOND_DISP_SetDispOnOff (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPONOFF) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_SECOND_DISP_HardwareVersion (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_HARDWAREVERSION) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_SECOND_DISP_SoftwareVersion (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SOFTWAREVERSION) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_SECOND_DISP_GetALLParam (DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_GETALLPARAM) -> Opcode: Error, MethodResult, MethodStart, "));

   // dispvidctrl_tclServiceDimmingvTraceInfo: user specific code start
   // dispvidctrl_tclServiceDimmingvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclServiceDimmingvOnServiceAvailable: user specific code start
   // dispvidctrl_tclServiceDimmingvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimming::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimming::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclServiceDimmingvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclServiceDimmingvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclServiceDimming
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool dispvidctrl_tclServiceDimming
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case DIMMING_MAINFI_C_U16_DIM_INFO_CARILLUMINATIONDATA:
      {
         dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus oStatus;

         oStatus.IlluminationSwitch = _tDIM_INFO_CarIlluminationData_IlluminationSwitch;
         oStatus.IlluminationBrightness = _tDIM_INFO_CarIlluminationData_IlluminationBrightness;

         // CaseDIM_INFO_CarIlluminationDataStatus_Pre: user specific code start
         // CaseDIM_INFO_CarIlluminationDataStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_CarIlluminationDataStatus: user specific code start
         // CaseDIM_INFO_CarIlluminationDataStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_INFO_LIGHTSENSORBRIGHTNESS:
      {
         dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus oStatus;

         oStatus.SensorAvail = _tDIM_INFO_LightSensorBrightness_SensorAvail;
         oStatus.SensorBrightness = _tDIM_INFO_LightSensorBrightness_SensorBrightness;

         // CaseDIM_INFO_LightSensorBrightnessStatus_Pre: user specific code start
         // CaseDIM_INFO_LightSensorBrightnessStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_LightSensorBrightnessStatus: user specific code start
         // CaseDIM_INFO_LightSensorBrightnessStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_INFO_DIMMINGMODE:
      {
         dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus oStatus;

         oStatus.Config = _tDIM_INFO_DimmingMode_Config;
         oStatus.Car = _tDIM_INFO_DimmingMode_Car;
         oStatus.Status = _tDIM_INFO_DimmingMode_Status;

         // CaseDIM_INFO_DimmingModeStatus_Pre: user specific code start
         // CaseDIM_INFO_DimmingModeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_DimmingModeStatus: user specific code start
         // CaseDIM_INFO_DimmingModeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_INFO_EMULATIONMODE:
      {
         dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus oStatus;

         oStatus.EmulationMode = _tDIM_INFO_EmulationMode_EmulationMode;

         // CaseDIM_INFO_EmulationModeStatus_Pre: user specific code start
         // CaseDIM_INFO_EmulationModeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_EmulationModeStatus: user specific code start
         // CaseDIM_INFO_EmulationModeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_INFO_ITC:
      {
         dimming_mainfi_tclMsgDIM_INFO_ITCStatus oStatus;

         oStatus.ITC = _tDIM_INFO_ITC_ITC;

         // CaseDIM_INFO_ITCStatus_Pre: user specific code start
         // CaseDIM_INFO_ITCStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_ITCStatus: user specific code start
         // CaseDIM_INFO_ITCStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_INFO_PWMBRIGHTNESS:
      {
         dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus oStatus;

         oStatus.PWMBrightness = _tDIM_INFO_PWMBrightness_PWMBrightness;

         // CaseDIM_INFO_PWMBrightnessStatus_Pre: user specific code start
         // CaseDIM_INFO_PWMBrightnessStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_PWMBrightnessStatus: user specific code start
         // CaseDIM_INFO_PWMBrightnessStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_INFO_CANBRIGHTNESS:
      {
         dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus oStatus;

         oStatus.CANBrightness = _tDIM_INFO_CANBrightness_CANBrightness;

         // CaseDIM_INFO_CANBrightnessStatus_Pre: user specific code start
         // CaseDIM_INFO_CANBrightnessStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_INFO_CANBrightnessStatus: user specific code start
         // CaseDIM_INFO_CANBrightnessStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_KEYB_BRIGHTNESS:
      {
         dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus oStatus;

         oStatus.Brightness = _tDIM_KEYB_Brightness_Brightness;

         // CaseDIM_KEYB_BrightnessStatus_Pre: user specific code start
         // CaseDIM_KEYB_BrightnessStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_KEYB_BrightnessStatus: user specific code start
         // CaseDIM_KEYB_BrightnessStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_KEYB_HALFCLASS:
      {
         dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus oStatus;

         oStatus.Halfclass_A = _tDIM_KEYB_Halfclass_Halfclass_A;
         oStatus.Halfclass_B = _tDIM_KEYB_Halfclass_Halfclass_B;
         oStatus.ADC_CFG_A = _tDIM_KEYB_Halfclass_ADC_CFG_A;
         oStatus.ADC_CFG_B = _tDIM_KEYB_Halfclass_ADC_CFG_B;
         oStatus.ADC_A = _tDIM_KEYB_Halfclass_ADC_A;
         oStatus.ADC_B = _tDIM_KEYB_Halfclass_ADC_B;
         oStatus.PWM_HC_A = _tDIM_KEYB_Halfclass_PWM_HC_A;
         oStatus.PWM_HC_B = _tDIM_KEYB_Halfclass_PWM_HC_B;

         // CaseDIM_KEYB_HalfclassStatus_Pre: user specific code start
         // CaseDIM_KEYB_HalfclassStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_KEYB_HalfclassStatus: user specific code start
         // CaseDIM_KEYB_HalfclassStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_DRIVERINITALIZED:
      {
         dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus oStatus;

         oStatus.DriverInitialized = _tDIM_DISP_DriverInitalized_DriverInitialized;

         // CaseDIM_DISP_DriverInitalizedStatus_Pre: user specific code start
         // CaseDIM_DISP_DriverInitalizedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_DriverInitalizedStatus: user specific code start
         // CaseDIM_DISP_DriverInitalizedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_SCREENCONTENTAVAILABLE:
      {
         dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus oStatus;

         oStatus.ContentAvailable = _tDIM_DISP_ScreenContentAvailable_ContentAvailable;

         // CaseDIM_DISP_ScreenContentAvailableStatus_Pre: user specific code start
         // CaseDIM_DISP_ScreenContentAvailableStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_ScreenContentAvailableStatus: user specific code start
         // CaseDIM_DISP_ScreenContentAvailableStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESS:
      {
         dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus oStatus;

         oStatus.Brightness = _tDIM_DISP_Brightness_Brightness;

         // CaseDIM_DISP_BrightnessStatus_Pre: user specific code start
         // CaseDIM_DISP_BrightnessStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_BrightnessStatus: user specific code start
         // CaseDIM_DISP_BrightnessStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_BACKLIGHT:
      {
         dimming_mainfi_tclMsgDIM_DISP_BacklightStatus oStatus;

         oStatus.BacklightStatus = _tDIM_DISP_Backlight_BacklightStatus;

         // CaseDIM_DISP_BacklightStatus_Pre: user specific code start
         // CaseDIM_DISP_BacklightStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_BacklightStatus: user specific code start
         // CaseDIM_DISP_BacklightStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_TEMPERATUREINFO:
      {
         dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus oStatus;

         oStatus.PanelTemp = _tDIM_DISP_TemperatureInfo_PanelTemp;
         oStatus.AmbientTemp = _tDIM_DISP_TemperatureInfo_AmbientTemp;
         oStatus.WarningLevel = _tDIM_DISP_TemperatureInfo_WarningLevel;
         oStatus.CriticalLevelTimeout = _tDIM_DISP_TemperatureInfo_CriticalLevelTimeout;
         oStatus.CriticalLevelElapsed = _tDIM_DISP_TemperatureInfo_CriticalLevelElapsed;

         // CaseDIM_DISP_TemperatureInfoStatus_Pre: user specific code start
         // CaseDIM_DISP_TemperatureInfoStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_TemperatureInfoStatus: user specific code start
         // CaseDIM_DISP_TemperatureInfoStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_SIZE:
      {
         dimming_mainfi_tclMsgDIM_DISP_SizeStatus oStatus;

         oStatus.Size = _tDIM_DISP_Size_Size;

         // CaseDIM_DISP_SizeStatus_Pre: user specific code start
         // CaseDIM_DISP_SizeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_SizeStatus: user specific code start
         // CaseDIM_DISP_SizeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESSLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus oStatus;

         oStatus.BrightnessLevel = _tDIM_DISP_BrightnessLevel_BrightnessLevel;

         // CaseDIM_DISP_BrightnessLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_BrightnessLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_BrightnessLevelStatus: user specific code start
         // CaseDIM_DISP_BrightnessLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE:
      {
         dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus oStatus;

         oStatus.Temperature = _tDIM_DISP_PanelTemperature_Temperature;

         // CaseDIM_DISP_PanelTemperatureStatus_Pre: user specific code start
         // CaseDIM_DISP_PanelTemperatureStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_PanelTemperatureStatus: user specific code start
         // CaseDIM_DISP_PanelTemperatureStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESSLEVELEXTENDED:
      {
         dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus oStatus;

         oStatus.BrightnessLevelExtended = _tDIM_DISP_BrightnessLevelExtended_BrightnessLevelExtended;

         // CaseDIM_DISP_BrightnessLevelExtendedStatus_Pre: user specific code start
         // CaseDIM_DISP_BrightnessLevelExtendedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_BrightnessLevelExtendedStatus: user specific code start
         // CaseDIM_DISP_BrightnessLevelExtendedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_VIDEOBRIGHTNESSLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus oStatus;

         oStatus.VideoBrightnessLevel = _tDIM_DISP_VideoBrightnessLevel_VideoBrightnessLevel;

         // CaseDIM_DISP_VideoBrightnessLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_VideoBrightnessLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_VideoBrightnessLevelStatus: user specific code start
         // CaseDIM_DISP_VideoBrightnessLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_CONTRASTLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus oStatus;

         oStatus.Contrast = _tDIM_DISP_ContrastLevel_Contrast;

         // CaseDIM_DISP_ContrastLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_ContrastLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_ContrastLevelStatus: user specific code start
         // CaseDIM_DISP_ContrastLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_BLACKLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus oStatus;

         oStatus.BlackLevel = _tDIM_DISP_BlackLevel_BlackLevel;

         // CaseDIM_DISP_BlackLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_BlackLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_BlackLevelStatus: user specific code start
         // CaseDIM_DISP_BlackLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_YCURVELEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus oStatus;

         oStatus.YCurveLevel = _tDIM_DISP_YCurveLevel_YCurveLevel;

         // CaseDIM_DISP_YCurveLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_YCurveLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_YCurveLevelStatus: user specific code start
         // CaseDIM_DISP_YCurveLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_TINTLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus oStatus;

         oStatus.TintLevel = _tDIM_DISP_TintLevel_TintLevel;

         // CaseDIM_DISP_TintLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_TintLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_TintLevelStatus: user specific code start
         // CaseDIM_DISP_TintLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_COLORLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus oStatus;

         oStatus.Color = _tDIM_DISP_ColorLevel_Color;

         // CaseDIM_DISP_ColorLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_ColorLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_ColorLevelStatus: user specific code start
         // CaseDIM_DISP_ColorLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_DAY_LUMINOSITY_OFFSET:
      {
         dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus oStatus;

         oStatus.DayLuminosityOffset = _tDIM_DISP_DAY_LUMINOSITY_OFFSET_DayLuminosityOffset;

         // CaseDIM_DISP_DAY_LUMINOSITY_OFFSETStatus_Pre: user specific code start
         // CaseDIM_DISP_DAY_LUMINOSITY_OFFSETStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_DAY_LUMINOSITY_OFFSETStatus: user specific code start
         // CaseDIM_DISP_DAY_LUMINOSITY_OFFSETStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_NIGHT_LUMINOSITY_OFFSET:
      {
         dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus oStatus;

         oStatus.NightLuminosityOffset = _tDIM_DISP_NIGHT_LUMINOSITY_OFFSET_NightLuminosityOffset;

         // CaseDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus_Pre: user specific code start
         // CaseDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus: user specific code start
         // CaseDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_COCKPIT_SLIDER_OFFSET:
      {
         dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus oStatus;

         oStatus.CockpitDimmingSliderOffset = _tDIM_DISP_COCKPIT_SLIDER_OFFSET_CockpitDimmingSliderOffset;

         // CaseDIM_DISP_COCKPIT_SLIDER_OFFSETStatus_Pre: user specific code start
         // CaseDIM_DISP_COCKPIT_SLIDER_OFFSETStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_COCKPIT_SLIDER_OFFSETStatus: user specific code start
         // CaseDIM_DISP_COCKPIT_SLIDER_OFFSETStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DIAG_VARIANT:
      {
         dimming_mainfi_tclMsgDIM_DIAG_VariantStatus oStatus;

         oStatus.Variant = _tDIM_DIAG_Variant_Variant;

         // CaseDIM_DIAG_VariantStatus_Pre: user specific code start
         // CaseDIM_DIAG_VariantStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DIAG_VariantStatus: user specific code start
         // CaseDIM_DIAG_VariantStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DIAG_BRIGHTNESSINPUTTYPE:
      {
         dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus oStatus;

         oStatus.InputConfiguration = _tDIM_DIAG_BrightnessInputType_InputConfiguration;

         // CaseDIM_DIAG_BrightnessInputTypeStatus_Pre: user specific code start
         // CaseDIM_DIAG_BrightnessInputTypeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DIAG_BrightnessInputTypeStatus: user specific code start
         // CaseDIM_DIAG_BrightnessInputTypeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_CSCCONTRASTLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus oStatus;

         oStatus.ContrastLevel = _tDIM_DISP_CSCContrastLevel_ContrastLevel;

         // CaseDIM_DISP_CSCContrastLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_CSCContrastLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_CSCContrastLevelStatus: user specific code start
         // CaseDIM_DISP_CSCContrastLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_CSCBLACKLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus oStatus;

         oStatus.BlackLevel = _tDIM_DISP_CSCBlackLevel_BlackLevel;

         // CaseDIM_DISP_CSCBlackLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_CSCBlackLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_CSCBlackLevelStatus: user specific code start
         // CaseDIM_DISP_CSCBlackLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_CSCGAMMALEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus oStatus;

         oStatus.GammaLevel = _tDIM_DISP_CSCGammaLevel_GammaLevel;

         // CaseDIM_DISP_CSCGammaLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_CSCGammaLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_CSCGammaLevelStatus: user specific code start
         // CaseDIM_DISP_CSCGammaLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_CSCSATURATIONLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus oStatus;

         oStatus.SaturationLevel = _tDIM_DISP_CSCSaturationLevel_SaturationLevel;

         // CaseDIM_DISP_CSCSaturationLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_CSCSaturationLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_CSCSaturationLevelStatus: user specific code start
         // CaseDIM_DISP_CSCSaturationLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_CSCCOLORLEVEL:
      {
         dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus oStatus;

         oStatus.ColorLevel = _tDIM_DISP_CSCColorLevel_ColorLevel;

         // CaseDIM_DISP_CSCColorLevelStatus_Pre: user specific code start
         // CaseDIM_DISP_CSCColorLevelStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_DISP_CSCColorLevelStatus: user specific code start
         // CaseDIM_DISP_CSCColorLevelStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_ALLDISPLAYPARAM:
      {
         dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus oStatus;

         oStatus.u8BlackLevel = _tDIM_SECOND_DISP_AllDisplayParam_u8BlackLevel;
         oStatus.u8Brightness = _tDIM_SECOND_DISP_AllDisplayParam_u8Brightness;
         oStatus.u8Color = _tDIM_SECOND_DISP_AllDisplayParam_u8Color;
         oStatus.u8Contrast = _tDIM_SECOND_DISP_AllDisplayParam_u8Contrast;
         oStatus.u8Tint = _tDIM_SECOND_DISP_AllDisplayParam_u8Tint;
         oStatus.u8GammaLevel = _tDIM_SECOND_DISP_AllDisplayParam_u8GammaLevel;

         // CaseDIM_SECOND_DISP_AllDisplayParamStatus_Pre: user specific code start
         // CaseDIM_SECOND_DISP_AllDisplayParamStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_SECOND_DISP_AllDisplayParamStatus: user specific code start
         // CaseDIM_SECOND_DISP_AllDisplayParamStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SELFDIAGNOSISRESULT:
      {
         dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus oStatus;

         oStatus.u16SelfDiagResult  = _tDIM_SECOND_DISP_SelfDiagnosisResult_u16SelfDiagResult ;

         // CaseDIM_SECOND_DISP_SelfDiagnosisResultStatus_Pre: user specific code start

         // To get the second disp self diag result it has to be triggered from V850 first.
         dispvidctrl_tclSecondDisp* poSecondDisp = dynamic_cast<dispvidctrl_tclSecondDisp*>(dispvidctrl_tclAppMain::theServer()->getHandler("dispvidctrl_tclSecondDisp"));
         if ( poSecondDisp )
         {
             poSecondDisp -> requestV850_SelfDiagResult();
         }
         // CaseDIM_SECOND_DISP_SelfDiagnosisResultStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, DIMMING_FI_MAJOR_VERSION);

         // CaseDIM_SECOND_DISP_SelfDiagnosisResultStatus: user specific code start
         // CaseDIM_SECOND_DISP_SelfDiagnosisResultStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclServiceDimming
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool dispvidctrl_tclServiceDimming
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimming:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case DIMMING_MAINFI_C_U16_DIM_DISP_DAY_LUMINOSITY_OFFSET:
      {
         dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet oSet;

         if (oVisitorMsg.s32GetData(oSet, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(oSet.DayLuminosityOffset, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(oSet.DayLuminosityOffset, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDIM_DISP_DAY_LUMINOSITY_OFFSETSet: user specific code start
         // CaseDIM_DISP_DAY_LUMINOSITY_OFFSETSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_NIGHT_LUMINOSITY_OFFSET:
      {
         dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet oSet;

         if (oVisitorMsg.s32GetData(oSet, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(oSet.NightLuminosityOffset, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(oSet.NightLuminosityOffset, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet: user specific code start
         // CaseDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case DIMMING_MAINFI_C_U16_DIM_DISP_COCKPIT_SLIDER_OFFSET:
      {
         dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet oSet;

         if (oVisitorMsg.s32GetData(oSet, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(oSet.CockpitDimmingSliderOffset, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(oSet.CockpitDimmingSliderOffset, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDIM_DISP_COCKPIT_SLIDER_OFFSETSet: user specific code start
         // CaseDIM_DISP_COCKPIT_SLIDER_OFFSETSet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_CarIlluminationDataStatus(dimming_fi_tcl_e8_DIM_Status IlluminationSwitch, dimming_fi_tcl_u16_DIM_Permille IlluminationBrightness)
{

   _tDIM_INFO_CarIlluminationData_IlluminationSwitch = IlluminationSwitch;
   _tDIM_INFO_CarIlluminationData_IlluminationBrightness = IlluminationBrightness;


   ETG_TRACE_USR4(("sendDIM_INFO_CarIlluminationDataStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_CARILLUMINATIONDATA);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_LightSensorBrightnessStatus(dimming_fi_tcl_e8_DIM_Status SensorAvail, dimming_fi_tcl_u16_DIM_Permille SensorBrightness)
{

   _tDIM_INFO_LightSensorBrightness_SensorAvail = SensorAvail;
   _tDIM_INFO_LightSensorBrightness_SensorBrightness = SensorBrightness;


   ETG_TRACE_USR4(("sendDIM_INFO_LightSensorBrightnessStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_LIGHTSENSORBRIGHTNESS);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_DimmingModeStatus(dimming_fi_tcl_e8_DIM_Mode Config, dimming_fi_tcl_e8_DIM_Mode Car, dimming_fi_tcl_e8_DIM_Mode Status)
{

   _tDIM_INFO_DimmingMode_Config = Config;
   _tDIM_INFO_DimmingMode_Car = Car;
   _tDIM_INFO_DimmingMode_Status = Status;


   ETG_TRACE_USR4(("sendDIM_INFO_DimmingModeStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_DIMMINGMODE);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_EmulationModeStatus(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode)
{

   _tDIM_INFO_EmulationMode_EmulationMode = EmulationMode;


   ETG_TRACE_USR4(("sendDIM_INFO_EmulationModeStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_EMULATIONMODE);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_ITCStatus(tU16 ITC)
{

   _tDIM_INFO_ITC_ITC = ITC;


   ETG_TRACE_USR4(("sendDIM_INFO_ITCStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_ITC);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_PWMBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille PWMBrightness)
{

   _tDIM_INFO_PWMBrightness_PWMBrightness = PWMBrightness;


   ETG_TRACE_USR4(("sendDIM_INFO_PWMBrightnessStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_PWMBRIGHTNESS);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_CANBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille CANBrightness)
{

   _tDIM_INFO_CANBrightness_CANBrightness = CANBrightness;


   ETG_TRACE_USR4(("sendDIM_INFO_CANBrightnessStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_INFO_CANBRIGHTNESS);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_KEYB_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness)
{

   _tDIM_KEYB_Brightness_Brightness = Brightness;


   ETG_TRACE_USR4(("sendDIM_KEYB_BrightnessStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_KEYB_BRIGHTNESS);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_KEYB_HalfclassStatus(dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_A, dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_B, tU8 ADC_CFG_A, tU8 ADC_CFG_B, tU16 ADC_A, tU16 ADC_B, tU16 PWM_HC_A, tU16 PWM_HC_B)
{

   _tDIM_KEYB_Halfclass_Halfclass_A = Halfclass_A;
   _tDIM_KEYB_Halfclass_Halfclass_B = Halfclass_B;
   _tDIM_KEYB_Halfclass_ADC_CFG_A = ADC_CFG_A;
   _tDIM_KEYB_Halfclass_ADC_CFG_B = ADC_CFG_B;
   _tDIM_KEYB_Halfclass_ADC_A = ADC_A;
   _tDIM_KEYB_Halfclass_ADC_B = ADC_B;
   _tDIM_KEYB_Halfclass_PWM_HC_A = PWM_HC_A;
   _tDIM_KEYB_Halfclass_PWM_HC_B = PWM_HC_B;


   ETG_TRACE_USR4(("sendDIM_KEYB_HalfclassStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_KEYB_HALFCLASS);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_DriverInitalizedStatus(dimming_fi_tcl_e8_DIM_Status DriverInitialized)
{

   _tDIM_DISP_DriverInitalized_DriverInitialized = DriverInitialized;


   ETG_TRACE_USR4(("sendDIM_DISP_DriverInitalizedStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_DRIVERINITALIZED);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_ScreenContentAvailableStatus(dimming_fi_tcl_e8_DIM_Status ContentAvailable)
{

   _tDIM_DISP_ScreenContentAvailable_ContentAvailable = ContentAvailable;


   ETG_TRACE_USR4(("sendDIM_DISP_ScreenContentAvailableStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_SCREENCONTENTAVAILABLE);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness)
{

   _tDIM_DISP_Brightness_Brightness = Brightness;


   ETG_TRACE_USR4(("sendDIM_DISP_BrightnessStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESS);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_BacklightStatus(dimming_fi_tcl_e8_DIM_Status BacklightStatus)
{

   _tDIM_DISP_Backlight_BacklightStatus = BacklightStatus;


   ETG_TRACE_USR4(("sendDIM_DISP_BacklightStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_BACKLIGHT);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_TemperatureInfoStatus(dimming_fi_tcl_s16_DIM_Temperature PanelTemp, dimming_fi_tcl_s16_DIM_Temperature AmbientTemp, dimming_fi_tcl_e8_DIM_WarningLevel WarningLevel, tU16 CriticalLevelTimeout, tU16 CriticalLevelElapsed)
{

   _tDIM_DISP_TemperatureInfo_PanelTemp = PanelTemp;
   _tDIM_DISP_TemperatureInfo_AmbientTemp = AmbientTemp;
   _tDIM_DISP_TemperatureInfo_WarningLevel = WarningLevel;
   _tDIM_DISP_TemperatureInfo_CriticalLevelTimeout = CriticalLevelTimeout;
   _tDIM_DISP_TemperatureInfo_CriticalLevelElapsed = CriticalLevelElapsed;


   ETG_TRACE_USR4(("sendDIM_DISP_TemperatureInfoStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_TEMPERATUREINFO);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SizeStatus(dimming_fi_tcl_e8_DIM_DisplaySize Size)
{

   _tDIM_DISP_Size_Size = Size;


   ETG_TRACE_USR4(("sendDIM_DISP_SizeStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_SIZE);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_BrightnessLevelStatus(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel)
{

   _tDIM_DISP_BrightnessLevel_BrightnessLevel = BrightnessLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_BrightnessLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESSLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature)
{

   _tDIM_DISP_PanelTemperature_Temperature = Temperature;


   ETG_TRACE_USR4(("sendDIM_DISP_PanelTemperatureStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_BrightnessLevelExtendedStatus(tU8 BrightnessLevelExtended)
{

   _tDIM_DISP_BrightnessLevelExtended_BrightnessLevelExtended = BrightnessLevelExtended;


   ETG_TRACE_USR4(("sendDIM_DISP_BrightnessLevelExtendedStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_BRIGHTNESSLEVELEXTENDED);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_VideoBrightnessLevelStatus(tU8 VideoBrightnessLevel)
{

   _tDIM_DISP_VideoBrightnessLevel_VideoBrightnessLevel = VideoBrightnessLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_VideoBrightnessLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_VIDEOBRIGHTNESSLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_ContrastLevelStatus(tU8 Contrast)
{

   _tDIM_DISP_ContrastLevel_Contrast = Contrast;


   ETG_TRACE_USR4(("sendDIM_DISP_ContrastLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_CONTRASTLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_BlackLevelStatus(tU8 BlackLevel)
{

   _tDIM_DISP_BlackLevel_BlackLevel = BlackLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_BlackLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_BLACKLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_YCurveLevelStatus(tU8 YCurveLevel)
{

   _tDIM_DISP_YCurveLevel_YCurveLevel = YCurveLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_YCurveLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_YCURVELEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_TintLevelStatus(tU8 TintLevel)
{

   _tDIM_DISP_TintLevel_TintLevel = TintLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_TintLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_TINTLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_ColorLevelStatus(tU8 Color)
{

   _tDIM_DISP_ColorLevel_Color = Color;


   ETG_TRACE_USR4(("sendDIM_DISP_ColorLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_COLORLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(tU8 DayLuminosityOffset)
{

   _tDIM_DISP_DAY_LUMINOSITY_OFFSET_DayLuminosityOffset = DayLuminosityOffset;


   ETG_TRACE_USR4(("sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_DAY_LUMINOSITY_OFFSET);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(tU8 NightLuminosityOffset)
{

   _tDIM_DISP_NIGHT_LUMINOSITY_OFFSET_NightLuminosityOffset = NightLuminosityOffset;


   ETG_TRACE_USR4(("sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_NIGHT_LUMINOSITY_OFFSET);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(tU8 CockpitDimmingSliderOffset)
{

   _tDIM_DISP_COCKPIT_SLIDER_OFFSET_CockpitDimmingSliderOffset = CockpitDimmingSliderOffset;


   ETG_TRACE_USR4(("sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_COCKPIT_SLIDER_OFFSET);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DIAG_VariantStatus(tU8 Variant)
{

   _tDIM_DIAG_Variant_Variant = Variant;


   ETG_TRACE_USR4(("sendDIM_DIAG_VariantStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DIAG_VARIANT);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DIAG_BrightnessInputTypeStatus(dimming_fi_tcl_e8_DIM_InputConfiguration InputConfiguration)
{

   _tDIM_DIAG_BrightnessInputType_InputConfiguration = InputConfiguration;


   ETG_TRACE_USR4(("sendDIM_DIAG_BrightnessInputTypeStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DIAG_BRIGHTNESSINPUTTYPE);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_CSCContrastLevelStatus(tU8 ContrastLevel)
{

   _tDIM_DISP_CSCContrastLevel_ContrastLevel = ContrastLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_CSCContrastLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_CSCCONTRASTLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_CSCBlackLevelStatus(tU8 BlackLevel)
{

   _tDIM_DISP_CSCBlackLevel_BlackLevel = BlackLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_CSCBlackLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_CSCBLACKLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_CSCGammaLevelStatus(tU8 GammaLevel)
{

   _tDIM_DISP_CSCGammaLevel_GammaLevel = GammaLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_CSCGammaLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_CSCGAMMALEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_CSCSaturationLevelStatus(tU8 SaturationLevel)
{

   _tDIM_DISP_CSCSaturationLevel_SaturationLevel = SaturationLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_CSCSaturationLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_CSCSATURATIONLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_CSCColorLevelStatus(tU8 ColorLevel)
{

   _tDIM_DISP_CSCColorLevel_ColorLevel = ColorLevel;


   ETG_TRACE_USR4(("sendDIM_DISP_CSCColorLevelStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_DISP_CSCCOLORLEVEL);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_AllDisplayParamStatus(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel)
{

   _tDIM_SECOND_DISP_AllDisplayParam_u8BlackLevel = u8BlackLevel;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Brightness = u8Brightness;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Color = u8Color;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Contrast = u8Contrast;
   _tDIM_SECOND_DISP_AllDisplayParam_u8Tint = u8Tint;
   _tDIM_SECOND_DISP_AllDisplayParam_u8GammaLevel = u8GammaLevel;


   ETG_TRACE_USR4(("sendDIM_SECOND_DISP_AllDisplayParamStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_ALLDISPLAYPARAM);
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_SelfDiagnosisResultStatus(tU16 u16SelfDiagResult )
{

   _tDIM_SECOND_DISP_SelfDiagnosisResult_u16SelfDiagResult  = u16SelfDiagResult ;


   ETG_TRACE_USR4(("sendDIM_SECOND_DISP_SelfDiagnosisResultStatus() called."));
   eUpdateClients(DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SELFDIAGNOSISRESULT);
}

tBool dispvidctrl_tclServiceDimming::onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(tU8 DayLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)DayLuminosityOffset;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDIM_DISP_DAY_LUMINOSITY_OFFSETSet: user specific code start
   // onDIM_DISP_DAY_LUMINOSITY_OFFSETSet: user specific code end
   return _bResult;
}
tBool dispvidctrl_tclServiceDimming::onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(tU8 NightLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)NightLuminosityOffset;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet: user specific code start
   // onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet: user specific code end
   return _bResult;
}
tBool dispvidctrl_tclServiceDimming::onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(tU8 CockpitDimmingSliderOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)CockpitDimmingSliderOffset;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDIM_DISP_COCKPIT_SLIDER_OFFSETSet: user specific code start
   // onDIM_DISP_COCKPIT_SLIDER_OFFSETSet: user specific code end
   return _bResult;
}


tVoid dispvidctrl_tclServiceDimming::vHandleFI_VD_DIMMING_DEFAULTOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tFI_VD_DIMMING_DEFAULT_DefaultSettingsGroup = oMStart.DefaultSettingsGroup;
            _tFI_VD_DIMMING_DEFAULT_DefaultSettingsMode = oMStart.DefaultSettingsMode;



            // Remember that we have to send an answer to this request
            _oMemFI_VD_DIMMING_DEFAULT.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onFI_VD_DIMMING_DEFAULTMStart(oMStart.DefaultSettingsGroup, oMStart.DefaultSettingsMode);
            if (_poCallbackIf) _poCallbackIf->onFI_VD_DIMMING_DEFAULTMStart(oMStart.DefaultSettingsGroup, oMStart.DefaultSettingsMode);
            // vHandleFI_VD_DIMMING_DEFAULTOpMStart: user specific code start
            // vHandleFI_VD_DIMMING_DEFAULTOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleFI_VD_DIMMING_DEFAULTOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onFI_VD_DIMMING_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode) {

   // onFI_VD_DIMMING_DEFAULTMStart: user specific code start
   (tVoid) DefaultSettingsGroup;
   (tVoid) DefaultSettingsMode;
   // onFI_VD_DIMMING_DEFAULTMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendFI_VD_DIMMING_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus) {
   if (_oMemFI_VD_DIMMING_DEFAULT.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult  oMResult;
      //the data content

      oMResult.DefaultSettingsGroup = DefaultSettingsGroup;
      oMResult.DefaultSettingsStatus = DefaultSettingsStatus;


      _oMemFI_VD_DIMMING_DEFAULT.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemFI_VD_DIMMING_DEFAULT.u16GetSourceAppID(), 
         _oMemFI_VD_DIMMING_DEFAULT.u16GetRegisterID(), 
         _oMemFI_VD_DIMMING_DEFAULT.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_FI_VD_DIMMING_DEFAULT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendFI_VD_DIMMING_DEFAULTMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_FI_VD_DIMMING_DEFAULT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_SetDimmingModeOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_INFO_SetDimmingMode_DimmingMode = oMStart.DimmingMode;



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_SetDimmingMode.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_SetDimmingModeMStart(oMStart.DimmingMode);
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_SetDimmingModeMStart(oMStart.DimmingMode);
            // vHandleDIM_INFO_SetDimmingModeOpMStart: user specific code start
            // vHandleDIM_INFO_SetDimmingModeOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_SetDimmingModeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_SetDimmingModeMStart(dimming_fi_tcl_e8_DIM_Mode DimmingMode) {

   // onDIM_INFO_SetDimmingModeMStart: user specific code start
   (tVoid) DimmingMode;
   // onDIM_INFO_SetDimmingModeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_SetDimmingModeMResult(dimming_fi_tcl_e8_DIM_Mode DimmingMode) {
   if (_oMemDIM_INFO_SetDimmingMode.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult  oMResult;
      //the data content

      oMResult.DimmingMode = DimmingMode;


      _oMemDIM_INFO_SetDimmingMode.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_SetDimmingMode.u16GetSourceAppID(), 
         _oMemDIM_INFO_SetDimmingMode.u16GetRegisterID(), 
         _oMemDIM_INFO_SetDimmingMode.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGMODE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_SetDimmingModeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGMODE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_SetEmulationModeOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_INFO_SetEmulationMode_EmulationMode = oMStart.EmulationMode;



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_SetEmulationMode.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_SetEmulationModeMStart(oMStart.EmulationMode);
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_SetEmulationModeMStart(oMStart.EmulationMode);
            // vHandleDIM_INFO_SetEmulationModeOpMStart: user specific code start
            // vHandleDIM_INFO_SetEmulationModeOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_SetEmulationModeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_SetEmulationModeMStart(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode) {

   // onDIM_INFO_SetEmulationModeMStart: user specific code start
   (tVoid) EmulationMode;
   // onDIM_INFO_SetEmulationModeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_SetEmulationModeMResult(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode) {
   if (_oMemDIM_INFO_SetEmulationMode.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult  oMResult;
      //the data content

      oMResult.EmulationMode = EmulationMode;


      _oMemDIM_INFO_SetEmulationMode.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_SetEmulationMode.u16GetSourceAppID(), 
         _oMemDIM_INFO_SetEmulationMode.u16GetRegisterID(), 
         _oMemDIM_INFO_SetEmulationMode.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_SETEMULATIONMODE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_SetEmulationModeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_SETEMULATIONMODE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_SetDimmingStateOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_INFO_SetDimmingState_LUN = oMStart.LUN;
            _tDIM_INFO_SetDimmingState_DimmingStatus = oMStart.DimmingStatus;



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_SetDimmingState.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_SetDimmingStateMStart(oMStart.LUN, oMStart.DimmingStatus);
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_SetDimmingStateMStart(oMStart.LUN, oMStart.DimmingStatus);
            // vHandleDIM_INFO_SetDimmingStateOpMStart: user specific code start
            // vHandleDIM_INFO_SetDimmingStateOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_SetDimmingStateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_SetDimmingStateMStart(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus) {

   // onDIM_INFO_SetDimmingStateMStart: user specific code start
   (tVoid) LUN;
   (tVoid) DimmingStatus;
   // onDIM_INFO_SetDimmingStateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_SetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus) {
   if (_oMemDIM_INFO_SetDimmingState.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult  oMResult;
      //the data content

      oMResult.LUN = LUN;
      oMResult.DimmingStatus = DimmingStatus;


      _oMemDIM_INFO_SetDimmingState.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_SetDimmingState.u16GetSourceAppID(), 
         _oMemDIM_INFO_SetDimmingState.u16GetRegisterID(), 
         _oMemDIM_INFO_SetDimmingState.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGSTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_SetDimmingStateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGSTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_GetDimmingStateOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_INFO_GetDimmingState_LUN = oMStart.LUN;



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_GetDimmingState.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_GetDimmingStateMStart(oMStart.LUN);
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_GetDimmingStateMStart(oMStart.LUN);
            // vHandleDIM_INFO_GetDimmingStateOpMStart: user specific code start
            // vHandleDIM_INFO_GetDimmingStateOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_GetDimmingStateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_GetDimmingStateMStart(tU8 LUN) {

   // onDIM_INFO_GetDimmingStateMStart: user specific code start
   (tVoid) LUN;
   // onDIM_INFO_GetDimmingStateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_GetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingState) {
   if (_oMemDIM_INFO_GetDimmingState.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult  oMResult;
      //the data content

      oMResult.LUN = LUN;
      oMResult.DimmingState = DimmingState;


      _oMemDIM_INFO_GetDimmingState.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_GetDimmingState.u16GetSourceAppID(), 
         _oMemDIM_INFO_GetDimmingState.u16GetRegisterID(), 
         _oMemDIM_INFO_GetDimmingState.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGSTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_GetDimmingStateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGSTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_SetDimmingBrightnessOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_INFO_SetDimmingBrightness_LUN = oMStart.LUN;
            _tDIM_INFO_SetDimmingBrightness_Brightness = oMStart.Brightness;



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_SetDimmingBrightness.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_SetDimmingBrightnessMStart(oMStart.LUN, oMStart.Brightness);
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_SetDimmingBrightnessMStart(oMStart.LUN, oMStart.Brightness);
            // vHandleDIM_INFO_SetDimmingBrightnessOpMStart: user specific code start
            // vHandleDIM_INFO_SetDimmingBrightnessOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_SetDimmingBrightnessOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_SetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_INFO_SetDimmingBrightnessMStart: user specific code start
   (tVoid) LUN;
   (tVoid) Brightness;
   // onDIM_INFO_SetDimmingBrightnessMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_SetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) {
   if (_oMemDIM_INFO_SetDimmingBrightness.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult  oMResult;
      //the data content

      oMResult.LUN = LUN;
      oMResult.Brightness = Brightness;


      _oMemDIM_INFO_SetDimmingBrightness.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_SetDimmingBrightness.u16GetSourceAppID(), 
         _oMemDIM_INFO_SetDimmingBrightness.u16GetRegisterID(), 
         _oMemDIM_INFO_SetDimmingBrightness.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGBRIGHTNESS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_SetDimmingBrightnessMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_SETDIMMINGBRIGHTNESS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_GetDimmingBrightnessOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_INFO_GetDimmingBrightness_LUN = oMStart.LUN;



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_GetDimmingBrightness.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_GetDimmingBrightnessMStart(oMStart.LUN);
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_GetDimmingBrightnessMStart(oMStart.LUN);
            // vHandleDIM_INFO_GetDimmingBrightnessOpMStart: user specific code start
            // vHandleDIM_INFO_GetDimmingBrightnessOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_GetDimmingBrightnessOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_GetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN) {

   // onDIM_INFO_GetDimmingBrightnessMStart: user specific code start
   (tVoid) LUN;
   // onDIM_INFO_GetDimmingBrightnessMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_GetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) {
   if (_oMemDIM_INFO_GetDimmingBrightness.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult  oMResult;
      //the data content

      oMResult.LUN = LUN;
      oMResult.Brightness = Brightness;


      _oMemDIM_INFO_GetDimmingBrightness.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_GetDimmingBrightness.u16GetSourceAppID(), 
         _oMemDIM_INFO_GetDimmingBrightness.u16GetRegisterID(), 
         _oMemDIM_INFO_GetDimmingBrightness.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGBRIGHTNESS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_GetDimmingBrightnessMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_GETDIMMINGBRIGHTNESS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_INFO_GetPWMBrightnessOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemDIM_INFO_GetPWMBrightness.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_INFO_GetPWMBrightnessMStart();
            if (_poCallbackIf) _poCallbackIf->onDIM_INFO_GetPWMBrightnessMStart();
            // vHandleDIM_INFO_GetPWMBrightnessOpMStart: user specific code start
            // vHandleDIM_INFO_GetPWMBrightnessOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_INFO_GetPWMBrightnessOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_INFO_GetPWMBrightnessMStart() {

   // onDIM_INFO_GetPWMBrightnessMStart: user specific code start
   // onDIM_INFO_GetPWMBrightnessMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_INFO_GetPWMBrightnessMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
   if (_oMemDIM_INFO_GetPWMBrightness.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult  oMResult;
      //the data content

      oMResult.Brightness = Brightness;


      _oMemDIM_INFO_GetPWMBrightness.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_INFO_GetPWMBrightness.u16GetSourceAppID(), 
         _oMemDIM_INFO_GetPWMBrightness.u16GetRegisterID(), 
         _oMemDIM_INFO_GetPWMBrightness.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_INFO_GETPWMBRIGHTNESS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_INFO_GetPWMBrightnessMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_INFO_GETPWMBRIGHTNESS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_KEYB_SetDimmingOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_KEYB_SetDimming_Brightness = oMStart.Brightness;



            // Remember that we have to send an answer to this request
            _oMemDIM_KEYB_SetDimming.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_KEYB_SetDimmingMStart(oMStart.Brightness);
            if (_poCallbackIf) _poCallbackIf->onDIM_KEYB_SetDimmingMStart(oMStart.Brightness);
            // vHandleDIM_KEYB_SetDimmingOpMStart: user specific code start
            // vHandleDIM_KEYB_SetDimmingOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_KEYB_SetDimmingOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_KEYB_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_KEYB_SetDimmingMStart: user specific code start
   (tVoid) Brightness;
   // onDIM_KEYB_SetDimmingMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_KEYB_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
   if (_oMemDIM_KEYB_SetDimming.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult  oMResult;
      //the data content

      oMResult.Brightness = Brightness;


      _oMemDIM_KEYB_SetDimming.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_KEYB_SetDimming.u16GetSourceAppID(), 
         _oMemDIM_KEYB_SetDimming.u16GetRegisterID(), 
         _oMemDIM_KEYB_SetDimming.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMING, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_KEYB_SetDimmingMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMING, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_KEYB_SetDimmingPWMOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_KEYB_SetDimmingPWM_Brightness = oMStart.Brightness;



            // Remember that we have to send an answer to this request
            _oMemDIM_KEYB_SetDimmingPWM.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_KEYB_SetDimmingPWMMStart(oMStart.Brightness);
            if (_poCallbackIf) _poCallbackIf->onDIM_KEYB_SetDimmingPWMMStart(oMStart.Brightness);
            // vHandleDIM_KEYB_SetDimmingPWMOpMStart: user specific code start
            // vHandleDIM_KEYB_SetDimmingPWMOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_KEYB_SetDimmingPWMOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_KEYB_SetDimmingPWMMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_KEYB_SetDimmingPWMMStart: user specific code start
   (tVoid) Brightness;
   // onDIM_KEYB_SetDimmingPWMMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_KEYB_SetDimmingPWMMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
   if (_oMemDIM_KEYB_SetDimmingPWM.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult  oMResult;
      //the data content

      oMResult.Brightness = Brightness;


      _oMemDIM_KEYB_SetDimmingPWM.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_KEYB_SetDimmingPWM.u16GetSourceAppID(), 
         _oMemDIM_KEYB_SetDimmingPWM.u16GetRegisterID(), 
         _oMemDIM_KEYB_SetDimmingPWM.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMINGPWM, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_KEYB_SetDimmingPWMMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_KEYB_SETDIMMINGPWM, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetDriverInitalizedOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetDriverInitalized_SetDriverInitialized = oMStart.SetDriverInitialized;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetDriverInitalized.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetDriverInitalizedMStart(oMStart.SetDriverInitialized);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetDriverInitalizedMStart(oMStart.SetDriverInitialized);
            // vHandleDIM_DISP_SetDriverInitalizedOpMStart: user specific code start
            // vHandleDIM_DISP_SetDriverInitalizedOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetDriverInitalizedOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetDriverInitalizedMStart(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized) {

   // onDIM_DISP_SetDriverInitalizedMStart: user specific code start
   (tVoid) SetDriverInitialized;
   // onDIM_DISP_SetDriverInitalizedMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetDriverInitalizedMResult(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized) {
   if (_oMemDIM_DISP_SetDriverInitalized.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult  oMResult;
      //the data content

      oMResult.SetDriverInitialized = SetDriverInitialized;


      _oMemDIM_DISP_SetDriverInitalized.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetDriverInitalized.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetDriverInitalized.u16GetRegisterID(), 
         _oMemDIM_DISP_SetDriverInitalized.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETDRIVERINITALIZED, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetDriverInitalizedMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETDRIVERINITALIZED, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetScreenContentAvailableOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetScreenContentAvailable_SetScreenContentAvailable = oMStart.SetScreenContentAvailable;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetScreenContentAvailable.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetScreenContentAvailableMStart(oMStart.SetScreenContentAvailable);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetScreenContentAvailableMStart(oMStart.SetScreenContentAvailable);
            // vHandleDIM_DISP_SetScreenContentAvailableOpMStart: user specific code start
            // vHandleDIM_DISP_SetScreenContentAvailableOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetScreenContentAvailableOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetScreenContentAvailableMStart(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable) {

   // onDIM_DISP_SetScreenContentAvailableMStart: user specific code start
   (tVoid) SetScreenContentAvailable;
   // onDIM_DISP_SetScreenContentAvailableMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetScreenContentAvailableMResult(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable) {
   if (_oMemDIM_DISP_SetScreenContentAvailable.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult  oMResult;
      //the data content

      oMResult.SetScreenContentAvailable = SetScreenContentAvailable;


      _oMemDIM_DISP_SetScreenContentAvailable.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetScreenContentAvailable.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetScreenContentAvailable.u16GetRegisterID(), 
         _oMemDIM_DISP_SetScreenContentAvailable.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETSCREENCONTENTAVAILABLE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetScreenContentAvailableMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETSCREENCONTENTAVAILABLE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetDimmingOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetDimming_Brightness = oMStart.Brightness;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetDimming.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetDimmingMStart(oMStart.Brightness);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetDimmingMStart(oMStart.Brightness);
            // vHandleDIM_DISP_SetDimmingOpMStart: user specific code start
            // vHandleDIM_DISP_SetDimmingOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetDimmingOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_DISP_SetDimmingMStart: user specific code start
   (tVoid) Brightness;
   // onDIM_DISP_SetDimmingMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
   if (_oMemDIM_DISP_SetDimming.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult  oMResult;
      //the data content

      oMResult.Brightness = Brightness;


      _oMemDIM_DISP_SetDimming.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetDimming.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetDimming.u16GetRegisterID(), 
         _oMemDIM_DISP_SetDimming.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETDIMMING, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetDimmingMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETDIMMING, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SwitchBacklightOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SwitchBacklight_SwitchBacklight = oMStart.SwitchBacklight;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SwitchBacklight.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SwitchBacklightMStart(oMStart.SwitchBacklight);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SwitchBacklightMStart(oMStart.SwitchBacklight);
            // vHandleDIM_DISP_SwitchBacklightOpMStart: user specific code start
            // vHandleDIM_DISP_SwitchBacklightOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SwitchBacklightOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {

   // onDIM_DISP_SwitchBacklightMStart: user specific code start
   (tVoid) SwitchBacklight;
   // onDIM_DISP_SwitchBacklightMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {
   if (_oMemDIM_DISP_SwitchBacklight.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult  oMResult;
      //the data content

      oMResult.SwitchBacklight = SwitchBacklight;


      _oMemDIM_DISP_SwitchBacklight.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SwitchBacklight.u16GetSourceAppID(), 
         _oMemDIM_DISP_SwitchBacklight.u16GetRegisterID(), 
         _oMemDIM_DISP_SwitchBacklight.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SwitchBacklightMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetBrightnessLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetBrightnessLevel_BrightnessLevel = oMStart.BrightnessLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetBrightnessLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetBrightnessLevelMStart(oMStart.BrightnessLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetBrightnessLevelMStart(oMStart.BrightnessLevel);
            // vHandleDIM_DISP_SetBrightnessLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetBrightnessLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetBrightnessLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetBrightnessLevelMStart(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel) {

   // onDIM_DISP_SetBrightnessLevelMStart: user specific code start
   (tVoid) BrightnessLevel;
   // onDIM_DISP_SetBrightnessLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetBrightnessLevelMResult(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel) {
   if (_oMemDIM_DISP_SetBrightnessLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult  oMResult;
      //the data content

      oMResult.BrightnessLevel = BrightnessLevel;


      _oMemDIM_DISP_SetBrightnessLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetBrightnessLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetBrightnessLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetBrightnessLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetBrightnessLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetBrightnessLevelExtendedOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetBrightnessLevelExtended_BrightnessLevelExtended = oMStart.BrightnessLevelExtended;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetBrightnessLevelExtended.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetBrightnessLevelExtendedMStart(oMStart.BrightnessLevelExtended);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetBrightnessLevelExtendedMStart(oMStart.BrightnessLevelExtended);
            // vHandleDIM_DISP_SetBrightnessLevelExtendedOpMStart: user specific code start
            // vHandleDIM_DISP_SetBrightnessLevelExtendedOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetBrightnessLevelExtendedOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetBrightnessLevelExtendedMStart(tU8 BrightnessLevelExtended) {

   // onDIM_DISP_SetBrightnessLevelExtendedMStart: user specific code start
   (tVoid) BrightnessLevelExtended;
   // onDIM_DISP_SetBrightnessLevelExtendedMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetBrightnessLevelExtendedMResult(tU8 BrightnessLevelExtended) {
   if (_oMemDIM_DISP_SetBrightnessLevelExtended.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult  oMResult;
      //the data content

      oMResult.BrightnessLevelExtended = BrightnessLevelExtended;


      _oMemDIM_DISP_SetBrightnessLevelExtended.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetBrightnessLevelExtended.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetBrightnessLevelExtended.u16GetRegisterID(), 
         _oMemDIM_DISP_SetBrightnessLevelExtended.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVELEXTENDED, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetBrightnessLevelExtendedMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVELEXTENDED, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetVideoBrightnessLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelDay = oMStart.VideoBrightnessLevelDay;
            _tDIM_DISP_SetVideoBrightnessLevel_VideoBrightnessLevelNight = oMStart.VideoBrightnessLevelNight;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetVideoBrightnessLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetVideoBrightnessLevelMStart(oMStart.VideoBrightnessLevelDay, oMStart.VideoBrightnessLevelNight);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetVideoBrightnessLevelMStart(oMStart.VideoBrightnessLevelDay, oMStart.VideoBrightnessLevelNight);
            // vHandleDIM_DISP_SetVideoBrightnessLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetVideoBrightnessLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetVideoBrightnessLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetVideoBrightnessLevelMStart(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight) {

   // onDIM_DISP_SetVideoBrightnessLevelMStart: user specific code start
   (tVoid) VideoBrightnessLevelDay;
   (tVoid) VideoBrightnessLevelNight;
   // onDIM_DISP_SetVideoBrightnessLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetVideoBrightnessLevelMResult(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight) {
   if (_oMemDIM_DISP_SetVideoBrightnessLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult  oMResult;
      //the data content

      oMResult.VideoBrightnessLevelDay = VideoBrightnessLevelDay;
      oMResult.VideoBrightnessLevelNight = VideoBrightnessLevelNight;


      _oMemDIM_DISP_SetVideoBrightnessLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetVideoBrightnessLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetVideoBrightnessLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetVideoBrightnessLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETVIDEOBRIGHTNESSLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetVideoBrightnessLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETVIDEOBRIGHTNESSLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetContrastLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetContrastLevel_Contrast = oMStart.Contrast;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetContrastLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetContrastLevelMStart(oMStart.Contrast);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetContrastLevelMStart(oMStart.Contrast);
            // vHandleDIM_DISP_SetContrastLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetContrastLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetContrastLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetContrastLevelMStart(tU8 Contrast) {

   // onDIM_DISP_SetContrastLevelMStart: user specific code start
   (tVoid) Contrast;
   // onDIM_DISP_SetContrastLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetContrastLevelMResult(tU8 BrightnessLevelExtended) {
   if (_oMemDIM_DISP_SetContrastLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult  oMResult;
      //the data content

      oMResult.BrightnessLevelExtended = BrightnessLevelExtended;


      _oMemDIM_DISP_SetContrastLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetContrastLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetContrastLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetContrastLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCONTRASTLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetContrastLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCONTRASTLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetBlackLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetBlackLevel_BlackLevel = oMStart.BlackLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetBlackLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetBlackLevelMStart(oMStart.BlackLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetBlackLevelMStart(oMStart.BlackLevel);
            // vHandleDIM_DISP_SetBlackLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetBlackLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetBlackLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetBlackLevelMStart(tU8 BlackLevel) {

   // onDIM_DISP_SetBlackLevelMStart: user specific code start
   (tVoid) BlackLevel;
   // onDIM_DISP_SetBlackLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetBlackLevelMResult(tU8 BlackLevel) {
   if (_oMemDIM_DISP_SetBlackLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult  oMResult;
      //the data content

      oMResult.BlackLevel = BlackLevel;


      _oMemDIM_DISP_SetBlackLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetBlackLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetBlackLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetBlackLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETBLACKLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetBlackLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETBLACKLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetYCurveLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetYCurveLevel_YCurveLevel = oMStart.YCurveLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetYCurveLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetYCurveLevelMStart(oMStart.YCurveLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetYCurveLevelMStart(oMStart.YCurveLevel);
            // vHandleDIM_DISP_SetYCurveLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetYCurveLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetYCurveLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetYCurveLevelMStart(tU8 YCurveLevel) {

   // onDIM_DISP_SetYCurveLevelMStart: user specific code start
   (tVoid) YCurveLevel;
   // onDIM_DISP_SetYCurveLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetYCurveLevelMResult(tU8 YCurveLevel) {
   if (_oMemDIM_DISP_SetYCurveLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult  oMResult;
      //the data content

      oMResult.YCurveLevel = YCurveLevel;


      _oMemDIM_DISP_SetYCurveLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetYCurveLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetYCurveLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetYCurveLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETYCURVELEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetYCurveLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETYCURVELEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetTintLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetTintLevel_TintLevel = oMStart.TintLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetTintLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetTintLevelMStart(oMStart.TintLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetTintLevelMStart(oMStart.TintLevel);
            // vHandleDIM_DISP_SetTintLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetTintLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetTintLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetTintLevelMStart(tU8 TintLevel) {

   // onDIM_DISP_SetTintLevelMStart: user specific code start
   (tVoid) TintLevel;
   // onDIM_DISP_SetTintLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetTintLevelMResult(tU8 TintLevel) {
   if (_oMemDIM_DISP_SetTintLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult  oMResult;
      //the data content

      oMResult.TintLevel = TintLevel;


      _oMemDIM_DISP_SetTintLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetTintLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetTintLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetTintLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETTINTLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetTintLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETTINTLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetColorLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetColorLevel_ColorLevel = oMStart.ColorLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetColorLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetColorLevelMStart(oMStart.ColorLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetColorLevelMStart(oMStart.ColorLevel);
            // vHandleDIM_DISP_SetColorLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetColorLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetColorLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetColorLevelMStart(tU8 ColorLevel) {

   // onDIM_DISP_SetColorLevelMStart: user specific code start
   (tVoid) ColorLevel;
   // onDIM_DISP_SetColorLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetColorLevelMResult(tU8 ColorLevel) {
   if (_oMemDIM_DISP_SetColorLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult  oMResult;
      //the data content

      oMResult.ColorLevel = ColorLevel;


      _oMemDIM_DISP_SetColorLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetColorLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetColorLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetColorLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCOLORLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetColorLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCOLORLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DIAG_SetBrightnessInputTypeOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DIAG_SetBrightnessInputType_SetBrightnessInputType = oMStart.SetBrightnessInputType;



            // Remember that we have to send an answer to this request
            _oMemDIM_DIAG_SetBrightnessInputType.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DIAG_SetBrightnessInputTypeMStart(oMStart.SetBrightnessInputType);
            if (_poCallbackIf) _poCallbackIf->onDIM_DIAG_SetBrightnessInputTypeMStart(oMStart.SetBrightnessInputType);
            // vHandleDIM_DIAG_SetBrightnessInputTypeOpMStart: user specific code start
            // vHandleDIM_DIAG_SetBrightnessInputTypeOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DIAG_SetBrightnessInputTypeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DIAG_SetBrightnessInputTypeMStart(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType) {

   // onDIM_DIAG_SetBrightnessInputTypeMStart: user specific code start
   (tVoid) SetBrightnessInputType;
   // onDIM_DIAG_SetBrightnessInputTypeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DIAG_SetBrightnessInputTypeMResult(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType) {
   if (_oMemDIM_DIAG_SetBrightnessInputType.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult  oMResult;
      //the data content

      oMResult.SetBrightnessInputType = SetBrightnessInputType;


      _oMemDIM_DIAG_SetBrightnessInputType.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DIAG_SetBrightnessInputType.u16GetSourceAppID(), 
         _oMemDIM_DIAG_SetBrightnessInputType.u16GetRegisterID(), 
         _oMemDIM_DIAG_SetBrightnessInputType.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DIAG_SETBRIGHTNESSINPUTTYPE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DIAG_SetBrightnessInputTypeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DIAG_SETBRIGHTNESSINPUTTYPE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetCSCContrastLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetCSCContrastLevel_ContrastLevel = oMStart.ContrastLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetCSCContrastLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetCSCContrastLevelMStart(oMStart.ContrastLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetCSCContrastLevelMStart(oMStart.ContrastLevel);
            // vHandleDIM_DISP_SetCSCContrastLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetCSCContrastLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetCSCContrastLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetCSCContrastLevelMStart(tU8 ContrastLevel) {

   // onDIM_DISP_SetCSCContrastLevelMStart: user specific code start
   (tVoid) ContrastLevel;
   // onDIM_DISP_SetCSCContrastLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetCSCContrastLevelMResult(tU8 ContrastLevel) {
   if (_oMemDIM_DISP_SetCSCContrastLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult  oMResult;
      //the data content

      oMResult.ContrastLevel = ContrastLevel;


      _oMemDIM_DISP_SetCSCContrastLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetCSCContrastLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetCSCContrastLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetCSCContrastLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCONTRASTLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetCSCContrastLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCONTRASTLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetCSCBlackLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetCSCBlackLevel_BlackLevel = oMStart.BlackLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetCSCBlackLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetCSCBlackLevelMStart(oMStart.BlackLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetCSCBlackLevelMStart(oMStart.BlackLevel);
            // vHandleDIM_DISP_SetCSCBlackLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetCSCBlackLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetCSCBlackLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetCSCBlackLevelMStart(tU8 BlackLevel) {

   // onDIM_DISP_SetCSCBlackLevelMStart: user specific code start
   (tVoid) BlackLevel;
   // onDIM_DISP_SetCSCBlackLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetCSCBlackLevelMResult(tU8 BlackLevel) {
   if (_oMemDIM_DISP_SetCSCBlackLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult  oMResult;
      //the data content

      oMResult.BlackLevel = BlackLevel;


      _oMemDIM_DISP_SetCSCBlackLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetCSCBlackLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetCSCBlackLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetCSCBlackLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCBLACKLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetCSCBlackLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCBLACKLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetCSCGammaLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetCSCGammaLevel_GammaLevel = oMStart.GammaLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetCSCGammaLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetCSCGammaLevelMStart(oMStart.GammaLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetCSCGammaLevelMStart(oMStart.GammaLevel);
            // vHandleDIM_DISP_SetCSCGammaLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetCSCGammaLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetCSCGammaLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetCSCGammaLevelMStart(tU8 GammaLevel) {

   // onDIM_DISP_SetCSCGammaLevelMStart: user specific code start
   (tVoid) GammaLevel;
   // onDIM_DISP_SetCSCGammaLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetCSCGammaLevelMResult(tU8 GammaLevel) {
   if (_oMemDIM_DISP_SetCSCGammaLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult  oMResult;
      //the data content

      oMResult.GammaLevel = GammaLevel;


      _oMemDIM_DISP_SetCSCGammaLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetCSCGammaLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetCSCGammaLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetCSCGammaLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCGAMMALEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetCSCGammaLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCGAMMALEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetCSCSaturationLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetCSCSaturationLevel_SaturationLevel = oMStart.SaturationLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetCSCSaturationLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetCSCSaturationLevelMStart(oMStart.SaturationLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetCSCSaturationLevelMStart(oMStart.SaturationLevel);
            // vHandleDIM_DISP_SetCSCSaturationLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetCSCSaturationLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetCSCSaturationLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetCSCSaturationLevelMStart(tU8 SaturationLevel) {

   // onDIM_DISP_SetCSCSaturationLevelMStart: user specific code start
   (tVoid) SaturationLevel;
   // onDIM_DISP_SetCSCSaturationLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetCSCSaturationLevelMResult(tU8 SaturationLevel) {
   if (_oMemDIM_DISP_SetCSCSaturationLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult  oMResult;
      //the data content

      oMResult.SaturationLevel = SaturationLevel;


      _oMemDIM_DISP_SetCSCSaturationLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetCSCSaturationLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetCSCSaturationLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetCSCSaturationLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCSATURATIONLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetCSCSaturationLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCSATURATIONLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_DISP_SetCSCColorLevelOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_DISP_SetCSCColorLevel_ColorLevel = oMStart.ColorLevel;



            // Remember that we have to send an answer to this request
            _oMemDIM_DISP_SetCSCColorLevel.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_DISP_SetCSCColorLevelMStart(oMStart.ColorLevel);
            if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SetCSCColorLevelMStart(oMStart.ColorLevel);
            // vHandleDIM_DISP_SetCSCColorLevelOpMStart: user specific code start
            // vHandleDIM_DISP_SetCSCColorLevelOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_DISP_SetCSCColorLevelOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_DISP_SetCSCColorLevelMStart(tU8 ColorLevel) {

   // onDIM_DISP_SetCSCColorLevelMStart: user specific code start
   (tVoid) ColorLevel;
   // onDIM_DISP_SetCSCColorLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_DISP_SetCSCColorLevelMResult(tU8 ColorLevel) {
   if (_oMemDIM_DISP_SetCSCColorLevel.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult  oMResult;
      //the data content

      oMResult.ColorLevel = ColorLevel;


      _oMemDIM_DISP_SetCSCColorLevel.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_DISP_SetCSCColorLevel.u16GetSourceAppID(), 
         _oMemDIM_DISP_SetCSCColorLevel.u16GetRegisterID(), 
         _oMemDIM_DISP_SetCSCColorLevel.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCOLORLEVEL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_DISP_SetCSCColorLevelMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SETCSCCOLORLEVEL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_SECOND_DISP_SetDispParameterOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_SECOND_DISP_SetDispParameter_e16FunctionId = oMStart.e16FunctionId;
            _tDIM_SECOND_DISP_SetDispParameter_u16ParameterValue = oMStart.u16ParameterValue;



            // Remember that we have to send an answer to this request
            _oMemDIM_SECOND_DISP_SetDispParameter.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_SECOND_DISP_SetDispParameterMStart(oMStart.e16FunctionId, oMStart.u16ParameterValue);
            if (_poCallbackIf) _poCallbackIf->onDIM_SECOND_DISP_SetDispParameterMStart(oMStart.e16FunctionId, oMStart.u16ParameterValue);
            // vHandleDIM_SECOND_DISP_SetDispParameterOpMStart: user specific code start
            // vHandleDIM_SECOND_DISP_SetDispParameterOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_SECOND_DISP_SetDispParameterOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_SECOND_DISP_SetDispParameterMStart(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue) {

   // onDIM_SECOND_DISP_SetDispParameterMStart: user specific code start
   // onDIM_SECOND_DISP_SetDispParameterMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_SetDispParameterMResult(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue) {
   if (_oMemDIM_SECOND_DISP_SetDispParameter.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult  oMResult;
      //the data content

      oMResult.e16FunctionId = e16FunctionId;
      oMResult.u16ParameterValue = u16ParameterValue;


      _oMemDIM_SECOND_DISP_SetDispParameter.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_SECOND_DISP_SetDispParameter.u16GetSourceAppID(), 
         _oMemDIM_SECOND_DISP_SetDispParameter.u16GetRegisterID(), 
         _oMemDIM_SECOND_DISP_SetDispParameter.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPPARAMETER, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_SECOND_DISP_SetDispParameterMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPPARAMETER, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_SECOND_DISP_SetDispOnOffOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDIM_SECOND_DISP_SetDispOnOff_u8DisplayState = oMStart.u8DisplayState;



            // Remember that we have to send an answer to this request
            _oMemDIM_SECOND_DISP_SetDispOnOff.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_SECOND_DISP_SetDispOnOffMStart(oMStart.u8DisplayState);
            if (_poCallbackIf) _poCallbackIf->onDIM_SECOND_DISP_SetDispOnOffMStart(oMStart.u8DisplayState);
            // vHandleDIM_SECOND_DISP_SetDispOnOffOpMStart: user specific code start
            // vHandleDIM_SECOND_DISP_SetDispOnOffOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_SECOND_DISP_SetDispOnOffOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_SECOND_DISP_SetDispOnOffMStart(tU8 u8DisplayState) {

   // onDIM_SECOND_DISP_SetDispOnOffMStart: user specific code start
   // onDIM_SECOND_DISP_SetDispOnOffMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_SetDispOnOffMResult(tU8 u8DisplayState) {
   if (_oMemDIM_SECOND_DISP_SetDispOnOff.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult  oMResult;
      //the data content

      oMResult.u8DisplayState = u8DisplayState;


      _oMemDIM_SECOND_DISP_SetDispOnOff.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_SECOND_DISP_SetDispOnOff.u16GetSourceAppID(), 
         _oMemDIM_SECOND_DISP_SetDispOnOff.u16GetRegisterID(), 
         _oMemDIM_SECOND_DISP_SetDispOnOff.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPONOFF, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_SECOND_DISP_SetDispOnOffMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SETDISPONOFF, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_SECOND_DISP_HardwareVersionOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemDIM_SECOND_DISP_HardwareVersion.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_SECOND_DISP_HardwareVersionMStart();
            if (_poCallbackIf) _poCallbackIf->onDIM_SECOND_DISP_HardwareVersionMStart();
            // vHandleDIM_SECOND_DISP_HardwareVersionOpMStart: user specific code start
            // vHandleDIM_SECOND_DISP_HardwareVersionOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_SECOND_DISP_HardwareVersionOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_SECOND_DISP_HardwareVersionMStart() {

   // onDIM_SECOND_DISP_HardwareVersionMStart: user specific code start
   // onDIM_SECOND_DISP_HardwareVersionMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_HardwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo HW_VersionInfo) {
   if (_oMemDIM_SECOND_DISP_HardwareVersion.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult  oMResult;
      //the data content

      oMResult.HW_VersionInfo = HW_VersionInfo;


      _oMemDIM_SECOND_DISP_HardwareVersion.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_SECOND_DISP_HardwareVersion.u16GetSourceAppID(), 
         _oMemDIM_SECOND_DISP_HardwareVersion.u16GetRegisterID(), 
         _oMemDIM_SECOND_DISP_HardwareVersion.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_HARDWAREVERSION, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_SECOND_DISP_HardwareVersionMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_HARDWAREVERSION, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_SECOND_DISP_SoftwareVersionOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemDIM_SECOND_DISP_SoftwareVersion.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_SECOND_DISP_SoftwareVersionMStart();
            if (_poCallbackIf) _poCallbackIf->onDIM_SECOND_DISP_SoftwareVersionMStart();
            // vHandleDIM_SECOND_DISP_SoftwareVersionOpMStart: user specific code start
            // vHandleDIM_SECOND_DISP_SoftwareVersionOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_SECOND_DISP_SoftwareVersionOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_SECOND_DISP_SoftwareVersionMStart() {

   // onDIM_SECOND_DISP_SoftwareVersionMStart: user specific code start
   // onDIM_SECOND_DISP_SoftwareVersionMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_SoftwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo SW_VersionInfo) {
   if (_oMemDIM_SECOND_DISP_SoftwareVersion.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult  oMResult;
      //the data content

      oMResult.SW_VersionInfo = SW_VersionInfo;


      _oMemDIM_SECOND_DISP_SoftwareVersion.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_SECOND_DISP_SoftwareVersion.u16GetSourceAppID(), 
         _oMemDIM_SECOND_DISP_SoftwareVersion.u16GetRegisterID(), 
         _oMemDIM_SECOND_DISP_SoftwareVersion.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SOFTWAREVERSION, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_SECOND_DISP_SoftwareVersionMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SOFTWAREVERSION, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::sendDIM_SECOND_DISP_GetALLParamMResult() {
   if (_oMemDIM_SECOND_DISP_GetALLParam.bIsPending() == TRUE) {
      dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult  oMResult;
      //the data content



      _oMemDIM_SECOND_DISP_GetALLParam.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDIM_SECOND_DISP_GetALLParam.u16GetSourceAppID(), 
         _oMemDIM_SECOND_DISP_GetALLParam.u16GetRegisterID(), 
         _oMemDIM_SECOND_DISP_GetALLParam.u16GetCMDCounter(), 
         (tU16) DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_GETALLPARAM, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendDIM_SECOND_DISP_GetALLParamMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_GETALLPARAM, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceDimming::vHandleDIM_SECOND_DISP_GetALLParamOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemDIM_SECOND_DISP_GetALLParam.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDIM_SECOND_DISP_GetALLParamMStart();
            if (_poCallbackIf) _poCallbackIf->onDIM_SECOND_DISP_GetALLParamMStart();
            // vHandleDIM_SECOND_DISP_GetALLParamOpMStart: user specific code start
            // vHandleDIM_SECOND_DISP_GetALLParamOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDIM_SECOND_DISP_GetALLParamOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceDimming::onDIM_SECOND_DISP_GetALLParamMStart() {

   // onDIM_SECOND_DISP_GetALLParamMStart: user specific code start
   // onDIM_SECOND_DISP_GetALLParamMStart: user specific code end
}




// dispvidctrl_tclServiceDimmingdispvidctrl_ServiceDimming: user specific code start
// dispvidctrl_tclServiceDimmingdispvidctrl_ServiceDimming: user specific code end

//EOF
