/*****************************************************************************
* FILE:         dispvidctrl_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#ifndef _DISPVIDCTRLMAIN_H_
#define _DISPVIDCTRLMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include <string>
#include <map>
#include <set>

#include "dispvidctrl_AppMain_Trace.h"

// dispvidctrl_tclAppMainIncludes: user specific code start
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

// +++diaglib+++  Specify what kind of diagnostic services you provide. Consult documentation for details +++
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#define DIAGLIB_INCLUDE_IO_CONTROL
#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"

#include "dispvidmgr_dp_if.h"
// dispvidctrl_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


#define DISPVIDCTRL_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define DISPVIDCTRL_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// dispvidctrl_tclAppMainDefine: user specific code start

typedef struct
{
    tU8   u8Brand;
    tU8   u8OpeningAnimation;
    tU8   u8DisplayAspectRatio;
    tU8   u8DisplayType;
    tU16  u16DestinationRegion;
    tU16  u16VehicleType;
    //tU8   u8DisplayOutput;
    tU8   u8DisplayOrientation;
    tU8   u8CameraSystemType;
    tU8   u8CameraConnectionType;
    tU8   u8CameraSteeringMessageType;
    tU8   u8DeviceVariantType;
    tBool bRvcMode;
    tBool bAvmMode;
    tBool bMvcMode;
    tBool bAvmType_Entry;
    tBool bAvmType_Ipa;
    tBool bAvmType_Fap;
    tBool bAvmType_Phase3;
    tBool bAvmType_Renault;
    tBool bRvcType_Renault;
    tBool bStaticGuideline;
    tBool bCentreGuideline;
    tBool bAnticipatoryLine;
    tBool bLeftHandSteeringPosition;
    tBool bBlackWarningTextBackground;
    tBool bManualTransmission;
    tU8   u8BrightnessDay;
    tU8   u8BrightnessNight;
    tU8   u8DisplaySize;
    tU8   u8RvcLensParameterSet;
    tU32  u32DisplayResolutionWidth;
    tU32  u32DisplayResolutionHeight;
    tU32  u32DisplayTwoResolutionWidth;
    tU32  u32DisplayTwoResolutionHeight;
    tU8   VehicleParameter[80];
    tU8   u8VCANDiversity;
    tU8   u8CameraVideoHoldingTime;
    tU8   u8CameraRearTrunkBehaviour;
    tU8   u8ReverseGearDebouncing;
    tU8   u8CropUp;
    tU8   u8CropDown;
    tU8   u8CropLeft;
    tU8   u8CropRight;
    tU8   u8CameraImageMirror;
    tU8   u8WelcomeSequence;
    tU8   Resolution[32];
    tU8   DisplayOrder[4];
    tU8   FlushDesignConfigFile[64];
}TConfiguration;

typedef struct
{
    // pdd configuration
    TEarlyNorConfiguration tEarlyNor;
    TEarlyNorForceConfiguration tEarlyNorForce;

    // default configuration at startup
    tU32  u32RvcLayer;
    tU32  u32GuidelineSurface;
    tU32  u32RvcDayNight;
    tU32  u32RvcColour;
    tU32  u32RvcContrast;  
    tU32  u32RvcBrightness;
    tU32  u32RvcHue;
    tU32  u32RvcBlackLevel;
    tU32  u32RvcSurface;
    tU32  u32RvcPixFmt;
    tU32  u32AnimationSurface;
    tU32  u32RvcGraphicsLayer;
    tU32  u32AnimationLayer;
    tU32  u32AnimationLayer2;
    tU32  u32AnimationSurface2;
}TEarlyConfiguration;

#define DEFAULT_ANIMATIONPATH                         ""
#define DEFAULT_RVCLAYER                              5000
#define DEFAULT_RVCSURFACE                            91
#define DEFAULT_RVCPIXFMT                             9
#define DEFAULT_GUIDELINESURFACE                      92
#define DEFAULT_ANIMATIONSURFACE                      93
#define DEFAULT_RVCGRAPHICSLAYER                      5001
#define DEFAULT_ANIMATIONLAYER                        5002
#define DEFAULT_ANIMATIONLAYER2                       6013
#define DEFAULT_ANIMATIONSURFACE2                     97

typedef enum
{
   SETTING_SPMAUTOMODE,
   SETTING_RVCCOLOUR,
   SETTING_RVCCONTRAST,
   SETTING_RVCBRIGHTNESS,
   SETTING_RVCDAYNIGHT,
   SETTING_RVCHUE,
   SETTING_RVCBLACKLEVEL,
   SETTING_RVCLOWSPEEDTHRESHOLD,
   SETTING_RVCHIGHSPEEDTHRESHOLD,
   SETTING_RVCREVERSEOFFGUARDTIME,
   SETTING_GUIDELINEWARNINGLANGUAGE,
   SETTING_GUIDELINEWARNINGTEXT,
   SETTING_GUIDELINEVISIBILITY,
   SETTING_GUIDELINECAMERATYPE,
   SETTING_GUIDELINECAMERASYSTEMTYPE,
   SETTING_GUIDELINEBLACKWARNINGTEXTBACKGROUND,

   STEERING_WHEEL_ANGLE_CHANGED,
   REAR_WHEEL_ANGLE_CHANGED,

   SETTING_COMPLETE
} tenRVC_Settings;

// Whenever a new Camera type is added, make sure to add both Landscape and Portrait
typedef enum {
   // Landscape
   IDX_LANDSCAPE_RVC = 0,
   IDX_LANDSCAPE_AVM_ENTRY,
   IDX_LANDSCAPE_AVM_PHASE3,
   IDX_LANDSCAPE_MVC,
   IDX_LANDSCAPE_RVC_RENAULT,
   IDX_LANDSCAPE_RVC_RENAULT_UPA,
   IDX_LANDSCAPE_RVC_RENAULT_UPA_HFP,
   IDX_LANDSCAPE_AVM_ENTRY_RENAULT,
   IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA,
   IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA_HFP,
   // Portrait
   IDX_PORTRAIT_RVC,   // PORTRAIT_BEGIN
   IDX_PORTRAIT_AVM_ENTRY,  
   IDX_PORTRAIT_AVM_PHASE3,
   IDX_PORTRAIT_MVC,
   IDX_PORTRAIT_RVC_RENAULT,
   IDX_PORTRAIT_RVC_RENAULT_UPA,
   IDX_PORTRAIT_RVC_RENAULT_UPA_HFP,
   IDX_PORTRAIT_AVM_ENTRY_RENAULT,
   IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA,
   IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA_HFP,
   
   IDX_MAX
} enVideoParamMapIndex;

// Please Note: Adapt also 'enVideoParamMapIndex' in AppMain.h 
// if the below enum sequence is changed
enum tenControl_VideoResize
{
   RVC_AVM_VIDEO_FULL_SCREEN = 0, // according to the HMI PSD
   RVC_AVM_VIDEO_WITH_UPA_VIDEO_SCREEN,
   RVC_AVM_VIDEO_WITH_UPA_HFP_VIDEO_SCREEN,
   RVC_AVM_VIDEO_SETTINGS_SCREEN,
   RVC_AVM_VIDEO_FORCE_FULL_SCREEN // full screen display size
};

// dispvidctrl_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define DISPVIDCTRLINTERNAL_MSG_LEN    45       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class dispvidctrl_tclAppMain;

// dispvidctrl_tclAppMainForwardDecl: user specific code start

// +++diaglib+++  Listener forward declarations
class dispvidctrl_tclDiagRoutineControlListener;
class dispvidctrl_tclDiagIoControlListener;
class dispvidctrl_tclDiagSystemSetListener;

class CSMInterface;

#include <unistd.h>
#include <fcntl.h>

// dispvidctrl_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class dispvidctrl_tclBaseIf
{
protected:
   const dispvidctrl_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages
      eControl = 1,
      eControlAvm = 2,
      eControlHmi = 3,
      eControlRvc = 4,
      eControlMvc = 5,
      eControlFap = 6,
      eControlVideo = 7,
      eControlModeDisabled = 8,
      eControlModeEnabled = 9,
      eDiagVideoLayer = 10,
      eFsmAvm = 11,
      eFsmCameraSupply = 12,
      eFsmCameraSupplySupervision = 13,
      eFsmHmi = 14,
      eFsmIpaSwitchOperation = 15,
      eFsmOnOff = 16,
      eFsmReverseSignal = 17,
      eFsmRvcScreen = 18,
      eFsmMvc = 19,
      eReverseOff = 20,
      eReverseOn = 21,
      eReverseOnDebounced = 22,
      eHmiVisualisationOff = 23,
      eHmiVisualisationOn = 24,
      eHmiVisualisationOnCameraSettings = 25,
      eVideoStatus = 26,
      eAvmNormalBeep = 27,
      eAvmErrorBeep = 28,
      eAvmCanMsgTimeoutFalse = 29,
      eAvmCanMsgTimeoutTrue = 30,
      eAvmAffordableIts = 31,
      eAvmIpaConfigurationChange = 32,
      eAvmIpaRequestNormal = 33,
      eAvmIpaRequestIpa = 34,
      eAvmIpaOperationNormal = 35,
      eAvmIpaOperationMalfunction = 36,
      eAvmIpaSwitchesChange = 37,
      eAvmIpaRequestChange = 38,
      eAvmIpaMsgCountErr = 39,
      eAvmIpaDirectionChange = 40,
      eDimStateChanged = 41,
      eDimModeChanged = 42,
      eDimBrightnessChanged = 43,
      eDimCrLowVoltage = 44,
      eDimHighVoltage = 45,
      eDimNormalVoltage = 46,
      eEmulationModeSet = 47,
      eDispBrightnessSet = 48,
      eKeybBrightnessSet = 49,
      ePwmBrightnessGet = 50,
      eVideoPlayerReady = 51,
      eStartAnimation = 52,
      eStoptAnimation = 53,
      eSyncStateTimeout = 54,
      eSyncFirstFrame = 55,
      eControlSyncHandler = 56,
      eRvcCameraState = 57,
      eMvcViewModeStatus = 58,
      eMvcWarningDisplayRequest = 59,
      eTailGateStateChange = 60,
      eMvcCanMsgTimeoutFalse = 61,
      eMvcCanMsgTimeoutTrue = 62,
      eTriggerCanMsgConfirmTimeout = 63,
      eFapModeActive = 64,
      eAccChanged = 65,
      eIgnChanged = 66,
      eTriggerKDSChanged = 67,
      eTriggerRecheckITC = 68,
      eTriggerBerrUpdate = 69,
      eTriggerInputObserver = 70,
      eTriggerSrvDimStartComDone = 71,
      eAvm3FsmTrigger = 72,
      eAvm3SwitchInput = 73,
      eControlHmiAvm3 = 74,
      eFsmHmiAvm3 = 75,
      eClientMcanAvm3 = 76,

      // shifted by the generator postprocessor:
      // eAvmConnected = 70,
      // eAvmUpdate = 71,
      // eAvmMsgSend = 72,
      // eAvmCommTestResult = 73,
      // eAvmCDataConfTestResult = 74,
      // eAvmDDataConfTestResult = 75,
      // eAvmAccOffDecounced = 76,
      eAvmConnected = 150,
      eAvmUpdate = 151,
      eAvmMsgSend = 152,
      eAvmCommTestResult = 153,
      eAvmCDataConfTestResult = 154,
      eAvmDDataConfTestResult = 155,
      eAvmAccOffDecounced = 156,

      // shifted by the generator postprocessor:
      // eCmdIncMsgReceived = 100,
      eCmdIncMsgReceived = 190,

      // dispvidctrl_tclAppMainIMsgDef: user specific code start
      // dispvidctrl_tclAppMainIMsgDef: user specific code end

      // shifted by the generator postprocessor:
      // eHeartbeat = 200,
      eHeartbeat = 240,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eCmdMCanChannelReady,
      eCmdMCanDataInd,
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[51];
      
      typedef struct {
          tU32 u32Len;
          tU8* pu8Data;
      }TDataTrailer;
      TDataTrailer tDataTrailer;
            
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[DISPVIDCTRLINTERNAL_MSG_LEN];
         typedef struct {
            tU16   u16MsgId;
            tU8    u8Opcode;
         } TMCanMsg;
         TMCanMsg tMCanMsg;

         // dispvidctrl_tclAppMainIMsgUnion: user specific code start
         // dispvidctrl_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   dispvidctrl_tclBaseIf(const dispvidctrl_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~dispvidctrl_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // dispvidctrl_tclAppMainBaseIfDecl: user specific code start
   virtual tVoid vGetReferencesEarly() {};
   virtual tVoid vStartCommunicationEarly() {};

   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
   // dispvidctrl_tclAppMainBaseIfDecl: user specific code end

};


class dispvidctrl_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static dispvidctrl_tclAppMain*   _poMainAppInstance;

public:
   static dispvidctrl_tclAppMain* theServer();    


   dispvidctrl_tclAppMain(tVoid);
   virtual ~dispvidctrl_tclAppMain(tVoid);
   tU8 getVariantInfo();
   tVoid _vDetermineVariantConfiguration();

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclAppMain& operator= (const dispvidctrl_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'dispvidctrl_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclAppMain(const dispvidctrl_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);   
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(dispvidctrl_tclBaseIf::TMsg* pInternalMsg);

#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostInternalMessage(dispvidctrl_tclBaseIf::TMsg* pInternalMsg);
#endif

   tVoid vAddObj(dispvidctrl_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(dispvidctrl_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStart();
   tBool _bStartPerformed;   
   tBool CameraStreamingActive;
   tBool ReverseGearStatusViaCAN;
   tBool ReverseGearStatusViaCMA;
   tBool ReverseCamRequest;
   tBool SafeState;
   tU8  m_variantInfo;
   tBool avroutingRvcConfiguration;
   tBool CANRvcConfiguration;
   tBool rvcConfigured;


   //reference handling for __ created objects
private:
   std::set<dispvidctrl_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   dispvidctrl_tclBaseIf*  getHandler(const tChar* cName) const{
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
         if (0 == OSAL_s32StringCompare((*iter)->getName(), cName)) {
            return (*iter);
         }         
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:
#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostMsgControl(const tChar* strIfName, tU32 u32Control);
   virtual tVoid vPostMsgControlAvm(const tChar* strIfName, tU32 u32ControlAvm);
   virtual tVoid vPostMsgControlHmi(const tChar* strIfName, tU32 u32ControlHmi);
   virtual tVoid vPostMsgControlRvc(const tChar* strIfName, tU32 u32ControlRvc);
   virtual tVoid vPostMsgControlMvc(const tChar* strIfName, tU32 u32ControlMvc);
   virtual tVoid vPostMsgControlFap(const tChar* strIfName, tU32 u32ControlFap);
   virtual tVoid vPostMsgControlVideo(const tChar* strIfName, tU32 u32ControlVideo);
   virtual tVoid vPostMsgControlModeDisabled(const tChar* strIfName, tU32 u32ControlModeDisabled);
   virtual tVoid vPostMsgControlModeEnabled(const tChar* strIfName, tU32 u32ControlModeEnabled);
   virtual tVoid vPostMsgDiagVideoLayer(const tChar* strIfName, tU32 u32DiagVideoLayer);
   virtual tVoid vPostMsgFsmAvm(const tChar* strIfName, tU32 u32FsmAvm);
   virtual tVoid vPostMsgFsmCameraSupply(const tChar* strIfName, tU32 u32FsmCameraSupply);
   virtual tVoid vPostMsgFsmCameraSupplySupervision(const tChar* strIfName, tU32 u32FsmCameraSupplySupervision);
   virtual tVoid vPostMsgFsmHmi(const tChar* strIfName, tU32 u32FsmHmi);
   virtual tVoid vPostMsgFsmIpaSwitchOperation(const tChar* strIfName, tU32 u32FsmIpaSwitchOperation);
   virtual tVoid vPostMsgFsmOnOff(const tChar* strIfName, tU32 u32FsmOnOff);
   virtual tVoid vPostMsgFsmReverseSignal(const tChar* strIfName, tU32 u32FsmReverseSignal);
   virtual tVoid vPostMsgFsmRvcScreen(const tChar* strIfName, tU32 u32FsmRvcScreen);
   virtual tVoid vPostMsgFsmMvc(const tChar* strIfName, tU32 u32FsmMvc);
   virtual tVoid vPostMsgReverseOff(const tChar* strIfName);
   virtual tVoid vPostMsgReverseOn(const tChar* strIfName);
   virtual tVoid vPostMsgReverseOnDebounced(const tChar* strIfName);
   virtual tVoid vPostMsgHmiVisualisationOff(const tChar* strIfName, tU32 u32HmiVisualisationOff);
   virtual tVoid vPostMsgHmiVisualisationOn(const tChar* strIfName);
   virtual tVoid vPostMsgHmiVisualisationOnCameraSettings(const tChar* strIfName);
   virtual tVoid vPostMsgVideoStatus(const tChar* strIfName, tU32 u32VideoStatus);
   virtual tVoid vPostMsgAvmNormalBeep(const tChar* strIfName, tBool bAvmNormalBeep);
   virtual tVoid vPostMsgAvmErrorBeep(const tChar* strIfName, tBool bAvmErrorBeep);
   virtual tVoid vPostMsgAvmCanMsgTimeoutFalse(const tChar* strIfName, tBool bAvmCanMsgTimeoutFalse);
   virtual tVoid vPostMsgAvmCanMsgTimeoutTrue(const tChar* strIfName, tBool bAvmCanMsgTimeoutTrue);
   virtual tVoid vPostMsgAvmAffordableIts(const tChar* strIfName, tBool bAvmAffordableIts);
   virtual tVoid vPostMsgAvmIpaConfigurationChange(const tChar* strIfName, tBool bAvmIpaConfigurationChange);
   virtual tVoid vPostMsgAvmIpaRequestNormal(const tChar* strIfName, tBool bAvmIpaRequestNormal);
   virtual tVoid vPostMsgAvmIpaRequestIpa(const tChar* strIfName, tBool bAvmIpaRequestIpa);
   virtual tVoid vPostMsgAvmIpaOperationNormal(const tChar* strIfName, tBool bAvmIpaOperationNormal);
   virtual tVoid vPostMsgAvmIpaOperationMalfunction(const tChar* strIfName, tBool bAvmIpaOperationMalfunction);
   virtual tVoid vPostMsgAvmIpaSwitchesChange(const tChar* strIfName, tBool bAvmIpaSwitchesChange);
   virtual tVoid vPostMsgAvmIpaRequestChange(const tChar* strIfName, tBool bAvmIpaRequestChange);
   virtual tVoid vPostMsgAvmIpaMsgCountErr(const tChar* strIfName, tBool bAvmIpaMsgCountErr);
   virtual tVoid vPostMsgAvmIpaDirectionChange(const tChar* strIfName, tBool bAvmIpaDirectionChange);
   virtual tVoid vPostMsgDimStateChanged(const tChar* strIfName, tU32 u32DimStateChanged);
   virtual tVoid vPostMsgDimModeChanged(const tChar* strIfName, tU8 u8DimModeChanged);
   virtual tVoid vPostMsgDimBrightnessChanged(const tChar* strIfName, tU8 u8DimBrightnessChanged);
   virtual tVoid vPostMsgDimCrLowVoltage(const tChar* strIfName);
   virtual tVoid vPostMsgDimHighVoltage(const tChar* strIfName);
   virtual tVoid vPostMsgDimNormalVoltage(const tChar* strIfName);
   virtual tVoid vPostMsgEmulationModeSet(const tChar* strIfName, tU8 u8EmulationModeSet);
   virtual tVoid vPostMsgDispBrightnessSet(const tChar* strIfName, tU16 u16DispBrightnessSet);
   virtual tVoid vPostMsgKeybBrightnessSet(const tChar* strIfName, tU16 u16KeybBrightnessSet);
   virtual tVoid vPostMsgPwmBrightnessGet(const tChar* strIfName);
   virtual tVoid vPostMsgVideoPlayerReady(const tChar* strIfName);
   virtual tVoid vPostMsgStartAnimation(const tChar* strIfName, tU8 u8StartAnimation);
   virtual tVoid vPostMsgStoptAnimation(const tChar* strIfName);
   virtual tVoid vPostMsgSyncStateTimeout(const tChar* strIfName);
   virtual tVoid vPostMsgSyncFirstFrame(const tChar* strIfName);
   virtual tVoid vPostMsgControlSyncHandler(const tChar* strIfName, tU32 u32ControlSyncHandler);
   virtual tVoid vPostMsgRvcCameraState(const tChar* strIfName);
   virtual tVoid vPostMsgMvcViewModeStatus(const tChar* strIfName, tU8 u8MvcViewModeStatus);
   virtual tVoid vPostMsgMvcWarningDisplayRequest(const tChar* strIfName, tU8 u8MvcWarningDisplayRequest);
   virtual tVoid vPostMsgTailGateStateChange(const tChar* strIfName, tU8 u8TailGateStateChange);
   virtual tVoid vPostMsgMvcCanMsgTimeoutFalse(const tChar* strIfName, tBool bMvcCanMsgTimeoutFalse);
   virtual tVoid vPostMsgMvcCanMsgTimeoutTrue(const tChar* strIfName, tBool bMvcCanMsgTimeoutTrue);
   virtual tVoid vPostMsgTriggerCanMsgConfirmTimeout(const tChar* strIfName, tBool bTriggerCanMsgConfirmTimeout);
   virtual tVoid vPostMsgFapModeActive(const tChar* strIfName, tU8 u8FapModeActive);
   virtual tVoid vPostMsgAccChanged(const tChar* strIfName, tBool bAccChanged);
   virtual tVoid vPostMsgIgnChanged(const tChar* strIfName, tBool bIgnChanged);
   virtual tVoid vPostMsgTriggerKDSChanged(const tChar* strIfName);
   virtual tVoid vPostMsgTriggerRecheckITC(const tChar* strIfName);
   virtual tVoid vPostMsgTriggerBerrUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgTriggerInputObserver(const tChar* strIfName, tU8 u8TriggerInputObserver);
   virtual tVoid vPostMsgTriggerSrvDimStartComDone(const tChar* strIfName);
   virtual tVoid vPostMsgAvm3FsmTrigger(const tChar* strIfName, tU32 u32Avm3FsmTrigger);
   virtual tVoid vPostMsgAvm3SwitchInput(const tChar* strIfName, tU32 u32Avm3SwitchInput);
   virtual tVoid vPostMsgControlHmiAvm3(const tChar* strIfName, tU32 u32ControlHmiAvm3);
   virtual tVoid vPostMsgFsmHmiAvm3(const tChar* strIfName, tU32 u32FsmHmiAvm3);
   virtual tVoid vPostMsgClientMcanAvm3(const tChar* strIfName, tU32 u32ClientMcanAvm3);
   virtual tVoid vPostMsgAvmConnected(const tChar* strIfName, tBool bAvmConnected);
   virtual tVoid vPostMsgAvmUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgAvmMsgSend(const tChar* strIfName, tU16 u16AvmMsgSend);
   virtual tVoid vPostMsgAvmCommTestResult(const tChar* strIfName);
   virtual tVoid vPostMsgAvmCDataConfTestResult(const tChar* strIfName);
   virtual tVoid vPostMsgAvmDDataConfTestResult(const tChar* strIfName);
   virtual tVoid vPostMsgAvmAccOffDecounced(const tChar* strIfName);
   virtual tVoid vPostMsgCmdIncMsgReceived(const tChar* strIfName, tU8* au8CmdIncMsgReceived, tU32 length);
   virtual tVoid vPostMsgReverseonDuringCameraisActive(const tChar* strIfName);
   virtual tVoid vPostMsgReverseOFFDuringCameraisActive(const tChar* strIfName);
#endif

   // dispvidctrl_tclAppMainDecl: user specific code start
public:
   tVoid vStartCommunicationEarly() const {
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunicationEarly();
      }
   }

   tVoid vGetReferencesEarly() const {
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferencesEarly();
      }
   }

   tVoid vWaitForVideoChainReady(tU32 u32Timeout);

   tVoid vGetEarlyConfig(TEarlyConfiguration& rEarlyConfig) const;

   tVoid SetCameraStreamingStatus(tBool status);
   tVoid SetReverseCamRequest(tBool status);
   tBool getReverseCamRequest();
   tVoid SetReverseGearStatusViaCAN(tBool status);
   tBool getCameraStreamingStatus();
   tBool getReverseGearStatusfromCAN();
   tVoid SetReverseGearStatusViaCMA(tBool status);
   tBool getReverseGearStatusfromCMA();
   tVoid SetSafeState(tBool status);
   tBool getSafeState();
   tVoid SetAvroutingRvcConfiguration(tBool status);
   tVoid SetCANRvcConfiguration(tBool status);
   tBool getAvroutingRvcConfiguration();
   tBool getCANRvcConfiguration();
   tBool getReverseConfiguredStatus();
   tVoid checkAndSetReverseConfiguration();

   static tVoid vWriteStartupLog(std::string strTrace, tU32 u32Data = 0xffffffff);
   static tVoid vAddStartUpEntry(std::string strEntry, tU32 u32Data);

   tVoid vHandleConfigUpdate() const;
   tVoid vSetDefaultEarlyConfig();

   tVoid vCheckOwnMessageQueueStatus(dispvidctrl_tclBaseIf::TMsg* pInternalMsg, OSAL_tMQueueHandle hWorkerMsgQueue) const;

private:
   tBool                   _bAppStateReached;
   OSAL_tMQueueHandle      _hWorkerMsgQueue;
   tBool                   _bTerminate;
   OSAL_tThreadID          _tThreadID;

   TEarlyConfiguration     _tEarlyConfig;
   TEarlyConfiguration     _tEarlyConfigDefault;
   tBool                   _bEarlyConfigValid;

   tVoid                   vCreateWorkerThread();
   static tVoid            dwThreadWork( tPVoid pvArg );

   TConfiguration          _stConfigurationValues;

private:
   void vReadEarlyConfig();

   tVoid _vDetermineConfiguration(TConfiguration& rStConfigurationValues) const;
   tVoid _vGetConfiguration(const TConfiguration* pStConfigurationValues) const {
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetConfiguration(pStConfigurationValues);
      }
   }

   // +++diaglib+++
   diaglib::tclServiceDiaglib*             m_poServiceDiaglib;
   // +++ Listeners you create +++
   dispvidctrl_tclDiagRoutineControlListener*   m_poRoutineControlListener;
   dispvidctrl_tclDiagIoControlListener*        m_poIoControlListener;
   dispvidctrl_tclDiagSystemSetListener*        m_poSystemSetListener;

   typedef struct TStartupTrace {
       tU32 u32TimeStamp;
       std::string strInfo;
       tU32 u32Data;
   }TStartupTrace;
   typedef std::vector < TStartupTrace > TMapStartupInvest;
   TMapStartupInvest        _oStartupInvestMap;

public:
   CSMInterface*  pGetCsmInterface();
   CSMInterface*  pGetCsmInterfaceAVM();
   const TConfiguration* pGetConfiguration(tVoid)  { return & _stConfigurationValues; }

private:
   CSMInterface*  _poCSMInterface;
   tBool          bAVMPhase3;

   // dispvidctrl_tclAppMainDecl: user specific code end
}; 

class tclMCanClientMsgInfo
{
private:
    tBool                   _bSendingInProgress;
    tU32                    _u32TimeStampSend;
    tU32                    _u32TimeStampReceived;
    tU32                    _u32DebounceIntervall;
    tU32                    _u32TimeStampTimeout;
    tU32                    _u32TimeStampSendEnabled;
    tU32                    _u32Timeout;
    tBool                   _bContentChanged;
    tBool                   _bEnabled;
    tBool                   _bConfiured;
    tBool                   _bForce;

public:
    typedef tBool (*T_SendFunction) (tVoid*);
    typedef tVoid (*T_TimeoutFunction) (tVoid*);
    T_SendFunction      pFuncSendMsg;
    T_TimeoutFunction   pFuncTimeoutMsg;

    std::vector < tU32 > _vecStateBlockedIn;
        
    tclMCanClientMsgInfo() :
        _bSendingInProgress(FALSE),
        _u32TimeStampSend(0),
        _u32TimeStampReceived(0),
        _u32DebounceIntervall(0),
        _u32TimeStampTimeout(0),
        _u32TimeStampSendEnabled(0),
        _u32Timeout(1500),
        _bContentChanged(TRUE),
        _bEnabled(TRUE),
        _bConfiured(TRUE),
        _bForce(FALSE),
         pFuncSendMsg(NULL),
         pFuncTimeoutMsg(NULL) {};
    virtual ~tclMCanClientMsgInfo() {};

    tVoid vSetTimeout(tU32 u32Timeout) {_u32Timeout = u32Timeout;}
    tVoid vStartTimeoutDetection() {
        _bSendingInProgress   = TRUE;
        _u32TimeStampTimeout  = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }
    tVoid vMsgSend() {
        _u32TimeStampSend     = OSAL_ClockGetElapsedTime();
        _bContentChanged      = FALSE;
        _u32TimeStampTimeout = _u32TimeStampSend + _u32DebounceIntervall;
        if ( (_u32DebounceIntervall != 0) && (_bForce)){
            _bContentChanged = TRUE;
        }
    }
    tVoid vMsgReceived(tBool bResetInSendingOnly = FALSE) {
        _bSendingInProgress = FALSE;
        if (!bResetInSendingOnly) _u32TimeStampReceived = OSAL_ClockGetElapsedTime();
    }
    tVoid vStartStatusSendPeriod() {
        _bEnabled = TRUE;
        _u32TimeStampSendEnabled = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }

    tU32 u32GetLastSendTimestamp() {return _u32TimeStampSend;}
    tU32 u32GetLastRcvTimestamp() {return _u32TimeStampReceived;}

    tU32 u32MsgTimeout() {return _u32TimeStampTimeout;}
    tU32 u32GetMsgSendPeriodTimeout() {return _u32TimeStampSendEnabled;}

    tBool bSendingInProgress() {return _bSendingInProgress;}
    tVoid vDataChanged() {_bContentChanged = TRUE;}
    tBool bIsDataChanged() {return _bContentChanged;}
    tVoid vClearDataChanged() {_bContentChanged = FALSE;}

    tBool bIsMsgEnabled() {return _bEnabled;}
    tVoid vSetMsgEnabled(tBool bEnabled) {_bEnabled = bEnabled;}

    tBool bIsMsgConfigured() {return _bConfiured;}
    tVoid vSetMsgConfigured(tBool bConfiured) {_bConfiured = bConfiured;}

    tVoid vSetDebounceIntervall(tU32 u32Intervall) {_u32DebounceIntervall = u32Intervall;}
    tVoid vSetForceSend(tBool bForce) {_bForce = bForce;}
};
#endif // _DISPVIDCTRLMAIN_H_

