/*****************************************************************************
* FILE:         dispvidctrl_AppMain.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     applMain.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclAppMainIncludes: user specific code start
#include "pdd.h"
#include "pdd_config_nor_user.h"

#include <boost/format.hpp>

// +++diaglib+++
#include "dispvidctrl_tclDiagRoutineControlListener.h"
#include "dispvidctrl_tclDiagIoControlListener.h"
#include "dispvidctrl_tclDiagSystemSetListener.h"

#include "I_dispvidctrl_tclSyncHandler.h"
#include "dispvidctrl_tclPersistentData.h"

#include "dispvidctrl_datapool.h"
#include "VD_EARLYNorData.h"

#include "Idispvidctrl_ClientAvmAdaptor.h"
#include "Idispvidctrl_ClientAvmFsm.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"


#include <sstream> 

//#define DISPVIDCTRL_KERNEL_LOG_DISABLED
//#define DISPVIDCTRL_STARTUP_INVET_LOG_DISABLED

// warning fill level of message own queue in percent
#define DISPVIDCTRL_QUEUE_MAXMSG 120
#define DISPVIDCTRL_QUEUE_FILL_LEVEL 80

// dispvidctrl_tclAppMainIncludes: user specific code end

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_AppMain.cpp.trc.h"
#endif

#define GENERIC_VARIANT 3
#define EVOBUS_VARIANT 4

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
dispvidctrl_tclAppMain* dispvidctrl_tclAppMain::_poMainAppInstance = NULL;

tUChar  dispvidctrl_tclAppMain::_auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE] = {0};

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::theServer()
* DESCRIPTION: Creates new server object by using the singleton pattern.
* PARAMETER  : None.
* RETURNVALUE: Pointer to the instance of this application.
*******************************************************************************/
dispvidctrl_tclAppMain* dispvidctrl_tclAppMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new dispvidctrl_tclAppMain();
   }
   return _poMainAppInstance;
}


/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclAppMain::dispvidctrl_tclAppMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclAppMain::dispvidctrl_tclAppMain():ahl_tclBaseOneThreadApp(CCA_C_U16_APP_DRVASS_VIDEO)
{
   ETG_TRACE_USR4(("dispvidctrl_tclAppMain() entered."));

   dispvidctrl_tclAppMain::_poMainAppInstance   = this;
   
   _bStartPerformed = FALSE;   
  
   // dispvidctrl_tclAppMainConstructor: user specific code start

   _poCSMInterface  = NULL;
   bAVMPhase3       = FALSE;
   //Note - _poCSMInterface is set as late as possible in pGetCsmInterface()

   // +++diaglib+++
   m_poServiceDiaglib         = OSAL_NULL;
   m_poRoutineControlListener = OSAL_NULL;
   m_poIoControlListener      = OSAL_NULL;
   m_poSystemSetListener      = OSAL_NULL;
   CameraStreamingActive = FALSE;
   ReverseGearStatusViaCAN =   FALSE;
   ReverseGearStatusViaCMA = FALSE;
   ReverseCamRequest = FALSE;
   m_variantInfo = 0;
   avroutingRvcConfiguration = FALSE;
   CANRvcConfiguration = FALSE;
   rvcConfigured = FALSE;
   _bAppStateReached          = FALSE;
   _hWorkerMsgQueue           = OSAL_C_INVALID_HANDLE;
   SafeState   = FALSE;
   
   // to avoid copying the objects in case of reallocation from push_back
   if (_poMainAppInstance)
      _poMainAppInstance->_oStartupInvestMap.reserve(100);
   
   vCreateWorkerThread();

   _bEarlyConfigValid         = FALSE;
   vReadEarlyConfig();

   bAVMPhase3 = (_tEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_PHASE3) ? TRUE : FALSE;

   memset(&_stConfigurationValues, 0x00, sizeof(_stConfigurationValues));
   
   ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::dispvidctrl_tclAppMain() exited."));

   // dispvidctrl_tclAppMainConstructor: user specific code end

   vTracePlugIn();
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclAppMain::~dispvidctrl_tclAppMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclAppMain::~dispvidctrl_tclAppMain()
{
   ETG_TRACE_USR4(("~dispvidctrl_tclAppMain() entered."));

   // --- unplug TTFIS trace ---
   vTraceUnplug();   

   // dispvidctrl_tclAppMainDestructor: user specific code start

   // +++diaglib+++
   m_poServiceDiaglib         = OSAL_NULL;
   m_poRoutineControlListener = OSAL_NULL;
   m_poIoControlListener      = OSAL_NULL;
   m_poSystemSetListener      = OSAL_NULL;

   // dispvidctrl_tclAppMainDestructor: user specific code end

   dispvidctrl_tclAppMain::_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclAppMain::vStart()
*
* DESCRIPTION:
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vStart(tVoid)
{

   if (!_bStartPerformed) {

      // dispvidctrl_tclAppMainvStart: user specific code start

       // collect relevant configuration and hold within an structure
       // call vGetConfiguration of all registered classes with pointer to structure as parameter
       // classes will hold required info in own member variables
       _vDetermineVariantConfiguration();
       _vDetermineConfiguration(_stConfigurationValues);
       
       if(_stConfigurationValues.bAvmType_Phase3 == TRUE) {
           bAVMPhase3 = TRUE;
       }

	   _vGetConfiguration(&_stConfigurationValues);

      // dispvidctrl_tclAppMainvStart: user specific code end
   
      vGetReferences();
      vStartCommunication();
      
       _bStartPerformed = TRUE;   
   }
}

/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclAppMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool dispvidctrl_tclAppMain::bOnInit()
{
   tBool bSuccess = TRUE;

   ETG_TRACE_USR4(("bOnInit() entered."));

   while (!_bStartPerformed) {
       OSAL_s32ThreadWait(100);
       ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::bOnInit(): vStart not called now --> wait."));
   }
   
   // dispvidctrl_tclAppMainbOnInit: user specific code start

   tU32 u32StartTime = OSAL_ClockGetElapsedTime();

   _bAppStateReached = TRUE;

   // +++diaglib+++  create temporary pointer for registering listener
   diaglib::tclRoutineControlIF* m_poRoutineCtrlIF;
   diaglib::tclIoControlIF*      m_poIoCtrlIF;
   diaglib::tclSystemSetIF*      m_poSystemSetIF;

   // +++diaglib+++  Create diaglib-service
   //---------------------------------------
   m_poServiceDiaglib = OSAL_NEW diaglib::tclServiceDiaglib(this, 0x01);
   if (NULL == m_poServiceDiaglib)
   {
      bSuccess = FALSE;
      NORMAL_M_ASSERT_ALWAYS();
   }
   else
   {
      ETG_TRACE_USR4((" MAIN-APP :: bOnInit(): ............................. DIAGLib service created!                "));

      // ROUTINE CTRL =======================================================

         // +++ Get RoutineCtrl Interface
         m_poRoutineCtrlIF = m_poServiceDiaglib->poGetRoutineCtrl();

         // +++ Create your listener objects here +++
         m_poRoutineControlListener = OSAL_NEW dispvidctrl_tclDiagRoutineControlListener(m_poRoutineCtrlIF, this);

         // +++ Register your listeners here +++
         if (m_poRoutineControlListener != NULL)
         {
             m_poRoutineCtrlIF->vRegisterListener( ROUTINEID_VIDE_SOUR_SELE, m_poRoutineControlListener );
         }

       // IOCONTROL CTRL =======================================================
   
         // +++ Get RoutineCtrl Interface
         m_poIoCtrlIF = m_poServiceDiaglib->poGetIoCtrl();
   
         // +++ Create your listener objects here +++
         m_poIoControlListener = OSAL_NEW dispvidctrl_tclDiagIoControlListener(m_poIoCtrlIF);
   
         // +++ Register your listeners here +++
         if (m_poIoControlListener != NULL)
         {
             m_poIoCtrlIF->vRegisterListener( IOCONTROLID_RVC_CONTROL_LINE, m_poIoControlListener );
             m_poIoCtrlIF->vRegisterListener( IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1, m_poIoControlListener );
             // NCG3D-13847: handle IO Control for Dimming
             m_poIoCtrlIF->vRegisterListener( IOCONTROLID_KEYBOARD_DIMMING, m_poIoControlListener );
             m_poIoCtrlIF->vRegisterListener( IOCONTROLID_KEYBOARD_PWM, m_poIoControlListener );
             m_poIoCtrlIF->vRegisterListener( IOCONTROLID_DISPLAY_DIMMING_U16, m_poIoControlListener );
             // NCG3D-72861: P-IVI: Touch_Controller_Reset_Command_Control, Incorrect response NRC 0x22
             m_poIoCtrlIF->vRegisterListener( IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY, m_poIoControlListener );
         }
   
      // SYSTEM SET =========================================================
   
         // +++ Get SysSet Interface
         m_poSystemSetIF = m_poServiceDiaglib->poGetSysSet();
   
         // +++ Create your listener objects here +++
         m_poSystemSetListener = OSAL_NEW dispvidctrl_tclDiagSystemSetListener(m_poSystemSetIF);
   
         // +++ Register your listeners here +++
         if (m_poSystemSetListener != NULL)
         {
             m_poSystemSetIF->vRegisterListener( SYSSETID_REAR_VIEW_CAME, diaglib::EN_TYPE_DEFAULT_TEF, m_poSystemSetListener );
             m_poSystemSetIF->vRegisterListener( SYSSETID_REAR_VIEW_CAME, diaglib::EN_TYPE_DEFAULT_HMI, m_poSystemSetListener );
             m_poSystemSetIF->vRegisterListener( SYSSETID_REAR_VIEW_CAME, diaglib::EN_TYPE_CODING,      m_poSystemSetListener );
             // additional for dimming
             m_poSystemSetIF->vRegisterListener( SYSSETID_DIMM, diaglib::EN_TYPE_DEFAULT_TEF, m_poSystemSetListener );
             m_poSystemSetIF->vRegisterListener( SYSSETID_DIMM, diaglib::EN_TYPE_DEFAULT_HMI, m_poSystemSetListener );
             m_poSystemSetIF->vRegisterListener( SYSSETID_DIMM, diaglib::EN_TYPE_CODING,      m_poSystemSetListener );
             m_poSystemSetIF->vRegisterListener( SYSSETID_DIMM, diaglib::EN_TYPE_CALIBRATION, m_poSystemSetListener );
             //ETG_TRACE_USR1((" MAIN-APP :: bOnInit(): ............................. DIAG SystemSet Listener registered!     "));
         }
   }
   dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: vOnInit done", OSAL_ClockGetElapsedTime() - u32StartTime);
   // dispvidctrl_tclAppMainbOnInit: user specific code end

   
   return bSuccess;
}

/********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState).
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
{
    if (u32AppState == AMT_C_U32_STATE_OFF) {
        // dispvidctrl_tclAppMainvOnNewAppStateOff: user specific code start
        vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", I_dispvidctrl_tclMCanClientAvmFsm::eEventOff | 0x80000000);
        // dispvidctrl_tclAppMainvOnNewAppStateOff: user specific code end
    } else {
        // dispvidctrl_tclAppMainvOnNewAppStateNotOff: user specific code start
        vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", I_dispvidctrl_tclMCanClientAvmFsm::eEventOff             );
        // dispvidctrl_tclAppMainvOnNewAppStateNotOff: user specific code end
    }
  
    // dispvidctrl_tclAppMainvOnNewAppState: user specific code start
    // dispvidctrl_tclAppMainvOnNewAppState: user specific code end

    ahl_tclBaseOneThreadApp::vOnNewAppState(u32OldAppState, u32AppState);
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclAppMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   // dispvidctrl_tclAppMainvOnApplicationClose: user specific code start
      // +++diaglib+++  Delete Diag handler
      if (m_poRoutineControlListener != NULL)
      {
         OSAL_DELETE m_poRoutineControlListener;
         m_poRoutineControlListener = NULL;
      }
      if (m_poIoControlListener != NULL)
      {
         OSAL_DELETE m_poIoControlListener;
         m_poIoControlListener = NULL;
      }
      if (m_poSystemSetListener != NULL)
      {
         OSAL_DELETE m_poSystemSetListener;
         m_poSystemSetListener = NULL;
      }
      if (m_poServiceDiaglib != NULL)
      {
         OSAL_DELETE m_poServiceDiaglib;
         m_poServiceDiaglib = NULL;
      }

   // dispvidctrl_tclAppMainvOnApplicationClose: user specific code end

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclAppMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer(id: %d) entered.", u16TimerId ));

   // dispvidctrl_tclAppMainvOnTimer: user specific code start
   // dispvidctrl_tclAppMainvOnTimer: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclAppMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));

   // dispvidctrl_tclAppMainvOnLoopback_entry: user specific code start
   // Audio routing lib messages will end throwing up asserts here.
   if (0x0095 != u16ServiceID)
   {
   // dispvidctrl_tclAppMainvOnLoopback_entry: user specific code end
   
   gm_tclStreamMessage oVisitorMsg(poMessage);

   dispvidctrl_tclBaseIf::TMsg oMsg;

   if (oVisitorMsg.u32GetDataSize() >= sizeof(oMsg)) {
      memcpy((tVoid*)&oMsg, oVisitorMsg.pcocGetData(), sizeof(oMsg));
      
      if (oMsg.eCmd != (dispvidctrl_tclBaseIf::ECmdTypes)poMessage->u16GetFunctionID()) {
         ETG_TRACE_FATAL(("vOnLoopbackService() failed. iFID = 0x%04x, cmd = 0x%04x.", (tU32)poMessage->u16GetFunctionID(), (tU32)oMsg.eCmd));
         NORMAL_M_ASSERT_ALWAYS();
      }
      else {
         //post message
         tU8* pu8MsgData = NULL;
         if ((oMsg.tDataTrailer.pu8Data != NULL) && (oMsg.tDataTrailer.u32Len != 0)) {
             pu8MsgData = new tU8[oMsg.tDataTrailer.u32Len];
             if (pu8MsgData != NULL) {
                 memcpy((tVoid*)pu8MsgData, oVisitorMsg.pcocGetData()+sizeof(oMsg), oMsg.tDataTrailer.u32Len);
                 oMsg.tDataTrailer.pu8Data = pu8MsgData;
             }

         }
         vDispatchInternalMsg(&oMsg);
         if (pu8MsgData != NULL) {
             delete[] pu8MsgData;
         }
      }
   }
   else {
      ETG_TRACE_FATAL(("vOnLoopbackService() failed. message data size = %d, internal message size = %d.", (tU32)oVisitorMsg.u32GetDataSize(), (tU32)sizeof(oMsg) ));
      NORMAL_M_ASSERT_ALWAYS();
   }

   // dispvidctrl_tclAppMainvOnLoopback_exit: user specific code start
   }
   // dispvidctrl_tclAppMainvOnLoopback_exit: user specific code end   
}


tVoid dispvidctrl_tclAppMain::vDispatchInternalMsg(dispvidctrl_tclBaseIf::TMsg* pInternalMsg)
{
   if (pInternalMsg->eCmd == dispvidctrl_tclBaseIf::eCmdTraceCmdReceived) {
      //vHandleTraceMessageGen(_auchTraceInputBuffer);
       vHandleTraceMessage(_auchTraceInputBuffer);
 
       std::set<dispvidctrl_tclBaseIf*>::iterator iter;
       for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
            (*iter)->vHandleTraceMessage(_auchTraceInputBuffer);
       }
   }
   else {
      std::set<dispvidctrl_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (pInternalMsg->strClassName[0] != 0) 
         {
            if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
            if (0 == OSAL_s32StringCompare((*iter)->getName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
         } else {
            (*iter)->vHandleMessage(pInternalMsg);
         }
      }
   }
}

#ifndef _CCA_APPLICATION_WO_SERVICE
tVoid dispvidctrl_tclAppMain::vPostInternalMessage(dispvidctrl_tclBaseIf::TMsg* pInternalMsg)
{
   ETG_TRACE_USR1(("dispvidctrl_tclAppMain::vPostInternalMessage(): post internal message '%d'.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
   
   // dispvidctrl_tclAppMainPostInternStartUserSpecificClassCode: user specific code start

   // check message queue state
   if (!_bAppStateReached && (_hWorkerMsgQueue != OSAL_C_INVALID_HANDLE)) {
      vCheckOwnMessageQueueStatus(pInternalMsg, _hWorkerMsgQueue);

      tS32  s32Ret = OSAL_s32MessageQueuePost(_hWorkerMsgQueue,
         (tCU8*)pInternalMsg,
         sizeof(dispvidctrl_tclBaseIf::TMsg), 
         OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST);

      if(s32Ret != OSAL_OK){
         ETG_TRACE_FATAL(("dispvidctrl_tclBaseIf::vPostInternalMessage(): post to worker thread failed."));
      }
   } else {
      vCheckOwnMessageQueueStatus(pInternalMsg, hGetMyInQueue());
   // dispvidctrl_tclAppMainPostInternStartUserSpecificClassCode: user specific code end

   tU32 u32DataLengthMsg = sizeof(dispvidctrl_tclBaseIf::TMsg);
   tU8* pu8MsgData = NULL;

   const tChar* pStreamMsg = (const tChar*)pInternalMsg;

   if ((pInternalMsg->tDataTrailer.pu8Data != NULL) && (pInternalMsg->tDataTrailer.u32Len != 0)) {
       u32DataLengthMsg = (tU32)sizeof(dispvidctrl_tclBaseIf::TMsg) + pInternalMsg->tDataTrailer.u32Len;

       pu8MsgData = new tU8[u32DataLengthMsg];

       if (pu8MsgData != NULL) {
           (tVoid)OSAL_pvMemoryCopy((tVoid*)&pu8MsgData[0], pInternalMsg, sizeof(dispvidctrl_tclBaseIf::TMsg));
           (tVoid)OSAL_pvMemoryCopy((tVoid*)&pu8MsgData[sizeof(dispvidctrl_tclBaseIf::TMsg)], pInternalMsg->tDataTrailer.pu8Data, pInternalMsg->tDataTrailer.u32Len);

           pStreamMsg = (const tChar*)pu8MsgData;
           ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::vPostInternalMessage(): send stream message '%d'.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
       }
   }

   gm_tclStreamMessage oStreamMsg(u16GetAppId(), u16GetAppId(), 0, 0, 65, (tU16)pInternalMsg->eCmd, AMT_C_U8_CCAMSG_OPCODE_SET, u32DataLengthMsg );
   if (OSAL_NULL != oStreamMsg.pu8GetSharedMemBase()) {
       oStreamMsg.vSetData((const tChar*)pStreamMsg);
       if ( oStreamMsg.bIsValid() ) {
          if (enPostMessage(&oStreamMsg, TRUE) != AIL_EN_N_NO_ERROR) {
             NORMAL_M_ASSERT_ALWAYS();
          }
       } else {
          NORMAL_M_ASSERT_ALWAYS();
       }
   } else {
      ETG_TRACE_ERRMEM(("dispvidctrl_tclAppMain::vPostInternalMessage(): message %d with data size %u bytes could not create! No shared memory.",
            ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pInternalMsg->eCmd), (tUInt)sizeof(dispvidctrl_tclBaseIf::TMsg) ));
   }

   if (pu8MsgData != NULL) {
       delete[] pu8MsgData;
   }
   // dispvidctrl_tclAppMainPostInternEndUserSpecificClassCode: user specific code start
   }
   // dispvidctrl_tclAppMainPostInternEndUserSpecificClassCode: user specific code end

}
#endif

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for dispvidctrl
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_DRIVER_ASSIST_VIDEO;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)dispvidctrl_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);
   }
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for dispvidctrl
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_DRIVER_ASSIST_VIDEO;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)dispvidctrl_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
      }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);
   }
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetReverseGearStatusViaCAN
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetReverseGearStatusViaCAN(tBool status)
{
	ETG_TRACE_USR4(("Recieved Reverse Gear Status via CAN is %d",status));
	ReverseGearStatusViaCAN = status;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetReverseGearStatusViaCMA
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetReverseGearStatusViaCMA(tBool status)
{
	ETG_TRACE_USR4(("Recieved Reverse Gear Status via CMA is %d",status));
	ReverseGearStatusViaCMA = status;
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetCameraStreamingStatus
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetCameraStreamingStatus(tBool status)
{
	ETG_TRACE_USR4(("Recieved Camera Status is %d",status));
	CameraStreamingActive = status;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getCameraStreamingStatus
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: Bool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getCameraStreamingStatus()
{
	return CameraStreamingActive;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetAvroutingRvcConfiguration
* DESCRIPTION:
* PARAMETER  :Bool
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetAvroutingRvcConfiguration(tBool status)
{
	ETG_TRACE_USR4(("SetAvrouting RVC Configuration %d",status));
	avroutingRvcConfiguration = status;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetCANRvcConfiguration
* DESCRIPTION:
* PARAMETER  :Bool
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetCANRvcConfiguration(tBool status)
{
        ETG_TRACE_USR4(("Set CAN Rvc Configuration %d",status));
        CANRvcConfiguration = status;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getAvroutingRvcConfiguration
* DESCRIPTION:
* PARAMETER  :None
* RETURNVALUE: Bool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getAvroutingRvcConfiguration()
{
        ETG_TRACE_USR4(("Avrouting Rvc Configurationvalue is  %d",avroutingRvcConfiguration));
	return avroutingRvcConfiguration;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getCANRvcConfiguration
* DESCRIPTION:
* PARAMETER  :None
* RETURNVALUE: Bool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getCANRvcConfiguration()
{
        ETG_TRACE_USR4(("CAN Rvc Configurationvalue is  %d",CANRvcConfiguration));
        return CANRvcConfiguration;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::checkAndSetReverseConfiguration
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: Void
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::checkAndSetReverseConfiguration()
{
    ETG_TRACE_USR4(("Check And Set Reverse Configuration for Variant %d",m_variantInfo));
    if((GENERIC_VARIANT == getVariantInfo()))
    {
	    if(true == getAvroutingRvcConfiguration())
	    {
		    rvcConfigured = true;
                    ETG_TRACE_USR4(("Reverse is configured for Generic Variant"));
	    }
	    else
	    {
		    rvcConfigured = false;
	    }
    }
    if(EVOBUS_VARIANT == getVariantInfo())
    {
	    if(true == getCANRvcConfiguration())
	    {
		    rvcConfigured = true;
                    ETG_TRACE_USR4(("Reverse is configured for Evobus Variant"));
	    }
	    else
	    {
		    rvcConfigured = false;
	    }
    }
  
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getReverseConfiguredStatus
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: Void
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getReverseConfiguredStatus()
{
    ETG_TRACE_USR4(("Reverse Configured status is %d",rvcConfigured));
    return rvcConfigured;
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetReverseCamRequest
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetReverseCamRequest(tBool status)
{
	ETG_TRACE_USR4(("Reverse Camera request Status is %d",status));
	ReverseCamRequest = status;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getReverseCamRequest
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: Bool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getReverseCamRequest()
{
	return ReverseCamRequest;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getReverseGearStatusfromCAN
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: Bool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getReverseGearStatusfromCAN()
{
	return ReverseGearStatusViaCAN;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetReverseGearStatusViaCMA
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: Bool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getReverseGearStatusfromCMA()
{
	return ReverseGearStatusViaCMA;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::SetSafeState
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::SetSafeState(tBool status)
{
	
	SafeState = status;
        ETG_TRACE_USR4(("Setting SafeState with value is %d",status));
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::getSafeState
* DESCRIPTION: 
* PARAMETER  : 
* RETURNVALUE: tBool
*******************************************************************************/
tBool dispvidctrl_tclAppMain::getSafeState()
{
	ETG_TRACE_USR4(("SafeState return Status is %d",SafeState));
	return SafeState;
}
tU8 dispvidctrl_tclAppMain::getVariantInfo()
{
	return m_variantInfo;
}
/*******************************************************************************
* FUNCTION   : dispvidctrl_tclAppMain::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::vTraceCallbackFunction(const tUChar* puchData)
{
#ifdef _CCA_APPLICATION_WO_SERVICE

   //dispvidctrl_tclAppMain::vHandleTraceMessageGen(puchData);
   dispvidctrl_tclAppMain::vHandleTraceMessage(puchData);
#else
   if (puchData[0] < TRACE_BUFFER_MAXSIZE) {
      ETG_TRACE_USR4(("vTraceCallbackFunction(), length of TTFis message=%u\n Data: %*p",puchData[0],ETG_LIST_LEN(puchData[0]), ETG_LIST_PTR_T8(&(puchData[1]))));
      memcpy(_auchTraceInputBuffer, puchData, puchData[0]+1);

      if (NULL != _poMainAppInstance) {
         dispvidctrl_tclBaseIf::TMsg oMsg;
         (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
         
         oMsg.eCmd = dispvidctrl_tclBaseIf::eCmdTraceCmdReceived;
         oMsg.strClassName[0]=0;
         oMsg.u.u32Data = 0;

         _poMainAppInstance->vPostInternalMessage(&oMsg);
      }
   } else {
      ETG_TRACE_ERR(("MAIN :: Input trace command too long"));
   }
#endif // _CCA_APPLICATION_WO_SERVICE
}

tVoid dispvidctrl_tclAppMain::vLoadRegistry() 
{
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procdispvidctrl.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/procdispvidctrl.reg'!"));

        } else {
            ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/procdispvidctrl.reg'!"));
        }
    }
    OSAL_s32IOClose(regHandle);
}

#ifndef _CCA_APPLICATION_WO_SERVICE

tVoid dispvidctrl_tclAppMain::vPostMsgControl(const tChar* strIfName, tU32 u32Control) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControl(): eControl message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControl;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32Control;
    // dispvidctrl_tclAppMain::vPostMsgControl: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControl: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlAvm(const tChar* strIfName, tU32 u32ControlAvm) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlAvm(): eControlAvm message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlAvm;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlAvm;
    // dispvidctrl_tclAppMain::vPostMsgControlAvm: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlAvm: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlHmi(const tChar* strIfName, tU32 u32ControlHmi) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlHmi(): eControlHmi message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlHmi;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlHmi;
    // dispvidctrl_tclAppMain::vPostMsgControlHmi: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlHmi: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlRvc(const tChar* strIfName, tU32 u32ControlRvc) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlRvc(): eControlRvc message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlRvc;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlRvc;
    // dispvidctrl_tclAppMain::vPostMsgControlRvc: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlRvc: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlMvc(const tChar* strIfName, tU32 u32ControlMvc) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlMvc(): eControlMvc message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlMvc;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlMvc;
    // dispvidctrl_tclAppMain::vPostMsgControlMvc: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlMvc: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlFap(const tChar* strIfName, tU32 u32ControlFap) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlFap(): eControlFap message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlFap;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlFap;
    // dispvidctrl_tclAppMain::vPostMsgControlFap: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlFap: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlVideo(const tChar* strIfName, tU32 u32ControlVideo) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlVideo(): eControlVideo message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlVideo;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlVideo;
    // dispvidctrl_tclAppMain::vPostMsgControlVideo: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlVideo: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlModeDisabled(const tChar* strIfName, tU32 u32ControlModeDisabled) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlModeDisabled(): eControlModeDisabled message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlModeDisabled;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlModeDisabled;
    // dispvidctrl_tclAppMain::vPostMsgControlModeDisabled: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlModeDisabled: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlModeEnabled(const tChar* strIfName, tU32 u32ControlModeEnabled) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlModeEnabled(): eControlModeEnabled message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlModeEnabled;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlModeEnabled;
    // dispvidctrl_tclAppMain::vPostMsgControlModeEnabled: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlModeEnabled: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgDiagVideoLayer(const tChar* strIfName, tU32 u32DiagVideoLayer) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDiagVideoLayer(): eDiagVideoLayer message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDiagVideoLayer;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32DiagVideoLayer;
    // dispvidctrl_tclAppMain::vPostMsgDiagVideoLayer: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgDiagVideoLayer: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmAvm(const tChar* strIfName, tU32 u32FsmAvm) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmAvm(): eFsmAvm message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmAvm;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmAvm;
    // dispvidctrl_tclAppMain::vPostMsgFsmAvm: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmAvm: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmCameraSupply(const tChar* strIfName, tU32 u32FsmCameraSupply) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmCameraSupply(): eFsmCameraSupply message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmCameraSupply;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmCameraSupply;
    // dispvidctrl_tclAppMain::vPostMsgFsmCameraSupply: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmCameraSupply: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmCameraSupplySupervision(const tChar* strIfName, tU32 u32FsmCameraSupplySupervision) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmCameraSupplySupervision(): eFsmCameraSupplySupervision message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmCameraSupplySupervision;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmCameraSupplySupervision;
    // dispvidctrl_tclAppMain::vPostMsgFsmCameraSupplySupervision: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmCameraSupplySupervision: user specific code end
    vPostInternalMessage(&oMsg);
}

tVoid dispvidctrl_tclAppMain::vPostMsgReverseonDuringCameraisActive(const tChar* strIfName)
{
	//ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgReverseonDuringCameraisActive() '%50s'", strIfName));
	ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgReverseonDuringCameraisActive(): eReverseOnDebounced message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eReverseOnDebounced;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgReverseOnDebounced: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgReverseOnDebounced: user specific code end
    vPostInternalMessage(&oMsg);
}

tVoid dispvidctrl_tclAppMain::vPostMsgReverseOFFDuringCameraisActive(const tChar* strIfName)
{
	ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgReverseOFFDuringCameraisActive(): eReverseOnDebounced message to '%50s'", strIfName));

	dispvidctrl_tclBaseIf::TMsg oMsg;
        (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
        oMsg.eCmd = dispvidctrl_tclBaseIf::eReverseOff;
        OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgReverseOff: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgReverseOff: user specific code end
        vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmHmi(const tChar* strIfName, tU32 u32FsmHmi) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmHmi(): eFsmHmi message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmHmi;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmHmi;
    // dispvidctrl_tclAppMain::vPostMsgFsmHmi: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmHmi: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmIpaSwitchOperation(const tChar* strIfName, tU32 u32FsmIpaSwitchOperation) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmIpaSwitchOperation(): eFsmIpaSwitchOperation message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmIpaSwitchOperation;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmIpaSwitchOperation;
    // dispvidctrl_tclAppMain::vPostMsgFsmIpaSwitchOperation: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmIpaSwitchOperation: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmOnOff(const tChar* strIfName, tU32 u32FsmOnOff) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmOnOff(): eFsmOnOff message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmOnOff;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmOnOff;
    // dispvidctrl_tclAppMain::vPostMsgFsmOnOff: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmOnOff: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmReverseSignal(const tChar* strIfName, tU32 u32FsmReverseSignal) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmReverseSignal(): eFsmReverseSignal message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmReverseSignal;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmReverseSignal;
    // dispvidctrl_tclAppMain::vPostMsgFsmReverseSignal: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmReverseSignal: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmRvcScreen(const tChar* strIfName, tU32 u32FsmRvcScreen) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmRvcScreen(): eFsmRvcScreen message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmRvcScreen;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmRvcScreen;
    // dispvidctrl_tclAppMain::vPostMsgFsmRvcScreen: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmRvcScreen: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmMvc(const tChar* strIfName, tU32 u32FsmMvc) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmMvc(): eFsmMvc message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmMvc;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmMvc;
    // dispvidctrl_tclAppMain::vPostMsgFsmMvc: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmMvc: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgReverseOff(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgReverseOff(): eReverseOff message to '%50s'", strIfName));
	
        dispvidctrl_tclBaseIf::TMsg oMsg;
        (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
        oMsg.eCmd = dispvidctrl_tclBaseIf::eReverseOff;
        OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgReverseOff: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgReverseOff: user specific code end
        vPostInternalMessage(&oMsg);
	
}
tVoid dispvidctrl_tclAppMain::vPostMsgReverseOn(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgReverseOn(): eReverseOn message to '%50s'", strIfName));
	
		 dispvidctrl_tclBaseIf::TMsg oMsg;
		 (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
		 oMsg.eCmd = dispvidctrl_tclBaseIf::eReverseOn;
         OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgReverseOn: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgReverseOn: user specific code end
         vPostInternalMessage(&oMsg);
	
}
tVoid dispvidctrl_tclAppMain::vPostMsgReverseOnDebounced(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgReverseOnDebounced(): eReverseOnDebounced message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eReverseOnDebounced;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgReverseOnDebounced: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgReverseOnDebounced: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOff(const tChar* strIfName, tU32 u32HmiVisualisationOff) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOff(): eHmiVisualisationOff message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eHmiVisualisationOff;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32HmiVisualisationOff;
    // dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOff: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOff: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOn(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOn(): eHmiVisualisationOn message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eHmiVisualisationOn;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOn: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOn: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOnCameraSettings(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOnCameraSettings(): eHmiVisualisationOnCameraSettings message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eHmiVisualisationOnCameraSettings;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOnCameraSettings: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgHmiVisualisationOnCameraSettings: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgVideoStatus(const tChar* strIfName, tU32 u32VideoStatus) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgVideoStatus(): eVideoStatus message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eVideoStatus;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32VideoStatus;
    // dispvidctrl_tclAppMain::vPostMsgVideoStatus: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgVideoStatus: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmNormalBeep(const tChar* strIfName, tBool bAvmNormalBeep) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmNormalBeep(): eAvmNormalBeep message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmNormalBeep;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmNormalBeep;
    // dispvidctrl_tclAppMain::vPostMsgAvmNormalBeep: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmNormalBeep: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmErrorBeep(const tChar* strIfName, tBool bAvmErrorBeep) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmErrorBeep(): eAvmErrorBeep message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmErrorBeep;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmErrorBeep;
    // dispvidctrl_tclAppMain::vPostMsgAvmErrorBeep: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmErrorBeep: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutFalse(const tChar* strIfName, tBool bAvmCanMsgTimeoutFalse) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutFalse(): eAvmCanMsgTimeoutFalse message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmCanMsgTimeoutFalse;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmCanMsgTimeoutFalse;
    // dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutFalse: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutFalse: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutTrue(const tChar* strIfName, tBool bAvmCanMsgTimeoutTrue) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutTrue(): eAvmCanMsgTimeoutTrue message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmCanMsgTimeoutTrue;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmCanMsgTimeoutTrue;
    // dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutTrue: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmCanMsgTimeoutTrue: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmAffordableIts(const tChar* strIfName, tBool bAvmAffordableIts) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmAffordableIts(): eAvmAffordableIts message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmAffordableIts;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmAffordableIts;
    // dispvidctrl_tclAppMain::vPostMsgAvmAffordableIts: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmAffordableIts: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaConfigurationChange(const tChar* strIfName, tBool bAvmIpaConfigurationChange) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaConfigurationChange(): eAvmIpaConfigurationChange message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaConfigurationChange;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaConfigurationChange;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaConfigurationChange: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaConfigurationChange: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestNormal(const tChar* strIfName, tBool bAvmIpaRequestNormal) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestNormal(): eAvmIpaRequestNormal message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaRequestNormal;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaRequestNormal;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestNormal: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestNormal: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestIpa(const tChar* strIfName, tBool bAvmIpaRequestIpa) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestIpa(): eAvmIpaRequestIpa message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaRequestIpa;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaRequestIpa;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestIpa: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestIpa: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationNormal(const tChar* strIfName, tBool bAvmIpaOperationNormal) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationNormal(): eAvmIpaOperationNormal message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaOperationNormal;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaOperationNormal;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationNormal: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationNormal: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationMalfunction(const tChar* strIfName, tBool bAvmIpaOperationMalfunction) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationMalfunction(): eAvmIpaOperationMalfunction message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaOperationMalfunction;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaOperationMalfunction;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationMalfunction: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaOperationMalfunction: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaSwitchesChange(const tChar* strIfName, tBool bAvmIpaSwitchesChange) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaSwitchesChange(): eAvmIpaSwitchesChange message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaSwitchesChange;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaSwitchesChange;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaSwitchesChange: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaSwitchesChange: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestChange(const tChar* strIfName, tBool bAvmIpaRequestChange) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestChange(): eAvmIpaRequestChange message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaRequestChange;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaRequestChange;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestChange: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaRequestChange: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaMsgCountErr(const tChar* strIfName, tBool bAvmIpaMsgCountErr) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaMsgCountErr(): eAvmIpaMsgCountErr message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaMsgCountErr;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaMsgCountErr;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaMsgCountErr: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaMsgCountErr: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmIpaDirectionChange(const tChar* strIfName, tBool bAvmIpaDirectionChange) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmIpaDirectionChange(): eAvmIpaDirectionChange message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmIpaDirectionChange;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmIpaDirectionChange;
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaDirectionChange: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmIpaDirectionChange: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgDimStateChanged(const tChar* strIfName, tU32 u32DimStateChanged) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDimStateChanged(): eDimStateChanged message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDimStateChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32DimStateChanged;
    // dispvidctrl_tclAppMain::vPostMsgDimStateChanged: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgDimStateChanged: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgDimModeChanged(const tChar* strIfName, tU8 u8DimModeChanged) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDimModeChanged(): eDimModeChanged message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDimModeChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8DimModeChanged;
    // dispvidctrl_tclAppMain::vPostMsgDimModeChanged: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgDimModeChanged: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgDimBrightnessChanged(const tChar* strIfName, tU8 u8DimBrightnessChanged) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDimBrightnessChanged(): eDimBrightnessChanged message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDimBrightnessChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8DimBrightnessChanged;
    // dispvidctrl_tclAppMain::vPostMsgDimBrightnessChanged: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgDimBrightnessChanged: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgDimCrLowVoltage(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDimCrLowVoltage(): eDimCrLowVoltage message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDimCrLowVoltage;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgDimCrLowVoltage: user specific code start
    // note: vPostInternalMessage() below was commented out in checked-in code, which has obviously been a manual modification (why???); we mimick this by the following:
    if(NULL==&oMsg)  // "morally" equivalent to "if(0)", but (hopefully) compiler and/or lint won't complain about unreachable code
    // dispvidctrl_tclAppMain::vPostMsgDimCrLowVoltage: user specific code end
	{
	}
   ////////////////////////// vPostInternalMessage(&oMsg);
   
	//CID: 90906
	//The above func call vPostInternalMessage(); is commented to resolve coverity issue. as the code is logically dead code 
	
}
tVoid dispvidctrl_tclAppMain::vPostMsgDimHighVoltage(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDimHighVoltage(): eDimHighVoltage message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDimHighVoltage;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgDimHighVoltage: user specific code start
    // note: vPostInternalMessage() below was commented out in checked-in code, which has obviously been a manual modification (why???); we mimick this by the following:
    if(NULL==&oMsg)  // "morally" equivalent to "if(0)", but (hopefully) compiler and/or lint won't complain about unreachable code
    // dispvidctrl_tclAppMain::vPostMsgDimHighVoltage: user specific code end
	{
	}
 
	////////////////////////////////////  vPostInternalMessage(&oMsg);
	//CID: 90905
	//The above func call vPostInternalMessage(); is commented to resolve coverity issue. as the code is logically dead code 
	
}
tVoid dispvidctrl_tclAppMain::vPostMsgDimNormalVoltage(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDimNormalVoltage(): eDimNormalVoltage message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDimNormalVoltage;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgDimNormalVoltage: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgDimNormalVoltage: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgEmulationModeSet(const tChar* strIfName, tU8 u8EmulationModeSet) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgEmulationModeSet(): eEmulationModeSet message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eEmulationModeSet;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8EmulationModeSet;
    // dispvidctrl_tclAppMain::vPostMsgEmulationModeSet: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgEmulationModeSet: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgDispBrightnessSet(const tChar* strIfName, tU16 u16DispBrightnessSet) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgDispBrightnessSet(): eDispBrightnessSet message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eDispBrightnessSet;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u16Data = u16DispBrightnessSet;
    // dispvidctrl_tclAppMain::vPostMsgDispBrightnessSet: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgDispBrightnessSet: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgKeybBrightnessSet(const tChar* strIfName, tU16 u16KeybBrightnessSet) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgKeybBrightnessSet(): eKeybBrightnessSet message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eKeybBrightnessSet;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u16Data = u16KeybBrightnessSet;
    // dispvidctrl_tclAppMain::vPostMsgKeybBrightnessSet: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgKeybBrightnessSet: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgPwmBrightnessGet(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgPwmBrightnessGet(): ePwmBrightnessGet message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::ePwmBrightnessGet;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgPwmBrightnessGet: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgPwmBrightnessGet: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgVideoPlayerReady(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgVideoPlayerReady(): eVideoPlayerReady message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eVideoPlayerReady;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgVideoPlayerReady: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgVideoPlayerReady: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgStartAnimation(const tChar* strIfName, tU8 u8StartAnimation) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgStartAnimation(): eStartAnimation message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eStartAnimation;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8StartAnimation;
    // dispvidctrl_tclAppMain::vPostMsgStartAnimation: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgStartAnimation: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgStoptAnimation(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgStoptAnimation(): eStoptAnimation message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eStoptAnimation;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgStoptAnimation: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgStoptAnimation: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgSyncStateTimeout(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgSyncStateTimeout(): eSyncStateTimeout message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eSyncStateTimeout;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgSyncStateTimeout: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgSyncStateTimeout: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgSyncFirstFrame(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgSyncFirstFrame(): eSyncFirstFrame message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eSyncFirstFrame;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgSyncFirstFrame: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgSyncFirstFrame: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlSyncHandler(const tChar* strIfName, tU32 u32ControlSyncHandler) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlSyncHandler(): eControlSyncHandler message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlSyncHandler;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlSyncHandler;
    // dispvidctrl_tclAppMain::vPostMsgControlSyncHandler: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlSyncHandler: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgRvcCameraState(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgRvcCameraState(): eRvcCameraState message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eRvcCameraState;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgRvcCameraState: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgRvcCameraState: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgMvcViewModeStatus(const tChar* strIfName, tU8 u8MvcViewModeStatus) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgMvcViewModeStatus(): eMvcViewModeStatus message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eMvcViewModeStatus;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8MvcViewModeStatus;
    // dispvidctrl_tclAppMain::vPostMsgMvcViewModeStatus: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgMvcViewModeStatus: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgMvcWarningDisplayRequest(const tChar* strIfName, tU8 u8MvcWarningDisplayRequest) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgMvcWarningDisplayRequest(): eMvcWarningDisplayRequest message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eMvcWarningDisplayRequest;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8MvcWarningDisplayRequest;
    // dispvidctrl_tclAppMain::vPostMsgMvcWarningDisplayRequest: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgMvcWarningDisplayRequest: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTailGateStateChange(const tChar* strIfName, tU8 u8TailGateStateChange) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTailGateStateChange(): eTailGateStateChange message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTailGateStateChange;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8TailGateStateChange;
    // dispvidctrl_tclAppMain::vPostMsgTailGateStateChange: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTailGateStateChange: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutFalse(const tChar* strIfName, tBool bMvcCanMsgTimeoutFalse) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutFalse(): eMvcCanMsgTimeoutFalse message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eMvcCanMsgTimeoutFalse;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bMvcCanMsgTimeoutFalse;
    // dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutFalse: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutFalse: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutTrue(const tChar* strIfName, tBool bMvcCanMsgTimeoutTrue) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutTrue(): eMvcCanMsgTimeoutTrue message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eMvcCanMsgTimeoutTrue;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bMvcCanMsgTimeoutTrue;
    // dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutTrue: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgMvcCanMsgTimeoutTrue: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTriggerCanMsgConfirmTimeout(const tChar* strIfName, tBool bTriggerCanMsgConfirmTimeout) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTriggerCanMsgConfirmTimeout(): eTriggerCanMsgConfirmTimeout message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerCanMsgConfirmTimeout;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bTriggerCanMsgConfirmTimeout;
    // dispvidctrl_tclAppMain::vPostMsgTriggerCanMsgConfirmTimeout: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTriggerCanMsgConfirmTimeout: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFapModeActive(const tChar* strIfName, tU8 u8FapModeActive) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFapModeActive(): eFapModeActive message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFapModeActive;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8FapModeActive;
    // dispvidctrl_tclAppMain::vPostMsgFapModeActive: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFapModeActive: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAccChanged(const tChar* strIfName, tBool bAccChanged) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAccChanged(): eAccChanged message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAccChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAccChanged;
    // dispvidctrl_tclAppMain::vPostMsgAccChanged: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAccChanged: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgIgnChanged(const tChar* strIfName, tBool bIgnChanged) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgIgnChanged(): eIgnChanged message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eIgnChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bIgnChanged;
    // dispvidctrl_tclAppMain::vPostMsgIgnChanged: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgIgnChanged: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTriggerKDSChanged(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTriggerKDSChanged(): eTriggerKDSChanged message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerKDSChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgTriggerKDSChanged: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTriggerKDSChanged: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTriggerRecheckITC(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTriggerRecheckITC(): eTriggerRecheckITC message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerRecheckITC;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgTriggerRecheckITC: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTriggerRecheckITC: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTriggerBerrUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTriggerBerrUpdate(): eTriggerBerrUpdate message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerBerrUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgTriggerBerrUpdate: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTriggerBerrUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTriggerInputObserver(const tChar* strIfName, tU8 u8TriggerInputObserver) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTriggerInputObserver(): eTriggerInputObserver message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerInputObserver;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u8Data = u8TriggerInputObserver;
    // dispvidctrl_tclAppMain::vPostMsgTriggerInputObserver: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTriggerInputObserver: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgTriggerSrvDimStartComDone(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgTriggerSrvDimStartComDone(): eTriggerSrvDimStartComDone message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerSrvDimStartComDone;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgTriggerSrvDimStartComDone: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgTriggerSrvDimStartComDone: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvm3FsmTrigger(const tChar* strIfName, tU32 u32Avm3FsmTrigger) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvm3FsmTrigger(): eAvm3FsmTrigger message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvm3FsmTrigger;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32Avm3FsmTrigger;
    // dispvidctrl_tclAppMain::vPostMsgAvm3FsmTrigger: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvm3FsmTrigger: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvm3SwitchInput(const tChar* strIfName, tU32 u32Avm3SwitchInput) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvm3SwitchInput(): eAvm3SwitchInput message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvm3SwitchInput;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32Avm3SwitchInput;
    // dispvidctrl_tclAppMain::vPostMsgAvm3SwitchInput: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvm3SwitchInput: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgControlHmiAvm3(const tChar* strIfName, tU32 u32ControlHmiAvm3) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgControlHmiAvm3(): eControlHmiAvm3 message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eControlHmiAvm3;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ControlHmiAvm3;
    // dispvidctrl_tclAppMain::vPostMsgControlHmiAvm3: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgControlHmiAvm3: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgFsmHmiAvm3(const tChar* strIfName, tU32 u32FsmHmiAvm3) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgFsmHmiAvm3(): eFsmHmiAvm3 message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eFsmHmiAvm3;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32FsmHmiAvm3;
    // dispvidctrl_tclAppMain::vPostMsgFsmHmiAvm3: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgFsmHmiAvm3: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgClientMcanAvm3(const tChar* strIfName, tU32 u32ClientMcanAvm3) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgClientMcanAvm3(): eClientMcanAvm3 message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eClientMcanAvm3;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ClientMcanAvm3;
    // dispvidctrl_tclAppMain::vPostMsgClientMcanAvm3: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgClientMcanAvm3: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmConnected(const tChar* strIfName, tBool bAvmConnected) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmConnected(): eAvmConnected message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmConnected;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.bData = bAvmConnected;
    // dispvidctrl_tclAppMain::vPostMsgAvmConnected: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmConnected: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmUpdate(): eAvmUpdate message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgAvmUpdate: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmMsgSend(const tChar* strIfName, tU16 u16AvmMsgSend) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmMsgSend(): eAvmMsgSend message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmMsgSend;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u16Data = u16AvmMsgSend;
    // dispvidctrl_tclAppMain::vPostMsgAvmMsgSend: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmMsgSend: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmCommTestResult(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmCommTestResult(): eAvmCommTestResult message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmCommTestResult;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgAvmCommTestResult: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmCommTestResult: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmCDataConfTestResult(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmCDataConfTestResult(): eAvmCDataConfTestResult message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmCDataConfTestResult;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgAvmCDataConfTestResult: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmCDataConfTestResult: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmDDataConfTestResult(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmDDataConfTestResult(): eAvmDDataConfTestResult message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmDDataConfTestResult;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgAvmDDataConfTestResult: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmDDataConfTestResult: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgAvmAccOffDecounced(const tChar* strIfName) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgAvmAccOffDecounced(): eAvmAccOffDecounced message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eAvmAccOffDecounced;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // dispvidctrl_tclAppMain::vPostMsgAvmAccOffDecounced: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgAvmAccOffDecounced: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid dispvidctrl_tclAppMain::vPostMsgCmdIncMsgReceived(const tChar* strIfName, tU8* au8CmdIncMsgReceived, tU32 length) {

    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vPostMsgCmdIncMsgReceived(): eCmdIncMsgReceived message to '%50s'", strIfName));

    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eCmdIncMsgReceived;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    
    if (length <= DISPVIDCTRLINTERNAL_MSG_LEN) {
        (tVoid)OSAL_pvMemoryCopy(oMsg.u.au8Data, au8CmdIncMsgReceived, length);
        // dispvidctrl_tclAppMain::vPostMsgCmdIncMsgReceived: user specific code start
    // dispvidctrl_tclAppMain::vPostMsgCmdIncMsgReceived: user specific code end
    vPostInternalMessage(&oMsg);
    } else {
        ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::vPostMsgCmdIncMsgReceived::sendMessage(): Failed to send. Message to long!!!"));
    }
    
}
#endif

// dispvidctrl_tclAppMainUserSpecificClassCode: user specific code start
/******************************************************************************/
/* FUNCTION     _vDetermineConfiguration                                      */
/******************************************************************************/
tVoid dispvidctrl_tclAppMain::_vDetermineVariantConfiguration()
{
	 tU8 variantInfo = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("AIVIVariantCoding", "SystemTypeSelector", &variantInfo, 1))
   {
      ETG_TRACE_USR4(("VariantHandling::variant is ::%d", variantInfo));
      m_variantInfo = variantInfo;
   }
   else
   {
      ETG_TRACE_FATAL(("Failed to Read Variant Info from Kds"));
   }

}
/******************************************************************************/
/* FUNCTION     _vDetermineConfiguration                                      */
/******************************************************************************/
/**
*  \brief       determines relevant configuration details
*               from KDS configuration entries
*               - camera system configuration (RVC/AVM)
*               - guideline configuration
*               - brightness configuration
*               - display size
*               - steering position
*               - RVC warning text background
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclAppMain::_vDetermineConfiguration(TConfiguration& rStConfigurationValues) const
{
   //set default values within configuration value structure
   rStConfigurationValues.u8Brand = 1;
   rStConfigurationValues.u8OpeningAnimation = 1;
   rStConfigurationValues.u8DisplayAspectRatio = 2;
   rStConfigurationValues.u8DisplayType = 0;
   rStConfigurationValues.u16VehicleType = 0x4250;
   rStConfigurationValues.u16DestinationRegion = 0;
   //rStConfigurationValues.u8DisplayOutput = 0;
   rStConfigurationValues.u8DisplayOrientation = 0;
   rStConfigurationValues.u8CameraSystemType     = 0x3;//0;//0x3;
   rStConfigurationValues.u8CameraConnectionType = 0x1;//0;//0x1;
   rStConfigurationValues.u8CameraSteeringMessageType = 0;
   rStConfigurationValues.u8DeviceVariantType = 0x1;
   rStConfigurationValues.bRvcMode          = TRUE;//FALSE;
   rStConfigurationValues.bAvmMode          = FALSE;
   rStConfigurationValues.bMvcMode          = FALSE;
   rStConfigurationValues.bAvmType_Entry    = FALSE;
   rStConfigurationValues.bAvmType_Ipa      = FALSE;
   rStConfigurationValues.bAvmType_Fap      = FALSE;
   rStConfigurationValues.bAvmType_Phase3   = FALSE;
   rStConfigurationValues.bAvmType_Renault  = FALSE;
   rStConfigurationValues.bRvcType_Renault  = FALSE;
   rStConfigurationValues.bStaticGuideline  = FALSE;
   rStConfigurationValues.bCentreGuideline  = FALSE;
   rStConfigurationValues.bAnticipatoryLine = FALSE;
   rStConfigurationValues.bLeftHandSteeringPosition   = TRUE;
   rStConfigurationValues.bBlackWarningTextBackground = 0x0;
   rStConfigurationValues.bManualTransmission = FALSE;
   rStConfigurationValues.u8BrightnessDay   = 50;
   rStConfigurationValues.u8BrightnessNight = 50;
   rStConfigurationValues.u8DisplaySize = DISPVIDCTRL_DISPLAY_SIZE_7_INCH;
   rStConfigurationValues.u8RvcLensParameterSet = 0;
   
#ifndef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   rStConfigurationValues.u32DisplayResolutionWidth = 0x320;
   rStConfigurationValues.u32DisplayResolutionHeight = 0x1e0;
   rStConfigurationValues.u32DisplayTwoResolutionWidth = 0x0;
   rStConfigurationValues.u32DisplayTwoResolutionHeight = 0x0;
#else
   rStConfigurationValues.u32DisplayResolutionWidth = 1280;
   rStConfigurationValues.u32DisplayResolutionHeight = 768;
   rStConfigurationValues.u32DisplayTwoResolutionWidth = 1280;
   rStConfigurationValues.u32DisplayTwoResolutionHeight = 768;
#endif

   (tVoid) OSAL_pvMemorySet(&rStConfigurationValues.VehicleParameter[0], 0x00, sizeof(rStConfigurationValues.VehicleParameter)); 
#ifdef VARIANT_S_FTR_ENABLE_SMART   
   rStConfigurationValues.u8VCANDiversity = 0x1;
   #else
      rStConfigurationValues.u8VCANDiversity = 0x5;
  #endif
   rStConfigurationValues.u8CameraVideoHoldingTime = 0;
   rStConfigurationValues.u8CameraRearTrunkBehaviour = 0;
   rStConfigurationValues.u8ReverseGearDebouncing = 0x0;
   rStConfigurationValues.u8CropUp = 0;
   rStConfigurationValues.u8CropDown = 0;
   rStConfigurationValues.u8CropLeft = 0;
   rStConfigurationValues.u8CropRight = 0;
   rStConfigurationValues.u8CameraImageMirror = 0;
   rStConfigurationValues.u8WelcomeSequence = 0;
   (tVoid) OSAL_pvMemorySet(&rStConfigurationValues.Resolution[0], 0x00, sizeof(rStConfigurationValues.Resolution));
   rStConfigurationValues.DisplayOrder[0] = 1;
   rStConfigurationValues.DisplayOrder[1] = 2;
   rStConfigurationValues.DisplayOrder[2] = 3;
   rStConfigurationValues.DisplayOrder[3] = 0;
   (tVoid) OSAL_pvMemorySet(&rStConfigurationValues.FlushDesignConfigFile[0], 0x00, sizeof(rStConfigurationValues.FlushDesignConfigFile));
   rStConfigurationValues.FlushDesignConfigFile[0] = '\0';

  tS32  s32ReturnValue;
  //DP_S32_NO_ERR                     0;
 

	  

   // possible return values for data-pool-KDS access
   // DP_S32_NO_ERR:              success
   // DP_S32_ERR_WRONG_PARAM:     parameter wrong
   // DP_S32_ERR_NO_ELEMENT_READ: element defined but could not read
   // DP_S32_ERR_NO_ELEMENT:      element not defined

   // DP_S32_NO_ERR                     0
   // DP_S32_ERR_ACCESS_RIGHT          -1
   // DP_S32_ERR_ACCESS_POOL_LOCKED    -2
   // DP_S32_ERR_RD_BUF_LEN            -3
   // DP_S32_ERR_WR_BUF_LEN            -4
   // DP_S32_ERR_NO_ELEMENT            -5
   // DP_S32_ERR_IDLE                  -6
   // DP_S32_ERR_NO_CONVERSION         -7
   // DP_S32_ERR_TIMEOUT               -8
   // DP_S32_ERR_BUSY                  -9
   // DP_S32_ERR_UNKNOWN               -10
   // DP_S32_ERR_TYPE                  -11
   // DP_S32_ERR_ALREADY_LOCKED        -12
   // DP_S32_ERR_WRONG_PARAM           -14
   // DP_S32_ERR_NO_POOL               -15
   // DP_S32_ERR_WRONG_SIZE            -16
   // DP_S32_ERR_DIFFERENT_LOCATION    -17
   // DP_S32_ERR_EQUAL_HASH            -18
   // DP_S32_ERR_NOT_SUPPORTED         -19
   // DP_S32_ERR_NO_ELEMENT_READ       -20
#ifdef VARIANT_S_FTR_ENABLE_SMART
   { /* read configurations from camera system KDS entry
      * - AnticipatoryLine
      * - CameraSystem
      * - CameraConnection
      * - CameraBrightnessDay
      * - CameraBrightnessNight
      * - RVCLensParameter
      * - all Guideline Parameter*/
      tS32  s32ReturnValue;
      tU8   u8BufferGet[88] = {0};
      // AnticipatoryLine
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","AnticipatoryLine",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.bAnticipatoryLine = (tBool) u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> AnticipatoryLine: %-5d", s32ReturnValue));
         // use default values
      }

      // CameraSystem
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","CameraSystem",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CameraSystemType = u8BufferGet[0];
         ETG_TRACE_USR1((" MAIN-APP :: CameraSystem: %d", rStConfigurationValues.u8CameraSystemType));
    
         switch (u8BufferGet[0])
         {
            case DISPVIDCTRL_AllianceCameraSystemType_RearCameraRenault:
               {
                  rStConfigurationValues.bRvcMode = TRUE;
                  rStConfigurationValues.bRvcType_Renault = TRUE;
               }
               break;
    
            case DISPVIDCTRL_AllianceCameraSystemType_RearCameraNissan:
               {
                  rStConfigurationValues.bRvcMode = TRUE;
                  rStConfigurationValues.bRvcType_Renault = FALSE;
               }
               break;
    
            case DISPVIDCTRL_AllianceCameraSystemType_EntryAvm:
               {
                  rStConfigurationValues.bAvmMode = TRUE;
                  rStConfigurationValues.bAvmType_Entry = TRUE;
                  rStConfigurationValues.bAvmType_Renault = FALSE;
               }
               break;
    
            case DISPVIDCTRL_AllianceCameraSystemType_EntryAvmRenault:
               {
                  rStConfigurationValues.bAvmMode = TRUE;
                  rStConfigurationValues.bAvmType_Entry = TRUE;
                  rStConfigurationValues.bAvmType_Renault = TRUE;
               }
               break;
    
            case DISPVIDCTRL_AllianceCameraSystemType_Mvc:
               {
                  rStConfigurationValues.bMvcMode = TRUE;
               }
               break;
    
            case DISPVIDCTRL_AllianceCameraSystemType_AvmPhase3:
               {
                  // eis2hi: caution: as of now, rStConfigurationValues.bAvmMode is intentionally *not* set to TRUE here;
                  // see comments in dispvidctrl_tclServiceRvc::vGetConfiguration() for further explanations
                  
                  // rStConfigurationValues.bAvmMode = TRUE;
                  rStConfigurationValues.bAvmType_Phase3 = TRUE;
               }
               break;
            default:
            break;
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> CameraSystem: %-5d", s32ReturnValue));
         // use default values
      }
    
      // CameraConnection
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","CameraConnection",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CameraConnectionType = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> CameraConnection: %-5d", s32ReturnValue));
         // use default values
      }
    
      // CameraSteeringMessage
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","CameraSteeringMessage",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CameraSteeringMessageType = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> CameraSteeringMessage: %-5d", s32ReturnValue));
         // use default values
      }
    
      // CameraBrightnessDay
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","CameraBrightnessDay",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         if (u8BufferGet[0] <= 100) {
            rStConfigurationValues.u8BrightnessDay = u8BufferGet[0];
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> CameraBrightnessDay: %-5d", s32ReturnValue));
         // use default values
      }
      // CameraBrightnessNight
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","CameraBrightnessNight",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         if (u8BufferGet[0] <= 100) {
            rStConfigurationValues.u8BrightnessNight = u8BufferGet[0];
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> CameraBrightnessNight: %-5d", s32ReturnValue));
         // use default values
      }
    
      // RVCLensParameter
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","RVCLensParameter",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8RvcLensParameterSet = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> RVCLensParameter: %-5d", s32ReturnValue));
         // use default values
      }
    
      // GuidelineParameter
      s32ReturnValue = DP_s32GetConfigItem("CameraSystem","",u8BufferGet, 88, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         (tVoid) OSAL_pvMemoryCopy(&rStConfigurationValues.VehicleParameter[0], &u8BufferGet[0], (tU32) 80);
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CameraSystem -> All (Guideline Parameter): %-5d", s32ReturnValue));
         // use default values
      }

   }
#endif

    tU8   u8BufferGet[88] = {0};
   s32ReturnValue = DP_s32GetConfigItem("CMVariantCoding","RVC",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
		  ETG_TRACE_FATAL((" MAIN-APP ::  Value of %d", u8BufferGet[0]));
         if (0 == u8BufferGet[0])
         {
            // RVC not mounted
            //rStConfigurationValues.u8CameraSystemType = 0;
            rStConfigurationValues.bRvcMode = FALSE ;
           // rStConfigurationValues.bAvmMode = FALSE;
          //  rStConfigurationValues.bMvcMode = FALSE;
			ETG_TRACE_FATAL((" MAIN-APP :: RVC Read Successfull"));
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CMVariantCoding -> RVC: %-5d", s32ReturnValue));
         // use default values
      }
   /*{ /* read configurations from Vehicle Information KDS Entry  via Data-pool from KDS
      *  - steering position
      *  - IPAHFP
      *  - VCANDiversity
      *  - TransmissionType
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[2] = {0,0};

      // steering position
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","SteeringPosition",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         switch (u8BufferGet[0])
         {
            case DISPVIDCTRL_AllianceSteeringPositionType_RHD:
               rStConfigurationValues.bLeftHandSteeringPosition = FALSE;
               break;
            case DISPVIDCTRL_AllianceSteeringPositionType_LHD:
            default:
               rStConfigurationValues.bLeftHandSteeringPosition = TRUE;
               break;
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> SteeringPosition: %-5d", s32ReturnValue));
         // use default values
      }

      // IPA
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","IPAHFP",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         switch (u8BufferGet[0])
         {
            case DISPVIDCTRL_AllianceIPAHFP_Type_IPA:
               if ( rStConfigurationValues.bAvmMode == TRUE ) {
                  rStConfigurationValues.bAvmType_Ipa = TRUE;
                  rStConfigurationValues.bAvmType_Fap = FALSE;
                  rStConfigurationValues.bAvmType_Entry = FALSE;
               }
               break;
            case DISPVIDCTRL_AllianceIPAHFP_Type_FAP:
               if ( rStConfigurationValues.bAvmMode == TRUE ) {
                  rStConfigurationValues.bAvmType_Ipa = FALSE;
                  rStConfigurationValues.bAvmType_Entry = FALSE;
                  rStConfigurationValues.bAvmType_Fap = TRUE;
               }
               break;
            case DISPVIDCTRL_AllianceIPAHFP_Type_None:
            case DISPVIDCTRL_AllianceIPAHFP_Type_HFP_Renault:
            default:
               rStConfigurationValues.bAvmType_Ipa = FALSE;
               rStConfigurationValues.bAvmType_Fap = FALSE;
               break;
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> IPAHFP: %-5d", s32ReturnValue));
         // use default values
      }

      // VCAN Diversity
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","VCANDiversity",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         switch (u8BufferGet[0])
         {
            case DISPVIDCTRL_AllianceVCANSlot_Type_0:
            case DISPVIDCTRL_AllianceVCANSlot_Type_C1A:
            case DISPVIDCTRL_AllianceVCANSlot_Type_C1R:
            case DISPVIDCTRL_AllianceVCANSlot_Type_T4VS:
            case DISPVIDCTRL_AllianceVCANSlot_Type_G1:
            case DISPVIDCTRL_AllianceVCANSlot_Type_C1N:
            case DISPVIDCTRL_AllianceVCANSlot_Type_OLD_NISSAN:
               rStConfigurationValues.u8VCANDiversity = u8BufferGet[0];
               break;
            default:
               rStConfigurationValues.u8VCANDiversity = DISPVIDCTRL_AllianceVCANSlot_Type_0;
               break;
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> VCANDiversity: %-5d", s32ReturnValue));
         // use default values
      }

      // transmission type (manual or automatic gear box)
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","TransmissionType",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         switch (u8BufferGet[0])
         {
            case DISPVIDCTRL_AllianceTransmissionType_MT:
               rStConfigurationValues.bManualTransmission = TRUE;
               break;
            default:
               rStConfigurationValues.bManualTransmission = FALSE;
               break;
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> Transmission_type: %-5d", s32ReturnValue));
         // use default values
      }

      // Reverse Gear Debouncing 
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","ReverseGearDebouncing",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8ReverseGearDebouncing = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> ReverseGearDebouncing: %-5d", s32ReturnValue));
         // use default values
      }

      // Camera Picture Holding time 
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CameraPictureHoldingTime",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CameraVideoHoldingTime = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CameraPictureHoldingTime: %-5d", s32ReturnValue));
         // use default values
      }

      // Camera Rear Trunk Behaviour 
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CameraRearTrunkBehaviour",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CameraRearTrunkBehaviour = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CameraRearTrunkBehaviour: %-5d", s32ReturnValue));
         // use default values
      }

      // Vehicle Type 
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","VehicleType",u8BufferGet, 2, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u16VehicleType = ((u8BufferGet[0]<<8) | u8BufferGet[1]);
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> VehicleType: %-5d", s32ReturnValue));
         // use default values
      }      
   }

   { /* display (size)
      *    Display Config ($A0C2)
      *
      *  - Display1
      *    Bytes 0-31 display1
      *          4-5 Bytes x-Pixels
      *          6-7 Bytes y-Pixels
      *
      *  - Display2
      *    Bytes 32-63 display2
      *          37-38 Bytes x-Pixels
      *          39-40 Bytes y-Pixels
      *
      

      tS32  s32ReturnValue;
      tU8   u8BufferGet[2] = {0};

      // Display Resolution Width in Pixels
      s32ReturnValue = DP_s32GetConfigItem("Display","NumOfPixelsX",u8BufferGet, 2, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u32DisplayResolutionWidth =  (tU32) ( ( (tU16) ( u8BufferGet[0] << 8 ) ) | ( (tU16) u8BufferGet[1] ) );
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting Display -> NumOfPixelsX: %-5d", s32ReturnValue));
         // use default values
      }
      
      // Display Resolution Height in Pixels
      s32ReturnValue = DP_s32GetConfigItem("Display","NumOfPixelsY",u8BufferGet, 2, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u32DisplayResolutionHeight = (tU32) ( ( (tU16) ( u8BufferGet[0] << 8 ) ) | ( (tU16) u8BufferGet[1] ) );
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting Display -> NumOfPixelsY: %-5d", s32ReturnValue));
         // use default values
      }
      
      // Display2 Resolution Width in Pixels
      s32ReturnValue = DP_s32GetConfigItem("Display","NumOfPixelsX2",u8BufferGet, 2, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u32DisplayTwoResolutionWidth = (tU32) ( ( (tU16) ( u8BufferGet[0] << 8 ) ) | ( (tU16) u8BufferGet[1] ) );
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting Display2 -> NumOfPixelsX2: %-5d", s32ReturnValue));
         // use default values
      }
      
      // Display2 Resolution Height in Pixels
      s32ReturnValue = DP_s32GetConfigItem("Display","NumOfPixelsY2",u8BufferGet, 2, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u32DisplayTwoResolutionHeight = (tU32) ( ( (tU16) ( u8BufferGet[0] << 8 ) ) | ( (tU16) u8BufferGet[1] ) );
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting Display2 -> NumOfPixelsY2: %-5d", s32ReturnValue));
         // use default values
      }

      rStConfigurationValues.u8DisplaySize = DISPVIDCTRL_DISPLAY_SIZE_7_INCH;
   }

   { /* read black warning text background configuration via Data-pool from KDS
      *
      */
//todo  currently no configuration item available
   //}

    /* read configurations from System Information Common KDS Entry  via Data-pool from KDS
      *  - Brand
      *  - OpeningAnimation
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // Brand
      s32ReturnValue = DP_s32GetConfigItem("SystemConfiguration1","Brand",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8Brand = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting SystemInformationCommon -> Brand: %-5d", s32ReturnValue));
         // use default values
      }
   }

   { /* read configurations from System Information Common KDS Entry  via Data-pool from KDS
      *  - OpeningAnimation
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // OpeningAnimation
      s32ReturnValue = DP_s32GetConfigItem("SystemConfiguration1","OpeningAnimation",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8OpeningAnimation = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting SystemInformation1 -> OpeningAnimation: %-5d", s32ReturnValue));
         // use default values
      }
   }

#if 0
   { /* read configurations from System Information Common KDS Entry  via Data-pool from KDS
      *  - DisplayOutput
      *
      * 0 = Internal Display
      * 1 = External Display
     
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // DisplayOutput
      s32ReturnValue = DP_s32GetConfigItem("AIVIVariantCoding","DisplayOutput",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8DisplayOutput = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting AIVIVariantCoding -> DisplayOutput: %-5d", s32ReturnValue));
         // use default values
      }
   }
#endif //0

  { /* read configurations from HMI Config KDS Entry  via Data-pool from KDS
      *  - DisplayOrientation = DisplayFormat
      *
      *    HMI Config ($2108)
      *    Byte 9 bit 5
      *    DisplayFormat
      *         1 Bit 
      *             [0x00] Landscape 
      *             [0x01] Portrait 
      *
      * lis8hi - Landscape/Portrait KDS item changed from DisplayOrientation to DisplayFormat, but variable names unchanged to minimise impact
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // DisplayOrientation >= DisplayFormat
      s32ReturnValue = DP_s32GetConfigItem("HMIConfig","DisplayFormat",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8DisplayOrientation = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting HMIConfig -> DisplayFormat: %-5d", s32ReturnValue));
         // use default values
      }
   }

   { /* read configurations from System Information Common KDS Entry  via Data-pool from KDS
      *  - DisplayAspectRatio
      *
      * 0 = Not configured
      * 1 = 15:9
      * 2 = 17:9
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // DisplayAspectRatio
      s32ReturnValue = DP_s32GetConfigItem("AIVIVariantCoding","DisplayAspectRatio",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8DisplayAspectRatio = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting AIVIVariantCoding -> DisplayAspectRatio: %-5d", s32ReturnValue));
         // use default values
      }
   }

   // In DA variants, we cannot use Sds for Ipa Voice Requests, instead play audio mp3 files
   { /* read configurations from System Information Common KDS Entry  via Data-pool from KDS
      *  - Alliance Variant Type
      *
      * 0 = Not configured
      * 1 = Navi
      * 2 = DA (Without Navi and SDS etc..)
      *
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // Variant Type
      s32ReturnValue = DP_s32GetConfigItem("AIVIVariantCoding","VariantSelection",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8DeviceVariantType = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting AIVIVariantCoding -> VariantSelection: %-5d", s32ReturnValue));
         // use default values
      }
   }

   { /* read configurations from Vehicle Information Common KDS Entry  via Data-pool from KDS
      *  - DestinationRegion
      *
      * 0x01 = CAN
      * 0x19 = JPN
      * etc
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // DestinationRegion
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","DestinationRegion1",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u16DestinationRegion = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> DestinationRegion: %-5d", s32ReturnValue));
         // use default values
      }
   }

   {
      // Display Type
      //    System Information Common($DAB1)
      //    59   PIVI only
      //         4-5   Display_type
      //               2 Bit 
      //                   [0x00] Single Display
      //                   [0x01] Dual Display
      //                   [0x01] None
      //                   [0x01] Reserved
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      s32ReturnValue = DP_s32GetConfigItem("SystemConfiguration1","DisplayType",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8DisplayType = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting SystemInformationCommon -> DisplayType: %-5d", s32ReturnValue));
         // use default values
      }

   }

   // [18.11.2016]
   // There are "Entry" devices whitout RVC feature (e.g. )
   // We must check CMVariantCoding - RVC
   // If RVC == not mounted, we shall not enable RVC or AVM independent of the customer configuration for camera system
   // Currently our understanding is that this entry is standing for the mounting of the ADV chip.
   // As soon as LVDS is comming ino account we have to recheck this impmlementation.
   // Maybe we have to take care on CameraSystem-CameraConnection (CVBS or LVDS) then.
   {
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // RVC HW assembly info (PD configuration)
      s32ReturnValue = DP_s32GetConfigItem("CMVariantCoding","RVC",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         if (0 == u8BufferGet[0])
         {
            // RVC not mounted
            rStConfigurationValues.u8CameraSystemType = 0;
            rStConfigurationValues.bRvcMode = FALSE ;
            rStConfigurationValues.bAvmMode = FALSE;
            rStConfigurationValues.bMvcMode = FALSE;
         }
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting CMVariantCoding -> RVC: %-5d", s32ReturnValue));
         // use default values
      }
   }
   
   {  // read configurations from Vehicle Information Common KDS Entry  via Data-pool from KDS

      // Crop Up
      //    Vehicle Information Common($DAB1)
      //    42   Renault only
      //         0-6   Crop Up
      //               7 Bit 
      //                   y = x %; Lower limit (phys): 0 %; Upper limit (phys): 127 %;
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // CropUp
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CropUp",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CropUp = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CropUp: %-5d", s32ReturnValue));
         // use default values
      }
   }

   {  // read configurations from Vehicle Information Common KDS Entry  via Data-pool from KDS

      // Crop Down
      //    Vehicle Information Common($DAB1)
      //    43   Renault only
      //         0-6   Crop Down
      //               7 Bit 
      //                   y = x %; Lower limit (phys): 0 %; Upper limit (phys): 127 %;
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // CropDown
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CropDown",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CropDown = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CropDown: %-5d", s32ReturnValue));
         // use default values
      }
   }

   {  // read configurations from Vehicle Information Common KDS Entry  via Data-pool from KDS

      // Crop Left
      //    Vehicle Information Common($DAB1)
      //    44   Renault only
      //         0-6   Crop Left
      //               7 Bit 
      //                   y = x %; Lower limit (phys): 0 %; Upper limit (phys): 127 %;
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // CropLeft
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CropLeft",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CropLeft = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CropLeft: %-5d", s32ReturnValue));
         // use default values
      }
   }

   {  // read configurations from Vehicle Information Common KDS Entry  via Data-pool from KDS

      // Crop Right
      //    Vehicle Information Common($DAB1)
      //    45   Renault only
      //         0-6   Crop Right
      //               7 Bit 
      //                   y = x %; Lower limit (phys): 0 %; Upper limit (phys): 127 %;
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // CropRight
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CropRight",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CropRight = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CropRight: %-5d", s32ReturnValue));
         // use default values
      }
   }

   {  // read configurations from Vehicle Information Common KDS Entry  via Data-pool from KDS

      // Camera Image Mirror
      //    Vehicle Information Common($DAB1)
      //    49   Renault only
      //         5-6   Camera Image Mirror
      //               2 Bit 
      //                  [0x00] none
      //                  [0x01] Vertical
      //                  [0x02] Horizontal
      //                  [0x03] Vertical + Horizontal
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      // CameraImageMirror
      s32ReturnValue = DP_s32GetConfigItem("VehicleInformation","CameraImageMirror",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8CameraImageMirror = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting VehicleInformation -> CameraImageMirror: %-5d", s32ReturnValue));
         // use default values
      }
   }

   { /* read configurations from HMI Config KDS Entry  via Data-pool from KDS
      *  Welcome Sequence
      *
      *    HMI Config ($2108)
      *    Byte 20 bits 0-3
      *    WelcomeSequence
      *         4 Bits 
      *             [0x00] Without Welcome Sequence 
      *             [0x01] Welcome sequence 1
      *             [0x02] Welcome sequence 2
      *             [0x03] Welcome sequence 3
      *             [0x04] Welcome sequence 4
      *             [0x05] Welcome sequence 5
      *             [0x06] Welcome sequence 6
      *             [0x07] Welcome sequence 7
      *             [0x08] Welcome sequence 8
      *
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[1] = {0};

      s32ReturnValue = DP_s32GetConfigItem("HMIConfig","WelcomeSequence",u8BufferGet, 1, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         rStConfigurationValues.u8WelcomeSequence = u8BufferGet[0];
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting HMIConfig -> WelcomeSequence: %-5d", s32ReturnValue));
         // use default values
      }
   }

   { /* read configurations from HMI Config KDS Entry  via Data-pool from KDS
      *  EarlyConfig_Display Resolution
      *
      *    EarlyConfig_Display ($8500)
      *    Resolution Bytes 0-31 - zero terminated string giving Display resolution
      *
      
      tS32  s32ReturnValue;
      tU8   u8BufferGet[32] = {0};
      s32ReturnValue = DP_s32GetConfigItem("EarlyConfig_Display","Resolution",u8BufferGet, 32, FALSE);
      if (s32ReturnValue == DP_S32_NO_ERR) {
         (tVoid) OSAL_pvMemoryCopy(&rStConfigurationValues.Resolution[0], &u8BufferGet[0], (tU32) 32);
      }
      else {
         ETG_TRACE_FATAL((" MAIN-APP :: E R R O R in _vDetermineConfiguration(): while requesting EarlyConfig_Display -> Resolution: %-5d", s32ReturnValue));
         // use default values
      }
   }*/

   // see NCG3D-88866: Nissan vehicle H61L gets an upgrade from LCN2kaiEvo to A-IVI Scope2,
   // so according to Nissan request, unlike the other IVI using cars, it shall have center guidelines to avoid a feature loss.
   // However, no according Diag config item is specified for A-IVI, so for the time being, we will hard-configure this here for now:
   if (DISPVIDCTRL_VEHICLE_TYPE_H61L == rStConfigurationValues.u16VehicleType) {
      rStConfigurationValues.bCentreGuideline = TRUE;
   }
   
   //trace configuration values
   ETG_TRACE_FATAL((" MAIN-APP :: _vDetermineConfiguration(): ------ CONFIGURATION --------------------------------"));
   ETG_TRACE_FATAL((" MAIN-APP :: u8Brand = .............................. 0x%-38x", rStConfigurationValues.u8Brand));
   ETG_TRACE_FATAL((" MAIN-APP :: u8OpeningAnimation = ................... 0x%-38x", rStConfigurationValues.u8OpeningAnimation));
   ETG_TRACE_FATAL((" MAIN-APP :: u8DisplayAspectRatio = ................. 0x%-38x", rStConfigurationValues.u8DisplayAspectRatio));
   ETG_TRACE_FATAL((" MAIN-APP :: u8DisplayType = ........................ 0x%-38x", rStConfigurationValues.u8DisplayType));
   ETG_TRACE_FATAL((" MAIN-APP :: u16DestinationRegion = ................. 0x%-38x", rStConfigurationValues.u16DestinationRegion));
   ETG_TRACE_FATAL((" MAIN-APP :: u16VehicleType = ....................... 0x%-38x", rStConfigurationValues.u16VehicleType));
   ETG_TRACE_FATAL((" MAIN-APP :: u8DisplayOrientation = ................. 0x%-38x", rStConfigurationValues.u8DisplayOrientation));
   //ETG_TRACE_FATAL((" MAIN-APP :: u8DisplayOutput = ...................... 0x%-38x", rStConfigurationValues.u8DisplayOutput));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CameraSystemType = ................... 0x%-38x", rStConfigurationValues.u8CameraSystemType));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CameraConnectionType = ............... 0x%-38x", rStConfigurationValues.u8CameraConnectionType));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CameraSteeringMessageType = .......... 0x%-38x", rStConfigurationValues.u8CameraSteeringMessageType));
   ETG_TRACE_FATAL((" MAIN-APP :: u8DeviceVariantType = .................. 0x%-38x", rStConfigurationValues.u8DeviceVariantType));
   ETG_TRACE_FATAL((" MAIN-APP :: bRvcMode = ............................. 0x%-38x", rStConfigurationValues.bRvcMode));
   ETG_TRACE_FATAL((" MAIN-APP :: bAvmMode = ............................. 0x%-38x", rStConfigurationValues.bAvmMode));
   ETG_TRACE_FATAL((" MAIN-APP :: bMvcMode = ............................. 0x%-38x", rStConfigurationValues.bMvcMode));
   ETG_TRACE_FATAL((" MAIN-APP :: bAvmType_Entry = ....................... 0x%-38x", rStConfigurationValues.bAvmType_Entry));
   ETG_TRACE_FATAL((" MAIN-APP :: bAvmType_Ipa = ......................... 0x%-38x", rStConfigurationValues.bAvmType_Ipa));
   ETG_TRACE_FATAL((" MAIN-APP :: bAvmType_Fap = ......................... 0x%-38x", rStConfigurationValues.bAvmType_Fap));
   ETG_TRACE_FATAL((" MAIN-APP :: bAvmType_Phase3 = ...................... 0x%-38x", rStConfigurationValues.bAvmType_Phase3));
   ETG_TRACE_FATAL((" MAIN-APP :: bAvmType_Renault = ..................... 0x%-38x", rStConfigurationValues.bAvmType_Renault));
   ETG_TRACE_FATAL((" MAIN-APP :: bRvcType_Renault = ..................... 0x%-38x", rStConfigurationValues.bRvcType_Renault));
   ETG_TRACE_FATAL((" MAIN-APP :: bStaticGuideline = ..................... 0x%-38x", rStConfigurationValues.bStaticGuideline));
   ETG_TRACE_FATAL((" MAIN-APP :: bCentreGuideline = ..................... 0x%-38x", rStConfigurationValues.bCentreGuideline));
   ETG_TRACE_FATAL((" MAIN-APP :: bAnticipatoryLine = .................... 0x%-38x", rStConfigurationValues.bAnticipatoryLine));
   ETG_TRACE_FATAL((" MAIN-APP :: bLeftHandSteeringPosition = ............ 0x%-38x", rStConfigurationValues.bLeftHandSteeringPosition));
   ETG_TRACE_FATAL((" MAIN-APP :: bBlackWarningTextBackground = .......... 0x%-38x", rStConfigurationValues.bBlackWarningTextBackground));
   ETG_TRACE_FATAL((" MAIN-APP :: bManualTransmission = .................. 0x%-38x", rStConfigurationValues.bManualTransmission));   
   ETG_TRACE_FATAL((" MAIN-APP :: u8BrightnessDay = ...................... 0x%-38x", rStConfigurationValues.u8BrightnessDay));
   ETG_TRACE_FATAL((" MAIN-APP :: u8BrightnessNight = .................... 0x%-38x", rStConfigurationValues.u8BrightnessNight));
   ETG_TRACE_FATAL((" MAIN-APP :: u8DisplaySize = ........................ 0x%-38x", rStConfigurationValues.u8DisplaySize));
   ETG_TRACE_FATAL((" MAIN-APP :: u8RvcLensParameterSet = ................ 0x%-38x", rStConfigurationValues.u8RvcLensParameterSet));
   ETG_TRACE_FATAL((" MAIN-APP :: u32DisplayResolutionWidth = ............ 0x%-38x", rStConfigurationValues.u32DisplayResolutionWidth));
   ETG_TRACE_FATAL((" MAIN-APP :: u32DisplayResolutionHeight = ........... 0x%-38x", rStConfigurationValues.u32DisplayResolutionHeight));
   ETG_TRACE_FATAL((" MAIN-APP :: u32DisplayTwoResolutionWidth = ......... 0x%-38x", rStConfigurationValues.u32DisplayTwoResolutionWidth));
   ETG_TRACE_FATAL((" MAIN-APP :: u32DisplayTwoResolutionHeight = ........ 0x%-38x", rStConfigurationValues.u32DisplayTwoResolutionHeight));
   ETG_TRACE_FATAL((" MAIN-APP :: u8VCANDiversity = ...................... 0x%-38x", rStConfigurationValues.u8VCANDiversity));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CameraVideoHoldingTime = ............. 0x%-38x", rStConfigurationValues.u8CameraVideoHoldingTime));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CameraRearTrunkBehaviour = ........... 0x%-38x", rStConfigurationValues.u8CameraRearTrunkBehaviour));
   ETG_TRACE_FATAL((" MAIN-APP :: u8ReverseGearDebouncing = .............. 0x%-38x", rStConfigurationValues.u8ReverseGearDebouncing));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CropUp = ............................. 0x%-38x", rStConfigurationValues.u8CropUp));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CropDown = ........................... 0x%-38x", rStConfigurationValues.u8CropDown));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CropLeft = ........................... 0x%-38x", rStConfigurationValues.u8CropLeft));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CropRight = .......................... 0x%-38x", rStConfigurationValues.u8CropRight));
   ETG_TRACE_FATAL((" MAIN-APP :: u8CameraImageMirror = .................. 0x%-38x", rStConfigurationValues.u8CameraImageMirror));
   ETG_TRACE_FATAL((" MAIN-APP :: u8WelcomeSequence = .................... 0x%-38x", rStConfigurationValues.u8WelcomeSequence));
   //ETG_TRACE_FATAL((" MAIN-APP :: Resolution = ........................... %s", rStConfigurationValues.Resolution));
   ETG_TRACE_FATAL((" MAIN-APP :: ---------------------------------------------------------------------------------"));
}

tVoid dispvidctrl_tclBaseIf::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   (tVoid) pStConfigurationValues;
}

tVoid dispvidctrl_tclAppMain::vCreateWorkerThread(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclBaseIf::vCreateWorkerThread() entered."));
   OSAL_trThreadAttribute  rThAttr;

   tU32 u32ThreadPrio = 120;
   tU32 u32ThreadStack = 2048;
   tChar szName[32] = "dispvidctrlworker";
   
   // create msgbox
   if( OSAL_ERROR == OSAL_s32MessageQueueCreate(szName,
		   DISPVIDCTRL_QUEUE_MAXMSG, sizeof(dispvidctrl_tclBaseIf::TMsg),
		   OSAL_EN_READWRITE, &_hWorkerMsgQueue)
      )
   {
	   ETG_TRACE_FATAL(("dispvidctrl_tclBaseIf::vCreateWorkerThread(): creation of message queue failed."));
      _hWorkerMsgQueue=OSAL_C_INVALID_HANDLE;
   }
   else
   {
	   ETG_TRACE_FATAL(("dispvidctrl_tclBaseIf::vCreateWorkerThread(): creation of message queue successful."));
   }
   
   
   // setup thread
   _bTerminate = FALSE;
   
   rThAttr.szName       = szName;
   rThAttr.u32Priority  = u32ThreadPrio;
   rThAttr.s32StackSize = u32ThreadStack;
   rThAttr.pfEntry      = (OSAL_tpfThreadEntry)dwThreadWork; 
   rThAttr.pvArg        = (tPVoid)this;

   // create thread suspended
   _tThreadID = OSAL_ThreadSpawn( &rThAttr );
   if(_tThreadID == OSAL_ERROR)
   {
      ETG_TRACE_FATAL(("dispvidctrl_tclBaseIf::vCreateWorkerThread(): Failed to create worker thread."));
   }

   return;


}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclBaseIf::dwThreadWork( tPVoid pvArg )
*
* DESCRIPTION: Worker thread will only be supported if configured.
*
* PARAMETER: pointer to main class object
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclAppMain::dwThreadWork( tPVoid pvArg )
{
   ETG_TRACE_USR4(("dispvidctrl_tclBaseIf::dwThreadWork() entered."));

   dispvidctrl_tclAppMain*  poMain = (dispvidctrl_tclAppMain*)pvArg;
   tS32      s32Ret;
   
   dispvidctrl_tclBaseIf::TMsg tMyMsg;
   tU32		 u32Prio;
   tU32		 u32MsgMax, u32MaxLen, u32MsgCount;

   while(!(poMain->_bTerminate))
   {
      if (OSAL_OK != OSAL_s32MessageQueueStatus(poMain->_hWorkerMsgQueue, &u32MsgMax, &u32MaxLen, &u32MsgCount)) {
      }
      if (u32MsgCount == 0) {
         //no more message in queue -> all current substate updates consumed
      }

      s32Ret = OSAL_s32MessageQueueWait(
         poMain->_hWorkerMsgQueue,
         (tU8*)&tMyMsg, /*pointer of the MsgHandle field*/
         sizeof(dispvidctrl_tclBaseIf::TMsg),
         &u32Prio, 
         OSAL_C_U32_INFINITE
         );

      poMain->vCheckOwnMessageQueueStatus(&tMyMsg, poMain->_hWorkerMsgQueue);

      if (!(poMain->_bTerminate) && (s32Ret != OSAL_ERROR)) {
         ETG_TRACE_USR4(("dispvidctrl_tclBaseIf::dwThreadWork(): New message received: %u -> data: %d.",
        		 ETG_ENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)tMyMsg.eCmd), tMyMsg.u.u32Data));
         poMain->vDispatchInternalMsg(&tMyMsg);
      }

   }

   OSAL_vThreadExit();
   return;


}

tVoid dispvidctrl_tclAppMain::vWaitForVideoChainReady(tU32 u32Timeout){
    I_dispvidctrl_tclSyncHandler* _poSyncHdl = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(getHandler("I_dispvidctrl_tclSyncHandler"));
    if (_poSyncHdl) {
        _poSyncHdl->vWaitVideoChain(u32Timeout);
    }
}

tVoid dispvidctrl_tclAppMain::vWriteStartupLog(std::string strTrace, tU32 u32Data) {

#   ifndef DISPVIDCTRL_KERNEL_LOG_DISABLED
    std::stringstream strKernelTrace;
    if (u32Data != 0xffffffff) {
        strKernelTrace << strTrace.c_str() << " duration: " << u32Data << " ms";
    } else {
        strKernelTrace << strTrace.c_str() << "";
    }
    ETG_TRACE_FATAL( ( "[%d ms] : %s", OSAL_ClockGetElapsedTime(), strKernelTrace.str().c_str() ));
    strKernelTrace << "\n";

    int  ViFile = open("/dev/kmsg", O_WRONLY );
    if (ViFile != -1)
    {
       write(ViFile,(const void*)strKernelTrace.str().c_str(),strKernelTrace.str().size());
       close(ViFile);
    }

#   endif

    if (_poMainAppInstance) {
        _poMainAppInstance->vAddStartUpEntry(strTrace, u32Data);
    }
}

tVoid dispvidctrl_tclAppMain::vAddStartUpEntry(std::string strEntry, tU32 u32Data) {
    TStartupTrace oNewEntry;
    oNewEntry.u32TimeStamp = OSAL_ClockGetElapsedTime();
    oNewEntry.strInfo = strEntry;
    oNewEntry.u32Data = u32Data;
    if (_poMainAppInstance) _poMainAppInstance->_oStartupInvestMap.push_back(oNewEntry);
}

void dispvidctrl_tclAppMain::vReadEarlyConfig() {
    if (!_bEarlyConfigValid) {
        tU32 u32StartTime = OSAL_ClockGetElapsedTime();

        //first set default values
        _tEarlyConfig.u32RvcDayNight                           = DEFAULT_RVCDAYNIGHT;
        _tEarlyConfig.u32RvcColour                             = DEFAULT_RVCCOLOURDAY;
        _tEarlyConfig.u32RvcContrast                           = DEFAULT_RVCCONTRASTDAY;
        _tEarlyConfig.u32RvcBrightness                         = DEFAULT_RVCBRIGHTNESSDAY;
        _tEarlyConfig.u32RvcHue                                = DEFAULT_RVCHUEDAY;
        _tEarlyConfig.u32RvcBlackLevel                         = DEFAULT_RVCBLACKLEVELDAY;
        _tEarlyConfig.u32RvcLayer                              = DEFAULT_RVCLAYER;
        _tEarlyConfig.u32RvcSurface                            = DEFAULT_RVCSURFACE;
        _tEarlyConfig.u32RvcPixFmt                             = DEFAULT_RVCPIXFMT;
        _tEarlyConfig.u32AnimationSurface                      = DEFAULT_ANIMATIONSURFACE;
        _tEarlyConfig.u32GuidelineSurface                      = DEFAULT_GUIDELINESURFACE;
        _tEarlyConfig.u32RvcGraphicsLayer                      = DEFAULT_RVCGRAPHICSLAYER;
        _tEarlyConfig.u32AnimationLayer                        = DEFAULT_ANIMATIONLAYER;
        _tEarlyConfig.u32AnimationLayer2                       = DEFAULT_ANIMATIONLAYER2;
        _tEarlyConfig.u32AnimationSurface2                     = DEFAULT_ANIMATIONSURFACE2;

        _tEarlyConfig.tEarlyNor.u32SpmAutoMode                          = DEFAULT_SPMAUTOMODE;
        _tEarlyConfig.tEarlyNor.u32RvcColourDay                         = DEFAULT_RVCCOLOURDAY;                       
        _tEarlyConfig.tEarlyNor.u32RvcContrastDay                       = DEFAULT_RVCCONTRASTDAY;                     
        _tEarlyConfig.tEarlyNor.u32RvcBrightnessDay                     = DEFAULT_RVCBRIGHTNESSDAY;                   
        _tEarlyConfig.tEarlyNor.u32RvcHueDay                            = DEFAULT_RVCHUEDAY;                          
        _tEarlyConfig.tEarlyNor.u32RvcBlackLevelDay                     = DEFAULT_RVCBRIGHTNESSDAY;                   
        _tEarlyConfig.tEarlyNor.u32RvcColourNight                       = DEFAULT_RVCCOLOURNIGHT;                     
        _tEarlyConfig.tEarlyNor.u32RvcContrastNight                     = DEFAULT_RVCCONTRASTNIGHT;                   
        _tEarlyConfig.tEarlyNor.u32RvcBrightnessNight                   = DEFAULT_RVCBRIGHTNESSNIGHT;                
        _tEarlyConfig.tEarlyNor.u32RvcHueNight                          = DEFAULT_RVCHUENIGHT;                        
        _tEarlyConfig.tEarlyNor.u32RvcBlackLevelNight                   = DEFAULT_RVCBLACKLEVELNIGHT;
        _tEarlyConfig.tEarlyNor.u32GuidelineWarningLanguage             = DEFAULT_GUIDELINEWARNINGLANGUAGE;
        _tEarlyConfig.tEarlyNor.u32GuidelineVisibilityMode              = DEFAULT_GUIDELINEVISIBILITYMODE;
        _tEarlyConfig.tEarlyNor.u8AvmLanguage                           = 0;

        _tEarlyConfig.tEarlyNorForce.u32RvcLowSpeedThreshold                 = DEFAULT_RVCLOWSPEEDTHRESHOLD;
        _tEarlyConfig.tEarlyNorForce.u32RvcHighSpeedThreshold                = DEFAULT_RVCHIGHSPEEDTHRESHOLD;
        _tEarlyConfig.tEarlyNorForce.u32RvcReverseOffGuardTime               = DEFAULT_RVCREVERSEOFFGUARDTIME;
        _tEarlyConfig.tEarlyNorForce.u32GuidelineCameraType                  = DEFAULT_GUIDELINECAMERATYPE;
        _tEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType            = DEFAULT_GUIDELINECAMERASYSTEMTYPE;
        _tEarlyConfig.tEarlyNorForce.u32GuidelineBlackWarningTextBackground  = DEFAULT_GUIDELINEWARNINGTEXTBACKGROUND;
        _tEarlyConfig.tEarlyNorForce.u32GuidelineWarningText                 = DEFAULT_GUIDELINEWARNINGTEXT;
        _tEarlyConfig.tEarlyNorForce.bGuidelineVisibility                    = DEFAULT_GUIDELINEVISIBILITY;
        (tVoid) OSAL_pvMemorySet(_tEarlyConfig.tEarlyNorForce.au8GuidelineVehicleParameter, 0x00, sizeof _tEarlyConfig.tEarlyNorForce.au8GuidelineVehicleParameter);
        _tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_X               = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_Y               = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_Width           = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_Height          = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_X          = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_Y          = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_Width      = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_Height     = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoCropping_Up                     = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoCropping_Down                   = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoCropping_Left                   = 0;
        _tEarlyConfig.tEarlyNorForce.u16VideoCropping_Right                  = 0;
        _tEarlyConfig.tEarlyNorForce.bVideoScalingSet                        = FALSE;
        _tEarlyConfig.tEarlyNorForce.bVideoCroppingSet                       = FALSE;
        _tEarlyConfig.tEarlyNorForce.bLeftHandSteeringPosition               = DEFAULT_STEERING_POSITION;
        _tEarlyConfig.tEarlyNorForce.u8EarlyBrand                            = DEFAULT_BRAND;
        _tEarlyConfig.tEarlyNorForce.u8EarlyOpeningAnimation                 = DEFAULT_OPENINGANIMATION;
        _tEarlyConfig.tEarlyNorForce.u8EarlyDisplayAspectRatio               = DEFAULT_DISPLAYASPECTRATIO;
        _tEarlyConfig.tEarlyNorForce.u8EarlyDisplayOrientation               = DEFAULT_DISPLAYORIENTATION;
		#ifdef VARIANT_S_FTR_ENABLE_SMART
        _tEarlyConfig.tEarlyNorForce.u8CameraConnectionType                  = DISPVIDCTRL_AllianceCameraConnectionType_CVBS;
		#endif
		#ifndef VARIANT_S_FTR_ENABLE_SMART
		_tEarlyConfig.tEarlyNorForce.u8CameraConnectionType                  = 0;
		#endif
        _tEarlyConfig.tEarlyNorForce.u16CameraWidth                          = DEFAULT_CAMERAWIDTH;
        _tEarlyConfig.tEarlyNorForce.u16CameraHeight                         = DEFAULT_CAMERAHEIGHT;
        _tEarlyConfig.tEarlyNorForce.u16CameraXOffset                        = 0;
        _tEarlyConfig.tEarlyNorForce.u16CameraYOffset                        = 0;
        _tEarlyConfig.tEarlyNorForce.u8DisplayType                           = 0;
#ifndef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        _tEarlyConfig.tEarlyNorForce.u16Display1Width                        = 800;
        _tEarlyConfig.tEarlyNorForce.u16Display1Height                       = 480;
        _tEarlyConfig.tEarlyNorForce.u16Display1XOffset                      = 0;
        _tEarlyConfig.tEarlyNorForce.u16Display1YOffset                      = 0;
        _tEarlyConfig.tEarlyNorForce.u16Display2Width                        = 800;
        _tEarlyConfig.tEarlyNorForce.u16Display2Height                       = 480;
        _tEarlyConfig.tEarlyNorForce.u16Display2XOffset                      = 0;
        _tEarlyConfig.tEarlyNorForce.u16Display2YOffset                      = 0;
#else
        _tEarlyConfig.tEarlyNorForce.u16Display1Width                        = 1280;
        _tEarlyConfig.tEarlyNorForce.u16Display1Height                       = 768;
        _tEarlyConfig.tEarlyNorForce.u16Display1XOffset                      = 0;
        _tEarlyConfig.tEarlyNorForce.u16Display1YOffset                      = 0;
        _tEarlyConfig.tEarlyNorForce.u16Display2Width                        = 1280;
        _tEarlyConfig.tEarlyNorForce.u16Display2Height                       = 768;
        _tEarlyConfig.tEarlyNorForce.u16Display2XOffset                      = 0;
        _tEarlyConfig.tEarlyNorForce.u16Display2YOffset                      = 0;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SMART 
        _tEarlyConfig.tEarlyNorForce.u8VCANDiversity                         = 1;
#else
        _tEarlyConfig.tEarlyNorForce.u8VCANDiversity                         = DEFAULT_VCANDIVERSITY;
#endif
        _tEarlyConfig.tEarlyNorForce.u8CameraImageMirror                     = 0;
        _tEarlyConfig.tEarlyNorForce.u8EarlyWelcomeSequence                  = DEFAULT_WELCOMESEQUENCE;
        (tVoid) OSAL_pvMemorySet(_tEarlyConfig.tEarlyNorForce.au8EarlyResolution, 0x00, sizeof _tEarlyConfig.tEarlyNorForce.au8EarlyResolution);
        _tEarlyConfig.tEarlyNorForce.u16VehicleType                          = DEFAULT_VEHICLE_TYPE;
        (tVoid) OSAL_pvMemorySet(_tEarlyConfig.tEarlyNorForce.au8EarlyDisplayOrder, 0x00, sizeof _tEarlyConfig.tEarlyNorForce.au8EarlyDisplayOrder);
        (tVoid) OSAL_pvMemorySet(_tEarlyConfig.tEarlyNorForce.au8EarlyFlushDesignConfigFile, 0x00, sizeof _tEarlyConfig.tEarlyNorForce.au8EarlyFlushDesignConfigFile);


        _tEarlyConfigDefault = _tEarlyConfig;  //to maintain default to use for TTFis command

        //Get settings data from NOR data
        int s32StreamLength = 800;

        //Allocate buffer
        unsigned char* pu8DataStreamBuffer = (unsigned char*) malloc((unsigned int)s32StreamLength);
        tU8            Vu8Info             = PDD_READ_INFO_NORMAL_FILE;
        int s32Result = pdd_read_datastream_early_from_nor((const char*)PDD_NOR_USER_DATASTREAM_NAME_DATASET_VD_EARLY_CONFIG, pu8DataStreamBuffer, s32StreamLength, 1, &Vu8Info);
        if (s32Result > 0) {
            ETG_TRACE_FATAL((" MAIN-APP :: vReadEarlyConfig(): Read %d bytes from pdd.", s32Result));

            if(pdd_helper_get_element_from_stream(const_cast<tString>("EarlyNorConfig"),pu8DataStreamBuffer,(size_t)s32Result, (void*) &_tEarlyConfig.tEarlyNor, sizeof(TEarlyNorConfiguration),0)==0) { //lint !e605

                dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Early config read from NOR ", OSAL_ClockGetElapsedTime() - u32StartTime);
            }
        }

        if (pu8DataStreamBuffer)
        {
            memset(pu8DataStreamBuffer, 0, s32StreamLength);
            Vu8Info             = PDD_READ_INFO_BACKUP_FILE;

            s32Result = pdd_read_datastream_early_from_nor((const char*)PDD_NOR_USER_DATASTREAM_NAME_DATASET_VD_EARLY_FORCE_CONFIG, pu8DataStreamBuffer, s32StreamLength, 1, &Vu8Info);
            if (s32Result > 0) {
                ETG_TRACE_FATAL((" MAIN-APP :: vReadEarlyConfig(): Read %d bytes from pdd.", s32Result));

                if(pdd_helper_get_element_from_stream(const_cast<tString>("EarlyNorConfigForce"),pu8DataStreamBuffer,(size_t)s32Result, (void*) &_tEarlyConfig.tEarlyNorForce, sizeof(TEarlyNorForceConfiguration),0)==0) { //lint !e605

                    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Early Force config read from NOR ", OSAL_ClockGetElapsedTime() - u32StartTime);
                }
            }
            
            else
            {
                dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Early Force config read FAILED from NOR %d", s32Result);
            }
        }

        free(pu8DataStreamBuffer);

        _bEarlyConfigValid = TRUE;
    }
}

void dispvidctrl_tclAppMain::vGetEarlyConfig(TEarlyConfiguration& rEarlyConfig) const {
    rEarlyConfig = _tEarlyConfig;
}

tVoid dispvidctrl_tclAppMain::vHandleConfigUpdate() const
{
    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vHandleConfigUpdate entered"));
    TConfiguration   StConfigurationValues;
    _vDetermineConfiguration(StConfigurationValues);

    dispvidctrl_tclPersistentData* poPersistentData = dynamic_cast<dispvidctrl_tclPersistentData*>(getHandler("dispvidctrl_tclPersistentData"));
    DISPVIDCTRL_NULL_POINTER_CHECK(poPersistentData);

    poPersistentData->vUpdateConfiguration(&StConfigurationValues);
}

tVoid dispvidctrl_tclAppMain::vCheckOwnMessageQueueStatus(dispvidctrl_tclBaseIf::TMsg* pInternalMsg, OSAL_tMQueueHandle hWorkerMsgQueue) const
{
    ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vCheckOwnMessageQueueStatus entered"));

    tU32 _u32MsgMax, _u32MaxLen, _u32MsgCount = 0;
    dispvidctrl_tclBaseIf::ECmdTypes _enCmd = ((OSAL_NULL != pInternalMsg)?pInternalMsg->eCmd:(dispvidctrl_tclBaseIf::ECmdTypes)0);

    if ( OSAL_OK != OSAL_s32MessageQueueStatus( hWorkerMsgQueue, &_u32MsgMax, &_u32MaxLen, &_u32MsgCount ) ){
       ETG_TRACE_FATAL(( "dispvidctrl_tclAppMain::vCheckOwnMessageQueueStatus(msg: 0x%08x, queue handle: %d): !!!!!! Error detected !!!!!!",
    		   (intptr_t)pInternalMsg, (tS32)hWorkerMsgQueue ));
    }

    ETG_TRACE_USR3(("dispvidctrl_tclAppMain::vCheckOwnMessageQueueStatus(msg: 0x%08x, queue handle: %d): Current message count '%d (send: %u (%dms))'.",
    		(intptr_t)pInternalMsg, (tS32)hWorkerMsgQueue,
    		_u32MsgCount, ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)_enCmd), OSAL_ClockGetElapsedTime() ));

    tU32 _u32FillLevel = ( _u32MsgCount * 100 ) / _u32MsgMax;
    if ( _u32FillLevel > DISPVIDCTRL_QUEUE_FILL_LEVEL ){
       boost::format Format( "dispvidctrl_tclAppMain::vCheckOwnMessageQueueStatus(msg: 0x%08x, queue handle: %d): !!!!!! Error detected !!!!!! Fill level of fc meter CCA msg queue (%d%%) exceeded maximum of %d%% while sending internal command (%d) (%dms)" );
       std::string   strError = boost::str( Format % (intptr_t)pInternalMsg % (tS32)hWorkerMsgQueue % _u32FillLevel % DISPVIDCTRL_QUEUE_FILL_LEVEL % (tU32)_enCmd % OSAL_ClockGetElapsedTime());
       ETG_TRACE_ERRMEM( ( "%s", strError.c_str( ) ) );
       ETG_TRACE_FATAL( ( "%s", strError.c_str( ) ) );
    }
}

tVoid dispvidctrl_tclAppMain::vSetDefaultEarlyConfig()
{
    //Get settings data from NOR data
    int s32StreamLength = 800;
    //Allocate buffer
    unsigned char* pu8DataStreamBuffer = (unsigned char*) malloc((unsigned int)s32StreamLength);

    memcpy(pu8DataStreamBuffer, &_tEarlyConfigDefault.tEarlyNorForce, sizeof(_tEarlyConfigDefault.tEarlyNorForce));
    int s32Result = pdd_write_data_stream((const char *)"EarlyNorConfigForce", PDD_LOCATION_NOR_USER, pu8DataStreamBuffer, s32StreamLength, 1);
    free(pu8DataStreamBuffer);
    if (s32Result > 0) {
        ETG_TRACE_FATAL(("SetDefaultEarlyConfig :Early Force config Write Default %d", s32Result));
    }
    else
    {
        dispvidctrl_tclAppMain::vWriteStartupLog("SetDefaultEarlyConfig: Early Force config Write Default %d", s32Result);
    }
}

CSMInterface*  dispvidctrl_tclAppMain::pGetCsmInterface()
{
    if (_poCSMInterface == 0)
    {
        tS32 s32CanActive = CSMInterface::CSM_s32WaitForCAN(3000);
        if (s32CanActive < 0) {
            ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::pGetCsmInterface() CAN currently not active."));
        } else {
            ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::pGetCsmInterface() Waiting for CAN: %d ms.", s32CanActive));
        }

    _poCSMInterface  = OSAL_NEW CSMInterface();
    ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::pGetCsmInterface(): CSM If: %08x.", _poCSMInterface));
    }
    return _poCSMInterface;
}

// Note - special handling of AVM to avoid waiting for 3 seconds when MCAN is not required
CSMInterface*  dispvidctrl_tclAppMain::pGetCsmInterfaceAVM()
{
    if (_poCSMInterface == 0)
    {
        if(bAVMPhase3 == TRUE)
        {
            tS32 s32CanActive = CSMInterface::CSM_s32WaitForCAN(3000);
            if (s32CanActive < 0) {
                ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::pGetCsmInterfaceAVM() CAN currently not active."));
            } else {
                ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::pGetCsmInterfaceAVM() Waiting for CAN: %d ms.", s32CanActive));
            }
        }

    _poCSMInterface  = OSAL_NEW CSMInterface();
    ETG_TRACE_FATAL(("dispvidctrl_tclAppMain::pGetCsmInterfaceAVM(): CSM If: %08x.", _poCSMInterface));
    }
    return _poCSMInterface;
}

// dispvidctrl_tclAppMainUserSpecificClassCode: user specific code end


/*******************************************************************************
*                                       E O F
*******************************************************************************/
