
/*****************************************************************************
* FILE:         dispvidctrl_fsm.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     fsm.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "dispvidctrl_fsm.h"

dispvidctrl_tclFsmBase::dispvidctrl_tclFsmBase(tU32 u32InitFsmSTate, tU32 u32MaxTransitionEntry, TStateTransitions* paFsmTransitionTable,  tU32 u32MaxStateEntry, TFsmStateConf* paFsmStateTable, tU32 u32TraceClass) {

   _u32CurrentTrigger = 0;
   _u32Trigger = 0;
   _u32CurrentTriggerUpdate = 0;
   _u32TriggerUpdate = 0;
   _u32LastTransitionId = 0;
   _u32TimeOut = 0;
   _u32FsmState = u32InitFsmSTate;
   _u32LastFsmState = u32InitFsmSTate;

   _u32MaxStateEntry = u32MaxStateEntry;
   _paFsmStateTable = paFsmStateTable;

   _u32MaxTransitionEntry = u32MaxTransitionEntry;
   _paFsmTransitionTable = paFsmTransitionTable;

   _u32TraceClass = u32TraceClass;

}

dispvidctrl_tclFsmBase::~dispvidctrl_tclFsmBase(){
   _paFsmStateTable = NULL;
   _paFsmTransitionTable = NULL;
}

tVoid dispvidctrl_tclFsmBase::vSendTriggerViaWorker(tU32 u32Trigger, tBool bState){
   (tVoid) u32Trigger;
   (tVoid) bState;
   return;
}
tVoid dispvidctrl_tclFsmBase::vStateChangeDetected(){
   return;
}


tVoid dispvidctrl_tclFsmBase::vStartFsmStateTimer(tU32 u32Time)
/*!
* \fn
*  \brief
*    Start state timer. 
*    
*  \param
*     u32Time  -> intervall time in ms
*  \return
*  \note
*  \version
*    1.0   - Initial
******
*/
{
   (tVoid) u32Time;
   return;
}

tVoid dispvidctrl_tclFsmBase::vActStateExit(tU32 u32FsmState)
/*!
* \fn
*  \brief
*    Called when new system state detected by state machine and current state is leaved. 
*    
*  \param
*  \return
*    tVoid
*
*  \note
*  \version
*    1.0   - Initial
******
*/
{
   tBool bFound;
   const TFsmStateConf *prStateDescr;

   if (u32FsmState < _u32MaxStateEntry)
   {
      bFound = FALSE;
      prStateDescr = _paFsmStateTable;

      /* while state not found and not end of state table */
      while ( (bFound==FALSE) && (prStateDescr < (_paFsmStateTable + _u32MaxStateEntry) ) )
      {
         /* if state is active */
         if (u32FsmState == prStateDescr->u32FsmState)
         {
            /* call state exit function */
            bFound=TRUE;
            if (prStateDescr->pfnvStateExit) {
               (* prStateDescr->pfnvStateExit)();
            }
         }
         prStateDescr++;
      }
   }
}

tU32 dispvidctrl_tclFsmBase::u32ActStateEntry(tU32 u32NewFsmState)
/*!
* \fn
*  \brief
*    Called when new system state detected by state machine and current state has to be entered. 
*    
*  \param
*     u32NewSystemState -> system state detected by state machine
*  \return
*     u32Timeout -> timeout value in ms for new system state
*    
*  \note
*  \version
*    1.0   - Initial
******
*/
{
   tBool bFound;
   const TFsmStateConf *prStateDescr;
   tU32 u32Timeout = 0;

   if (u32NewFsmState < _u32MaxStateEntry)
   {
      bFound = FALSE;
      prStateDescr = _paFsmStateTable;

      /* while state not found and not end of state table */
      while ( (bFound==FALSE) && (prStateDescr < (_paFsmStateTable + _u32MaxStateEntry) ) )
      {
         /* if state is active */
         if (u32NewFsmState == prStateDescr->u32FsmState)
         {
            /* call state exit function */
            bFound=TRUE;
            if (prStateDescr->pfnvStateEntry) {
               (* prStateDescr->pfnvStateEntry)();
            }
            u32Timeout = prStateDescr->u32Timeout;
         }
         prStateDescr++;
      }
   }
   return u32Timeout;
}

tVoid dispvidctrl_tclFsmBase::vActStateReached(tU32 u32FsmState)
/*!
* \fn
*  \brief
*    Called when new system state is reached -> all applications has acknowledged transition. 
*    
*  \param
*     u32SystemState -> system state entered
*  \return
*    
*  \note
*  \version
*    1.0   - Initial
******
*/
{
   tBool bFound = FALSE;
   const TFsmStateConf *prStateDescr;

   if (u32FsmState < _u32MaxStateEntry)
   {
      bFound = FALSE;
      prStateDescr = _paFsmStateTable;

      /* while state not found and not end of state table */
      while ( (bFound==FALSE) && (prStateDescr < (_paFsmStateTable + _u32MaxStateEntry) ) )
      {
         /* if state is active */
         if (u32FsmState == prStateDescr->u32FsmState)
         {
            /* call state exit function */
            bFound=TRUE;
            if (prStateDescr->pfnvStateReached) {
               (* prStateDescr->pfnvStateReached)();
            }
         }
         prStateDescr++;
      }
   }

   if (bFound == FALSE) {
      // System state SPM_SYSTEM_OFF is reached --> call method directly
      //vStateReachedOff();
   } 
   return;
}

//state handling
tU32 dispvidctrl_tclFsmBase::u32CalcNewFsmState(tU32 u32Trigger, tBool bState)
/*!
* \fn
*  \brief
*    check for new system state in state transition table _arStateTable[].  
*    
*  \param
*     u32PreviousSystemState -> last valid system state
*     u32NewSystemState      -> new system state, if different to u32PreviousSystemState, system state transition is still active 
*  \return
*     u32CalcNewSystemState  -> new calculated system state
*  \note
*  \version
*    1.0   - Initial
******
*/
{
   tU32 u32CalcNewSystemState = 0xffffffff;

   tU32 u32TransitionId = FSM_U32_TRANSITION_ID_INVALID;
   tU32 u32ActionId     = FSM_DONT_CARE;

   _u32TriggerUpdate |= u32Trigger;

   if (bState) {
      _u32Trigger |= u32Trigger;
   } else {
      _u32Trigger &= ~u32Trigger;
   }

   // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Entry1: user specific code start
   #if(0)
   // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Entry1: user specific code end

   ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_TRIGGER _
         ET_EN_T32 _ _u32TriggerUpdate _
         ET_EN_T32 _ _u32Trigger _
         ET_EN_DONE);

   // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Entry2: user specific code start
   #else
   ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_TRIGGER_ALTERN _
         ET_EN_T32 _ _u32TriggerUpdate _
         ET_EN_T32 _ _u32Trigger _
         ET_EN_T32 _ _u32FsmState _
         ET_EN_T32 _ (tU32)bState _
         ET_EN_DONE);
   #endif
   // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Entry2: user specific code end

   _u32CurrentTrigger = _u32Trigger;
   _u32CurrentTriggerUpdate = _u32TriggerUpdate;
   _u32TriggerUpdate = 0;


   tU32 u32TabEntries = _u32MaxTransitionEntry;
   TStateTransitions* prTransitionDescr = _paFsmTransitionTable;
   TStateTransitions* prLastTransitionEntry  = _paFsmTransitionTable + u32TabEntries;

   if ((u32TabEntries > 0) && prTransitionDescr) {
      /* while end state not found and not end of state table */
      while ( (u32TransitionId == FSM_U32_TRANSITION_ID_INVALID) && (prTransitionDescr < prLastTransitionEntry) )
      {
         // checksystem state
         // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check1: user specific code start
         enum { eNone, eWrongState, eWrongUpdateTrigger, eWrongActiveSubstates, eWrongInactiveSubstates };
         tU32 eReason = eWrongState;
         // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check1: user specific code end
         if ((prTransitionDescr->u32CurrentFsmState == _u32FsmState) || (prTransitionDescr->u32CurrentFsmState == FSM_DONT_CARE)) {
            // is update detected
            // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check2: user specific code start
            eReason = eWrongUpdateTrigger;
            // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check2: user specific code end
            if (((prTransitionDescr->u32UpdateTrigger&_u32CurrentTriggerUpdate)==prTransitionDescr->u32UpdateTrigger) || (prTransitionDescr->u32UpdateTrigger == FSM_DONT_CARE)){
               // is substate active
               // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check3: user specific code start
               eReason = eWrongActiveSubstates;
               // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check3: user specific code end
               if (((prTransitionDescr->u32Trigger&_u32CurrentTrigger)==prTransitionDescr->u32Trigger)|| (prTransitionDescr->u32Trigger == FSM_DONT_CARE)) {
                  // is a substate not active
                  // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check4: user specific code start
                  eReason = eWrongInactiveSubstates;
                  // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check4: user specific code end
                  if (((prTransitionDescr->u32TriggerNotSet & ~_u32CurrentTrigger) ==  prTransitionDescr->u32TriggerNotSet)|| (prTransitionDescr->u32TriggerNotSet == FSM_DONT_CARE)){
                     // found a table entry
                     u32CalcNewSystemState = prTransitionDescr->u32NextFsmState;

                     u32TransitionId = prTransitionDescr->u32TransitionId;
                     u32ActionId     = prTransitionDescr->u32ActionId;

                     // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check5: user specific code start
                     eReason = eNone;
                     // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Check5: user specific code end
                  }
               }
            }
         }

         // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Mismatch: user specific code start
         if (eWrongUpdateTrigger==eReason || eWrongActiveSubstates==eReason || eWrongInactiveSubstates==eReason) {
             ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
                ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NO_MATCH_REASON _
                ET_EN_T32 _ prTransitionDescr->u32TransitionId _
                ET_EN_T32 _ eReason _
                ET_EN_DONE);
         }
         // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Mismatch: user specific code end
         prTransitionDescr++;
      }
   }

   if (u32TransitionId != FSM_U32_TRANSITION_ID_INVALID)
   {
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Match1: user specific code start
      ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NEW_STATE_ALTERN _
         ET_EN_T32 _ ((u32CalcNewSystemState != FSM_DONT_CARE) ? u32CalcNewSystemState : _u32FsmState) _
         ET_EN_T32 _ _u32FsmState _
         ET_EN_T32 _ u32TransitionId _
         ET_EN_DONE);
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Match1: user specific code end

      _u32LastTransitionId = u32TransitionId;

      if (u32CalcNewSystemState != FSM_DONT_CARE) {
          _u32LastFsmState = _u32FsmState;
          _u32FsmState = u32CalcNewSystemState;

          if (u32CalcNewSystemState != _u32LastFsmState) {
              vActStateExit(_u32LastFsmState);
          }

          vStateChangeDetected();

          /* call state entry function */
          /* this function may be empty (PM_MS_vStateDummy) or it may set used flags, trigger servers or whatever */
          _u32TimeOut = u32ActStateEntry(u32CalcNewSystemState);

          //_u32CurrentInternSubState &= ~SPM_INTERN_SUBSTATE_STATE_TIMEOUT;

          vStartFsmStateTimer(_u32TimeOut);
      }


      if (u32ActionId != FSM_DONT_CARE) {
          vTransitionAction(u32ActionId);
      }

      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Match2: user specific code start
      #if(0)
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Match2: user specific code end

      ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NEW_STATE _
         ET_EN_T32 _ _u32FsmState _
         ET_EN_T32 _ _u32LastFsmState _
         ET_EN_T32 _ _u32LastTransitionId _
         ET_EN_DONE);

      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Match3: user specific code start
      #endif
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_Match3: user specific code end
   } else {
      //no new state found
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_NoMatch1: user specific code start
      ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NO_NEW_STATE_ALTERN _
         ET_EN_T32 _ _u32FsmState _
         ET_EN_DONE);
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_NoMatch1: user specific code end

      vStateNoTransition();

      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_NoMatch2: user specific code start
      #if(0)
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_NoMatch2: user specific code end

      ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NO_NEW_STATE _
         ET_EN_DONE);

      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_NoMatch3: user specific code start
      #endif
      // dispvidctrl_tclFsmBase_u32CalcNewFsmState_NoMatch3: user specific code end
   }
     


   return(u32CalcNewSystemState);
}

tVoid dispvidctrl_tclFsmBase::vStateNoTransition(tVoid){
   return;
};

tVoid dispvidctrl_tclFsmBase::vTraceStatusInfo(tU32 u32RemainingTime) {
      ET_TRACE_INFO_BIN( (tU16)_u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_INFO _
         ET_EN_T32 _ _u32FsmState _
         ET_EN_T32 _ _u32LastFsmState _
         ET_EN_T32 _ _u32LastTransitionId _
         ET_EN_T32 _ _u32TriggerUpdate _
         ET_EN_T32 _ _u32Trigger _
         ET_EN_T32 _ _u32TimeOut _
         ET_EN_T32 _ u32RemainingTime _
         ET_EN_DONE);
}


