/*****************************************************************************
 * @file:         dispvidctrl_ClientAvmSink.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: dispvidctrl
 * @Template:     MCanSink.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          Tx Interface for MCAN communication
 *
 *          Do here client specific implementation
 *          Changes possible only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2018 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AVM
#include "trcGenProj/Header/dispvidctrl_ClientAvmSink.cpp.trc.h"
#endif

#include "dispvidctrl_ClientAvmSink.h"

dispvidctrl_tclClientAvmSink::dispvidctrl_tclClientAvmSink(dispvidctrl_tclAppMain* baseRef) : TxSinkItf (), I_dispvidctrl_tclClientAvmSink ( baseRef )
{
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientAvmSink() entered") );
   _poCSMInterface = NULL;
   // FUNCdispvidctrl_tclClientAvmSink: user specific code start
   // FUNCdispvidctrl_tclClientAvmSink: user specific code end
}

dispvidctrl_tclClientAvmSink::~dispvidctrl_tclClientAvmSink(){
   ETG_TRACE_USR1( ( "~dispvidctrl_tclClientAvmSink() entered" ) );
}

tVoid dispvidctrl_tclClientAvmSink::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg) {
   // dispvidctrl_tclClientAvmSink_vHandleMessage: user specific code start
   // dispvidctrl_tclClientAvmSink_vHandleMessage: user specific code end
}

tVoid dispvidctrl_tclClientAvmSink::vGetReferences() {
   _poCSMInterface = _cpoMain->theServer()->pGetCsmInterface();
   // dispvidctrl_tclClientAvmSink_vGetReferences: user specific code start
   // dispvidctrl_tclClientAvmSink_vGetReferences: user specific code end
}

tVoid dispvidctrl_tclClientAvmSink::vStartCommunication() {
   // dispvidctrl_tclClientAvmSinkvStartCommunication: user specific code start
   // dispvidctrl_tclClientAvmSinkvStartCommunication: user specific code end
}

tVoid dispvidctrl_tclClientAvmSink::vTraceInfo() {
   // dispvidctrl_tclClientAvmSinkvTraceInfo: user specific code start
   // dispvidctrl_tclClientAvmSinkvTraceInfo: user specific code end
}

/*************************************************************************
 * * FUNCTION:     dispvidctrl_tclClientAvmSink::DataReq()
 *
 * DESCRIPTION:  Implementation of TxSink interface DataReq Function for Sending data to CSM
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tS32
 *
 ******************************************************************************/
tS32 dispvidctrl_tclClientAvmSink::DataReq(void *pvHandle, tU32 dwProtocolType, const void *pvAddressField, const tU8 *pbData, tU16 wDataLength)
{
   //use csm object of main here and pass the message.
   ETG_TRACE_USR1(("dispvidctrl_tclClientAvmSink::DataReq() entered"));

   DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poCSMInterface);
   return _poCSMInterface->CSM_lDataReq(pvHandle,dwProtocolType,pvAddressField,pbData,wDataLength);

}

/*************************************************************************
 * * FUNCTION:     dispvidctrl_tclClientAvmSink::vSendSpeedLimit()
 *
 * DESCRIPTION:  Implementation of TxSink interface vSendSpeedLimit Function.
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tS32
 *
 ******************************************************************************/
tVoid dispvidctrl_tclClientAvmSink::vSendSpeedLimit( tU8 _u8SpeedLimitValue )
{
   (tU8)_u8SpeedLimitValue; //To resolve lint
}

/*************************************************************************
 * * FUNCTION:     dispvidctrl_tclClientAvmSink::ApplCallbackInit()
 *
 * DESCRIPTION:  Implementation of TxSink interface DataReq Function for Registering CSM call backs
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tS32
 *
 ******************************************************************************/
tS32 dispvidctrl_tclClientAvmSink::ApplCallbackInit(void *pvHandle, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt)

{
   ETG_TRACE_USR1(("dispvidctrl_tclClientAvmSink::ApplCallbackInit Entered"));

   DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poCSMInterface);
   return _poCSMInterface->CSM_lApplCallbackInit(pvHandle,dwProtocolType,pvAddressField,pvCallBackFkt);
}

/*************************************************************************
 * * FUNCTION:     dispvidctrl_tclClientAvmSink::ApplCallbackInit()
 *
 * DESCRIPTION:  Implementation of TxSink interface DataReq Function for Open or Close the communication charge.
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tS32
 *
 ******************************************************************************/
tS32 dispvidctrl_tclClientAvmSink::CommunicationReq(void *pvHandle, tU8 bBus, tU32 dwProtocolType, const void *pvAddressField, tU8 bAction, tU16 wApplID)
{
   ETG_TRACE_USR1(("dispvidctrl_tclClientAvmSink::CommunicationReq Entered"));

   DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poCSMInterface);
   return _poCSMInterface->CSM_lCommunicationReq(pvHandle,bBus,dwProtocolType,pvAddressField,bAction,wApplID);
}

// dispvidctrl_tclClientAvmSink::ClassImplementation: user specific code start

tVoid dispvidctrl_tclClientAvmSink::vGetReferencesEarly(tVoid){
    ETG_TRACE_FATAL( ( "dispvidctrl_tclClientAvmSink::vGetReferencesEarly() Entered") );
    _poCSMInterface = _cpoMain->theServer()->pGetCsmInterfaceAVM();
}

tVoid dispvidctrl_tclClientAvmSink::vStartCommunicationEarly(tVoid) {
    ETG_TRACE_FATAL( ( "dispvidctrl_tclClientAvmSink::vStartCommunicationEarly() Entered") );
}

// dispvidctrl_tclClientAvmSink::ClassImplementation: user specific code end
