#ifndef _AVMMCAN_CLIENT_ADAPTOR_H_
#define _AVMMCAN_CLIENT_ADAPTOR_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ClientAvmAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     MCanAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                MCAN adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <vector>

// dispvidctrl_tclClientAvmAdaptor::ClassIncludes: user specific code start
// dispvidctrl_tclClientAvmAdaptor::ClassIncludes: user specific code end

#include "Idispvidctrl_ClientAvmAdaptor.h"

// trace defines
class AvmEnums{
public:
   enum TRACE_ERROR_CODE {
      DISPVIDCTRLTRACE_ERROR_CODE_NOT_YET_IMPLEMENTED                                 =  0,
      DISPVIDCTRLTRACE_ERROR_CODE_CLOSE_NOTIFICATION_SEMAPHORE                        =  1,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_NOTIFICATION_SEMAPHORE                       =  2,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_WORKER_THREAD                                =  3,
      DISPVIDCTRLTRACE_ERROR_CODE_CLOSE_WORKER_EVENTS                                 =  4,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_WORKER_EVENTS                                =  5,
      DISPVIDCTRLTRACE_ERROR_CODE_CLOSE_WORKER_ACCESS_SEMAPHORE                       =  6,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_WORKER_ACCESS_SEMAPHORE                      =  7,
      DISPVIDCTRLTRACE_ERROR_CODE_PLUG_IN_TRACE                                       =  8,
      DISPVIDCTRLTRACE_ERROR_CODE_UNPLUG_TRACE                                        =  9,
      DISPVIDCTRLTRACE_ERROR_CODE_READ_WORKER_PRIO_FROM_REGISTRY                      = 11,
      DISPVIDCTRLTRACE_ERROR_CODE_READ_WORKER_STACKSIZE_FROM_REGISTRY                 = 12,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_WORKER_EVENTS                                = 13,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_WORKER_ACCESS_SEMAPHORE                      = 14,
      DISPVIDCTRLTRACE_ERROR_CODE_SPAWN_WORKER_THREAD                                 = 15,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_NOTIFICATION_SEMAPHORE                       = 16,
      DISPVIDCTRLTRACE_ERROR_CODE_ACCESS_WORKER_EVENTS                                = 17,
      DISPVIDCTRLTRACE_ERROR_CODE_WORKER_THREAD_ARGUMENT                              = 18,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_DATAPOOL_ACCESS_SEMAPHORE                    = 19,
      DISPVIDCTRLTRACE_ERROR_CODE_CLOSE_DATAPOOL_ACCESS_SEMAPHORE                     = 21,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_DATAPOOL_ACCESS_SEMAPHORE                    = 22,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_COMMUNICATION_TEST_TIMER                     = 23,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_COMMUNICATION_TEST_TIMER                     = 24,
      DISPVIDCTRLTRACE_ERROR_CODE_SET_COMMUNICATION_TEST_TIMER                        = 25,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_CONFIGURATION_GET_TIMER                      = 26,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_CONFIGURATION_GET_TIMER                      = 27,
      DISPVIDCTRLTRACE_ERROR_CODE_SET_CONFIGURATION_GET_TIMER                         = 28,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_HARDWARE_VERSION_GET_TIMER                   = 29,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_HARDWARE_VERSION_GET_TIMER                   = 31,
      DISPVIDCTRLTRACE_ERROR_CODE_SET_HARDWARE_VERSION_GET_TIMER                      = 32,
      DISPVIDCTRLTRACE_ERROR_CODE_CREATE_SOFTWARE_VERSION_GET_TIMER                   = 33,
      DISPVIDCTRLTRACE_ERROR_CODE_DELETE_SOFTWARE_VERSION_GET_TIMER                   = 34,
      DISPVIDCTRLTRACE_ERROR_CODE_SET_SOFTWARE_VERSION_GET_TIMER                      = 35,
      DISPVIDCTRLTRACE_ERROR_CODE_MAX                                                 =255
   };

   enum TRACE_TIMER_CODE {
      DISPVIDCTRLTRACE_MCAN_SET_COMMUNICATION_TEST_TIMER                   = 0x10,
      DISPVIDCTRLTRACE_MCAN_EV_COMMUNICATION_TEST_TIMER                    = 0x11,
      DISPVIDCTRLTRACE_MCAN_SET_CONFIGURATION_GET_TIMER                    = 0x12,
      DISPVIDCTRLTRACE_MCAN_EV_CONFIGURATION_GET_TIMER                     = 0x13,
      DISPVIDCTRLTRACE_MCAN_SET_HARDWARE_VERSION_GET_TIMER                 = 0x14,
      DISPVIDCTRLTRACE_MCAN_EV_HARDWARE_VERSION_GET_TIMER                  = 0x15,
      DISPVIDCTRLTRACE_MCAN_SET_SOFTWARE_VERSION_GET_TIMER                 = 0x16,
      DISPVIDCTRLTRACE_MCAN_EV_SOFTWARE_VERSION_GET_TIMER                  = 0x17,
   };

   enum BOOL{
      STATE_FALSE  =    0,
      STATE_TRUE   =    1
   };

   enum MCAN_tenComStatus
   {
       MCAN_EN_COMM_STATUS_OFF,
       MCAN_EN_COMM_STATUS_NOT_CONNECTED,
       MCAN_EN_COMM_STATUS_CONNECTION_WAIT,
       MCAN_EN_COMM_STATUS_CONNECTED,
       MCAN_EN_COMM_STATUS_CONNECTION_ERROR,
       MCAN_EN_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR
   };

};

class dispvidctrl_tclClientAvmAdaptor : public I_dispvidctrl_tclClientAvmAdaptor
{
private: 
    // my own instance
   static dispvidctrl_tclClientAvmAdaptor*     _poMyOwnRef;
   AvmMCanAvmCallbackIf*                     _pClientCallback;
   
   tU16                                                           _u16MessageInSending;   
   
   typedef struct{
       tU16  u16MsgId;
       tU8   u8MsgOpcode;
       tBool bTxDirection;
       tU32  u32Timestamp;
   }TMsgHistory;

   std::vector < TMsgHistory > _vecMsgHistory;

   tVoid vLogNewMsg(tU16  u16MsgId, tU8   u8MsgOpcode, tBool bTransmit) {
       TMsgHistory oHis;
       oHis.bTxDirection   = bTransmit;
       oHis.u16MsgId       = u16MsgId;
       oHis.u8MsgOpcode    = u8MsgOpcode;
       oHis.u32Timestamp   = OSAL_ClockGetElapsedTime();
       _vecMsgHistory.push_back(oHis);
       if (_vecMsgHistory.size() > 50) {
           _vecMsgHistory.erase(_vecMsgHistory.begin());
       }
   }   

public:
    dispvidctrl_tclClientAvmAdaptor(dispvidctrl_tclAppMain* baseRef);
    virtual ~dispvidctrl_tclClientAvmAdaptor();

    virtual tVoid vSetCallbackIf(AvmMCanAvmCallbackIf* pCallback) {
        _pClientCallback = pCallback;
    };

    tBool bOnInit();

    // debug functions
    tVoid vShowCommunicationState();
    tVoid vShowVersioninfo();
    
    virtual tBool bAllowedToSend() {return (bIsConnected() && bIsAllowedToSendCData());};
    virtual tU8   u8GetUnitId() const {return u8GetUnitID();};    
    virtual tBool bIsConnectionAvailable() {return bIsConnected();}

   // function called when the system changes to ON without change of connection
   // -> retrigger all messages that were blocked during "not ON"

   virtual tVoid vDoActionsAfterChangeToOn();


   // function called when the system leaves ON without change of connection
   // -> send AUDIO_OFF to meter

   virtual tVoid vDoActionsAfterLeavingOn();


   // callbacks for the CSM interface

   static tVoid csm_callback_vCommunicationCon
                   ( 
                      tVoid* pvHandle, 
                      tU8 u8Bus, 
                      tU32 u32ProtocolType, 
                      const tVoid* pvAddressfield, 
                      tU8 u8ConnectState, 
                      tU16 u16ApplId
                   );

   static tVoid csm_callback_vCommunicationInd
                   ( 
                      tVoid* pvHandle, 
                      tU8 u8Bus, 
                      tU32 u32ProtocolType, 
                      const tVoid* pvAddressfield, 
                      tU8 u8ConnectState, 
                      tU16 u16ApplId
                   );
   
   static tVoid csm_callback_vCDataCon
                   ( 
                      tVoid* pvHandle, 
                      tU32 u32ProtocolType, 
                      const tVoid* pvAddressfield, 
                      tU8 u8State
                   );
   
   static tVoid csm_callback_vCDataInd
                   ( 
                      tVoid* pvHandle, 
                      tU32 u32ProtocolType, 
                      const tVoid* pvAddressfield, 
                      tU8* pu8Data, 
                      tU16 u16Length
                   );
   
   static tVoid csm_callback_vDDataCon
                   ( 
                      tVoid* pvHandle, 
                      tU32 u32ProtocolType, 
                      const tVoid* pvAddressfield, 
                      tU8 u8State
                   );
   
   static tVoid csm_callback_vDDataInd
                   ( 
                      tVoid* pvHandle, 
                      tU32 u32ProtocolType, 
                      const tVoid* pvAddressfield, 
                      tU8* pu8Data, 
                      tU16 u16Length
                   );

   // do the handling for incoming CSM messages that are specific for this unit
   virtual tVoid vHandleUnitSpecificDataInd    ( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16Length );
   virtual tVoid vHandleUnitSpecificDataIndCtxt( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16Length );

protected:
    // creation of unit specific timers
    virtual tVoid vCreateUnitSpecificTimers();

   // do the checking of the unit specific trigger flags to do a data request
   virtual tVoid vCheckForUnitSpecificDataRequests();

   // handle the unit specific events
   virtual OSAL_tEventMask hHandleUnitSpecificEvents( OSAL_tEventMask hEvents );

   // do the actions when initialization is set to incomplete, i.e. when configuration has to be exchanged
   virtual tVoid vDoActionsWhenInitializationIncomplete();

   // do the actions after initialization is complete, i.e. after configuration and versions have been received
   virtual tVoid vDoActionsAfterInitializationComplete();

   // functions called to send a data update to possible CCA clients

   virtual tVoid vSendConnection();
   virtual tVoid vSendConfiguration();
   virtual tVoid vSendHardwareVersion();
   virtual tVoid vSendSoftwareVersion();
   virtual tVoid vSendDataTransmission();
   virtual tVoid vSendCurrentCommTestResult();
   virtual tVoid vSendCurrentCDataConfTestResult();
   virtual tVoid vSendCurrentDDataConfTestResult();


protected:
    virtual tBool bUnitShouldBeAvailable();

    // for trace outputs
    virtual tVoid vTraceError( MCAN_tenErrorCode enErrorCode );
    virtual tVoid vTraceIncomingMessage( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16DataLength );
    virtual tVoid vTraceConnectionStateConnected();
    virtual tVoid vTraceConnectionStateDisconnected( tBool bInfoFromIndication );
    virtual tVoid vTraceCommunicationRequestConnect();
    virtual tVoid vTraceCommunicationRequestDisconnect();
    virtual tVoid vTraceSendingConfigurationGet();
    virtual tVoid vTraceSendingConfigurationStatus();
    virtual tVoid vTraceSendingHardwareVersionGet();
    virtual tVoid vTraceSendingSoftwareVersionGet();
    virtual tVoid vTraceBasicTimerEvent( MCAN_tenBasicTimer enTimer );
    virtual tVoid vTraceBasicTimerSet( MCAN_tenBasicTimer enTimer, OSAL_tMSecond msTimeout );


public:
    virtual const tChar* getName() const { return "dispvidctrl_tclClientAvmAdaptor"; }

    virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();

    virtual tBool sendSoftware_VersionGetOut(tcl_ITM_Camera_System_Software_Version_GetOut& oIn_Software_Version);
    virtual tBool sendHardware_VersionGetOut(tcl_ITM_Camera_System_Hardware_Version_GetOut& oIn_Hardware_Version);
    virtual tBool sendSW_SignalIndicationOut(tcl_ITM_Camera_System_SW_Signal_IndicationOut& oIn_SW_Signal);
    virtual tBool sendView_Change_08AVMStatusOut(tcl_ITM_Camera_System_View_Change_08AVM_StatusOut& oIn_View_Change_08AVM);
    virtual tBool sendDirect_Camera_OFFIndicationOut(tcl_ITM_Camera_System_Direct_Camera_OFF_IndicationOut& oIn_Direct_Camera_OFF);
    virtual tBool sendAVM_Sonar_BuzzerSetOut(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_SetOut& oIn_AVM_Sonar_Buzzer);
    virtual tBool sendCamera_Setting_08AVMSetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_SetOut& oIn_Camera_Setting_08AVM);
    virtual tBool sendCamera_Setting_08AVMGetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_GetOut& oIn_Camera_Setting_08AVM);
    virtual tBool sendCamera_Primary_SettingSetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_SetOut& oIn_Camera_Primary_Setting);
    virtual tBool sendCamera_Primary_SettingGetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_GetOut& oIn_Camera_Primary_Setting);
    virtual tBool sendMCAN_Communication_ErrorGetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_GetOut& oIn_MCAN_Communication_Error);
    virtual tBool sendMCAN_Communication_Error_ClearSetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_SetOut& oIn_MCAN_Communication_Error_Clear);
    virtual tBool sendCamera_Diag_SensorSetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_SetOut& oIn_Camera_Diag_Sensor);
    virtual tBool sendCamera_Diag_SensorGetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_GetOut& oIn_Camera_Diag_Sensor);

// dispvidctrl_tclClientAvmAdaptor::ClassImplementation: user specific code start
// dispvidctrl_tclClientAvmAdaptor::ClassImplementation: user specific code end
};

#endif // _AVMMCAN_CLIENT_ADAPTOR_H_

