#ifndef _I_EARLYINCADAPTOR_H_
#define _I_EARLYINCADAPTOR_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          I_dispvidctrl_ClientEarlyIncAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     IincAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "DatagramSocket.h"
#include "DatagramSocketCallbackIf.h"

//include base class
#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_ClientEarlyIncFiDef.h"

class EarlyIncCallbackIf;

class I_dispvidctrl_tclClientEarlyIncAdaptor : public DatagramSocketCallbackIf,  public dispvidctrl_tclBaseIf
{
public:
    I_dispvidctrl_tclClientEarlyIncAdaptor(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
    virtual ~I_dispvidctrl_tclClientEarlyIncAdaptor(){}

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientEarlyIncAdaptor"; };

    virtual tVoid vSetCallbackIf(EarlyIncCallbackIf* poCallback) = 0;

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
    virtual tBool sendCOMMUNICATION_CTRL(tU8 u8InitComm, tU8 u8AutoMode) = 0;
    virtual tBool sendGET_SIGNALS(tU8 u8InitSig, tU16 u16Signal) = 0;
    virtual tBool sendUPDATE_SIGNALS() = 0;
    virtual tBool sendACTION(::early_inc_fi::EAction Action, tU8 u8Parameter) = 0;

    // I_dispvidctrl_tclClientEarlyIncAdaptor_AddClassPart: user specific code start
    // I_dispvidctrl_tclClientEarlyIncAdaptor_AddClassPart: user specific code end
};

#endif // _I_EARLYINCADAPTOR_H_

