/*****************************************************************************
* FILE:         dispvidctrl_ClientDimmingIncAdaptor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     incAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

//include base class
#include "dispvidctrl_AppMain.h"

#include "Dimming_incCallbackIf.h"
#include "dispvidctrl_ClientDimmingIncAdaptor.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <dirent.h>
#include <mntent.h>

#include "inc.h"
#include "inc_ports.h"
#include "dgram_service.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING
#include "trcGenProj/Header/dispvidctrl_ClientDimmingIncAdaptor.cpp.trc.h"
#endif

// dispvidctrl_tclClientDimmingIncAdaptorIncludes: user specific code start
#include "I_dispvidctrl_tclSyncHandler.h"
// dispvidctrl_tclClientDimmingIncAdaptorIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

dispvidctrl_tclClientDimmingIncAdaptor::dispvidctrl_tclClientDimmingIncAdaptor(dispvidctrl_tclAppMain* poMainAppl) : 
I_dispvidctrl_tclClientDimmingIncAdaptor(poMainAppl)
{

    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::dispvidctrl_tclClientDimmingIncAdaptor(): Called.... ."));

   _poDatagramSocket = new DatagramSocket(this, 8000, 100, DIMMING_PORT, AF_BOSCH_INC_AUTOSAR, TRUE);
   _poCallbackIf     = OSAL_NULL;
   
   // dispvidctrl_tclClientDimmingIncAdaptor::dispvidctrl_tclClientDimmingIncAdaptor: user specific code start
   _tAppState    = ::dimming_inc_fi::eINACTIVE;
   _bDimState    = FALSE;
   _u8AppVersion = 0xff;   
   // dispvidctrl_tclClientDimmingIncAdaptor::dispvidctrl_tclClientDimmingIncAdaptor: user specific code end   
}

dispvidctrl_tclClientDimmingIncAdaptor::~dispvidctrl_tclClientDimmingIncAdaptor()
{

   ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::~dispvidctrl_tclClientDimmingIncAdaptor(): Called.... ."));

   if( OSAL_NULL != _poDatagramSocket) {
      OSAL_DELETE _poDatagramSocket;
   }
   
   _poDatagramSocket = OSAL_NULL;
   _poCallbackIf     = OSAL_NULL;
}

tVoid dispvidctrl_tclClientDimmingIncAdaptor::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eCmdIncMsgReceived) {
       vDispatchMessage(pMsg->u.au8Data, DISPVIDCTRLINTERNAL_MSG_LEN);
   }
   // dispvidctrl_tclClientDimmingIncAdaptor::vHandleMessage: user specific code start
   // dispvidctrl_tclClientDimmingIncAdaptor::vHandleMessage: user specific code end
}

tVoid dispvidctrl_tclClientDimmingIncAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
    DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientDimmingIncAdaptor::vHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientDimmingIncAdaptor::vHandleTraceMessage: user specific code end
}

tVoid dispvidctrl_tclClientDimmingIncAdaptor::vGetReferences() {
   // dispvidctrl_tclClientDimmingIncAdaptor::vGetReferences: user specific code start
   // dispvidctrl_tclClientDimmingIncAdaptor::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclClientDimmingIncAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::vTraceInfo() entered."));
   // dispvidctrl_tclClientDimmingIncAdaptor::vTraceInfo: user specific code start
   // dispvidctrl_tclClientDimmingIncAdaptor::vTraceInfo: user specific code end

}


tVoid dispvidctrl_tclClientDimmingIncAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::vStartCommunication() entered."));
   // dispvidctrl_tclClientDimmingIncAdaptor::vStartCommunication: user specific code start
   // dispvidctrl_tclClientDimmingIncAdaptor::vStartCommunication: user specific code end
}

tBool dispvidctrl_tclClientDimmingIncAdaptor::sendMessage(tU8* u8buf, tU32 ulen) {

    tBool bRet = FALSE;
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimmingIncAdaptor::sendMessage(): Called.... ."));
    if (_poDatagramSocket) {
        ETG_TRACE_USR1(("dispvidctrl_tclClientDimmingIncAdaptor::sendMessage():  Send message ID: %02x, datalen %d.", (tU8)u8buf[0], ulen));

        if (0 != _poDatagramSocket->sendMessage((void*)u8buf, ulen)) {
            bRet = TRUE;
        }
    }
    return bRet;
}

void dispvidctrl_tclClientDimmingIncAdaptor::onNewDatagramMessage(void* data, size_t length)
{
    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eCmdIncMsgReceived;
    memset(oMsg.strClassName, 0, 50);
    OSAL_szStringNCopy(oMsg.strClassName, "I_dispvidctrl_tclClientDimmingIncAdaptor", strlen("I_dispvidctrl_tclClientDimmingIncAdaptor"));

    if (length <= DISPVIDCTRLINTERNAL_MSG_LEN) {
        (tVoid)OSAL_pvMemoryCopy(oMsg.u.au8Data, data, length);
        _cpoMain->theServer()->vPostInternalMessage(&oMsg);
    } else {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientDimmingIncAdaptor::onNewDatagramMessage(): message too long."));
        // dispvidctrl_tclClientDimmingIncAdaptor::onNewDatagramMessage: user specific code start
        // dispvidctrl_tclClientDimmingIncAdaptor::onNewDatagramMessage: user specific code end        
    }

}

void dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage(void* data, size_t length)
{
   tU8* pu8Data = (tU8*)data;
   ETG_TRACE_USR1(("dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage() entered -> data: %*x", ETG_LIST_LEN(length), ETG_LIST_PTR_T8((tU8*)data)));

   // dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage: user specific code start
   if ( (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_COMPONENT_STATUS == pu8Data[0] ) {  // need an else-branch for if(_poCallbackIf), but generated standard code further down doesn't have any
      _tAppState    = (::dimming_inc_fi::EApplicationStatus)pu8Data[1];
      _u8AppVersion = (tU8)pu8Data[2];
      if (_poCallbackIf) {
          _poCallbackIf->onCOMPONENT_STATUS((::dimming_inc_fi::EApplicationStatus)pu8Data[1], (tU8)pu8Data[2]);
      }
      else
      {
         if (_tAppState == ::dimming_inc_fi::eACTIVE)
         {
            //ETG_TRACE_FATAL(("dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage(): request for Dimming Mode State"));
            sendINFO_GET_DIMMINGMODE_STATE();
         }
      }
      return;
   }
   if ( (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_INFO_GET_DIMMINGMODE_STATE == pu8Data[0] ) {  // need an else-branch for if(_poCallbackIf), but generated standard code further down doesn't have any
      if (_poCallbackIf) {
          _poCallbackIf->onINFO_GET_DIMMINGMODE_STATE((::dimming_inc_fi::EDimmingModeStatus)pu8Data[1], (tS8)pu8Data[2]);
      }
      else
      {
         //ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage(): received early Dimming Mode State:%d ",OSAL_ClockGetElapsedTime(), pu8Data[1]));
         // inform sync handler for early day/night handling in video player
         I_dispvidctrl_tclSyncHandler* poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
         if (poSyncHandler)
         {
             switch (pu8Data[1])
             {
                case 0x01: //Day
                case 0x03: //Auto-Day
                   poSyncHandler->vHandleControl(EN_CONTROL_SH__DIMMING_INC_CAR_MODE_DAY);
                   break;
                case 0x02: //Night
                case 0x04: //Auto-Night
                   poSyncHandler->vHandleControl(EN_CONTROL_SH__DIMMING_INC_CAR_MODE_NIGHT);
                   break;
                default:
                   ETG_TRACE_FATAL(("dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage(): INVALID Dimming Mode State received:%d", pu8Data[1]));
                   break;
             }
         }
      }
      return;
   }
   // dispvidctrl_tclClientDimmingIncAdaptor::vDispatchMessage: user specific code end

   switch (pu8Data[0]) {
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_COMPONENT_STATUS:
           if (_poCallbackIf) {
               _poCallbackIf->onCOMPONENT_STATUS((::dimming_inc_fi::EApplicationStatus)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_REJECT:
           if (_poCallbackIf) {
               _poCallbackIf->onREJECT((::dimming_inc_fi::ERejectReason)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DISPLAY_REQ:
           if (_poCallbackIf) {
               _poCallbackIf->onDISPLAY_REQ((::dimming_inc_fi::EDisplayRequest)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DISPLAY_READY:
           if (_poCallbackIf) {
               _poCallbackIf->onDISPLAY_READY((::dimming_inc_fi::EDisplayReady)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DISP_SET_BRIGHTNESS_LEVEL:
           if (_poCallbackIf) {
               _poCallbackIf->onDISP_SET_BRIGHTNESS_LEVEL((tU8)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DISP_SET_DIMMING:
           if (_poCallbackIf) {
               _poCallbackIf->onDISP_SET_DIMMING((tU32)((tU32)pu8Data[4]<<24)|((tU32)pu8Data[3]<<16)|((tU32)pu8Data[2]<<8)|((tU32)pu8Data[1]), (tU8)pu8Data[5]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_INFO_SET_DIMMINGMODE_CONFIG:
           if (_poCallbackIf) {
               _poCallbackIf->onINFO_SET_DIMMINGMODE_CONFIG((::dimming_inc_fi::EDimmingMode)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_INFO_GET_DIMMINGMODE_STATE:
           if (_poCallbackIf) {
               _poCallbackIf->onINFO_GET_DIMMINGMODE_STATE((::dimming_inc_fi::EDimmingModeStatus)pu8Data[1], (tS8)pu8Data[2]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_DISP_READ_BRIGHT_VAL:
           if (_poCallbackIf) {
               _poCallbackIf->onDIAG_DISP_READ_BRIGHT_VAL((tU8)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_KEYB_READ_BRIGHT_VAL:
           if (_poCallbackIf) {
               _poCallbackIf->onDIAG_KEYB_READ_BRIGHT_VAL((tU8)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_KEYB_SET_DIMMING:
           if (_poCallbackIf) {
               _poCallbackIf->onDIAG_KEYB_SET_DIMMING((tU8)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_SESSION:
           if (_poCallbackIf) {
               _poCallbackIf->onDIAG_SESSION((::dimming_inc_fi::ESessionType)pu8Data[1]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_READ_BRIGHTNESS_VAL:
           if (_poCallbackIf) {
               _poCallbackIf->onDIAG_READ_BRIGHTNESS_VAL((::dimming_inc_fi::EDeviceType)pu8Data[1], (tU16)((tU16)pu8Data[3]<<8)|((tU16)pu8Data[2]));
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_SET_BRIGHTNESS_VAL:
           if (_poCallbackIf) {
               _poCallbackIf->onDIAG_SET_BRIGHTNESS_VAL((::dimming_inc_fi::EDeviceType)pu8Data[1], (tU16)((tU16)pu8Data[3]<<8)|((tU16)pu8Data[2]));
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_GET_DIMMING_INFO_PRJ:
           if (_poCallbackIf) {
               _poCallbackIf->onGET_DIMMING_INFO_PRJ((tU32)((tU32)pu8Data[4]<<24)|((tU32)pu8Data[3]<<16)|((tU32)pu8Data[2]<<8)|((tU32)pu8Data[1]));
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_SECOND_DISP_GET_HW_VERSION:
           if (_poCallbackIf) {
               _poCallbackIf->onSECOND_DISP_GET_HW_VERSION((tU32)((tU32)pu8Data[4]<<24)|((tU32)pu8Data[3]<<16)|((tU32)pu8Data[2]<<8)|((tU32)pu8Data[1]));
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_SECOND_DISP_GET_SW_VERSION:
           if (_poCallbackIf) {
               _poCallbackIf->onSECOND_DISP_GET_SW_VERSION((tU32)((tU32)pu8Data[4]<<24)|((tU32)pu8Data[3]<<16)|((tU32)pu8Data[2]<<8)|((tU32)pu8Data[1]));
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_SECOND_DISP_SET_DISPLAY_PARAMETERS:
           if (_poCallbackIf) {
               _poCallbackIf->onSECOND_DISP_SET_DISPLAY_PARAMETERS((tU16)((tU16)pu8Data[2]<<8)|((tU16)pu8Data[1]), (tU16)((tU16)pu8Data[4]<<8)|((tU16)pu8Data[3]), (tU8)pu8Data[5]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_SECOND_DISP_GET_DIMMING_PARAMETERS:
           if (_poCallbackIf) {
               _poCallbackIf->onSECOND_DISP_GET_DIMMING_PARAMETERS((tU8)pu8Data[1], (tU8)pu8Data[2], (tU8)pu8Data[3], (tU8)pu8Data[4], (tU8)pu8Data[5], (tU16)((tU16)pu8Data[7]<<8)|((tU16)pu8Data[6]));
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_SEND_POWERMODE_TO_V850:
           if (_poCallbackIf) {
               _poCallbackIf->onSEND_POWERMODE_TO_V850((tU8)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::dimming_inc_fi::eSCC_DIMMING_R_SECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT:
           if (_poCallbackIf) {
               _poCallbackIf->onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT((tU16)((tU16)pu8Data[2]<<8)|((tU16)pu8Data[1]));
           }
           break;
       default:
           break;
   }
}

tBool dispvidctrl_tclClientDimmingIncAdaptor::sendCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_COMPONENT_STATUS, (tU8)ApplicationStatus, (tU8)ApplicationVersion};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendCOMPONENT_STATUS(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendCOMPONENT_STATUS: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendCOMPONENT_STATUS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_REJECT, (tU8)RejectReason, (tU8)RejectedMsgID};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendREJECT(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendREJECT: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendREJECT: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DISPLAY_REQ, (tU8)DisplayRequest};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_REQ(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_REQ: user specific code start
    //ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_REQ()",OSAL_ClockGetElapsedTime()));
    _bDimState = (DisplayRequest == ::dimming_inc_fi::eACTIVATE_DISPLAY) ? TRUE : FALSE;
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_REQ: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DISPLAY_READY, (tU8)DisplayReady};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_READY(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_READY: user specific code start
    //ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_READY()",OSAL_ClockGetElapsedTime()));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISPLAY_READY: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DISP_SET_BRIGHTNESS_LEVEL, (tU8)DimmingModeAndDispBrightnessLevel};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_BRIGHTNESS_LEVEL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_BRIGHTNESS_LEVEL: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_BRIGHTNESS_LEVEL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_DIMMING(tU32 DispBrightness) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DISP_SET_DIMMING, (tU8)((0x000000FF & ((tU32)DispBrightness)) >> 0), (tU8)((0x0000FF00 & ((tU32)DispBrightness)) >> 8), (tU8)((0x00FF0000 & ((tU32)DispBrightness)) >> 16), (tU8)((0xFF000000 & ((tU32)DispBrightness)) >> 24)};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_DIMMING(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_DIMMING: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDISP_SET_DIMMING: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendKEY_SET_BRIGHTNESS_LEVEL(tU8 KeyBrightnessLevel) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_KEY_SET_BRIGHTNESS_LEVEL, (tU8)KeyBrightnessLevel};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendKEY_SET_BRIGHTNESS_LEVEL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendKEY_SET_BRIGHTNESS_LEVEL: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendKEY_SET_BRIGHTNESS_LEVEL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_INFO_SET_DIMMINGMODE_CONFIG, (tU8)DimmingMode};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_SET_DIMMINGMODE_CONFIG(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_SET_DIMMINGMODE_CONFIG: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_SET_DIMMINGMODE_CONFIG: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_GET_DIMMINGMODE_STATE() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_INFO_GET_DIMMINGMODE_STATE};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_GET_DIMMINGMODE_STATE(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_GET_DIMMINGMODE_STATE: user specific code start
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_GET_DIMMINGMODE_STATE()",OSAL_ClockGetElapsedTime()));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendINFO_GET_DIMMINGMODE_STATE: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_DISP_READ_BRIGHT_VAL() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DIAG_DISP_READ_BRIGHT_VAL};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_DISP_READ_BRIGHT_VAL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_DISP_READ_BRIGHT_VAL: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_DISP_READ_BRIGHT_VAL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_READ_BRIGHT_VAL() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DIAG_KEYB_READ_BRIGHT_VAL};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_READ_BRIGHT_VAL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_READ_BRIGHT_VAL: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_READ_BRIGHT_VAL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DIAG_KEYB_SET_DIMMING, (tU8)KeyB_Brightness};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_SET_DIMMING(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_SET_DIMMING: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_KEYB_SET_DIMMING: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SESSION, (tU8)Session_Type};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SESSION(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SESSION: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SESSION: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DIAG_READ_BRIGHTNESS_VAL, (tU8)Device_Type};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_READ_BRIGHTNESS_VAL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_READ_BRIGHTNESS_VAL: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_READ_BRIGHTNESS_VAL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SET_BRIGHTNESS_VAL, (tU8)Device_Type, (tU8)((0x00FF & ((tU16)Brightness)) >> 0), (tU8)((0xFF00 & ((tU16)Brightness)) >> 8)};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SET_BRIGHTNESS_VAL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SET_BRIGHTNESS_VAL: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendDIAG_SET_BRIGHTNESS_VAL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendGET_DIMMING_INFO_PRJ() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_GET_DIMMING_INFO_PRJ};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendGET_DIMMING_INFO_PRJ(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendGET_DIMMING_INFO_PRJ: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendGET_DIMMING_INFO_PRJ: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_HW_VERSION() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SECOND_DISP_GET_HW_VERSION};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_HW_VERSION(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_HW_VERSION: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_HW_VERSION: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SW_VERSION() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SECOND_DISP_GET_SW_VERSION};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SW_VERSION(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SW_VERSION: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SW_VERSION: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_SET_DISPLAY_PARAMETERS(::dimming_inc_fi::ESecondDisplayParamID e16SecondDisplayParamID, tU16 u16ParameterValue) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SECOND_DISP_SET_DISPLAY_PARAMETERS, (tU8)e16SecondDisplayParamID, (tU8)((0x00FF & ((tU16)u16ParameterValue)) >> 0), (tU8)((0xFF00 & ((tU16)u16ParameterValue)) >> 8)};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_SET_DISPLAY_PARAMETERS(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_SET_DISPLAY_PARAMETERS: user specific code start
    if (this) {  // effectively equivalent to 'if(1)', but (hopefully) without upsetting lint or Coverity ;-) ...
        // eis2hi: we need a fix for a bug in the application generator, which currently handles enums with basetype != tU8 incorrectly
        tU8 au8DataCorr[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SECOND_DISP_SET_DISPLAY_PARAMETERS,
                             (tU8)((0x00FF & ((tU16)e16SecondDisplayParamID)) >> 0), (tU8)((0xFF00 & ((tU16)e16SecondDisplayParamID)) >> 8),
                             (tU8)((0x00FF & ((tU16)u16ParameterValue))       >> 0), (tU8)((0xFF00 & ((tU16)u16ParameterValue))       >> 8) };
        return sendMessage(au8DataCorr, sizeof(au8DataCorr));
    }
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_SET_DISPLAY_PARAMETERS: user specific code end
	//CID: 90908
	//Commenting the below func call as it will never get called.
   // return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_DIMMING_PARAMETERS() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SECOND_DISP_GET_DIMMING_PARAMETERS};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_DIMMING_PARAMETERS(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_DIMMING_PARAMETERS: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_DIMMING_PARAMETERS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendSEND_POWERMODE_TO_V850(tU8 u8PowerMode) {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SEND_POWERMODE_TO_V850, (tU8)u8PowerMode};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendSEND_POWERMODE_TO_V850(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSEND_POWERMODE_TO_V850: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSEND_POWERMODE_TO_V850: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT() {
    tU8 au8Data[] = {(tU8)::dimming_inc_fi::eSCC_DIMMING_C_SECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT};
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: user specific code start
    // dispvidctrl_tclClientDimmingIncAdaptor::sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}

// dispvidctrl_DIMMINGAdaptorAddClassPart: user specific code start

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientDimmingIncAdaptor::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_USR1(("dispvidctrl_tclClientDimmingIncAdaptor::vGetReferencesEarly() entered."));
}


/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientDimmingIncAdaptor::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_USR1(("[%d ms] dispvidctrl_tclClientDimmingIncAdaptor::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));
   sendCOMPONENT_STATUS( ::dimming_inc_fi::eACTIVE, 1);
}

// dispvidctrl_DIMMINGAdaptorAddClassPart: user specific code end
