#ifndef _I_DIMMINGINCADAPTOR_H_
#define _I_DIMMINGINCADAPTOR_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          I_dispvidctrl_ClientDimmingIncAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     IincAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "DatagramSocket.h"
#include "DatagramSocketCallbackIf.h"

//include base class
#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_ClientDimmingIncFiDef.h"

class DimmingIncCallbackIf;

class I_dispvidctrl_tclClientDimmingIncAdaptor : public DatagramSocketCallbackIf,  public dispvidctrl_tclBaseIf
{
public:
    I_dispvidctrl_tclClientDimmingIncAdaptor(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
    virtual ~I_dispvidctrl_tclClientDimmingIncAdaptor(){}

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientDimmingIncAdaptor"; };

    virtual tVoid vSetCallbackIf(DimmingIncCallbackIf* poCallback) = 0;

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
    virtual tBool sendREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) = 0;
    virtual tBool sendDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest) = 0;
    virtual tBool sendDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady) = 0;
    virtual tBool sendDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel) = 0;
    virtual tBool sendDISP_SET_DIMMING(tU32 DispBrightness) = 0;
    virtual tBool sendKEY_SET_BRIGHTNESS_LEVEL(tU8 KeyBrightnessLevel) = 0;
    virtual tBool sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode) = 0;
    virtual tBool sendINFO_GET_DIMMINGMODE_STATE() = 0;
    virtual tBool sendDIAG_DISP_READ_BRIGHT_VAL() = 0;
    virtual tBool sendDIAG_KEYB_READ_BRIGHT_VAL() = 0;
    virtual tBool sendDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness) = 0;
    virtual tBool sendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) = 0;
    virtual tBool sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type) = 0;
    virtual tBool sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) = 0;
    virtual tBool sendGET_DIMMING_INFO_PRJ() = 0;
    virtual tBool sendSECOND_DISP_GET_HW_VERSION() = 0;
    virtual tBool sendSECOND_DISP_GET_SW_VERSION() = 0;
    virtual tBool sendSECOND_DISP_SET_DISPLAY_PARAMETERS(::dimming_inc_fi::ESecondDisplayParamID e16SecondDisplayParamID, tU16 u16ParameterValue) = 0;
    virtual tBool sendSECOND_DISP_GET_DIMMING_PARAMETERS() = 0;
    virtual tBool sendSEND_POWERMODE_TO_V850(tU8 u8PowerMode) = 0;
    virtual tBool sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT() = 0;

    // I_dispvidctrl_tclClientDimmingIncAdaptor_AddClassPart: user specific code start
    virtual tVoid getComponentStatus(::dimming_inc_fi::EApplicationStatus& ApplicationStatus, tU8& ApplicationVersion) = 0;
    virtual tBool bIsBacklightActive() = 0;
    // I_dispvidctrl_tclClientDimmingIncAdaptor_AddClassPart: user specific code end
};

#endif // _I_DIMMINGINCADAPTOR_H_

