

/*****************************************************************************
* FILE:         dispvidctrl_ClientVehicledata.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// dispvidctrl_tclClientVehicledataIncludes: user specific code start
// dispvidctrl_tclClientVehicledataIncludes: user specific code end

#include "dispvidctrl_ClientVehicledata.h"
#include "dispvidctrl_ClientVehicledataCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VEHICLEDATA
#include "trcGenProj/Header/dispvidctrl_ClientVehicledata.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define VEHICLEDATA_SERVICE_ID              63
#define VEHICLEDATA_FI_MAJOR_VERSION        1
#define VEHICLEDATA_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientVehicledata, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_REVERSEGEAR, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleReverseGearOpStatus)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAMTXT, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleCamTxtOpStatus)
   // dispvidctrl_tclClientVehicledata_MsgMap: user specific code start
   // dispvidctrl_tclClientVehicledata_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVehicledata::
*             dispvidctrl_tclClientVehicledata(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVehicledata::dispvidctrl_tclClientVehicledata(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientVehicledata(poMainAppl, VEHICLEDATA_SERVICE_ID, VEHICLEDATA_FI_MAJOR_VERSION, VEHICLEDATA_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledata() entered."));
    dispvidctrl_tclAppMain::vWriteStartupLog("dispvidctrl_tclClientVehicledata entered");
   _poCallbackIf = OSAL_NULL;
   _State_ReverseGearStatus = 0;
   
   // dispvidctrl_tclClientVehicledataConstructor: user specific code start
   // dispvidctrl_tclClientVehicledataConstructor: user specific code end
   vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_REVERSEGEAR);
   vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_CAMTXT);
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVehicledata::
*             ~dispvidctrl_tclClientVehicledata(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVehicledata::~dispvidctrl_tclClientVehicledata(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientVehicledata() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientVehicledataDestructor: user specific code start
   // dispvidctrl_tclClientVehicledataDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientVehicledata.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     VEHICLEDATA_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledata::vGetReferences() entered."));
   
   // dispvidctrl_tclClientVehicledatavGetReferences: user specific code start
   // dispvidctrl_tclClientVehicledatavGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledata::vStartCommunication() entered."));
   // dispvidctrl_tclClientVehicledatavStartCommunication: user specific code start
   // dispvidctrl_tclClientVehicledatavStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledata::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientVehicledatavHandleMessage: user specific code start
   // dispvidctrl_tclClientVehicledatavHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledata::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientVehicledatavHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientVehicledatavHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vTraceInfo()
{
   ETG_TRACE_USR4(("Property support:      ReverseGear (VEHICLE_MAINFI_C_U16_REVERSEGEAR) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_USR4(("Property support:      CamTxt (VEHICLE_MAINFI_C_U16_CAMTXT) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));

   // dispvidctrl_tclClientVehicledatavTraceInfo: user specific code start
   // dispvidctrl_tclClientVehicledatavTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientVehicledatavOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientVehicledatavOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledata::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledata::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientVehicledatavOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientVehicledatavOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property VEHICLE_MAINFI_C_U16_REVERSEGEAR
*******************************************************************************/

tVoid dispvidctrl_tclClientVehicledata::vHandleReverseGearOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgReverseGearStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VEHICLEDATA_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _State_ReverseGearStatus = oStatus.State;

            ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledata::vHandleReverseGearOpStatus(): Status update message received for 'VEHICLE_MAINFI_C_U16_REVERSEGEAR' (FID: 0x1004)!"));

            onReverseGearStatus(oStatus.State);

            // vHandleReverseGearOpStatus: user specific code start
            // vHandleReverseGearOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientVehicledata::vHandleReverseGearOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientVehicledata::onReverseGearStatus(tU8 State) {

   if (_poCallbackIf) _poCallbackIf->onReverseGearStatus(State); 

   // onReverseGearStatus: user specific code start
   // onReverseGearStatus: user specific code end

}

/*******************************************************************************
* Handling of property VEHICLE_MAINFI_C_U16_CAMTXT
*******************************************************************************/

tVoid dispvidctrl_tclClientVehicledata::vHandleCamTxtOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCamTxtStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VEHICLEDATA_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _CamTxtValue_CamTxtStatus = oStatus.CamTxtValue;

            ETG_TRACE_USR1(("dispvidctrl_tclClientVehicledata::vHandleCamTxtOpStatus(): Status update message received for 'VEHICLE_MAINFI_C_U16_CAMTXT' (FID: 0x100D)!"));

            onCamTxtStatus(oStatus.CamTxtValue);

            // vHandleCamTxtOpStatus: user specific code start
            // vHandleCamTxtOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientVehicledata::vHandleCamTxtOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientVehicledata::onCamTxtStatus(tU64 CamTxtValue) {

   if (_poCallbackIf) _poCallbackIf->onCamTxtStatus(CamTxtValue); 

   // onCamTxtStatus: user specific code start
   // onCamTxtStatus: user specific code end

}






tBool dispvidctrl_tclClientVehicledata::sendReverseGearGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      vehicle_mainfi_tclMsgReverseGearGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VEHICLE_MAINFI_C_U16_REVERSEGEAR, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVehicledata::sendReverseGearGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_REVERSEGEAR, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientVehicledata::sendCamTxtGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      vehicle_mainfi_tclMsgCamTxtGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VEHICLE_MAINFI_C_U16_CAMTXT, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVehicledata::sendCamTxtGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAMTXT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// dispvidctrl_tclClientVehicledatadispvidctrl_ClientVehicledata: user specific code start
// dispvidctrl_tclClientVehicledatadispvidctrl_ClientVehicledata: user specific code end

//EOF
