/*****************************************************************************
* FILE:         dispvidctrl_ClientSpm.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientSpm_H_
#define __dispvidctrl_ClientSpm_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Idispvidctrl_ClientSpm.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclClientSpm_Include: user specific code start
// dispvidctrl_tclClientSpm_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclClientSpmCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class dispvidctrl_tclClientSpm : public Idispvidctrl_tclClientSpm
{

public:
   virtual const tChar* getName() const { return "dispvidctrl_tclClientSpm"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   dispvidctrl_tclClientSpm(tVoid); 
   dispvidctrl_tclClientSpm(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientSpm();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclClientSpmCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclClientSpmDeclarations: user specific code start
   // dispvidctrl_tclClientSpmDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclClientSpm' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclClientSpm& operator = (const dispvidctrl_tclClientSpm &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   dispvidctrl_tclClientSpmCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tVoid getActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> >& rtOnOffTriggerList) {
      rtOnOffTriggerList    = _tOnOffTriggerList_ActiveOnOffTriggerStatus;
   }

   virtual tBool sendActiveOnOffTriggerGet();
   virtual tVoid getSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE& rSysPwrMode) {
      rSysPwrMode           = _SysPwrMode_SysPwrModeStatus;
   }

   virtual tBool sendSysPwrModeGet();
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent) {
      rCvmEvent             = _CvmEvent_CvmEventStatus;
   }

   virtual tBool sendCvmEventGet();
   virtual tVoid getHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE& rHmiState) {
      rHmiState             = _HmiState_HmiStateStatus;
   }

   virtual tBool sendHmiStateGet();
   virtual tVoid getDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE& rDimState) {
      rDimState             = _DimState_DimmingStateStatus;
   }

   virtual tBool sendDimmingStateGet();

   virtual tBool sendOnOffTriggerMStart(spm_fi_tcl_SPM_e32_SubStateType eSwitchOnTrigger, tBool bState);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleActiveOnOffTriggerOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleSysPwrModeOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleCvmEventOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleHmiStateOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleDimmingStateOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandleOnOffTriggerOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList);
   virtual tVoid onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);
   virtual tVoid onHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE HmiState);
   virtual tVoid onDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE DimState);

   virtual tVoid onOnOffTriggerMResult();

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > _tOnOffTriggerList_ActiveOnOffTriggerStatus;
   spm_fi_tcl_SPM_e32_SYSPWRMODE            _SysPwrMode_SysPwrModeStatus;
   spm_fi_tcl_SPM_e32_CVM_EVENT             _CvmEvent_CvmEventStatus;
   spm_fi_tcl_SPM_e32_HMI_STATE             _HmiState_HmiStateStatus;
   spm_fi_tcl_SPM_b32_DIM_STATE             _DimState_DimmingStateStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclClientSpm) 

// dispvidctrl_tclClientSpmDeclarationsPart2: user specific code start
// dispvidctrl_tclClientSpmDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientSpm_H_


