

/*****************************************************************************
* FILE:         dispvidctrl_ClientSds_tts.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientSds_ttsIncludes: user specific code start
// dispvidctrl_tclClientSds_ttsIncludes: user specific code end

#include "dispvidctrl_ClientSds_tts.h"
#include "dispvidctrl_ClientSds_ttsCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_SDS_TTS
#include "trcGenProj/Header/dispvidctrl_ClientSds_tts.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SDS_TTS_SERVICE_ID              514
#define SDS_TTS_FI_MAJOR_VERSION        6
#define SDS_TTS_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientSds_tts, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SDS_TTSFI_C_U16_TTSSTATUS, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleTTSStatusOpStatus)
   ON_MESSAGE_SVCDATA(SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandlePrepareVoiceOutputOpMResult)
   ON_MESSAGE_SVCDATA(SDS_TTSFI_C_U16_ABORTPROMPT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleAbortPromptOpMResult)
   // dispvidctrl_tclClientSds_tts_MsgMap: user specific code start
   ON_MESSAGE_SVCDATA(SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandlePrepareVoiceOutputOpMError)   
   // dispvidctrl_tclClientSds_tts_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSds_tts::
*             dispvidctrl_tclClientSds_tts(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSds_tts::dispvidctrl_tclClientSds_tts(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientSds_tts(poMainAppl, SDS_TTS_SERVICE_ID, SDS_TTS_FI_MAJOR_VERSION, SDS_TTS_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_tts() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclClientSds_ttsConstructor: user specific code start
   // dispvidctrl_tclClientSds_ttsConstructor: user specific code end
   vAddAutoRegisterForProperty(SDS_TTSFI_C_U16_TTSSTATUS);
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSds_tts::
*             ~dispvidctrl_tclClientSds_tts(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSds_tts::~dispvidctrl_tclClientSds_tts(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientSds_tts() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientSds_ttsDestructor: user specific code start
   // dispvidctrl_tclClientSds_ttsDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientSds_tts.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     SDS_TTS_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_tts::vGetReferences() entered."));
   
   // dispvidctrl_tclClientSds_ttsvGetReferences: user specific code start
   // dispvidctrl_tclClientSds_ttsvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_tts::vStartCommunication() entered."));
   // dispvidctrl_tclClientSds_ttsvStartCommunication: user specific code start
   // dispvidctrl_tclClientSds_ttsvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_tts::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientSds_ttsvHandleMessage: user specific code start
   // dispvidctrl_tclClientSds_ttsvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_tts::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientSds_ttsvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientSds_ttsvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      TTSStatus (SDS_TTSFI_C_U16_TTSSTATUS) -> Opcode: Get, Status, UpReg, RelUpReg, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SynthesizeSpeak (SDS_TTSFI_C_U16_SYNTHESIZESPEAK) -> Opcode: MethodStart, MethodResultFirst, MethodResultMiddle, MethodResultLast, Error, "));
   ETG_TRACE_FATAL(("Method   support:      PrepareVoiceOutput (SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AbortPrompt (SDS_TTSFI_C_U16_ABORTPROMPT) -> Opcode: MethodStart, MethodResult, Error, "));

   // dispvidctrl_tclClientSds_ttsvTraceInfo: user specific code start
   // dispvidctrl_tclClientSds_ttsvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientSds_ttsvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientSds_ttsvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_tts::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_tts::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientSds_ttsvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientSds_ttsvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SDS_TTSFI_C_U16_TTSSTATUS
*******************************************************************************/

tVoid dispvidctrl_tclClientSds_tts::vHandleTTSStatusOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sds_ttsfi_tclMsgTTSStatusStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SDS_TTS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _TTSStatus_TTSStatusStatus = oStatus.TTSStatus;

            ETG_TRACE_USR1(("dispvidctrl_tclClientSds_tts::vHandleTTSStatusOpStatus(): Status update message received for 'SDS_TTSFI_C_U16_TTSSTATUS' (FID: 0x2205)!"));

            onTTSStatusStatus(oStatus.TTSStatus);

            // vHandleTTSStatusOpStatus: user specific code start
            // vHandleTTSStatusOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSds_tts::vHandleTTSStatusOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSds_tts::onTTSStatusStatus(sds_fi_tcl_e8_TTSStatus TTSStatus) {

   if (_poCallbackIf) _poCallbackIf->onTTSStatusStatus(TTSStatus); 

   // onTTSStatusStatus: user specific code start
   // onTTSStatusStatus: user specific code end

}



/*******************************************************************************
* Handling of property SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT
*******************************************************************************/

tVoid dispvidctrl_tclClientSds_tts::vHandlePrepareVoiceOutputOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, SDS_TTS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientSds_tts::vHandlePrepareVoiceOutputOpMResult(): Method result update message received for 'SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT' (FID: 0x2103)!"));

            onPrepareVoiceOutputMResult();

            // vHandlePrepareVoiceOutputOpMResult: user specific code start
            // vHandlePrepareVoiceOutputOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSds_tts::vHandlePrepareVoiceOutputOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSds_tts::onPrepareVoiceOutputMResult() {

   if (_poCallbackIf) _poCallbackIf->onPrepareVoiceOutputMResult(); 

   // onPrepareVoiceOutputMResult: user specific code start
   // onPrepareVoiceOutputMResult: user specific code end

}

/*******************************************************************************
* Handling of property SDS_TTSFI_C_U16_ABORTPROMPT
*******************************************************************************/

tVoid dispvidctrl_tclClientSds_tts::vHandleAbortPromptOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sds_ttsfi_tclMsgAbortPromptMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, SDS_TTS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientSds_tts::vHandleAbortPromptOpMResult(): Method result update message received for 'SDS_TTSFI_C_U16_ABORTPROMPT' (FID: 0x2108)!"));

            onAbortPromptMResult();

            // vHandleAbortPromptOpMResult: user specific code start
            // vHandleAbortPromptOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSds_tts::vHandleAbortPromptOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSds_tts::onAbortPromptMResult() {

   if (_poCallbackIf) _poCallbackIf->onAbortPromptMResult(); 

   // onAbortPromptMResult: user specific code start
   // onAbortPromptMResult: user specific code end

}




tBool dispvidctrl_tclClientSds_tts::sendTTSStatusGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sds_ttsfi_tclMsgTTSStatusGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SDS_TTSFI_C_U16_TTSSTATUS, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSds_tts::sendTTSStatusGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SDS_TTSFI_C_U16_TTSSTATUS, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}

tBool dispvidctrl_tclClientSds_tts::sendSynthesizeSpeakMStart(sds_fi_tclString TextAndTags, sds_fi_tcl_e8_TextStyleOption TextStyle, sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation, sds_fi_tcl_e8_StatusInfoOption StatusInfo, tU32 ExpDate, tBool LastPackage) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sds_ttsfi_tclMsgSynthesizeSpeakMethodStart  oMStart;
      //the data content
      oMStart.TextAndTags = TextAndTags;
      oMStart.TextStyle = TextStyle;
      oMStart.AudioOutputLocation = AudioOutputLocation;
      oMStart.StatusInfo = StatusInfo;
      oMStart.ExpDate = ExpDate;
      oMStart.LastPackage = LastPackage;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SDS_TTSFI_C_U16_SYNTHESIZESPEAK, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSds_tts::sendSynthesizeSpeakMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SDS_TTSFI_C_U16_SYNTHESIZESPEAK, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientSds_tts::sendPrepareVoiceOutputMStart(sds_fi_tclString Device) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart  oMStart;
      //the data content
      oMStart.Device = Device;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSds_tts::sendPrepareVoiceOutputMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientSds_tts::sendAbortPromptMStart(sds_fi_tcl_e8_PromptAbortOption AbortPromptOption) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sds_ttsfi_tclMsgAbortPromptMethodStart  oMStart;
      //the data content
      oMStart.AbortPromptOption = AbortPromptOption;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SDS_TTSFI_C_U16_ABORTPROMPT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSds_tts::sendAbortPromptMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SDS_TTSFI_C_U16_ABORTPROMPT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// dispvidctrl_tclClientSds_ttsdispvidctrl_ClientSds_tts: user specific code start
tVoid dispvidctrl_tclClientSds_tts::vHandlePrepareVoiceOutputOpMError(amt_tclServiceData* poMessage) {
    if (poMessage != NULL) {
       if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR ) {
          amt_tclServiceDataError oErrorMsg( poMessage );
          tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

          ETG_TRACE_ERR(("dispvidctrl_tclClientSds_tts::vHandlePrepareVoiceOutputOpMError: Error Code 0x%04x", u16ErrorCode));
       }
    }
}
// dispvidctrl_tclClientSds_ttsdispvidctrl_ClientSds_tts: user specific code end

//EOF
