

/*****************************************************************************
* FILE:         dispvidctrl_ClientAudio.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientAudioIncludes: user specific code start
// dispvidctrl_tclClientAudioIncludes: user specific code end

#include "dispvidctrl_ClientAudio.h"
#include "dispvidctrl_ClientAudioCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AUDIO
#include "trcGenProj/Header/dispvidctrl_ClientAudio.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define AUDIO_SERVICE_ID              263
#define AUDIO_FI_MAJOR_VERSION        1
#define AUDIO_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientAudio, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_BEEP, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleBeepOpMResult)
   // dispvidctrl_tclClientAudio_MsgMap: user specific code start
   // dispvidctrl_tclClientAudio_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientAudio::
*             dispvidctrl_tclClientAudio(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientAudio::dispvidctrl_tclClientAudio(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientAudio(poMainAppl, AUDIO_SERVICE_ID, AUDIO_FI_MAJOR_VERSION, AUDIO_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudio() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclClientAudioConstructor: user specific code start
   // dispvidctrl_tclClientAudioConstructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientAudio::
*             ~dispvidctrl_tclClientAudio(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientAudio::~dispvidctrl_tclClientAudio(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientAudio() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientAudioDestructor: user specific code start
   // dispvidctrl_tclClientAudioDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientAudio.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     AUDIO_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudio::vGetReferences() entered."));
   
   // dispvidctrl_tclClientAudiovGetReferences: user specific code start
   // dispvidctrl_tclClientAudiovGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudio::vStartCommunication() entered."));
   // dispvidctrl_tclClientAudiovStartCommunication: user specific code start
   // dispvidctrl_tclClientAudiovStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudio::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientAudiovHandleMessage: user specific code start
   // dispvidctrl_tclClientAudiovHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudio::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientAudiovHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientAudiovHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vTraceInfo()
{
   ETG_TRACE_FATAL(("Method   support:      Beep (MIDW_MASCFFI_C_U16_BEEP) -> Opcode: MethodStart, MethodResult, "));

   // dispvidctrl_tclClientAudiovTraceInfo: user specific code start
   // dispvidctrl_tclClientAudiovTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientAudiovOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientAudiovOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudio::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientAudio::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientAudiovOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientAudiovOnServiceUnavailable: user specific code end
}




/*******************************************************************************
* Handling of property MIDW_MASCFFI_C_U16_BEEP
*******************************************************************************/

tVoid dispvidctrl_tclClientAudio::vHandleBeepOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_mascffi_tclMsgBeepMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, AUDIO_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientAudio::vHandleBeepOpMResult(): Method result update message received for 'MIDW_MASCFFI_C_U16_BEEP' (FID: 0xC04)!"));

            onBeepMResult(oMResult.ServiceStatus);

            // vHandleBeepOpMResult: user specific code start
            // vHandleBeepOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientAudio::vHandleBeepOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientAudio::onBeepMResult(midw_fi_tcl_e8_AudioServiceStatus ServiceStatus) {

   if (_poCallbackIf) _poCallbackIf->onBeepMResult(ServiceStatus); 

   // onBeepMResult: user specific code start
   // onBeepMResult: user specific code end

}





tBool dispvidctrl_tclClientAudio::sendBeepMStart(midw_fi_tcl_e8_AudioBeepType BeepType, midw_fi_tcl_e8_ResourceNo Resource) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      midw_mascffi_tclMsgBeepMethodStart  oMStart;
      //the data content
      oMStart.BeepType = BeepType;
      oMStart.Resource = Resource;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MIDW_MASCFFI_C_U16_BEEP, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientAudio::sendBeepMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MIDW_MASCFFI_C_U16_BEEP, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// dispvidctrl_tclClientAudiodispvidctrl_ClientAudio: user specific code start
// dispvidctrl_tclClientAudiodispvidctrl_ClientAudio: user specific code end

//EOF
