/*****************************************************************************
* FILE:         dispvidctrl_MCanClientAvmFsm.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     MCanClientFsm.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_ClientAvmFsm.h"
#include "Idispvidctrl_ClientAvmAdaptor.h"
#include "Idispvidctrl_ClientAvm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AVM
#include "trcGenProj/Header/dispvidctrl_ClientAvmFsm.cpp.trc.h"
#endif

// dispvidctrl_tclMCanClientAvmFsmInclude: user specific code start

// some macros to ease reading of the transition definitions and allow for more specific searching
#define FSM_TRANSITION_ID(x)          (x)
#define FSM_IN_STATE(x)               (x)
#define FSM_ON_EVENT(x)               (x)
#define FSM_IF_STATES_ARE_TRUE(x)     (x)
#define FSM_IF_STATES_ARE_FALSE(x)    (x)
#define FSM_EXEC_TRANSITION_ACTION(x) (x)
#define FSM_GOTO_NEW_STATE(x)         (x)
#define FSM_IN_ANY_STATE              FSM_DONT_CARE
#define FSM_ON_ANY_EVENT              FSM_DONT_CARE
#define FSM_IGNORE_TRUE_STATES        FSM_DONT_CARE
#define FSM_IGNORE_FALSE_STATES       FSM_DONT_CARE
#define FSM_NO_TRANSITION_ACTION      FSM_DONT_CARE
#define FSM_STAY_IN_CURRENT_STATE     FSM_DONT_CARE

// dispvidctrl_tclMCanClientAvmFsmInclude: user specific code end

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/
#define ELEMENTE(array)       ( (tU16)( sizeof( array ) / sizeof( array[0] ) ) )


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/
dispvidctrl_tclMCanClientAvmFsm* dispvidctrl_tclMCanClientAvmFsm::_poMyStaticRef = NULL;

dispvidctrl_tclMCanClientAvmFsm::TFsmStateConf dispvidctrl_tclMCanClientAvmFsm::_aFsmStateTable[eStateFsmMax] =
{
   { eStateDeactivated,
     0,                        // u32Timeout
     vEntryDeactivated,        // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     NULL                      // tFsmStateExitFunc
   },
   { eStateInitalizing,
     10000,                    // u32Timeout
     vEntryInitalizing,        // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     NULL                      // tFsmStateExitFunc
   },
   { eStateConnected,
     0,                        // u32Timeout
     vEntryConnected,          // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     NULL                      // tFsmStateExitFunc
   },
   
   // dispvidctrl_tclMCanClientAvmFsmStateDef: user specific code start
   
   // AVM idle state: AVM is connected (<=> MPDT channel open), ignition is ON (<=> AVM ready to operate), no AVM camera view or AVM settings shown
   { eStateAvmIdle,
     0,                        // u32Timeout
     vEntryAvmIdle,            // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     vExitAvmIdle              // tFsmStateExitFunc
   },
   
   // AVM camera view active state:
   { eStateAvmVideo,
     0,                        // u32Timeout
     vEntryAvmVideo,           // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     vExitAvmVideo             // tFsmStateExitFunc
   },

   // AVM blanking on way from other to camera screen state:
   { eStateAvmBlankOth2Vid,
     0,                        // u32Timeout
     vEntryAvmBlankOth2Vid,    // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     vExitAvmBlankOth2Vid      // tFsmStateExitFunc
   },
   
   // AVM blanking on way from camera to other screen state:
   { eStateAvmBlankVid2Oth,
     0,                        // u32Timeout
     vEntryAvmBlankVid2Oth,    // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     vExitAvmBlankVid2Oth      // tFsmStateExitFunc
   },
   
   // AVM blanking between two different camera screens state:
   { eStateAvmBlankVid2Vid,
     0,                        // u32Timeout
     vEntryAvmBlankVid2Vid,    // tFsmStateEntryFunc
     NULL,                     // tFsmStateReachedFunc
     vExitAvmBlankVid2Vid      // tFsmStateExitFunc
   },
   
   // dispvidctrl_tclMCanClientAvmFsmStateDef: user specific code end
};

dispvidctrl_tclMCanClientAvmFsm::TStateTransitions dispvidctrl_tclMCanClientAvmFsm::_aFsmStateTransitionTable[] =
{
   { 0,                           // transitionId
     FSM_DONT_CARE,               // current FSM State
     FSM_DONT_CARE,               // trigger update
     eEventOff,                   // current active trigger(s)
     FSM_DONT_CARE,               // current not active trigger(s)
     FSM_DONT_CARE,               // action to do on transition
     eStateDeactivated            // next FSM State
   },
   { 100,                         // transitionId
     eStateDeactivated,           // current FSM State
     FSM_DONT_CARE,               // trigger update
     eEventAcc,                   // current active trigger(s)
     FSM_DONT_CARE,               // current not active trigger(s)
     FSM_DONT_CARE,               // action to do on transition     
     eStateInitalizing            // next FSM State
   },
   // dispvidctrl_tclMCanClientAvmFsmTransDeactive: user specific code start

   
   //************** state eStateInitalizing **************//
   
   
   // dispvidctrl_tclMCanClientAvmFsmTransDeactive: user specific code end
   
   { 200,                         // transitionId
     eStateInitalizing,           // current FSM State
     eEventAccOffDecounced,       // trigger update
     FSM_DONT_CARE,               // current active trigger(s)
     eEventAcc,                   // current not active trigger(s)
     FSM_DONT_CARE,               // action to do on transition     
     eStateDeactivated            // next FSM State
   },
   // dispvidctrl_tclMCanClientAvmFsmTransInitPre: user specific code start
   { FSM_TRANSITION_ID(202),      // eEventConnected->1 while eEventIgnition==1 => finish config sequence and directly go to state Idle
     FSM_IN_STATE(eStateInitalizing),
     FSM_ON_ANY_EVENT,
     FSM_IF_STATES_ARE_TRUE(eEventConnected | eEventIgnition),
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionFinishCfgSeq),
     FSM_GOTO_NEW_STATE(eStateAvmIdle)
   },
   { FSM_TRANSITION_ID(203),
     FSM_IN_STATE(eStateInitalizing),  // eEventConnected->1 while eEventIgnition==1 => finish config sequence and and go to state Connected
     FSM_ON_ANY_EVENT,
     FSM_IF_STATES_ARE_TRUE(eEventConnected),
     FSM_IF_STATES_ARE_FALSE(eEventIgnition),
     FSM_EXEC_TRANSITION_ACTION(eActionFinishCfgSeq),
     FSM_GOTO_NEW_STATE(eStateConnected)
   },
   
   // the above transition (203) is basically the same as the one below (201), only that instead of the standard
   // generated behaviour, in addition we need the transition action eActionFinishCfgSeq, hence the "duplication"
   
   // dispvidctrl_tclMCanClientAvmFsmTransInitPre: user specific code end
   { 201,                         // transitionId
     eStateInitalizing,           // current FSM State
     FSM_DONT_CARE,               // trigger update
     eEventConnected,             // current active trigger(s)
     FSM_DONT_CARE,               // current not active trigger(s)
     FSM_DONT_CARE,               // action to do on transition     
     eStateConnected              // next FSM State
   },
   // dispvidctrl_tclMCanClientAvmFsmTransInit: user specific code start


   //************** state eStateConnected **************//

   
   { FSM_TRANSITION_ID(397),
     FSM_IN_STATE(eStateConnected),
     FSM_ON_ANY_EVENT,
     FSM_IF_STATES_ARE_TRUE(eEventAcc | eEventConnected | eEventIgnition),
     FSM_IGNORE_FALSE_STATES,
     FSM_NO_TRANSITION_ACTION,
     FSM_GOTO_NEW_STATE(eStateAvmIdle)
   },
   // dispvidctrl_tclMCanClientAvmFsmTransInit: user specific code end
   { 398,                         // transitionId
     eStateConnected,             // current FSM State
     FSM_DONT_CARE,               // trigger update
     FSM_DONT_CARE,               // current active trigger(s)
     eEventConnected,             // current not active trigger(s)
     FSM_DONT_CARE,               // action to do on transition
     eStateInitalizing            // next FSM State
   },
   { 399,                         // transitionId
     eStateConnected,             // current FSM State
     eEventAccOffDecounced,       // trigger update
     FSM_DONT_CARE,               // current active trigger(s)
     eEventAcc,                   // current not active trigger(s)
     FSM_DONT_CARE,               // action to do on transition     
     eStateDeactivated            // next FSM State
   },
   
   // dispvidctrl_tclMCanClientAvmFsmTransElse: user specific code start


   //************** Comm-Lost handling for states other than eStateDeactivated, eStateInitalizing and eStateAvmIdle **************//
   

   { FSM_TRANSITION_ID(9970),  //  AccOffDecounced in state eStateDeactivated => ignore
     FSM_IN_STATE(eStateDeactivated),
     FSM_ON_EVENT(eEventAccOffDecounced),
     FSM_IGNORE_TRUE_STATES,
     FSM_IF_STATES_ARE_FALSE(eEventAcc),
     FSM_NO_TRANSITION_ACTION,
     FSM_STAY_IN_CURRENT_STATE
   },
   { FSM_TRANSITION_ID(9971),  // AccOffDecounced in any other state => fall back to eStateDeactivated
     FSM_IN_ANY_STATE,
     FSM_ON_EVENT(eEventAccOffDecounced),
     FSM_IGNORE_TRUE_STATES,
     FSM_IF_STATES_ARE_FALSE(eEventAcc),
     FSM_EXEC_TRANSITION_ACTION(eActionHandleCommLost),
     FSM_GOTO_NEW_STATE(eStateDeactivated)
   },
   
   { FSM_TRANSITION_ID(9980),  // Connected(0) in state eStateDeactivated => ignore
     FSM_IN_STATE(eStateDeactivated),
     FSM_ON_ANY_EVENT,
     FSM_IGNORE_TRUE_STATES,
     FSM_IF_STATES_ARE_FALSE(eEventConnected),
     FSM_NO_TRANSITION_ACTION,
     FSM_STAY_IN_CURRENT_STATE
   },
   { FSM_TRANSITION_ID(9981),  // Connected(0) in state eStateInitalizing => ignore
     FSM_IN_STATE(eStateInitalizing),
     FSM_ON_ANY_EVENT,
     FSM_IGNORE_TRUE_STATES,
     FSM_IF_STATES_ARE_FALSE(eEventConnected),
     FSM_NO_TRANSITION_ACTION,
     FSM_STAY_IN_CURRENT_STATE
   },
   { FSM_TRANSITION_ID(9982),  // Connected(0) in any other state => fall back to eStateInitalizing
     FSM_IN_ANY_STATE,
     FSM_ON_ANY_EVENT,
     FSM_IGNORE_TRUE_STATES,
     FSM_IF_STATES_ARE_FALSE(eEventConnected),
     FSM_EXEC_TRANSITION_ACTION(eActionHandleCommLost),
     FSM_GOTO_NEW_STATE(eStateInitalizing)
   },
   

   //************** state eStateAvmIdle **************//
  

   { FSM_TRANSITION_ID(400),  // start switch-on sequence
     FSM_IN_STATE(eStateAvmIdle),
     FSM_ON_EVENT(eEventVideoScreenReq),
     FSM_IF_STATES_ARE_TRUE(eEventVideoScreenReq),
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOnOth2Vid),
     FSM_GOTO_NEW_STATE(eStateAvmBlankOth2Vid)
   },


   //************** state eStateAvmVideo **************//

   
   { FSM_TRANSITION_ID(500),  // start switch-off sequence
     FSM_IN_STATE(eStateAvmVideo),
     FSM_ON_EVENT(eEventVideoScreenReq),
     FSM_IGNORE_TRUE_STATES,
     FSM_IF_STATES_ARE_FALSE(eEventVideoScreenReq),
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOnVid2Oth),
     FSM_GOTO_NEW_STATE(eStateAvmBlankVid2Oth)
   },
   { FSM_TRANSITION_ID(501),  // start view change sequence
     FSM_IN_STATE(eStateAvmVideo),
     FSM_ON_EVENT(eEventVideoScreenReq),
     FSM_IF_STATES_ARE_TRUE(eEventVideoScreenReq),
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOnVid2Vid),
     FSM_GOTO_NEW_STATE(eStateAvmBlankVid2Vid)
   },

   
   //************** state eStateAvmBlankOth2Vid **************//

   
   { FSM_TRANSITION_ID(600),
     FSM_IN_STATE(eStateAvmBlankOth2Vid),
     FSM_ON_EVENT(eEventBlankingOffReq),
     FSM_IGNORE_TRUE_STATES,
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOffOth2Vid),
     FSM_GOTO_NEW_STATE(eStateAvmVideo)
   },
   { FSM_TRANSITION_ID(601),
     FSM_IN_STATE(eStateAvmBlankOth2Vid),
     FSM_ON_EVENT(eEventTimeOutBlankOth2Vid),
     FSM_IGNORE_TRUE_STATES,
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOffOth2Vid),
     FSM_GOTO_NEW_STATE(eStateAvmVideo)
   },
   

   //************** state eStateAvmBlankVid2Oth **************//
   

   { FSM_TRANSITION_ID(700),
     FSM_IN_STATE(eStateAvmBlankVid2Oth),
     FSM_ON_EVENT(eEventBlankingOffReq),
     FSM_IGNORE_TRUE_STATES,
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOffVid2Oth),
     FSM_GOTO_NEW_STATE(eStateAvmIdle)
   },
   { FSM_TRANSITION_ID(701),
     FSM_IN_STATE(eStateAvmBlankVid2Oth),
     FSM_ON_EVENT(eEventTimeOutBlankVid2Oth),
     FSM_IGNORE_TRUE_STATES,
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOffVid2Oth),
     FSM_GOTO_NEW_STATE(eStateAvmIdle)
   },


   //************** state eStateAvmBlankVid2Vid **************//
   

   { FSM_TRANSITION_ID(800),
     FSM_IN_STATE(eStateAvmBlankVid2Vid),
     FSM_ON_EVENT(eEventBlankingOffReq),
     FSM_IGNORE_TRUE_STATES,
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOffVid2Vid),
     FSM_GOTO_NEW_STATE(eStateAvmVideo)
   },
   { FSM_TRANSITION_ID(801),
     FSM_IN_STATE(eStateAvmBlankVid2Vid),
     FSM_ON_EVENT(eEventTimeOutBlankVid2Vid),
     FSM_IGNORE_TRUE_STATES,
     FSM_IGNORE_FALSE_STATES,
     FSM_EXEC_TRANSITION_ACTION(eActionBlankOffVid2Vid),
     FSM_GOTO_NEW_STATE(eStateAvmVideo)
   },
   
   // dispvidctrl_tclMCanClientAvmFsmTransElse: user specific code end

};


dispvidctrl_tclMCanClientAvmFsm::dispvidctrl_tclMCanClientAvmFsm(dispvidctrl_tclAppMain* poMainAppl)
: dispvidctrl_tclFsmBase(eStateDeactivated, ELEMENTE(_aFsmStateTransitionTable), _aFsmStateTransitionTable, ELEMENTE(_aFsmStateTable), _aFsmStateTable, TR_CLASS_DISPVIDCTRL_CLIENT_AVM)
, I_dispvidctrl_tclMCanClientAvmFsm(poMainAppl)
, _hStateTimer(OSAL_C_INVALID_HANDLE)
{
   _poMyStaticRef = this;

   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvmFsm() entered."));

   if( OSAL_s32TimerCreate( (OSAL_tpfCallback)vStateTimer, ( tPVoid ) this, &_hStateTimer) != OSAL_OK){
      _hStateTimer = OSAL_C_INVALID_HANDLE;
   }
   
   _bFsmDeactivated   = FALSE;    
   _bChannelRequested = FALSE;   
   
   // dispvidctrl_tclMCanClientAvmFsmConstruct: user specific code start
   _pMcanClientAvm = OSAL_NULL;
   
   _bAvmPhase3Configured      = FALSE;
   _bEarlyPhaseOver           = FALSE;
   _bAcceptUndebouncedRevGear = TRUE;  // only during the early phase, and only for the very first activation of the reverse gear (in order to meet the 2sec requirement)

    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)vCallbk_TimeOutBlankOth2Vid, (tPVoid)this, &_hTimerBlankOth2Vid) != OSAL_OK) {
        ETG_TRACE_FATAL((" dispvidctrl_tclMCanClientAvmFsm::CTOR: ERROR - could not create timer _hTimerBlankOth2Vid!"));
        _hTimerBlankOth2Vid = OSAL_C_INVALID_HANDLE;
    }
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)vCallbk_TimeOutBlankVid2Vid, (tPVoid)this, &_hTimerBlankVid2Vid) != OSAL_OK) {
        ETG_TRACE_FATAL((" dispvidctrl_tclMCanClientAvmFsm::CTOR: ERROR - could not create timer _hTimerBlankVid2Vid!"));
        _hTimerBlankVid2Vid = OSAL_C_INVALID_HANDLE;
    }
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)vCallbk_TimeOutBlankVid2Oth, (tPVoid)this, &_hTimerBlankVid2Oth) != OSAL_OK) {
        ETG_TRACE_FATAL((" dispvidctrl_tclMCanClientAvmFsm::CTOR: ERROR - could not create timer _hTimerBlankVid2Oth!"));
        _hTimerBlankVid2Oth = OSAL_C_INVALID_HANDLE;
    }   
   // dispvidctrl_tclMCanClientAvmFsmConstruct: user specific code end
}

/*******************************************************************************
*
* FUNCTION:    ~dispvidctrl_tclMCanClientAvmFsm()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
dispvidctrl_tclMCanClientAvmFsm::~dispvidctrl_tclMCanClientAvmFsm()
{
   ETG_TRACE_USR4(("~dispvidctrl_tclMCanClientAvmFsm() entered."));

   if (OSAL_C_INVALID_HANDLE != _hStateTimer) {
      if (OSAL_s32TimerSetTime( _hStateTimer, 0, 0) != OSAL_OK){     // Stop Timer before deleting
         ETG_TRACE_ERR( ( "~dispvidctrl_tclMCanClientAvmFsm(): SPM: !!!!!! Error detected !!!!!!" ) );
      }
      if( OSAL_s32TimerDelete( _hStateTimer) != OSAL_OK){            // Delete Timer
         ETG_TRACE_ERR( ( "~dispvidctrl_tclMCanClientAvmFsm(): SPM: !!!!!! Error detected !!!!!!" ) )
      }
      _hStateTimer = OSAL_C_INVALID_HANDLE;
   }
   // dispvidctrl_tclMCanClientAvmFsmDestruct: user specific code start
   
   _pMcanClientAvm = OSAL_NULL;
   
    if (OSAL_C_INVALID_HANDLE  !=   _hTimerBlankOth2Vid)  {
       (tVoid) OSAL_s32TimerSetTime(_hTimerBlankOth2Vid, 0, 0);
       (tVoid) OSAL_s32TimerDelete (_hTimerBlankOth2Vid);
       _hTimerBlankOth2Vid = OSAL_C_INVALID_HANDLE;
    }   
    if (OSAL_C_INVALID_HANDLE  !=   _hTimerBlankVid2Vid)  {
       (tVoid) OSAL_s32TimerSetTime(_hTimerBlankVid2Vid, 0, 0);
       (tVoid) OSAL_s32TimerDelete (_hTimerBlankVid2Vid);
       _hTimerBlankVid2Vid = OSAL_C_INVALID_HANDLE;
    }   
    if (OSAL_C_INVALID_HANDLE  !=   _hTimerBlankVid2Oth)  {
       (tVoid) OSAL_s32TimerSetTime(_hTimerBlankVid2Oth, 0, 0);
       (tVoid) OSAL_s32TimerDelete (_hTimerBlankVid2Oth);
       _hTimerBlankVid2Oth = OSAL_C_INVALID_HANDLE;
    }   
   // dispvidctrl_tclMCanClientAvmFsmDestruct: user specific code end
   
}

/*******************************************************************************
*
* FUNCTION:    vHandleMessage()
*
* DESCRIPTION: handle internal message
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid dispvidctrl_tclMCanClientAvmFsm::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvmFsm::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

    // dispvidctrl_tclMCanClientAvmFsmHandleMsgEntry: user specific code start
    if (!_bAvmPhase3Configured) {
        ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvmFsm::vHandleMessage(): AVM phase 3 not configured, doing nothing"));
        return;
    }
    // dispvidctrl_tclMCanClientAvmFsmHandleMsgEntry: user specific code end

    if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAccChanged) {
        if (!_bFsmDeactivated) {
             vNewTrigger(eEventAcc, pMsg->u.bData);
        }
    }
    if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAvmConnected) {
        vNewTrigger(eEventConnected, pMsg->u.bData);
    }
    if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAvmAccOffDecounced) {
        vNewTrigger(eEventAccOffDecounced, FALSE);
    }
    
   // dispvidctrl_tclMCanClientAvmFsmHandleMsg: user specific code start
   
    switch(pMsg->eCmd) {
        // IGN state messages
        case dispvidctrl_tclBaseIf::eIgnChanged:
            vNewTrigger(eEventIgnition, pMsg->u.bData);
            break;
            
        // reverse gear state messages
        case dispvidctrl_tclBaseIf::eReverseOn:
            if (_bAcceptUndebouncedRevGear) {
                _bAcceptUndebouncedRevGear = FALSE;  // accept undebounced reverse gear only on the very first activation of the reverse gear
                vHandleSwitchInput(rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_REVERSE_ON);
            }
            break;
        case dispvidctrl_tclBaseIf::eReverseOnDebounced:
            vHandleSwitchInput(rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_REVERSE_ON);
            break;
        case dispvidctrl_tclBaseIf::eReverseOff:
            vHandleSwitchInput(rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_REVERSE_OFF);
            break;
            
        // switch inputs being sent from e.g. ClientAvm
        case dispvidctrl_tclBaseIf::eAvm3SwitchInput:
            vHandleSwitchInput(pMsg->u.u32Data);
            break;
           
        // FSM triggers being sent from e.g. ClientAvm or from ourselves
        case dispvidctrl_tclBaseIf::eAvm3FsmTrigger:
        {
          eFsmTrigger eTriggerId    = (eFsmTrigger)(pMsg->u.u32Data & ~0x80000000);
          tBool       bTriggerState = (pMsg->u.u32Data & 0x80000000) ? TRUE : FALSE;
          vNewTrigger(eTriggerId, bTriggerState);
          break;
        }
            
        default:
            break;       
    }
    
   // dispvidctrl_tclMCanClientAvmFsmHandleMsg: user specific code end
    
}

/*******************************************************************************
*
* FUNCTION:     vHandleTraceMessage()
*
* DESCRIPTION:  handler for trace command
*
* PARAMETER:    const tUChar* puchData: reference of received message
*
* RETURNVALUE:  None.
*
*******************************************************************************/
tVoid dispvidctrl_tclMCanClientAvmFsm::vHandleTraceMessage(const tUChar* puchData)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvmFsm::vHandleTraceMessage() entered (data: 0x%08x).", puchData ));
   // dispvidctrl_tclMCanClientAvmFsmHandleTrace: user specific code start
   // dispvidctrl_tclMCanClientAvmFsmHandleTrace: user specific code end
}

/*******************************************************************************
*
* FUNCTION:     vGetReferences(tVoid)
*
* DESCRIPTION:  Function to get all reference needed by this class.
*               A reference should always be the Interface class of the object
*
* PARAMETER:    None.
*
* RETURNVALUE:  None.
*
*******************************************************************************/
tVoid dispvidctrl_tclMCanClientAvmFsm::vGetReferences(tVoid)
{
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvmFsm::vGetReferences() entered."));
   // dispvidctrl_tclMCanClientAvmFsmGetRef: user specific code start
   
   _pMcanClientAvm = dynamic_cast<I_dispvidctrl_tclMCanClientAvm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_pMcanClientAvm);

   _bEarlyPhaseOver           = TRUE;
   _bAcceptUndebouncedRevGear = FALSE;   // the early phase is over; from now on, we require the reverse-gear-on signal to be debounced before we use it
   // dispvidctrl_tclMCanClientAvmFsmGetRef: user specific code end
    
}

/*******************************************************************************
*
* FUNCTION:     tVoid vStartCommunication()
*
* DESCRIPTION:  Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER:    None.
*
* RETURNVALUE:  None.
*
*******************************************************************************/
tVoid dispvidctrl_tclMCanClientAvmFsm::vStartCommunication(tVoid)
{
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvmFsm::vStartCommunication() entered."));
   // dispvidctrl_tclMCanClientAvmFsmStartComm: user specific code start
   if (_pMcanClientAvm) {
      _bAvmPhase3Configured = _pMcanClientAvm->bIsAvmPhase3Configured();
   }
//   ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vStartCommunication() Entered, _bAvmPhase3Configured=%u", _bAvmPhase3Configured) );
   // dispvidctrl_tclMCanClientAvmFsmStartComm: user specific code end
    
}

/*******************************************************************************
*
* FUNCTION:     vTraceInfo()
*
* DESCRIPTION:  Trace information
*
* PARAMETER:    None.
*
* RETURNVALUE:  None.
*
*******************************************************************************/
tVoid dispvidctrl_tclMCanClientAvmFsm::vTraceInfo()
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvmFsm::vTraceInfo() entered."));
    vFsmInfo();
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vNewTrigger(eFsmTrigger eTrigger, tBool bTriggerState) const {
    // dispvidctrl_tclMCanClientAvmFsm_vNewTrigger: user specific code start
    ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvmFsm::vNewTrigger(%u = %u) in state %u", ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::eFsmTrigger,eTrigger), bTriggerState, ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::tenFsmState,u32GetState()) ));
    // dispvidctrl_tclMCanClientAvmFsm_vNewTrigger: user specific code end
   _poMyStaticRef->u32CalcNewFsmState( (tU32)eTrigger, bTriggerState);
   return;
}

OSAL_tpfCallback dispvidctrl_tclMCanClientAvmFsm::vStateTimer(tVoid *pArg){
   (tVoid)pArg;
   ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vStateTimer() --> timeout detected!" ) );
   //_poMyStaticRef->_cpoMain->theServer()->vPostMsgAvmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", eEventStateTimeOut);
   // dispvidctrl_tclMCanClientAvmvStateTimer: user specific code start
   _poMyStaticRef->_cpoMain->theServer()->vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", eEventStateTimeOut);
   // dispvidctrl_tclMCanClientAvmvStateTimer: user specific code end
   return( 0 );
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vStartFsmStateTimer(tU32 u32Time){
   if (OSAL_C_INVALID_HANDLE != _hStateTimer) {
      ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vStartFsmStateTimer() --> %dms!", u32Time ) );
      if(u32Time > 0){
         // set Shutdown-Timer active
         OSAL_s32TimerSetTime(_hStateTimer, u32Time, 0);
      } else {
         // reset Shutdown-Timer
         OSAL_s32TimerSetTime(_hStateTimer,       0, 0);
      }
   }
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vFsmInfo(tVoid){
   // get remaining state timeout time

   tU32 u32RemainingTime = 0;
   tU32 u32IntervalTime  = 0;

   if (OSAL_C_INVALID_HANDLE != _hStateTimer) {
      if (OSAL_s32TimerGetTime(_hStateTimer, &u32RemainingTime, &u32IntervalTime) != OSAL_OK){
         // don't need to error trace -> on ADIT platform even if timer isn't running return value is != OK
      }
   }

   vTraceStatusInfo(u32RemainingTime);
   return;
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vStateChangeDetected(){

   // dispvidctrl_tclMCanClientAvmFsmStateChange: user specific code start
   // dispvidctrl_tclMCanClientAvmFsmStateChange: user specific code end
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vTransitionAction(tU32 u32ActionId) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvmFsm::vTransitionAction(): %d!", u32ActionId) );
   // dispvidctrl_tclMCanClientAvmvTransitionAction: user specific code start
    ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvmFsm::vTransitionAction(): ActionID = %u", ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::tenActionId, u32ActionId)) );
   
   switch(u32ActionId) {
       case eActionFinishCfgSeq   : vFinishCfgSeq();                                                    break;
           
       case eActionBlankOnOth2Vid : vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisOn_BlankOn  ); break;
       case eActionBlankOffOth2Vid: vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisOn_BlankOff ); break;
       case eActionBlankOnVid2Vid : vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisChg_BlankOn ); break;
       case eActionBlankOffVid2Vid: vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisChg_BlankOff); break;
       case eActionBlankOnVid2Oth : vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisOff_BlankOn ); break;
       case eActionBlankOffVid2Oth: vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisOff_BlankOff); break;
       
       case eActionHandleCommLost : vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eHandleCommLost ); break;
           
       default:
           ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vTransitionAction(): unhandled ActionID %d", ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::tenActionId, u32ActionId)) );
           break;
   }
   // dispvidctrl_tclMCanClientAvmvTransitionAction: user specific code end
   return;
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryDeactivated(tVoid){
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryDeactivated()!" ) );

    if (_poMyStaticRef->_bChannelRequested) {
        I_dispvidctrl_tclClientAvmAdaptor* pMcanAdaptor = dynamic_cast<I_dispvidctrl_tclClientAvmAdaptor*>(_poMyStaticRef->_cpoMain->getHandler("I_dispvidctrl_tclClientAvmAdaptor"));
        if (pMcanAdaptor) {
            pMcanAdaptor->ForceDeactivateChannel();
            _poMyStaticRef->_bChannelRequested = FALSE;
        }
    
        // dispvidctrl_tclMCanClientAvmFsmvEntryDeactivatedReq: user specific code start
        // dispvidctrl_tclMCanClientAvmFsmvEntryDeactivatedReq: user specific code end
    }
    // dispvidctrl_tclMCanClientAvmFsmvEntryDeactivated: user specific code start
    // dispvidctrl_tclMCanClientAvmFsmvEntryDeactivated: user specific code end
    
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryInitalizing(tVoid){
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryInitalizing()!" ) );

    I_dispvidctrl_tclClientAvmAdaptor* pMcanAdaptor = dynamic_cast<I_dispvidctrl_tclClientAvmAdaptor*>(_poMyStaticRef->_cpoMain->getHandler("I_dispvidctrl_tclClientAvmAdaptor"));
    if (pMcanAdaptor && !_poMyStaticRef->_bChannelRequested) {
        pMcanAdaptor->ActivateChannel();
        _poMyStaticRef->_bChannelRequested = TRUE;
    }
    
    // dispvidctrl_tclMCanClientAvmFsmvEntryActivated: user specific code start
    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: ClientAvmFsm: vEntryInitalizing");
    // dispvidctrl_tclMCanClientAvmFsmvEntryActivated: user specific code end
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryConnected(tVoid){
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryConnected()!" ) );
    // dispvidctrl_tclMCanClientAvmFsmvEntryConnected: user specific code start
    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: ClientAvmFsm: vEntryConnected");
    // dispvidctrl_tclMCanClientAvmFsmvEntryConnected: user specific code end
}

// dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code start
/*

     X   X   XXX   XXXXX  XXXX        XXX    XXX   XXXX   XXXXX       XXX   XXXXX   XXX   XXXXX  XXX   XXX   X   X
     X   X  X   X  X      X   X      X   X  X   X  X   X  X          X   X  X      X   X    X     X   X   X  X   X
     X   X  X      X      X   X      X      X   X  X   X  X          X      X      X        X     X   X   X  XX  X
     X   X   XXX   XXXX   XXXX       X      X   X  X   X  XXXX        XXX   XXXX   X        X     X   X   X  X X X
     X   X      X  X      X X        X      X   X  X   X  X              X  X      X        X     X   X   X  X  XX
     X   X  X   X  X      X  X       X   X  X   X  X   X  X          X   X  X      X   X    X     X   X   X  X   X
      XXX    XXX   XXXXX  X   X       XXX    XXX   XXXX   XXXXX       XXX   XXXXX   XXX     X    XXX   XXX   X   X

*/


////////////////////////////////////////////////////////////////////////////////////////////////


tVoid dispvidctrl_tclMCanClientAvmFsm::vGetReferencesEarly(tVoid)
{
    ETG_TRACE_FATAL( ( "dispvidctrl_tclMCanClientAvmFsm::vGetReferencesEarly() entered") );
    
    _pMcanClientAvm = dynamic_cast<I_dispvidctrl_tclMCanClientAvm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvm"));
    DISPVIDCTRL_NULL_POINTER_CHECK(_pMcanClientAvm);
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vStartCommunicationEarly(tVoid)
{
    if (_pMcanClientAvm) {
        _bAvmPhase3Configured = _pMcanClientAvm->bIsAvmPhase3Configured();
    }
    ETG_TRACE_FATAL( ( "dispvidctrl_tclMCanClientAvmFsm::vStartCommunicationEarly() Entered, _bAvmPhase3Configured=%u", _bAvmPhase3Configured) );
}


////////////////////////////////////////////////////////////////////////////////////////////////


tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryAvmIdle(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryAvmIdle()!" ) );
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vExitAvmIdle(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vExitAvmIdle()!" ) );
}

////////////////////////////////

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryAvmVideo(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryAvmVideo()!" ) );
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vExitAvmVideo(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vExitAvmVideo()!" ) );
}

////////////////////////////////

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryAvmBlankOth2Vid(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryAvmBlankOth2Vid()!" ) );
    _poMyStaticRef->vUpdateTrigger(eEventBlankingOffReq | eEventTimeOutBlankOth2Vid,FALSE);
    _poMyStaticRef->vSetTimer(eTimerBlankOth2Vid,2000);
    _poMyStaticRef->vSendNormalBeep();
    // _poMyStaticRef->vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisOn_BlankOn);
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vExitAvmBlankOth2Vid(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vExitAvmBlankOth2Vid()!" ) );
    _poMyStaticRef->vSetTimer(eTimerBlankOth2Vid,0);
}

////////////////////////////////

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryAvmBlankVid2Oth(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryAvmBlankVid2Oth()!" ) );
    _poMyStaticRef->vUpdateTrigger(eEventBlankingOffReq | eEventTimeOutBlankVid2Oth,FALSE);
    _poMyStaticRef->vSetTimer(eTimerBlankVid2Oth,2000);
    _poMyStaticRef->vSendNormalBeep();
    // _poMyStaticRef->vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisOff_BlankOn);
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vExitAvmBlankVid2Oth(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vExitAvmBlankVid2Oth()!" ) );
    _poMyStaticRef->vSetTimer(eTimerBlankVid2Oth,0);
}

////////////////////////////////

tVoid dispvidctrl_tclMCanClientAvmFsm::vEntryAvmBlankVid2Vid(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vEntryAvmBlankVid2Vid()!" ) );
    _poMyStaticRef->vUpdateTrigger(eEventBlankingOffReq | eEventTimeOutBlankVid2Vid,FALSE);
    _poMyStaticRef->vSetTimer(eTimerBlankVid2Vid,2000);
    _poMyStaticRef->vSendNormalBeep();
    // _poMyStaticRef->vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eVisChg_BlankOn);
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vExitAvmBlankVid2Vid(tVoid) {
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vExitAvmBlankVid2Vid()!" ) );
    _poMyStaticRef->vSetTimer(eTimerBlankVid2Vid,0);
}

////////////////////////////////////////////////////////////////////////////////////////////////

tVoid dispvidctrl_tclMCanClientAvmFsm::vFinishCfgSeq(tVoid) {
    vSendFsmOutEvent(I_dispvidctrl_tclMCanClientAvm::eHandleCommEstablished);

    I_dispvidctrl_tclClientAvmAdaptor* pMcanAdaptor = dynamic_cast<I_dispvidctrl_tclClientAvmAdaptor*>(_poMyStaticRef->_cpoMain->getHandler("I_dispvidctrl_tclClientAvmAdaptor"));
    if (pMcanAdaptor)
    {
        tU8 u8UnitId  = pMcanAdaptor->u8GetUnitID();
        tU8 u8VersHi  = pMcanAdaptor->u8GetMsgVersionUpper();
        tU8 u8VersMid = pMcanAdaptor->u8GetMsgVersionMid();
        tU8 u8VersLo  = pMcanAdaptor->u8GetMsgVersionLower();
        
        ETG_TRACE_FATAL(( "dispvidctrl_tclMCanClientAvmFsm::vFinishCfgSeq(): Unit_ID=0x%02X MsgVers=%u.%u.%u", u8UnitId, u8VersHi, u8VersMid, u8VersLo ));
        
        vSendUnitConfiguration(u8UnitId,u8VersHi,u8VersMid,u8VersLo);
        
        tU8 u8UnitVariant = DISPVIDCTRL_AVM_UNIT_ID_STR(u8UnitId);
        if (tcl_ITM_Camera_System_e32_STR::FI_EN_VAL06AVM == u8UnitVariant ||
            tcl_ITM_Camera_System_e32_STR::FI_EN_VAL08AVM == u8UnitVariant ||
            tcl_ITM_Camera_System_e32_STR::FI_EN_VAL11AVM == u8UnitVariant  )
        {           
            vSendSW_Signal( bIsRevActive() ? tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_ON
                                           : tcl_ITM_Camera_System_e32_SW_Status::FI_EN_WITHOUT_CHANGING);
        }
    }
}


tVoid dispvidctrl_tclMCanClientAvmFsm::vSendUnitConfiguration(tU8 u8UnitId, tU8 u8VersHi, tU8 u8VersMid, tU8 u8VersLo)
{
    if (_pMcanClientAvm) {
        I_dispvidctrl_tclMCanClientAvm::tstUnitConfiguration stUnitCfg;
        stUnitCfg.u8Unit_ID     = u8UnitId;
        stUnitCfg.u8MsgVersHigh = u8VersHi;
        stUnitCfg.u8MsgVersMid  = u8VersMid;
        stUnitCfg.u8MsgVersLow  = u8VersLo;
        _pMcanClientAvm->vHandleFsmOutput(I_dispvidctrl_tclMCanClientAvm::eSetUnitConfig, & stUnitCfg);
    }
}


tVoid dispvidctrl_tclMCanClientAvmFsm::vSendNormalBeep(tVoid) {
    if (_pMcanClientAvm) {
        ETG_TRACE_USR4(( "dispvidctrl_tclMCanClientAvmFsm::vSendNormalBeep() called" ));
        tBool bData = TRUE;
        _pMcanClientAvm->vHandleFsmOutput(I_dispvidctrl_tclMCanClientAvm::eNormalBeep, & bData);
    }
}


tVoid dispvidctrl_tclMCanClientAvmFsm::vSendErrorBeep(tVoid) {
    if (_pMcanClientAvm) {
        ETG_TRACE_USR4(( "dispvidctrl_tclMCanClientAvmFsm::vSendErrorBeep() called" ));
        tBool bData = TRUE;
        _pMcanClientAvm->vHandleFsmOutput(I_dispvidctrl_tclMCanClientAvm::eErrorBeep, & bData);
    }
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vSendFsmOutEvent(tU32 u32EventId, const void* pvData) {
    if (_pMcanClientAvm) {
        _pMcanClientAvm->vHandleFsmOutput((I_dispvidctrl_tclMCanClientAvm::tenFsmOutputEvent)u32EventId, pvData);
    }
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vSendFsmLoopbackEvent(tU32 u32EventId, tBool bEventState)
{
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vSendFsmLoopbackEvent(): triggerID=%u, triggerState=%d",
                        ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::eFsmTrigger,u32EventId),bEventState) );
    tU32 u32EventIdAndState = (FALSE == bEventState) ? u32EventId : (u32EventId | 0x80000000);
    _cpoMain->theServer()->vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", u32EventIdAndState);
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vSendSW_Signal(tU32 u32SW_Status) {
   tBool bCamScreen = (u32GetTrigger() & eEventVideoScreenReq) ? TRUE : FALSE;
   vSendSW_Signal(u32SW_Status,  bCamScreen ? tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY
                                            : tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_EXCEPT_FOR_CAMERA_DISPLAY);
}


tVoid dispvidctrl_tclMCanClientAvmFsm::vSendSW_Signal(tU32 u32SW_Status, tU32 u32Disp_Status) {
    if (_pMcanClientAvm)
    {
        tU32 au32Params[2] = { u32SW_Status, u32Disp_Status };
        _pMcanClientAvm->vHandleFsmOutput(I_dispvidctrl_tclMCanClientAvm::eSendSwitchToAvm, &au32Params[0]);
    }
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vSendBciSwitch(tU32 u32SwitchId) {
    if (_pMcanClientAvm)
    {
        _pMcanClientAvm->vHandleFsmOutput(I_dispvidctrl_tclMCanClientAvm::eSendBciSwitch, &u32SwitchId);
    }
}

tVoid dispvidctrl_tclMCanClientAvmFsm::vHandleSwitchInput(tU32 u32SwitchId) {
    switch ( u32SwitchId )
    {
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_REVERSE_ON:
            vNewTrigger(eEventReverseGear, TRUE);
            vSendSW_Signal(tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_ON);
            break;

        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_REVERSE_OFF:
            vNewTrigger(eEventReverseGear, FALSE);
            vSendSW_Signal(tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_OFF);
            break;

        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_CAMERA:
            // extra case because later on, we may need to add checks whether or not it's allowed to send the camera switch key press to the AVM
            vSendSW_Signal(tcl_ITM_Camera_System_e32_SW_Status::FI_EN_CAMERA_SW_DEPRESSED);
            break;

        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_HIGHANGLEVIEW:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_SIDEVIEW:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_WIDEVIEW:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_CORNERVIEW:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_VIEWSWITCHING:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_POINTREGISTRATION:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_POINTREMOVING:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_PARKINGGUIDE:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_START:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_END:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_HINT:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_STARTVOICEOUTPUT:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_PARALLELATLEFTSIDE:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_PARALLELATRIGHTSIDE:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_TANDEMATLEFTSIDE:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_TANDEMATRIGHTSIDE:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_FINERTUNING:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_DECIDEFINERTUNING:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BACK:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_MODSONAR_IND_ON:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_MODSONAR_IND_OFF:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_NARROWMODE_IND_ON:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_NARROWMODE_IND_OFF:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_MOD_IND_ON:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_MOD_IND_OFF:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_SONAR_IND_ON:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_SONAR_IND_OFF:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_RESERVESWITCH:
            vSendSW_Signal(u32SwitchId);
            break;

        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_OFF: 
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_ON:
        case DISPVIDCTRL_AVM3_RESET_BCI_TEMP_SW:
            // extra case because BCI switch presses/releases are sent to VCAN, not to MCAN,
            // and because one bad day they may require some additional special treatment
            vSendBciSwitch(u32SwitchId);
            break;
            
        default:
            break;
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////

tVoid dispvidctrl_tclMCanClientAvmFsm::vSetTimer(tU32 u32TimerId, tU32 u32MilliSec)
{
   OSAL_tTimerHandle tHandle = OSAL_C_INVALID_HANDLE;
    
   switch (u32TimerId) {
      case eTimerBlankOth2Vid:
         tHandle = _hTimerBlankOth2Vid;
         break;
      case eTimerBlankVid2Vid:
         tHandle = _hTimerBlankVid2Vid;
         break;
      case eTimerBlankVid2Oth:
         tHandle = _hTimerBlankVid2Oth;
         break;
      default:
         ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvmFsm::vSetTimer(): can't set invalid timer ID %u to %ums", u32TimerId,u32MilliSec));
         break;
   }
   
   if (OSAL_C_INVALID_HANDLE != tHandle) {
      ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvmFsm::vSetTimer(): setting timer %u to %ums", ETG_CENUM(dispvidctrl_tclMCanClientAvmFsm::tenTimerId,u32TimerId),u32MilliSec));
      (tVoid) OSAL_s32TimerSetTime( tHandle, (OSAL_tMSecond)u32MilliSec, 0 );
   }
}

OSAL_tpfCallback dispvidctrl_tclMCanClientAvmFsm::vCallbk_TimeOutBlankOth2Vid(tVoid *pArg)
{
   (tVoid) pArg;
   ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vTimeOutBlankOth2Vid(): timeout detected" ) );
   _poMyStaticRef->_cpoMain->theServer()->vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", (tU32)eEventTimeOutBlankOth2Vid);
   return 0;
}

OSAL_tpfCallback dispvidctrl_tclMCanClientAvmFsm::vCallbk_TimeOutBlankVid2Vid(tVoid *pArg)
{
   (tVoid) pArg;
   ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vTimeOutBlankVid2Vid(): timeout detected" ) );
   _poMyStaticRef->_cpoMain->theServer()->vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", (tU32)eEventTimeOutBlankVid2Vid);
   return 0;
}

OSAL_tpfCallback dispvidctrl_tclMCanClientAvmFsm::vCallbk_TimeOutBlankVid2Oth(tVoid *pArg)
{
   (tVoid) pArg;
   ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvmFsm::vTimeOutBlankVid2Oth(): timeout detected" ) );
   _poMyStaticRef->_cpoMain->theServer()->vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", (tU32)eEventTimeOutBlankVid2Oth);
   return 0;
}

// dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code end
//EOF
