/*****************************************************************************
* FILE:         dispvidctrl_MCanClientAvm.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     MCanClient.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/
#ifndef _AVMMCAN_CLIENT_H_
#define _AVMMCAN_CLIENT_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <map>

//include base class
#include "Idispvidctrl_ClientAvm.h"

// dispvidctrl_tclMCanClientAvm::ClassIncludes: user specific code start

////#include "Idispvidctrl_ClientAvmFsm.h"
#include "dispvidctrl_tclControl_HmiAvm3.h"
#include "I_dispvidctrl_ClientAudioIf.h"

//#include "I_dispvidctrl_ServiceRvcIf.h"
class Idispvidctrl_tclServiceRvcIf;

#define RVC_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "rvc_fi_if.h"

// dispvidctrl_tclMCanClientAvm::ClassIncludes: user specific code end

#define Avm_ASSEMBLE_KEY(msgId, msgOpcode)   (((tU16)::Avm_fi::msgId) << 16 | msgOpcode)
#define Avm_GET_MSG_ID(key)                  (tU16)((key & 0xffff0000) >> 16)
#define Avm_GET_MSG_OPCODE(key)              (tU8) (key & 0x000000ff)

class dispvidctrl_tclMCanClientAvm : 
    public I_dispvidctrl_tclMCanClientAvm,
    public AvmMCanAvmCallbackIf
{
private:
    I_dispvidctrl_tclClientAvmAdaptor* _pCsmBase;
    
    // vector of message to process
    typedef struct{
        tU16 u16MsgId;
        tU8  u8MsgOpcode;
    }TMsgHeader;
            
    std::vector < TMsgHeader > _vecForceSendMsgQueue;
    std::vector < TMsgHeader > _vecSequenceMsgQueue;
    std::vector < TMsgHeader > _vecSequenceMsgBlockAllOtherQueue;
    
    tU32   _u32SequenceMsgQueueChangedTime;
    tU32   _u32SequenceBlockMsgQueueChangedTime;    
        
    tU32   _u32AccOffDetected;    
                    
    std::map < tU32, tclMCanClientMsgInfo > _mapMsgs;

    OSAL_tTimerHandle _hAvmTimeoutTimer;
    static OSAL_tpfCallback vCallbackAvmTimeoutTimer(tVoid* pvArg);
    
    //remember last send message
    tcl_ITM_Camera_System_Software_Version_GetOut        _oSoftware_VersionGetOut;
    tcl_ITM_Camera_System_Hardware_Version_GetOut        _oHardware_VersionGetOut;
    tcl_ITM_Camera_System_SW_Signal_IndicationOut        _oSW_SignalIndicationOut;
    tcl_ITM_Camera_System_View_Change_08AVM_StatusOut        _oView_Change_08AVMStatusOut;
    tcl_ITM_Camera_System_Direct_Camera_OFF_IndicationOut        _oDirect_Camera_OFFIndicationOut;
    tcl_ITM_Camera_System_AVM_Sonar_Buzzer_SetOut        _oAVM_Sonar_BuzzerSetOut;
    tcl_ITM_Camera_System_Camera_Setting_08AVM_SetOut        _oCamera_Setting_08AVMSetOut;
    tcl_ITM_Camera_System_Camera_Setting_08AVM_GetOut        _oCamera_Setting_08AVMGetOut;
    tcl_ITM_Camera_System_Camera_Primary_Setting_SetOut        _oCamera_Primary_SettingSetOut;
    tcl_ITM_Camera_System_Camera_Primary_Setting_GetOut        _oCamera_Primary_SettingGetOut;
    tcl_ITM_Camera_System_MCAN_Communication_Error_GetOut        _oMCAN_Communication_ErrorGetOut;
    tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_SetOut        _oMCAN_Communication_Error_ClearSetOut;
    tcl_ITM_Camera_System_Camera_Diag_Sensor_SetOut        _oCamera_Diag_SensorSetOut;
    tcl_ITM_Camera_System_Camera_Diag_Sensor_GetOut        _oCamera_Diag_SensorGetOut;
    
public:
   dispvidctrl_tclMCanClientAvm(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclMCanClientAvm();

   virtual const tChar* getName() const { return "dispvidctrl_tclMCanClientAvm"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
   virtual tVoid vConnectionUp();   

   virtual tVoid addMsgToSequenceWoBlocking(tU16 u16MsgId, tU8  u8MsgOpcode);
   virtual tVoid addMsgToSequence(tU16 u16MsgId, tU8  u8MsgOpcode);
   virtual tVoid clearMsgSequences();   
   

    virtual tVoid setSoftware_VersionGetOutUpdate(tVoid);

    virtual tVoid setHardware_VersionGetOutUpdate(tVoid);

    virtual tVoid setSW_SignalIndicationOutSW_Status(const tcl_ITM_Camera_System_SW_Status& oSW_Status, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_SW_Status& getSW_SignalIndicationOutSW_Status() { return _oSW_SignalIndicationOut.oSW_Status; }

    virtual tVoid setSW_SignalIndicationOutDisp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Disp_Status& getSW_SignalIndicationOutDisp_Status() { return _oSW_SignalIndicationOut.oDisp_Status; }

    virtual tBool sendSW_SignalIndicationOut(const tcl_ITM_Camera_System_SW_Status& oSW_Status, const tcl_ITM_Camera_System_Disp_Status& oDisp_Status) {
        _oSW_SignalIndicationOut.oSW_Status = oSW_Status;
        _oSW_SignalIndicationOut.oDisp_Status = oDisp_Status;    
        sendSW_SignalIndicationOut(_oSW_SignalIndicationOut);
        return TRUE;    
    }

    virtual tVoid setView_Change_08AVMStatusOutInvalid_Parameter(const tcl_ITM_Camera_System_Invalid_Parameter& oInvalid_Parameter, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Invalid_Parameter& getView_Change_08AVMStatusOutInvalid_Parameter() { return _oView_Change_08AVMStatusOut.oInvalid_Parameter; }

    virtual tVoid setView_Change_08AVMStatusOutDisp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Disp_Status& getView_Change_08AVMStatusOutDisp_Status() { return _oView_Change_08AVMStatusOut.oDisp_Status; }

    virtual tVoid setView_Change_08AVMStatusOutView_Pattern(const tcl_ITM_Camera_System_View_Pattern& oView_Pattern, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_View_Pattern& getView_Change_08AVMStatusOutView_Pattern() { return _oView_Change_08AVMStatusOut.oView_Pattern; }

    virtual tVoid setView_Change_08AVMStatusOutCaution(const tcl_ITM_Camera_System_Caution& oCaution, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Caution& getView_Change_08AVMStatusOutCaution() { return _oView_Change_08AVMStatusOut.oCaution; }

    virtual tVoid setView_Change_08AVMStatusOutDisp_SW_08AVM(const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Disp_SW_08AVM& getView_Change_08AVMStatusOutDisp_SW_08AVM() { return _oView_Change_08AVMStatusOut.oDisp_SW_08AVM; }

    virtual tVoid setView_Change_08AVMStatusOutIcon(const tcl_ITM_Camera_System_Icon& oIcon, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Icon& getView_Change_08AVMStatusOutIcon() { return _oView_Change_08AVMStatusOut.oIcon; }

    virtual tVoid setView_Change_08AVMStatusOutBuzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Buzzer_Status& getView_Change_08AVMStatusOutBuzzer_Status() { return _oView_Change_08AVMStatusOut.oBuzzer_Status; }

    virtual tBool sendView_Change_08AVMStatusOut(const tcl_ITM_Camera_System_Invalid_Parameter& oInvalid_Parameter, const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, const tcl_ITM_Camera_System_View_Pattern& oView_Pattern, const tcl_ITM_Camera_System_Caution& oCaution, const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM, const tcl_ITM_Camera_System_Icon& oIcon, const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status) {
        _oView_Change_08AVMStatusOut.oInvalid_Parameter = oInvalid_Parameter;
        _oView_Change_08AVMStatusOut.oDisp_Status = oDisp_Status;
        _oView_Change_08AVMStatusOut.oView_Pattern = oView_Pattern;
        _oView_Change_08AVMStatusOut.oCaution = oCaution;
        _oView_Change_08AVMStatusOut.oDisp_SW_08AVM = oDisp_SW_08AVM;
        _oView_Change_08AVMStatusOut.oIcon = oIcon;
        _oView_Change_08AVMStatusOut.oBuzzer_Status = oBuzzer_Status;    
        sendView_Change_08AVMStatusOut(_oView_Change_08AVMStatusOut);
        return TRUE;    
    }

    virtual tVoid setDirect_Camera_OFFIndicationOutUpdate(tVoid);

    virtual tVoid setAVM_Sonar_BuzzerSetOutBuzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Buzzer_Status& getAVM_Sonar_BuzzerSetOutBuzzer_Status() { return _oAVM_Sonar_BuzzerSetOut.oBuzzer_Status; }

    virtual tBool sendAVM_Sonar_BuzzerSetOut(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status) {
        _oAVM_Sonar_BuzzerSetOut.oBuzzer_Status = oBuzzer_Status;    
        sendAVM_Sonar_BuzzerSetOut(_oAVM_Sonar_BuzzerSetOut);
        return TRUE;    
    }

    virtual tVoid setCamera_Setting_08AVMSetOutCamera_08AVM(const tcl_ITM_Camera_System_Camera_08AVM& oCamera_08AVM, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Camera_08AVM& getCamera_Setting_08AVMSetOutCamera_08AVM() { return _oCamera_Setting_08AVMSetOut.oCamera_08AVM; }

    virtual tVoid setCamera_Setting_08AVMSetOutCorner_Sonar_Level(const tcl_ITM_Camera_System_Corner_Sonar_Level& oCorner_Sonar_Level, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Corner_Sonar_Level& getCamera_Setting_08AVMSetOutCorner_Sonar_Level() { return _oCamera_Setting_08AVMSetOut.oCorner_Sonar_Level; }

    virtual tVoid setCamera_Setting_08AVMSetOutSonar_Level(const tcl_ITM_Camera_System_Sonar_Level& oSonar_Level, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Sonar_Level& getCamera_Setting_08AVMSetOutSonar_Level() { return _oCamera_Setting_08AVMSetOut.oSonar_Level; }

    virtual tBool sendCamera_Setting_08AVMSetOut(const tcl_ITM_Camera_System_Camera_08AVM& oCamera_08AVM, const tcl_ITM_Camera_System_Corner_Sonar_Level& oCorner_Sonar_Level, const tcl_ITM_Camera_System_Sonar_Level& oSonar_Level) {
        _oCamera_Setting_08AVMSetOut.oCamera_08AVM = oCamera_08AVM;
        _oCamera_Setting_08AVMSetOut.oCorner_Sonar_Level = oCorner_Sonar_Level;
        _oCamera_Setting_08AVMSetOut.oSonar_Level = oSonar_Level;    
        sendCamera_Setting_08AVMSetOut(_oCamera_Setting_08AVMSetOut);
        return TRUE;    
    }

    virtual tVoid setCamera_Setting_08AVMGetOutUpdate(tVoid);

    virtual tVoid setCamera_Primary_SettingSetOutPrimary_Setting(const tcl_ITM_Camera_System_Primary_Setting& oPrimary_Setting, ESendMode eSendMode = eOnChange);
    virtual const tcl_ITM_Camera_System_Primary_Setting& getCamera_Primary_SettingSetOutPrimary_Setting() { return _oCamera_Primary_SettingSetOut.oPrimary_Setting; }

    virtual tBool sendCamera_Primary_SettingSetOut(const tcl_ITM_Camera_System_Primary_Setting& oPrimary_Setting) {
        _oCamera_Primary_SettingSetOut.oPrimary_Setting = oPrimary_Setting;    
        sendCamera_Primary_SettingSetOut(_oCamera_Primary_SettingSetOut);
        return TRUE;    
    }

    virtual tVoid setCamera_Primary_SettingGetOutUpdate(tVoid);

    virtual tVoid setMCAN_Communication_ErrorGetOutUpdate(tVoid);

    virtual tVoid setMCAN_Communication_Error_ClearSetOutUpdate(tVoid);

    virtual tVoid setCamera_Diag_SensorSetOutUpdate(tVoid);

    virtual tVoid setCamera_Diag_SensorGetOutUpdate(tVoid);


private:
   tVoid vCheck4Messages2Send(tVoid);
   virtual tBool sendSoftware_VersionGetOut(tcl_ITM_Camera_System_Software_Version_GetOut& oIn_Software_Version) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oSoftware_VersionGetOut = oIn_Software_Version;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version, MCAN_C_OP_TYPE_GET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendSoftware_VersionGetOut(oIn_Software_Version);
        }
        return bRet;
   }
    virtual tBool sendSoftware_VersionGetOut(tVoid) {
        return sendSoftware_VersionGetOut(_oSoftware_VersionGetOut);
    }
    static tBool sendSoftware_VersionGetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendSoftware_VersionGetOut();
        }
        return bRet;
    };
    
   virtual tBool sendHardware_VersionGetOut(tcl_ITM_Camera_System_Hardware_Version_GetOut& oIn_Hardware_Version) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oHardware_VersionGetOut = oIn_Hardware_Version;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version, MCAN_C_OP_TYPE_GET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendHardware_VersionGetOut(oIn_Hardware_Version);
        }
        return bRet;
   }
    virtual tBool sendHardware_VersionGetOut(tVoid) {
        return sendHardware_VersionGetOut(_oHardware_VersionGetOut);
    }
    static tBool sendHardware_VersionGetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendHardware_VersionGetOut();
        }
        return bRet;
    };
    
   virtual tBool sendSW_SignalIndicationOut(tcl_ITM_Camera_System_SW_Signal_IndicationOut& oIn_SW_Signal) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oSW_SignalIndicationOut = oIn_SW_Signal;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal, MCAN_C_OP_TYPE_INDICATION)].vMsgSend();
       
            bRet = _pCsmBase->sendSW_SignalIndicationOut(oIn_SW_Signal);
        }
        return bRet;
   }
    virtual tBool sendSW_SignalIndicationOut(tVoid) {
        return sendSW_SignalIndicationOut(_oSW_SignalIndicationOut);
    }
    static tBool sendSW_SignalIndicationOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendSW_SignalIndicationOut();
        }
        return bRet;
    };
    
   virtual tBool sendView_Change_08AVMStatusOut(tcl_ITM_Camera_System_View_Change_08AVM_StatusOut& oIn_View_Change_08AVM) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oView_Change_08AVMStatusOut = oIn_View_Change_08AVM;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM, MCAN_C_OP_TYPE_STATUS)].vMsgSend();
       
            bRet = _pCsmBase->sendView_Change_08AVMStatusOut(oIn_View_Change_08AVM);
        }
        return bRet;
   }
    virtual tBool sendView_Change_08AVMStatusOut(tVoid) {
        return sendView_Change_08AVMStatusOut(_oView_Change_08AVMStatusOut);
    }
    static tBool sendView_Change_08AVMStatusOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendView_Change_08AVMStatusOut();
        }
        return bRet;
    };
    
   virtual tBool sendDirect_Camera_OFFIndicationOut(tcl_ITM_Camera_System_Direct_Camera_OFF_IndicationOut& oIn_Direct_Camera_OFF) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oDirect_Camera_OFFIndicationOut = oIn_Direct_Camera_OFF;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctDirect_Camera_OFF, MCAN_C_OP_TYPE_INDICATION)].vMsgSend();
       
            bRet = _pCsmBase->sendDirect_Camera_OFFIndicationOut(oIn_Direct_Camera_OFF);
        }
        return bRet;
   }
    virtual tBool sendDirect_Camera_OFFIndicationOut(tVoid) {
        return sendDirect_Camera_OFFIndicationOut(_oDirect_Camera_OFFIndicationOut);
    }
    static tBool sendDirect_Camera_OFFIndicationOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendDirect_Camera_OFFIndicationOut();
        }
        return bRet;
    };
    
   virtual tBool sendAVM_Sonar_BuzzerSetOut(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_SetOut& oIn_AVM_Sonar_Buzzer) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oAVM_Sonar_BuzzerSetOut = oIn_AVM_Sonar_Buzzer;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer, MCAN_C_OP_TYPE_SET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendAVM_Sonar_BuzzerSetOut(oIn_AVM_Sonar_Buzzer);
        }
        return bRet;
   }
    virtual tBool sendAVM_Sonar_BuzzerSetOut(tVoid) {
        return sendAVM_Sonar_BuzzerSetOut(_oAVM_Sonar_BuzzerSetOut);
    }
    static tBool sendAVM_Sonar_BuzzerSetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendAVM_Sonar_BuzzerSetOut();
        }
        return bRet;
    };
    
   virtual tBool sendCamera_Setting_08AVMSetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_SetOut& oIn_Camera_Setting_08AVM) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oCamera_Setting_08AVMSetOut = oIn_Camera_Setting_08AVM;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_SET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendCamera_Setting_08AVMSetOut(oIn_Camera_Setting_08AVM);
        }
        return bRet;
   }
    virtual tBool sendCamera_Setting_08AVMSetOut(tVoid) {
        return sendCamera_Setting_08AVMSetOut(_oCamera_Setting_08AVMSetOut);
    }
    static tBool sendCamera_Setting_08AVMSetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendCamera_Setting_08AVMSetOut();
        }
        return bRet;
    };
    
   virtual tBool sendCamera_Setting_08AVMGetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_GetOut& oIn_Camera_Setting_08AVM) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oCamera_Setting_08AVMGetOut = oIn_Camera_Setting_08AVM;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_GET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendCamera_Setting_08AVMGetOut(oIn_Camera_Setting_08AVM);
        }
        return bRet;
   }
    virtual tBool sendCamera_Setting_08AVMGetOut(tVoid) {
        return sendCamera_Setting_08AVMGetOut(_oCamera_Setting_08AVMGetOut);
    }
    static tBool sendCamera_Setting_08AVMGetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendCamera_Setting_08AVMGetOut();
        }
        return bRet;
    };
    
   virtual tBool sendCamera_Primary_SettingSetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_SetOut& oIn_Camera_Primary_Setting) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oCamera_Primary_SettingSetOut = oIn_Camera_Primary_Setting;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_SET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendCamera_Primary_SettingSetOut(oIn_Camera_Primary_Setting);
        }
        return bRet;
   }
    virtual tBool sendCamera_Primary_SettingSetOut(tVoid) {
        return sendCamera_Primary_SettingSetOut(_oCamera_Primary_SettingSetOut);
    }
    static tBool sendCamera_Primary_SettingSetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendCamera_Primary_SettingSetOut();
        }
        return bRet;
    };
    
   virtual tBool sendCamera_Primary_SettingGetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_GetOut& oIn_Camera_Primary_Setting) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oCamera_Primary_SettingGetOut = oIn_Camera_Primary_Setting;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_GET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendCamera_Primary_SettingGetOut(oIn_Camera_Primary_Setting);
        }
        return bRet;
   }
    virtual tBool sendCamera_Primary_SettingGetOut(tVoid) {
        return sendCamera_Primary_SettingGetOut(_oCamera_Primary_SettingGetOut);
    }
    static tBool sendCamera_Primary_SettingGetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendCamera_Primary_SettingGetOut();
        }
        return bRet;
    };
    
   virtual tBool sendMCAN_Communication_ErrorGetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_GetOut& oIn_MCAN_Communication_Error) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oMCAN_Communication_ErrorGetOut = oIn_MCAN_Communication_Error;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error, MCAN_C_OP_TYPE_GET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendMCAN_Communication_ErrorGetOut(oIn_MCAN_Communication_Error);
        }
        return bRet;
   }
    virtual tBool sendMCAN_Communication_ErrorGetOut(tVoid) {
        return sendMCAN_Communication_ErrorGetOut(_oMCAN_Communication_ErrorGetOut);
    }
    static tBool sendMCAN_Communication_ErrorGetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendMCAN_Communication_ErrorGetOut();
        }
        return bRet;
    };
    
   virtual tBool sendMCAN_Communication_Error_ClearSetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_SetOut& oIn_MCAN_Communication_Error_Clear) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oMCAN_Communication_Error_ClearSetOut = oIn_MCAN_Communication_Error_Clear;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear, MCAN_C_OP_TYPE_SET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendMCAN_Communication_Error_ClearSetOut(oIn_MCAN_Communication_Error_Clear);
        }
        return bRet;
   }
    virtual tBool sendMCAN_Communication_Error_ClearSetOut(tVoid) {
        return sendMCAN_Communication_Error_ClearSetOut(_oMCAN_Communication_Error_ClearSetOut);
    }
    static tBool sendMCAN_Communication_Error_ClearSetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendMCAN_Communication_Error_ClearSetOut();
        }
        return bRet;
    };
    
   virtual tBool sendCamera_Diag_SensorSetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_SetOut& oIn_Camera_Diag_Sensor) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oCamera_Diag_SensorSetOut = oIn_Camera_Diag_Sensor;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_SET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendCamera_Diag_SensorSetOut(oIn_Camera_Diag_Sensor);
        }
        return bRet;
   }
    virtual tBool sendCamera_Diag_SensorSetOut(tVoid) {
        return sendCamera_Diag_SensorSetOut(_oCamera_Diag_SensorSetOut);
    }
    static tBool sendCamera_Diag_SensorSetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendCamera_Diag_SensorSetOut();
        }
        return bRet;
    };
    
   virtual tBool sendCamera_Diag_SensorGetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_GetOut& oIn_Camera_Diag_Sensor) {
        tBool bRet = FALSE;
        if (_pCsmBase) {
            _oCamera_Diag_SensorGetOut = oIn_Camera_Diag_Sensor;
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_GET)].vMsgSend();
            _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_STATUS)].vStartTimeoutDetection();       
            bRet = _pCsmBase->sendCamera_Diag_SensorGetOut(oIn_Camera_Diag_Sensor);
        }
        return bRet;
   }
    virtual tBool sendCamera_Diag_SensorGetOut(tVoid) {
        return sendCamera_Diag_SensorGetOut(_oCamera_Diag_SensorGetOut);
    }
    static tBool sendCamera_Diag_SensorGetOut(tVoid * pArg) {
        tBool bRet = FALSE;
        if (pArg != NULL) {
            dispvidctrl_tclMCanClientAvm* pObj = (dispvidctrl_tclMCanClientAvm*)pArg;
            bRet = pObj->sendCamera_Diag_SensorGetOut();
        }
        return bRet;
    };
    
        static tVoid wrapSoftware_VersionStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onSoftware_VersionStatusInTimeout();}
        static tVoid wrapHardware_VersionStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onHardware_VersionStatusInTimeout();}
        static tVoid wrapAVM_Sonar_BuzzerStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onAVM_Sonar_BuzzerStatusInTimeout();}
        static tVoid wrapCamera_Setting_08AVMStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onCamera_Setting_08AVMStatusInTimeout();}
        static tVoid wrapCamera_Primary_SettingStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onCamera_Primary_SettingStatusInTimeout();}
        static tVoid wrapMCAN_Communication_ErrorStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onMCAN_Communication_ErrorStatusInTimeout();}
        static tVoid wrapMCAN_Communication_Error_ClearStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onMCAN_Communication_Error_ClearStatusInTimeout();}
        static tVoid wrapCamera_Diag_SensorStatusInTimeout(tVoid * pArg) { if (pArg != NULL) ((dispvidctrl_tclMCanClientAvm*)pArg)->onCamera_Diag_SensorStatusInTimeout();}

        virtual void onSoftware_VersionStatusIn(tcl_ITM_Camera_System_Software_Version_StatusIn& oIn_Software_Version);
        virtual void onSoftware_VersionStatusInTimeout(tVoid);
        virtual void onHardware_VersionStatusIn(tcl_ITM_Camera_System_Hardware_Version_StatusIn& oIn_Hardware_Version);
        virtual void onHardware_VersionStatusInTimeout(tVoid);
        virtual void onExtra_SWIndicationIn(tcl_ITM_Camera_System_Extra_SW_IndicationIn& oIn_Extra_SW);
        virtual void onView_Change_08AVMSetIn(tcl_ITM_Camera_System_View_Change_08AVM_SetIn& oIn_View_Change_08AVM);
        virtual void onBlanking_OFFIndicationIn(tcl_ITM_Camera_System_Blanking_OFF_IndicationIn& oIn_Blanking_OFF);
        virtual void onBlanking_less_Change_08AVMIndicationIn(tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oIn_Blanking_less_Change_08AVM);
        virtual void onAVM_Sonar_BuzzerStatusIn(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_StatusIn& oIn_AVM_Sonar_Buzzer);
        virtual void onAVM_Sonar_BuzzerStatusInTimeout(tVoid);
        virtual void onAVM_Sonar_BuzzerIndicationIn(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_IndicationIn& oIn_AVM_Sonar_Buzzer);
        virtual void onCamera_Setting_08AVMStatusIn(tcl_ITM_Camera_System_Camera_Setting_08AVM_StatusIn& oIn_Camera_Setting_08AVM);
        virtual void onCamera_Setting_08AVMStatusInTimeout(tVoid);
        virtual void onCamera_Setting_08AVMIndicationIn(tcl_ITM_Camera_System_Camera_Setting_08AVM_IndicationIn& oIn_Camera_Setting_08AVM);
        virtual void onCamera_Primary_SettingStatusIn(tcl_ITM_Camera_System_Camera_Primary_Setting_StatusIn& oIn_Camera_Primary_Setting);
        virtual void onCamera_Primary_SettingStatusInTimeout(tVoid);
        virtual void onMCAN_Communication_ErrorStatusIn(tcl_ITM_Camera_System_MCAN_Communication_Error_StatusIn& oIn_MCAN_Communication_Error);
        virtual void onMCAN_Communication_ErrorStatusInTimeout(tVoid);
        virtual void onMCAN_Communication_Error_ClearStatusIn(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_StatusIn& oIn_MCAN_Communication_Error_Clear);
        virtual void onMCAN_Communication_Error_ClearStatusInTimeout(tVoid);
        virtual void onCamera_Diag_SensorStatusIn(tcl_ITM_Camera_System_Camera_Diag_Sensor_StatusIn& oIn_Camera_Diag_Sensor);
        virtual void onCamera_Diag_SensorStatusInTimeout(tVoid);
        virtual void onCamera_Diag_SensorIndicationIn(tcl_ITM_Camera_System_Camera_Diag_Sensor_IndicationIn& oIn_Camera_Diag_Sensor);

// dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code start

public:
    virtual tVoid vGetReferencesEarly(tVoid);
    virtual tVoid vStartCommunicationEarly(tVoid);

    virtual tBool bIsAvmPhase3Configured(tVoid) { return _bAvmPhase3Configured; }
    virtual tVoid vHandleFsmOutput(tenFsmOutputEvent eEvent, const void* pvData);
    virtual tVoid vHandleControlOutput(tenControlOutputEvent eEvent, tU32 u32Data=0);
    virtual tVoid vHandleDataEvent(tenDataEvent eEvent, tU32 u32Data1=0, tU32 u32Data2=0);

    virtual tVoid onAVM3_SetSwitchMStart(tU8 u8SwitchId);
    virtual tVoid onAVM3_SetSonarBuzzerStatusMStart(tU8 u8BuzzerStatus);
    virtual tVoid onAVM3_Settings_Primary_SendReqMStart(tU8 u8RequestType, tU8 u8AVM_Sonar, tBool bDetail_Setting, tBool bImage_Quality);
    virtual tVoid onAVM3_Settings_Detailed_SendReqMStart(tU8 u8RequestType, std::vector<tstSettingsItem, std::allocator<tstSettingsItem> > arChangedItems);
    virtual tVoid onAVM3_GetVersionInfoMStart(tU8 u8VersionType);
    virtual tVoid onAVM3_GetCommunicationErrorsMStart(tVoid);
    virtual tVoid onAVM3_ClearCommunicationErrorsMStart(tVoid);
    virtual tVoid onAVM3_CameraStateRequest(tBool);

    
private:
    I_dispvidctrl_tclMCanClientAvmFsm* _pMcanClientAvmFsm;
    dispvidctrl_tclControl_HmiAvm3*    _pControl_HmiAvm3;
    Idispvidctrl_tclClientAudioIf*     _pClientAudio;
    Idispvidctrl_tclServiceRvcIf*      _pServiceRvc;

    tBool _bConfigDetermined;
    tBool _bAvmPhase3Configured;
    tBool _bEarlyPhaseOver;
    tBool _bDiagVideoActive;
    tBool _bActivatingVidSettings;

    //// last received messages parameters and message validity flags

    // params of message Configuration.Status
    tstUnitConfiguration                    _oRxParam_UnitConfiguration;
    // the message Configuration.Status doesn't come in here via onXyz() call. Rather, on reception, the MCAN adapter base class
    // calls a method in ClientAvmFsm, which in turn retrieves the individual parameters and forwards them to us.
    // Hence, unlike for all other messages, we don't use tcl_ITM_Camera_System_* types to store them, but use an own struct type instead.
    
    // params of messages Software_Version.Status and Hardware_Version.Status
    tcl_ITM_Camera_System_Software_Version  _oRxParam_Software_Version;
    tcl_ITM_Camera_System_Sonar_Soft_Ver    _oRxParam_Sonar_Soft_Ver;
    tcl_ITM_Camera_System_Hardware_Version  _oRxParam_Hardware_Version;
    tcl_ITM_Camera_System_Sonar_Hard_Ver    _oRxParam_Sonar_Hard_Ver;
    
    // params of messages MCAN_Communication_Error.Status and MCAN_Communication_Error_Clear.Status
    tcl_ITM_Camera_System_MCAN_Communication_Error  _oRxParam_MCAN_Communication_Error;
    
    // params of messages View_Change_08AVM.Set and Blanking_less_Change_08AVM.Indication    
    tcl_ITM_Camera_System_Disp_Status       _oRxParam_Disp_Status;   // in ViewChg08AVM only
    tcl_ITM_Camera_System_View_Pattern      _oRxParam_View_Pattern;  
    tcl_ITM_Camera_System_Caution           _oRxParam_Caution;
    tcl_ITM_Camera_System_Disp_SW_08AVM     _oRxParam_Disp_SW_08AVM;
    tcl_ITM_Camera_System_Buzzer_Status     _oRxParam_Buzzer_Status;
    tcl_ITM_Camera_System_Icon              _oRxParam_Icon;
    tcl_ITM_Camera_System_Error_Message     _oRxParam_Error_Message; // in BlnklsChg08AVM only
    tBool                                   _bRxParamsValid_View_Change_08AVM;
    tBool                                   _bRxParamsValid_Blanking_less_Change_08AVM;

    // params of message Camera_Primary_Setting.Status and Camera_Setting_08AVM.Status/.Indication
    tcl_ITM_Camera_System_Primary_Setting     _oRxParam_Primary_Setting;

    // params of messages Camera_Setting_08AVM.Status/.Indication
    tcl_ITM_Camera_System_Camera_08AVM        _oRxParam_Camera_08AVM;
    tcl_ITM_Camera_System_Corner_Sonar_Level   _oRxParam_Corner_Sonar_Level;
    tcl_ITM_Camera_System_Sonar_Level         _oRxParam_Sonar_Level;
    
    // params of messages AVM_Sonar_Buzzer.Status/.Indication
    tcl_ITM_Camera_System_Buzzer_Status       _oRxParam_Buzzer_Status_2; // "morally" the same as _oRxParam_Buzzer_Status above?

    // params of messages Camera_Diag_Sensor.Status/.Indication
    tcl_ITM_Camera_System_Sensor_State        _oRxParam_Sensor_State;
    tcl_ITM_Camera_System_Camara_Set_State    _oRxParam_Camara_Set_State;
    tcl_ITM_Camera_System_RR_Camera_State     _oRxParam_RR_Camera_State;
    tcl_ITM_Camera_System_FR_Camera_State     _oRxParam_FR_Camera_State;
    tcl_ITM_Camera_System_AS_Camera_State     _oRxParam_AS_Camera_State;
    tcl_ITM_Camera_System_DS_Camera_State     _oRxParam_DS_Camera_State;
    
    
    //////// methods to check incoming content for validity
    ////// whole messages
    tBool bIsValidMsg_View_Change_08AVM_SetIn                (const tcl_ITM_Camera_System_View_Change_08AVM_SetIn&                 oViewChgSet  );
    tBool bIsValidMsg_Blanking_less_Change_08AVM_IndicationIn(const tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oBlnklsChgInd);
    //// parameters of messages
    tBool bIsValidPar_Disp_Status  (const tcl_ITM_Camera_System_Disp_Status&   oDisp_Status  );
    tBool bIsValidPar_View_Pattern (const tcl_ITM_Camera_System_View_Pattern&  oView_Pattern );
    tBool bIsValidPar_Caution      (const tcl_ITM_Camera_System_Caution&       oCaution      );
    tBool bIsValidPar_Disp_SW_08AVM(const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM);
    tBool bIsValidPar_Icon         (const tcl_ITM_Camera_System_Icon&          oIcon         );
    tBool bIsValidPar_Buzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status);
    tBool bIsValidPar_Error_Message(const tcl_ITM_Camera_System_Error_Message& oError_Message);
    //// subparameters of parameters
    tBool bIsValidSubPar_Disp_SW_08AVM_SWx       (const tcl_ITM_Camera_System_e32_SW&         eSW       );
    tBool bIsValidSubPar_Disp_SW_08AVM_SWx_Status(const tcl_ITM_Camera_System_e32_SW1_Status& eSW_Status);

    // messages to ease receiving and sending MCAN messages
    tVoid vSaveRxParams_View_Change_08AVM_Set                (const tcl_ITM_Camera_System_View_Change_08AVM_SetIn&                 oViewChgSet    );
    tVoid vSaveRxParams_Blanking_less_Change_08AVM_Indication(const tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oBlnklsChgInd  );
    tVoid vSaveRxParams_Camera_Primary_Setting_Status        (const tcl_ITM_Camera_System_Camera_Primary_Setting_StatusIn&         oCamPrimSetStat);
    tVoid vSaveRxParams_Camera_Setting_08AVM_Status          (const tcl_ITM_Camera_System_Camera_Setting_08AVM_StatusIn&           oCamSettingStat);
    tVoid vSaveRxParams_Camera_Setting_08AVM_Indication      (const tcl_ITM_Camera_System_Camera_Setting_08AVM_IndicationIn&       oCamSettingInd );
    tVoid vSaveRxParams_Camera_Diag_Sensor_Status            (const tcl_ITM_Camera_System_Camera_Diag_Sensor_StatusIn&             oCamDiaSensStat);
    tVoid vSaveRxParams_Camera_Diag_Sensor_Indication        (const tcl_ITM_Camera_System_Camera_Diag_Sensor_IndicationIn&         oCamDiaSensInd );
    tVoid vSetInvalidRxCamSettingsToDefault(tVoid);
    tVoid vFillAndSendMsg_View_Change_08AVM_Status(tVoid);
    tVoid vFillAndSendMsg_Direct_Camera_Off_Indication(tVoid);
    tVoid vFillAndSendMsg_SW_Signal_Indication(tU8 u8SW_Status, tU8 u8Disp_Status);
    tVoid vFillAndSendMsg_AVM_Sonar_Buzzer_Set(tU8 u8Buzzer_Status);
    tVoid vFillAndSendMsg_Camera_Primary_Setting_Get(tVoid);
    tVoid vFillAndSendMsg_Camera_Primary_Setting_Set(tU8 u8AVM_Sonar, tBool bDetail_Setting, tBool bImage_Quality);
    tVoid vFillAndSendMsg_Camera_Setting_08AVM_Get(tVoid);
    tVoid vFillAndSendMsg_Camera_Setting_08AVM_Set(std::vector<tstSettingsItem, std::allocator<tstSettingsItem> > arChangedItems);
    tVoid vFillAndSendMsg_Software_Version_Get(tVoid);
    tVoid vFillAndSendMsg_Hardware_Version_Get(tVoid);
    tVoid vFillAndSendMsg_MCAN_Communication_Error_Get(tVoid);
    tVoid vFillAndSendMsg_MCAN_Communication_Error_Clear_Set(tVoid);
    tVoid vFillAndSendMsg_Camera_Diag_Sensor_Get(tVoid);
    tVoid vFillAndSendMsg_Camera_Diag_Sensor_Set(tVoid);
    tVoid vClearAllPendingMcanMsg(tVoid);    
    
    // other utility methods
    tVoid vDetermineConfiguration(tVoid);
    tVoid vSendTriggerToFsm(tU32 u32FsmTriggerId, tBool bFsmTriggerState);
    tVoid vSendSwitchInputToFsm(tU32 u32SwitchId);
    tVoid vSendEventToControl(tenControl_HmiAvm3 eEvent, tU32 u32Value=0, tBool bAsMsg=FALSE);

    tVoid vSendBeepReq(midw_fi_tcl_e8_AudioBeepType::tenType eBeepType);
    tVoid vSendNormalBeepReq(tBool bBeepOn);
    tVoid vSendErrorBeepReq(tBool bBeepOn);
    tVoid vSendViewContentToServer(tBool bSendDispStat, tBool bSendErrMsg);
    tVoid vRemapRxSwitchStatesToFiMsg(tU8 u8SwitchId, tU8 u8SwitchStatus, rvc_fi_tcl_AVMph3_SwitchDescriptor aoSwParam[]);
    tVoid vSendBuzzerStatusToServer(tVoid);
    tVoid vSendPrimarySettingsToServer(tVoid);
    tVoid vSendDetailSettingsToServer(tVoid);
    tVoid vSendConfigurationInfoToServer(tVoid);
    tVoid vSendSoftwareVersionInfoToServer(tVoid);
    tVoid vSendHardwareVersionInfoToServer(tVoid);
    tVoid vSendMcanCommErrorInfoToServer(tVoid);

    tVoid vShowRvcRequest(tU32 u32Data);
    tVoid vSendControlEventToVideoControl(tU32 u32ControlEventId, tU32 u32Value=0);
    tVoid vDiagVideoRequest(tU32 u32Data);
    tVoid vCamSettingsVideoRequest(tU32 u32Data);
    
    // properties and methods to handle the BCI state received from VCAN
    tU8                      _u8BciSwitchId;
    tU8                      _u8BciSwitchStatus;
    tVoid                    vHandleBciState(tU8 u8BciState, tBool bBciStateValid);
    // properties and methods to handle the BCI button presses to be sent to VCAN
    OSAL_tTimerHandle        _hTimerHandle_BciSwitchReset;
    tBool                    bSetTimer_BciSwitchReset(OSAL_tMSecond msTimeout);
    static OSAL_tpfCallback  pfCallbackTimer_BciSwitchReset(tVoid* pArg);
    tVoid                    vSendBciSwitch(tU32 u32SwitchId);

    tU8                      _u8BeepTriggerSwitchId;
    
// dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code end


};

#endif // _AVMCAN_CLIENT_H_

