/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Idispvidctrl_ClientAvmFsm.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     IMCanClientFsm.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm client statemachine interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_AVMMCAN_CLIENTFSM_H_
#define _I_AVMMCAN_CLIENTFSM_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "dispvidctrl_AppMain.h"

class I_dispvidctrl_tclMCanClientAvmFsm : public dispvidctrl_tclBaseIf
{
public:
   typedef enum {
        eEventAcc                  = 0x00000001,
        eEventConnected            = 0x00000002,
        eEventAccOffDecounced      = 0x00000004,
        eEventOff                  = 0x00000008,
        
        // I_dispvidctrl_tclMCanClientAvmFsmTrigger::ClassImplementation: user specific code start
        eEventIgnition             = 0x00000010,
        eEventReverseGear          = 0x00000020,
        eEventVideoScreenReq       = 0x00000040,
        eEventBlankingOffReq       = 0x00000080,
        
        eEventStateTimeOut         = 0x00000100,
        eEventTimeOutBlankOth2Vid  = 0x00000200,
        eEventTimeOutBlankVid2Oth  = 0x00000400,
        eEventTimeOutBlankVid2Vid  = 0x00000800,
        // I_dispvidctrl_tclMCanClientAvmFsmTrigger::ClassImplementation: user specific code end

   }eFsmTrigger;
   
   typedef enum
   {
        eStateDeactivated = 0,
        eStateInitalizing,
        eStateConnected,

        // I_dispvidctrl_tclMCanClientAvmFsmState::ClassImplementation: user specific code start
        eStateAvmIdle,
        eStateAvmVideo,
        eStateAvmBlankOth2Vid,
        eStateAvmBlankVid2Oth,
        eStateAvmBlankVid2Vid,
        // I_dispvidctrl_tclMCanClientAvmFsmState::ClassImplementation: user specific code end

        eStateFsmMax,
        eStateFsmInvalid = 0xFFFF
   }tenFsmState;   

   I_dispvidctrl_tclMCanClientAvmFsm(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
   virtual ~I_dispvidctrl_tclMCanClientAvmFsm() {;}

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclMCanClientAvmFsm"; };

   virtual tVoid vNewTrigger(eFsmTrigger eTrigger, tBool bTriggerState) const = 0;
   virtual tU32  u32GetState()  const = 0;
   virtual tBool bIsAccActive() const = 0;   
   
    // I_dispvidctrl_tclMCanClientAvmFsm::ClassImplementation: user specific code start
    
    // enum for transition action IDs
    typedef enum {
        eActionFinishCfgSeq,
        
        eActionBlankOnOth2Vid,
        eActionBlankOffOth2Vid,
        eActionBlankOnVid2Oth,
        eActionBlankOffVid2Oth,
        eActionBlankOnVid2Vid,
        eActionBlankOffVid2Vid,

        eActionHandleCommLost,
    } tenActionId;

    virtual tBool bIsIgnActive() const = 0;   
    virtual tBool bIsRevActive() const = 0;   

    // I_dispvidctrl_tclMCanClientAvmFsm::ClassImplementation: user specific code end
};

#endif // _I_AVMMCAN_CLIENTFSM_H_
