/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ClientEarly_trace.cpp
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     client_trace.cpp.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                application trace interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_ClientEarly.h"

#include "dispvidctrl_AppMain_Trace.h"


// TR_CLASS_DISPVIDCTRL_CLIENT_EARLY_traceInclude: user specific code start
// TR_CLASS_DISPVIDCTRL_CLIENT_EARLY_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_EARLY
#include "trcGenProj/Header/dispvidctrl_ClientEarly_trace.cpp.trc.h"
#endif

tVoid dispvidctrl_tclClientEarly::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case DISPVIDCTRL_DISPVIDCTRL_CMDEARLY_COMPONENT_STATUS:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDCOMPONENT_STATUS: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDCOMPONENT_STATUS: user specific code end
            onCOMPONENT_STATUS((::early_inc_fi::EApplicationStatus)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDEARLY_REJECT:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDREJECT: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDREJECT: user specific code end
            onREJECT((::early_inc_fi::ERejectReason)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDCOMMUNICATION_CTRL:
        {
            // 
    

            // dispvidctrl_DISPVIDCTRL_CMDCOMMUNICATION_CTRL: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDCOMMUNICATION_CTRL: user specific code end
            onCOMMUNICATION_CTRL();
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDGET_SIGNALS:
        {
            // 
    

            // dispvidctrl_DISPVIDCTRL_CMDGET_SIGNALS: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDGET_SIGNALS: user specific code end
            onGET_SIGNALS();
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDUPDATE_SIGNALS:
        {
            // 
    

            // dispvidctrl_DISPVIDCTRL_CMDUPDATE_SIGNALS: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDUPDATE_SIGNALS: user specific code end
            onUPDATE_SIGNALS();
        }
        break;

    // dispvidctrl_tclClientEarlyFunction_vHandleTraceMessageCase: user specific code start
    // dispvidctrl_tclClientEarlyFunction_vHandleTraceMessageCase: user specific code end

    default:
        ETG_TRACE_USR4(("dispvidctrl_tclClientEarly::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // dispvidctrl_tclClientEarlyFunction_vHandleTraceMessage: user specific code start
    // dispvidctrl_tclClientEarlyFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// TR_CLASS_DISPVIDCTRL_CLIENT_EARLY_trace: user specific code start
// TR_CLASS_DISPVIDCTRL_CLIENT_EARLY_trace: user specific code end

