#ifndef _EARLYINCPROXY_H_
#define _EARLYINCPROXY_H_

/*****************************************************************************
* FILE:         dispvidctrl_ClientEarly.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     incProxy.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

// Early_incProxy_tclMainIncludes: user specific code start
class I_dispvidctrl_tclSyncHandler;
// Early_incProxy_tclMainIncludes: user specific code end

//include base class
#include "Idispvidctrl_ClientEarly.h"
#include "dispvidctrl_ClientEarlyIncFiDef.h"
#include "I_dispvidctrl_ClientEarlyIncAdaptor.h"
#include "Early_incCallbackIf.h"


class dispvidctrl_tclClientEarly : public I_dispvidctrl_tclClientEarly, public EarlyIncCallbackIf
{
private: 
   I_dispvidctrl_tclClientEarlyIncAdaptor*     _poThermalInc;
   tBool    _bAvailable;
public:
   dispvidctrl_tclClientEarly(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientEarly();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientEarly"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bIsServiceAvailable() {return _bAvailable;};

   // EarlyIncCallbackIf interface
   virtual void onCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
   virtual void onREJECT(::early_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
   virtual void onCOMMUNICATION_CTRL();
   virtual void onGET_SIGNALS();
   virtual void onUPDATE_SIGNALS();

   // I_dispvidctrl_tclClientEarly interface (to send INC messages)
   virtual tBool sendCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus = ::early_inc_fi::eACTIVE, tU8 ApplicationVersion = 1);
   virtual tBool sendCOMMUNICATION_CTRL(tU8 u8InitComm, tU8 u8AutoMode);
   virtual tBool sendGET_SIGNALS(tU8 u8InitSig, tU16 u16Signal);
   virtual tBool sendUPDATE_SIGNALS();
   virtual tBool sendACTION(::early_inc_fi::EAction Action, tU8 u8Parameter);
    // dispvidctrl_tclClientEarlyAddClassPart: user specific code start
private:
    //Vehicle Power State
    tBool _bVehiclePowerStateReceived;
    tBool _bAccOn;
    tBool _bIgnOn;
    //Vehicle Movement State
    tBool _bVehicleMovementStateReceived;
    tBool _bReverseOn;
    //Steering Wheel Angle(s)
    tS16  _s16FrontSteeringAngle;
    tBool _bFrontSteeringAngleValid;
    tS16  _s16RearSteeringAngle;
    tBool _bRearSteeringAngleValid;
    // AvmRequest
    tBool _bAvmRequestReceived;
    tBool _bAvmInitFlagRx;
    tBool _bAvmViewChgReq;


    tBool _bRvcConfigured;
    tBool _bAvmConfigured;
    tU8   _bUseCanSignal_PowerAndReverse;

    tBool _bStateSignalReceived;
    tBool _bSteeringAngleDataSignalReceived;
    tBool _bDataSignalReceived;

    I_dispvidctrl_tclSyncHandler* _poSyncHandler;

    tVoid _vEvaluateSignalPayloadObject(tU16 u16SignalId, tU16 u16PayloadSize, tU8* p8Data);
    tVoid _vHandleStateSignalUpdates(tVoid);
    tVoid _vHandleSteeringAngleDataSignalUpdates(tVoid);
    tVoid _vHandleDataSignalUpdates(tVoid);

public:
    virtual tVoid vGetReferencesEarly(tVoid);
    virtual tVoid vStartCommunicationEarly(tVoid);

    virtual tVoid onCOMMUNICATION_CTRL(tU8 u8NumSignals, tU8* p8Data);
    virtual tVoid onUPDATE_SIGNALS(tU8 u8NumSignals, tU8* p8Data);

    virtual tBool bGetFrontSteeringAngle(tS16& s16SteeringAngle);
    virtual tBool bGetRearSteeringAngle(tS16& s16SteeringAngle);
    // dispvidctrl_tclClientEarlyAddClassPart: user specific code end
};

#endif // _VEDA_THERMAL_H_

