/*****************************************************************************
* FILE:         dispvidctrl_ClientEarly.cpp
* PROJECT:      CMD project
* SW-COMPONENT: dispvidctrl
* Template:     incProxy.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_ClientEarly.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_EARLY
#include "trcGenProj/Header/dispvidctrl_ClientEarly.cpp.trc.h"
#endif

// Early_incProxy_tclMainIncludes: user specific code start
#include "I_dispvidctrl_tclSyncHandler.h"
#include "I_dispvidctrl_tclVideoPlayer.h"
#include "dispvidctrl_datapool.h"
// Early_incProxy_tclMainIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

dispvidctrl_tclClientEarly::dispvidctrl_tclClientEarly(dispvidctrl_tclAppMain* poMainAppl):I_dispvidctrl_tclClientEarly(poMainAppl)
{
   _bAvailable = FALSE;
   _poThermalInc = OSAL_NULL;

   // dispvidctrl_tclClientEarly::dispvidctrl_tclClientEarly: user specific code start
   _bVehiclePowerStateReceived = FALSE;
   _bAccOn = FALSE;
   _bIgnOn = FALSE;
   _bVehicleMovementStateReceived = FALSE;
   _bReverseOn = FALSE;
   _s16FrontSteeringAngle = 0;
   _bFrontSteeringAngleValid = FALSE;
   _s16RearSteeringAngle = 0;
   _bRearSteeringAngleValid = FALSE;
   _bAvmRequestReceived = FALSE;
   _bAvmInitFlagRx = FALSE;
   _bAvmViewChgReq = FALSE;

   _bRvcConfigured = FALSE;
   _bAvmConfigured = FALSE;
   _bUseCanSignal_PowerAndReverse = FALSE;

   _bStateSignalReceived = FALSE;
   _bSteeringAngleDataSignalReceived = FALSE;
   _bDataSignalReceived = FALSE;

   _poSyncHandler = NULL;
   // dispvidctrl_tclClientEarly::dispvidctrl_tclClientEarly: user specific code end
   
   return;
}

dispvidctrl_tclClientEarly::~dispvidctrl_tclClientEarly(tVoid)
{
   _poThermalInc = OSAL_NULL;

   // dispvidctrl_tclClientEarly::~dispvidctrl_tclClientEarly: user specific code start
   _poSyncHandler = OSAL_NULL;
   // dispvidctrl_tclClientEarly::~dispvidctrl_tclClientEarly: user specific code end
}

tVoid dispvidctrl_tclClientEarly::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarly::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientEarly::vHandleMessage: user specific code start
   // dispvidctrl_tclClientEarly::vHandleMessage: user specific code end

}

tVoid dispvidctrl_tclClientEarly::vGetReferences()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarly::vGetReferences() entered."));

   _poThermalInc = dynamic_cast<I_dispvidctrl_tclClientEarlyIncAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientEarlyIncAdaptor"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poThermalInc);
   _poThermalInc->vSetCallbackIf(this);

   // dispvidctrl_tclClientEarly::vGetReferences: user specific code start
   // dispvidctrl_tclClientEarly::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclClientEarly::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarly::vTraceInfo() entered."));
   // dispvidctrl_tclClientEarly::vTraceInfo: user specific code start
   // dispvidctrl_tclClientEarly::vTraceInfo: user specific code end
}


tVoid dispvidctrl_tclClientEarly::vStartCommunication(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientEarly::vStartCommunication() entered."));
    if (sendCOMPONENT_STATUS() == FALSE) {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::vStartCommunication(): Failed to send component state!!!"));
    }

    // dispvidctrl_tclClientEarly::vStartCommunication: user specific code start
    // dispvidctrl_tclClientEarly::vStartCommunication: user specific code end
}

void dispvidctrl_tclClientEarly::onCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::onCOMPONENT_STATUS():  Incomming msg: eSCC_EARLY_R_COMPONENT_STATUS: ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(DISPVIDCTRL_EARLY_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));

    if (ApplicationStatus == ::early_inc_fi::eACTIVE) {
        _bAvailable = TRUE;
    }    

    // dispvidctrl_tclClientEarly_onCOMPONENT_STATUS: user specific code start
    // dispvidctrl_tclClientEarly_onCOMPONENT_STATUS: user specific code end
}
void dispvidctrl_tclClientEarly::onREJECT(::early_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::onREJECT():  Incomming msg: eSCC_EARLY_R_REJECT: RejectReason: %u, RejectedMsgID: %d", ETG_ENUM(DISPVIDCTRL_EARLY_REJECTREASON, RejectReason), RejectedMsgID));

    // dispvidctrl_tclClientEarly_onREJECT: user specific code start
    // dispvidctrl_tclClientEarly_onREJECT: user specific code end
}
void dispvidctrl_tclClientEarly::onCOMMUNICATION_CTRL() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::onCOMMUNICATION_CTRL():  Incomming msg: eSCC_EARLY_R_COMMUNICATION_CTRL: "));

    // dispvidctrl_tclClientEarly_onCOMMUNICATION_CTRL: user specific code start
    // dispvidctrl_tclClientEarly_onCOMMUNICATION_CTRL: user specific code end
}
void dispvidctrl_tclClientEarly::onGET_SIGNALS() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::onGET_SIGNALS():  Incomming msg: eSCC_EARLY_R_GET_SIGNALS: "));

    // dispvidctrl_tclClientEarly_onGET_SIGNALS: user specific code start
    // dispvidctrl_tclClientEarly_onGET_SIGNALS: user specific code end
}
void dispvidctrl_tclClientEarly::onUPDATE_SIGNALS() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::onUPDATE_SIGNALS():  Incomming msg: eSCC_EARLY_R_UPDATE_SIGNALS: "));

    // dispvidctrl_tclClientEarly_onUPDATE_SIGNALS: user specific code start
    // dispvidctrl_tclClientEarly_onUPDATE_SIGNALS: user specific code end
}

tBool dispvidctrl_tclClientEarly::sendCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::sendCOMPONENT_STATUS():  ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(DISPVIDCTRL_EARLY_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));
    if (_poThermalInc) {
        return _poThermalInc->sendCOMPONENT_STATUS(ApplicationStatus, ApplicationVersion);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientEarly::sendCOMMUNICATION_CTRL(tU8 u8InitComm, tU8 u8AutoMode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::sendCOMMUNICATION_CTRL():  u8InitComm: %d, u8AutoMode: %d", u8InitComm, u8AutoMode));
    if (_poThermalInc) {
        return _poThermalInc->sendCOMMUNICATION_CTRL(u8InitComm, u8AutoMode);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientEarly::sendGET_SIGNALS(tU8 u8InitSig, tU16 u16Signal) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::sendGET_SIGNALS():  u8InitSig: %d, u16Signal: %d", u8InitSig, u16Signal));
    if (_poThermalInc) {
        return _poThermalInc->sendGET_SIGNALS(u8InitSig, u16Signal);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientEarly::sendUPDATE_SIGNALS() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::sendUPDATE_SIGNALS():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendUPDATE_SIGNALS();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientEarly::sendACTION(::early_inc_fi::EAction Action, tU8 u8Parameter) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::sendACTION():  Action: %u, u8Parameter: %d", ETG_ENUM(DISPVIDCTRL_EARLY_ACTION, Action), u8Parameter));
    if (_poThermalInc) {
        return _poThermalInc->sendACTION(Action, u8Parameter);
    }
    return FALSE;
}

// dispvidctrl_tclClientEarlyAddClassPart: user specific code start
/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarly::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::vGetReferencesEarly() entered."));

   TEarlyConfiguration rEarlyConfig;
   _cpoMain->vGetEarlyConfig(rEarlyConfig);

   ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::vGetReferencesEarly() Early Config Camera System Type: %u.", rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType));
   ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::vGetReferencesEarly() Early Config V-Can Diversity Type: %u.", rEarlyConfig.tEarlyNorForce.u8VCANDiversity));

//_bRvcConfigured only enabled when configured to RVC
//_bAvmConfigured only enabled when configured to AVM of any type
   if ((rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_RVC)
    || (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_RVC_RENAULT))
   {
       _bRvcConfigured = TRUE;
   }
   else if ((rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_ENTRY)
         || (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_IPA)
         || (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_ENTRY_RENAULT)
         || (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_LOW)
         || (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_HIGH)
         || (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_PHASE3) )
   {
       _bAvmConfigured = TRUE;
   }
   else
   {
   }

   // Power signals and reverse signal can be based on hardwired inputs (GPIO) or CAN signals
   // Hardwired:
   // - Nissan AIVI Scope1 and Scope2 (C1N, Old_Nissan_EV)
   // - Nissan PIVI (C1N, Old_Nissan_EV)
   // CAN:
   // - Renault Scope2.1 (C1A, T4VS)
   // - Nissan Scope 2.1 (C1A)
   // please note: Nissan Scope2.1 (C1A - Alliance platform) is build using the same customer project filter "RNAIVI"
   //              as used for Nissan Scope2.
   //              Therefore we must differentiate on VCANDiversity configuration value.
   #ifdef VARIANT_S_FTR_ENABLE_SMART
   rEarlyConfig.tEarlyNorForce.u8VCANDiversity = 1;
   #endif
   switch (rEarlyConfig.tEarlyNorForce.u8VCANDiversity)
   {
      case DISPVIDCTRL_AllianceVCANSlot_Type_C1A:
      case DISPVIDCTRL_AllianceVCANSlot_Type_T4VS:
         _bUseCanSignal_PowerAndReverse = TRUE;
         break;
      default:
         _bUseCanSignal_PowerAndReverse = FALSE;
         break;
   }
   
   _poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poSyncHandler);

   _poThermalInc = dynamic_cast<I_dispvidctrl_tclClientEarlyIncAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientEarlyIncAdaptor"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poThermalInc);
   _poThermalInc->vSetCallbackIf(this);
}


/******************************************************************************/
/* FUNCTION     vStartCommunicationEarly                                      */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarly::vStartCommunicationEarly(tVoid)
{
    ETG_TRACE_USR1(("[%d ms] dispvidctrl_tclClientEarly::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));
    if (sendCOMMUNICATION_CTRL(1, (tU8) TRUE) == FALSE) {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::vStartCommunicationEarly(): Failed to send component state!!!"));
    }

}

tVoid dispvidctrl_tclClientEarly::onCOMMUNICATION_CTRL(tU8 u8NumSignals, tU8* p8Data)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::onCOMMUNICATION_CTRL():  Incomming msg: eSCC_EARLY_R_COMMUNICATION_CTRL: "));

   tU8* pCurData = p8Data;
   for (tU8 i=0; i<u8NumSignals;i++)
   {
      //first get signal ID
      tU16 u16SignalId = (tU16)(*pCurData++);
      if ((u16SignalId & 0x80) != 0) {
         u16SignalId = ((u16SignalId & ~0x80) << 8) | *pCurData++;
      }
      tU16 u16MaxDataSize = (tU16)(*pCurData++);
      if ((u16MaxDataSize & 0x80) != 0) {
         u16MaxDataSize = ((u16MaxDataSize & ~0x80) << 8) | *pCurData++;
      }
      tU16 u16CurDataSize = (tU16)(*pCurData++);
      if ((u16CurDataSize & 0x80) != 0) {
         u16CurDataSize = ((u16CurDataSize & ~0x80) << 8) | *pCurData++;
      }
      _vEvaluateSignalPayloadObject(u16SignalId, u16CurDataSize, pCurData);
      pCurData = pCurData + u16CurDataSize;
   }

   if (_bStateSignalReceived) {
      _bStateSignalReceived = FALSE;
      _vHandleStateSignalUpdates();
   }
   if (_bSteeringAngleDataSignalReceived) {
      _bSteeringAngleDataSignalReceived = FALSE;
      _vHandleSteeringAngleDataSignalUpdates();
   }
   if (_bDataSignalReceived) {
      _bDataSignalReceived = FALSE;
      _vHandleDataSignalUpdates();
   }
}

tVoid dispvidctrl_tclClientEarly::onUPDATE_SIGNALS(tU8 u8NumSignals, tU8* p8Data)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::onUPDATE_SIGNALS():  Incomming msg: eSCC_EARLY_R_UPDATE_SIGNALS: "));

   tU8* pCurData = p8Data;
   for (tU8 i=0; i<u8NumSignals;i++)
   {
      //first get signal ID
      tU16 u16SignalId = (tU16)(*pCurData++);
      if ((u16SignalId & 0x80) != 0) {
         u16SignalId = ((u16SignalId & ~0x80) << 8) | *pCurData++;
      }
      tU16 u16CurDataSize = (tU16)(*pCurData++);
      if ((u16CurDataSize & 0x80) != 0) {
         u16CurDataSize = ((u16CurDataSize & ~0x80) << 8) | *pCurData++;
      }
      _vEvaluateSignalPayloadObject(u16SignalId, u16CurDataSize, pCurData);
      pCurData = pCurData + u16CurDataSize;
   }

   if (_bStateSignalReceived) {
      _bStateSignalReceived = FALSE;
      _vHandleStateSignalUpdates();
   }
   if (_bSteeringAngleDataSignalReceived) {
      _bSteeringAngleDataSignalReceived = FALSE;
      _vHandleSteeringAngleDataSignalUpdates();
   }
   if (_bDataSignalReceived) {
      _bDataSignalReceived = FALSE;
      _vHandleDataSignalUpdates();
   }
}

/******************************************************************************/
/* FUNCTION     _vEvaluateSignalPayloadObject                                 */
/******************************************************************************/
/**
*  \brief       evaluate payload data for the received signals
*
*  \param       signal Id, payload data size and pointer to payload data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject(tU16 u16SignalId, tU16 u16PayloadSize, tU8* p8Data)
{
   tBool bDataAvailable = TRUE;
   tBool bDataValid     = FALSE;

   // to reduce the update trigger going to sync-handler we differenciate
   // between state relevant signals and other data signals
   // _bStateSignalReceived or _bDataSignalReceived must be set for signals,
   // which must be collected first to handled the signals together in the
   // appropriate HandleSignalsUpdate function

   if (u16PayloadSize == 0)
   {
      bDataAvailable = FALSE;
   }
   else
   {
      bDataValid = (tBool) ((*p8Data) & 0x01);
   }
   ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject: u16SignalId: %d, bDataAvailable: %d, bDataValid: %d", u16SignalId, bDataAvailable, bDataValid));

   switch (u16SignalId)
   {
      case 0x0001:    // Vehicle Power State
         {
            tU8 u8PowerState = 0;

            _bAccOn = FALSE;
            _bIgnOn = FALSE;
            if (bDataAvailable)
            {
               u8PowerState = *(p8Data + 1);

               if (_bUseCanSignal_PowerAndReverse == FALSE) {
                  // bDataValid should not be checked for the GPIO data because it is the CAN signal state as soon the CAN signal is available in V850
                  // (GOPIO data are always valid)
                  if (u8PowerState & 0x01)  // GPIO PIN in lower nibble bit 0
                  {
                     _bAccOn = TRUE;
                  }
                  if (u8PowerState & 0x02)  // GPIO PIN in lower nibble bit 1
                  {
                     _bIgnOn = TRUE;
                  }
               }
               else {
                  // in Scope2.1 (C1A, T4VS) we get the states via CAN signal "Vehicle State"
                  // CAN signal value in upper nibble: interpretation according abstract signal description

                  //     T4VS                       C1A
                  //  0: Sleeping                   Sleeping
                  //  1: Technical Wakeup           Not used
                  //  2: CutOffPending              CutoffPending
                  //  3: BatTempoLevel              AutoACC  - BatTempoLevel
                  //  4: AccessoryLevel             Not used
                  //  5: IgnitionLevel              IgnitionLevel
                  //  6: StartingInProgress         StartingInProgress
                  //  7: EngineRunning              PowertrainRunning
                  //  8: AutoStart                  AutoStart
                  //  9: EngineSystemStop           EngineSystemStop
                  // 10: UnvailableValue            Not used
                  // 11:                            Not used
                  // 12:                            Not used
                  // 13:                            Not used
                  // 14:                            Not used
                  // 15:                            Unavailable

                  if (bDataValid)
                  {
                     switch ((u8PowerState >> 4) & 0x0F)
                     {
                        case 3:
                        case 4:
                           _bAccOn  = TRUE;
                           break;
                        case 5:
                        case 6:
                        case 7:
                        case 8:
                        case 9:
                           _bAccOn  = TRUE;
                           _bIgnOn  = TRUE;
                           break;
                        default:
                           break;
                     }
                  }
               }
               ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject():  VehiclePowerState is: 0x%02x", u8PowerState));
            }

            _bVehiclePowerStateReceived = TRUE;
            _bStateSignalReceived = TRUE;
         }
         break;
      case 0x0002:    // Vehicle Movement State  (e.g. rear gear status)
         {
            tU8 u8VehicleMovementState = 0;

            _bReverseOn = FALSE;
            if (bDataAvailable && bDataValid)
            {
               u8VehicleMovementState = *(p8Data+1);

               if (_bUseCanSignal_PowerAndReverse == FALSE) {
                  if (u8VehicleMovementState & 0x01) { // GPIO PIN in lower nibble bit 0
                     _bReverseOn = TRUE;
                  }
               }
               else {
                  if ((u8VehicleMovementState & 0x30) == 0x20) { // CAN signal in upper nibble: interpretation according abstract signal description (10b == RearGearEngaged)
                     _bReverseOn = TRUE;
                  }
               }
               ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject():  VehicleMovementState is: 0x%02x", u8VehicleMovementState));
            }

            _bVehicleMovementStateReceived = TRUE;
            _bStateSignalReceived = TRUE;
         }
         break;
      #if !defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE1)
      case 0x0003: // Steering Wheel Angle
         {
            _bFrontSteeringAngleValid = bDataValid;
            if (bDataAvailable && bDataValid)
            {
               // two data bytes
               _s16FrontSteeringAngle = (tS16) ((*(p8Data + 1) << 8) | *(p8Data + 2)); // raw value
               _s16FrontSteeringAngle = (tS16) _s16FrontSteeringAngle * 0.1; /*lint !e524*/  // degree value
               //ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject():  FrontSteeringWheelAngle deg is: %d", _s16FrontSteeringAngle));
            }

            _bSteeringAngleDataSignalReceived = TRUE;
         }
         break;
      #endif
      case 0x0005: // Vehicle Speed
         {
            //two data bytes
            //_bDataSignalReceived = TRUE;
         }
         break;
#if !defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE1)
      case 0x0007: // Rear Wheel Angle
         {
            _bRearSteeringAngleValid = bDataValid;
            if (bDataAvailable && bDataValid)
            {
               // two data bytes little endian
               _s16RearSteeringAngle = (tS16) ((*(p8Data + 1) << 8) | *(p8Data + 2)); // raw value
               // ... How is the format?
            }

            _bSteeringAngleDataSignalReceived = TRUE;
         }
         break;
#endif
      case 0x0040: // AvmRequest
         {
            tU8 u8AvmRequest = 0;
            // in case of AVMRequest signal: 
            //    Payload Size is 0 in case CAN message where not received at all
            //    DataValid is 0 in case of CAN message time out
            _bAvmInitFlagRx = TRUE;
            _bAvmViewChgReq = FALSE;
            if (bDataAvailable && bDataValid)
            {
               u8AvmRequest = *(p8Data + 1);
               if (!(u8AvmRequest & 0x01))
               {
                  _bAvmInitFlagRx = FALSE;
               }
               if (u8AvmRequest & 0x02)
               {
                  _bAvmViewChgReq = TRUE;
               }
               //ETG_TRACE_USR1(("dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject():  AvmRequest InitFlag is: %d, ViewChgReq is: %d", _bAvmInitFlagRx, _bAvmViewChgReq));
               ETG_TRACE_FATAL(("dispvidctrl_tclClientEarly::_vEvaluateSignalPayloadObject():  AvmRequest InitFlag is: %d, ViewChgReq is: %d", _bAvmInitFlagRx, _bAvmViewChgReq));
            }

            _bAvmRequestReceived = TRUE;
            _bStateSignalReceived = TRUE;
         }
         break;
      default:
         break;
   }

}

/******************************************************************************/
/* FUNCTION     _vHandleStateSignalUpdates                                    */
/******************************************************************************/
/**
*  \brief       handle signal updates for activation/deactivation states
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarly::_vHandleStateSignalUpdates(tVoid)
{
   if (_bAvmConfigured) {
      if (_bAvmRequestReceived) {
         if (_poSyncHandler) {
            _poSyncHandler->vHandleControl(EN_CONTROL_SH__EARLY_INC_IGNITION , (tU32) _bIgnOn);
            _poSyncHandler->vHandleControl(EN_CONTROL_SH__EARLY_INC_AVM_INIT_FLAG_RX , (tU32) _bAvmInitFlagRx);
            _poSyncHandler->vHandleControl(EN_CONTROL_SH__EARLY_INC_AVM_VIEW_CHG_REQ , (tU32) _bAvmViewChgReq);
         }
      }
   }

   if (_bRvcConfigured) {
// todo : to think about: in case of cranking ACC is going to OFF while IGN is still ON (for Nissan)
//                        Is it right to check here ACC state also?
//                        We would not show early video in cranking mode?
//                        It could cause a video screen flicker when cranking is
//                           started immediately after early video was activated.
      // check RVC Screen activation conditions
      tBool bRvcActivated = _bAccOn & _bIgnOn & _bReverseOn;

      if (_poSyncHandler) {
            _poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerRvcDebounced, bRvcActivated);
      }
   }

   if (_bVehicleMovementStateReceived && _bVehiclePowerStateReceived) {
      if (_poSyncHandler) { 
         _poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerIncUp, TRUE);
      }
   }
   
   if (_bVehiclePowerStateReceived) {
       _cpoMain->theServer()->vPostMsgAccChanged("", _bAccOn);
       _cpoMain->theServer()->vPostMsgIgnChanged("", _bIgnOn);
   }
   if (_bVehicleMovementStateReceived) {
       if (_bReverseOn) {
           _cpoMain->theServer()->vPostMsgReverseOn("I_dispvidctrl_tclMCanClientAvmFsm");
       } else {
           _cpoMain->theServer()->vPostMsgReverseOff("I_dispvidctrl_tclMCanClientAvmFsm");
       }
   }

}

/******************************************************************************/
/* FUNCTION     _vHandleSteeringAngleDataSignalUpdates                        */
/******************************************************************************/
/**
*  \brief       handle steering angle signal data updates
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarly::_vHandleSteeringAngleDataSignalUpdates(tVoid)
{
   if (_bRvcConfigured) {
      if (_poSyncHandler) {
         _poSyncHandler->vHandleControl(EN_CONTROL_SH__EARLY_INC_STEERING_ANGLE);
      }
   }
}

/******************************************************************************/
/* FUNCTION     bGetFrontSteeringAngle                                        */
/******************************************************************************/
/**
*  \brief
*
*  \param       tS16& - reference for Steering Angle value
*  \return      tBool - for Steering Angle valid state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientEarly::bGetFrontSteeringAngle(tS16& s16SteeringAngle)
{
   s16SteeringAngle = _s16FrontSteeringAngle;
   return (_bFrontSteeringAngleValid);
}

/******************************************************************************/
/* FUNCTION     bGetRearSteeringAngle                                         */
/******************************************************************************/
/**
*  \brief
*
*  \param       tS16& - reference for Steering Angle value
*  \return      tBool - for Steering Angle valid state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientEarly::bGetRearSteeringAngle(tS16& s16SteeringAngle)
{
   s16SteeringAngle = _s16RearSteeringAngle;
   return (_bRearSteeringAngleValid);
}

/******************************************************************************/
/* FUNCTION     _vHandleDataSignalUpdates                                     */
/******************************************************************************/
/**
*  \brief       handle signal data updates
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarly::_vHandleDataSignalUpdates(tVoid)
{
   //forward vehicle speed information
}

// dispvidctrl_tclClientEarlyAddClassPart: user specific code end

//EOF
