#ifndef _I_EARLYINCPROXY_H_
#define _I_EARLYINCPROXY_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Idispvidctrl_ClientEarly.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     incProxyIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC Proxy interface file
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

//include base class
#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_ClientEarlyIncFiDef.h"

class I_dispvidctrl_tclClientEarly : public dispvidctrl_tclBaseIf
{
public:
   I_dispvidctrl_tclClientEarly(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
   virtual ~I_dispvidctrl_tclClientEarly() {;}

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientEarly"; };

   virtual tBool bIsServiceAvailable() = 0;
   virtual tBool sendCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus = ::early_inc_fi::eACTIVE, tU8 ApplicationVersion = 1) = 0;
   virtual tBool sendCOMMUNICATION_CTRL(tU8 u8InitComm, tU8 u8AutoMode) = 0;
   virtual tBool sendGET_SIGNALS(tU8 u8InitSig, tU16 u16Signal) = 0;
   virtual tBool sendUPDATE_SIGNALS() = 0;
   virtual tBool sendACTION(::early_inc_fi::EAction Action, tU8 u8Parameter) = 0;

    // I_dispvidctrl_tclClientEarlyAddClassPart: user specific code start
    virtual tBool bGetFrontSteeringAngle(tS16& s16SteeringAngle) = 0;
    virtual tBool bGetRearSteeringAngle(tS16& s16SteeringAngle) = 0;
    // I_dispvidctrl_tclClientEarlyAddClassPart: user specific code end
};


#endif //_I_EARLYINCPROXY_H_

