/*****************************************************************************
* FILE:         dispvidctrl_ClientDimming.cpp
* PROJECT:      CMD project
* SW-COMPONENT: dispvidctrl
* Template:     incProxy.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_ClientDimming.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING
#include "trcGenProj/Header/dispvidctrl_ClientDimming.cpp.trc.h"
#endif

// Dimming_incProxy_tclMainIncludes: user specific code start
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_drvass_video_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"


#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#include "I_dispvidctrl_ClientSpmIf.h"
#include "dispvidctrl_tclTypes.h"
#include "I_dispvidctrl_tclConfigMgr.h"

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
#include "dispvidctrl_tclSecondDisp.h"
#endif

#include "I_dispvidctrl_tclTouchDriverControl.h"

#define INC_CLIENTDIMMING_MAX_EQUALMSG_PROCESS	3

#define CAN_CFG_C1A  0x01
#define CAN_CGF_T4VS 0x03
#define T4VS_RENAULT_DIMM_COLUMN_OFFSET_FIX  10

// Dimming_incProxy_tclMainIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

dispvidctrl_tclClientDimming::dispvidctrl_tclClientDimming(dispvidctrl_tclAppMain* poMainAppl):I_dispvidctrl_tclClientDimming(poMainAppl)
{
   _bAvailable = FALSE;
   _poThermalInc = OSAL_NULL;

   // dispvidctrl_tclClientDimming::dispvidctrl_tclClientDimming: user specific code start
   _poDimSrv 							= OSAL_NULL;
   _poDisplaySettings					= OSAL_NULL;
   _poSyncHandler                   = OSAL_NULL;

   m_enBacklightState_SPM				= eBackLight_Spm_Off;
   m_enBacklightState_CVM				= eBackLight_Cvm_Auto;
   m_enBacklightState_HMI				= eBackLight_Hmi_Auto;
   m_enBacklightState_BERR				= eBackLight_BERR_Auto;
   m_enBacklightState_HC                = eBackLight_HC_Auto;
   m_enBacklightState_RVC               = eBackLight_RVC_Auto;

   _u8DispBrightness         		    = 0;
   _u8KeybBrightness         		    = 0;
   _u8IllBrightness         		    = 0;
   _bIllActive         					= FALSE;
   _bMR_OUTPUT         					= FALSE;

   _bDimState         					= FALSE;
   _bCrVoltage        					= FALSE;
   _bUseNewCatalog    					= TRUE;
   _bMethodEmulationModeSetPending 		= FALSE;
   _bMethodKeyBrightnessSetPending 		= FALSE;
   _bMethodKeyPwmBrightnessSetPending 	= FALSE;
   _bMethodDispBrightnessSetPending		= FALSE;
   _bMethodIcuBrightnessGetPending 		= FALSE;
   _bReadBrightnessValKeybPending 		= FALSE;
   _bReadBrightnessValDispPending 		= FALSE;
   _bReadBrightnessValICUPending 		= FALSE;
	_u8prevDimMode_State 				= 0;
	_u8DimMode_State					= 0;
   //Renault display brightness specific
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   memset(_aDayDispBrightnessMatrix, 0, 882);
   memset(_aNightDispBrightnessMatrix, 0, 882);
   m_u8OffsetFromCAN  = 10;
   m_u8OffsetFromDayorNightHMISlider = 10;
   m_u8OffsetFromHMICockpitSlider = 10;
   m_u8DimmingStrategy = 0;
   m_bIsDarkModeEnabled = FALSE;
#endif
   //
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
   _poSecondDispIfRef = NULL;
#endif
   // NCG3D-26251 related NCG3D-24250
   m_enLast_DimmingMode = ::dimming_inc_fi::eDimmingModeStatusMax;
   m_s8Last_DispBrightnessOffset = OSAL_C_S8_MAX;
   m_u8CountEqual_onINFO_GET_DIMMINGMODE_STATE = 0;

   // NCG3D-13847
   memset((tVoid*)m_arrDiagDimMsg, OSAL_NULL, sizeof(m_arrDiagDimMsg));
   m_u16DiagDimMsgWriteIdx = 0;
   m_u16DiagDimMsgReadIdx = 0;
   m_hDiagDimMsgSemaphore = OSAL_C_INVALID_HANDLE;
   if (OSAL_ERROR == OSAL_s32SemaphoreCreate( "DiagDimMsgSemaphore", &m_hDiagDimMsgSemaphore, 1 ))
   {
	   if (OSAL_ERROR == OSAL_s32SemaphoreOpen( "DiagDimMsgSemaphore", &m_hDiagDimMsgSemaphore ))
	   {
		   m_hDiagDimMsgSemaphore = OSAL_C_INVALID_HANDLE;
		   ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::dispvidctrl_tclClientDimming() DiagDimMsgSemaphore could not create"));
	   }
   }
   m_poTouchDriverControl = OSAL_NULL;
   m_bTouchDriverStarted = FALSE;
   // dispvidctrl_tclClientDimming::dispvidctrl_tclClientDimming: user specific code end
   
   return;
}

dispvidctrl_tclClientDimming::~dispvidctrl_tclClientDimming(tVoid)
{
   _poThermalInc = OSAL_NULL;

   // dispvidctrl_tclClientDimming::~dispvidctrl_tclClientDimming: user specific code start
   m_poTouchDriverControl = OSAL_NULL;
   _poSyncHandler = OSAL_NULL;
   _poDisplaySettings = OSAL_NULL;
   _poDimSrv = OSAL_NULL;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
   _poSecondDispIfRef = NULL;
#endif

   // NCG3D-13847
   if (OSAL_C_INVALID_HANDLE != m_hDiagDimMsgSemaphore)
   {
	   if (OSAL_ERROR != OSAL_s32SemaphoreClose( m_hDiagDimMsgSemaphore ))
	   {
		   (tVoid) OSAL_s32SemaphoreDelete( "DiagDimMsgSemaphore" );
		   m_hDiagDimMsgSemaphore = OSAL_C_INVALID_HANDLE;
	   }
   }
   // dispvidctrl_tclClientDimming::~dispvidctrl_tclClientDimming: user specific code end
}

tVoid dispvidctrl_tclClientDimming::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientDimming::vHandleMessage: user specific code start
   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDimStateChanged) {
       _bDimState = bHandleBacklightState((tenBackLightState)pMsg->u.u32Data);
       if (TRUE == _bDimState)
       {
    	   sendDISPLAY_REQ(::dimming_inc_fi::eACTIVATE_DISPLAY);
           if (OSAL_NULL != m_poTouchDriverControl)
           {
        	   if (TRUE == m_bTouchDriverStarted)
        	   {
        		   m_poTouchDriverControl->s32StartDriver(EARLY_CONFIG_TOUCHDRIVER_FIRST);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        		   m_poTouchDriverControl->s32StartDriver(EARLY_CONFIG_TOUCHDRIVER_SECOND);
#endif //#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        	   }
        	   else
        	   {
        		   m_bTouchDriverStarted = TRUE;
        		   m_poTouchDriverControl->s32RestartDriver(EARLY_CONFIG_TOUCHDRIVER_FIRST);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        		   m_poTouchDriverControl->s32RestartDriver(EARLY_CONFIG_TOUCHDRIVER_SECOND);
#endif //#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        	   }
           }
       }
       else
       {
           if (OSAL_NULL != m_poTouchDriverControl)
           {
        	   m_poTouchDriverControl->s32StopDriver(EARLY_CONFIG_TOUCHDRIVER_FIRST);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        	   m_poTouchDriverControl->s32StopDriver(EARLY_CONFIG_TOUCHDRIVER_SECOND);
#endif //#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
           }
    	   sendDISPLAY_REQ(::dimming_inc_fi::eDEACTIVATE_DISPLAY);
       }
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDimModeChanged) {
	   dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
	   // send new dimming mode config to V850
	   if (FALSE == sendINFO_SET_DIMMINGMODE_CONFIG((::dimming_inc_fi::EDimmingMode)pMsg->u.u8Data)) {
		   ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::vHandleMessage() failed %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
	   }
	   _oDimModeConfig.vSetData(pMsg->u.u8Data);
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDimBrightnessChanged) {
	   tU8 _u8BrightnessLevelInfo = pMsg->u.u8Data;
	   tBool _bIsNight = FALSE;
	   dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
	   dp_tclDimmingDPINFO_DimmingModeStatus _oDimModeStatus;
		if (DISPVIDCTRL_U8_DIMMODECONFIG_NIGHT == _oDimModeConfig.tGetData())
		{
			_bIsNight = TRUE;
		}
		else if (DISPVIDCTRL_U8_DIMMODECONFIG_AUTO == _oDimModeConfig.tGetData())
		{
			if (DISPVIDCTRL_U8_DIMMODESTATUS_NIGHT == _oDimModeStatus.tGetData()
				|| DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT == _oDimModeStatus.tGetData())
			{
				_bIsNight = TRUE;
			}
		}
	   if (TRUE == _bIsNight) {
		   dp_tclDimmingDPDISP_BrightnessLevelExtended_Night _oBrightnessLevelNight;
		   _oBrightnessLevelNight.vSetData(pMsg->u.u8Data);
		   if (TRUE == _bUseNewCatalog)
		   {
			   _u8BrightnessLevelInfo |= 0x80;
		   }
	   }
	   else {
		   dp_tclDimmingDPDISP_BrightnessLevelExtended_Day _oBrightnessLevelDay;
		   _oBrightnessLevelDay.vSetData(pMsg->u.u8Data);
		   if (TRUE == _bUseNewCatalog)
		   {
			   _u8BrightnessLevelInfo |= 0x40;
		   }
	   }
       if (OSAL_NULL != _poDimSrv) {
    	   _poDimSrv->sendDIM_DISP_BrightnessLevelExtendedStatus(pMsg->u.u8Data);
			dimming_fi_tcl_e8_DIM_BrightnessLevel _oBrightnessLevel;
			_oBrightnessLevel.enType = (dimming_fi_tcl_e8_DIM_BrightnessLevel::tenType)u8ConvertBlex2Bl(pMsg->u.u8Data);
			_poDimSrv->sendDIM_DISP_BrightnessLevelStatus(_oBrightnessLevel);
       }
       sendDISP_SET_BRIGHTNESS_LEVEL(_u8BrightnessLevelInfo);
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDimCrLowVoltage) {
	   _bDimState = bHandleBacklightState(eBackLight_Cvm_Off);
	   if (TRUE == _bDimState)
		   sendDISPLAY_REQ(::dimming_inc_fi::eACTIVATE_DISPLAY);
	   else
		   sendDISPLAY_REQ(::dimming_inc_fi::eDEACTIVATE_DISPLAY);
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDimHighVoltage) {
	   _bDimState = bHandleBacklightState(eBackLight_Cvm_Off);
	   if (TRUE == _bDimState)
		   sendDISPLAY_REQ(::dimming_inc_fi::eACTIVATE_DISPLAY);
	   else
		   sendDISPLAY_REQ(::dimming_inc_fi::eDEACTIVATE_DISPLAY);
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDimNormalVoltage) {
	   _bDimState = bHandleBacklightState(eBackLight_Cvm_Auto);
	   if (TRUE == _bDimState)
		   sendDISPLAY_REQ(::dimming_inc_fi::eACTIVATE_DISPLAY);
	   else
		   sendDISPLAY_REQ(::dimming_inc_fi::eDEACTIVATE_DISPLAY);
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eEmulationModeSet) {
       // NCG3D-23030: DIMMING config manager ... loading of calibration values from KDS
       I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
       if ((OSAL_NULL != _poDimConfigMgr)
    	   && ((DISPVIDCTRL_C_U8_EMULATIONMODE_KEYBFREEZE == pMsg->u.u8Data) || (DISPVIDCTRL_C_U8_EMULATIONMODE_SETUP == pMsg->u.u8Data) || (DISPVIDCTRL_C_U8_EMULATIONMODE_VERIFY == pMsg->u.u8Data)))
       {
          _poDimConfigMgr->vOnLoadSettings();
       }
	   if (/*(DISPVIDCTRL_C_U8_EMULATIONMODE_OFF <= pMsg->u.u8Data) &&*/ (DISPVIDCTRL_C_U8_EMULATIONMODE_VERIFY >= pMsg->u.u8Data) && TRUE == sendDIAG_SESSION((::dimming_inc_fi::ESessionType)pMsg->u.u8Data))
	   {
		   // INC message send successful
		   _bMethodEmulationModeSetPending = TRUE;
	   }
	   else
	   {
		   // error observed
		   if (OSAL_NULL != _poDimSrv)
		   {
			   dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
			   dimming_fi_tcl_e8_DIM_EmulationMode _oEmulationMode;
			   _oEmulationMode.enType = (dimming_fi_tcl_e8_DIM_EmulationMode::tenType)_oDpEmulationMode.tGetData();
			   _poDimSrv->sendDIM_INFO_SetEmulationModeMResult(_oEmulationMode);
		   }
	   }
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eKeybBrightnessSet) {
	   dp_tclDimmingDPINFO_EmulationModeSet _oEmulationMode;
	   if (/*0 <= pMsg->u.u16Data &&*/ 1000 >= pMsg->u.u16Data && TRUE == sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType,pMsg->u.u16Data))
	   {
		   // INC message send successful
		   _bMethodKeyBrightnessSetPending = (DISPVIDCTRL_C_U8_EMULATIONMODE_KEYBFREEZE == _oEmulationMode.tGetData());
		   _bMethodKeyPwmBrightnessSetPending = (DISPVIDCTRL_C_U8_EMULATIONMODE_SETUP == _oEmulationMode.tGetData());
	   }
	   else
	   {
		   // error observed
		   if (OSAL_NULL != _poDimSrv)
		   {
			   if (DISPVIDCTRL_C_U8_EMULATIONMODE_KEYBFREEZE == _oEmulationMode.tGetData())
			   {
				   _poDimSrv->sendDIM_KEYB_SetDimmingMResult(0);
			   }
			   else if (DISPVIDCTRL_C_U8_EMULATIONMODE_SETUP == _oEmulationMode.tGetData())
			   {
				   _poDimSrv->sendDIM_KEYB_SetDimmingPWMMResult(0);
			   }
		   }
	   }
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::eDispBrightnessSet) {
	   if (/*0 <= pMsg->u.u16Data &&*/ 1000 >= pMsg->u.u16Data && TRUE == sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType,pMsg->u.u16Data))
	   {
		   // INC message send successful
		   _bMethodDispBrightnessSetPending = TRUE;
	   }
	   else
	   {
		   // error observed
		   if (OSAL_NULL != _poDimSrv)
		   {
			   _poDimSrv->sendDIM_DISP_SetDimmingMResult(0);
		   }
	   }
   } else if (pMsg->eCmd == dispvidctrl_tclBaseIf::ePwmBrightnessGet) {
	   if (TRUE == sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eICU_DeviceType))
	   {
		   // INC message send successful
		   _bMethodIcuBrightnessGetPending = TRUE;
	   }
	   else
	   {
		   // error observed
		   if (OSAL_NULL != _poDimSrv)
		   {
			   _poDimSrv->sendDIM_INFO_GetPWMBrightnessMResult(0);
		   }
	   }
   }
   // dispvidctrl_tclClientDimming::vHandleMessage: user specific code end

}

tVoid dispvidctrl_tclClientDimming::vGetReferences()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::vGetReferences() entered."));

   if(_cpoMain!=NULL) //CID: 19188
   _poThermalInc = dynamic_cast<I_dispvidctrl_tclClientDimmingIncAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientDimmingIncAdaptor"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poThermalInc);
   _poThermalInc->vSetCallbackIf(this);

   // dispvidctrl_tclClientDimming::vGetReferences: user specific code start
   if (OSAL_NULL != _cpoMain)
   {
	   _poDimSrv = dynamic_cast<Idispvidctrl_tclServiceDimmingIf*>(_cpoMain->getHandler("Idispvidctrl_tclServiceDimmingIf"));
	   _poDisplaySettings = dynamic_cast<I_dispvidctrl_tclDisplaySettings*>(_cpoMain->getHandler("I_dispvidctrl_tclDisplaySettings"));
       _poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
       //For P-IVI Second Screen If
       _poSecondDispIfRef = dynamic_cast<I_dispvidctrl_tclSecondDispIf*>(_cpoMain->getHandler("dispvidctrl_tclSecondDisp"));
       m_poTouchDriverControl = dynamic_cast<I_dispvidctrl_tclTouchDriverControl*>(_cpoMain->getHandler("I_dispvidctrl_tclTouchDriverControl"));
#else
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
       m_poTouchDriverControl = dynamic_cast<I_dispvidctrl_tclTouchDriverControl*>(_cpoMain->getHandler("I_dispvidctrl_tclTouchDriverControl"));
#else
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
       m_poTouchDriverControl = dynamic_cast<I_dispvidctrl_tclTouchDriverControl*>(_cpoMain->getHandler("I_dispvidctrl_tclTouchDriverControl"));
#else
       ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vGetReferences(): touch driver control unsupported!"));
#endif
#endif // #ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
#endif // #ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   }
   // dispvidctrl_tclClientDimming::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclClientDimming::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::vTraceInfo() entered."));
   // dispvidctrl_tclClientDimming::vTraceInfo: user specific code start
   // dispvidctrl_tclClientDimming::vTraceInfo: user specific code end
}


tVoid dispvidctrl_tclClientDimming::vStartCommunication(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::vStartCommunication() entered."));
    if (sendCOMPONENT_STATUS() == FALSE) {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vStartCommunication(): Failed to send component state!!!"));
    }

    // dispvidctrl_tclClientDimming::vStartCommunication: user specific code start
	#if 0
	   if (sendCOMPONENT_STATUS() == FALSE) {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vStartCommunication(): Failed to send component state!!!"));
    }
	#endif

    // ... load current dimming state ... we are late
	Idispvidctrl_tclClientSpm* _poSpmIf = dynamic_cast<Idispvidctrl_tclClientSpm*>(_cpoMain->getHandler("Idispvidctrl_tclClientSpm"));
    if (OSAL_NULL != _poSpmIf)
    {
    	spm_fi_tcl_SPM_b32_DIM_STATE _rDimState;
    	_poSpmIf->getDimmingStateStatus(_rDimState);
        ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onCOMPONENT_STATUS(): Idispvidctrl_tclClientSpm DimState %d", _rDimState.u32Value ));
        if ((TRUE == _rDimState.bSPM_U32_DIMMINGSTATE_BACKLIGHT()) || (TRUE == _rDimState.bSPM_U32DIMMINGSTATE_ALL_ON()))
        	_bDimState = bHandleBacklightState(eBackLight_Spm_On);
        else
        	_bDimState = bHandleBacklightState(eBackLight_Spm_Off);
    }
    else
    {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::onCOMPONENT_STATUS(): Idispvidctrl_tclClientSpmIf unavailable" ));
    }
    // ... update CCA property
    if (_poDimSrv) {
		// update CCA property DIM_INFO_DimmingMode
    	dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
		dimming_fi_tcl_e8_DIM_Mode _enConfig;
		switch (_oDimModeConfig.tGetData())
		{
		case DISPVIDCTRL_U8_DIMMODECONFIG_DAY:
		case DISPVIDCTRL_U8_DIMMODECONFIG_NIGHT:
		case DISPVIDCTRL_U8_DIMMODECONFIG_AUTO:
			{
				_enConfig.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeConfig.tGetData();
			}
			break;
		default:
			{
				_enConfig.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
			}
			break;
		}
    	dp_tclDimmingDPINFO_DimmingModeCar _oDimModeCar;
		dimming_fi_tcl_e8_DIM_Mode _enCar;
		switch (_oDimModeCar.tGetData())
		{
		case DISPVIDCTRL_U8_DIMMODECAR_DAY:
		case DISPVIDCTRL_U8_DIMMODECAR_NIGHT:
			{
				_enCar.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeCar.tGetData();
			}
			break;
		default:
			{
				_enCar.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_DAY;
			}
			break;
		}
		dp_tclDimmingDPINFO_DimmingModeStatus _oDimModeStatus;
		dimming_fi_tcl_e8_DIM_Mode _enStatus;
		switch (_oDimModeStatus.tGetData())
		{
		case DISPVIDCTRL_U8_DIMMODESTATUS_DAY:
		case DISPVIDCTRL_U8_DIMMODESTATUS_NIGHT:
			{
				_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeStatus.tGetData();
			}
			break;
		case DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY:
		case DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT:
			{
				_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
			}
			break;
		default:
			{
				_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
			}
			break;
		}
		if (dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO < _enStatus.enType)
		{
			_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
		}
		else if (dimming_fi_tcl_e8_DIM_Mode::FI_EN_DAY > _enStatus.enType)
		{
			_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
		}
		//_poDimSrv->sendDIM_INFO_DimmingModeStatus(_enConfig, _enCar, _enStatus);
		tBool _bIsNight = FALSE;
		if (DISPVIDCTRL_U8_DIMMODECONFIG_NIGHT == _oDimModeConfig.tGetData())
		{
			_bIsNight = TRUE;
		}
		else if (DISPVIDCTRL_U8_DIMMODECONFIG_AUTO == _oDimModeConfig.tGetData())
		{
			if (DISPVIDCTRL_U8_DIMMODESTATUS_NIGHT == _oDimModeStatus.tGetData()
				|| DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT == _oDimModeStatus.tGetData())
			{
				_bIsNight = TRUE;
			}
		}
		// update CCA property DIM_DISP_BrightnessLevelExtended
		if (TRUE == _bIsNight) {
			dp_tclDimmingDPDISP_BrightnessLevelExtended_Night _oBrightnessLevelNight;
			_poDimSrv->sendDIM_DISP_BrightnessLevelExtendedStatus(_oBrightnessLevelNight.tGetData());
			dimming_fi_tcl_e8_DIM_BrightnessLevel _oBrightnessLevel;
			_oBrightnessLevel.enType = (dimming_fi_tcl_e8_DIM_BrightnessLevel::tenType)u8ConvertBlex2Bl(_oBrightnessLevelNight.tGetData());
			_poDimSrv->sendDIM_DISP_BrightnessLevelStatus(_oBrightnessLevel);
		}
		else {
			dp_tclDimmingDPDISP_BrightnessLevelExtended_Day _oBrightnessLevelDay;
			_poDimSrv->sendDIM_DISP_BrightnessLevelExtendedStatus(_oBrightnessLevelDay.tGetData());
			dimming_fi_tcl_e8_DIM_BrightnessLevel _oBrightnessLevel;
			_oBrightnessLevel.enType = (dimming_fi_tcl_e8_DIM_BrightnessLevel::tenType)u8ConvertBlex2Bl(_oBrightnessLevelDay.tGetData());
			_poDimSrv->sendDIM_DISP_BrightnessLevelStatus(_oBrightnessLevel);
		}
		if (DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT == _oDimModeStatus.tGetData())
		{
			_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT;
			ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::Entered DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT"));
		}
		if(DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY == _oDimModeStatus.tGetData())
		{
			_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY;
			ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::Entered DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY"));
		}
		_poDimSrv->sendDIM_INFO_DimmingModeStatus(_enConfig, _enCar, _enStatus);
    }

    {
        ::dimming_inc_fi::EApplicationStatus tAppState = ::dimming_inc_fi::eINACTIVE;
        tU8                                  u8AppVersion = 0xff;

        
        if (_poThermalInc) { 
            _poThermalInc->getComponentStatus(tAppState, u8AppVersion);
            _bDimState = _poThermalInc->bIsBacklightActive();
        }

        if (tAppState == ::dimming_inc_fi::eINACTIVE) {
            // here we have to call --> COMPONENT_STATUS seems not called by inc adapter
            if (sendCOMPONENT_STATUS() == FALSE) {
              ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vStartCommunication(): Failed to send component state!!!"));
            }
        } else {
            //INC channel already active
            onCOMPONENT_STATUS(tAppState, u8AppVersion);
        }
    }
    // control touch driver depending of DimState
    if (OSAL_NULL != m_poTouchDriverControl)
    {
        if (TRUE == bGetDimState())
        {
       	   m_poTouchDriverControl->s32RestartDriver(EARLY_CONFIG_TOUCHDRIVER_FIRST);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
       	   m_poTouchDriverControl->s32RestartDriver(EARLY_CONFIG_TOUCHDRIVER_SECOND);
#endif //#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        }
        else
        {
      	   m_poTouchDriverControl->s32StopDriver(EARLY_CONFIG_TOUCHDRIVER_FIRST);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
      	   m_poTouchDriverControl->s32StopDriver(EARLY_CONFIG_TOUCHDRIVER_SECOND);
#endif //#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
        }
    }
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    {
		//Populating Day and Night Matrix
		vUpdateDayBrightnessMatrix();
		vUpdateNightBrightnessMatrix();
		m_u8DimmingStrategy = u8DimmingStrategy();
    }
#endif
    // dispvidctrl_tclClientDimming::vStartCommunication: user specific code end
}

void dispvidctrl_tclClientDimming::onCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onCOMPONENT_STATUS():  Incomming msg: eSCC_DIMMING_R_COMPONENT_STATUS: ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));

    if (ApplicationStatus == ::dimming_inc_fi::eACTIVE) {
        _bAvailable = TRUE;
    }    

    // dispvidctrl_tclClientDimming_onCOMPONENT_STATUS: user specific code start
    if (TRUE == _bAvailable) {
    	if (TRUE == bGetDimState())
    		sendDISPLAY_REQ(::dimming_inc_fi::eACTIVATE_DISPLAY);
    	else
    		sendDISPLAY_REQ(::dimming_inc_fi::eDEACTIVATE_DISPLAY);
        sendDISPLAY_READY(::dimming_inc_fi::eLCD_READY);
        sendINFO_GET_DIMMINGMODE_STATE();
        sendGET_DIMMING_INFO_PRJ();
		sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType);
		_bReadBrightnessValDispPending = TRUE;
		_bReadBrightnessValICUPending = TRUE;
    }    
    // dispvidctrl_tclClientDimming_onCOMPONENT_STATUS: user specific code end
}
void dispvidctrl_tclClientDimming::onREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onREJECT():  Incomming msg: eSCC_DIMMING_R_REJECT: RejectReason: %u, RejectedMsgID: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_REJECTREASON, RejectReason), RejectedMsgID));

    // dispvidctrl_tclClientDimming_onREJECT: user specific code start
    // NCG3D-13847: handle reject of DIAG_SESSION or DIAG_SET_BRIGHTNESS_VAL
    tDiagDimMsg _popMsg;
    _popMsg.enMsgID = (::dimming_inc_fi::EMessageIds)RejectedMsgID;
    _popMsg.enResMsgID = ::dimming_inc_fi::eSCC_DIMMING_R_REJECT;
    // push new message
    (tVoid)u16DiagDimMsgPop2Send(_popMsg);
    // dispvidctrl_tclClientDimming_onREJECT: user specific code end
}
void dispvidctrl_tclClientDimming::onDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDISPLAY_REQ():  Incomming msg: eSCC_DIMMING_R_DISPLAY_REQ: DisplayRequest: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DISPLAYREQUEST, DisplayRequest)));

    // dispvidctrl_tclClientDimming_onDISPLAY_REQ: user specific code start
    if (OSAL_NULL != _poDimSrv) {
        dimming_fi_tcl_e8_DIM_Status oDimState;
        oDimState.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_OFF;

        if (DisplayRequest == ::dimming_inc_fi::eACTIVATE_DISPLAY){
            oDimState.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_ON;
        }
        _poDimSrv->sendDIM_DISP_BacklightStatus(oDimState);
    }
    // dispvidctrl_tclClientDimming_onDISPLAY_REQ: user specific code end
}
void dispvidctrl_tclClientDimming::onDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDISPLAY_READY():  Incomming msg: eSCC_DIMMING_R_DISPLAY_READY: DisplayReady: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DISPLAYREADY, DisplayReady)));

    // dispvidctrl_tclClientDimming_onDISPLAY_READY: user specific code start
    dp_tclDimmingDPINFO_DimmingModeConfig _oDimMode_Config;
    if (FALSE == sendINFO_SET_DIMMINGMODE_CONFIG((::dimming_inc_fi::EDimmingMode)_oDimMode_Config.tGetData())) {
    	ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDISPLAY_READY() sendINFO_SET_DIMMINGMODE_CONFIG %d failed!", _oDimMode_Config.tGetData() ));
    }
    if (OSAL_NULL != _poDimSrv)
    {
    	dimming_fi_tcl_e8_DIM_Status _oDriverInit;
    	_oDriverInit.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_OFF;
    	if (::dimming_inc_fi::eLCD_READY == DisplayReady)
        	_oDriverInit.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_ON;
    	_poDimSrv->sendDIM_DISP_DriverInitalizedStatus(_oDriverInit);
    }
    // dispvidctrl_tclClientDimming_onDISPLAY_READY: user specific code end
}
void dispvidctrl_tclClientDimming::onDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel, tU8 errorCode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDISP_SET_BRIGHTNESS_LEVEL():  Incomming msg: eSCC_DIMMING_R_DISP_SET_BRIGHTNESS_LEVEL: DimmingModeAndDispBrightnessLevel: %d, errorCode: %d", DimmingModeAndDispBrightnessLevel, errorCode));

    // dispvidctrl_tclClientDimming_onDISP_SET_BRIGHTNESS_LEVEL: user specific code start
    if (OSAL_NULL != _poDimSrv)
    {
    	tU8 _u8BrightnessLevel = (DimmingModeAndDispBrightnessLevel & 0x3f);
		ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDISP_SET_BRIGHTNESS_LEVEL(): _u8BrightnessLevel %d", _u8BrightnessLevel));
    	//_poDimSrv->sendDIM_DISP_BrightnessLevelExtendedStatus(_u8BrightnessLevel);
		dimming_fi_tcl_e8_DIM_BrightnessLevel _oBrightnessLevel;
		_oBrightnessLevel.enType = (dimming_fi_tcl_e8_DIM_BrightnessLevel::tenType)u8ConvertBlex2Bl(_u8BrightnessLevel);
		_poDimSrv->sendDIM_DISP_BrightnessLevelStatus(_oBrightnessLevel);
		
    }
    _bReadBrightnessValDispPending = TRUE;
    sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType);
    // dispvidctrl_tclClientDimming_onDISP_SET_BRIGHTNESS_LEVEL: user specific code end
}
void dispvidctrl_tclClientDimming::onDISP_SET_DIMMING(tU32 DispBrightness, tU8 errorCode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDISP_SET_DIMMING():  Incomming msg: eSCC_DIMMING_R_DISP_SET_DIMMING: DispBrightness: %d, errorCode: %d", DispBrightness, errorCode));

    // dispvidctrl_tclClientDimming_onDISP_SET_DIMMING: user specific code start
    // dispvidctrl_tclClientDimming_onDISP_SET_DIMMING: user specific code end
}
void dispvidctrl_tclClientDimming::onINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onINFO_SET_DIMMINGMODE_CONFIG():  Incomming msg: eSCC_DIMMING_R_INFO_SET_DIMMINGMODE_CONFIG: DimmingMode: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DIMMINGMODE, DimmingMode)));

    // dispvidctrl_tclClientDimming_onINFO_SET_DIMMINGMODE_CONFIG: user specific code start
    switch (DimmingMode)
    {
    case ::dimming_inc_fi::eAUTO:
    case ::dimming_inc_fi::eDAY:
    case ::dimming_inc_fi::eNIGHT:
		{
			_bUseNewCatalog = TRUE;
			dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
			if ((tU8)DimmingMode != _oDimModeConfig.tGetData())
			{
				_oDimModeConfig.vSetData((tU8)DimmingMode);
			}
		}
		break;
    default:
    	{
    		ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::onINFO_SET_DIMMINGMODE_CONFIG():  Invalid DimmingMode: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DIMMINGMODE, DimmingMode)));
    	}
    	break;
    }
    // dispvidctrl_tclClientDimming_onINFO_SET_DIMMINGMODE_CONFIG: user specific code end
}
void dispvidctrl_tclClientDimming::onINFO_GET_DIMMINGMODE_STATE(::dimming_inc_fi::EDimmingModeStatus DimmingMode, tS8 DispBrightnessOffset) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onINFO_GET_DIMMINGMODE_STATE():  Incomming msg: eSCC_DIMMING_R_INFO_GET_DIMMINGMODE_STATE: DimmingMode: %u, DispBrightnessOffset: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DIMMINGMODESTATUS, DimmingMode), DispBrightnessOffset));
	if(DimmingMode)
    {
    	_u8DimMode_State = DimmingMode;
    }
    // In case in RVC update brightness to default =11
    if(_poDisplaySettings && _u8prevDimMode_State != _u8DimMode_State)
    {
	   // _poDisplaySettings->vUpdateDisplaySettingsforDayNightButton();
		_u8prevDimMode_State = _u8DimMode_State;
    }
    // dispvidctrl_tclClientDimming_onINFO_GET_DIMMINGMODE_STATE: user specific code start
    // NCG3D-26251 related NCG3D-24250
    if ((m_enLast_DimmingMode != DimmingMode) || (m_s8Last_DispBrightnessOffset != DispBrightnessOffset))
    {
    	m_enLast_DimmingMode = DimmingMode;
    	m_s8Last_DispBrightnessOffset = DispBrightnessOffset;
    	m_u8CountEqual_onINFO_GET_DIMMINGMODE_STATE = 0;
    }
    else if (INC_CLIENTDIMMING_MAX_EQUALMSG_PROCESS > m_u8CountEqual_onINFO_GET_DIMMINGMODE_STATE)
    {
    	++m_u8CountEqual_onINFO_GET_DIMMINGMODE_STATE;
    }
    else
    {
        ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onINFO_GET_DIMMINGMODE_STATE: too many equal messages received: eSCC_DIMMING_R_INFO_GET_DIMMINGMODE_STATE: DimmingMode: %u, DispBrightnessOffset: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DIMMINGMODESTATUS, DimmingMode), DispBrightnessOffset));
    	return;
    }

    tBool _bIsNight = ((::dimming_inc_fi::eDimModeStatus_AUTO_NIGHT == DimmingMode) || (::dimming_inc_fi::eDimModeStatus_NIGHT == DimmingMode));
    // ... DimmingMode
	dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
	dp_tclDimmingDPINFO_DimmingModeCar _oDimModeCar;
// tU8 _u8DimModeCar = _oDimModeCar.tGetData();
	dp_tclDimmingDPINFO_DimmingModeStatus _oDimModeStatus;
// tU8 _u8DimModeStatus = _oDimModeStatus.tGetData();
    switch(DimmingMode)
    {
    case ::dimming_inc_fi::eDimModeStatus_AUTO_DAY:
    case ::dimming_inc_fi::eDimModeStatus_AUTO_NIGHT:
    case ::dimming_inc_fi::eDimModeStatus_DAY:
    case ::dimming_inc_fi::eDimModeStatus_NIGHT:
		{
			_oDimModeStatus.vSetData((tU8)DimmingMode);
			if (DimmingMode == ::dimming_inc_fi::eDimModeStatus_AUTO_DAY)
			{
				_oDimModeCar.vSetData(DISPVIDCTRL_U8_DIMMODECAR_DAY);
			}
			else if (DimmingMode == ::dimming_inc_fi::eDimModeStatus_AUTO_NIGHT)
			{
				_oDimModeCar.vSetData(DISPVIDCTRL_U8_DIMMODECAR_NIGHT);
			}
		}
		break;
    default:
		{
		    ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::onINFO_GET_DIMMINGMODE_STATE():  Invalid DimmingMode: %u, DispBrightnessLevel: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DIMMINGMODESTATUS, DimmingMode), DispBrightnessOffset));
		}
    	break;
    }
    if (OSAL_NULL != _poDimSrv)
    {
		dimming_fi_tcl_e8_DIM_Mode _enConfig;
		_enConfig.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeConfig.tGetData();
		dimming_fi_tcl_e8_DIM_Mode _enCar;
		_enCar.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeCar.tGetData();
		dimming_fi_tcl_e8_DIM_Mode _enStatus;
		_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)DimmingMode;
		if (dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO < _enStatus.enType)
		{
			_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
		}
		else if (dimming_fi_tcl_e8_DIM_Mode::FI_EN_DAY > _enStatus.enType)
		{
			_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
		}

		// send to Video Controller to update the RVC/AVM/IPA Video's accordingly
        // send to Video Controller to update the RVC/AVM/IPA Video's accordingly
        if ( (_cpoMain != NULL) && (_cpoMain->theServer() != NULL) )
        {
            tChar strIfName[] = "dispvidctrl_tclControl_Video";
            if ( _enStatus.enType != dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO ) {
                _cpoMain->theServer()->vPostMsgDimStateChanged(strIfName, (tU32) _enStatus.enType );
            } else {
                _cpoMain->theServer()->vPostMsgDimStateChanged(strIfName, (tU32) _enCar.enType );
            }
        }
		if (DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT == DimmingMode)
		{
			_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT;
			ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::Entered 12 DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT"));
		}
		if(DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY == DimmingMode)
		{
			_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY;
			ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::Entered 12 DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY"));
		}
		_poDimSrv->sendDIM_INFO_DimmingModeStatus(_enConfig, _enCar, _enStatus);
    }
    // ... BightnessLevel
    tU8 _u8BrightnessLevel = (tU8)DispBrightnessOffset;
    if ((OSAL_NULL != _cpoMain) && (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8BrightnessLevel))
    {
    	_u8BrightnessLevel = DISPVIDCTRL_C_U8_LEVEL_MAX;
		_cpoMain->theServer()->vPostMsgDimBrightnessChanged("I_dispvidctrl_tclClientDimming", _u8BrightnessLevel);
    }
	if (TRUE == _bIsNight)
	{
		dp_tclDimmingDPDISP_BrightnessLevelExtended_Night _oBrightnessLevelNight;
		_oBrightnessLevelNight.vSetData(_u8BrightnessLevel);
	}
	else
	{
	    dp_tclDimmingDPDISP_BrightnessLevelExtended_Day _oBrightnessLevelDay;
		_oBrightnessLevelDay.vSetData(_u8BrightnessLevel);
	}
    if (OSAL_NULL != _poDimSrv)
    {
    	_poDimSrv->sendDIM_DISP_BrightnessLevelExtendedStatus(_u8BrightnessLevel);
		dimming_fi_tcl_e8_DIM_BrightnessLevel _oBrightnessLevel;
		_oBrightnessLevel.enType = (dimming_fi_tcl_e8_DIM_BrightnessLevel::tenType)u8ConvertBlex2Bl(_u8BrightnessLevel);
		_poDimSrv->sendDIM_DISP_BrightnessLevelStatus(_oBrightnessLevel);
		_bReadBrightnessValDispPending = TRUE;
    	sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType);
    }
	// Brightness enhancement (AIVI-22378)
#ifdef VARIANT_S_FTR_ENABLE_BRIGHTNESS_ENHANCEMENT
    if (OSAL_NULL != _poDisplaySettings)
	{
		if (FALSE == _bIsNight)
		{
			(tVoid)_poDisplaySettings->s32EnhanceBrightness((tU8)DispBrightnessOffset,DISPVIDCTRL_U8_DIMMODECAR_DAY);
		}
		else
		{
			(tVoid)_poDisplaySettings->s32EnhanceBrightness((tU8)DispBrightnessOffset,DISPVIDCTRL_U8_DIMMODECAR_NIGHT);
		}
	}
#endif //#ifdef VARIANT_S_FTR_ENABLE_BRIGHTNESS_ENHANCEMENT
    // dispvidctrl_tclClientDimming_onINFO_GET_DIMMINGMODE_STATE: user specific code end
}
void dispvidctrl_tclClientDimming::onDIAG_DISP_READ_BRIGHT_VAL(tU8 DispBrightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDIAG_DISP_READ_BRIGHT_VAL():  Incomming msg: eSCC_DIMMING_R_DIAG_DISP_READ_BRIGHT_VAL: DispBrightness: %d", DispBrightness));

    // dispvidctrl_tclClientDimming_onDIAG_DISP_READ_BRIGHT_VAL: user specific code start
    // dispvidctrl_tclClientDimming_onDIAG_DISP_READ_BRIGHT_VAL: user specific code end
}
void dispvidctrl_tclClientDimming::onDIAG_KEYB_READ_BRIGHT_VAL(tU8 KeyB_Brightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDIAG_KEYB_READ_BRIGHT_VAL():  Incomming msg: eSCC_DIMMING_R_DIAG_KEYB_READ_BRIGHT_VAL: KeyB_Brightness: %d", KeyB_Brightness));

    // dispvidctrl_tclClientDimming_onDIAG_KEYB_READ_BRIGHT_VAL: user specific code start
    // dispvidctrl_tclClientDimming_onDIAG_KEYB_READ_BRIGHT_VAL: user specific code end
}
void dispvidctrl_tclClientDimming::onDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDIAG_KEYB_SET_DIMMING():  Incomming msg: eSCC_DIMMING_R_DIAG_KEYB_SET_DIMMING: KeyB_Brightness: %d", KeyB_Brightness));

    // dispvidctrl_tclClientDimming_onDIAG_KEYB_SET_DIMMING: user specific code start
    // dispvidctrl_tclClientDimming_onDIAG_KEYB_SET_DIMMING: user specific code end
}
void dispvidctrl_tclClientDimming::onDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDIAG_SESSION():  Incomming msg: eSCC_DIMMING_R_DIAG_SESSION: Session_Type: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_SESSIONTYPE, Session_Type)));

    // dispvidctrl_tclClientDimming_onDIAG_SESSION: user specific code start
    if (OSAL_NULL != _poDimSrv)
    {
		dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
		dimming_fi_tcl_e8_DIM_EmulationMode _oEmulationMode;
		_oEmulationMode.enType = (dimming_fi_tcl_e8_DIM_EmulationMode::tenType)Session_Type;
		tU8 _u8EmulationModeOld = _oDpEmulationMode.tGetData();
		_oDpEmulationMode.vSetData((tU8)_oEmulationMode.enType);
		if (TRUE == _bMethodEmulationModeSetPending)
		{
			_poDimSrv->sendDIM_INFO_SetEmulationModeMResult(_oEmulationMode);
			_bMethodEmulationModeSetPending = FALSE;
		}
		_poDimSrv->sendDIM_INFO_EmulationModeStatus(_oEmulationMode);
		if (_u8EmulationModeOld != _oDpEmulationMode.tGetData())
		{
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType);
			_bReadBrightnessValDispPending = TRUE;
			_bReadBrightnessValICUPending = TRUE;
		}
    }

    // NCG3D-13847: handle response DIAG_SESSION
    tDiagDimMsg _popMsg;
    _popMsg.enMsgID = ::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SESSION;
    _popMsg.enResMsgID = ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_SESSION;
    _popMsg.Data.DIAG_SESSION.Session_Type = Session_Type;
    // push new message
    (tVoid)u16DiagDimMsgPop2Send(_popMsg);
    // dispvidctrl_tclClientDimming_onDIAG_SESSION: user specific code end
}
void dispvidctrl_tclClientDimming::onDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDIAG_READ_BRIGHTNESS_VAL():  Incomming msg: eSCC_DIMMING_R_DIAG_READ_BRIGHTNESS_VAL: Device_Type: %u, Brightness: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, Device_Type), Brightness));

    // dispvidctrl_tclClientDimming_onDIAG_READ_BRIGHTNESS_VAL: user specific code start
    if (OSAL_NULL != _poDimSrv)
    {
		dimming_fi_tcl_u16_DIM_Permille _oBrightness(Brightness);
    	if (::dimming_inc_fi::eKEY_DeviceType == Device_Type)
    	{
    		_bReadBrightnessValKeybPending = FALSE;
    		_poDimSrv->sendDIM_KEYB_BrightnessStatus(_oBrightness);
    		_u8KeybBrightness = (tU8)(Brightness / 10);
    	}
    	else if (::dimming_inc_fi::eDISPLAY_DeviceType == Device_Type)
    	{
			_bReadBrightnessValDispPending = FALSE;
    		_poDimSrv->sendDIM_DISP_BrightnessStatus(_oBrightness);
    		_u8DispBrightness = (tU8)(Brightness / 10);
    	}
    	else if (::dimming_inc_fi::eICU_DeviceType == Device_Type)
    	{
    		_bReadBrightnessValICUPending = FALSE;
    		if (TRUE == _bMethodIcuBrightnessGetPending)
    		{
    			_poDimSrv->sendDIM_INFO_GetPWMBrightnessMResult(_oBrightness);
    			_bMethodIcuBrightnessGetPending = FALSE;
    		}
    		_poDimSrv->sendDIM_INFO_PWMBrightnessStatus(_oBrightness);
    	}
    	else if (::dimming_inc_fi::eILLPLUS_DeviceType == Device_Type)
    	{
    		// currently unsupported
    	}
    	// pending request
    	if (TRUE == _bReadBrightnessValKeybPending)
    	{
        	_bReadBrightnessValKeybPending = FALSE;
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType);
    	}
    	else if (TRUE == _bReadBrightnessValDispPending)
    	{
    		_bReadBrightnessValDispPending = FALSE;
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType);
    	}
    	else if (TRUE == _bReadBrightnessValICUPending)
		{
    		_bReadBrightnessValICUPending = FALSE;
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eICU_DeviceType);
		}
    }
    // dispvidctrl_tclClientDimming_onDIAG_READ_BRIGHTNESS_VAL: user specific code end
}
void dispvidctrl_tclClientDimming::onDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onDIAG_SET_BRIGHTNESS_VAL():  Incomming msg: eSCC_DIMMING_R_DIAG_SET_BRIGHTNESS_VAL: Device_Type: %u, Brightness: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, Device_Type), Brightness));

    // dispvidctrl_tclClientDimming_onDIAG_SET_BRIGHTNESS_VAL: user specific code start
    if (OSAL_NULL != _poDimSrv)
    {
		dimming_fi_tcl_u16_DIM_Permille _oBrightness(Brightness);
    	if (::dimming_inc_fi::eKEY_DeviceType == Device_Type)
    	{
    		if (TRUE == _bMethodKeyBrightnessSetPending)
    		{
    			_poDimSrv->sendDIM_KEYB_SetDimmingMResult(_oBrightness);
    			_bMethodKeyBrightnessSetPending = FALSE;
    		}
    		if (TRUE == _bMethodKeyPwmBrightnessSetPending)
    		{
    			_poDimSrv->sendDIM_KEYB_SetDimmingPWMMResult(_oBrightness);
    			_bMethodKeyPwmBrightnessSetPending = FALSE;
    		}
    		_poDimSrv->sendDIM_KEYB_BrightnessStatus(_oBrightness);
    	}
    	else if (::dimming_inc_fi::eDISPLAY_DeviceType == Device_Type)
    	{
    		if (TRUE == _bMethodDispBrightnessSetPending)
    		{
    			_poDimSrv->sendDIM_DISP_SetDimmingMResult(_oBrightness);
        		_bMethodDispBrightnessSetPending = FALSE;
    		}
    		_poDimSrv->sendDIM_DISP_BrightnessStatus(_oBrightness);
    	}
    	else if (::dimming_inc_fi::eICU_DeviceType == Device_Type)
    	{

    	}
    	else if (::dimming_inc_fi::eILLPLUS_DeviceType == Device_Type)
    	{

    	}
    	// pending request
    	if (TRUE == _bReadBrightnessValKeybPending)
    	{
        	_bReadBrightnessValKeybPending = FALSE;
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType);
    	}
    	else if (TRUE == _bReadBrightnessValDispPending)
    	{
    		_bReadBrightnessValDispPending = FALSE;
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType);
    	}
    	else if (TRUE == _bReadBrightnessValICUPending)
		{
    		_bReadBrightnessValICUPending = FALSE;
			sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eICU_DeviceType);
		}

        // NCG3D-13847: handle response of DIAG_SET_BRIGHTNESS_VAL
        tDiagDimMsg _popMsg;
        _popMsg.enMsgID = ::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SET_BRIGHTNESS_VAL;
        _popMsg.enResMsgID = ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_SET_BRIGHTNESS_VAL;
        _popMsg.Data.DIAG_SET_BRIGHTNESS_VAL.Device_Type = Device_Type;
        _popMsg.Data.DIAG_SET_BRIGHTNESS_VAL.Brightness = Brightness;
        // push new message
        (tVoid)u16DiagDimMsgPop2Send(_popMsg);
    }
    // dispvidctrl_tclClientDimming_onDIAG_SET_BRIGHTNESS_VAL: user specific code end
}
void dispvidctrl_tclClientDimming::onGET_DIMMING_INFO_PRJ(tU32 DimInfoPrj) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onGET_DIMMING_INFO_PRJ():  Incomming msg: eSCC_DIMMING_R_GET_DIMMING_INFO_PRJ: DimInfoPrj: %d", DimInfoPrj));

    // dispvidctrl_tclClientDimming_onGET_DIMMING_INFO_PRJ: user specific code start
    // see https://hi-dms.de.bosch.com/docushare/dsweb/Services/Document-777285
    // ... DimmingModeCar
	dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
	dp_tclDimmingDPINFO_DimmingModeCar _oDimModeCar;
	dp_tclDimmingDPINFO_DimmingModeStatus _oDimModeStatus;
	tU8 _u8DimModeCar = _oDimModeCar.tGetData();
    if (OSAL_NULL < (1 & DimInfoPrj))
    {
    	_oDimModeCar.vSetData(DISPVIDCTRL_U8_DIMMODECAR_NIGHT);
    	_bMR_OUTPUT = TRUE;
    }
    else
    {
    	_oDimModeCar.vSetData(DISPVIDCTRL_U8_DIMMODECAR_DAY);
    	_bMR_OUTPUT = FALSE;
    }
    if (OSAL_NULL != _poDimSrv)
    {
		if (_u8DimModeCar != _oDimModeCar.tGetData())
		{
			dimming_fi_tcl_e8_DIM_Mode _enConfig;
			_enConfig.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeConfig.tGetData();
			dimming_fi_tcl_e8_DIM_Mode _enCar;
			_enCar.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeCar.tGetData();
			dimming_fi_tcl_e8_DIM_Mode _enStatus;
			_enStatus.enType = (dimming_fi_tcl_e8_DIM_Mode::tenType)_oDimModeStatus.tGetData();
			if (dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO < _enStatus.enType)
			{
				_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
			}
			else if (dimming_fi_tcl_e8_DIM_Mode::FI_EN_DAY > _enStatus.enType)
			{
				_enStatus.enType = dimming_fi_tcl_e8_DIM_Mode::FI_EN_AUTO;
			}
			//_poDimSrv->sendDIM_INFO_DimmingModeStatus(_enConfig, _enCar, _enStatus);
		}
		// ... CarIlluminationInfo
		dimming_fi_tcl_e8_DIM_Status _enIlluminationSwitch;
		if ((OSAL_NULL < (2 & DimInfoPrj)))
		{
			_enIlluminationSwitch.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_ON;
			_bIllActive = TRUE;
		}
		else
		{
			_bIllActive = FALSE;
		}
		dimming_fi_tcl_u16_DIM_Permille _u16IlluminationBrightness;
		_u16IlluminationBrightness.u16Value = (tU16)((0x00FFFF00 & DimInfoPrj) >> 8);
		_u8IllBrightness = (tU8)(_u16IlluminationBrightness.u16Value / 10);
		_poDimSrv->sendDIM_INFO_CarIlluminationDataStatus(_enIlluminationSwitch, _u16IlluminationBrightness);
		// reading current brightness of keyboard and display
		sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType);
		_bReadBrightnessValDispPending = TRUE;
		_bReadBrightnessValICUPending = TRUE;
    }
    // dispvidctrl_tclClientDimming_onGET_DIMMING_INFO_PRJ: user specific code end
}
void dispvidctrl_tclClientDimming::onSECOND_DISP_GET_HW_VERSION(tU32 HWVersion) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onSECOND_DISP_GET_HW_VERSION():  Incomming msg: eSCC_DIMMING_R_SECOND_DISP_GET_HW_VERSION: HWVersion: %d", HWVersion));

    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_HW_VERSION: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->update_HWVersionInfo(HWVersion);
    }
#endif	
    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_HW_VERSION: user specific code end
}
void dispvidctrl_tclClientDimming::onSECOND_DISP_GET_SW_VERSION(tU32 SWVersion) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onSECOND_DISP_GET_SW_VERSION():  Incomming msg: eSCC_DIMMING_R_SECOND_DISP_GET_SW_VERSION: SWVersion: %d", SWVersion));

    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_SW_VERSION: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->update_SWVersionInfo(SWVersion);
    }
#endif		
    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_SW_VERSION: user specific code end
}
void dispvidctrl_tclClientDimming::onSECOND_DISP_SET_DISPLAY_PARAMETERS(tU16 u16FunctionId, tU16 u16ParameterValue, tU8 u8ErrorCode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onSECOND_DISP_SET_DISPLAY_PARAMETERS():  Incomming msg: eSCC_DIMMING_R_SECOND_DISP_SET_DISPLAY_PARAMETERS: u16FunctionId: %d, u16ParameterValue: %d, u8ErrorCode: %d", u16FunctionId, u16ParameterValue, u8ErrorCode));

    // dispvidctrl_tclClientDimming_onSECOND_DISP_SET_DISPLAY_PARAMETERS: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->update_DisplayParam(u16FunctionId, u16ParameterValue, u8ErrorCode);
    }
#endif
    // dispvidctrl_tclClientDimming_onSECOND_DISP_SET_DISPLAY_PARAMETERS: user specific code end
}
void dispvidctrl_tclClientDimming::onSECOND_DISP_GET_DIMMING_PARAMETERS(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onSECOND_DISP_GET_DIMMING_PARAMETERS():  Incomming msg: eSCC_DIMMING_R_SECOND_DISP_GET_DIMMING_PARAMETERS: u8BlackLevel: %d, u8Brightness: %d, u8Color: %d, u8Contrast: %d, u8Tint: %d, u8GammaLevel: %d", u8BlackLevel, u8Brightness, u8Color, u8Contrast, u8Tint, u8GammaLevel));

    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_DIMMING_PARAMETERS: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->update_AllDisplayParam(u8BlackLevel,u8Brightness, u8Color,
    			                                   u8Contrast, u8Tint, u8GammaLevel);
    }
#endif
    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_DIMMING_PARAMETERS: user specific code end
}
void dispvidctrl_tclClientDimming::onSEND_POWERMODE_TO_V850(tU8 u8PowerState, tU8 u8ErrorCode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onSEND_POWERMODE_TO_V850():  Incomming msg: eSCC_DIMMING_R_SEND_POWERMODE_TO_V850: u8PowerState: %d, u8ErrorCode: %d", u8PowerState, u8ErrorCode));

    // dispvidctrl_tclClientDimming_onSEND_POWERMODE_TO_V850: user specific code start
    // dispvidctrl_tclClientDimming_onSEND_POWERMODE_TO_V850: user specific code end
}
void dispvidctrl_tclClientDimming::onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT(tU16 u16SelfDiagResult ) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT():  Incomming msg: eSCC_DIMMING_R_SECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: u16SelfDiagResult : %d", u16SelfDiagResult ));

    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->update_SelfDiagResult(u16SelfDiagResult);
    }
#endif
    // dispvidctrl_tclClientDimming_onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: user specific code end
}

tBool dispvidctrl_tclClientDimming::sendCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendCOMPONENT_STATUS():  ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));
    if (_poThermalInc) {
        return _poThermalInc->sendCOMPONENT_STATUS(ApplicationStatus, ApplicationVersion);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendREJECT():  RejectReason: %u, RejectedMsgID: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_REJECTREASON, RejectReason), RejectedMsgID));
    if (_poThermalInc) {
        return _poThermalInc->sendREJECT(RejectReason, RejectedMsgID);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDISPLAY_REQ():  DisplayRequest: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DISPLAYREQUEST, DisplayRequest)));
    if (_poThermalInc) {
        return _poThermalInc->sendDISPLAY_REQ(DisplayRequest);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDISPLAY_READY():  DisplayReady: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DISPLAYREADY, DisplayReady)));
    if (_poThermalInc) {
        return _poThermalInc->sendDISPLAY_READY(DisplayReady);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDISP_SET_BRIGHTNESS_LEVEL():  DimmingModeAndDispBrightnessLevel: %d", DimmingModeAndDispBrightnessLevel));
    if (_poThermalInc) {
        return _poThermalInc->sendDISP_SET_BRIGHTNESS_LEVEL(DimmingModeAndDispBrightnessLevel);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDISP_SET_DIMMING(tU32 DispBrightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDISP_SET_DIMMING():  DispBrightness: %d", DispBrightness));
    if (_poThermalInc) {
        return _poThermalInc->sendDISP_SET_DIMMING(DispBrightness);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendKEY_SET_BRIGHTNESS_LEVEL(tU8 KeyBrightnessLevel) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendKEY_SET_BRIGHTNESS_LEVEL():  KeyBrightnessLevel: %d", KeyBrightnessLevel));
    if (_poThermalInc) {
        return _poThermalInc->sendKEY_SET_BRIGHTNESS_LEVEL(KeyBrightnessLevel);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendINFO_SET_DIMMINGMODE_CONFIG():  DimmingMode: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DIMMINGMODE, DimmingMode)));
    if (_poThermalInc) {
        return _poThermalInc->sendINFO_SET_DIMMINGMODE_CONFIG(DimmingMode);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendINFO_GET_DIMMINGMODE_STATE() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendINFO_GET_DIMMINGMODE_STATE():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendINFO_GET_DIMMINGMODE_STATE();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDIAG_DISP_READ_BRIGHT_VAL() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDIAG_DISP_READ_BRIGHT_VAL():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendDIAG_DISP_READ_BRIGHT_VAL();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDIAG_KEYB_READ_BRIGHT_VAL() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDIAG_KEYB_READ_BRIGHT_VAL():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendDIAG_KEYB_READ_BRIGHT_VAL();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDIAG_KEYB_SET_DIMMING():  KeyB_Brightness: %d", KeyB_Brightness));
    if (_poThermalInc) {
        return _poThermalInc->sendDIAG_KEYB_SET_DIMMING(KeyB_Brightness);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDIAG_SESSION():  Session_Type: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_SESSIONTYPE, Session_Type)));
    if (_poThermalInc) {
        return _poThermalInc->sendDIAG_SESSION(Session_Type);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDIAG_READ_BRIGHTNESS_VAL():  Device_Type: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, Device_Type)));
    if (_poThermalInc) {
        return _poThermalInc->sendDIAG_READ_BRIGHTNESS_VAL(Device_Type);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendDIAG_SET_BRIGHTNESS_VAL():  Device_Type: %u, Brightness: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, Device_Type), Brightness));
    if (_poThermalInc) {
        return _poThermalInc->sendDIAG_SET_BRIGHTNESS_VAL(Device_Type, Brightness);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendGET_DIMMING_INFO_PRJ() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendGET_DIMMING_INFO_PRJ():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendGET_DIMMING_INFO_PRJ();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_HW_VERSION() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_HW_VERSION():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendSECOND_DISP_GET_HW_VERSION();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_SW_VERSION() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_SW_VERSION():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendSECOND_DISP_GET_SW_VERSION();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendSECOND_DISP_SET_DISPLAY_PARAMETERS(::dimming_inc_fi::ESecondDisplayParamID e16SecondDisplayParamID, tU16 u16ParameterValue) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendSECOND_DISP_SET_DISPLAY_PARAMETERS():  e16SecondDisplayParamID: %u, u16ParameterValue: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_SECONDDISPLAYPARAMID, e16SecondDisplayParamID), u16ParameterValue));
    if (_poThermalInc) {
        return _poThermalInc->sendSECOND_DISP_SET_DISPLAY_PARAMETERS(e16SecondDisplayParamID, u16ParameterValue);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_DIMMING_PARAMETERS() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_DIMMING_PARAMETERS():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendSECOND_DISP_GET_DIMMING_PARAMETERS();
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendSEND_POWERMODE_TO_V850(tU8 u8PowerMode) {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendSEND_POWERMODE_TO_V850():  u8PowerMode: %d", u8PowerMode));
    if (_poThermalInc) {
        return _poThermalInc->sendSEND_POWERMODE_TO_V850(u8PowerMode);
    }
    return FALSE;
}
tBool dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT() {
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT():  "));
    if (_poThermalInc) {
        return _poThermalInc->sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT();
    }
    return FALSE;
}

// dispvidctrl_tclClientDimmingAddClassPart: user specific code start

/*******************************************************************************
*
* FUNCTION:    s32ResetDimming()
*
* DESCRIPTION: reset all dimming properties
*
* PARAMETER:   none
*
* RETURNVALUE: tS32   { less 0 - failed | else success }
*
*******************************************************************************/
tS32 dispvidctrl_tclClientDimming::s32ResetDimming(tVoid)
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::s32ResetDimming():  "));

    tS32 _s32Return = 0;
    // reset brightness level (NCG3D-9822)
    if (FALSE == sendDISP_SET_BRIGHTNESS_LEVEL(0xFF))
    {
    	_s32Return += -2;
    }
    // reset dimming mode config
    if (FALSE == sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::eAUTO))
    {
    	_s32Return += -1;
    }

//For Renault Slider Reset++
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    vSendDimBrightnessValToV850(10, 10);  //Send row and column as 10 and 10 to select random middle brightness value from Matrix
    //Also We shall update HMI properties with offset as 10
    if(_poDimSrv != NULL)
    {
		_poDimSrv->sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(10);
		_poDimSrv->sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(10);
		_poDimSrv->sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(10);
    }
    //Also Make sure Datapool slider values are also reset to 10
    vReset_Disp_SliderOffsetDatapoolElements(10);
#endif
//For Renault Slider Reset--

//For PIVI Slider Reset ++
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    //Calling this func, will trigger V850 to send back all dimming parameters after reset.
    //Then on Receiving Values from V850 HMI sliders will also get Reset.
    sendSECOND_DISP_GET_DIMMING_PARAMETERS();
#endif
//For PIVI Slider Reset --
    return _s32Return;
}

/*******************************************************************************
*
* FUNCTION:    bGetDimState()
*
* DESCRIPTION: return current dim state of back light
*
*              NOTE for RVC video:
*              Backlight can be active on startup already (early video) before this class was instantiated/SPM was telling the ON state.
*              or Scope2.1: RVC video must be activated when "CustomerFeedback", "DisplayRequest" is not needed (Spm state OFF).
*
* PARAMETER:   none
*
* RETURNVALUE: tBool
*
*******************************************************************************/
tBool dispvidctrl_tclClientDimming::bGetDimState(tVoid) const
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::bGetDimState():  "));

	if (((eBackLight_Spm_On == m_enBacklightState_SPM)
       || (eBackLight_RVC_On == m_enBacklightState_RVC))
		&& (eBackLight_Cvm_Off != m_enBacklightState_CVM)
		&& (eBackLight_Hmi_Off != m_enBacklightState_HMI)
		&& (eBackLight_BERR_Off != m_enBacklightState_BERR)
		&& (eBackLight_HC_Off != m_enBacklightState_HC)
		&& (eBackLight_RVC_Off != m_enBacklightState_RVC))
		return TRUE;
	return FALSE;
}

//------------------------------------------------------------------------------
//	VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1 Specific Public Interfaces Start
//------------------------------------------------------------------------------

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
/*******************************************************************************
*
* FUNCTION:    vSendDimBrightnessValToV850()
*
* DESCRIPTION: return current dim state of back light
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vSendDimBrightnessValToV850(tU8 u8RowOffset, tU8 u8ColOffset)
{
	tU16 u16DayBrightness = 800;
	tU16 u16NightBrightness = 500;
	tU32 u32DispV850Brightness = tU32( (tU32(u16NightBrightness)<<16) | (u16DayBrightness) );

	if(u8RowOffset<21 && u8ColOffset<21)
	{
		u16DayBrightness = _aDayDispBrightnessMatrix[u8RowOffset][u8ColOffset]; //*10;
		u16NightBrightness = _aNightDispBrightnessMatrix[u8RowOffset][u8ColOffset]; //*10;

		ETG_TRACE_USR1(("u8RowOffset = %d, u8ColOffset=%d",u8RowOffset, u8ColOffset));
	}
	else
	{
		ETG_TRACE_USR1((": ERROR!.. Silder Values of : (HMI)->u8RowOffset=%d OR  (Cockpit/CAN)->u8ColOffset is OUT OF Range=%d", u8RowOffset, u8ColOffset));
		ETG_TRACE_USR1((": vSendDimBrightnessValToV850-> So Set Default Values: Day to 80 and Night as 50"));
	}

	ETG_TRACE_USR1(("u16DayBrightness = %d, u16NightBrightness=%d",u16DayBrightness, u16NightBrightness));

	//sendDISP_SET_DIMMING to V850
	if(_poThermalInc != NULL && m_bIsDarkModeEnabled == FALSE)
	{
		//Creating 2 Bytes for V850 Night as MSB and Day as LSB
        u32DispV850Brightness = tU32( (tU32(u16NightBrightness)<<16) | (u16DayBrightness) );

        if( TRUE == _poThermalInc->sendDISP_SET_DIMMING(u32DispV850Brightness) )
		{
			ETG_TRACE_USR1((": vSelectDimmBrightnessVal:: sendDISP_SET_DIMMING (Day: %d , Night: %d) to V850",
					         u16DayBrightness, u16NightBrightness ));
		}
		else
		{
			ETG_TRACE_ERR((":\tsendDISP_SET_DIMMING(u32DispV850Brightness) INC message Send Failed !!!"));
		}
	}
	else
	{
		ETG_TRACE_USR1((":vSendDimBrightnessValToV850-> Didnt Send Brigthenss to V850 , as DarkMode is Enabled or Null pointer"));
	}

}

/*******************************************************************************
*
* FUNCTION:    vHandleDarkModeReq()
*
* DESCRIPTION: Sets V850 brightness depending upon the Dark Mode Status
*
* PARAMETER:   bStatus for Dark Mode
*
* RETURNVALUE: void
*
*******************************************************************************/

void dispvidctrl_tclClientDimming::vHandleDarkModeReq(tBool bStatus)
{
	ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::vHandleDarkModeReq() Entered"));
	m_bIsDarkModeEnabled = bStatus;
	if(m_bIsDarkModeEnabled == TRUE)
	{
		tU16 u16DayBrightness = 200;
		tU16 u16NightBrightness = 200;
		tU32 u32DispV850Brightness = tU32( (tU32(u16NightBrightness)<<16) | (u16DayBrightness) );
		if(_poThermalInc != NULL)
		{
			//Creating 2 Bytes for V850 Night as MSB and Day as LSB
			u32DispV850Brightness = tU32( (tU32(u16NightBrightness)<<16) | (u16DayBrightness) );

			if( TRUE == _poThermalInc->sendDISP_SET_DIMMING(u32DispV850Brightness) )
			{
				ETG_TRACE_USR1((": vHandleDarkModeReq: sendDISP_SET_DIMMING [DarkMode Enabled](Day: %d , Night: %d) to V850",
								 u16DayBrightness, u16NightBrightness ));
			}
			else
			{
				ETG_TRACE_ERR((":vHandleDarkModeReq: sendDISP_SET_DIMMING(u32DispV850Brightness) INC message Send Failed !!!"));
			}
		}
	}
	else
	{
		ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::vHandleDarkModeReq()->vUpdateINCforBrightness calling when darkmode is false"));
		vUpdateINCforBrightness();

	}


}

/*******************************************************************************
*
* FUNCTION:    sUnitType()
*
* DESCRIPTION: return VCANDiversityType for back light
*
* PARAMETER:   none
*
* RETURNVALUE: tU8: 0x01 -> C1A, 0x03 ->T4VS, 0x00-> Default Supplier
*
*******************************************************************************/
tU8 dispvidctrl_tclClientDimming::sUnitType(tVoid)
{
	ETG_TRACE_USR1((": sUnitType() Enter"));
	tU8 VCANDiversityType = 0xFF;  //whether C1A (0x01) or T4VS (0x03)
	dp_tclKdsVehicleInformation _oKdsVehicleInfo;
	_oKdsVehicleInfo.u8GetVCANDiversity(VCANDiversityType);
	return VCANDiversityType;

}
/*******************************************************************************
*
* FUNCTION:    u8DimmingStrategy()
*
* DESCRIPTION: return Dimming Strategy for back light
*
* PARAMETER:   [0x00] by meter
* 			   [0x01] by head-unit
*
* RETURNVALUE: tU8
*
*******************************************************************************/
tU8  dispvidctrl_tclClientDimming::u8DimmingStrategy(tVoid)
{
	tU8 u8DimmingStrategy = 0;
	ETG_TRACE_USR1((": u8DimmingStrategy() Enter"));
	dp_tclKdsHMIConfig _oKdsHMIConfig;
	_oKdsHMIConfig.u8GetCFGDimmingStrategy(u8DimmingStrategy);
	ETG_TRACE_USR1((": u8DimmingStrategy() is .. %d ", m_u8DimmingStrategy));
	return u8DimmingStrategy;

}

/*******************************************************************************
*
* FUNCTION:    u8DimmingStrategy()
*
* DESCRIPTION: return m_enLast_DimmingMode Member Variable which stores
* 			   Last Dimming Mode for back light received from INC Message
*
* PARAMETER:   None
*
* RETURNVALUE: tU8
*	        INVALID = 0
*	        DAY = 1
*	        NIGHT = 2
*	        AUTO_DAY = 3
*	        AUTO_NIGHT = 4
*
*******************************************************************************/
tU8  dispvidctrl_tclClientDimming::u8GetLastDimmingMode_INCValue(tVoid)
{
	   return m_enLast_DimmingMode;
}
/*******************************************************************************
*
* FUNCTION:    vLoadDataFromMeter()
*
* DESCRIPTION: set Offset received from CAN and sends update INC message
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vLoadDataFromMeter(tU8 u8OffsetFromCAN)
{
	ETG_TRACE_USR1((": vLoadDataFromMeter() Enter %d ", u8OffsetFromCAN));

	if(u8OffsetFromCAN < 21)
	{
		m_u8OffsetFromCAN =  u8OffsetFromCAN;
		vUpdateINCforBrightness();
	}
	else
	{
		ETG_TRACE_FATAL((": vLoadDataFromMeter() ERROR Value of CAN Offset  Out of Range = %d ", u8OffsetFromCAN));
	}
}

/*******************************************************************************
*
* FUNCTION:    vLoadDataFromHMI()
*
* DESCRIPTION: set Offset received from HMI and sends update INC message
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vLoadDataFromHMI(tU8 u8HMIOffsetValue)
{
	ETG_TRACE_USR1((": vLoadDataFromHMI() Enter %d ", u8HMIOffsetValue));
	m_u8OffsetFromDayorNightHMISlider = u8HMIOffsetValue;
	vUpdateINCforBrightness();
}
/*******************************************************************************
*
* FUNCTION:    vLoadDataFromHMICockpitSlider()
*
* DESCRIPTION: set u8CockpitOffsetValue received from HMI and sends update
*              INC message
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vLoadDataFromHMICockpitSlider(tU8 u8CockpitOffsetValue)
{
	ETG_TRACE_USR1((": vLoadDataFromHMICockpitSlider() Enter %d", u8CockpitOffsetValue));
	m_u8OffsetFromHMICockpitSlider = u8CockpitOffsetValue;
	vUpdateINCforBrightness();
}
/*******************************************************************************
*
* FUNCTION:    vUpdateINCforBrightness()
*
* DESCRIPTION: sends Day and Night Brightness INC message to V850
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vUpdateINCforBrightness()
{
	//For T4VS changes, we can Hardcoe the column value to 10 here
	tU8 u8RenaultCANType = sUnitType();
	//u8RenaultCANType = 0x01 ; means C1A
	//u8RenaultCANType = 0x03; means T4VS
	ETG_TRACE_USR1((": vUpdateINCforBrightness() Enter"));

	if(u8RenaultCANType == CAN_CFG_C1A)
	{
		switch(m_u8DimmingStrategy)
		{
			case eMeterMaster:
			{
				ETG_TRACE_USR1(("vUpdateINCforBrightness C1A: Meter is the Master for Dimming Strategy"));
				vSendDimBrightnessValToV850(m_u8OffsetFromDayorNightHMISlider, m_u8OffsetFromCAN);
			}
			break;
			case eHeadUnitMaster:
			{
				ETG_TRACE_USR1(("vUpdateINCforBrightness C1A: I-AIVI is the Master for Dimming Strategy"));
				vSendDimBrightnessValToV850(m_u8OffsetFromDayorNightHMISlider, m_u8OffsetFromHMICockpitSlider);
			}
			break;
			default:
			break;
		}
	}
	//if its T4VS, then send only HMI day/Night Slider values and set this value as Row and column both(Diagonal elements selected)
	else if(u8RenaultCANType == CAN_CGF_T4VS)
	{
		ETG_TRACE_USR1(("vUpdateINCforBrightness T4VS: So only HMI Day/Night Sliders Active and set as both Row and Column value"));
		vSendDimBrightnessValToV850(m_u8OffsetFromDayorNightHMISlider, m_u8OffsetFromDayorNightHMISlider);
	}
	else
	{
		//Do Nothing
	}

}

/*******************************************************************************
*
* FUNCTION:    vReadDatapool()
*
* DESCRIPTION: Reads datapool values and updates the member variables for INC update to V850 on profile change trigger
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vReadDatapool()
{
	dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET dpDayLuminosity_HMISlider;
	dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET dpDayNightLuminosity_HMISlider;
	dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET dpDimCockPitSlider_Offset;

	m_u8OffsetFromHMICockpitSlider = dpDimCockPitSlider_Offset.tGetData();
	m_u8OffsetFromDayorNightHMISlider = dpDayNightLuminosity_HMISlider.tGetData();
	m_u8OffsetFromCAN = dpDayLuminosity_HMISlider.tGetData();
}
/*******************************************************************************
*
* FUNCTION:    vUpdateDayBrightnessMatrix()
*
* DESCRIPTION: updates Day Matrix by reading from Datapool
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vUpdateDayBrightnessMatrix()
{
	tU16 u16DayDisplayBrightnessData[441] = {0};
	dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set _aCalibDayBrightnessValues;
	ETG_TRACE_USR1((": updateDayBrightnessMatrix() Enter"));
	//Get Day Brightness Data and populate in 2D array
    _aCalibDayBrightnessValues.s32GetData(&u16DayDisplayBrightnessData[0], 441);

    tU16 array_index = 0;
    for(int row = 0; row<21; row++)
    {
    	ETG_TRACE_USR4(("dispvidctrl_tclClientDimming: _aDayDispBrightnessMatrix[row : %d]->>>>>>>>>>>>>>>>", row));
    	for(int col = 0; col<21; col++)
    	{
    		if( (u16DayDisplayBrightnessData[array_index] >= 5) && (u16DayDisplayBrightnessData[array_index] <= 1000) )
    		{
    			_aDayDispBrightnessMatrix[row][col] = u16DayDisplayBrightnessData[array_index];
    			ETG_TRACE_USR4(("dispvidctrl_tclClientDimming: \t[%d][%d]: (%d), ", row, col, _aDayDispBrightnessMatrix[row][col]));
    		}
    	    else
    	    {
    	    	_aDayDispBrightnessMatrix[row][col] = 5; //fill some default brightness as 0.5%
    	    	ETG_TRACE_USR4((": vUpdateDayBrightnessMatrix ; ERROR in some Datapool Matrix value so store as 200"));
    	    }
    		//go To Next Datapool Value
    		array_index ++;
    	}
    }

}
/*******************************************************************************
*
* FUNCTION:    vUpdateNightBrightnessMatrix()
*
* DESCRIPTION: updates Night Matrix by reading from Datapool
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vUpdateNightBrightnessMatrix()
{
	tU16 u16NightDisplayBrightnessData[441] = {0};
	dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set _aCalibNightBrightnessValues;
	ETG_TRACE_USR1((": updateNightBrightnessMatrix() Enter"));
	//Get Night Brightness data and Populate in 2D Array
	_aCalibNightBrightnessValues.s32GetData(&u16NightDisplayBrightnessData[0], 441);

	tU16 array_index = 0;
    for(int row = 0; row<21; row++)
    {
    	ETG_TRACE_USR4((": _aNightDispBrightnessMatrix[row : %d]->>>>>>>>>>>>>>>>", row));
    	for(int col = 0; col<21; col++)
    	{
    		if( (u16NightDisplayBrightnessData[array_index] >=5) && (u16NightDisplayBrightnessData[array_index]<=1000) )
    		{
    			_aNightDispBrightnessMatrix[row][col] = u16NightDisplayBrightnessData[array_index];
    			ETG_TRACE_USR4(("\t[%d][%d]: (%d), ", row, col, _aNightDispBrightnessMatrix[row][col]));
    		}
    		else
    		{
    			//_aNightDispBrightnessMatrix[row][col] = (100 + row *(col+20)); // Min value = 100 Max Value 961
    			_aNightDispBrightnessMatrix[row][col] = ((row+1) * (col+2));
    			_aNightDispBrightnessMatrix[row][col] = (_aNightDispBrightnessMatrix[row][col] < 1000)?_aNightDispBrightnessMatrix[row][col]: 1000;
    		}
    		//go To Next Datapool Value
        	array_index ++;
    	}
    }

}
/*******************************************************************************
*
* FUNCTION:    vUpdateOffsetKeyBrightnessLevel()
*
* DESCRIPTION: updates Key Illum Offset
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vUpdateOffsetKeyBrightnessLevel(tU8 u8KeyBrightnessLevel)
{
	sendKEY_SET_BRIGHTNESS_LEVEL(u8KeyBrightnessLevel);
}
/*******************************************************************************
*
* FUNCTION:    vStoreDayMatrixToDatapool()
*
* DESCRIPTION: stores day matrix to datapool
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vStoreDayMatrixToDatapool()
{
	ETG_TRACE_FATAL((":storeDayMatrixToDatapool() DAY Brightness Matrix->>>>>>>>>>>>>>>>START"));

	dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set _aCalibDayBrightnessValues;
	//Store Day Matrix Values into  Datapool for Day Brightness
    _aCalibDayBrightnessValues.s32SetData((tU16*)(&_aDayDispBrightnessMatrix[0][0]), 441);

    //Update Datapool Brightness Selection Criteria
	dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection BrigthnessSelCriteria;
	BrigthnessSelCriteria.s32SetData((tU8)(dispvidctrl_ConfigMgr::EBrightnessCalib_USER));

    //Print the array on TTFIS traces
    vPrintCalibrationMatrix(0);  //Day Matrix
	ETG_TRACE_FATAL((":storeDayMatrixToDatapool() DAY Brightness Matrix->>>>>>>>>>>>>>>>END"));
}
/*******************************************************************************
*
* FUNCTION:    vStoreNightMatrixToDatapool()
*
* DESCRIPTION: stores Night matrix to datapool
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vStoreNightMatrixToDatapool()
{
	ETG_TRACE_FATAL((": storeNightMatrixToDatapool() Night Brightness Matrix->>>>>>>>>>>>>>>>START"));

	dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set _aCalibNightBrightnessValues;
	//Store Day Matrix Values into  Datapool for Day Brightness
	_aCalibNightBrightnessValues.s32SetData((tU16*)(&_aNightDispBrightnessMatrix[0][0]), 441);

	//Update Datapool Brightness Selection Criteria
	dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection BrigthnessSelCriteria;
	BrigthnessSelCriteria.s32SetData((tU8)(dispvidctrl_ConfigMgr::EBrightnessCalib_USER));

    //Print the array on TTFIS traces
    vPrintCalibrationMatrix(1);  //Night Matrix
	ETG_TRACE_FATAL((": storeNightMatrixToDatapool() Night Brightness Matrix->>>>>>>>>>>>>>>>END"));
}
/*******************************************************************************
*
* FUNCTION:    vStoreKeyArrayToDatapool()
*
* DESCRIPTION: stores Key Illum Array to datapool
*
* PARAMETER:   none
*
* RETURNVALUE: tVoid
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vStoreKeyArrayToDatapool()
{
	ETG_TRACE_FATAL((":\tvStoreKeyArrayToDatapool->_aKeyIllumBrightnessArray:{%*d}", ETG_LIST_LEN(21), ETG_LIST_PTR_T16(_aKeyIllumBrightnessArray)));
	setKeyIllumMatrix(_aKeyIllumBrightnessArray,  sizeof(_aKeyIllumBrightnessArray));
}
#endif
//------------------------------------------------------------------------------
//	VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1 Specific Public Interfaces END
//------------------------------------------------------------------------------

//Private Functions:-
/*******************************************************************************
*
* FUNCTION:    vHandleTraceCmd_DIMMING_GETGENERALSTATUSINFO()
*
* DESCRIPTION: handle trace command DIMMING_GETGENERALSTATUSINFO
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDimming::vHandleTraceCmd_DIMMING_GETGENERALSTATUSINFO(tVoid) const
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::vHandleTraceCmd_DIMMING_GETGENERALSTATUSINFO():  "));

    ETG_TRACE_FATAL(("%26s: DIMMING_GetGeneralStatusInfo ",
          "DIM.APPL.DISP.CMD__.START" ));

    tChar _strIdentStart[30] = "DIM.APPL.DISP.SETT_.START";
    tChar _strIdentAttr[30]  = "DIM.APPL.DISP.SETT_.ATTR_";
    tChar _strIdentEnd[30]   = "DIM.APPL.DISP.SETT_.END__";
    ETG_TRACE_USR2(("%026s: ", _strIdentStart ));

    dp_tclDimmingDPINFO_DimmingModeConfig _oDimModeConfig;
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "     DIM_MODE_CONFIG",
 		   ETG_ENUM(DIM_DIMMODE, _oDimModeConfig.tGetData()) ));
    dp_tclDimmingDPINFO_DimmingModeCar _oDimModeCar;
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "        DIM_MODE_CAR",
 		   ETG_ENUM(DIM_DIMMODE, _oDimModeCar.tGetData()) ));
    dp_tclDimmingDPINFO_DimmingModeStatus _oDimModeStatus;
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "      DIM_MODE_SATUS",
 		   ETG_ENUM(DIM_DIMMODE, _oDimModeCar.tGetData()) ));
    dp_tclDimmingDPDISP_BrightnessLevelExtended_Day _oBrightnessLevelDay;
    ETG_TRACE_USR2(("%26s: %30s=%u [percent] ", _strIdentAttr, "   BRIGHTNESSLEV_DAY",
 		   _oBrightnessLevelDay.tGetData() ));
    dp_tclDimmingDPDISP_BrightnessLevelExtended_Night _oBrightnessLevelNight;
    ETG_TRACE_USR2(("%26s: %30s=%u [percent] ", _strIdentAttr, " BRIGHTNESSLEV_NIGHT",
 		   _oBrightnessLevelNight.tGetData() ));

    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "       DIM_MR_OUTPUT",
 		   ETG_ENUM(DISPVIDCTRL_Bool, _bMR_OUTPUT) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "            DIM_ILL+",
 		   ETG_ENUM(DISPVIDCTRL_Bool, _bIllActive) ));
    ETG_TRACE_USR2(("%26s: %30s=%u [percent] ", _strIdentAttr, "            DIM_ILL-",
 		   _u8IllBrightness ));

    dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "      EMULATION_MODE",
 		   ETG_ENUM(DIM_EMUMODE, _oDpEmulationMode.tGetData()) ));
    ETG_TRACE_USR2(("%26s: %30s=%u [percent] ", _strIdentAttr, "     BRIGHTNESS_DISP",
 		   _u8DispBrightness ));
    ETG_TRACE_USR2(("%26s: %30s=%u [percent] ", _strIdentAttr, "     BRIGHTNESS_KEYB",
 		   _u8KeybBrightness ));

    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "      BACKLIGHTSTATE",
    		ETG_CENUM(DISPVIDCTRL_Bool, bGetDimState()) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "  BACKLIGHTSTATE_SPM",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_SPM) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "  BACKLIGHTSTATE_CVM",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_CVM) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "  BACKLIGHTSTATE_HMI",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_HMI) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "  BACKLIGHTSTATE_HMI",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_HMI) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, " BACKLIGHTSTATE_BERR",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_BERR) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "   BACKLIGHTSTATE_HC",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_HC) ));
    ETG_TRACE_USR2(("%26s: %30s=%u ", _strIdentAttr, "  BACKLIGHTSTATE_RVC",
    		ETG_CENUM(tenBackLightState, m_enBacklightState_RVC) ));

    ETG_TRACE_USR2(("%026s: ", _strIdentEnd ));

    ETG_TRACE_FATAL(("%26s: finished without errors ",
          "DIM.APPL.DISP.CMD__.RES__" ));

}

/*******************************************************************************
*
* FUNCTION:    bHandleBacklightState()
*
* DESCRIPTION: handle new back light states
*
* PARAMETER:   tenBackLightState eStates
*
* RETURNVALUE: tBool {TRUE - back light is ON | else - back light is OFF}
*
*******************************************************************************/
tBool dispvidctrl_tclClientDimming::bHandleBacklightState(tenBackLightState eStates)
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::bHandleBacklightState(state 0x%08x): entered", eStates));
	if (eBackLight_None != (eStates & eBackLight_Spm_Mask))
		m_enBacklightState_SPM = (tenBackLightState)(eStates & eBackLight_Spm_Mask);
	if (eBackLight_None != (eStates & eBackLight_Cvm_Mask))
		m_enBacklightState_CVM = (tenBackLightState)(eStates & eBackLight_Cvm_Mask);
	if (eBackLight_None != (eStates & eBackLight_Hmi_Mask))
		m_enBacklightState_HMI = (tenBackLightState)(eStates & eBackLight_Hmi_Mask);
	if (eBackLight_None != (eStates & eBackLight_BERR_Mask))
		m_enBacklightState_BERR = (tenBackLightState)(eStates & eBackLight_BERR_Mask);
	if (eBackLight_None != (eStates & eBackLight_HC_Mask))
		m_enBacklightState_HC = (tenBackLightState)(eStates & eBackLight_HC_Mask);
   if (OSAL_NULL != _poSyncHandler) {
      m_enBacklightState_RVC = _poSyncHandler->enGetBacklightState_RVC(); // should be AUTO or ON
   }
	return bGetDimState();
}


//------------------------------------------------------------------------------
//	VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1 Specific Private Functions Start
//------------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
//Private Functions
tVoid dispvidctrl_tclClientDimming::getKeyIllumMatrix(tU16* KeyIllumArray, tU8 length = 21)
{
	 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
	 ETG_TRACE_FATAL((": dispvidctrl_tclClientDimming::getKeyIllumMatrix() -------------------------------Enter"));

	 if( _poDimConfigMgr != NULL && KeyIllumArray != NULL && length<=21 )
	 {
		_poDimConfigMgr->vGetKeyIllumMatrixValues(KeyIllumArray, length);
	 }
}

tVoid dispvidctrl_tclClientDimming::setKeyIllumMatrix(tU16* KeyIllumArray, tU8 length = 21)
{
	 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
	 ETG_TRACE_FATAL((": dispvidctrl_tclClientDimming::setKeyIllumMatrix() -------------------------------Enter"));

	 if(_poDimConfigMgr != NULL && KeyIllumArray != NULL && length<=21)
	 {
		_poDimConfigMgr->vSetKeyIllumMatrixValues(KeyIllumArray, length);
	 }
}

tVoid dispvidctrl_tclClientDimming::vSetDayMatrixCellValue(tS32 Row, tS32 Col, tU16 u16BrightnessVal)
{
	   tU8 NoOfRows = sizeof(_aDayDispBrightnessMatrix[0]);
	   tU8 NoOfColumns =  sizeof(_aDayDispBrightnessMatrix)/NoOfRows;

	   if( Row <= NoOfRows && Col <= NoOfColumns)
	   {
	      ETG_TRACE_USR4((":\tTTFIS: _aDayDispBrightnessMatrix[%d][%d] : %d",  Row, Col,  u16BrightnessVal));
	      _aDayDispBrightnessMatrix[Row][Col] = u16BrightnessVal;
	   }
	   else
	   {
		   ETG_TRACE_ERR((":\TTFIS _aDayDispBrightnessMatrix->(Row)%d/(Col)%d , out of Range Error", Row, Col));
	   }
}

tVoid dispvidctrl_tclClientDimming::vSetNightMatrixCellValue(tS32 Row, tS32 Col, tU16 u16BrightnessVal)
{
	   tU8 NoOfRows = sizeof(_aNightDispBrightnessMatrix[0]);
	   tU8 NoOfColumns =  sizeof(_aNightDispBrightnessMatrix)/NoOfRows;

	   if( Row <= NoOfRows && Col <= NoOfColumns)
	   {
		   ETG_TRACE_USR4((":\tTTFIS: _aNightDispBrightnessMatrix[%d][%d] : %d",  Row, Col,  u16BrightnessVal));
		   _aNightDispBrightnessMatrix[Row][Col] = u16BrightnessVal;
	   }
	   else
	   {
		   ETG_TRACE_ERR((":\TTFIS _aNightDispBrightnessMatrix->(Row)%d/(Col)%d , out of Range Error", Row, Col));
	   }
}

tVoid dispvidctrl_tclClientDimming :: vPrintCalibrationMatrix(tU8 u8DayNightMode)
{
	if(u8DayNightMode == 0)
	{
		ETG_TRACE_FATAL((": printCalibrationMatrix() DAY Brightness Matrix->>>>>>>>>>>>>>>>START"));

		//Print the array on TTFIS traces
		for(int row = 0; row<21; row++)
		{
			ETG_TRACE_FATAL((":\t_aDayDispBrightnessMatrix[%d]:{%*d}", row,
							ETG_LIST_LEN(21), ETG_LIST_PTR_T16(&_aDayDispBrightnessMatrix[row][0])));
		}

		ETG_TRACE_FATAL((": printCalibrationMatrix() DAY Brightness Matrix->>>>>>>>>>>>>>>>END"));
	}

	if(u8DayNightMode == 1)
	{
		ETG_TRACE_FATAL((": printCalibrationMatrix() Night Brightness Matrix->>>>>>>>>>>>>>>>START"));

		//Print the array on TTFIS traces
		for(int row = 0; row<21; row++)
		{
			ETG_TRACE_FATAL((":\t_aNightDispBrightnessMatrix[%d]:{%*d}", row,
							ETG_LIST_LEN(21), ETG_LIST_PTR_T16(&_aNightDispBrightnessMatrix[row][0])));
		}

		ETG_TRACE_FATAL((": printCalibrationMatrix() Night Brightness Matrix->>>>>>>>>>>>>>>>END"));
	}
}

tVoid dispvidctrl_tclClientDimming::setT4VSKeyIllumConfigParam(tU16 u16Day_Day1, tU16 u16Day_Night1, tU16 u16Night_Night1)
{
	 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
	 ETG_TRACE_FATAL((" :setT4VSKeyIllumConfigParam(Day_Day1=%d, Day_Night1=%d, Nigt_Night1=%d)",u16Day_Day1, u16Day_Night1, u16Night_Night1));

	 if( _poDimConfigMgr != NULL)
	 {
		_poDimConfigMgr->vSetT4VSKeyIllumDataPool(u16Day_Day1, u16Day_Night1, u16Night_Night1);
	 }
}

tVoid dispvidctrl_tclClientDimming::getT4VSKeyIllumConfigParam(tU16 (&KeyIllumArray)[3])
{
	 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
	 ETG_TRACE_FATAL((": dispvidctrl_tclClientDimming::getT4VSKeyIllumConfigParam() -------------------------------Enter"));

	 if( _poDimConfigMgr != NULL && KeyIllumArray != NULL )
	 {
		_poDimConfigMgr->vGetT4VSKeyIllumDataPool(KeyIllumArray);
	 }
}


tVoid dispvidctrl_tclClientDimming::vReset_Disp_SliderOffsetDatapoolElements(tU8 u8DefaultValue)
{
	   dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET HMI_DaySliderOffset;
	   dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET HMI_NightSliderOffset;
	   dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET HMI_CockpitSliderOffset;

	   u8DefaultValue = (u8DefaultValue < 20) ? u8DefaultValue : 10;

	   HMI_DaySliderOffset.s32SetData(u8DefaultValue);
	   HMI_NightSliderOffset.s32SetData(u8DefaultValue);
	   HMI_CockpitSliderOffset.s32SetData(u8DefaultValue);
}
#endif
//------------------------------------------------------------------------------
//	VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1 Specific Private Functions Start
//------------------------------------------------------------------------------

// NCG3D-13847: queue DIAG_SESSION message to send
tBool dispvidctrl_tclClientDimming::qsendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) {
    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::qsendDIAG_SESSION():  Session_Type: %u", ETG_ENUM(DISPVIDCTRL_DIMMING_SESSIONTYPE, Session_Type)));
    tDiagDimMsg _pushMsg;
    _pushMsg.enMsgID = ::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SESSION;
    _pushMsg.enResMsgID = ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_SESSION;
    _pushMsg.Data.DIAG_SESSION.Session_Type = Session_Type;
    // push new message
    return (DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_arrDiagDimMsg) > u16DiagDimMsgPush2Send(_pushMsg));
}
// NCG3D-13847: queue DIAG_SET_BRIGHTNESS_VAL message to send
tBool dispvidctrl_tclClientDimming::qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) {
    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::qsendDIAG_SET_BRIGHTNESS_VAL():  Device_Type: %u, Brightness: %d", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, Device_Type), Brightness));
    tDiagDimMsg _pushMsg;
    _pushMsg.enMsgID = ::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SET_BRIGHTNESS_VAL;
    _pushMsg.enResMsgID = ::dimming_inc_fi::eSCC_DIMMING_R_DIAG_SET_BRIGHTNESS_VAL;
    _pushMsg.Data.DIAG_SET_BRIGHTNESS_VAL.Device_Type = Device_Type;
    _pushMsg.Data.DIAG_SET_BRIGHTNESS_VAL.Brightness = Brightness;
    // push new message
    return (DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_arrDiagDimMsg) > u16DiagDimMsgPush2Send(_pushMsg));
}
// NCG3D-13847: queue DiagDimMsg is empty
tBool dispvidctrl_tclClientDimming::bDiagDimMsgEmpty(tVoid) const
{
	tBool _bRetValue = (m_u16DiagDimMsgReadIdx == m_u16DiagDimMsgWriteIdx);
    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::bDiagDimMsgEmpty():  ReadMsgIdx: %d, WriteMsgIdx: %d, empty: %d",
    		m_u16DiagDimMsgReadIdx, m_u16DiagDimMsgWriteIdx, _bRetValue ));
	return _bRetValue;
}
// NCG3D-13847: queue DiagDimMsg is full
tBool dispvidctrl_tclClientDimming::bDiagDimMsgFull(tVoid) const
{
	tBool _bRetValue = (m_u16DiagDimMsgReadIdx == u16DiagDimMsgGetNextIdx(m_u16DiagDimMsgWriteIdx));
    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::bDiagDimMsgFull():  ReadMsgIdx: %d, WriteMsgIdx: %d, full: %d",
    		m_u16DiagDimMsgReadIdx, m_u16DiagDimMsgWriteIdx, _bRetValue ));
	return _bRetValue;
}
// NCG3D-13847: calculate next message index in queue DiagDimMsg
tU16 dispvidctrl_tclClientDimming::u16DiagDimMsgGetNextIdx(tU16 u16Idx) const
{
	tU16 _u16ReturnIdx = u16Idx + 1;
	if (DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_arrDiagDimMsg) <= _u16ReturnIdx)
	{
		_u16ReturnIdx = 0;
	}
    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgGetNextIdx():  Idx: %d, NextIdx: %d", u16Idx, _u16ReturnIdx ));
	return _u16ReturnIdx;
}
tU16 dispvidctrl_tclClientDimming::u16DiagDimMsgPush2Send(const tDiagDimMsg& pushMsg)
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::u16DiagDimMsgPush2Send(): pushMsgID: %d, pushResMsgID: %d", pushMsg.enMsgID, pushMsg.enResMsgID ));
    tU16 _u16PushMsgIdx = OSAL_C_U16_MAX;
	tBool _bSemLock = bDiagDimMsgLock();
	tBool _bToSendMsg = (TRUE == bDiagDimMsgEmpty());
    if ((FALSE == bDiagDimMsgFull()))
    {
    	_u16PushMsgIdx = m_u16DiagDimMsgWriteIdx;
    	(tVoid*)memcpy((tVoid*)&m_arrDiagDimMsg[_u16PushMsgIdx], (const tVoid*)&pushMsg, sizeof(m_arrDiagDimMsg[_u16PushMsgIdx]));
		m_u16DiagDimMsgWriteIdx = u16DiagDimMsgGetNextIdx(_u16PushMsgIdx);
	    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgPush2Send(): pushMsgID: %d with pushResMsgID: %d pushed to index %d.",
	    		pushMsg.enMsgID, pushMsg.enResMsgID, _u16PushMsgIdx ));
		// send first pending message
	    if ((TRUE == _bToSendMsg))
	    {
	    	tDiagDimMsg _sendMsg;
	    	(tVoid*)memcpy((tVoid*)&_sendMsg, (tVoid*)&m_arrDiagDimMsg[m_u16DiagDimMsgReadIdx], sizeof(_sendMsg));
	    	if (TRUE == bDiagDimMsgSend(_sendMsg))
	    	{
				ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgPush2Send():  sendMsgID: %d with sendResMsgID: %d at index: %d send.",
						_sendMsg.enMsgID, _sendMsg.enResMsgID, m_u16DiagDimMsgReadIdx ));
	    	}
	    	else
	    	{
				ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::u16DiagDimMsgPush2Send():  sendMsgID: %d with sendResMsgID: %d at index: %d couldn't send!",
						_sendMsg.enMsgID, _sendMsg.enResMsgID, m_u16DiagDimMsgReadIdx ));
				m_u16DiagDimMsgReadIdx = u16DiagDimMsgGetNextIdx(m_u16DiagDimMsgReadIdx);
	    	}
	    }
    }
    else
    {
	    ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::u16DiagDimMsgPush2Send():  pushMsgID: %d with pushResMsgID: %d at index: %d couln't pushed, because ring buffer is full.",
	    		pushMsg.enMsgID, pushMsg.enResMsgID, _u16PushMsgIdx ));
    }
	if (TRUE == _bSemLock)
	{
		(tVoid)bDiagDimMsgUnlock();
	}
    return _u16PushMsgIdx;
}
tU16 dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send(const tDiagDimMsg& popMsg)
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  popResMsgID: %d  of MsgID: %d",
    		popMsg.enResMsgID, popMsg.enMsgID ));
    tU16 _u16PopResMsgIdx = OSAL_C_U16_MAX;
	tBool _bSemLock = bDiagDimMsgLock();
    if ((FALSE == bDiagDimMsgEmpty()))
    {
    	_u16PopResMsgIdx = m_u16DiagDimMsgReadIdx;
    	if (popMsg.enMsgID  == m_arrDiagDimMsg[_u16PopResMsgIdx].enMsgID)
    	{
        	if ((popMsg.enResMsgID == m_arrDiagDimMsg[_u16PopResMsgIdx].enResMsgID) || (::dimming_inc_fi::eSCC_DIMMING_R_REJECT == popMsg.enResMsgID))
        	{
        	    ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  popResMsgID: %d of MsgID: %d popped from index %d.",
        	    		popMsg.enResMsgID, popMsg.enMsgID, _u16PopResMsgIdx ));
        	    memset((tVoid*)&m_arrDiagDimMsg[_u16PopResMsgIdx], OSAL_NULL, sizeof(m_arrDiagDimMsg[_u16PopResMsgIdx]));
        		m_u16DiagDimMsgReadIdx = u16DiagDimMsgGetNextIdx(_u16PopResMsgIdx);
        		// send next pending message
        		tBool _bToSendMsg = (FALSE == bDiagDimMsgEmpty());
        		tDiagDimMsg _sendMsg;
        		for ( tU16 _u16Idx = 0; (DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_arrDiagDimMsg) > _u16Idx) && (TRUE == _bToSendMsg); ++_u16Idx)
        		{
        			(tVoid*)memcpy((tVoid*)&_sendMsg, (tVoid*)&m_arrDiagDimMsg[m_u16DiagDimMsgReadIdx], sizeof(_sendMsg));
        	    	if (TRUE == bDiagDimMsgSend(_sendMsg))
        	    	{
        				ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  sendMsgID: %d with sendResMsgID: %d at index: %d send.",
        						_sendMsg.enMsgID, _sendMsg.enResMsgID, m_u16DiagDimMsgReadIdx ));
            			_bToSendMsg = FALSE;
        	    	}
        	    	else
        	    	{
        				ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  sendMsgID: %d with sendResMsgID: %d at index: %d couldn't send!",
        						_sendMsg.enMsgID, _sendMsg.enResMsgID, m_u16DiagDimMsgReadIdx ));
        				m_u16DiagDimMsgReadIdx = u16DiagDimMsgGetNextIdx(m_u16DiagDimMsgReadIdx);
            			_bToSendMsg = (FALSE == bDiagDimMsgEmpty());
        	    	}
        		}
        	}
        	else
        	{
        	    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  popResMsgID: %d of MsgID: %d at index %d couldn't popped, because required ResMsgID %d of MsgID: %d isn't equal!",
        	    		popMsg.enResMsgID, popMsg.enMsgID, _u16PopResMsgIdx, m_arrDiagDimMsg[_u16PopResMsgIdx].enResMsgID, m_arrDiagDimMsg[_u16PopResMsgIdx].enMsgID ));
        	}
    	}
    	else
    	{
    	    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  popMsgID: %d with ResMsgID: %d at index %d couldn't popped, because required MsgID %d of ResMsgID: %d isn't equal!",
    	    		popMsg.enMsgID, popMsg.enResMsgID, _u16PopResMsgIdx, m_arrDiagDimMsg[_u16PopResMsgIdx].enMsgID, m_arrDiagDimMsg[_u16PopResMsgIdx].enResMsgID ));
    	}
    }
    else
    {
	    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::u16DiagDimMsgPop2Send():  popResMsgID: %d of MsgID: %d at index: %d couldn't popped, because ring buffer is empty!",
	    		popMsg.enMsgID, popMsg.enResMsgID, _u16PopResMsgIdx ));
    }
	if (TRUE == _bSemLock)
	{
		(tVoid)bDiagDimMsgUnlock();
	}
    return _u16PopResMsgIdx;
}
tBool dispvidctrl_tclClientDimming::bDiagDimMsgSend(const tDiagDimMsg& tosendMsg)
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::bDiagDimMsgSend():  tosendMsgID: %d with tosendResMsgID: %d", tosendMsg.enMsgID, tosendMsg.enResMsgID ));
    tBool _bSuccess = FALSE;
	tBool _bSend = FALSE;
	switch (tosendMsg.enMsgID)
	{
	case ::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SESSION:
		{
			_bSend = sendDIAG_SESSION(tosendMsg.Data.DIAG_SESSION.Session_Type);
		}
		break;
	case ::dimming_inc_fi::eSCC_DIMMING_C_DIAG_SET_BRIGHTNESS_VAL:
		{
			_bSend = sendDIAG_SET_BRIGHTNESS_VAL(tosendMsg.Data.DIAG_SET_BRIGHTNESS_VAL.Device_Type, tosendMsg.Data.DIAG_SET_BRIGHTNESS_VAL.Brightness);
		}
		break;
	default:
		{
			ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::bDiagDimMsgSend():  tosendMsgID: %d with tosendResMsgID: %d couldn't send, message id %d is invalid",
					tosendMsg.enMsgID, tosendMsg.enResMsgID, tosendMsg.enMsgID ));
		}
		break;
	}
	if (TRUE == _bSend)
	{
		ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::bDiagDimMsgSend():  tosendMsgID: %d with tosendResMsgID: %d send successful and waiting for response message with id %d.",
				tosendMsg.enMsgID, tosendMsg.enResMsgID, tosendMsg.enResMsgID ));
		_bSuccess = TRUE;
	}
	else
	{
		ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::bDiagDimMsgSend():  tosendMsgID: %d with tosendResMsgID: %d couldn't send!",
				tosendMsg.enMsgID, tosendMsg.enResMsgID ));
	}
    if(FALSE == _bSuccess)
    {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::bDiagDimMsgSend():  tosendMsgID: %d with tosendResMsgID: %d couldn't send, message id %d is invalid",
        		tosendMsg.enMsgID, tosendMsg.enResMsgID, tosendMsg.enMsgID ));
    }
    return _bSuccess;
}
tBool dispvidctrl_tclClientDimming::bDiagDimMsgLock(tVoid) const
{
	if ((OSAL_C_INVALID_HANDLE != m_hDiagDimMsgSemaphore) && (OSAL_OK == OSAL_s32SemaphoreWait( m_hDiagDimMsgSemaphore, OSAL_C_TIMEOUT_FOREVER )))
	{
	    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::bDiagDimMsgLock(): locked successful for thread %d", OSAL_ThreadWhoAmI() ));
		return TRUE;
	}
    ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::bDiagDimMsgLock(): lock failed for thread %d", OSAL_ThreadWhoAmI() ));
	return FALSE;
}
tVoid dispvidctrl_tclClientDimming::bDiagDimMsgUnlock(tVoid) const
{
    ETG_TRACE_USR3(("dispvidctrl_tclClientDimming::bDiagDimMsgUnlock(): unlocked for thread %d ", OSAL_ThreadWhoAmI() ));
	(tVoid) OSAL_s32SemaphorePost(m_hDiagDimMsgSemaphore);
}
// dispvidctrl_tclClientDimmingAddClassPart: user specific code end

tU8 dispvidctrl_tclClientDimming::u8ReturnDimmingStatus()
{
   return _u8DimMode_State;
}
//EOF
