#ifndef _I_DIMMINGINCPROXY_H_
#define _I_DIMMINGINCPROXY_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Idispvidctrl_ClientDimming.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     incProxyIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC Proxy interface file
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

//include base class
#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_ClientDimmingIncFiDef.h"

class I_dispvidctrl_tclClientDimming : public dispvidctrl_tclBaseIf
{
public:
   I_dispvidctrl_tclClientDimming(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
   virtual ~I_dispvidctrl_tclClientDimming() {;}

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientDimming"; };

   virtual tBool bIsServiceAvailable() = 0;
   virtual tBool sendCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus = ::dimming_inc_fi::eACTIVE, tU8 ApplicationVersion = 1) = 0;
   virtual tBool sendREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) = 0;
   virtual tBool sendDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest) = 0;
   virtual tBool sendDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady) = 0;
   virtual tBool sendDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel) = 0;
   virtual tBool sendDISP_SET_DIMMING(tU32 DispBrightness) = 0;
   virtual tBool sendKEY_SET_BRIGHTNESS_LEVEL(tU8 KeyBrightnessLevel) = 0;
   virtual tBool sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode) = 0;
   virtual tBool sendINFO_GET_DIMMINGMODE_STATE() = 0;
   virtual tBool sendDIAG_DISP_READ_BRIGHT_VAL() = 0;
   virtual tBool sendDIAG_KEYB_READ_BRIGHT_VAL() = 0;
   virtual tBool sendDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness) = 0;
   virtual tBool sendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) = 0;
   virtual tBool sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type) = 0;
   virtual tBool sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) = 0;
   virtual tBool sendGET_DIMMING_INFO_PRJ() = 0;
   virtual tBool sendSECOND_DISP_GET_HW_VERSION() = 0;
   virtual tBool sendSECOND_DISP_GET_SW_VERSION() = 0;
   virtual tBool sendSECOND_DISP_SET_DISPLAY_PARAMETERS(::dimming_inc_fi::ESecondDisplayParamID e16SecondDisplayParamID, tU16 u16ParameterValue) = 0;
   virtual tBool sendSECOND_DISP_GET_DIMMING_PARAMETERS() = 0;
   virtual tBool sendSEND_POWERMODE_TO_V850(tU8 u8PowerMode) = 0;
   virtual tBool sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT() = 0;

    // I_dispvidctrl_tclClientDimmingAddClassPart: user specific code start
   virtual tS32 s32ResetDimming(tVoid) = 0;
   virtual tBool bGetDimState(tVoid) const = 0;
 
   // NCG3D-13847: queue DIAG_SESSION
   virtual tBool qsendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) = 0;
   // NCG3D-13847: queue DIAG_SET_BRIGHTNESS_VAL
   virtual tBool qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) = 0;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
  virtual void vSendDimBrightnessValToV850(tU8 u8RowOffset, tU8 u8ColOffset) = 0;
  virtual void vHandleDarkModeReq(tBool bStatus) = 0;
   virtual tU8 sUnitType(tVoid) = 0;
   virtual tU8 u8DimmingStrategy(tVoid) = 0;
   virtual tU8  u8GetLastDimmingMode_INCValue(tVoid) = 0;
   virtual tU8 u8GetDayOrNightSliderVal(tU8& DimmMode_Mode_Out) = 0;
   virtual tU8 u8GetHMICockpitSliderVal()=0;

   virtual tVoid vLoadDataFromMeter(tU8 u8CANOffsetValue) = 0;
   virtual tVoid vLoadDataFromHMI(tU8 u8HMIOffsetValue) = 0;
   virtual tVoid vLoadDataFromHMICockpitSlider(tU8 u8CockpitOffsetValue) = 0;
   virtual tVoid vUpdateINCforBrightness() = 0;
   virtual tVoid vReadDatapool()= 0;	//Read datapool values and store in member variables to update V850 on profile change trigger

   virtual tVoid vSetDayMatrixCellValue(tS32 Row, tS32 Col, tU16 u16BrightnessVal)=0;
   virtual tVoid vSetNightMatrixCellValue(tS32 Row, tS32 Col, tU16 u16BrightnessVal)=0;
   virtual tVoid vPrintCalibrationMatrix(tU8 u8DayNightMode)=0;

   virtual tVoid vUpdateDayBrightnessMatrix() = 0;
   virtual tVoid vUpdateNightBrightnessMatrix() = 0;
   virtual void  vUpdateOffsetKeyBrightnessLevel(tU8 u8KeyBrightnessLevel) = 0;
   //Interfaces to trigger storing Brightness Matrix and Key into datapool
   virtual tVoid vStoreDayMatrixToDatapool() = 0;
   virtual tVoid vStoreNightMatrixToDatapool() = 0;
   virtual tVoid vStoreKeyArrayToDatapool() = 0;
#endif
    // I_dispvidctrl_tclClientDimmingAddClassPart: user specific code end
};


#endif //_I_DIMMINGINCPROXY_H_

