/*****************************************************************************
* FILE:         dispvidctrl_ClientVideomanagerIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientVideomanagerIf__IF__H_
#define __dispvidctrl_ClientVideomanagerIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientVideomanagerIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientVideomanagerCallbackIf.h"

// dispvidctrl_tclClientVideomanagerIf_Include: user specific code start
// dispvidctrl_tclClientVideomanagerIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclClientVideomanager;

class dispvidctrl_tclClientVideomanagerIf : public Idispvidctrl_tclClientVideomanagerIf, public dispvidctrl_tclClientVideomanagerCallbackIF
{
public:

   dispvidctrl_tclClientVideomanagerIf(tVoid); 
   dispvidctrl_tclClientVideomanagerIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientVideomanagerIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientVideomanagerIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendRVCASet() {
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRVCASet();
   }
   virtual tBool sendRVCDSet() {
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRVCDSet();
   }


   virtual tBool sendRVCAGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRVCAGet();
   }
   virtual tVoid getRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState& rRVCA_StateInfo){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getRVCAStatus(rRVCA_StateInfo);
   }


   virtual tBool sendRVCDGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRVCDGet();
   }
   virtual tVoid getRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState& rRVCD_StateInfo){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getRVCDStatus(rRVCD_StateInfo);
   }


   virtual tBool sendRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRequestVideoSourceStateMStart(tVideoSource, tRequestedState);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo);
   virtual tVoid onRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo);

   virtual tVoid onRequestVideoSourceStateMResult(tBool bSourceChangeGranted);

   // dispvidctrl_tclClientVideomanagerIfDeclarations: user specific code start
   // dispvidctrl_tclClientVideomanagerIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientVideomanager* _poClientRef;

// dispvidctrl_tclClientVideomanagerIfDeclarationsPart2: user specific code start
// dispvidctrl_tclClientVideomanagerIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientVideomanagerIf__IF__H_


