/*****************************************************************************
* FILE:         dispvidctrl_ClientVehicledataIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientVehicledataIf__IF__H_
#define __dispvidctrl_ClientVehicledataIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientVehicledataIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientVehicledataCallbackIf.h"

// dispvidctrl_tclClientVehicledataIf_Include: user specific code start
// dispvidctrl_tclClientVehicledataIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclControl_Video;
class Idispvidctrl_tclClientVehicledata;

class dispvidctrl_tclClientVehicledataIf : public Idispvidctrl_tclClientVehicledataIf, public dispvidctrl_tclClientVehicledataCallbackIF
{
public:

   dispvidctrl_tclClientVehicledataIf(tVoid); 
   dispvidctrl_tclClientVehicledataIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientVehicledataIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientVehicledataIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendReverseGearGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendReverseGearGet();
   }
   virtual tVoid getReverseGearStatus(tU8& rState){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getReverseGearStatus(rState);
   }


   virtual tBool sendCamTxtGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendCamTxtGet();
   }
   virtual tVoid getCamTxtStatus(tU64& rCamTxtValue){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getCamTxtStatus(rCamTxtValue);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onReverseGearStatus(tU8 State);
   virtual tVoid onCamTxtStatus(tU64 CamTxtValue);


   // dispvidctrl_tclClientVehicledataIfDeclarations: user specific code start
   // dispvidctrl_tclClientVehicledataIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientVehicledata* _poClientRef;
   dispvidctrl_tclControl_Video*     m_poControl_Video;
   bool reverse;

// dispvidctrl_tclClientVehicledataIfDeclarationsPart2: user specific code start
// dispvidctrl_tclClientVehicledataIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientVehicledataIf__IF__H_


