
/*****************************************************************************
* FILE:         dispvidctrl_ClientVehicledataIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// dispvidctrl_tclClientVehicledataIfIncludes: user specific code start
// dispvidctrl_tclClientVehicledataIfIncludes: user specific code end

#include "dispvidctrl_ClientVehicledataIf.h"
#include "Idispvidctrl_ClientVehicledata.h"
#include "dispvidctrl_tclControl_Video.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VEHICLEDATA
#include "trcGenProj/Header/dispvidctrl_ClientVehicledataIf.cpp.trc.h"
#endif

#define VISIBLE 1
#define GENERIC_VARIANT 3
#define EVOBUS_VARIANT 4

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVehicledataIf::
*             dispvidctrl_tclClientVehicledataIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVehicledataIf::dispvidctrl_tclClientVehicledataIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientVehicledataIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf() entered."));
    dispvidctrl_tclAppMain::vWriteStartupLog("dispvidctrl_tclClientVehicledataIf entered");
   _poClientRef = OSAL_NULL;
   m_poControl_Video = OSAL_NULL;
   reverse = false;
   // dispvidctrl_tclClientVehicledataIfConstructor: user specific code start
   // dispvidctrl_tclClientVehicledataIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVehicledataIf::
*             ~dispvidctrl_tclClientVehicledataIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVehicledataIf::~dispvidctrl_tclClientVehicledataIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientVehicledataIf() entered."));
   _poClientRef = OSAL_NULL;
   m_poControl_Video = OSAL_NULL;

   // dispvidctrl_tclClientVehicledataIfDestructor: user specific code start
   // dispvidctrl_tclClientVehicledataIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientVehicledataIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     VEHICLEDATA_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf::vGetReferences() entered."));
   dispvidctrl_tclAppMain::vWriteStartupLog("dispvidctrl_tclClientVehicledataIf vGetReferences entered");

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientVehicledata*>(_cpoMain->getHandler("Idispvidctrl_tclClientVehicledata"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

    m_poControl_Video = dynamic_cast<dispvidctrl_tclControl_Video*>(_cpoMain->getHandler("dispvidctrl_tclControl_Video"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Video);

   //set callback interface

   // dispvidctrl_tclClientVehicledataIfvGetReferences: user specific code start
   // dispvidctrl_tclClientVehicledataIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientVehicledataIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientVehicledataIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclClientVehicledataIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientVehicledataIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientVehicledataIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientVehicledataIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::vTraceInfo()
{
   // dispvidctrl_tclClientVehicledataIfvTraceInfo: user specific code start
   // dispvidctrl_tclClientVehicledataIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientVehicledataIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientVehicledataIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVehicledataIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVehicledataIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVehicledataIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientVehicledataIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientVehicledataIfvOnServiceUnavailable: user specific code end
}

tVoid dispvidctrl_tclClientVehicledataIf::onReverseGearStatus(tU8 State) {
   ETG_TRACE_USR4( ( "dispvidctrl_tclClientVehicledataIf::onReverseGearStatus(): CALLED %d",State ) );
   // reverse = false;
   // onReverseGearStatus: user specific code start
     if(State == 1)
     {
         dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCAN(true);
     }
     else
     {
         dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCAN(false);
     }

     if(true == dispvidctrl_tclAppMain::theServer()->getReverseConfiguredStatus())
     {
	   if((State == 1) && (FALSE == dispvidctrl_tclAppMain::theServer()->getSafeState()))
	   {
                   dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCAN(TRUE);
                   m_poControl_Video->setGraphicslayerVisibility(VISIBLE);
		   tChar strIfName[] = "";
			dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOnDebounced(strIfName);
			reverse = true;
       }
	   else if(State == 0)
       {
	        if(reverse == true)
		{
			dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCAN(FALSE);
                        if(FALSE ==   dispvidctrl_tclAppMain::theServer()->getReverseCamRequest())
                        {
			  tChar strIfName[] = "";
			  dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOff(strIfName);
			  reverse = false;
                        }
                }
       }
     }
   // onReverseGearStatus: user specific code end
}
tVoid dispvidctrl_tclClientVehicledataIf::onCamTxtStatus(tU64 CamTxtValue) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientVehicledataIf::onCamTxtStatus(): CALLED" ) );
   tU8 reverstatus = CamTxtValue & 0xFF;
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientVehicledataIf::Value of CamTxt first byte is %d",reverstatus ) );
   if(GENERIC_VARIANT !=  dispvidctrl_tclAppMain::theServer()->getVariantInfo())
   {
   if(reverstatus == 35)
   {
	 dispvidctrl_tclAppMain::theServer()->SetCANRvcConfiguration(true);
	 dispvidctrl_tclAppMain::theServer()->checkAndSetReverseConfiguration();
	 if(true == dispvidctrl_tclAppMain::theServer()->getReverseGearStatusfromCAN())
	 {
        	 dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCAN(TRUE);
                   m_poControl_Video->setGraphicslayerVisibility(VISIBLE);
                   tChar strIfName[] = "";
                        dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOnDebounced(strIfName);
                        reverse = true;

	 }
   }
   else
   {
	 dispvidctrl_tclAppMain::theServer()->SetCANRvcConfiguration(false);
	 dispvidctrl_tclAppMain::theServer()->checkAndSetReverseConfiguration();
	 if(true == dispvidctrl_tclAppMain::theServer()->getReverseGearStatusfromCAN())
	 {
             dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCAN(FALSE);
             dispvidctrl_tclAppMain::theServer()->SetReverseCamRequest(FALSE);
                 tChar strIfName[] = "";
                 dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOff(strIfName);
                 reverse = false;

	 }

   }
   }
   // onCamTxtStatus: user specific code start
   // onCamTxtStatus: user specific code end
}




// dispvidctrl_tclClientVehicledataIfdispvidctrl_ClientVehicledataIf: user specific code start
// dispvidctrl_tclClientVehicledataIfdispvidctrl_ClientVehicledataIf: user specific code end

//EOF
