/*****************************************************************************
* FILE:         dispvidctrl_ClientSpmIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientSpmIf__IF__H_
#define __dispvidctrl_ClientSpmIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientSpmIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientSpmCallbackIf.h"

// dispvidctrl_tclClientSpmIf_Include: user specific code start
//enumeration of possible CVM events
enum tenCvmEvent
{
   EN_CVM__CRITICAL_LOW_VOLTAGE_START    = 0,
   EN_CVM__CRITICAL_LOW_VOLTAGE_END      = 1,
   EN_CVM__LOW_VOLTAGE_START             = 2,
   EN_CVM__LOW_VOLTAGE_END               = 3,
   EN_CVM__HIGH_VOLTAGE_START            = 4,
   EN_CVM__HIGH_VOLTAGE_END              = 5,
   EN_CVM__CRITICAL_HIGH_VOLTAGE_START   = 6,
   EN_CVM__CRITICAL_HIGH_VOLTAGE_END     = 7,
   EN_CVM__NO_EVENT                      = 15
};

//class dispvidctrl_tclControl;
class dispvidctrl_tclControl_Mvc;
class I_dispvidctrl_tclClientVcan;
class I_dispvidctrl_tclClientDimming;
// dispvidctrl_tclClientSpmIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclClientSpm;

class dispvidctrl_tclClientSpmIf : public Idispvidctrl_tclClientSpmIf, public dispvidctrl_tclClientSpmCallbackIF
{
public:

   dispvidctrl_tclClientSpmIf(tVoid); 
   dispvidctrl_tclClientSpmIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientSpmIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientSpmIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> >& rtOnOffTriggerList){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getActiveOnOffTriggerStatus(rtOnOffTriggerList);
   }


   virtual tBool sendActiveOnOffTriggerGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendActiveOnOffTriggerGet();
   }
   virtual tVoid getSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE& rSysPwrMode){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSysPwrModeStatus(rSysPwrMode);
   }


   virtual tBool sendSysPwrModeGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSysPwrModeGet();
   }
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getCvmEventStatus(rCvmEvent);
   }


   virtual tBool sendCvmEventGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendCvmEventGet();
   }
   virtual tVoid getHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE& rHmiState){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getHmiStateStatus(rHmiState);
   }


   virtual tBool sendHmiStateGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendHmiStateGet();
   }
   virtual tVoid getDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE& rDimState){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getDimmingStateStatus(rDimState);
   }


   virtual tBool sendDimmingStateGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendDimmingStateGet();
   }

   virtual tBool sendOnOffTriggerMStart(spm_fi_tcl_SPM_e32_SubStateType eSwitchOnTrigger, tBool bState){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendOnOffTriggerMStart(eSwitchOnTrigger, bState);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList);
   virtual tVoid onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);
   virtual tVoid onHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE HmiState);
   virtual tVoid onDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE DimState);

   virtual tVoid onOnOffTriggerMResult();

   // dispvidctrl_tclClientSpmIfDeclarations: user specific code start
public:
   virtual tBool bMapCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent, tU32& tU32ControlEvent, tU32& tU32VoltageLevel);
   virtual tBool bIsCriticalVoltageActive() const;
private:
   // dispvidctrl_tclClientSpmIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientSpm* _poClientRef;

// dispvidctrl_tclClientSpmIfDeclarationsPart2: user specific code start
   dispvidctrl_tclControl*        m_poControl;
   dispvidctrl_tclControl_Avm*    m_poControl_Avm;
   dispvidctrl_tclControl_Rvc*    m_poControl_Rvc;
   dispvidctrl_tclControl_Mvc*    m_poControl_Mvc;
   dispvidctrl_tclControl_Video*  m_poControl_Video;
   I_dispvidctrl_tclClientVcan*   m_poClientVcan;
   I_dispvidctrl_tclClientDimming* m_poClientDimming;		//Alok
   spm_fi_tcl_SPM_e32_SYSPWRMODE::tenType m_enSysPwrMode;
   spm_fi_tcl_SPM_e32_CVM_EVENT::tenType m_enCvmEvent;
   tBool m_bIgnitionActive;
   tBool m_bAccActive;
   tBool m_bDarkModeStatus;
// dispvidctrl_tclClientSpmIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientSpmIf__IF__H_


