/*****************************************************************************
* FILE:         dispvidctrl_ClientProfileIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientProfileIf__IF__H_
#define __dispvidctrl_ClientProfileIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientProfileIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientProfileCallbackIf.h"

// dispvidctrl_tclClientProfileIf_Include: user specific code start
// dispvidctrl_tclClientProfileIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclClientProfile;

class dispvidctrl_tclClientProfileIf : public Idispvidctrl_tclClientProfileIf, public dispvidctrl_tclClientProfileCallbackIF
{
public:

   dispvidctrl_tclClientProfileIf(tVoid); 
   dispvidctrl_tclClientProfileIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientProfileIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientProfileIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendactiveProfileGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendactiveProfileGet();
   }
   virtual tVoid getactiveProfileStatus(tU8& rID){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getactiveProfileStatus(rID);
   }


   virtual tBool sendstatusGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendstatusGet();
   }
   virtual tVoid getstatusStatus(profile_fi_tcl_e8_profileStatus& rstatus){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getstatusStatus(rstatus);
   }

   virtual tVoid getcopyProfileStatus(tU8& rsourceID, tU8& rdestinationID){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getcopyProfileStatus(rsourceID, rdestinationID);
   }

   virtual tVoid getdeleteProfileStatus(tU8& rProfileID){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getdeleteProfileStatus(rProfileID);
   }

   virtual tVoid getdataChangedStatus(profile_fi_tcl_e8_changeProfile& rreason){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getdataChangedStatus(rreason);
   }

   virtual tVoid getcreateProfileStatus(tU8& rID){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getcreateProfileStatus(rID);
   }


   virtual tBool sendonDataChangedMStart(profile_fi_tcl_e8_DataChangedResponse result){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendonDataChangedMStart(result);
   }
   virtual tBool sendonProfileCreatedMStart(profile_fi_tcl_e8_ClientResponse result){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendonProfileCreatedMStart(result);
   }
   virtual tBool sendonProfileCopiedMStart(profile_fi_tcl_e8_ClientResponse result){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendonProfileCopiedMStart(result);
   }
   virtual tBool sendonProfileDeletedMStart(profile_fi_tcl_e8_ClientResponse result){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendonProfileDeletedMStart(result);
   }
   virtual tBool sendRegisterClientMStart(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRegisterClientMStart();
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onactiveProfileStatus(tU8 ID);
   virtual tVoid onstatusStatus(profile_fi_tcl_e8_profileStatus status);
   virtual tVoid oncopyProfileStatus(tU8 sourceID, tU8 destinationID);
   virtual tVoid ondeleteProfileStatus(tU8 ProfileID);
   virtual tVoid ondataChangedStatus(profile_fi_tcl_e8_changeProfile reason);
   virtual tVoid oncreateProfileStatus(tU8 ID);

   virtual tVoid onRegisterClientMResult(tBool bReloadData);

   // dispvidctrl_tclClientProfileIfDeclarations: user specific code start
   // dispvidctrl_tclClientProfileIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientProfile* _poClientRef;

// dispvidctrl_tclClientProfileIfDeclarationsPart2: user specific code start
// dispvidctrl_tclClientProfileIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientProfileIf__IF__H_


