
/*****************************************************************************
* FILE:         dispvidctrl_ClientProfileIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientProfileIfIncludes: user specific code start
#include "I_dispvidctrl_ProfileManager.h"
// dispvidctrl_tclClientProfileIfIncludes: user specific code end

#include "dispvidctrl_ClientProfileIf.h"
#include "Idispvidctrl_ClientProfile.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_PROFILE
#include "trcGenProj/Header/dispvidctrl_ClientProfileIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientProfileIf::
*             dispvidctrl_tclClientProfileIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientProfileIf::dispvidctrl_tclClientProfileIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientProfileIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientProfileIfConstructor: user specific code start
   // dispvidctrl_tclClientProfileIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientProfileIf::
*             ~dispvidctrl_tclClientProfileIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientProfileIf::~dispvidctrl_tclClientProfileIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientProfileIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientProfileIfDestructor: user specific code start
   // dispvidctrl_tclClientProfileIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientProfileIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     PROFILE_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientProfile*>(_cpoMain->getHandler("Idispvidctrl_tclClientProfile"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclClientProfileIfvGetReferences: user specific code start
   // dispvidctrl_tclClientProfileIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientProfileIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientProfileIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclClientProfileIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientProfileIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientProfileIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientProfileIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::vTraceInfo()
{
   // dispvidctrl_tclClientProfileIfvTraceInfo: user specific code start
   // dispvidctrl_tclClientProfileIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientProfileIfvOnServiceAvailable: user specific code start
   if(FALSE == sendRegisterClientMStart()) //To notify profile manager to register Dimming CCA ID for Profile change Updates
   {
	   ETG_TRACE_FATAL(("dispvidctrl_tclClientProfileIf::sendRegisterClientMStart() -> Registration FAILED."));
   }
   else
   {
	   ETG_TRACE_FATAL(("dispvidctrl_tclClientProfileIf::sendRegisterClientMStart() -> Registration SUCCESSFUL."));
   }
   // dispvidctrl_tclClientProfileIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfileIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientProfileIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfileIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientProfileIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientProfileIfvOnServiceUnavailable: user specific code end
}

tVoid dispvidctrl_tclClientProfileIf::onactiveProfileStatus(tU8 ID) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::onactiveProfileStatus(): CALLED" ) );

   // onactiveProfileStatus: user specific code start
   // onactiveProfileStatus: user specific code end
}
tVoid dispvidctrl_tclClientProfileIf::onstatusStatus(profile_fi_tcl_e8_profileStatus status) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::onstatusStatus(): CALLED" ) );

   // onstatusStatus: user specific code start
   // onstatusStatus: user specific code end
}
tVoid dispvidctrl_tclClientProfileIf::oncopyProfileStatus(tU8 sourceID, tU8 destinationID) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::oncopyProfileStatus(): CALLED" ) );

   // oncopyProfileStatus: user specific code start
   profile_fi_tcl_e8_ClientResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;
   sendonProfileCopiedMStart(ResponseBack);
   // oncopyProfileStatus: user specific code end
}
tVoid dispvidctrl_tclClientProfileIf::ondeleteProfileStatus(tU8 ProfileID) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::ondeleteProfileStatus(): CALLED" ) );

   // ondeleteProfileStatus: user specific code start
   profile_fi_tcl_e8_ClientResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;
   sendonProfileDeletedMStart(ResponseBack);
   // ondeleteProfileStatus: user specific code end
}
tVoid dispvidctrl_tclClientProfileIf::ondataChangedStatus(profile_fi_tcl_e8_changeProfile reason) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::ondataChangedStatus(): CALLED" ) );

   // ondataChangedStatus: user specific code start
   I_dispvidctrl_tclProfileManagerIf* pProfileManagerIf = dynamic_cast<I_dispvidctrl_tclProfileManagerIf*>(_cpoMain->getHandler("dispvidctrl_tclProfileManager"));

   //Message Or Response Attribute
   profile_fi_tcl_e8_DataChangedResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_FAILED;

   switch(reason.enType)
   {
		case profile_fi_tcl_e8_changeProfile::FI_EN_PREPARE: //Changed to PREPARE
		{
			//Save Current User data into Datapool and get ready to switch to another set of Datapool for New User
			if(pProfileManagerIf != NULL) {
				pProfileManagerIf->vHandlePrepareTrigger();
			}

			ResponseBack.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_PREPARED;
		}
		break;

		case profile_fi_tcl_e8_changeProfile::FI_EN_PROFILECHANGED:
		{
			//Perform Read operation of Datapool set for New User and Update HMi clients.
			if(pProfileManagerIf != NULL) {
				pProfileManagerIf->vHandleProfileChangeTrigger();
			}

			ResponseBack.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_PROFILE_CHANGED;
		}
		break;

		case profile_fi_tcl_e8_changeProfile::FI_EN_DOWNLOAD:
		break;

		case profile_fi_tcl_e8_changeProfile::FI_EN_PROFILERESET:
		{
			//Reset Set of Datapool with XML default values again
			if(pProfileManagerIf != NULL) {
				pProfileManagerIf->vHandleResetProfileTrigger();
			}
		}
		break;

		default:
		break;
   }

   //Send Data Changed Response Back to Profile Manager based on Trigger
   sendonDataChangedMStart(ResponseBack);

   // ondataChangedStatus: user specific code end
}
tVoid dispvidctrl_tclClientProfileIf::oncreateProfileStatus(tU8 ID) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::oncreateProfileStatus(): CALLED" ) );

   // oncreateProfileStatus: user specific code start
   ETG_TRACE_USR1( ( ": oncreateProfileStatus() -> Profile ID = %d", ID) );
   profile_fi_tcl_e8_ClientResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;
   sendonProfileCreatedMStart(ResponseBack);
   // oncreateProfileStatus: user specific code end
}

tVoid dispvidctrl_tclClientProfileIf::onRegisterClientMResult(tBool bReloadData) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientProfileIf::onRegisterClientMResult(): CALLED" ) );

   // onRegisterClientMResult: user specific code start
   // onRegisterClientMResult: user specific code end
}



// dispvidctrl_tclClientProfileIfdispvidctrl_ClientProfileIf: user specific code start
// dispvidctrl_tclClientProfileIfdispvidctrl_ClientProfileIf: user specific code end

//EOF
