/*****************************************************************************
* FILE:         dispvidctrl_ClientDiaglogIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientDiaglogIf__IF__H_
#define __dispvidctrl_ClientDiaglogIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientDiaglogIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientDiaglogCallbackIf.h"

// dispvidctrl_tclClientDiaglogIf_Include: user specific code start
typedef struct
{
   tU8 u8Index;
   tU16 u16ITC;
}StIdcIndexMappingTable;
// dispvidctrl_tclClientDiaglogIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclClientDiaglog;

class dispvidctrl_tclClientDiaglogIf : public Idispvidctrl_tclClientDiaglogIf, public dispvidctrl_tclClientDiaglogCallbackIF
{
public:

   dispvidctrl_tclClientDiaglogIf(tVoid); 
   dispvidctrl_tclClientDiaglogIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientDiaglogIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientDiaglogIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure& rNextTestResultStruct, tBool& rStatus){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSendNextTestResultStatus(rNextTestResultStruct, rStatus);
   }


   virtual tBool sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSaveTestResultMStart(TestResultList);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status);

   virtual tVoid onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status);

   // dispvidctrl_tclClientDiaglogIfDeclarations: user specific code start
   // dispvidctrl_tclClientDiaglogIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientDiaglog* _poClientRef;

// dispvidctrl_tclClientDiaglogIfDeclarationsPart2: user specific code start
                        tBool  m_bDiagLogServiceAvailable;
                          tU8  m_au8ItcState[enITC_ID_MAX];

   tVoid _vSetPendingItcTestResult(tVoid);
public:
   virtual tVoid vSetITC(tenITC_ID enITC_ID, midw_fi_tcl_e8_TestResult::tenType enTestResult);
// dispvidctrl_tclClientDiaglogIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientDiaglogIf__IF__H_


