/*****************************************************************************
* FILE:         dispvidctrl_ClientVcan.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     CsmClient.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/
#ifndef _VCANCAN_CLIENT_H_
#define _VCANCAN_CLIENT_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//include base class
#include "Idispvidctrl_ClientVcan.h"

#include "I_dispvidctrl_ClientVcanCanAdaptor.h"

// dispvidctrl_tclClientVcan::ClassIncludes: user specific code start
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

typedef enum {
    TIMEOUT_FALSE = 0,
    TIMEOUT_TRUE,
    TIMEOUT_CONFIRMED
}TenCanFrameTimeoutState;

class dispvidctrl_tclControl_Avm;
class dispvidctrl_tclControl_Mvc;
class Idispvidctrl_tclClientDiaglogIf;
class I_dispvidctrl_tclClientDimming;
class dispvidctrl_tclControl_Hmi;
/*******************************************************************************
   Class
*******************************************************************************/
// dispvidctrl_tclClientVcan::ClassIncludes: user specific code end


class dispvidctrl_tclClientVcan : 
    public I_dispvidctrl_tclClientVcan,
    public CsmCallbackIF
{
private:
    I_dispvidctrl_tclClientVcanCanAdaptor* _pCsmBase;
public:
   dispvidctrl_tclClientVcan(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientVcan();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientVcan"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

    virtual tVoid vGetUPA_RX_Initializing();
    virtual tVoid vGetUPA_View_Change_Request();
    virtual tVoid vGetUPA_BEEP_Sound_Request();
    virtual tVoid vGetUPA_AOD_Beep1_Request();
    virtual tVoid vGetUPA_Setting_ITS();
    virtual tVoid vGetUPA_MOD_Status();
    virtual tVoid vGetUPA_BEEP_Sound_Type();
    virtual tVoid vGetSteering_Angle();
    virtual tVoid vGetCalibration_Flag();
    virtual tVoid vGetSteering_Sensor_Fail_Flag();
    virtual tVoid vGetSwaSensorInternalStatus();
    virtual tVoid vGetFRONT_STEER_PINION_ANGLE();
    virtual tVoid vGetACTIVE_STEER_FAIL();
    virtual tVoid vGetVehicleSpeed();
    virtual tVoid vGetIPA_Mode_Change_Request();
    virtual tVoid vGetIPA_Switch_Display_Request();
    virtual tVoid vGetIPA_Switch_mask_Request();
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_01();
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_02();
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_03();
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_04();
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_05();
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_06();
    virtual tVoid vGetIPA_mode_selection();
    virtual tVoid vGetIPA_Message_Display_Request();
    virtual tVoid vGetIPA_Sound_Output_Request();
    virtual tVoid vGetIPA_Voice_Output_Request();
    virtual tVoid vGetIPA_region_selection();
    virtual tVoid vGetIPA_Camera_Indicator_Request();
    virtual tVoid vGetIPA_Mulfunction();
    virtual tVoid vGetRearGearEngaged();
    virtual tVoid vGetMVC_ViewModeStatus();
    virtual tVoid vGetMVC_WarningDisplayRequest();
    virtual tVoid vGetTailGateStatus();
    virtual tVoid vGetAVM_ChangeViewStatus();
    virtual tVoid vGetAVM_ClosingAuthorization();
    virtual tVoid vGetMOD_ActivationState();
    virtual tVoid vGetFAP_ModeChangeRequest();
    virtual tVoid vGetCamerasetting_availability();
    virtual tVoid vGetFAP_Setting01();
    virtual tVoid vGetFAP_Setting02();
    virtual tVoid vGetFAP_Setting03();
    virtual tVoid vGetFAP_Setting04();
    virtual tVoid vGetFAP_Setting05();
    virtual tVoid vGetFAP_Setting06();
    virtual tVoid vGetFAP_Setting07();
    virtual tVoid vGetFAP_Setting08();
    virtual tVoid vGetFAP_Setting09();
    virtual tVoid vGetFAP_Setting10();
    virtual tVoid vGetAVM_Setting_1();
    virtual tVoid vGetAVM_Setting_2();
    virtual tVoid vGetAVM_Setting_3();
    virtual tVoid vGetAVM_Setting_4();
    virtual tVoid vGetAVM_Setting_5();
    virtual tVoid vGetAVM_Setting_6();
    virtual tVoid vGetAVM_Setting_7();
    virtual tVoid vGetAVM_Setting_8();
    virtual tVoid vGetAVM_Setting_9();
    virtual tVoid vGetFAP_PurposeSwitchAvailability();
    virtual tVoid vGetFAP_ChangeViewRequest();
    virtual tVoid vGetFAP_SoundDirection();
    virtual tVoid vGetFAP_SoundLevelControl();
    virtual tVoid vGetFAP_SoundPatternRequest();
    virtual tVoid vGetFAP_VoicePatternRequest();
    virtual tVoid vGetDayRheostatedLightMaxPercent();
    virtual tVoid vGetNightRheostatedLightMaxPercent();
    virtual tVoid vGetDimmingState();
    virtual tVoid vGetSTATUS_DYNAMIC_REAR();

    virtual tVoid vSendUPA_TX_Initializing(TUPA_TX_Initializing tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUPA_TX_Initializing(tTxSignal);
        }
    }
    virtual tVoid vSendUPA_Camera_Switch_Press(TUPA_Camera_Switch_Press tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUPA_Camera_Switch_Press(tTxSignal);
        }
    }
    virtual tVoid vSendUPA_Camera_Switch_Keep(TUPA_Camera_Switch_Keep tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUPA_Camera_Switch_Keep(tTxSignal);
        }
    }
    virtual tVoid vSendUPA_Camera_OFF_Request(TUPA_Camera_OFF_Request tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUPA_Camera_OFF_Request(tTxSignal);
        }
    }
    virtual tVoid vSendUPA_Setting_Language_Request(TUPA_Setting_Language_Request tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUPA_Setting_Language_Request(tTxSignal);
        }
    }
    virtual tVoid vSendUPA_MOD_Switch_Press(TUPA_MOD_Switch_Press tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUPA_MOD_Switch_Press(tTxSignal);
        }
    }
    virtual tVoid vSendIPA_Activation_flug(TIPA_Activation_flug tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendIPA_Activation_flug(tTxSignal);
        }
    }
    virtual tVoid vSendIPA_SW_Long_Press(TIPA_SW_Long_Press tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendIPA_SW_Long_Press(tTxSignal);
        }
    }
    virtual tVoid vSendIPA_SW_Operation_Status(TIPA_SW_Operation_Status tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendIPA_SW_Operation_Status(tTxSignal);
        }
    }
    virtual tVoid vSendMVC_ViewModeRequest(TMVC_ViewModeRequest tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMVC_ViewModeRequest(tTxSignal);
        }
    }
    virtual tVoid vSendFAP_SwitchOperationStatus(TFAP_SwitchOperationStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendFAP_SwitchOperationStatus(tTxSignal);
        }
    }
    virtual tVoid vSendFAP_Screen_Activation_flag(TFAP_Screen_Activation_flag tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendFAP_Screen_Activation_flag(tTxSignal);
        }
    }
    virtual tVoid vSendFAP_ScreenPressCoordinateX(TFAP_ScreenPressCoordinateX tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendFAP_ScreenPressCoordinateX(tTxSignal);
        }
    }
    virtual tVoid vSendFAP_ScreenPressCoordinateY(TFAP_ScreenPressCoordinateY tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendFAP_ScreenPressCoordinateY(tTxSignal);
        }
    }
    virtual tVoid vSendFAP_ScreenPressDetected(TFAP_ScreenPressDetected tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendFAP_ScreenPressDetected(tTxSignal);
        }
    }
    virtual tVoid vSendHorizontalDilutionOfPrecision(THorizontalDilutionOfPrecision tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendHorizontalDilutionOfPrecision(tTxSignal);
        }
    }
    virtual tVoid vSendVerticalDilutionOfPrecision(TVerticalDilutionOfPrecision tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendVerticalDilutionOfPrecision(tTxSignal);
        }
    }
    virtual tVoid vSendSatNUM(TSatNUM tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendSatNUM(tTxSignal);
        }
    }
    virtual tVoid vSendGroundSpeed(TGroundSpeed tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendGroundSpeed(tTxSignal);
        }
    }
    virtual tVoid vSendSatelliteGPSCount(TSatelliteGPSCount tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendSatelliteGPSCount(tTxSignal);
        }
    }
    virtual tVoid vSendFAP_ActivationRequest(TFAP_ActivationRequest tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendFAP_ActivationRequest(tTxSignal);
        }
    }
    virtual tVoid vSendSwitchRequest_AVM(TSwitchRequest_AVM tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendSwitchRequest_AVM(tTxSignal);
        }
    }
    virtual tVoid vSendChangeViewRequest_AVM(TChangeViewRequest_AVM tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendChangeViewRequest_AVM(tTxSignal);
        }
    }
    virtual tVoid vSendMOD_ActivationRequest2(TMOD_ActivationRequest2 tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMOD_ActivationRequest2(tTxSignal);
        }
    }
    virtual tVoid vSendDimmingReq(TDimmingReq tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDimmingReq(tTxSignal);
        }
    }
    virtual tVoid vSendDriver_Assistance_SW_flag(TDriver_Assistance_SW_flag tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDriver_Assistance_SW_flag(tTxSignal);
        }
    }

private:
   virtual void onUPA_RX_InitializingStatus(TUPA_RX_Initializing tUPA_RX_Initializing);
   virtual void onUPA_View_Change_RequestStatus(TUPA_View_Change_Request tUPA_View_Change_Request);
   virtual void onUPA_BEEP_Sound_RequestStatus(TUPA_BEEP_Sound_Request tUPA_BEEP_Sound_Request);
   virtual void onUPA_AOD_Beep1_RequestStatus(TUPA_AOD_Beep1_Request tUPA_AOD_Beep1_Request);
   virtual void onUPA_Setting_ITSStatus(TUPA_Setting_ITS tUPA_Setting_ITS);
   virtual void onUPA_MOD_StatusStatus(TUPA_MOD_Status tUPA_MOD_Status);
   virtual void onUPA_BEEP_Sound_TypeStatus(TUPA_BEEP_Sound_Type tUPA_BEEP_Sound_Type);
   virtual void onSteering_AngleStatus(TSteering_Angle tSteering_Angle);
   virtual void onCalibration_FlagStatus(TCalibration_Flag tCalibration_Flag);
   virtual void onSteering_Sensor_Fail_FlagStatus(TSteering_Sensor_Fail_Flag tSteering_Sensor_Fail_Flag);
   virtual void onSwaSensorInternalStatusStatus(TSwaSensorInternalStatus tSwaSensorInternalStatus);
   virtual void onFRONT_STEER_PINION_ANGLEStatus(TFRONT_STEER_PINION_ANGLE tFRONT_STEER_PINION_ANGLE);
   virtual void onACTIVE_STEER_FAILStatus(TACTIVE_STEER_FAIL tACTIVE_STEER_FAIL);
   virtual void onVehicleSpeedStatus(TVehicleSpeed tVehicleSpeed);
   virtual void onIPA_Mode_Change_RequestStatus(TIPA_Mode_Change_Request tIPA_Mode_Change_Request);
   virtual void onIPA_Switch_Display_RequestStatus(TIPA_Switch_Display_Request tIPA_Switch_Display_Request);
   virtual void onIPA_Switch_mask_RequestStatus(TIPA_Switch_mask_Request tIPA_Switch_mask_Request);
   virtual void onIPA_Switch_Gray_Out_Request_01Status(TIPA_Switch_Gray_Out_Request_01 tIPA_Switch_Gray_Out_Request_01);
   virtual void onIPA_Switch_Gray_Out_Request_02Status(TIPA_Switch_Gray_Out_Request_02 tIPA_Switch_Gray_Out_Request_02);
   virtual void onIPA_Switch_Gray_Out_Request_03Status(TIPA_Switch_Gray_Out_Request_03 tIPA_Switch_Gray_Out_Request_03);
   virtual void onIPA_Switch_Gray_Out_Request_04Status(TIPA_Switch_Gray_Out_Request_04 tIPA_Switch_Gray_Out_Request_04);
   virtual void onIPA_Switch_Gray_Out_Request_05Status(TIPA_Switch_Gray_Out_Request_05 tIPA_Switch_Gray_Out_Request_05);
   virtual void onIPA_Switch_Gray_Out_Request_06Status(TIPA_Switch_Gray_Out_Request_06 tIPA_Switch_Gray_Out_Request_06);
   virtual void onIPA_mode_selectionStatus(TIPA_mode_selection tIPA_mode_selection);
   virtual void onIPA_Message_Display_RequestStatus(TIPA_Message_Display_Request tIPA_Message_Display_Request);
   virtual void onIPA_Sound_Output_RequestStatus(TIPA_Sound_Output_Request tIPA_Sound_Output_Request);
   virtual void onIPA_Voice_Output_RequestStatus(TIPA_Voice_Output_Request tIPA_Voice_Output_Request);
   virtual void onIPA_region_selectionStatus(TIPA_region_selection tIPA_region_selection);
   virtual void onIPA_Camera_Indicator_RequestStatus(TIPA_Camera_Indicator_Request tIPA_Camera_Indicator_Request);
   virtual void onIPA_MulfunctionStatus(TIPA_Mulfunction tIPA_Mulfunction);
   virtual void onRearGearEngagedStatus(TRearGearEngaged tRearGearEngaged);
   virtual void onMVC_ViewModeStatusStatus(TMVC_ViewModeStatus tMVC_ViewModeStatus);
   virtual void onMVC_WarningDisplayRequestStatus(TMVC_WarningDisplayRequest tMVC_WarningDisplayRequest);
   virtual void onTailGateStatusStatus(TTailGateStatus tTailGateStatus);
   virtual void onAVM_ChangeViewStatusStatus(TAVM_ChangeViewStatus tAVM_ChangeViewStatus);
   virtual void onAVM_ClosingAuthorizationStatus(TAVM_ClosingAuthorization tAVM_ClosingAuthorization);
   virtual void onMOD_ActivationStateStatus(TMOD_ActivationState tMOD_ActivationState);
   virtual void onFAP_ModeChangeRequestStatus(TFAP_ModeChangeRequest tFAP_ModeChangeRequest);
   virtual void onCamerasetting_availabilityStatus(TCamerasetting_availability tCamerasetting_availability);
   virtual void onFAP_Setting01Status(TFAP_Setting01 tFAP_Setting01);
   virtual void onFAP_Setting02Status(TFAP_Setting02 tFAP_Setting02);
   virtual void onFAP_Setting03Status(TFAP_Setting03 tFAP_Setting03);
   virtual void onFAP_Setting04Status(TFAP_Setting04 tFAP_Setting04);
   virtual void onFAP_Setting05Status(TFAP_Setting05 tFAP_Setting05);
   virtual void onFAP_Setting06Status(TFAP_Setting06 tFAP_Setting06);
   virtual void onFAP_Setting07Status(TFAP_Setting07 tFAP_Setting07);
   virtual void onFAP_Setting08Status(TFAP_Setting08 tFAP_Setting08);
   virtual void onFAP_Setting09Status(TFAP_Setting09 tFAP_Setting09);
   virtual void onFAP_Setting10Status(TFAP_Setting10 tFAP_Setting10);
   virtual void onAVM_Setting_1Status(TAVM_Setting_1 tAVM_Setting_1);
   virtual void onAVM_Setting_2Status(TAVM_Setting_2 tAVM_Setting_2);
   virtual void onAVM_Setting_3Status(TAVM_Setting_3 tAVM_Setting_3);
   virtual void onAVM_Setting_4Status(TAVM_Setting_4 tAVM_Setting_4);
   virtual void onAVM_Setting_5Status(TAVM_Setting_5 tAVM_Setting_5);
   virtual void onAVM_Setting_6Status(TAVM_Setting_6 tAVM_Setting_6);
   virtual void onAVM_Setting_7Status(TAVM_Setting_7 tAVM_Setting_7);
   virtual void onAVM_Setting_8Status(TAVM_Setting_8 tAVM_Setting_8);
   virtual void onAVM_Setting_9Status(TAVM_Setting_9 tAVM_Setting_9);
   virtual void onFAP_PurposeSwitchAvailabilityStatus(TFAP_PurposeSwitchAvailability tFAP_PurposeSwitchAvailability);
   virtual void onFAP_ChangeViewRequestStatus(TFAP_ChangeViewRequest tFAP_ChangeViewRequest);
   virtual void onFAP_SoundDirectionStatus(TFAP_SoundDirection tFAP_SoundDirection);
   virtual void onFAP_SoundLevelControlStatus(TFAP_SoundLevelControl tFAP_SoundLevelControl);
   virtual void onFAP_SoundPatternRequestStatus(TFAP_SoundPatternRequest tFAP_SoundPatternRequest);
   virtual void onFAP_VoicePatternRequestStatus(TFAP_VoicePatternRequest tFAP_VoicePatternRequest);
   virtual void onDayRheostatedLightMaxPercentStatus(TDayRheostatedLightMaxPercent tDayRheostatedLightMaxPercent);
   virtual void onNightRheostatedLightMaxPercentStatus(TNightRheostatedLightMaxPercent tNightRheostatedLightMaxPercent);
   virtual void onDimmingStateStatus(TDimmingState tDimmingState);
   virtual void onSTATUS_DYNAMIC_REARStatus(TSTATUS_DYNAMIC_REAR tSTATUS_DYNAMIC_REAR);

// dispvidctrl_tclClientVcan::ClassImplementation: user specific code start
   static OSAL_tpfCallback _pfCallbackTimer_SteeringFail(tVoid* pArg);
   static OSAL_tpfCallback _pfCallbackTimer_SteeringSignal(tVoid* pArg);
   tBool  _bSetTimer_SteeringFail(OSAL_tMSecond msTimeout) const;
   tBool  _bSetTimer_SteeringSignal(OSAL_tMSecond msTimeout) const;

   // Special for Renault CAN Frames handling for confirmation only after 3s after detection
   static OSAL_tpfCallback _pfCallbackTimer_FrameTimeoutConfirmed(tVoid* pArg);
   tBool  _bSetTimer_FrameTimeoutConfirmed(OSAL_tMSecond msTimeout) const;

   tVoid vCheckAndSendITCStatus(tVoid);
   
   dispvidctrl_tclControl_Avm*       m_poControl_Avm;
   dispvidctrl_tclControl_Mvc*       m_poControl_Mvc;
   Idispvidctrl_tclClientDiaglogIf*  m_poClientDiaglogIf;
   dispvidctrl_tclControl_Hmi*       m_poControl_Hmi;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   I_dispvidctrl_tclClientDimming* m_poClientINCIf;
#endif

   OSAL_tTimerHandle  m_hTimerHandle_SteeringFail;
   OSAL_tTimerHandle  m_hTimerHandle_SteeringSignal;
   OSAL_tTimerHandle  m_hTimerHandle_FrameTimeoutConfirmed;

   tBool m_bErrorQualificationUnlocked_SensorCalibration;
   TenCanFrameTimeoutState m_enAvmCanMsgTimeOutState;
   tBool m_bItcSteeringFlagFail;
   tBool m_bSteeringSignalFail;
   tU8   m_Config_u8CameraSteeringMessageType;
   tBool m_bSteeringFlag_OK;
   tBool m_bSteeringSignal_OK;
   tBool m_bSteeringSignal_UNAVAILABLE;
   //---------------------------------------
   tU32  m_u32SetITSStatus;
   tU8   m_u8SetITSValue;
   tU32  m_u32BeepTypeStatus;
   tU8   m_u8BeepTypeValue;
   tU32  m_u32MODStatusStatus;
   tU8   m_u8MODStatusValue;
   //tU32  m_u32BSWStatusStatus;
   //tU8   m_u8BSWStatusValue;
   //tU32  m_u32LDWStatusStatus;
   //tU8   m_u8LDWStatusValue;
   tU32  m_u32ViewChReqStatus;
   tU8   m_u8ViewChReqValue;
   tU32  m_u32BeepReqStatus;
   tU8   m_u8BeepReqValue;
   tU32  m_u32InitialStatus;
   tU8   m_u8InitialValue;
   tU32  m_Status_u32AodBeep1Request;
   tU32  m_Status_u32SteeringAngle;
   tU32  m_Status_u32CalibrationFlag;
   tU32  m_Status_u32SteeringSensorFailFlag;
   tU32  m_Status_u32SwaSensorInternalStatus;
   tU32  m_Status_u32FrontSteerPinionAngle;
   tU32  m_Status_u32ActiveSteerFail;
   tU32  m_Status_u32VehicleSpeed;
   tU8   m_Value_u8AodBeep1Request;
   tS16  m_Value_s16SteeringAngle;
   tU8   m_Value_u8CalibrationFlag;
   tU8   m_Value_u8SteeringsensorFailFlag;
   tU8   m_Value_u8SwaSensorInternalStatus;
   tS16  m_Value_s16FrontSteerPinionAngle;
   tU8   m_Value_u8ActiveSteerFail;
   tU32  m_Value_u32VehicleSpeed;
   //---------------------------------------
   tU8   m_u8CameraOffRequest;
   tU8   m_u8CameraSwitchPress;
   tU8   m_u8CameraSwitchKeep;
   tU8   m_u8ModSwitchPress;
   //tU8   m_u8LdwSwitchPress;
   //tU8   m_u8BswSwitchPress;
   tU32  m_Status_u32RearGearEngaged;
   tU8   m_u8RearGearEngaged;
   tBool m_bRvcMode;

   // IPA related
   tBool m_bIpaMode;
   
   tBool m_Value_bIPAMode;
   tU8 m_Value_u8IPASwitchDisplay;
   tU8 m_Value_u8IPASwitchMask;
   tBool m_Value_bIPASwitchRequest01;
   tBool m_Value_bIPASwitchRequest02;
   tBool m_Value_bIPASwitchRequest03;
   tBool m_Value_bIPASwitchRequest04;
   tBool m_Value_bIPASwitchRequest05;
   tBool m_Value_bIPASwitchRequest06;
   tU8 m_Value_u8IPAModeSelection;
   tU8 m_Value_u8IPAMessageDisplay;
   tU8 m_Value_u8IPASoundOutput;
   tU8 m_Value_u8IPAVoiceOutput;
   tU8 m_Value_u8IPARegionSelection;
   tU8 m_Value_u8IPACameraIndicatorReq;
   tU8 m_Value_u8IPAMalfunction;

   tU32 m_Status_u32IPAMode;
   tU32 m_Status_u32IPASwitchDisplay;
   tU32 m_Status_u32IPASwitchMask;
   tU32 m_Status_u32IPASwitchRequest01;
   tU32 m_Status_u32IPASwitchRequest02;
   tU32 m_Status_u32IPASwitchRequest03;
   tU32 m_Status_u32IPASwitchRequest04;
   tU32 m_Status_u32IPASwitchRequest05;
   tU32 m_Status_u32IPASwitchRequest06;
   tU32 m_Status_u32IPAModeSelection;
   tU32 m_Status_u32IPAMessageDisplay;
   tU32 m_Status_u32IPASoundOutput;
   tU32 m_Status_u32IPAVoiceOutput;
   tU32 m_Status_u32IPARegionSelection;
   tU32 m_Status_u32IPACameraIndicatorReq;
   tU32 m_Status_u32IPAMalfunction;
   
   // MVC related
   tBool m_bMvcMode;
   TenCanFrameTimeoutState m_enMvcCanMsgTimeOutState;
   
   tU8 m_Value_u8MVC_ViewModeStatus;
   tU8 m_Value_u8MVC_WarningDisplayRequest;
   tU8 m_Value_u8TailGateStatus;
   
   tU32 m_Status_u32MVC_ViewModeStatus;
   tU32 m_Status_u32MVC_WarningDisplayRequest;
   tU32 m_Status_u32TailGateStatus;
   
   // AVM Renault related
   tU32 m_Status_u32AVM_ChangeViewStatus;
   tU32 m_Status_u32AVM_ClosingAuthorization;

   tU8 m_value_u8AVM_ChangeViewStatus;
   tU8 m_value_u8AVM_ClosingAuthorization;

   tU8 m_Config_u8VCANDiversity;
   
   tU8 m_ValueDayRheostatedLightMaxPercent;
   tU8 m_ValueNightRheostatedLightMaxPercent;
   
   // FAP related   
   tBool m_bFapMode;
   TenCanFrameTimeoutState m_enFapCanMsgTimeOutState;

   tU32 m_Status_FAP_ModeChangeRequestStatus;
   tU32 m_Status_Camerasetting_availabilityStatus;
   tU32 m_Status_FAP_Setting01Status;
   tU32 m_Status_FAP_Setting02Status;
   tU32 m_Status_FAP_Setting03Status;
   tU32 m_Status_FAP_Setting04Status;
   tU32 m_Status_FAP_Setting05Status;
   tU32 m_Status_FAP_Setting06Status;
   tU32 m_Status_FAP_Setting07Status;
   tU32 m_Status_FAP_Setting08Status;
   tU32 m_Status_FAP_Setting09Status;
   tU32 m_Status_FAP_Setting10Status;
   tU32 m_Status_AVM_Setting_1Status;
   tU32 m_Status_AVM_Setting_2Status;
   tU32 m_Status_AVM_Setting_3Status;
   tU32 m_Status_AVM_Setting_4Status;
   tU32 m_Status_AVM_Setting_5Status;
   tU32 m_Status_AVM_Setting_6Status;
   tU32 m_Status_AVM_Setting_7Status;
   tU32 m_Status_AVM_Setting_8Status;
   tU32 m_Status_AVM_Setting_9Status;
   tU32 m_Status_FAP_PurposeSwitchAvailabilityStatus;
   tU32 m_Status_FAP_ChangeViewRequestStatus;
   tU32 m_Status_FAP_SoundDirectionStatus;
   tU32 m_Status_FAP_SoundLevelControlStatus;
   tU32 m_Status_FAP_SoundPatternRequestStatus;
   tU32 m_Status_FAP_VoicePatternRequestStatus;
   
   tU32 m_Value_FAP_ModeChangeRequest;
   tU32 m_Value_Camerasetting_availability;
   tU32 m_Value_FAP_Setting01;
   tU32 m_Value_FAP_Setting02;
   tU32 m_Value_FAP_Setting03;
   tU32 m_Value_FAP_Setting04;
   tU32 m_Value_FAP_Setting05;
   tU32 m_Value_FAP_Setting06;
   tU32 m_Value_FAP_Setting07;
   tU32 m_Value_FAP_Setting08;
   tU32 m_Value_FAP_Setting09;
   tU32 m_Value_FAP_Setting10;
   tU32 m_Value_AVM_Setting_1;
   tU32 m_Value_AVM_Setting_2;
   tU32 m_Value_AVM_Setting_3;
   tU32 m_Value_AVM_Setting_4;
   tU32 m_Value_AVM_Setting_5;
   tU32 m_Value_AVM_Setting_6;
   tU32 m_Value_AVM_Setting_7;
   tU32 m_Value_AVM_Setting_8;
   tU32 m_Value_AVM_Setting_9;
   tU32 m_Value_FAP_PurposeSwitchAvailability;
   tU32 m_Value_FAP_ChangeViewRequest;
   tU32 m_Value_FAP_SoundDirection;
   tU32 m_Value_FAP_SoundLevelControl;
   tU32 m_Value_FAP_SoundPatternRequest;
   tU32 m_Value_FAP_VoicePatternRequest;

   // AVM phase3 related
   tU8  m_Value_u8BciStatus;
   tU32 m_Status_u32BciStatus;
   
public:
   virtual tVoid vHandleControl(tenControl_ClientCsm enControl, tU32 u32Value = 0);
   virtual tVoid vCheckInitialisingSignal(tVoid) const;
   virtual tVoid vCheckViewChangeRequestSignal(tVoid) const;
   virtual tVoid vWriteUPA_TX_Initializing(tU8 u8SignalValue);
   virtual tVoid vWriteUPA_Setting_Language_Request(tU8 u8AvmLanguage);
   virtual tVoid vWriteUPA_Camera_OFF_Request(tBool bReinit);
   virtual tVoid vWriteUPA_Camera_Switch_Keep(tBool bReinit);
   virtual tVoid vWriteUPA_Camera_Switch_Press(tBool bReinit);
   virtual tVoid vWriteUPA_MOD_Switch_Press(tBool bReinit);
   virtual tVoid vWriteIPA_Activation_Flag(tBool bFlag);
   virtual tVoid vWriteIPA_SW_Long_Press(tBool bSWLongPress);
   virtual tVoid vWriteIPA_SW_Operation_Status(tU8 u8Status);
   virtual tVoid vWriteAVM_Switch_Request(tU8 u8Request);
   virtual tVoid vWriteAVM_View_Change_Request(tU8 u8Request);
   virtual tVoid vWriteMVC_ViewModeRequest(tU8 u8Request);
   virtual tVoid vWriteAVM_MOD_Activation_Request(tU8 u8Request);

   virtual tVoid vWriteFAP_ScreenPressCoordinateX(tU8 u8Data);
   virtual tVoid vWriteFAP_ScreenPressCoordinateY(tU8 u8Data);
   virtual tVoid vWriteFAP_ScreenPressDetected(tU8 u8Data);
   virtual tVoid vWriteFAP_Screen_Activation_flag(tU8 u8Data);

   //virtual tVoid vWriteLDW_PRESS_5FE(tBool bReinit);
   //virtual tVoid vWriteBSW_PRESS_5FE(tBool bReinit);

   virtual tVoid vInvalidateCsmRx(tVoid);
   virtual tBool bGetViewChangeRequestSignal(tU8& u8ViewChangeSignalValue);
   virtual tBool bGet_MVC_ViewModeStatus(tU8& u8ViewStatus);
   virtual tBool bGet_MVC_WarningDisplayRequest(tU32& u32Request);
   //virtual tBool bGetAffordableItsSignals(tBool& bItsMod, tBool& bItsBsw, tBool& bItsLdw, tBool& bItsAvailable);
   virtual tBool bGetAffordableItsSignals(tBool& bItsMod, tBool& bItsAvailable);
   virtual tBool bGet_VehicleSpeedSignal(tU32& u32VehicleSpeedValue);
   virtual tBool bGet_SteeringAngleSignal(tS32& s32SteeringAngleDeg);
   virtual tBool bGet_FrontSteerPinionAngleSignal(tS32& s32FrontSteerPinionAngleDeg);
   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
   virtual tBool bIsSteeringAngleInfoValid() const;
   // IPA related
   virtual tBool bGet_IPA_SwitchesSignals(tU8& u8SwitchesSignalsValue);
   virtual tBool bGet_IPA_PatternDisplayStatus(tU8& u8SwitchDisplayValue);
   virtual tBool bGet_IPA_MessageDisplaySignals(tU8& u8MessageDisplayValue);
   virtual tBool bGet_IPA_ConfigurationStatus(tU8& u8RegionSelection);
   virtual tBool bGet_IPA_OperationStatus(tU8& u8OperationStatus, tU8& u8RequestedStatus);
   virtual tBool bGet_IPA_SwitchMaskStatus(tU8& u8SwitchMaskStatus);
   virtual tBool bGet_IPA_DirectionStatus(tU8& u8DirectionStatus);

   virtual tBool bGet_ReverseGearEngagedStatus(tVoid);
   virtual tBool bGet_TailgateStatus(tBool& bTailgateOpen) const;
   virtual tU8  u8getDayRheostatedLightMaxPercent(tVoid);
   virtual tU8  u8getRheostatedLightMaxPercent(tVoid);

   virtual tVoid vCheck_Fap_ViewChangeRequestSignal(tVoid) const;
   virtual tBool bGet_Fap_ViewChangeRequestSignal(tU8& u8ViewChangeSignalValue);

   virtual tU8   u8GetFapSettingState(tU8 u8SettingType) const;
   virtual tU8   u8GetAvmSettingState(tU8 u8SettingType) const;

   virtual tU8   u8GetAvmViewStatus() const;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   virtual tVoid onDayRheostatedLightMaxPercentTTFIsTrigger(tU8 u8DayRheostated);
#endif

   virtual tBool bGetBciStatus(tU8& bBciStatus) const;
   virtual tVoid vWriteDriver_Assistance_SW_flag(tU8 u8SwitchId);
// dispvidctrl_tclClientVcan::ClassImplementation: user specific code end


};

#endif // _VCANCAN_CLIENT_H_

