/*****************************************************************************
* FILE:         dispvidctrl_ClientVcan.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     CsmClient.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "dispvidctrl_ClientVcan.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VCAN
#include "trcGenProj/Header/dispvidctrl_ClientVcan.cpp.trc.h"
#endif

// dispvidctrl_tclClientVcan::ClassIncludes: user specific code start
#include "I_dispvidctrl_ClientDiaglogIf.h"
#include "dispvidctrl_tclControl_Rvc.h"
#include "dispvidctrl_tclControl_Avm.h"
#include "dispvidctrl_tclControl_Mvc.h"
#include "dispvidctrl_datapool.h"
#include "Idispvidctrl_ClientDimming.h"
#include "dispvidctrl_tclControl_Hmi.h"
#include "dispvidctrl_ServiceDimmingIf.h"
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"
#include "Idispvidctrl_ClientAvm.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
// NCG3D-22060
// For the case that the ECU is setting the Steering Calibration Flag
//  to False state on there shut-down before stopping CAN message Tx,
//  the failure qualification time should be longer than CAN message time out
#define DISPVIDCTRL_CLIENT_VCAN_STEERING_FAIL_RECHECK_TIME_IN_MS    2500

#define DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS    3000

#define DISPVIDCTRL_CLIENT_VCAN_METER_OFFSET  0.2
#define DISPVIDCTRL_CLIENT_VCAN_RENAULT_RESOLUTION 0.4
#define RENAULT_CAN_MATRIX_OFFSET_FACTOR  (tF32) ( (tF32)(DISPVIDCTRL_CLIENT_VCAN_METER_OFFSET) * (tF32)(DISPVIDCTRL_CLIENT_VCAN_RENAULT_RESOLUTION))

// dispvidctrl_tclClientVcan::ClassIncludes: user specific code end

dispvidctrl_tclClientVcan::dispvidctrl_tclClientVcan(dispvidctrl_tclAppMain* poMainAppl):
I_dispvidctrl_tclClientVcan(poMainAppl),
_pCsmBase(NULL)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::dispvidctrl_tclClientVcan() entered."));
   // dispvidctrl_tclClientVcan::dispvidctrl_tclClientVcan: user specific code start
   m_poControl_Avm = OSAL_NULL;
   m_poControl_Mvc = OSAL_NULL;
   m_poClientDiaglogIf = OSAL_NULL;
   m_poControl_Hmi = OSAL_NULL;
   m_hTimerHandle_SteeringFail = OSAL_C_INVALID_HANDLE;
   m_hTimerHandle_SteeringSignal = OSAL_C_INVALID_HANDLE;
   m_hTimerHandle_FrameTimeoutConfirmed = OSAL_C_INVALID_HANDLE;
   m_bErrorQualificationUnlocked_SensorCalibration = FALSE;
   m_enAvmCanMsgTimeOutState = TIMEOUT_FALSE;
   m_bItcSteeringFlagFail = FALSE;
   m_bSteeringSignalFail = FALSE;
   m_bSteeringFlag_OK = TRUE;
   m_bSteeringSignal_OK = TRUE;
   m_bSteeringSignal_UNAVAILABLE = FALSE;
   //------------------------------ system (KDS) configuration info
   m_Config_u8CameraSteeringMessageType = 0;
   //-----------------------------------------------
   m_u32BeepTypeStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_u8BeepTypeValue = 0;
   //m_u32LDWStatusStatus = CSM_C_SIGNAL_DATA_INVALID;
   //m_u8LDWStatusValue = 0;
   //m_u32BSWStatusStatus = CSM_C_SIGNAL_DATA_INVALID;
   //m_u8BSWStatusValue = 0;
   m_u32MODStatusStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_u8MODStatusValue = 0;
   m_u32SetITSStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_u8SetITSValue = 0;
   m_u32ViewChReqStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_u8ViewChReqValue = 0;
   m_u32BeepReqStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_u8BeepReqValue = 0;
   m_u32InitialStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_u8InitialValue = 0;
   m_Status_u32AodBeep1Request = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32SteeringAngle = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32CalibrationFlag = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32SteeringSensorFailFlag = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32SwaSensorInternalStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32FrontSteerPinionAngle = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32ActiveSteerFail = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32VehicleSpeed = CSM_C_SIGNAL_DATA_INVALID;
   m_Value_u8AodBeep1Request = 0;
   m_Value_s16SteeringAngle = 0;
   m_Value_u8CalibrationFlag = 0;
   m_Value_u8SteeringsensorFailFlag = 0;
   m_Value_u8SwaSensorInternalStatus = 0;
   m_Value_s16FrontSteerPinionAngle = 0;
   m_Value_u8ActiveSteerFail = 0;
   m_Value_u32VehicleSpeed = 0;
   //---------------------------------------
   m_u8CameraOffRequest = 0;
   m_u8CameraSwitchPress = 0;
   m_u8CameraSwitchKeep = 0;
   m_u8ModSwitchPress = 0;
   //m_u8LdwSwitchPress = 0;
   //m_u8BswSwitchPress = 0;
   m_Status_u32RearGearEngaged = 0;
   m_u8RearGearEngaged = 0;
   m_bRvcMode = FALSE;
   
   // IPA related
   m_bIpaMode = FALSE;
   
   m_Value_bIPAMode = FALSE;
   m_Value_u8IPASwitchDisplay = 0;
   m_Value_u8IPASwitchMask = 0;
   m_Value_bIPASwitchRequest01 = FALSE;
   m_Value_bIPASwitchRequest02 = FALSE;
   m_Value_bIPASwitchRequest03 = FALSE;
   m_Value_bIPASwitchRequest04 = FALSE;
   m_Value_bIPASwitchRequest05 = FALSE;
   m_Value_bIPASwitchRequest06 = FALSE;
   m_Value_u8IPAModeSelection = 0;
   m_Value_u8IPAMessageDisplay = 0;
   m_Value_u8IPASoundOutput = 0;
   m_Value_u8IPAVoiceOutput = 0;
   m_Value_u8IPARegionSelection = 0;
   m_Value_u8IPACameraIndicatorReq = 0;
   m_Value_u8IPAMalfunction = 0;
   m_Status_u32IPAMode = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchDisplay = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchMask = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchRequest01 = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchRequest02 = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchRequest03 = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchRequest04 = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchRequest05 = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASwitchRequest06 = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPAModeSelection = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPAMessageDisplay = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPASoundOutput = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPAVoiceOutput = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPARegionSelection = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPACameraIndicatorReq = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32IPAMalfunction = CSM_C_SIGNAL_DATA_INVALID;
   
   m_bMvcMode = FALSE;
   m_enMvcCanMsgTimeOutState = TIMEOUT_FALSE;
   
   m_Value_u8MVC_ViewModeStatus = 0;
   m_Value_u8MVC_WarningDisplayRequest = 0;
   m_Value_u8TailGateStatus = 0;
   m_value_u8AVM_ChangeViewStatus = 0;
   m_value_u8AVM_ClosingAuthorization = 0;
   
   m_Status_u32MVC_ViewModeStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32MVC_WarningDisplayRequest = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32TailGateStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32AVM_ChangeViewStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_u32AVM_ClosingAuthorization = CSM_C_SIGNAL_DATA_INVALID;
   
   m_bFapMode = FALSE;
   m_enFapCanMsgTimeOutState = TIMEOUT_FALSE;
   m_Status_FAP_ModeChangeRequestStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_Camerasetting_availabilityStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting01Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting02Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting03Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting04Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting05Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting06Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting07Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting08Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting09Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_Setting10Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_1Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_2Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_3Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_4Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_5Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_6Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_7Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_8Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_AVM_Setting_9Status = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_PurposeSwitchAvailabilityStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_ChangeViewRequestStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_SoundDirectionStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_SoundLevelControlStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_SoundPatternRequestStatus = CSM_C_SIGNAL_DATA_INVALID;
   m_Status_FAP_VoicePatternRequestStatus = CSM_C_SIGNAL_DATA_INVALID;
   
   m_Value_FAP_ModeChangeRequest = 0;
   m_Value_Camerasetting_availability = 0;
   m_Value_FAP_Setting01 = 0;
   m_Value_FAP_Setting02 = 0;
   m_Value_FAP_Setting03 = 0;
   m_Value_FAP_Setting04 = 0;
   m_Value_FAP_Setting05 = 0;
   m_Value_FAP_Setting06 = 0;
   m_Value_FAP_Setting07 = 0;
   m_Value_FAP_Setting08 = 0;
   m_Value_FAP_Setting09 = 0;
   m_Value_FAP_Setting10 = 0;
   m_Value_AVM_Setting_1 = 0;
   m_Value_AVM_Setting_2 = 0;
   m_Value_AVM_Setting_3 = 0;
   m_Value_AVM_Setting_4 = 0;
   m_Value_AVM_Setting_5 = 0;
   m_Value_AVM_Setting_6 = 0;
   m_Value_AVM_Setting_7 = 0;
   m_Value_AVM_Setting_8 = 0;
   m_Value_AVM_Setting_9 = 0;
   m_Value_FAP_PurposeSwitchAvailability = 0;
   m_Value_FAP_ChangeViewRequest = 0;
   m_Value_FAP_SoundDirection = 0;
   m_Value_FAP_SoundLevelControl = 0;
   m_Value_FAP_SoundPatternRequest = 0;
   m_Value_FAP_VoicePatternRequest = 0;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
	m_poClientINCIf = OSAL_NULL;
#endif
	m_ValueDayRheostatedLightMaxPercent = 0;
	m_ValueNightRheostatedLightMaxPercent = 0;

   m_Value_u8BciStatus = 0;
   m_Status_u32BciStatus = CSM_C_SIGNAL_DATA_INVALID;


   m_Config_u8VCANDiversity = 0;
   // dispvidctrl_tclClientVcan::dispvidctrl_tclClientVcan: user specific code end
   return;
}

dispvidctrl_tclClientVcan::~dispvidctrl_tclClientVcan()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::~dispvidctrl_tclClientVcan() entered."));
   _pCsmBase = OSAL_NULL;
   // dispvidctrl_tclClientVcan::~dispvidctrl_tclClientVcan: user specific code start

   //stop and delete all timer
   if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_SteeringFail)
   {
      (tVoid) OSAL_s32TimerSetTime(m_hTimerHandle_SteeringFail, 0, 0);
      (tVoid) OSAL_s32TimerDelete(m_hTimerHandle_SteeringFail);
   }
   if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_SteeringSignal)
   {
      (tVoid) OSAL_s32TimerSetTime(m_hTimerHandle_SteeringSignal, 0, 0);
      (tVoid) OSAL_s32TimerDelete(m_hTimerHandle_SteeringSignal);
   }
   if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_FrameTimeoutConfirmed)
   {
      (tVoid) OSAL_s32TimerSetTime(m_hTimerHandle_FrameTimeoutConfirmed, 0, 0);
      (tVoid) OSAL_s32TimerDelete(m_hTimerHandle_FrameTimeoutConfirmed);
   }

   m_poControl_Avm = OSAL_NULL;
   m_poControl_Mvc = OSAL_NULL;
   m_poClientDiaglogIf = OSAL_NULL;
   m_poControl_Hmi = OSAL_NULL;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   m_poClientINCIf = OSAL_NULL;
#endif
   // dispvidctrl_tclClientVcan::~dispvidctrl_tclClientVcan: user specific code end
   return;
}

tVoid dispvidctrl_tclClientVcan::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientVcan::vHandleMessage: user specific code start
   switch(pMsg->eCmd)
   {
   case dispvidctrl_tclBaseIf::eTriggerRecheckITC:
   {
       if ( m_Config_u8CameraSteeringMessageType == 0x00 ) {
           vGetCalibration_Flag();
       } else if ( m_Config_u8CameraSteeringMessageType == 0x01 ) {
           vGetACTIVE_STEER_FAIL();
       }

       vCheckAndSendITCStatus();
   }
   break;
   case dispvidctrl_tclBaseIf::eTriggerCanMsgConfirmTimeout:
   {
       if (TIMEOUT_CONFIRMED == m_enAvmCanMsgTimeOutState)
       {
           if (m_poControl_Avm)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_CONFIRMED);
           }
       }

       if (TIMEOUT_CONFIRMED == m_enMvcCanMsgTimeOutState)
       {
           if (m_poControl_Mvc)
           {
               m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__CAN_MSG_TIMEOUT_CONFIRMED);
           }
       }
   }
   break;
   default:
       break;
   }
   // dispvidctrl_tclClientVcan::vHandleMessage: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientVcan::vHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientVcan::vHandleTraceMessage: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetReferences() {

   _pCsmBase = dynamic_cast<I_dispvidctrl_tclClientVcanCanAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientVcanCanAdaptor"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);
   _pCsmBase->vSetCallbackIf(this);

   // dispvidctrl_tclClientVcan::vGetReferences: user specific code start
   m_poControl_Avm = dynamic_cast<dispvidctrl_tclControl_Avm*>(_cpoMain->getHandler("dispvidctrl_tclControl_Avm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);

   m_poClientDiaglogIf = dynamic_cast<Idispvidctrl_tclClientDiaglogIf*>(_cpoMain->getHandler("Idispvidctrl_tclClientDiaglogIf"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientDiaglogIf);
   
   m_poControl_Mvc = dynamic_cast<dispvidctrl_tclControl_Mvc*>(_cpoMain->getHandler("dispvidctrl_tclControl_Mvc"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Mvc);
   
   m_poControl_Hmi = dynamic_cast<dispvidctrl_tclControl_Hmi*>(_cpoMain->getHandler("dispvidctrl_tclControl_Hmi"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Hmi);
   
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   m_poClientINCIf = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_cpoMain->getHandler("I_dispvidctrl_tclClientDimming"));
    DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientINCIf);
#endif
   // dispvidctrl_tclClientVcan::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclClientVcan::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::vTraceInfo() entered."));
   // dispvidctrl_tclClientVcan::vTraceInfo: user specific code start

// signal status flags
//  ARRIVED                             = 0x00000001UL,  /**< Signal received      */
//  ARRIVED_FIRST                       = 0x00000002UL,  /**< First time reception */
//  ARRIVED_FIRST__ARRIVED              = 0x00000003UL,  // assembled value 
//  DATA_INVALID                        = 0x00000004UL,  /**< data invalid         */
//  TIMEOUT                             = 0x00000008UL,  /**< receive Timeout      */
//  ARRIVED__TIMEOUT                    = 0x00000009UL,  // assembled value
//  ARRIVED_FIRST__ARRIVED__TIMEOUT     = 0x0000000BUL,  // assembled value
//  NOT_RECEIVED                        = 0x00000010UL,  /**< no signal received   */
//  NOT_RECEIVED__DATA_INVALID__TIMEOUT = 0x0000001CUL,  // assembled value
//  DATA_OUTDATED                       = 0x00000020UL,  /**< bus sleep, no actual value */
//  RETRIGGERED                         = 0x00000040UL,  /**< forced signal indication   */
//  HAS_NO_DATA_SOURCE                  = 0x00000080UL,  /**< for abstract Rx signals which don't have a "real" CSM source signal */
//  DATA_QUEUED                         = 0x00000100UL,  /**< signal/message is read from queue */
//  DATA_QUEUE_OVERRUN                  = 0x00000200UL   /**< signal/message is read from queue */


   ETG_TRACE_FATAL(("  CL-VCAN :: vTraceInfo()      : ****** Client VCAN states ***********************************"));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bErrorQual..Unlocked_SensorCalibration .. %-40u", m_bErrorQualificationUnlocked_SensorCalibration));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_enAvmCanMsgTimeOutState ................. %-40u", ETG_CENUM(TenCanFrameTimeoutState, m_enAvmCanMsgTimeOutState)));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bSteeringFlagFail ....................... %-40u", m_bItcSteeringFlagFail));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bSteeringSignalFail ..................... %-40u", m_bSteeringSignalFail));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Config_u8CameraSteeringMessageType ...... %-40u", m_Config_u8CameraSteeringMessageType));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bSteeringFlag_OK ........................ %-40u", m_bSteeringFlag_OK));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bSteeringSignal_OK ...................... %-40u", m_bSteeringSignal_OK));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bSteeringSignal_UNAVAILABLE ............. %-40u", m_bSteeringSignal_UNAVAILABLE));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u32SetITSStatus ......................... %-40u", m_u32SetITSStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8SetITSValue ........................... %-40u", m_u8SetITSValue));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u32BeepTypeStatus ....................... %-40u", m_u32BeepTypeStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8BeepTypeValue ......................... %-40u", m_u8BeepTypeValue));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u32MODStatusStatus ...................... %-40u", m_u32MODStatusStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8MODStatusValue ........................ %-40u", m_u8MODStatusValue));
   //ETG_TRACE_FATAL(("  CL-VCAN :: m_u32BSWStatusStatus ...................... %-40u", m_u32BSWStatusStatus));
   //ETG_TRACE_FATAL(("  CL-VCAN :: m_u8BSWStatusValue ........................ %-40u", m_u8BSWStatusValue));
   //ETG_TRACE_FATAL(("  CL-VCAN :: m_u32LDWStatusStatus ...................... %-40u", m_u32LDWStatusStatus));
   //ETG_TRACE_FATAL(("  CL-VCAN :: m_u8LDWStatusValue ........................ %-40u", m_u8LDWStatusValue));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u32ViewChReqStatus ...................... %-40u", m_u32ViewChReqStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8ViewChReqValue ........................ %-40u", m_u8ViewChReqValue));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u32BeepReqStatus ........................ %-40u", m_u32BeepReqStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8BeepReqValue .......................... %-40u", m_u8BeepReqValue));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u32InitialStatus ........................ %-40u", m_u32InitialStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8InitialValue .......................... %-40u", m_u8InitialValue));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32AodBeep1Request ............... 0x%08x", m_Status_u32AodBeep1Request));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32SteeringAngle ................. 0x%08x", m_Status_u32SteeringAngle));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32CalibrationFlag ............... 0x%08x", m_Status_u32CalibrationFlag));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32SteeringSensorFailFlag ........ 0x%08x", m_Status_u32SteeringSensorFailFlag));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32FrontSteerPinionAngle ......... 0x%08x", m_Status_u32FrontSteerPinionAngle));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32ActiveSteerFail ............... 0x%08x", m_Status_u32ActiveSteerFail));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u8VehicleSpeed ................... 0x%08x", m_Status_u32VehicleSpeed));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8AodBeep1Request ................. %-40u", m_Value_u8AodBeep1Request));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_s16SteeringAngle .................. %-40d", m_Value_s16SteeringAngle));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8CalibrationFlag ................. %-40u", m_Value_u8CalibrationFlag));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8SteeringsensorFailFlag .......... %-40u", m_Value_u8SteeringsensorFailFlag));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_s16FrontSteerPinionAngle .......... %-40d", m_Value_s16FrontSteerPinionAngle));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8ActiveSteerFail ................. %-40u", m_Value_u8ActiveSteerFail));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u32VehicleSpeed ................... %-40u", m_Value_u32VehicleSpeed));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8CameraOffRequest ...................... %-40u", m_u8CameraOffRequest));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8CameraSwitchPress ..................... %-40u", m_u8CameraSwitchPress));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8CameraSwitchKeep ...................... %-40u", m_u8CameraSwitchKeep));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8ModSwitchPress ........................ %-40u", m_u8ModSwitchPress));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32RearGearEngaged ............... %-40u", m_Status_u32RearGearEngaged));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_u8RearGearEngaged ....................... %-40u", m_u8RearGearEngaged));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_bRvcMode ................................ %-40u", m_bRvcMode));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPAMode .......................... %-40u", m_Value_bIPAMode));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPASwitchDisplay ................ %-40u", m_Value_u8IPASwitchDisplay));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPASwitchMask ................... %-40u", m_Value_u8IPASwitchMask));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPASwitchRequest01 ............... %-40u", m_Value_bIPASwitchRequest01));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPASwitchRequest02 ............... %-40u", m_Value_bIPASwitchRequest02));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPASwitchRequest03 ............... %-40u", m_Value_bIPASwitchRequest03));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPASwitchRequest04 ............... %-40u", m_Value_bIPASwitchRequest04));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPASwitchRequest05 ............... %-40u", m_Value_bIPASwitchRequest05));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_bIPASwitchRequest06 ............... %-40u", m_Value_bIPASwitchRequest06));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPAModeSelection .................%-40u", m_Value_u8IPAModeSelection));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPAMessageDisplay ................%-40u", m_Value_u8IPAMessageDisplay));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPASoundOutput ...................%-40u", m_Value_u8IPASoundOutput));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPAVoiceOutput ...................%-40u", m_Value_u8IPAVoiceOutput));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPARegionSelection ...............%-40u", m_Value_u8IPARegionSelection));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPACameraIndicatorReq ............%-40u", m_Value_u8IPACameraIndicatorReq));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8IPAMalfunction ...................%-40u", m_Value_u8IPAMalfunction));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPAMode ....................... %-40u", m_Status_u32IPAMode));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchDisplay ...............%-40u", m_Status_u32IPASwitchDisplay));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchMask ..................%-40u", m_Status_u32IPASwitchMask));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchRequest01 .............%-40u", m_Status_u32IPASwitchRequest01));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchRequest02 .............%-40u", m_Status_u32IPASwitchRequest02));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchRequest03 .............%-40u", m_Status_u32IPASwitchRequest03));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchRequest04 .............%-40u", m_Status_u32IPASwitchRequest04));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchRequest05 .............%-40u", m_Status_u32IPASwitchRequest05));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASwitchRequest06 .............%-40u", m_Status_u32IPASwitchRequest06));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPAModeSelection ...............%-40u", m_Status_u32IPAModeSelection));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPAMessageDisplay ..............%-40u", m_Status_u32IPAMessageDisplay));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPASoundOutput .................%-40u", m_Status_u32IPASoundOutput));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPAVoiceOutput .................%-40u", m_Status_u32IPAVoiceOutput));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPARegionSelection .............%-40u", m_Status_u32IPARegionSelection));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPACameraIndicatorReq ..........%-40u", m_Status_u32IPACameraIndicatorReq));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32IPAMalfunction .................%-40u", m_Status_u32IPAMalfunction)); 
   ETG_TRACE_FATAL(("  CL-VCAN :: m_enMvcCanMsgTimeOutState.................. %-40u", ETG_CENUM(TenCanFrameTimeoutState, m_enMvcCanMsgTimeOutState)));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8MVC_ViewModeStatus .............. %-40u", m_Value_u8MVC_ViewModeStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8MVC_WarningDisplayRequest ....... %-40u", m_Value_u8MVC_WarningDisplayRequest));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Value_u8TailGateStatus .................. %-40u", m_Value_u8TailGateStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32MVC_ViewModeStatus ............ %-40u", m_Status_u32MVC_ViewModeStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32MVC_WarningDisplayRequest ..... %-40u", m_Status_u32MVC_WarningDisplayRequest));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32TailGateStatus ................ %-40u", m_Status_u32TailGateStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32AVM_ChangeViewStatus .......... %-40u", m_Status_u32AVM_ChangeViewStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Status_u32AVM_ClosingAuthorization ...... %-40u", m_Status_u32AVM_ClosingAuthorization));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_value_u8AVM_ChangeViewStatus ............ %-40u", m_value_u8AVM_ChangeViewStatus));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_value_u8AVM_ClosingAuthorization ........ %-40u", m_value_u8AVM_ClosingAuthorization));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_Config_u8VCANDiversity .................. %-40u", m_Config_u8VCANDiversity));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_ValueDayRheostatedLightMaxPercent ....... %-40u", m_ValueDayRheostatedLightMaxPercent));
   ETG_TRACE_FATAL(("  CL-VCAN :: m_ValueNightRheostatedLightMaxPercent ..... %-40u", m_ValueNightRheostatedLightMaxPercent));
   ETG_TRACE_FATAL(("  CL-VCAN :: *********************************************************************************"));
   // dispvidctrl_tclClientVcan::vTraceInfo: user specific code end

}


tVoid dispvidctrl_tclClientVcan::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::vStartCommunication() entered."));
   if (_pCsmBase) _pCsmBase->vConnect();

   // dispvidctrl_tclClientVcan::vStartCommunication: user specific code start
   // create timer for Steering Fail verification
   if( OSAL_s32TimerCreate((OSAL_tpfCallback) _pfCallbackTimer_SteeringFail, (tVoid*) this, &m_hTimerHandle_SteeringFail) != OSAL_OK)
   {
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_USR4(("dispvidctrl_tclClientVcan:: E R R O R in vStartCommunication(): ..... create Timer SteeringFail failed! "));
      m_hTimerHandle_SteeringFail =  OSAL_C_INVALID_HANDLE;
   }
   // create timer for Steering Signal verification
   if( OSAL_s32TimerCreate((OSAL_tpfCallback) _pfCallbackTimer_SteeringSignal, (tVoid*) this, &m_hTimerHandle_SteeringSignal) != OSAL_OK)
   {
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_USR4(("dispvidctrl_tclClientVcan:: E R R O R in vStartCommunication(): ..... create Timer SteeringSignal failed! "));
      m_hTimerHandle_SteeringSignal =  OSAL_C_INVALID_HANDLE;
   }
   // create timer for Renault CAN Frame Timeout Confirmation
   if( OSAL_s32TimerCreate((OSAL_tpfCallback) _pfCallbackTimer_FrameTimeoutConfirmed, (tVoid*) this, &m_hTimerHandle_FrameTimeoutConfirmed) != OSAL_OK)
   {
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_USR4(("dispvidctrl_tclClientVcan:: E R R O R in vStartCommunication(): ..... create Timer CAN FrameTimeoutConfirmed failed! "));
      m_hTimerHandle_FrameTimeoutConfirmed = OSAL_C_INVALID_HANDLE;
   }
   // dispvidctrl_tclClientVcan::vStartCommunication: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_RX_InitializingStatus(TUPA_RX_Initializing tUPA_RX_Initializing) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_RX_InitializingStatus(): status: %08x, data: %d.", tUPA_RX_Initializing.u32Status , tUPA_RX_Initializing.UPA_RX_Initializing));
   // dispvidctrl_tclClientVcan::onUPA_RX_InitializingStatus: user specific code start

    // this signal should not be used for VCAN Slot C1A, there are separate signals for that
    m_u32InitialStatus = tUPA_RX_Initializing.u32Status;
    m_u8InitialValue   = tUPA_RX_Initializing.UPA_RX_Initializing;

    if (m_poControl_Avm)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tUPA_RX_Initializing.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               // event AVM init signal did change
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__INIT_CHANGE);
           }
           else
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_FALSE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_FALSE);
           }
       }
       else if (CSM_C_SIGNAL_TIMEOUT & tUPA_RX_Initializing.u32Status)
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onINITIAL_Short_5C2Status() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onINITIAL_Short_5C2Status() : signal data NOK!                        "));
       }
    }
   // dispvidctrl_tclClientVcan::onUPA_RX_InitializingStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_View_Change_RequestStatus(TUPA_View_Change_Request tUPA_View_Change_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_View_Change_RequestStatus(): status: %08x, data: %d.", tUPA_View_Change_Request.u32Status , tUPA_View_Change_Request.UPA_View_Change_Request));
   // dispvidctrl_tclClientVcan::onUPA_View_Change_RequestStatus: user specific code start
   m_u32ViewChReqStatus = tUPA_View_Change_Request.u32Status;
   m_u8ViewChReqValue   = tUPA_View_Change_Request.UPA_View_Change_Request;

   if (m_poControl_Avm && (m_bFapMode == FALSE))
   {
      if (CSM_C_SIGNAL_ARRIVED == (tUPA_View_Change_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         // event to check signal value
         m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__VIEW_CHANGE_REQUEST_CHANGE);
      }
      else if (CSM_C_SIGNAL_TIMEOUT & tUPA_View_Change_Request.u32Status)
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onVIEW_CH_REQ_Short_5C2Status() :  signal timeout!                         "));
      
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
         }
      }
      else
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onVIEW_CH_REQ_Short_5C2Status() :  signal data NOK!                        "));
      }
   }      
   // dispvidctrl_tclClientVcan::onUPA_View_Change_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_RequestStatus(TUPA_BEEP_Sound_Request tUPA_BEEP_Sound_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_RequestStatus(): status: %08x, data: %d.", tUPA_BEEP_Sound_Request.u32Status , tUPA_BEEP_Sound_Request.UPA_BEEP_Sound_Request));
   // dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_RequestStatus: user specific code start
   m_u32BeepReqStatus = tUPA_BEEP_Sound_Request.u32Status;
   m_u8BeepReqValue   = tUPA_BEEP_Sound_Request.UPA_BEEP_Sound_Request;
   
   if (m_poControl_Avm)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tUPA_BEEP_Sound_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         // read Beep Sound Type value
         vGetUPA_BEEP_Sound_Type();
         ETG_TRACE_USR4(("  CL-VCAN :: BeepTypeStatus = ........................ %-40u", m_u32BeepTypeStatus));
         ETG_TRACE_USR4(("  CL-VCAN :: BeepTypeValue  = ........................ %-40u", m_u8BeepTypeValue));
      
         if (CSM_C_SIGNAL_ARRIVED == (m_u32BeepTypeStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
            if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
            {
               if (m_u8BeepTypeValue == 0x01)
               {
                  // event error beep
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__ERROR_BEEP);
               }
               else
               {
                  // event normal beep
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__NORMAL_BEEP);
               }
            }
         }
         else if (CSM_C_SIGNAL_TIMEOUT & m_u32BeepTypeStatus)
         {
            ETG_TRACE_USR4(("  CL-VCAN :: onBEEP_REQ_Short_5C2Status(): signal timout for BeepSoundType!                   "));
      
            if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
            {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
            }
         }
         else
         {
            /* data value for beep type could not be read */
            ETG_TRACE_USR4((" CL-VCAN:: onBEEP_REQ_Short_5C2Status(): reading BeepSoundType failed!           "));
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tUPA_BEEP_Sound_Request.u32Status )
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onBEEP_REQ_Short_5C2Status(): signal timout!                          "));
      
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
         }
      }
      else
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onBEEP_REQ_Short_5C2Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_AOD_Beep1_RequestStatus(TUPA_AOD_Beep1_Request tUPA_AOD_Beep1_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_AOD_Beep1_RequestStatus(): status: %08x, data: %d.", tUPA_AOD_Beep1_Request.u32Status , tUPA_AOD_Beep1_Request.UPA_AOD_Beep1_Request));
   // dispvidctrl_tclClientVcan::onUPA_AOD_Beep1_RequestStatus: user specific code start
   m_Status_u32AodBeep1Request = tUPA_AOD_Beep1_Request.u32Status;
   m_Value_u8AodBeep1Request   = tUPA_AOD_Beep1_Request.UPA_AOD_Beep1_Request;
   
   if (m_poControl_Avm)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tUPA_AOD_Beep1_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            // event AOD Beep1 signal did change
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__AOD_BEEP_1, (tU32) m_Value_u8AodBeep1Request);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tUPA_AOD_Beep1_Request.u32Status )
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onAOD_Beep1_Request_Short_5C2Status() : signal timeout!                         "));
      
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
         }
      }
      else
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onAOD_Beep1_Request_Short_5C2Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onUPA_AOD_Beep1_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_Setting_ITSStatus(TUPA_Setting_ITS tUPA_Setting_ITS) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_Setting_ITSStatus(): status: %08x, data: %d.", tUPA_Setting_ITS.u32Status , tUPA_Setting_ITS.UPA_Setting_ITS));
   // dispvidctrl_tclClientVcan::onUPA_Setting_ITSStatus: user specific code start
   m_u32SetITSStatus = tUPA_Setting_ITS.u32Status;
   m_u8SetITSValue   = tUPA_Setting_ITS.UPA_Setting_ITS;
   
   if (m_poControl_Avm)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tUPA_Setting_ITS.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            // event AVM Affordable Its signal did change
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__AFFORDABLE_ITS);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tUPA_Setting_ITS.u32Status )
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onSET_ITS_Short_5C2Status() : signal timeout!                         "));
      
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
         }
      }
      else
      {
         ETG_TRACE_USR4(("  CL-VCAN :: onSET_ITS_Short_5C2Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onUPA_Setting_ITSStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_MOD_StatusStatus(TUPA_MOD_Status tUPA_MOD_Status) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_MOD_StatusStatus(): status: %08x, data: %d.", tUPA_MOD_Status.u32Status , tUPA_MOD_Status.UPA_MOD_Status));
   // dispvidctrl_tclClientVcan::onUPA_MOD_StatusStatus: user specific code start
   if ( m_Config_u8VCANDiversity != DISPVIDCTRL_AllianceVCANSlot_Type_C1A )
   {
      m_u32MODStatusStatus = tUPA_MOD_Status.u32Status;
      m_u8MODStatusValue   = tUPA_MOD_Status.UPA_MOD_Status;
      
      if (m_poControl_Avm)
      {
         if (CSM_C_SIGNAL_ARRIVED == (tUPA_MOD_Status.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
            if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
            {
               // event AVM Affordable Its signal did change
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__AFFORDABLE_ITS);
            }
         }
         else if( CSM_C_SIGNAL_TIMEOUT & tUPA_MOD_Status.u32Status )
         {
            ETG_TRACE_USR4(("  CL-VCAN :: onMOD_Status_Short_5C2Status() : signal timeout!                         "));
         
            if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
            {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
            }
         }
         else
         {
            ETG_TRACE_USR4(("  CL-VCAN :: onMOD_Status_Short_5C2Status() : signal data NOK!                        "));
         }
      }
   }
   // dispvidctrl_tclClientVcan::onUPA_MOD_StatusStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_TypeStatus(TUPA_BEEP_Sound_Type tUPA_BEEP_Sound_Type) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_TypeStatus(): status: %08x, data: %d.", tUPA_BEEP_Sound_Type.u32Status , tUPA_BEEP_Sound_Type.UPA_BEEP_Sound_Type));
   // dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_TypeStatus: user specific code start
   m_u32BeepTypeStatus = tUPA_BEEP_Sound_Type.u32Status;
   m_u8BeepTypeValue   = tUPA_BEEP_Sound_Type.UPA_BEEP_Sound_Type;
   // dispvidctrl_tclClientVcan::onUPA_BEEP_Sound_TypeStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onSteering_AngleStatus(TSteering_Angle tSteering_Angle) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onSteering_AngleStatus(): status: %08x, data: %d.", tSteering_Angle.u32Status , tSteering_Angle.Steering_Angle));
   // dispvidctrl_tclClientVcan::onSteering_AngleStatus: user specific code start
    //read steering angle CAN Signal only from message ID 002
    if (m_Config_u8CameraSteeringMessageType == 0x00)
    {
       m_Status_u32SteeringAngle = tSteering_Angle.u32Status;
       m_Value_s16SteeringAngle = (tS16) ((tSteering_Angle.Steering_Angle[0] << 8) +
                                           tSteering_Angle.Steering_Angle[1]         );
    }
   // dispvidctrl_tclClientVcan::onSteering_AngleStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onCalibration_FlagStatus(TCalibration_Flag tCalibration_Flag) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onCalibration_FlagStatus(): status: %08x, data: %d.", tCalibration_Flag.u32Status , tCalibration_Flag.Calibration_Flag));
   // dispvidctrl_tclClientVcan::onCalibration_FlagStatus: user specific code start
   //read steering angle CAN Signal only from message ID 002
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientDiaglogIf);
   m_Status_u32CalibrationFlag = tCalibration_Flag.u32Status;
   m_Value_u8CalibrationFlag = tCalibration_Flag.Calibration_Flag;

   if (m_Config_u8CameraSteeringMessageType == 0x00)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32CalibrationFlag & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
          // fault condition: if the signal is received with Calibration Unfinished while RVC configured
          if ((0 == m_Value_u8CalibrationFlag) && (1 == m_bRvcMode))
          {
             //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): SteerFail flag is set"));
             // remember ITC relevant failure condition
             m_bItcSteeringFlagFail = TRUE;
             ETG_TRACE_USR4((" CSM-IF   :: onCalibration_FlagStatus(): SteerFail flag is set!"));

             //NCG3D-22060 start verification timer only if ACC and IGN is ON (error qualification unlocked)
             if (TRUE == m_bErrorQualificationUnlocked_SensorCalibration)
             {
                 //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): error qualification unlocked - start timer"));
                 if (FALSE == _bSetTimer_SteeringFail( (OSAL_tMSecond) DISPVIDCTRL_CLIENT_VCAN_STEERING_FAIL_RECHECK_TIME_IN_MS))
                 {
                    ETG_TRACE_USR4((" CSM-IF   :: onACTIVE_STEER_FAIL_002Status: Calibration flag says: failure!  Start verification timer failed! "));
                 }
             }
          }
          else // Calibration finished, clear the ITC is set already
          {
             //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): calibration finished"));
             m_bSteeringFlag_OK = TRUE;
             // ITC handling
             if ( TRUE == m_bItcSteeringFlagFail )
             {
                //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): Steering Fail flag was set -> stop timer"));
                //stop verification timer
                (tVoid) _bSetTimer_SteeringFail( (OSAL_tMSecond) 0);
                //reset ITC relevant failure
                m_bItcSteeringFlagFail = FALSE;
             }
             // NCG3D-22060 report ITC as passed minimum once after startup if no failure is present and not only when there was a failure condition in this operation cycle before
             // Reporting once is required to set back a failure state of previous operation cycle when failure condition is not present anymore.

             //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): Report ITC as PASSED"));
             // report ITC as Passed
             if (m_bRvcMode) {
               m_poClientDiaglogIf->vSetITC(enITC_ID_ANGLE_SENSOR_CALIBRATION, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
             } else {
               m_poClientDiaglogIf->vSetITC(enITC_ID_ANGLE_SENSOR_CALIBRATION, midw_fi_tcl_e8_TestResult::FI_EN_NORESULT);
             }
          }
      }
      // CAN signal not valid or CAN timeout, clear the ITC flag
      else
      {
          //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): CAM message timeout"));
          if ( TRUE == m_bItcSteeringFlagFail )
          {
              //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): Steering Fail flag was set -> stop timer"));
              //stop verification timer
              (tVoid) _bSetTimer_SteeringFail( (OSAL_tMSecond) 0);
              m_bItcSteeringFlagFail = FALSE;
          }
          //ETG_TRACE_USR1((" CSM-IF   :: onCalibration_FlagStatus(): Report ITC as UNKNOWN"));
          // report ITC as Unknown
          m_poClientDiaglogIf->vSetITC(enITC_ID_ANGLE_SENSOR_CALIBRATION, midw_fi_tcl_e8_TestResult::FI_EN_NORESULT);

         ETG_TRACE_USR4((" CSM-IF   :: onCalibration_FlagStatus(): state of ActiveSteerFail signal NOK! state = %-7x", m_Status_u32CalibrationFlag));
      }
   }
   // dispvidctrl_tclClientVcan::onCalibration_FlagStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onSteering_Sensor_Fail_FlagStatus(TSteering_Sensor_Fail_Flag tSteering_Sensor_Fail_Flag) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onSteering_Sensor_Fail_FlagStatus(): status: %08x, data: %d.", tSteering_Sensor_Fail_Flag.u32Status , tSteering_Sensor_Fail_Flag.Steering_Sensor_Fail_Flag));
   // dispvidctrl_tclClientVcan::onSteering_Sensor_Fail_FlagStatus: user specific code start
   //read steering angle CAN Signal only from message ID 002
   if (m_Config_u8CameraSteeringMessageType == 0x00)
   {
      m_Status_u32SteeringSensorFailFlag = tSteering_Sensor_Fail_Flag.u32Status;
      m_Value_u8SteeringsensorFailFlag = tSteering_Sensor_Fail_Flag.Steering_Sensor_Fail_Flag;
   }
   // dispvidctrl_tclClientVcan::onSteering_Sensor_Fail_FlagStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onSwaSensorInternalStatusStatus(TSwaSensorInternalStatus tSwaSensorInternalStatus) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onSwaSensorInternalStatusStatus(): status: %08x, data: %d.", tSwaSensorInternalStatus.u32Status , tSwaSensorInternalStatus.SwaSensorInternalStatus));
   // dispvidctrl_tclClientVcan::onSwaSensorInternalStatusStatus: user specific code start
   m_Status_u32SwaSensorInternalStatus = tSwaSensorInternalStatus.u32Status;
   m_Value_u8SwaSensorInternalStatus = tSwaSensorInternalStatus.SwaSensorInternalStatus;
   // dispvidctrl_tclClientVcan::onSwaSensorInternalStatusStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFRONT_STEER_PINION_ANGLEStatus(TFRONT_STEER_PINION_ANGLE tFRONT_STEER_PINION_ANGLE) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFRONT_STEER_PINION_ANGLEStatus(): status: %08x, data: %d.", tFRONT_STEER_PINION_ANGLE.u32Status , tFRONT_STEER_PINION_ANGLE.FRONT_STEER_PINION_ANGLE));
   // dispvidctrl_tclClientVcan::onFRONT_STEER_PINION_ANGLEStatus: user specific code start
   //read steering angle CAN Signal only from message ID 0C1
   if (m_Config_u8CameraSteeringMessageType == 0x01)
   {
      m_Status_u32FrontSteerPinionAngle = tFRONT_STEER_PINION_ANGLE.u32Status;
      m_Value_s16FrontSteerPinionAngle = (tS16) ((tFRONT_STEER_PINION_ANGLE.FRONT_STEER_PINION_ANGLE[0] << 8) +
                                                  tFRONT_STEER_PINION_ANGLE.FRONT_STEER_PINION_ANGLE[1]         );
   }
   // dispvidctrl_tclClientVcan::onFRONT_STEER_PINION_ANGLEStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onACTIVE_STEER_FAILStatus(TACTIVE_STEER_FAIL tACTIVE_STEER_FAIL) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onACTIVE_STEER_FAILStatus(): status: %08x, data: %d.", tACTIVE_STEER_FAIL.u32Status , tACTIVE_STEER_FAIL.ACTIVE_STEER_FAIL));
   // dispvidctrl_tclClientVcan::onACTIVE_STEER_FAILStatus: user specific code start
   //read steering angle CAN Signal only from message ID 0C1
   if (m_Config_u8CameraSteeringMessageType == 0x01)
   {
      m_Status_u32ActiveSteerFail = tACTIVE_STEER_FAIL.u32Status;
      m_Value_u8ActiveSteerFail = tACTIVE_STEER_FAIL.ACTIVE_STEER_FAIL;
      /*tBool bFailure = TRUE;
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32ActiveSteerFail & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         // failure condition 2: Fail flag is set
         if (1 == m_Value_u8ActiveSteerFail)
         {
            // remember ITC relevant failure condition
            m_bItcSteeringFlagFail = TRUE;
            ETG_TRACE_USR4((" CSM-IF   :: onACTIVE_STEER_FAIL_0C1Status(): ActiveSteerFail flag is set!"));
         }
         // no failure exists
         else
         {
            bFailure = FALSE;
            m_bSteeringFlag_OK = TRUE;
            // ITC handling
            if (TRUE == m_bItcSteeringFlagFail)
            {
               //stop verification timer
               (tVoid) _bSetTimer_SteeringFail( (OSAL_tMSecond) 0);
               //reset ITC relevant failure
               m_bItcSteeringFlagFail = FALSE;
               // report ITC as Passed
               if (m_poClientDiaglogIf)
               {
                  m_poClientDiaglogIf->vSetITC(enITC_ID_ANGLE_SENSOR_CALIBRATION, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
               }
            }
         }
      }
      //failure condition 1: CAN signal not valid or CAN timeout
      else
      {
         m_bItcSteeringFlagFail = TRUE;
         ETG_TRACE_USR4((" CSM-IF   :: onACTIVE_STEER_FAIL_0C1Status(): state of ActiveSteerFail signal NOK! state = %-7x", m_Status_u32ActiveSteerFail));
      }

      //start verification timer
      if (bFailure == TRUE)
      {
         if (FALSE ==_bSetTimer_SteeringFail( (OSAL_tMSecond) DISPVIDCTRL_CLIENT_VCAN_STEERING_FAIL_RECHECK_TIME_IN_MS))
         {
            ETG_TRACE_USR4((" CSM-IF   :: onACTIVE_STEER_FAIL_0C1Status: ActiveSteerFail flag says: failure!  Start verification timer failed! "));
         }
      }*/
   }
   // dispvidctrl_tclClientVcan::onACTIVE_STEER_FAILStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onVehicleSpeedStatus(TVehicleSpeed tVehicleSpeed) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onVehicleSpeedStatus(): status: %08x, data: %d.", tVehicleSpeed.u32Status , tVehicleSpeed.VehicleSpeed));
   // dispvidctrl_tclClientVcan::onVehicleSpeedStatus: user specific code start
   m_Status_u32VehicleSpeed = tVehicleSpeed.u32Status;
   m_Value_u32VehicleSpeed = (tU32) ((tVehicleSpeed.VehicleSpeed[1] << 8) | (tVehicleSpeed.VehicleSpeed[0]));
   // dispvidctrl_tclClientVcan::onVehicleSpeedStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Mode_Change_RequestStatus(TIPA_Mode_Change_Request tIPA_Mode_Change_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Mode_Change_RequestStatus(): status: %08x, data: %d.", tIPA_Mode_Change_Request.u32Status , tIPA_Mode_Change_Request.IPA_Mode_Change_Request));
   // dispvidctrl_tclClientVcan::onIPA_Mode_Change_RequestStatus: user specific code start
    m_Value_bIPAMode = (tBool) tIPA_Mode_Change_Request.IPA_Mode_Change_Request;
    m_Status_u32IPAMode = tIPA_Mode_Change_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
   if (m_poControl_Avm && m_bIpaMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tIPA_Mode_Change_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              if ( m_Value_bIPAMode == 0x00 )
              {
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_REQUEST_NORMAL);
              }
              else if ( m_Value_bIPAMode == 0x01 )
              {
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_REQUEST_IPA);
              }
          }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Mode_Change_Request.u32Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Mode_Change_RequestStatus() : signal timeout!                         "));
      
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Mode_Change_RequestStatus() : signal data NOK!                        "));
      }
   }      
#endif
   // dispvidctrl_tclClientVcan::onIPA_Mode_Change_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Display_RequestStatus(TIPA_Switch_Display_Request tIPA_Switch_Display_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Display_RequestStatus(): status: %08x, data: %d.", tIPA_Switch_Display_Request.u32Status , tIPA_Switch_Display_Request.IPA_Switch_Display_Request));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Display_RequestStatus: user specific code start
    m_Value_u8IPASwitchDisplay = (tU8) tIPA_Switch_Display_Request.IPA_Switch_Display_Request;
    m_Status_u32IPASwitchDisplay = tIPA_Switch_Display_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
   if (m_poControl_Avm && m_bIpaMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Display_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_REQUEST_CHANGE);
          }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Display_Request.u32Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Display_RequestStatus() : signal timeout!                         "));
      
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Display_RequestStatus() : signal data NOK!                        "));
      }
   }      
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Display_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_mask_RequestStatus(TIPA_Switch_mask_Request tIPA_Switch_mask_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_mask_RequestStatus(): status: %08x, data: %d.", tIPA_Switch_mask_Request.u32Status , tIPA_Switch_mask_Request.IPA_Switch_mask_Request));
   // dispvidctrl_tclClientVcan::onIPA_Switch_mask_RequestStatus: user specific code start
    m_Value_u8IPASwitchMask = (tBool) tIPA_Switch_mask_Request.IPA_Switch_mask_Request;
    m_Status_u32IPASwitchMask = tIPA_Switch_mask_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
   if (m_poControl_Avm && m_bIpaMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_mask_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
          }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_mask_Request.u32Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_mask_RequestStatus() : signal timeout!                         "));
      
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_mask_RequestStatus() : signal data NOK!                        "));
      }
   }      
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_mask_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_01Status(TIPA_Switch_Gray_Out_Request_01 tIPA_Switch_Gray_Out_Request_01) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_01Status(): status: %08x, data: %d.", tIPA_Switch_Gray_Out_Request_01.u32Status , tIPA_Switch_Gray_Out_Request_01.IPA_Switch_Gray_Out_Request_01));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_01Status: user specific code start
    m_Value_bIPASwitchRequest01 = (tBool) tIPA_Switch_Gray_Out_Request_01.IPA_Switch_Gray_Out_Request_01;
    m_Status_u32IPASwitchRequest01 = tIPA_Switch_Gray_Out_Request_01.u32Status; 

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Gray_Out_Request_01.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Gray_Out_Request_01.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_01Status() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_01Status() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_01Status: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_02Status(TIPA_Switch_Gray_Out_Request_02 tIPA_Switch_Gray_Out_Request_02) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_02Status(): status: %08x, data: %d.", tIPA_Switch_Gray_Out_Request_02.u32Status , tIPA_Switch_Gray_Out_Request_02.IPA_Switch_Gray_Out_Request_02));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_02Status: user specific code start
    m_Value_bIPASwitchRequest02 = (tBool) tIPA_Switch_Gray_Out_Request_02.IPA_Switch_Gray_Out_Request_02;
    m_Status_u32IPASwitchRequest02 = tIPA_Switch_Gray_Out_Request_02.u32Status; 

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Gray_Out_Request_02.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Gray_Out_Request_02.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_02Status() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_02Status() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_02Status: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_03Status(TIPA_Switch_Gray_Out_Request_03 tIPA_Switch_Gray_Out_Request_03) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_03Status(): status: %08x, data: %d.", tIPA_Switch_Gray_Out_Request_03.u32Status , tIPA_Switch_Gray_Out_Request_03.IPA_Switch_Gray_Out_Request_03));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_03Status: user specific code start
    m_Value_bIPASwitchRequest03 = (tBool) tIPA_Switch_Gray_Out_Request_03.IPA_Switch_Gray_Out_Request_03;
    m_Status_u32IPASwitchRequest03 = tIPA_Switch_Gray_Out_Request_03.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Gray_Out_Request_03.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Gray_Out_Request_03.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_03Status() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_03Status() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_03Status: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_04Status(TIPA_Switch_Gray_Out_Request_04 tIPA_Switch_Gray_Out_Request_04) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_04Status(): status: %08x, data: %d.", tIPA_Switch_Gray_Out_Request_04.u32Status , tIPA_Switch_Gray_Out_Request_04.IPA_Switch_Gray_Out_Request_04));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_04Status: user specific code start
    m_Value_bIPASwitchRequest04 = (tBool) tIPA_Switch_Gray_Out_Request_04.IPA_Switch_Gray_Out_Request_04;
    m_Status_u32IPASwitchRequest04 = tIPA_Switch_Gray_Out_Request_04.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Gray_Out_Request_04.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Gray_Out_Request_04.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_04Status() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_04Status() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_04Status: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_05Status(TIPA_Switch_Gray_Out_Request_05 tIPA_Switch_Gray_Out_Request_05) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_05Status(): status: %08x, data: %d.", tIPA_Switch_Gray_Out_Request_05.u32Status , tIPA_Switch_Gray_Out_Request_05.IPA_Switch_Gray_Out_Request_05));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_05Status: user specific code start
    m_Value_bIPASwitchRequest05 = (tBool) tIPA_Switch_Gray_Out_Request_05.IPA_Switch_Gray_Out_Request_05;
    m_Status_u32IPASwitchRequest05 = tIPA_Switch_Gray_Out_Request_05.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Gray_Out_Request_05.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Gray_Out_Request_05.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_05Status() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_05Status() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_05Status: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_06Status(TIPA_Switch_Gray_Out_Request_06 tIPA_Switch_Gray_Out_Request_06) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_06Status(): status: %08x, data: %d.", tIPA_Switch_Gray_Out_Request_06.u32Status , tIPA_Switch_Gray_Out_Request_06.IPA_Switch_Gray_Out_Request_06));
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_06Status: user specific code start
    m_Value_bIPASwitchRequest06 = (tBool) tIPA_Switch_Gray_Out_Request_06.IPA_Switch_Gray_Out_Request_06;
    m_Status_u32IPASwitchRequest06 = tIPA_Switch_Gray_Out_Request_06.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
   if (m_poControl_Avm && m_bIpaMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (tIPA_Switch_Gray_Out_Request_06.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SWITCHES_CHANGE);
          }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Switch_Gray_Out_Request_06.u32Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_06Status() : signal timeout!                         "));
      
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Switch_Gray_Out_Request_06Status() : signal data NOK!                        "));
      }
   }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Switch_Gray_Out_Request_06Status: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_mode_selectionStatus(TIPA_mode_selection tIPA_mode_selection) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_mode_selectionStatus(): status: %08x, data: %d.", tIPA_mode_selection.u32Status , tIPA_mode_selection.IPA_mode_selection));
   // dispvidctrl_tclClientVcan::onIPA_mode_selectionStatus: user specific code start
    m_Value_u8IPAModeSelection = tIPA_mode_selection.IPA_mode_selection;
    m_Status_u32IPAModeSelection = tIPA_mode_selection.u32Status;
   // dispvidctrl_tclClientVcan::onIPA_mode_selectionStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Message_Display_RequestStatus(TIPA_Message_Display_Request tIPA_Message_Display_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Message_Display_RequestStatus(): status: %08x, data: %d.", tIPA_Message_Display_Request.u32Status , tIPA_Message_Display_Request.IPA_Message_Display_Request));
   // dispvidctrl_tclClientVcan::onIPA_Message_Display_RequestStatus: user specific code start
    m_Value_u8IPAMessageDisplay = tIPA_Message_Display_Request.IPA_Message_Display_Request;
    m_Status_u32IPAMessageDisplay = tIPA_Message_Display_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Message_Display_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_REQUEST_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Message_Display_Request.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Message_Display_RequestStatus() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Message_Display_RequestStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Message_Display_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Sound_Output_RequestStatus(TIPA_Sound_Output_Request tIPA_Sound_Output_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Sound_Output_RequestStatus(): status: %08x, data: %d.", tIPA_Sound_Output_Request.u32Status , tIPA_Sound_Output_Request.IPA_Sound_Output_Request));
   // dispvidctrl_tclClientVcan::onIPA_Sound_Output_RequestStatus: user specific code start
    m_Value_u8IPASoundOutput = tIPA_Sound_Output_Request.IPA_Sound_Output_Request;
    m_Status_u32IPASoundOutput = tIPA_Sound_Output_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Sound_Output_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_SOUND_OUTPUT_REQUEST, (tU32) m_Value_u8IPASoundOutput);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Sound_Output_Request.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Sound_Output_RequestStatus() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Sound_Output_RequestStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Sound_Output_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Voice_Output_RequestStatus(TIPA_Voice_Output_Request tIPA_Voice_Output_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Voice_Output_RequestStatus(): status: %08x, data: %d.", tIPA_Voice_Output_Request.u32Status , tIPA_Voice_Output_Request.IPA_Voice_Output_Request));
   // dispvidctrl_tclClientVcan::onIPA_Voice_Output_RequestStatus: user specific code start
    m_Value_u8IPAVoiceOutput = tIPA_Voice_Output_Request.IPA_Voice_Output_Request;
    m_Status_u32IPAVoiceOutput = tIPA_Voice_Output_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Voice_Output_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_VOICE_OUTPUT_REQUEST, (tU32) m_Value_u8IPAVoiceOutput);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Voice_Output_Request.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Voice_Output_RequestStatus() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Voice_Output_RequestStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Voice_Output_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_region_selectionStatus(TIPA_region_selection tIPA_region_selection) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_region_selectionStatus(): status: %08x, data: %d.", tIPA_region_selection.u32Status , tIPA_region_selection.IPA_region_selection));
   // dispvidctrl_tclClientVcan::onIPA_region_selectionStatus: user specific code start
    m_Value_u8IPARegionSelection = tIPA_region_selection.IPA_region_selection;
    m_Status_u32IPARegionSelection = tIPA_region_selection.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_region_selection.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_CONFIGURATION_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_region_selection.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_region_selectionStatus() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_region_selectionStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_region_selectionStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_Camera_Indicator_RequestStatus(TIPA_Camera_Indicator_Request tIPA_Camera_Indicator_Request) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_Camera_Indicator_RequestStatus(): status: %08x, data: %d.", tIPA_Camera_Indicator_Request.u32Status , tIPA_Camera_Indicator_Request.IPA_Camera_Indicator_Request));
   // dispvidctrl_tclClientVcan::onIPA_Camera_Indicator_RequestStatus: user specific code start
    m_Value_u8IPACameraIndicatorReq = tIPA_Camera_Indicator_Request.IPA_Camera_Indicator_Request;
    m_Status_u32IPACameraIndicatorReq = tIPA_Camera_Indicator_Request.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Camera_Indicator_Request.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_DIRECTION_CHANGE);
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Camera_Indicator_Request.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Camera_Indicator_RequestStatus() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_Camera_Indicator_RequestStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_Camera_Indicator_RequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onIPA_MulfunctionStatus(TIPA_Mulfunction tIPA_Mulfunction) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onIPA_MulfunctionStatus(): status: %08x, data: %d.", tIPA_Mulfunction.u32Status , tIPA_Mulfunction.IPA_Mulfunction));
   // dispvidctrl_tclClientVcan::onIPA_MulfunctionStatus: user specific code start
    m_Value_u8IPAMalfunction = tIPA_Mulfunction.IPA_Mulfunction;
    m_Status_u32IPAMalfunction = tIPA_Mulfunction.u32Status;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    if (m_poControl_Avm && m_bIpaMode)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tIPA_Mulfunction.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {      
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               if ( m_Value_u8IPAMalfunction == 0x00 )
               {
                   m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_OPERATION_NORMAL);
               }
               else if ( m_Value_u8IPAMalfunction == 0x01 )
               {
                   m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_OPERATION_MALFUNCTION);
               }
           }
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tIPA_Mulfunction.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_MulfunctionStatus() : signal timeout!                         "));
       
           if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
           {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
           }
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onIPA_MulfunctionStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onIPA_MulfunctionStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onRearGearEngagedStatus(TRearGearEngaged tRearGearEngaged) {
   /* ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onRearGearEngagedStatus(): status: %08x, data: %d.", tRearGearEngaged.u32Status , tRearGearEngaged.RearGearEngaged));
    if(true == dispvidctrl_tclAppMain::theServer()->getReverseConfiguredStatus())
    {
      m_Status_u32RearGearEngaged = tRearGearEngaged.u32Status;
      m_u8RearGearEngaged = tRearGearEngaged.RearGearEngaged;
      
	   if((m_u8RearGearEngaged == 1) && (FALSE == dispvidctrl_tclAppMain::theServer()->getSafeState()))
	   {
			tChar strIfName[] = "";
			dispvidctrl_tclAppMain::theServer()->SetReverseCamRequest(TRUE);
			dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOnDebounced(strIfName);
	   }
	   else
	   {
		   dispvidctrl_tclAppMain::theServer()->SetReverseCamRequest(FALSE);
		   if(FALSE ==  dispvidctrl_tclAppMain::theServer()->getReverseGearStatusfromCAN())
		   {
			 tChar strIfName[] = "";
			 dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOff(strIfName);
		   }
	   }
   
    }*/
}

void dispvidctrl_tclClientVcan::onMVC_ViewModeStatusStatus(TMVC_ViewModeStatus tMVC_ViewModeStatus) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onMVC_ViewModeStatusStatus(): status: %08x, data: %d.", tMVC_ViewModeStatus.u32Status , tMVC_ViewModeStatus.MVC_ViewModeStatus));
   // dispvidctrl_tclClientVcan::onMVC_ViewModeStatusStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   if (m_bMvcMode && m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_T4VS)
   {
      m_Value_u8MVC_ViewModeStatus = tMVC_ViewModeStatus.MVC_ViewModeStatus;
      m_Status_u32MVC_ViewModeStatus = tMVC_ViewModeStatus.u32Status;
      
      if (m_poControl_Mvc)
      {
         if (CSM_C_SIGNAL_ARRIVED == (tMVC_ViewModeStatus.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
             if (m_enMvcCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__VIEW_MODE_CHANGED);         
             }
             else
             {
                 m_enMvcCanMsgTimeOutState = TIMEOUT_FALSE;
                 m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__CAN_MSG_TIMEOUT_FALSE);
                 _bSetTimer_FrameTimeoutConfirmed(0); // Stop the timer, CAN Frame is Valid
             }
         }
         else if( CSM_C_SIGNAL_TIMEOUT & tMVC_ViewModeStatus.u32Status )
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onMVC_ViewModeStatusStatus() : signal timeout!                         "));
         
             if (m_enMvcCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                 m_enMvcCanMsgTimeOutState = TIMEOUT_TRUE;
                 m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__CAN_MSG_TIMEOUT_TRUE);
                 _bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
             }
         }
         else
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onMVC_ViewModeStatusStatus() : signal data NOK!                        "));
         }
      }
   }
#endif
   // dispvidctrl_tclClientVcan::onMVC_ViewModeStatusStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onMVC_WarningDisplayRequestStatus(TMVC_WarningDisplayRequest tMVC_WarningDisplayRequest) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onMVC_WarningDisplayRequestStatus(): status: %08x, data: %d.", tMVC_WarningDisplayRequest.u32Status , tMVC_WarningDisplayRequest.MVC_WarningDisplayRequest));
   // dispvidctrl_tclClientVcan::onMVC_WarningDisplayRequestStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   if (m_bMvcMode && m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_T4VS)
   {
      m_Value_u8MVC_WarningDisplayRequest = tMVC_WarningDisplayRequest.MVC_WarningDisplayRequest;
      m_Status_u32MVC_WarningDisplayRequest = tMVC_WarningDisplayRequest.u32Status;
      
      if (m_poControl_Mvc)
      {
         if (CSM_C_SIGNAL_ARRIVED == (tMVC_WarningDisplayRequest.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
             if (m_enMvcCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                 m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__WARNING_DISPLAY_STATUS_UPDATE, m_Value_u8MVC_WarningDisplayRequest);
             }
         }
         else if( CSM_C_SIGNAL_TIMEOUT & tMVC_WarningDisplayRequest.u32Status )
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onMVC_WarningDisplayRequestStatus() : signal timeout!                         "));
         
             if (m_enMvcCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                 m_enMvcCanMsgTimeOutState = TIMEOUT_TRUE;
                 m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__CAN_MSG_TIMEOUT_TRUE);
                 _bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
             }
         }
         else
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onMVC_WarningDisplayRequestStatus() : signal data NOK!                        "));
         }
      }
   }
#endif
   // dispvidctrl_tclClientVcan::onMVC_WarningDisplayRequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onTailGateStatusStatus(TTailGateStatus tTailGateStatus) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onTailGateStatusStatus(): status: %08x, data: %d.", tTailGateStatus.u32Status , tTailGateStatus.TailGateStatus));
   // dispvidctrl_tclClientVcan::onTailGateStatusStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    m_Value_u8TailGateStatus = tTailGateStatus.TailGateStatus;
    m_Status_u32TailGateStatus = tTailGateStatus.u32Status;
    
    if (m_poControl_Hmi)
    {
       if (CSM_C_SIGNAL_ARRIVED == (tTailGateStatus.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
       {
           m_poControl_Hmi->vHandleControl(EN_CONTROL_HMI__TAILGATE_STATUS, m_Value_u8TailGateStatus);
       }
       else if( CSM_C_SIGNAL_TIMEOUT & tTailGateStatus.u32Status )
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onTailGateStatusStatus() : signal timeout!                         "));
       }
       else
       {
           ETG_TRACE_USR4(("  CL-VCAN :: onTailGateStatusStatus() : signal data NOK!                        "));
       }
    }
#endif
   // dispvidctrl_tclClientVcan::onTailGateStatusStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_ChangeViewStatusStatus(TAVM_ChangeViewStatus tAVM_ChangeViewStatus) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_ChangeViewStatusStatus(): status: %08x, data: %d.", tAVM_ChangeViewStatus.u32Status , tAVM_ChangeViewStatus.AVM_ChangeViewStatus));
   // dispvidctrl_tclClientVcan::onAVM_ChangeViewStatusStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   // Only valid for C1A Frame ID 0x5B3
   if (m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_C1A)
   {
      m_Status_u32AVM_ChangeViewStatus = tAVM_ChangeViewStatus.u32Status;
      m_value_u8AVM_ChangeViewStatus   = tAVM_ChangeViewStatus.AVM_ChangeViewStatus;
      
      if (m_poControl_Avm)
      {
         if (CSM_C_SIGNAL_ARRIVED == (tAVM_ChangeViewStatus.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
             if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                 m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CURRENT_VIEW_STATUS, m_value_u8AVM_ChangeViewStatus);
             }
         }
         else if( CSM_C_SIGNAL_TIMEOUT & tAVM_ChangeViewStatus.u32Status )
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onAVM_ChangeViewStatusStatus() : signal timeout!                         "));
         
             if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                 m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
                 m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
                 _bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
             }
         }
         else
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onAVM_ChangeViewStatusStatus() : signal data NOK!                        "));
         }
      }
   }
#endif
   // dispvidctrl_tclClientVcan::onAVM_ChangeViewStatusStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_ClosingAuthorizationStatus(TAVM_ClosingAuthorization tAVM_ClosingAuthorization) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_ClosingAuthorizationStatus(): status: %08x, data: %d.", tAVM_ClosingAuthorization.u32Status , tAVM_ClosingAuthorization.AVM_ClosingAuthorization));
   // dispvidctrl_tclClientVcan::onAVM_ClosingAuthorizationStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   // Only valid for C1A Frame ID 0x5B3
   if (m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_C1A)
   {
      m_Status_u32AVM_ClosingAuthorization = tAVM_ClosingAuthorization.u32Status;
      m_value_u8AVM_ClosingAuthorization = tAVM_ClosingAuthorization.AVM_ClosingAuthorization;
      
      if (m_poControl_Avm)
      {
         if (CSM_C_SIGNAL_ARRIVED == (tAVM_ClosingAuthorization.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
             if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
             {
//todo : Add a new control event in AVM to handle this special requirement for C1A
                 m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__VIEW_EXIT_ALLOWED_STATUS, m_value_u8AVM_ClosingAuthorization);
             }
         }
         else if( CSM_C_SIGNAL_TIMEOUT & tAVM_ClosingAuthorization.u32Status )
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onAVM_ClosingAuthorizationStatus() : signal timeout!                         "));
         
             if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
             {
                 m_enAvmCanMsgTimeOutState= TIMEOUT_TRUE;
                 m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
                 _bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
             }
         }
         else
         {
             ETG_TRACE_USR4(("  CL-VCAN :: onAVM_ClosingAuthorizationStatus() : signal data NOK!                        "));
         }
      }
   }
#endif
   // dispvidctrl_tclClientVcan::onAVM_ClosingAuthorizationStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onMOD_ActivationStateStatus(TMOD_ActivationState tMOD_ActivationState) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onMOD_ActivationStateStatus(): status: %08x, data: %d.", tMOD_ActivationState.u32Status , tMOD_ActivationState.MOD_ActivationState));
   // dispvidctrl_tclClientVcan::onMOD_ActivationStateStatus: user specific code start
   if ( m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_C1A )
   {
      m_u32MODStatusStatus = tMOD_ActivationState.u32Status;
      m_u8MODStatusValue   = tMOD_ActivationState.MOD_ActivationState;
      
      if (m_poControl_Avm)
      {
         if (CSM_C_SIGNAL_ARRIVED == (tMOD_ActivationState.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
         {
            if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
            {
               // event AVM Affordable Its signal did change
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__AFFORDABLE_ITS);
            }
         }
         else if( CSM_C_SIGNAL_TIMEOUT & tMOD_ActivationState.u32Status )
         {
            ETG_TRACE_USR4(("  CL-VCAN :: onMOD_Status_Short_5C2Status() : signal timeout!                         "));
         
            if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
            {
               m_enAvmCanMsgTimeOutState = TIMEOUT_TRUE;
               m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
            }
         }
         else
         {
            ETG_TRACE_USR4(("  CL-VCAN :: onMOD_Status_Short_5C2Status() : signal data NOK!                        "));
         }
      }
   }
   // dispvidctrl_tclClientVcan::onMOD_ActivationStateStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_ModeChangeRequestStatus(TFAP_ModeChangeRequest tFAP_ModeChangeRequest) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_ModeChangeRequestStatus(): status: %08x, data: %d.", tFAP_ModeChangeRequest.u32Status , tFAP_ModeChangeRequest.FAP_ModeChangeRequest));
   // dispvidctrl_tclClientVcan::onFAP_ModeChangeRequestStatus: user specific code start
   m_Status_FAP_ModeChangeRequestStatus = tFAP_ModeChangeRequest.u32Status;
   m_Value_FAP_ModeChangeRequest = tFAP_ModeChangeRequest.FAP_ModeChangeRequest;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_ModeChangeRequestStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            // Broadcast the message for Control AVM and Control HMI
            dispvidctrl_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = dispvidctrl_tclBaseIf::eFapModeActive;
            oMsg.u.u8Data = m_Value_FAP_ModeChangeRequest;
            dispvidctrl_tclAppMain::theServer()->vPostInternalMessage(&oMsg);
         }
         else 
         {
            m_enFapCanMsgTimeOutState = TIMEOUT_FALSE;
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_FALSE);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_ModeChangeRequestStatus )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_ModeChangeRequestStatus() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_ModeChangeRequestStatus() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_ModeChangeRequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onCamerasetting_availabilityStatus(TCamerasetting_availability tCamerasetting_availability) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onCamerasetting_availabilityStatus(): status: %08x, data: %d.", tCamerasetting_availability.u32Status , tCamerasetting_availability.Camerasetting_availability));
   // dispvidctrl_tclClientVcan::onCamerasetting_availabilityStatus: user specific code start
   m_Status_Camerasetting_availabilityStatus = tCamerasetting_availability.u32Status;
   m_Value_Camerasetting_availability = tCamerasetting_availability.Camerasetting_availability;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_Camerasetting_availabilityStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_CAMERA_SETTING_AVAILABLE, (tU32) 0);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_Camerasetting_availabilityStatus )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onCamerasetting_availabilityStatus() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onCamerasetting_availabilityStatus() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onCamerasetting_availabilityStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting01Status(TFAP_Setting01 tFAP_Setting01) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting01Status(): status: %08x, data: %d.", tFAP_Setting01.u32Status , tFAP_Setting01.FAP_Setting01));
   // dispvidctrl_tclClientVcan::onFAP_Setting01Status: user specific code start
   m_Status_FAP_Setting01Status = tFAP_Setting01.u32Status;
   m_Value_FAP_Setting01 = tFAP_Setting01.FAP_Setting01;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting01Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING01);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting01Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting01Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting01Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting01Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting02Status(TFAP_Setting02 tFAP_Setting02) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting02Status(): status: %08x, data: %d.", tFAP_Setting02.u32Status , tFAP_Setting02.FAP_Setting02));
   // dispvidctrl_tclClientVcan::onFAP_Setting02Status: user specific code start
   m_Status_FAP_Setting02Status = tFAP_Setting02.u32Status;
   m_Value_FAP_Setting02 = tFAP_Setting02.FAP_Setting02;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting02Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING02);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting02Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting02Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting02Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting02Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting03Status(TFAP_Setting03 tFAP_Setting03) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting03Status(): status: %08x, data: %d.", tFAP_Setting03.u32Status , tFAP_Setting03.FAP_Setting03));
   // dispvidctrl_tclClientVcan::onFAP_Setting03Status: user specific code start
   m_Status_FAP_Setting03Status = tFAP_Setting03.u32Status;
   m_Value_FAP_Setting03 = tFAP_Setting03.FAP_Setting03;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting03Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING03);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting03Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting03Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting03Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting03Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting04Status(TFAP_Setting04 tFAP_Setting04) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting04Status(): status: %08x, data: %d.", tFAP_Setting04.u32Status , tFAP_Setting04.FAP_Setting04));
   // dispvidctrl_tclClientVcan::onFAP_Setting04Status: user specific code start
   m_Status_FAP_Setting04Status = tFAP_Setting04.u32Status;
   m_Value_FAP_Setting04 = tFAP_Setting04.FAP_Setting04;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting04Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING04);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting04Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting04Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting04Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting04Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting05Status(TFAP_Setting05 tFAP_Setting05) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting05Status(): status: %08x, data: %d.", tFAP_Setting05.u32Status , tFAP_Setting05.FAP_Setting05));
   // dispvidctrl_tclClientVcan::onFAP_Setting05Status: user specific code start
   m_Status_FAP_Setting05Status = tFAP_Setting05.u32Status;
   m_Value_FAP_Setting05 = tFAP_Setting05.FAP_Setting05;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting05Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING05);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting05Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting05Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting05Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting05Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting06Status(TFAP_Setting06 tFAP_Setting06) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting06Status(): status: %08x, data: %d.", tFAP_Setting06.u32Status , tFAP_Setting06.FAP_Setting06));
   // dispvidctrl_tclClientVcan::onFAP_Setting06Status: user specific code start
   m_Status_FAP_Setting06Status = tFAP_Setting06.u32Status;
   m_Value_FAP_Setting06 = tFAP_Setting06.FAP_Setting06;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting06Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING06);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting06Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting06Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting06Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting06Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting07Status(TFAP_Setting07 tFAP_Setting07) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting07Status(): status: %08x, data: %d.", tFAP_Setting07.u32Status , tFAP_Setting07.FAP_Setting07));
   // dispvidctrl_tclClientVcan::onFAP_Setting07Status: user specific code start
   m_Status_FAP_Setting07Status = tFAP_Setting07.u32Status;
   m_Value_FAP_Setting07 = tFAP_Setting07.FAP_Setting07;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting07Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING07);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting07Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting07Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting07Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting07Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting08Status(TFAP_Setting08 tFAP_Setting08) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting08Status(): status: %08x, data: %d.", tFAP_Setting08.u32Status , tFAP_Setting08.FAP_Setting08));
   // dispvidctrl_tclClientVcan::onFAP_Setting08Status: user specific code start
   m_Status_FAP_Setting08Status = tFAP_Setting08.u32Status;
   m_Value_FAP_Setting08 = tFAP_Setting08.FAP_Setting08;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting08Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING08);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting08Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting08Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting08Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting08Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting09Status(TFAP_Setting09 tFAP_Setting09) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting09Status(): status: %08x, data: %d.", tFAP_Setting09.u32Status , tFAP_Setting09.FAP_Setting09));
   // dispvidctrl_tclClientVcan::onFAP_Setting09Status: user specific code start
   m_Status_FAP_Setting09Status = tFAP_Setting09.u32Status;
   m_Value_FAP_Setting09 = tFAP_Setting09.FAP_Setting09;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting09Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING09);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting09Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting09Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting09Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting09Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_Setting10Status(TFAP_Setting10 tFAP_Setting10) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_Setting10Status(): status: %08x, data: %d.", tFAP_Setting10.u32Status , tFAP_Setting10.FAP_Setting10));
   // dispvidctrl_tclClientVcan::onFAP_Setting10Status: user specific code start
   m_Status_FAP_Setting10Status = tFAP_Setting10.u32Status;
   m_Value_FAP_Setting10 = tFAP_Setting10.FAP_Setting10;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_Setting10Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, FAP_SETTING_TYPE__FAP_SETTING10);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_Setting10Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting10Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_Setting10Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_Setting10Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_1Status(TAVM_Setting_1 tAVM_Setting_1) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_1Status(): status: %08x, data: %d.", tAVM_Setting_1.u32Status , tAVM_Setting_1.AVM_Setting_1));
   // dispvidctrl_tclClientVcan::onAVM_Setting_1Status: user specific code start
   m_Status_AVM_Setting_1Status = tAVM_Setting_1.u32Status;
   m_Value_AVM_Setting_1 = tAVM_Setting_1.AVM_Setting_1;

   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_1Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING01);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_1Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_1Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_1Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_1Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_2Status(TAVM_Setting_2 tAVM_Setting_2) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_2Status(): status: %08x, data: %d.", tAVM_Setting_2.u32Status , tAVM_Setting_2.AVM_Setting_2));
   // dispvidctrl_tclClientVcan::onAVM_Setting_2Status: user specific code start
   m_Status_AVM_Setting_2Status = tAVM_Setting_2.u32Status;
   m_Value_AVM_Setting_2 = tAVM_Setting_2.AVM_Setting_2;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_2Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING02);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_2Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_2Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_2Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_2Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_3Status(TAVM_Setting_3 tAVM_Setting_3) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_3Status(): status: %08x, data: %d.", tAVM_Setting_3.u32Status , tAVM_Setting_3.AVM_Setting_3));
   // dispvidctrl_tclClientVcan::onAVM_Setting_3Status: user specific code start
   m_Status_AVM_Setting_3Status = tAVM_Setting_3.u32Status;
   m_Value_AVM_Setting_3 = tAVM_Setting_3.AVM_Setting_3;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_3Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING03);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_3Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_3Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_3Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_3Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_4Status(TAVM_Setting_4 tAVM_Setting_4) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_4Status(): status: %08x, data: %d.", tAVM_Setting_4.u32Status , tAVM_Setting_4.AVM_Setting_4));
   // dispvidctrl_tclClientVcan::onAVM_Setting_4Status: user specific code start
   m_Status_AVM_Setting_4Status = tAVM_Setting_4.u32Status;
   m_Value_AVM_Setting_4 = tAVM_Setting_4.AVM_Setting_4;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_4Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING04);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_4Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_4Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_4Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_4Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_5Status(TAVM_Setting_5 tAVM_Setting_5) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_5Status(): status: %08x, data: %d.", tAVM_Setting_5.u32Status , tAVM_Setting_5.AVM_Setting_5));
   // dispvidctrl_tclClientVcan::onAVM_Setting_5Status: user specific code start
   m_Status_AVM_Setting_5Status = tAVM_Setting_5.u32Status;
   m_Value_AVM_Setting_5 = tAVM_Setting_5.AVM_Setting_5;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_5Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING05);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_5Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_5Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_5Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_5Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_6Status(TAVM_Setting_6 tAVM_Setting_6) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_6Status(): status: %08x, data: %d.", tAVM_Setting_6.u32Status , tAVM_Setting_6.AVM_Setting_6));
   // dispvidctrl_tclClientVcan::onAVM_Setting_6Status: user specific code start
   m_Status_AVM_Setting_6Status = tAVM_Setting_6.u32Status;
   m_Value_AVM_Setting_6 = tAVM_Setting_6.AVM_Setting_6;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_6Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING06);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_6Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_6Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_6Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_6Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_7Status(TAVM_Setting_7 tAVM_Setting_7) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_7Status(): status: %08x, data: %d.", tAVM_Setting_7.u32Status , tAVM_Setting_7.AVM_Setting_7));
   // dispvidctrl_tclClientVcan::onAVM_Setting_7Status: user specific code start
   m_Status_AVM_Setting_7Status = tAVM_Setting_7.u32Status;
   m_Value_AVM_Setting_7 = tAVM_Setting_7.AVM_Setting_7;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_7Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING07);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_7Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_7Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_7Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_7Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_8Status(TAVM_Setting_8 tAVM_Setting_8) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_8Status(): status: %08x, data: %d.", tAVM_Setting_8.u32Status , tAVM_Setting_8.AVM_Setting_8));
   // dispvidctrl_tclClientVcan::onAVM_Setting_8Status: user specific code start
   m_Status_AVM_Setting_8Status = tAVM_Setting_8.u32Status;
   m_Value_AVM_Setting_8 = tAVM_Setting_8.AVM_Setting_8;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_8Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING08);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_8Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_8Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_8Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_8Status: user specific code end
}

void dispvidctrl_tclClientVcan::onAVM_Setting_9Status(TAVM_Setting_9 tAVM_Setting_9) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onAVM_Setting_9Status(): status: %08x, data: %d.", tAVM_Setting_9.u32Status , tAVM_Setting_9.AVM_Setting_9));
   // dispvidctrl_tclClientVcan::onAVM_Setting_9Status: user specific code start
   m_Status_AVM_Setting_9Status = tAVM_Setting_9.u32Status;
   m_Value_AVM_Setting_9 = tAVM_Setting_9.AVM_Setting_9;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_AVM_Setting_9Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS, FAP_SETTING_TYPE__AVM_SETTING09);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_AVM_Setting_9Status )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_9Status() : signal timeout!                         "));
      
          if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enFapCanMsgTimeOutState = TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onAVM_Setting_9Status() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onAVM_Setting_9Status: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_PurposeSwitchAvailabilityStatus(TFAP_PurposeSwitchAvailability tFAP_PurposeSwitchAvailability) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_PurposeSwitchAvailabilityStatus(): status: %08x, data: %d.", tFAP_PurposeSwitchAvailability.u32Status , tFAP_PurposeSwitchAvailability.FAP_PurposeSwitchAvailability));
   // dispvidctrl_tclClientVcan::onFAP_PurposeSwitchAvailabilityStatus: user specific code start
   m_Status_FAP_PurposeSwitchAvailabilityStatus = tFAP_PurposeSwitchAvailability.u32Status;
   m_Value_FAP_PurposeSwitchAvailability = tFAP_PurposeSwitchAvailability.FAP_PurposeSwitchAvailability;
   // dispvidctrl_tclClientVcan::onFAP_PurposeSwitchAvailabilityStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_ChangeViewRequestStatus(TFAP_ChangeViewRequest tFAP_ChangeViewRequest) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_ChangeViewRequestStatus(): status: %08x, data: %d.", tFAP_ChangeViewRequest.u32Status , tFAP_ChangeViewRequest.FAP_ChangeViewRequest));
   // dispvidctrl_tclClientVcan::onFAP_ChangeViewRequestStatus: user specific code start
   // This is a different CAN Frame 0x5F1 in Old Nissan (Nissan CAN Gen3)
   m_Status_FAP_ChangeViewRequestStatus = tFAP_ChangeViewRequest.u32Status;
   m_Value_FAP_ChangeViewRequest = tFAP_ChangeViewRequest.FAP_ChangeViewRequest;
   
   if (m_poControl_Avm && m_bFapMode)
   {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_ChangeViewRequestStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__VIEW_CHANGE_REQUEST_CHANGE);
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_ChangeViewRequestStatus )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_ChangeViewRequestStatus() : signal timeout!                         "));

          m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
          //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_ChangeViewRequestStatus() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_ChangeViewRequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_SoundDirectionStatus(TFAP_SoundDirection tFAP_SoundDirection) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_SoundDirectionStatus(): status: %08x, data: %d.", tFAP_SoundDirection.u32Status , tFAP_SoundDirection.FAP_SoundDirection));
   // dispvidctrl_tclClientVcan::onFAP_SoundDirectionStatus: user specific code start
   m_Status_FAP_SoundDirectionStatus = tFAP_SoundDirection.u32Status;
   m_Value_FAP_SoundDirection = tFAP_SoundDirection.FAP_SoundDirection;
   // dispvidctrl_tclClientVcan::onFAP_SoundDirectionStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_SoundLevelControlStatus(TFAP_SoundLevelControl tFAP_SoundLevelControl) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_SoundLevelControlStatus(): status: %08x, data: %d.", tFAP_SoundLevelControl.u32Status , tFAP_SoundLevelControl.FAP_SoundLevelControl));
   // dispvidctrl_tclClientVcan::onFAP_SoundLevelControlStatus: user specific code start
   m_Status_FAP_SoundLevelControlStatus = tFAP_SoundLevelControl.u32Status;
   m_Value_FAP_SoundLevelControl = tFAP_SoundLevelControl.FAP_SoundLevelControl;
   // dispvidctrl_tclClientVcan::onFAP_SoundLevelControlStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_SoundPatternRequestStatus(TFAP_SoundPatternRequest tFAP_SoundPatternRequest) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_SoundPatternRequestStatus(): status: %08x, data: %d.", tFAP_SoundPatternRequest.u32Status , tFAP_SoundPatternRequest.FAP_SoundPatternRequest));
   // dispvidctrl_tclClientVcan::onFAP_SoundPatternRequestStatus: user specific code start
   m_Status_FAP_SoundPatternRequestStatus = tFAP_SoundPatternRequest.u32Status;
   
   if (m_poControl_Avm && m_Value_FAP_SoundPatternRequest != tFAP_SoundPatternRequest.FAP_SoundPatternRequest)
   {
      m_Value_FAP_SoundPatternRequest = tFAP_SoundPatternRequest.FAP_SoundPatternRequest;
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_SoundPatternRequestStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SOUND_PATTERN_REQUEST, (tU32) m_Value_FAP_SoundPatternRequest);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_SoundPatternRequestStatus )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_SoundPatternRequestStatus() : signal timeout!                         "));
      
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enAvmCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_SoundPatternRequestStatus() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_SoundPatternRequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onFAP_VoicePatternRequestStatus(TFAP_VoicePatternRequest tFAP_VoicePatternRequest) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onFAP_VoicePatternRequestStatus(): status: %08x, data: %d.", tFAP_VoicePatternRequest.u32Status , tFAP_VoicePatternRequest.FAP_VoicePatternRequest));
   // dispvidctrl_tclClientVcan::onFAP_VoicePatternRequestStatus: user specific code start
   m_Status_FAP_VoicePatternRequestStatus = tFAP_VoicePatternRequest.u32Status;
   
   if (m_poControl_Avm && m_Value_FAP_VoicePatternRequest != tFAP_VoicePatternRequest.FAP_VoicePatternRequest)
   {
      m_Value_FAP_VoicePatternRequest = tFAP_VoicePatternRequest.FAP_VoicePatternRequest;
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_VoicePatternRequestStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_VOICE_PATTERN_REQUEST, (tU32) m_Value_FAP_VoicePatternRequest);
         }
      }
      else if( CSM_C_SIGNAL_TIMEOUT & m_Status_FAP_VoicePatternRequestStatus )
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_VoicePatternRequestStatus() : signal timeout!                         "));
      
          if (m_enAvmCanMsgTimeOutState == TIMEOUT_FALSE)
          {
              m_enAvmCanMsgTimeOutState= TIMEOUT_TRUE;
              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE);
              //_bSetTimer_FrameTimeoutConfirmed(DISPVIDCTRL_CLIENT_VCAN_TIMEOUT_CONFIRMATION_TIME_IN_MS);
          }
      }
      else
      {
          ETG_TRACE_USR4(("  CL-VCAN :: onFAP_VoicePatternRequestStatus() : signal data NOK!                        "));
      }
   }
   // dispvidctrl_tclClientVcan::onFAP_VoicePatternRequestStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onDayRheostatedLightMaxPercentStatus(TDayRheostatedLightMaxPercent tDayRheostatedLightMaxPercent) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onDayRheostatedLightMaxPercentStatus(): status: %08x, data: %d.", tDayRheostatedLightMaxPercent.u32Status , tDayRheostatedLightMaxPercent.DayRheostatedLightMaxPercent));
   // dispvidctrl_tclClientVcan::onDayRheostatedLightMaxPercentStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    tU8 u8Calculate_Matrix_COL_OFFSET = 10;
    if (CSM_C_SIGNAL_ARRIVED == (tDayRheostatedLightMaxPercent.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
    {
    	u8Calculate_Matrix_COL_OFFSET = (tU8)((tDayRheostatedLightMaxPercent.DayRheostatedLightMaxPercent) * RENAULT_CAN_MATRIX_OFFSET_FACTOR);
    	ETG_TRACE_USR4((": onDayRheostatedLightMaxPercentStatus -> CSM_C_SIGNAL_ARRIVED SUCCESS"));
    	ETG_TRACE_USR4((":Renault DAY:CAN -> u8Calculate_Matrix_COL_OFFSET = %d", u8Calculate_Matrix_COL_OFFSET));
    }
    else //Handle Failure Mode
    {
    	u8Calculate_Matrix_COL_OFFSET = 20; //(20 x 5 = 100% indicates full brightness value)
    	ETG_TRACE_USR4((": onDayRheostatedLightMaxPercentStatus -> CSM_C_SIGNAL_ARRIVED Failure Mode"));
      	ETG_TRACE_USR4((":Renault DAY:CAN -> u8Calculate_Matrix_COL_OFFSET = %d", u8Calculate_Matrix_COL_OFFSET));
    }

	if (OSAL_NULL != m_poClientINCIf) // && Mode = Day
	{
		tU8 u8Mode = m_poClientINCIf->u8GetLastDimmingMode_INCValue();

		if(u8Mode == 1 || u8Mode == 3) //If Day or AUTO_DAY: Only then Update Brightness to V850
		{
			ETG_TRACE_USR4((":Renault u8Mode(%d):CAN OFFSET = %d", u8Mode, u8Calculate_Matrix_COL_OFFSET));
			m_poClientINCIf->vLoadDataFromMeter(u8Calculate_Matrix_COL_OFFSET);
		}
	}
#endif

   // dispvidctrl_tclClientVcan::onDayRheostatedLightMaxPercentStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onNightRheostatedLightMaxPercentStatus(TNightRheostatedLightMaxPercent tNightRheostatedLightMaxPercent) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onNightRheostatedLightMaxPercentStatus(): status: %08x, data: %d.", tNightRheostatedLightMaxPercent.u32Status , tNightRheostatedLightMaxPercent.NightRheostatedLightMaxPercent));
   // dispvidctrl_tclClientVcan::onNightRheostatedLightMaxPercentStatus: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    tU8 u8Calculate_Matrix_COL_OFFSET = 10;

    if (CSM_C_SIGNAL_ARRIVED == (tNightRheostatedLightMaxPercent.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
	{
    	u8Calculate_Matrix_COL_OFFSET = (tU8)((tNightRheostatedLightMaxPercent.NightRheostatedLightMaxPercent) * RENAULT_CAN_MATRIX_OFFSET_FACTOR);
		ETG_TRACE_USR4((": onNightRheostatedLightMaxPercentStatus -> CSM_C_SIGNAL_ARRIVED SUCCESS"));
		ETG_TRACE_USR4((":Renault NIGHT:CAN -> u8Calculate_Matrix_COL_OFFSET = %d", u8Calculate_Matrix_COL_OFFSET));
	}
	else //Handle Failure Mode
	{
		u8Calculate_Matrix_COL_OFFSET = 20; //(20 x 5 = 100% indicates full brightness value)
		ETG_TRACE_USR4((": onNightRheostatedLightMaxPercentStatus -> CSM_C_SIGNAL_ARRIVED Failure Mode"));
		ETG_TRACE_USR4((":Renault NIGHT:CAN -> u8Calculate_Matrix_COL_OFFSET = %d", u8Calculate_Matrix_COL_OFFSET));
	}

	if (OSAL_NULL != m_poClientINCIf) // && Mode = Night
	{
		tU8 u8Mode = m_poClientINCIf->u8GetLastDimmingMode_INCValue();

		if(u8Mode == 2 || u8Mode == 4) //If Night or AUTO_Night : Only then Update Brightness to V850
		{
			ETG_TRACE_USR4((":Renault u8Mode(%d):CAN OFFSET = %d", u8Mode, u8Calculate_Matrix_COL_OFFSET));
			m_poClientINCIf->vLoadDataFromMeter(u8Calculate_Matrix_COL_OFFSET);
		}
	}
#endif
   // dispvidctrl_tclClientVcan::onNightRheostatedLightMaxPercentStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onDimmingStateStatus(TDimmingState tDimmingState) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onDimmingStateStatus(): status: %08x, data: %d.", tDimmingState.u32Status , tDimmingState.DimmingState));
   // dispvidctrl_tclClientVcan::onDimmingStateStatus: user specific code start
   // Change CAN cockpit slider value

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1

    tU8 u8StepSize =  tDimmingState.DimmingState;

    if (CSM_C_SIGNAL_ARRIVED == (tDimmingState.u32Status & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
	{
		ETG_TRACE_USR4((": onDimmingStateStatus -> CSM_C_SIGNAL_ARRIVED SUCCESS"));
	}
	else //Handle Failure Mode
	{
		ETG_TRACE_USR4((": onDimmingStateStatus -> CSM_C_SIGNAL_ARRIVED Failure Mode"));
	}

	if (OSAL_NULL != m_poClientINCIf) // && Mode = Night
	{
		tU8 u8Strategy = m_poClientINCIf->u8DimmingStrategy();

		if(u8Strategy == 1) // PARAMETer:  [0x01] by head-unit
		{
			if(u8StepSize > 0 && u8StepSize < 22) {
				ETG_TRACE_USR4((":Renault u8Strategy(%d): DimmingState Step = %d", u8Strategy, u8StepSize));
				//Update CCA HMI Slider offset for COckpit to display correct step size.
				dispvidctrl_tclServiceDimmingIf* pCCARef = dynamic_cast<dispvidctrl_tclServiceDimmingIf*>(_cpoMain->getHandler("dispvidctrl_tclServiceDimmingIf"));
				if(NULL != pCCARef)
				{
					tBool bPropertyChanged = TRUE;
					tU16 ErrorCode = 0;
					//This Single Function call will update HMI Slider value
					//and also Datapool and call V850 to change brightness
					ETG_TRACE_USR4((":Renault onDimmingStateStatus : Calling CCA onDIM_DISP_COCKPIT_SLIDER_OFFSETSet"));
					pCCARef->onDIM_DISP_COCKPIT_SLIDER_OFFSETSet((u8StepSize-1), bPropertyChanged, ErrorCode);
				}

			}
			else
			{
				ETG_TRACE_USR4((":Renault u8Strategy(%d): DimmingState Step OUT of RANGE = %d", u8Strategy, u8StepSize));
			}
		}
		else
		{
			ETG_TRACE_USR4((": onDimmingStateStatus -> u8DimmingStrategy is not HEAD-UNIT"));
		}
	}
#endif
   // dispvidctrl_tclClientVcan::onDimmingStateStatus: user specific code end
}

void dispvidctrl_tclClientVcan::onSTATUS_DYNAMIC_REARStatus(TSTATUS_DYNAMIC_REAR tSTATUS_DYNAMIC_REAR) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onSTATUS_DYNAMIC_REARStatus(): status: %08x, data: %d.", tSTATUS_DYNAMIC_REAR.u32Status , tSTATUS_DYNAMIC_REAR.STATUS_DYNAMIC_REAR));
   // dispvidctrl_tclClientVcan::onSTATUS_DYNAMIC_REARStatus: user specific code start
   m_Value_u8BciStatus   = tSTATUS_DYNAMIC_REAR.STATUS_DYNAMIC_REAR;
   m_Status_u32BciStatus = tSTATUS_DYNAMIC_REAR.u32Status;
   I_dispvidctrl_tclMCanClientAvm* pAvm3 = dynamic_cast<I_dispvidctrl_tclMCanClientAvm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvm"));
   if(pAvm3)
   {
       tU8   u8BciState;
       tBool bSigState = bGetBciStatus(u8BciState);
       pAvm3->vHandleDataEvent(I_dispvidctrl_tclMCanClientAvm::eIndBciState, u8BciState,bSigState);
   }
   // dispvidctrl_tclClientVcan::onSTATUS_DYNAMIC_REARStatus: user specific code end
}



tVoid dispvidctrl_tclClientVcan::vGetUPA_RX_Initializing() {
   TUPA_RX_Initializing tMyUPA_RX_Initializing;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_RX_Initializing(tMyUPA_RX_Initializing);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_RX_Initializing: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_RX_Initializing: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetUPA_View_Change_Request() {
   TUPA_View_Change_Request tMyUPA_View_Change_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_View_Change_Request(tMyUPA_View_Change_Request);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_View_Change_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_View_Change_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetUPA_BEEP_Sound_Request() {
   TUPA_BEEP_Sound_Request tMyUPA_BEEP_Sound_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_BEEP_Sound_Request(tMyUPA_BEEP_Sound_Request);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_BEEP_Sound_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_BEEP_Sound_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetUPA_AOD_Beep1_Request() {
   TUPA_AOD_Beep1_Request tMyUPA_AOD_Beep1_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_AOD_Beep1_Request(tMyUPA_AOD_Beep1_Request);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_AOD_Beep1_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_AOD_Beep1_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetUPA_Setting_ITS() {
   TUPA_Setting_ITS tMyUPA_Setting_ITS;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_Setting_ITS(tMyUPA_Setting_ITS);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_Setting_ITS: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_Setting_ITS: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetUPA_MOD_Status() {
   TUPA_MOD_Status tMyUPA_MOD_Status;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_MOD_Status(tMyUPA_MOD_Status);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_MOD_Status: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_MOD_Status: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetUPA_BEEP_Sound_Type() {
   TUPA_BEEP_Sound_Type tMyUPA_BEEP_Sound_Type;
   if (_pCsmBase) {
       _pCsmBase->vGetUPA_BEEP_Sound_Type(tMyUPA_BEEP_Sound_Type);
   }
   // dispvidctrl_tclClientVcan::vGetUPA_BEEP_Sound_Type: user specific code start
   // dispvidctrl_tclClientVcan::vGetUPA_BEEP_Sound_Type: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetSteering_Angle() {
   TSteering_Angle tMySteering_Angle;
   if (_pCsmBase) {
       _pCsmBase->vGetSteering_Angle(tMySteering_Angle);
   }
   // dispvidctrl_tclClientVcan::vGetSteering_Angle: user specific code start
   // dispvidctrl_tclClientVcan::vGetSteering_Angle: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetCalibration_Flag() {
   TCalibration_Flag tMyCalibration_Flag;
   if (_pCsmBase) {
       _pCsmBase->vGetCalibration_Flag(tMyCalibration_Flag);
   }
   // dispvidctrl_tclClientVcan::vGetCalibration_Flag: user specific code start
   // dispvidctrl_tclClientVcan::vGetCalibration_Flag: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetSteering_Sensor_Fail_Flag() {
   TSteering_Sensor_Fail_Flag tMySteering_Sensor_Fail_Flag;
   if (_pCsmBase) {
       _pCsmBase->vGetSteering_Sensor_Fail_Flag(tMySteering_Sensor_Fail_Flag);
   }
   // dispvidctrl_tclClientVcan::vGetSteering_Sensor_Fail_Flag: user specific code start
   // dispvidctrl_tclClientVcan::vGetSteering_Sensor_Fail_Flag: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetSwaSensorInternalStatus() {
   TSwaSensorInternalStatus tMySwaSensorInternalStatus;
   if (_pCsmBase) {
       _pCsmBase->vGetSwaSensorInternalStatus(tMySwaSensorInternalStatus);
   }
   // dispvidctrl_tclClientVcan::vGetSwaSensorInternalStatus: user specific code start
   // dispvidctrl_tclClientVcan::vGetSwaSensorInternalStatus: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFRONT_STEER_PINION_ANGLE() {
   TFRONT_STEER_PINION_ANGLE tMyFRONT_STEER_PINION_ANGLE;
   if (_pCsmBase) {
       _pCsmBase->vGetFRONT_STEER_PINION_ANGLE(tMyFRONT_STEER_PINION_ANGLE);
   }
   // dispvidctrl_tclClientVcan::vGetFRONT_STEER_PINION_ANGLE: user specific code start
   // dispvidctrl_tclClientVcan::vGetFRONT_STEER_PINION_ANGLE: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetACTIVE_STEER_FAIL() {
   TACTIVE_STEER_FAIL tMyACTIVE_STEER_FAIL;
   if (_pCsmBase) {
       _pCsmBase->vGetACTIVE_STEER_FAIL(tMyACTIVE_STEER_FAIL);
   }
   // dispvidctrl_tclClientVcan::vGetACTIVE_STEER_FAIL: user specific code start
   // dispvidctrl_tclClientVcan::vGetACTIVE_STEER_FAIL: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetVehicleSpeed() {
   TVehicleSpeed tMyVehicleSpeed;
   if (_pCsmBase) {
       _pCsmBase->vGetVehicleSpeed(tMyVehicleSpeed);
   }
   // dispvidctrl_tclClientVcan::vGetVehicleSpeed: user specific code start
   // dispvidctrl_tclClientVcan::vGetVehicleSpeed: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Mode_Change_Request() {
   TIPA_Mode_Change_Request tMyIPA_Mode_Change_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Mode_Change_Request(tMyIPA_Mode_Change_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Mode_Change_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Mode_Change_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Display_Request() {
   TIPA_Switch_Display_Request tMyIPA_Switch_Display_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Display_Request(tMyIPA_Switch_Display_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Display_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Display_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_mask_Request() {
   TIPA_Switch_mask_Request tMyIPA_Switch_mask_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_mask_Request(tMyIPA_Switch_mask_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_mask_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_mask_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_01() {
   TIPA_Switch_Gray_Out_Request_01 tMyIPA_Switch_Gray_Out_Request_01;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Gray_Out_Request_01(tMyIPA_Switch_Gray_Out_Request_01);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_01: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_01: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_02() {
   TIPA_Switch_Gray_Out_Request_02 tMyIPA_Switch_Gray_Out_Request_02;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Gray_Out_Request_02(tMyIPA_Switch_Gray_Out_Request_02);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_02: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_02: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_03() {
   TIPA_Switch_Gray_Out_Request_03 tMyIPA_Switch_Gray_Out_Request_03;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Gray_Out_Request_03(tMyIPA_Switch_Gray_Out_Request_03);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_03: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_03: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_04() {
   TIPA_Switch_Gray_Out_Request_04 tMyIPA_Switch_Gray_Out_Request_04;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Gray_Out_Request_04(tMyIPA_Switch_Gray_Out_Request_04);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_04: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_04: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_05() {
   TIPA_Switch_Gray_Out_Request_05 tMyIPA_Switch_Gray_Out_Request_05;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Gray_Out_Request_05(tMyIPA_Switch_Gray_Out_Request_05);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_05: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_05: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_06() {
   TIPA_Switch_Gray_Out_Request_06 tMyIPA_Switch_Gray_Out_Request_06;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Switch_Gray_Out_Request_06(tMyIPA_Switch_Gray_Out_Request_06);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_06: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Switch_Gray_Out_Request_06: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_mode_selection() {
   TIPA_mode_selection tMyIPA_mode_selection;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_mode_selection(tMyIPA_mode_selection);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_mode_selection: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_mode_selection: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Message_Display_Request() {
   TIPA_Message_Display_Request tMyIPA_Message_Display_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Message_Display_Request(tMyIPA_Message_Display_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Message_Display_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Message_Display_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Sound_Output_Request() {
   TIPA_Sound_Output_Request tMyIPA_Sound_Output_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Sound_Output_Request(tMyIPA_Sound_Output_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Sound_Output_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Sound_Output_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Voice_Output_Request() {
   TIPA_Voice_Output_Request tMyIPA_Voice_Output_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Voice_Output_Request(tMyIPA_Voice_Output_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Voice_Output_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Voice_Output_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_region_selection() {
   TIPA_region_selection tMyIPA_region_selection;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_region_selection(tMyIPA_region_selection);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_region_selection: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_region_selection: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Camera_Indicator_Request() {
   TIPA_Camera_Indicator_Request tMyIPA_Camera_Indicator_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Camera_Indicator_Request(tMyIPA_Camera_Indicator_Request);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Camera_Indicator_Request: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Camera_Indicator_Request: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetIPA_Mulfunction() {
   TIPA_Mulfunction tMyIPA_Mulfunction;
   if (_pCsmBase) {
       _pCsmBase->vGetIPA_Mulfunction(tMyIPA_Mulfunction);
   }
   // dispvidctrl_tclClientVcan::vGetIPA_Mulfunction: user specific code start
   // dispvidctrl_tclClientVcan::vGetIPA_Mulfunction: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetRearGearEngaged() {
   TRearGearEngaged tMyRearGearEngaged;
   if (_pCsmBase) {
       _pCsmBase->vGetRearGearEngaged(tMyRearGearEngaged);
   }
   // dispvidctrl_tclClientVcan::vGetRearGearEngaged: user specific code start
   // dispvidctrl_tclClientVcan::vGetRearGearEngaged: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetMVC_ViewModeStatus() {
   TMVC_ViewModeStatus tMyMVC_ViewModeStatus;
   if (_pCsmBase) {
       _pCsmBase->vGetMVC_ViewModeStatus(tMyMVC_ViewModeStatus);
   }
   // dispvidctrl_tclClientVcan::vGetMVC_ViewModeStatus: user specific code start
   // dispvidctrl_tclClientVcan::vGetMVC_ViewModeStatus: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetMVC_WarningDisplayRequest() {
   TMVC_WarningDisplayRequest tMyMVC_WarningDisplayRequest;
   if (_pCsmBase) {
       _pCsmBase->vGetMVC_WarningDisplayRequest(tMyMVC_WarningDisplayRequest);
   }
   // dispvidctrl_tclClientVcan::vGetMVC_WarningDisplayRequest: user specific code start
   // dispvidctrl_tclClientVcan::vGetMVC_WarningDisplayRequest: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetTailGateStatus() {
   TTailGateStatus tMyTailGateStatus;
   if (_pCsmBase) {
       _pCsmBase->vGetTailGateStatus(tMyTailGateStatus);
   }
   // dispvidctrl_tclClientVcan::vGetTailGateStatus: user specific code start
   // dispvidctrl_tclClientVcan::vGetTailGateStatus: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_ChangeViewStatus() {
   TAVM_ChangeViewStatus tMyAVM_ChangeViewStatus;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_ChangeViewStatus(tMyAVM_ChangeViewStatus);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_ChangeViewStatus: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_ChangeViewStatus: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_ClosingAuthorization() {
   TAVM_ClosingAuthorization tMyAVM_ClosingAuthorization;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_ClosingAuthorization(tMyAVM_ClosingAuthorization);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_ClosingAuthorization: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_ClosingAuthorization: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetMOD_ActivationState() {
   TMOD_ActivationState tMyMOD_ActivationState;
   if (_pCsmBase) {
       _pCsmBase->vGetMOD_ActivationState(tMyMOD_ActivationState);
   }
   // dispvidctrl_tclClientVcan::vGetMOD_ActivationState: user specific code start
   // dispvidctrl_tclClientVcan::vGetMOD_ActivationState: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_ModeChangeRequest() {
   TFAP_ModeChangeRequest tMyFAP_ModeChangeRequest;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_ModeChangeRequest(tMyFAP_ModeChangeRequest);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_ModeChangeRequest: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_ModeChangeRequest: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetCamerasetting_availability() {
   TCamerasetting_availability tMyCamerasetting_availability;
   if (_pCsmBase) {
       _pCsmBase->vGetCamerasetting_availability(tMyCamerasetting_availability);
   }
   // dispvidctrl_tclClientVcan::vGetCamerasetting_availability: user specific code start
   // dispvidctrl_tclClientVcan::vGetCamerasetting_availability: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting01() {
   TFAP_Setting01 tMyFAP_Setting01;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting01(tMyFAP_Setting01);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting01: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting01: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting02() {
   TFAP_Setting02 tMyFAP_Setting02;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting02(tMyFAP_Setting02);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting02: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting02: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting03() {
   TFAP_Setting03 tMyFAP_Setting03;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting03(tMyFAP_Setting03);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting03: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting03: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting04() {
   TFAP_Setting04 tMyFAP_Setting04;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting04(tMyFAP_Setting04);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting04: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting04: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting05() {
   TFAP_Setting05 tMyFAP_Setting05;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting05(tMyFAP_Setting05);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting05: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting05: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting06() {
   TFAP_Setting06 tMyFAP_Setting06;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting06(tMyFAP_Setting06);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting06: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting06: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting07() {
   TFAP_Setting07 tMyFAP_Setting07;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting07(tMyFAP_Setting07);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting07: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting07: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting08() {
   TFAP_Setting08 tMyFAP_Setting08;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting08(tMyFAP_Setting08);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting08: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting08: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting09() {
   TFAP_Setting09 tMyFAP_Setting09;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting09(tMyFAP_Setting09);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting09: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting09: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_Setting10() {
   TFAP_Setting10 tMyFAP_Setting10;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_Setting10(tMyFAP_Setting10);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_Setting10: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_Setting10: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_1() {
   TAVM_Setting_1 tMyAVM_Setting_1;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_1(tMyAVM_Setting_1);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_1: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_1: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_2() {
   TAVM_Setting_2 tMyAVM_Setting_2;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_2(tMyAVM_Setting_2);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_2: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_2: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_3() {
   TAVM_Setting_3 tMyAVM_Setting_3;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_3(tMyAVM_Setting_3);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_3: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_3: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_4() {
   TAVM_Setting_4 tMyAVM_Setting_4;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_4(tMyAVM_Setting_4);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_4: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_4: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_5() {
   TAVM_Setting_5 tMyAVM_Setting_5;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_5(tMyAVM_Setting_5);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_5: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_5: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_6() {
   TAVM_Setting_6 tMyAVM_Setting_6;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_6(tMyAVM_Setting_6);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_6: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_6: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_7() {
   TAVM_Setting_7 tMyAVM_Setting_7;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_7(tMyAVM_Setting_7);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_7: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_7: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_8() {
   TAVM_Setting_8 tMyAVM_Setting_8;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_8(tMyAVM_Setting_8);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_8: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_8: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetAVM_Setting_9() {
   TAVM_Setting_9 tMyAVM_Setting_9;
   if (_pCsmBase) {
       _pCsmBase->vGetAVM_Setting_9(tMyAVM_Setting_9);
   }
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_9: user specific code start
   // dispvidctrl_tclClientVcan::vGetAVM_Setting_9: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_PurposeSwitchAvailability() {
   TFAP_PurposeSwitchAvailability tMyFAP_PurposeSwitchAvailability;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_PurposeSwitchAvailability(tMyFAP_PurposeSwitchAvailability);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_PurposeSwitchAvailability: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_PurposeSwitchAvailability: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_ChangeViewRequest() {
   TFAP_ChangeViewRequest tMyFAP_ChangeViewRequest;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_ChangeViewRequest(tMyFAP_ChangeViewRequest);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_ChangeViewRequest: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_ChangeViewRequest: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_SoundDirection() {
   TFAP_SoundDirection tMyFAP_SoundDirection;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_SoundDirection(tMyFAP_SoundDirection);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_SoundDirection: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_SoundDirection: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_SoundLevelControl() {
   TFAP_SoundLevelControl tMyFAP_SoundLevelControl;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_SoundLevelControl(tMyFAP_SoundLevelControl);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_SoundLevelControl: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_SoundLevelControl: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_SoundPatternRequest() {
   TFAP_SoundPatternRequest tMyFAP_SoundPatternRequest;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_SoundPatternRequest(tMyFAP_SoundPatternRequest);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_SoundPatternRequest: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_SoundPatternRequest: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetFAP_VoicePatternRequest() {
   TFAP_VoicePatternRequest tMyFAP_VoicePatternRequest;
   if (_pCsmBase) {
       _pCsmBase->vGetFAP_VoicePatternRequest(tMyFAP_VoicePatternRequest);
   }
   // dispvidctrl_tclClientVcan::vGetFAP_VoicePatternRequest: user specific code start
   // dispvidctrl_tclClientVcan::vGetFAP_VoicePatternRequest: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetDayRheostatedLightMaxPercent() {
   TDayRheostatedLightMaxPercent tMyDayRheostatedLightMaxPercent;
   if (_pCsmBase) {
       _pCsmBase->vGetDayRheostatedLightMaxPercent(tMyDayRheostatedLightMaxPercent);
   }
   // dispvidctrl_tclClientVcan::vGetDayRheostatedLightMaxPercent: user specific code start
   // dispvidctrl_tclClientVcan::vGetDayRheostatedLightMaxPercent: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetNightRheostatedLightMaxPercent() {
   TNightRheostatedLightMaxPercent tMyNightRheostatedLightMaxPercent;
   if (_pCsmBase) {
       _pCsmBase->vGetNightRheostatedLightMaxPercent(tMyNightRheostatedLightMaxPercent);
   }
   // dispvidctrl_tclClientVcan::vGetNightRheostatedLightMaxPercent: user specific code start
   // dispvidctrl_tclClientVcan::vGetNightRheostatedLightMaxPercent: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetDimmingState() {
   TDimmingState tMyDimmingState;
   if (_pCsmBase) {
       _pCsmBase->vGetDimmingState(tMyDimmingState);
   }
   // dispvidctrl_tclClientVcan::vGetDimmingState: user specific code start
   // dispvidctrl_tclClientVcan::vGetDimmingState: user specific code end
}

tVoid dispvidctrl_tclClientVcan::vGetSTATUS_DYNAMIC_REAR() {
   TSTATUS_DYNAMIC_REAR tMySTATUS_DYNAMIC_REAR;
   if (_pCsmBase) {
       _pCsmBase->vGetSTATUS_DYNAMIC_REAR(tMySTATUS_DYNAMIC_REAR);
   }
   // dispvidctrl_tclClientVcan::vGetSTATUS_DYNAMIC_REAR: user specific code start
   // dispvidctrl_tclClientVcan::vGetSTATUS_DYNAMIC_REAR: user specific code end
}


// dispvidctrl_tclClientVcan::ClassImplementation: user specific code start
/******************************************************************************/
/* FUNCTION     vHandleControl()                                              */
/******************************************************************************/
/**
*  \brief       
*
*  \param       
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vHandleControl(tenControl_ClientCsm enControl, tU32 u32Value)
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32Value );

   ETG_TRACE_USR4(("CLIENT CSM:: ............vHandleControl(): %d  u32Value: %d   ", ETG_CENUM(tenControl_ClientCsm, enControl), u32Value));

   switch (enControl)
   {
      case EN_CONTROL_CLIENT_CSM__SYSPWRMODE_RUN:
         if (TRUE == (tBool) u32Value)
         {
            //ETG_TRACE_USR1((" CSM-IF   :: SYSPWRMODE_RUN is true -> unlock error qualification"));
            //RUN mode (IGN and ACC ON)
            // Unlock error qualification for Sensor Calibration Error
            m_bErrorQualificationUnlocked_SensorCalibration = TRUE;
            // recheck error state and start qualification if required for Sensor Calibration Error
            if (m_bItcSteeringFlagFail == TRUE)
            {
               //ETG_TRACE_USR1((" CSM-IF   :: m_bItcSteeringFlagFail is true -> restart qualification timer"));
               ETG_TRACE_USR4((" CSM-IF   :: m_bItcSteeringFlagFail is set! -> restart qualification timer"));
               //start error qualification timer
               (tVoid) _bSetTimer_SteeringFail( (OSAL_tMSecond) DISPVIDCTRL_CLIENT_VCAN_STEERING_FAIL_RECHECK_TIME_IN_MS);
            }
         }
         else
         {
            //ETG_TRACE_USR1((" CSM-IF   :: SYSPWRMODE_RUN is false -> lock error qualification and stop timer"));
            // No RUN mode (IGN and/or ACC OFF)
            // Lock error qualification for Sensor Calibration Error
            m_bErrorQualificationUnlocked_SensorCalibration = FALSE;
            // stop a possible running qualification for Sensor Calibration Error
            // -> stop qualification timer
            (tVoid) _bSetTimer_SteeringFail( (OSAL_tMSecond) 0);
         }
         break;

      default:
         break;
   }
}


/******************************************************************************/
/* FUNCTION     vCheckInitialisingSignal                                      */
/******************************************************************************/
/**
*  \brief       reads the "initialising" signal
*               sends messages ofr trigger events for AVM Init on or off
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vCheckInitialisingSignal(tVoid) const {

   ETG_TRACE_USR4((" CL-VCAN  :: vCheckInitialisingSignal(): ............ entered! -------------------------------"));
   ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_u32InitialStatus));
   ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_u8InitialValue));

   if (CSM_C_SIGNAL_ARRIVED == (m_u32InitialStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
   {
      if ( m_u8InitialValue == 0 ) {
         tChar strIfName[] = "dispvidctrl_tclControl_Avm";
         dispvidctrl_tclAppMain::theServer()->vPostMsgControlAvm(strIfName, (tU32) EN_CONTROL_AVM__INIT_DONE);
      }
      else {
         tChar strIfName[] = "dispvidctrl_tclControl_Avm";
         dispvidctrl_tclAppMain::theServer()->vPostMsgControlAvm(strIfName, (tU32) EN_CONTROL_AVM__INIT_ACTIVE);
      }
   }
   else
   {
     ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_SIG_RX_Initialising_5C2 = ............... signal data status NOK!          "));
   }
}

/******************************************************************************/
/* FUNCTION     vCheckViewChangeRequestSignal                                 */
/******************************************************************************/
/**
*  \brief       reads the "view change request" signal
*               sends event to main for camera screen on or off
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vCheckViewChangeRequestSignal(tVoid) const {

   ETG_TRACE_USR4((" CL-VCAN  :: vCheckViewChangeRequestSignal(): ....... entered! -------------------------------"));
   ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_u32ViewChReqStatus));
   ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_u8ViewChReqValue));

   if (CSM_C_SIGNAL_ARRIVED == (m_u32ViewChReqStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {

      if (m_u8ViewChReqValue == 0) {
         tChar strIfName[] = "dispvidctrl_tclControl_Avm";
         dispvidctrl_tclAppMain::theServer()->vPostMsgControlAvm(strIfName, (tU32) EN_CONTROL_AVM__CAMERA_SCREEN_OFF);
      }
      else {
         // event to switch camera screen on
         tChar strIfName[] = "dispvidctrl_tclControl_Avm";
         dispvidctrl_tclAppMain::theServer()->vPostMsgControlAvm(strIfName, (tU32) EN_CONTROL_AVM__CAMERA_SCREEN_ON);
      }
   }
   else {
      ETG_TRACE_USR4((" CL-VCAN  :: vCheckViewChangeRequestSignal(): ....... signal data status NOK!                 "));
   }
}
/******************************************************************************/
/* FUNCTION     vWriteUPA_TX_Initializing                                     */
/******************************************************************************/
/**
*  \brief       write the camera "Initializing" signal to Vcan
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteUPA_TX_Initializing(tU8 u8SignalValue)
{
   TUPA_TX_Initializing msgUPA_TX_Initializing;

   msgUPA_TX_Initializing.u8TxType    = CSM_C_TX_AS_CONFIGURED;
   msgUPA_TX_Initializing.UPA_TX_Initializing = u8SignalValue;

   vSendUPA_TX_Initializing(msgUPA_TX_Initializing);
}

/******************************************************************************/
/* FUNCTION     vWriteUPA_Setting_Language_Request                            */
/******************************************************************************/
/**
*  \brief       write the "settings language request" signal to Vcan
*
*  \param       Avm language to be set
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteUPA_Setting_Language_Request(tU8 u8AvmLanguage)
{
   TUPA_Setting_Language_Request msgUPA_Setting_Language_Request;

   msgUPA_Setting_Language_Request.u8TxType        = CSM_C_TX_AS_CONFIGURED;
   msgUPA_Setting_Language_Request.UPA_Setting_Language_Request = u8AvmLanguage;

   vSendUPA_Setting_Language_Request(msgUPA_Setting_Language_Request);
}

/******************************************************************************/
/* FUNCTION     vWriteUPA_Camera_OFF_Request                                  */
/******************************************************************************/
/**
*  \brief       write the camera "OFF request" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteUPA_Camera_OFF_Request(tBool bReinit)
{
   TUPA_Camera_OFF_Request msgUPA_Camera_OFF_Request;

   //write the inverted one (toggle the signal (bit 0)) or 0 in case of reinit
   m_u8CameraOffRequest = (m_u8CameraOffRequest ^ 0x01) && (!bReinit);

   msgUPA_Camera_OFF_Request.u8TxType        = CSM_C_TX_AS_CONFIGURED;
   msgUPA_Camera_OFF_Request.UPA_Camera_OFF_Request = m_u8CameraOffRequest;

   vSendUPA_Camera_OFF_Request(msgUPA_Camera_OFF_Request);
}

/******************************************************************************/
/* FUNCTION     vWriteUPA_Camera_Switch_Keep                                  */
/******************************************************************************/
/**
*  \brief       write the camera "switch keep" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteUPA_Camera_Switch_Keep(tBool bReinit)
{
   TUPA_Camera_Switch_Keep msgUPA_Camera_Switch_Keep;

   //write the inverted one (toggle the signal (bit 0)) or 0 in case of reinit
   m_u8CameraSwitchKeep = (m_u8CameraSwitchKeep ^ 0x01) && (!bReinit);

   msgUPA_Camera_Switch_Keep.u8TxType        = CSM_C_TX_AS_CONFIGURED;
   msgUPA_Camera_Switch_Keep.UPA_Camera_Switch_Keep = m_u8CameraSwitchKeep;

   vSendUPA_Camera_Switch_Keep(msgUPA_Camera_Switch_Keep);
}

/******************************************************************************/
/* FUNCTION     vWriteUPA_Camera_Switch_Press                                 */
/******************************************************************************/
/**
*  \brief       write the camera "switch pressed" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteUPA_Camera_Switch_Press(tBool bReinit)
{
   TUPA_Camera_Switch_Press msgUPA_Camera_Switch_Press;
 
   //write the inverted one (toggle the signal (bit 0)) or 0 in case of reinit
   m_u8CameraSwitchPress = (m_u8CameraSwitchPress ^ 0x01) && (!bReinit);

   msgUPA_Camera_Switch_Press.u8TxType      = CSM_C_TX_AS_CONFIGURED;
   msgUPA_Camera_Switch_Press.UPA_Camera_Switch_Press = m_u8CameraSwitchPress;

   vSendUPA_Camera_Switch_Press(msgUPA_Camera_Switch_Press);
}

/******************************************************************************/
/* FUNCTION     vWriteUPA_MOD_Switch_Press                                    */
/******************************************************************************/
/**
*  \brief       write the "Motion Object Detection press" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteUPA_MOD_Switch_Press(tBool bReinit)
{
   TUPA_MOD_Switch_Press msgMOD_Switch_Press;

   //write the inverted one (toggle the signal (bit 0)) or 0 in case of reinit
   m_u8ModSwitchPress = (m_u8ModSwitchPress ^ 0x01) && (!bReinit);

   msgMOD_Switch_Press.u8TxType      = CSM_C_TX_AS_CONFIGURED;
   msgMOD_Switch_Press.UPA_MOD_Switch_Press = m_u8ModSwitchPress;

   vSendUPA_MOD_Switch_Press(msgMOD_Switch_Press);
}

/******************************************************************************/
/* FUNCTION     vWriteIPA_Activation_Flag                                     */
/******************************************************************************/
/**
*  \brief       write the "Motion Object Detection press" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteIPA_Activation_Flag(tBool bFlag)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteIPA_Activation_Flag as %d", bFlag));

    if ( m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_OLD_NISSAN )
    {
        TFAP_ActivationRequest msgFAPActivationrequest;
        msgFAPActivationrequest.FAP_ActivationRequest = bFlag;
        msgFAPActivationrequest.u8TxType = CSM_C_TX_AS_CONFIGURED;
        //update
        vSendFAP_ActivationRequest(msgFAPActivationrequest);
    }
    else
    {
        TIPA_Activation_flug msgIPAActivationFlag;
        msgIPAActivationFlag.IPA_Activation_flug = bFlag;
        msgIPAActivationFlag.u8TxType = CSM_C_TX_AS_CONFIGURED;
        //update
        vSendIPA_Activation_flug(msgIPAActivationFlag);
    }
}

/******************************************************************************/
/* FUNCTION     vWriteIPA_SW_Long_Press                                       */
/******************************************************************************/
/**
*  \brief       write the "Motion Object Detection press" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteIPA_SW_Long_Press(tBool bSWLongPress)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteIPA_SW_Long_Press as %d", bSWLongPress));

    TIPA_SW_Long_Press msgIPASW_Long_Press;

    msgIPASW_Long_Press.IPA_SW_Long_Press = bSWLongPress;
    msgIPASW_Long_Press.u8TxType = CSM_C_TX_AS_CONFIGURED;

    vSendIPA_SW_Long_Press(msgIPASW_Long_Press);
}

/******************************************************************************/
/* FUNCTION     vWriteIPA_SW_Operation_Status                                 */
/******************************************************************************/
/**
*  \brief       write the "Motion Object Detection press" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteIPA_SW_Operation_Status(tU8 u8Status)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteIPA_SW_Operation_Status as %d", u8Status));

    TIPA_SW_Operation_Status msgIPASW_Operation_Status;

    msgIPASW_Operation_Status.IPA_SW_Operation_Status = u8Status;
    msgIPASW_Operation_Status.u8TxType = CSM_C_TX_AS_CONFIGURED;

    vSendIPA_SW_Operation_Status(msgIPASW_Operation_Status);
}

/******************************************************************************/
/* FUNCTION     vWriteAVM_Switch_Request                                      */
/******************************************************************************/
/**
*  \brief       write the "Switch Request" signal to Vcan
*
*  \param       Request
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteAVM_Switch_Request(tU8 u8Request)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteAVM_Switch_Request as %d", u8Request));

    TSwitchRequest_AVM msgAVM_Switch_Request;
    
    msgAVM_Switch_Request.SwitchRequest_AVM = u8Request;
    msgAVM_Switch_Request.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendSwitchRequest_AVM(msgAVM_Switch_Request);
}

/******************************************************************************/
/* FUNCTION     vWriteAVM_View_Change_Request                                 */
/******************************************************************************/
/**
*  \brief       write the "View Change request" signal to Vcan for AVM
*
*  \param       Request
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteAVM_View_Change_Request(tU8 u8Request)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteAVM_View_Change_Request as %d", u8Request));

    TChangeViewRequest_AVM msgAVM_Change_View_Request;
    
    msgAVM_Change_View_Request.ChangeViewRequest_AVM = u8Request;
    msgAVM_Change_View_Request.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendChangeViewRequest_AVM(msgAVM_Change_View_Request);
}

/******************************************************************************/
/* FUNCTION     vWriteMVC_ViewModeRequest                                     */
/******************************************************************************/
/**
*  \brief       write the "MVC view mode request" signal to Vcan for MVC
*
*  \param       Request
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteMVC_ViewModeRequest(tU8 u8Request)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteMVC_ViewModeRequest as %d", u8Request));

    TMVC_ViewModeRequest msgMVC_ViewModeRequest;
    
    msgMVC_ViewModeRequest.MVC_ViewModeRequest = u8Request;
    msgMVC_ViewModeRequest.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMVC_ViewModeRequest(msgMVC_ViewModeRequest);
}

/******************************************************************************/
/* FUNCTION     vWriteAVM_MOD_Activation_Request                              */
/******************************************************************************/
/**
*  \brief       write the "AVM MOD change request" signal to Vcan for 
*               Nissan AVM in C1A
*
*  \param       Request
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteAVM_MOD_Activation_Request(tU8 u8Request)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteAVM_MOD_Activation_Request as %d", u8Request));

   TMOD_ActivationRequest2 msgAVM_MODRequest;
    
    msgAVM_MODRequest.MOD_ActivationRequest2 = u8Request;
    msgAVM_MODRequest.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMOD_ActivationRequest2(msgAVM_MODRequest);
}

/******************************************************************************/
/* FUNCTION     vWriteLDW_PRESS_5FE                                           */
/******************************************************************************/
/**
*  \brief       write the "Lane Departure Warning press" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
/*
tVoid dispvidctrl_tclClientVcan::vWriteLDW_PRESS_5FE(tBool bReinit)
{
   TLDW_PRESS_5FE msgLDW_PRESS_5FE;

   //write the inverted one (toggle the signal (bit 0)) or 0 in case of reinit
   m_u8LdwSwitchPress = (m_u8LdwSwitchPress ^ 0x01) && (!bReinit);

   msgLDW_PRESS_5FE.u8TxType      = CSM_C_TX_AS_CONFIGURED;
   msgLDW_PRESS_5FE.LDW_PRESS_5FE = m_u8LdwSwitchPress;

   vSendLDW_PRESS_5FE(msgLDW_PRESS_5FE);
}
*/

/******************************************************************************/
/* FUNCTION     vWriteBSW_PRESS_5FE                                           */
/******************************************************************************/
/**
*  \brief       write the "Blind Spot Warning press" signal to Vcan
*
*  \param       is reinit active
*  \return      none
*/
/******************************************************************************/
/*
tVoid dispvidctrl_tclClientVcan::vWriteBSW_PRESS_5FE(tBool bReinit)
{
   TBSW_PRESS_5FE msgBSW_PRESS_5FE;

   //write the inverted one (toggle the signal (bit 0)) or 0 in case of reinit
   m_u8BswSwitchPress = (m_u8BswSwitchPress ^ 0x01) && (!bReinit);

   msgBSW_PRESS_5FE.u8TxType      = CSM_C_TX_AS_CONFIGURED;
   msgBSW_PRESS_5FE.BSW_PRESS_5FE = m_u8BswSwitchPress;

   vSendBSW_PRESS_5FE(msgBSW_PRESS_5FE);
}
*/

/******************************************************************************/
/* FUNCTION     vWriteFAP_ScreenPressCoordinateX                              */
/******************************************************************************/
/**
*  \brief       writes the "Fap Touch X ordinate" signal
*
*  \param       Data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteFAP_ScreenPressCoordinateX(tU8 u8Data)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteFAP_ScreenPressCoordinateX as %d", u8Data));

    TFAP_ScreenPressCoordinateX msgFAP_ScreenPressCoordinateX;
    
    msgFAP_ScreenPressCoordinateX.FAP_ScreenPressCoordinateX = u8Data;
    msgFAP_ScreenPressCoordinateX.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendFAP_ScreenPressCoordinateX(msgFAP_ScreenPressCoordinateX);
}

/******************************************************************************/
/* FUNCTION     vWriteFAP_ScreenPressCoordinateY                              */
/******************************************************************************/
/**
*  \brief       writes the "Fap Touch Y ordinate" signal
*
*  \param       Data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteFAP_ScreenPressCoordinateY(tU8 u8Data)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteFAP_ScreenPressCoordinateY as %d", u8Data));

    TFAP_ScreenPressCoordinateY msgFAP_ScreenPressCoordinateY;
    
    msgFAP_ScreenPressCoordinateY.FAP_ScreenPressCoordinateY = u8Data;
    msgFAP_ScreenPressCoordinateY.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendFAP_ScreenPressCoordinateY(msgFAP_ScreenPressCoordinateY);
}

/******************************************************************************/
/* FUNCTION     vWriteFAP_ScreenPressDetected                                 */
/******************************************************************************/
/**
*  \brief       writes the "Fap Touch Screen Press detected" signal
*
*  \param       Data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteFAP_ScreenPressDetected(tU8 u8Data)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteFAP_ScreenPressDetected as %d", u8Data));

    TFAP_ScreenPressDetected msgFAP_ScreenPressDetected;
    
    msgFAP_ScreenPressDetected.FAP_ScreenPressDetected = u8Data;
    msgFAP_ScreenPressDetected.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendFAP_ScreenPressDetected(msgFAP_ScreenPressDetected);
}

/******************************************************************************/
/* FUNCTION     vWriteFAP_Screen_Activation_flag                              */
/******************************************************************************/
/**
*  \brief       writes the "Fap Touch Screen Press detected" signal
*
*  \param       Data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vWriteFAP_Screen_Activation_flag(tU8 u8Data)
{
    ETG_TRACE_USR1((" CL-VCAN  :: vWriteFAP_Screen_Activation_flag as %d", u8Data));

    TFAP_Screen_Activation_flag msgFAP_ScreenActivationflag;
    
    msgFAP_ScreenActivationflag.FAP_Screen_Activation_flag = u8Data;
    msgFAP_ScreenActivationflag.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendFAP_Screen_Activation_flag(msgFAP_ScreenActivationflag);
}

/******************************************************************************/
/* FUNCTION     vInvalidateCsmRx                                              */
/******************************************************************************/
/**
*  \brief       to invalidate signal values/state for RX signals which could
*               cause Camera View activation
*               for these signals "Indicate Always" must be configured in CSM
*               (Callback Indication with every Message receiption)
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientVcan::vInvalidateCsmRx(tVoid)
{
   if (_pCsmBase) {
      _pCsmBase->vInvalidate_UPA_RX_Initializing();
      m_u32InitialStatus = CSM_C_SIGNAL_DATA_INVALID;
      _pCsmBase->vInvalidate_UPA_View_Change_Request();
      m_u32ViewChReqStatus = CSM_C_SIGNAL_DATA_INVALID;
      _pCsmBase->vInvalidate_FAP_ChangeViewRequest();
      m_Status_FAP_ChangeViewRequestStatus= CSM_C_SIGNAL_DATA_INVALID;
   }
}

/******************************************************************************/
/* FUNCTION     bGetViewChangeRequestSignal                                 */
/******************************************************************************/
/**
*  \brief       reads the "view change request" signal
*               sends event to main for camera screen on or off
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGetViewChangeRequestSignal(tU8& u8ViewChangeSignalValue)
{
   tBool bReturnValue = FALSE;

   ETG_TRACE_USR4((" CL-VCAN  :: bGetViewChangeRequestSignal(): ......... entered! -------------------------------"));
   ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_u32ViewChReqStatus));
   ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_u8ViewChReqValue));

   if (CSM_C_SIGNAL_ARRIVED == (m_u32ViewChReqStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
      u8ViewChangeSignalValue = m_u8ViewChReqValue;
      bReturnValue = TRUE;
   }
   else {
      ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_SIG_RX_View_Change_Request_5C2 =  signal data status NOK!                 "));
   }

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_MVC_ViewModeStatus                                       */
/******************************************************************************/
/**
*  \brief       reads the "view change request" signal
*               sends event to main for camera screen on or off
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_MVC_ViewModeStatus(tU8& u8ViewStatus)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_MVC_ViewModeStatus(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32MVC_ViewModeStatus));
    ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_u8MVC_ViewModeStatus));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32MVC_ViewModeStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
       u8ViewStatus = m_Value_u8MVC_ViewModeStatus;
       bReturnValue = TRUE;
    }
    else {
       ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_MVC_ViewModeStatus =  signal data status NOK!                 "));
    }

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_MVC_WarningDisplayRequest                                */
/******************************************************************************/
/**
*  \brief       reads the "view change request" signal
*               sends event to main for camera screen on or off
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_MVC_WarningDisplayRequest(tU32& u32Request)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_MVC_WarningDisplayRequest(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32MVC_WarningDisplayRequest));
    ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_u8MVC_WarningDisplayRequest));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32MVC_WarningDisplayRequest & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
       u32Request = m_Value_u8MVC_WarningDisplayRequest;
       bReturnValue = TRUE;
    }
    else {
       ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_MVC_WarningDisplayRequest =  signal data status NOK!                 "));
    }

     return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_IPA_SwitchesSignals                                      */
/******************************************************************************/
/**
*  \brief       reads the "IPA Gray Out request Signals"
*               loads the updated status into the parameter
*
*  \param       Gray Out Request Status Loaded
*  \return      Validity of the Loaded Value
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_SwitchesSignals(tU8& u8SwitchesSignalsValue)
{
    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_SwitchesSignals(): ......... entered! -------------------------------"));

    tBool bReturnValue = TRUE;

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchRequest01 & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: m_Value_bIPASwitchRequest01 = ..................... %u", m_Value_bIPASwitchRequest01));
        u8SwitchesSignalsValue |= ( ((tU8) m_Value_bIPASwitchRequest01) << 0 );
    } else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_01 =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchRequest02 & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: m_Value_bIPASwitchRequest01 = ..................... %u", m_Value_bIPASwitchRequest02));
        u8SwitchesSignalsValue |= ( ((tU8) m_Value_bIPASwitchRequest02) << 1 );
    } else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_02 =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchRequest03 & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: m_Value_bIPASwitchRequest03 = ..................... %u", m_Value_bIPASwitchRequest03));
        u8SwitchesSignalsValue |= ( ((tU8) m_Value_bIPASwitchRequest03) << 2 );
    } else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_03 =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchRequest04 & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: m_Value_bIPASwitchRequest04 = ..................... %u", m_Value_bIPASwitchRequest04));
        u8SwitchesSignalsValue |= ( ((tU8) m_Value_bIPASwitchRequest04) << 3 );
    } else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_04 =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchRequest05 & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: m_Value_bIPASwitchRequest05 = ..................... %u", m_Value_bIPASwitchRequest05));
        u8SwitchesSignalsValue |= ( ((tU8) m_Value_bIPASwitchRequest05) << 4 );
    } else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_05 =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchRequest06 & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: m_Value_bIPASwitchRequest06 = ..................... %u", m_Value_bIPASwitchRequest06));
        u8SwitchesSignalsValue |= ( ((tU8) m_Value_bIPASwitchRequest06) << 5 );
    } else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_06 =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_SwitchesSignals(): u8SwitchesSignalsValue = 0x%02x, bReturnValue 0x%01x", u8SwitchesSignalsValue, bReturnValue));

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_IPA_PatternDisplayStatus                                 */
/******************************************************************************/
/**
*  \brief       reads the "Pattern" loads the updated status into the parameter
*
*  \param       Pattern Number loaded
*  \return      Validity of the Loaded Value
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_PatternDisplayStatus(tU8& u8PatternValue)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_PatternDisplayStatus(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPASwitchDisplay));
    ETG_TRACE_USR4((" CL-VCAN  :: PatternId = ............................... %u", ETG_ENUM(DISPVIDCTRL_E8_IPA_PATTERNID, m_Value_u8IPASwitchDisplay)));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchDisplay & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        u8PatternValue = m_Value_u8IPASwitchDisplay;
        bReturnValue = TRUE;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_Display_Request =  signal data status NOK!                 "));
    }

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_IPA_MessageDisplaySignals                                */
/******************************************************************************/
/**
*  \brief       reads the "IPA Message Display"
*               loads the updated status into the parameter
*
*  \param       Gray Out Request Status Loaded
*  \return      Validity of the Loaded Value
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_MessageDisplaySignals(tU8& u8MessageDisplayValue)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_MessageDisplaySignals(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPAMessageDisplay));
    ETG_TRACE_USR4((" CL-VCAN  :: MessageID = ............................... %u", ETG_ENUM(DISPVIDCTRL_E8_IPA_MESSAGEID, m_Value_u8IPAMessageDisplay)));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPAMessageDisplay & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        u8MessageDisplayValue = m_Value_u8IPAMessageDisplay;
        bReturnValue = TRUE;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Message_Display_Request =  signal data status NOK!                 "));
    }

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_IPA_ConfigurationStatus                                  */
/******************************************************************************/
/**
*  \brief       reads the "IPA Config values, Region Selection"
*               loads the updated status into the parameters
*
*  \param       IPA Availability and IPA Region Selection
*  \return      Validity of the Loaded Value
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_ConfigurationStatus(tU8& u8RegionSelection)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_MessageDisplaySignals(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPARegionSelection));
    ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_u8IPARegionSelection));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPARegionSelection & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        u8RegionSelection = m_Value_u8IPARegionSelection;
        bReturnValue = TRUE;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_region_selection =  signal data status NOK!                 "));
    }

    return bReturnValue;
}


/******************************************************************************/
/* FUNCTION     bGet_IPA_OperationStatus                                      */
/******************************************************************************/
/**
*  \brief       reads the "IPA Operation Status, IPA Mode Requested Status"
*               loads the updated status into the parameters
*
*  \param       IPA Operation Status and IPA Request State
*  \return      Validity of the Loaded Value
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_OperationStatus(tU8& u8OperationStatus, tU8& u8RequestedStatus)
{
    tBool bReturnValue = TRUE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_OperationStatus(): ......... entered! -------------------------------"));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPAMalfunction & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPAMalfunction));
        ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_u8IPAMalfunction));
        u8OperationStatus = m_Value_u8IPAMalfunction;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Message_Display_Request =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPAMode & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPAMode));
        ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_bIPAMode));
        u8RequestedStatus = (tU8) m_Value_bIPAMode;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Mode_Change_Request =  signal data status NOK!                 "));
        bReturnValue &= FALSE;
    }

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_IPA_SwitchMaskStatus                                     */
/******************************************************************************/
/**
*  \brief       reads the IPA Switch Mask
*
*  \param       reference to the switch mask Status
*  \return      read access successful
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_SwitchMaskStatus(tU8& u8SwitchMaskStatus)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_SwitchMaskStatus(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPASwitchMask));
    ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_u8IPASwitchMask));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPASwitchMask & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        u8SwitchMaskStatus = m_Value_u8IPASwitchMask;
        bReturnValue = TRUE;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Switch_mask_Request =  signal data status NOK!                 "));
    }

    return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     bGet_IPA_DirectionStatus                                      */
/******************************************************************************/
/**
*  \brief       reads the IPA Direction Status
*
*  \param       reference to the Camera Indicator Direction Status
*  \return      read access successful
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_IPA_DirectionStatus(tU8& u8DirectionStatus)
{
    tBool bReturnValue = FALSE;

    ETG_TRACE_USR4((" CL-VCAN  :: bGet_IPA_DirectionStatus(): ......... entered! -------------------------------"));
    ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_u32IPACameraIndicatorReq));
    ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_u8IPACameraIndicatorReq));

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32IPACameraIndicatorReq & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
        u8DirectionStatus = m_Value_u8IPACameraIndicatorReq;
        bReturnValue = TRUE;
    }
    else {
        ETG_TRACE_USR4((" CL-VCAN  :: CSM_C_ASIG_RX_IPA_Camera_Indicator_Request =  signal data status NOK!                 "));
    }

    return bReturnValue;
}
 
/******************************************************************************/
/* FUNCTION     bGetAffordableItsSignals                                      */
/******************************************************************************/
/**
*  \brief       reads the Affordable ITS relevant signals
*
*  \param       references to variables for the affordable ITS relevant signals
*  \return      read access successful
*/
/******************************************************************************/
//tBool dispvidctrl_tclClientVcan::bGetAffordableItsSignals(tBool& bItsMod, tBool& bItsBsw, tBool& bItsLdw, tBool& bItsAvailable)
tBool dispvidctrl_tclClientVcan::bGetAffordableItsSignals(tBool& bItsMod, tBool& bItsAvailable)
{
   tBool bReturnValue = TRUE;

   if (CSM_C_SIGNAL_ARRIVED == (m_u32SetITSStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
      bItsAvailable = (tBool) m_u8SetITSValue;
   }
   else {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGetAffordableItsSignals(): signal NOK!  u32StatusRead_Setting_ITS = %-12x", m_u32SetITSStatus));
   }

   if (CSM_C_SIGNAL_ARRIVED == (m_u32MODStatusStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
      bItsMod = (tBool) m_u8MODStatusValue;
   }
   else {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGetAffordableItsSignals(): signal NOK!  u32StatusRead_MOD_Status = %-13x", m_u32MODStatusStatus));
   }

   /*
   if (CSM_C_SIGNAL_ARRIVED == (m_u32BSWStatusStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
      bItsBsw = (tBool) m_u8BSWStatusValue;
   }
   else {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGetAffordableItsSignals(): signal NOK!  u32StatusRead_BSW_Status = %-13x", m_u32BSWStatusStatus));
   }

   if (CSM_C_SIGNAL_ARRIVED == (m_u32LDWStatusStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
     bItsLdw = (tBool) m_u8LDWStatusValue;
   }
   else {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGetAffordableItsSignals(): signal NOK!  u32StatusRead_LDW_Status = %-13x", m_u32LDWStatusStatus));
   }
   */

   return (bReturnValue);
}

/******************************************************************************/
/* FUNCTION     bGet_SteeringAngleSignal                                      */
/******************************************************************************/
/**
*  \brief       The steering angel signal has a update rate of 10 ms (CAN Frame Period).
*               Therefore it is not configured for an auto update.
*               We will read it when requested.
*               to validate the sterring angle we have to check calibration status
*               and steering fail status in addition
*               Nissan C1N, OldNissanEV:
*               ------------------------
*               - Calibration_Flag
*               - Steering_Angle_Fail_Flag
*               Nissan C1A:
*               -----------
*               - SwaSensorInternalStatus
*               Renault T4V, C1A:
*               -----------------
*               - SwaSensorInternalStatus maybe?
*
*  \param
*
*  \return      tBool - success state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_SteeringAngleSignal(tS32& s32SteeringAngleDeg)
{
#if defined (LSIM)
   tBool  bReturnValue = TRUE;

   s32SteeringAngleDeg = 0;
   return(bReturnValue);
#else

   tBool bReturnValue = TRUE;

   // read signal value and state of SteeringAngle, CalibrationFlag
   vGetSteering_Angle();
// Calibration_Flag and Steering_Sensor_Fail-Flag signals not available in Scope2.1 (T4VS, C1A)
#if defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE1) || defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2)
   //vGetCalibration_Flag();         // commented because it configured for auto update
   vGetSteering_Sensor_Fail_Flag();  // will be polled currrently  todo: it can be configured for auto update
#endif

   if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32SteeringAngle & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
   {
      tS16 s16SteeringAngle;

      ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): --- current values ----------------------------------"));
      ETG_TRACE_USR4((" CSM-IF   :: m_Status_u32SteeringAngle = ............. %-40x", m_Status_u32SteeringAngle));
      ETG_TRACE_USR4((" CSM-IF   :: m_Value_s16SteeringAngle = .............. %-40d", m_Value_s16SteeringAngle));

      s16SteeringAngle = m_Value_s16SteeringAngle;

      // this are the range check values for CAN Gen5
      // todo: if CAN Gen3 should come into focus we have to differentiate here
      if ( (s16SteeringAngle >= ((tS16) 0xD5D0)) && (s16SteeringAngle <= ((tS16) 0x2A30)) ) //range check
      {
         m_bSteeringSignal_UNAVAILABLE = FALSE;
         //calculate physical value from raw data
         //s32SteeringAngleDeg = (tS32) (s16SteeringAngle * 0.1);
         //set value with raw data
         s32SteeringAngleDeg = (tS32) s16SteeringAngle;
      }
      else
      {
         ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): ............  steering angle value out of range!     "));
         m_bSteeringSignal_UNAVAILABLE = TRUE;
      }
   }
   else
   {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): state NOK! = %-40x", m_Status_u32SteeringAngle));
   }

// signals not available in Scope2.1 (T4VS, C1A)
#if defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE1) || defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2)
   // for Nissan C1A we have to check SwaSensorInternalStatus for calibration status
   if (m_Config_u8VCANDiversity == DISPVIDCTRL_AllianceVCANSlot_Type_C1A) {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32SwaSensorInternalStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (5 != m_Value_u8SwaSensorInternalStatus) // 5 = "calibrated, initialised"
         {
            bReturnValue = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): due to SwaSensorInternalStatus: calibration is unfinished!              "));
         }
      }
      else
      {
         bReturnValue = FALSE;
         ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): state of SwaSensorInternalStatus signal NOK! state = %-7x", m_Status_u32SwaSensorInternalStatus));
      }
   }
   // for Nissan C1N and OldNissan_EV we have to check Calibration_Flag and Steering_Sensor_Fail_Flag
   else {
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32CalibrationFlag & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (0 == m_Value_u8CalibrationFlag)
         {
            bReturnValue = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): due to flag: calibration is unfinished!              "));
         }
      }
      else
      {
         bReturnValue = FALSE;
         ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): state of calibration flag signal NOK! state = %-7x", m_Status_u32CalibrationFlag));
      }
      
      if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32SteeringSensorFailFlag & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
      {
         if (0 == m_Value_u8SteeringsensorFailFlag)
         {
            bReturnValue = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): due to flag: sensor not ok!              "));
         }
      }
      else
      {
         bReturnValue = FALSE;
         ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal(): state of steering sensor fail flag signal NOK! state = %-7x", m_Status_u32SteeringSensorFailFlag));
      }
   }
#endif

   if (bReturnValue == TRUE)
   {
      m_bSteeringSignalFail = FALSE;
      m_bSteeringSignal_OK = TRUE;
   }
   else
   {
      //start verification timer
      m_bSteeringSignalFail = TRUE;
      ETG_TRACE_USR4((" CSM-IF   :: bGet_SteeringAngleSignal calls _bSetTimer_SteeringSignal()      "));
      (tVoid) _bSetTimer_SteeringSignal( (OSAL_tMSecond) DISPVIDCTRL_CLIENT_VCAN_STEERING_FAIL_RECHECK_TIME_IN_MS);
   }

   // SteeringSensorFailFlag or SteeringSignal has a failure: show no dynamic guidelines
   if ( (m_bSteeringFlag_OK == FALSE) ||
        (m_bSteeringSignal_OK == FALSE) ||
        (m_bSteeringSignal_UNAVAILABLE == TRUE) )
   {
      bReturnValue = FALSE;
   }

   return(bReturnValue);
#endif
}

/******************************************************************************/
/* FUNCTION     bGet_FrontSteerPinionAngleSignal                              */
/******************************************************************************/
/**
*  \brief       get raw data
*
*  \param
*
*  \return      tBool - success state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_FrontSteerPinionAngleSignal(tS32& s32FrontSteerPinionAngleDeg)
{
#if defined (LSIM)
   tBool  bReturnValue = TRUE;

   s32FrontSteerPinionAngleDeg = 0;
   return(bReturnValue);
#else

   tBool bReturnValue = TRUE;

   // read signal value and state of SteeringAngle, CalibrationFlag
   vGetACTIVE_STEER_FAIL();
   vGetFRONT_STEER_PINION_ANGLE();

   if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32FrontSteerPinionAngle & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
   {
      tS16 s16FrontSteerPinionAngle;

      ETG_TRACE_USR4((" CSM-IF   :: bGet_FrontSteerPinionAngleSignal(): --- current values -------------------------"));
      ETG_TRACE_USR4((" CSM-IF   :: m_Status_u32FrontSteerPinionAngle = .... %-40x", m_Status_u32FrontSteerPinionAngle));
      ETG_TRACE_USR4((" CSM-IF   :: m_Value_s16FrontSteerPinionAngle = ..... %-40d", m_Value_s16FrontSteerPinionAngle));

      s16FrontSteerPinionAngle = m_Value_s16FrontSteerPinionAngle;

      if ( (s16FrontSteerPinionAngle >= ((tS16) 0x8000)) && (s16FrontSteerPinionAngle <= ((tS16) 0x7FFE)) ) //range check
      {
         m_bSteeringSignal_UNAVAILABLE = FALSE;
         //calculate physical value from raw data
         //s32FrontSteerPinionAngleDeg = (tS32) (s16FrontSteerPinionAngle * 0.1);
         //set value with raw data
         s32FrontSteerPinionAngleDeg = (tS32) s16FrontSteerPinionAngle;
      }
      else
      {
         ETG_TRACE_USR4((" CSM-IF   :: bGet_FrontSteerPinionAngleSignal(): ............  steering angle value out of range!     "));
         m_bSteeringSignal_UNAVAILABLE = TRUE;
      }
      m_bSteeringSignal_OK = TRUE;
   }
   else
   {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGet_FrontSteerPinionAngleSignal(): state NOK! = %-40x", m_Status_u32FrontSteerPinionAngle));
   }

   if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32ActiveSteerFail & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
   {
       if ( m_Value_u8ActiveSteerFail == 0x00 )
       {
           bReturnValue = FALSE;
           ETG_TRACE_USR4((" CSM-IF   :: bGet_FrontSteerPinionAngleSignal(): Active Steer Fail is set!              "));
       }
   }
   else
   {
       bReturnValue = FALSE;
       ETG_TRACE_USR4((" CSM-IF   :: bGet_FrontSteerPinionAngleSignal(): state NOK! = %-40x", m_Status_u32ActiveSteerFail));
   }

   if (bReturnValue == TRUE)
   {
      m_bSteeringSignalFail = FALSE;
      m_bSteeringSignal_OK = TRUE;
   }
   else
   {
      //start verification timer
      m_bSteeringSignalFail = TRUE;
      ETG_TRACE_USR4((" CSM-IF   :: bGet_FrontSteerPinionAngleSignal calls _bSetTimer_SteeringSignal()      "));
      (tVoid) _bSetTimer_SteeringSignal( (OSAL_tMSecond) DISPVIDCTRL_CLIENT_VCAN_STEERING_FAIL_RECHECK_TIME_IN_MS);
   }

   // SteeringSensorFailFlag or SteeringSignal has a failure: show no dynamic guidelines
   if ( (m_bSteeringFlag_OK == FALSE) ||
        (m_bSteeringSignal_OK == FALSE) ||
        (m_bSteeringSignal_UNAVAILABLE == TRUE) )
   {
      bReturnValue = FALSE;
   }
   else
   {
      bReturnValue = TRUE;
   }

   return(bReturnValue);
#endif
}

/******************************************************************************/
/* FUNCTION     bGet_VehicleSpeedSignal                                       */
/******************************************************************************/
/**
*  \brief
*
*  \param
*
*  \return      tBool - success state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::bGet_VehicleSpeedSignal(tU32& u32VehicleSpeedValue)
{
   tBool bReturnValue = TRUE;

   // read signal value and state of VehicleSpeed
   vGetVehicleSpeed();
   //if (! (m_Status_u32VehicleSpeed & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
   if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32VehicleSpeed & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
   {
      ETG_TRACE_USR4((" CSM-IF   :: bGet_VehicleSpeedSignal(): --- current values -------------------------"));
      ETG_TRACE_USR4((" CSM-IF   :: m_Status_u32VehicleSpeed = .... %-40x", m_Status_u32VehicleSpeed));
      ETG_TRACE_USR4((" CSM-IF   :: m_Value_u32VehicleSpeed = ..... %-40d", m_Value_u32VehicleSpeed));
      //ETG_TRACE_USR4(("dispvidctrl_tclClientVcan::onVehicleSpeed_2D3Status(): m_Value_u32VehicleSpeed = %d", m_Value_u32VehicleSpeed));
      if (m_Value_u32VehicleSpeed != 0xFFFF)
      {
         //calculate physical value from raw data; Resolution is 0.01 km/h
         u32VehicleSpeedValue = (tU32) ( m_Value_u32VehicleSpeed * 0.01 );
         ETG_TRACE_USR4((" CSM-IF   :: bGet_VehicleSpeedSignal(): u32VehicleSpeedValue = %-40d", u32VehicleSpeedValue));
      }
      else
      {
         bReturnValue = FALSE;
         ETG_TRACE_USR4((" CSM-IF   :: bGet_VehicleSpeedSignal(): m_Value_u32VehicleSpeed = 0x%-40x", m_Value_u32VehicleSpeed));
         ETG_TRACE_USR4((" CSM-IF   :: bGet_VehicleSpeedSignal(): signal value = invalid!"));
      }
   }
   else
   {
      bReturnValue = FALSE;
      ETG_TRACE_USR4((" CSM-IF   :: bGet_VehicleSpeedSignal(): state NOK! = %-40x", m_Status_u32VehicleSpeed));
   }

   return bReturnValue;
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_SteeringFail                                       */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       timeout value
*  \return      tBool - timer start success state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::_bSetTimer_SteeringFail( OSAL_tMSecond msTimeout ) const
{
   tBool bSuccess = TRUE;
   if ( OSAL_C_INVALID_HANDLE != m_hTimerHandle_SteeringFail )   {
      if (msTimeout)
      {
         if ( OSAL_s32TimerSetTime( m_hTimerHandle_SteeringFail, msTimeout, 0 ) != OSAL_OK )   {
            bSuccess = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_SteeringFail(): failed to set timer to %d ms!", msTimeout));
         }
      }
      else
      {
         if ( OSAL_s32TimerSetTime( m_hTimerHandle_SteeringFail, 0, 0 ) != OSAL_OK )   {
            bSuccess = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_SteeringFail(): failed to stop timer!"));
         }
      }
   }
   return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_SteeringFail                                 */
/******************************************************************************/
/**
*  \brief       verify if steering failure exists and stop dynamic guidelines
*               accordingly
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclClientVcan::_pfCallbackTimer_SteeringFail(tVoid* pArg)
{
   ETG_TRACE_USR4((" CSM-IF   :: _pfCallbackTimer_SteeringFail(): verification Timeout!"                 ));
   // get pointer to myself from argument
   dispvidctrl_tclClientVcan* po_ClientVcan = (dispvidctrl_tclClientVcan*)pArg;
   if (po_ClientVcan)
   {
      if (TRUE == po_ClientVcan->m_bItcSteeringFlagFail)
      {
         po_ClientVcan->m_bSteeringFlag_OK = FALSE;
         // report ITC as Failed
         if (po_ClientVcan->m_poClientDiaglogIf)
         {
            //ETG_TRACE_USR1((" CSM-IF   :: _pfCallbackTimer_SteeringFail(): Report ITC as FAILED"));
            po_ClientVcan->m_poClientDiaglogIf->vSetITC(enITC_ID_ANGLE_SENSOR_CALIBRATION, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
         }
      }
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_SteeringSignal                                     */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       timeout value
*  \return      tBool - timer start success state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::_bSetTimer_SteeringSignal( OSAL_tMSecond msTimeout ) const
{
   tBool bSuccess = TRUE;
   OSAL_tMSecond msRemainingTime = 0;
   if ( OSAL_C_INVALID_HANDLE != m_hTimerHandle_SteeringSignal )   {
      if (msTimeout != 0)
      {
         if ( OSAL_s32TimerGetTime( m_hTimerHandle_SteeringSignal, &msRemainingTime, 0) == OSAL_OK )
         {
            if ( msRemainingTime > 0 )
            {
               ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_SteeringSignal(): Timer is still running!"));
            }
            else if ( OSAL_s32TimerSetTime( m_hTimerHandle_SteeringSignal, msTimeout, 0 ) != OSAL_OK )
            {
               bSuccess = FALSE;
               ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_SteeringSignal(): failed to set timer to %d ms!", msTimeout));
            }
         }
         else
         {
            bSuccess = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_SteeringSignal(): failed to get remaining time!"));
         }
      }
      else
      {
         if ( OSAL_s32TimerSetTime( m_hTimerHandle_SteeringSignal, 0, 0 ) != OSAL_OK )
         {
            bSuccess = FALSE;
            ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_SteeringSignal(): failed to stop timer!"));
         }
      }
   }
   return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_SteeringSignal                               */
/******************************************************************************/
/**
*  \brief       verify if steering signal is valid again, otherwise stop dynamic guidelines
*               accordingly
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclClientVcan::_pfCallbackTimer_SteeringSignal(tVoid* pArg)
{
   ETG_TRACE_USR4((" CSM-IF   :: _pfCallbackTimer_SteeringSignal(): verification Timeout!"));
   // get pointer to myself from argument
   dispvidctrl_tclClientVcan* po_ClientVcan = (dispvidctrl_tclClientVcan*)pArg;
   if (po_ClientVcan)
   {
      if (TRUE == po_ClientVcan->m_bSteeringSignalFail)
      {
         po_ClientVcan->m_bSteeringSignal_OK = FALSE;
      }
      else
      {
         po_ClientVcan->m_bSteeringSignal_OK = TRUE;
      }
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_FrameTimeoutConfirmed                              */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       timeout value
*  \return      tBool - timer start success state
*/
/******************************************************************************/
tBool dispvidctrl_tclClientVcan::_bSetTimer_FrameTimeoutConfirmed(OSAL_tMSecond msTimeout) const
{
    tBool bSuccess = TRUE;
// No need of the timer for Scope 2
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    if ( OSAL_C_INVALID_HANDLE != m_hTimerHandle_FrameTimeoutConfirmed )   {
       if (msTimeout)
       {
          if ( OSAL_s32TimerSetTime( m_hTimerHandle_FrameTimeoutConfirmed, msTimeout, 0 ) != OSAL_OK )   {
             bSuccess = FALSE;
             ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_FrameTimeoutConfirmed(): failed to set timer to %d ms!", msTimeout));
          }
       }
       else
       {
          if ( OSAL_s32TimerSetTime( m_hTimerHandle_FrameTimeoutConfirmed, 0, 0 ) != OSAL_OK )   {
             bSuccess = FALSE;
             ETG_TRACE_USR4((" CSM-IF   :: _bSetTimer_FrameTimeoutConfirmed(): failed to stop timer!"));
          }
       }
    }
#else
    (tVoid) msTimeout;
#endif
    return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_FrameTimeoutConfirmed                        */
/******************************************************************************/
/**
*  \brief       verify if steering signal is valid again, otherwise stop dynamic guidelines
*               accordingly
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclClientVcan::_pfCallbackTimer_FrameTimeoutConfirmed(tVoid* pArg)
{
   ETG_TRACE_USR4((" CSM-IF   :: _pfCallbackTimer_FrameTimeoutConfirmed(): verification Timeout!"));
   // get pointer to myself from argument
   tBool bTimedout = FALSE;
   dispvidctrl_tclClientVcan* po_ClientVcan = (dispvidctrl_tclClientVcan*)pArg;
   if (po_ClientVcan)
   {
      if (TIMEOUT_TRUE == po_ClientVcan->m_enAvmCanMsgTimeOutState)
      {
         po_ClientVcan->m_enAvmCanMsgTimeOutState = TIMEOUT_CONFIRMED;
         bTimedout = TRUE;
      }

      if (TIMEOUT_TRUE == po_ClientVcan->m_enMvcCanMsgTimeOutState)
      {
         po_ClientVcan->m_enMvcCanMsgTimeOutState = TIMEOUT_CONFIRMED;
         bTimedout = TRUE;
      }

      const tChar strIfName[] = "dispvidctrl_tclClientVcan";
      dispvidctrl_tclAppMain::theServer()->vPostMsgTriggerCanMsgConfirmTimeout(strIfName, bTimedout);
   }
   return 0;
}


tVoid dispvidctrl_tclClientVcan::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
    ETG_TRACE_USR4((" CSM-IF   :: vGetConfiguration(): "));
    m_Config_u8CameraSteeringMessageType = pStConfigurationValues->u8CameraSteeringMessageType;
    m_bRvcMode = pStConfigurationValues->bRvcMode;
	m_Config_u8VCANDiversity = pStConfigurationValues->u8VCANDiversity;
	 #ifdef VARIANT_S_FTR_ENABLE_SMART
	 m_Config_u8VCANDiversity = 1;
	 #endif
    m_bFapMode = pStConfigurationValues->bAvmType_Fap;
    m_bIpaMode = pStConfigurationValues->bAvmType_Ipa;
    m_bMvcMode = pStConfigurationValues->bMvcMode;
}

tVoid dispvidctrl_tclClientVcan::vCheckAndSendITCStatus(tVoid)
{
    tU8 u8Result = midw_fi_tcl_e8_TestResult::FI_EN_NORESULT;
    if (m_bRvcMode) {
    
    if ( m_Config_u8CameraSteeringMessageType == 0x00 ) {
        if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32CalibrationFlag & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
            if (m_bErrorQualificationUnlocked_SensorCalibration == TRUE)
            {
               // Calibration unFinished log DTC
               if ( m_Value_u8CalibrationFlag == 0x00 ) {
                  //ETG_TRACE_USR1((" CSM-IF   :: vCheckAndSendITCStatus(): Report ITC as FAILED"));
                  u8Result = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
               } else {
                  //ETG_TRACE_USR1((" CSM-IF   :: vCheckAndSendITCStatus(): Report ITC as PASSED"));
                  u8Result = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
               }
            }
        }
    } else if ( m_Config_u8CameraSteeringMessageType == 0x01 ) {
        if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32ActiveSteerFail & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
            // Calibration unFinished log DTC
            if ( m_Value_u8ActiveSteerFail == 0x01 ) {
                u8Result = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
            } else {
                u8Result = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
            }
        }
    } else {
    }
    }
    DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientDiaglogIf);
    m_poClientDiaglogIf->vSetITC(enITC_ID_ANGLE_SENSOR_CALIBRATION, (midw_fi_tcl_e8_TestResult::tenType)(u8Result));
}

tBool dispvidctrl_tclClientVcan::bIsSteeringAngleInfoValid() const
{
    tBool bRetVal = FALSE;

    if ( m_Config_u8CameraSteeringMessageType == 0x00 )
    {
        // CAN Frame 0x002
        if (   (CSM_C_SIGNAL_ARRIVED == (m_Status_u32SteeringSensorFailFlag & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID)))
            && (CSM_C_SIGNAL_ARRIVED == (m_Status_u32CalibrationFlag & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID)))
            && (CSM_C_SIGNAL_ARRIVED == (m_Status_u32SteeringAngle & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID))) )
        {
            if ( ( m_Value_u8SteeringsensorFailFlag == 0x01 ) && ( m_Value_u8CalibrationFlag == 0x01) )
            {
                bRetVal = TRUE;
            }
        }
    }
    else if ( m_Config_u8CameraSteeringMessageType == 0x01 )
    {
        // CAN Frame 0x0C1
        if (   (CSM_C_SIGNAL_ARRIVED == (m_Status_u32ActiveSteerFail & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID)))
            && (CSM_C_SIGNAL_ARRIVED == (m_Status_u32FrontSteerPinionAngle & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID))) )
        {
            if ( m_Value_u8ActiveSteerFail == 0x01 )
            {
                bRetVal = TRUE;
            }
        }
    }

    return bRetVal;
}

tBool dispvidctrl_tclClientVcan::bGet_ReverseGearEngagedStatus(tVoid)
{
    tBool bReturnValue = FALSE;

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32RearGearEngaged & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
    {
       ETG_TRACE_USR4((" CSM-IF   :: bGet_ReverseGearEngagedStatus(): --- current values -------------------------"));
       ETG_TRACE_USR4((" CSM-IF   :: m_Status_u32RearGearEngaged = .... %-40x", m_Status_u32RearGearEngaged));
       ETG_TRACE_USR4((" CSM-IF   :: m_u8RearGearEngaged = ..... %-40d", m_u8RearGearEngaged));

       // Reverse is engaged
       if (m_u8RearGearEngaged == 0x02)
       {
           bReturnValue = TRUE;
           ETG_TRACE_USR4((" CSM-IF   :: bGet_ReverseGearEngagedStatus(): CAN Reverse is TRUE"));
       }
       else
       {
          bReturnValue = FALSE;
          ETG_TRACE_USR4((" CSM-IF   :: bGet_ReverseGearEngagedStatus(): CAN Reverse is FALSE"));
       }
    }
    else
    {
       bReturnValue = FALSE;
       ETG_TRACE_USR4((" CSM-IF   :: bGet_ReverseGearEngagedStatus(): state NOK! = %-40x", m_Status_u32RearGearEngaged));
    }

    return bReturnValue;
}

tBool dispvidctrl_tclClientVcan::bGet_TailgateStatus(tBool& bTailgateOpen) const
{
    tBool bReturnValue = FALSE;

    if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32TailGateStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
    {
       ETG_TRACE_USR4((" CSM-IF   :: bGet_TailgateStatus(): --- current values -------------------------"));
       ETG_TRACE_USR4((" CSM-IF   :: m_Status_u32TailGateStatus = .... %-40x", m_Status_u32TailGateStatus));
       ETG_TRACE_USR4((" CSM-IF   :: m_Value_u8TailGateStatus = ...... %-40d", m_Value_u8TailGateStatus));
       
       bReturnValue = TRUE;

       // Tailgate is open
       if (m_Value_u8TailGateStatus == 0x02)
       {
          bTailgateOpen = TRUE;
          ETG_TRACE_USR4((" CSM-IF   :: bGet_TailgateStatus(): Tailgate is Open"));
       }
       else
       {
          bTailgateOpen = FALSE;
          ETG_TRACE_USR4((" CSM-IF   :: bGet_TailgateStatus(): Tailgate is Closed"));
       }
    }
    else
    {
       bReturnValue = FALSE;
       ETG_TRACE_USR4((" CSM-IF   :: bGet_TailgateStatus(): state NOK! = %-40x", m_Status_u32TailGateStatus));
    }

    return bReturnValue;
}

tU8 dispvidctrl_tclClientVcan::u8getDayRheostatedLightMaxPercent()
{
	return m_ValueDayRheostatedLightMaxPercent;

}


tU8 dispvidctrl_tclClientVcan::u8getRheostatedLightMaxPercent()
{
	return m_ValueNightRheostatedLightMaxPercent;

}
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
tVoid dispvidctrl_tclClientVcan::onDayRheostatedLightMaxPercentTTFIsTrigger(tU8 u8DayRheostated)
{
    TDayRheostatedLightMaxPercent tDayRheostatedLightMax;
    tDayRheostatedLightMax.u32Status = 1;
    tDayRheostatedLightMax.DayRheostatedLightMaxPercent = u8DayRheostated;

    onDayRheostatedLightMaxPercentStatus(tDayRheostatedLightMax);

}
#endif

tVoid dispvidctrl_tclClientVcan::vCheck_Fap_ViewChangeRequestSignal(tVoid) const
{
   ETG_TRACE_USR4((" CL-VCAN  :: vCheck_Fap_ViewChangeRequestSignal(): .. entered! -----------------------"));
   ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_FAP_ChangeViewRequestStatus));
   ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_FAP_ChangeViewRequest));

   if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_ChangeViewRequestStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {

      if (m_Value_FAP_ChangeViewRequest == 0) {
         tChar strIfName[] = "dispvidctrl_tclControl_Avm";
         dispvidctrl_tclAppMain::theServer()->vPostMsgControlAvm(strIfName, (tU32) EN_CONTROL_AVM__CAMERA_SCREEN_OFF);
      }
      else {
         // event to switch camera screen on
         tChar strIfName[] = "dispvidctrl_tclControl_Avm";
         dispvidctrl_tclAppMain::theServer()->vPostMsgControlAvm(strIfName, (tU32) EN_CONTROL_AVM__CAMERA_SCREEN_ON);
      }
   }
   else {
      ETG_TRACE_USR4((" CL-VCAN  :: vCheck_Fap_ViewChangeRequestSignal(): ....... signal data status NOK!                 "));
   }
}

tBool dispvidctrl_tclClientVcan::bGet_Fap_ViewChangeRequestSignal(tU8& u8ViewChangeSignalValue)
{
   tBool bReturnValue = FALSE;

   ETG_TRACE_USR4((" CL-VCAN  :: bGet_Fap_ViewChangeRequestSignal(): .... entered! -------------------------------"));
   ETG_TRACE_USR4((" CL-VCAN  :: u32StatusRead = ........................ %-40u", m_Status_FAP_ChangeViewRequestStatus));
   ETG_TRACE_USR4((" CL-VCAN  :: u8Data_ReadValue = ..................... %-40u", m_Value_FAP_ChangeViewRequest));

   if (CSM_C_SIGNAL_ARRIVED == (m_Status_FAP_ChangeViewRequestStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
      u8ViewChangeSignalValue = m_Value_FAP_ChangeViewRequest;
      bReturnValue = TRUE;
   }
   else {
      ETG_TRACE_USR4((" CL-VCAN  :: FAP View_Change_Request 5F1 =  signal data status NOK!                 "));
   }

    return bReturnValue;
}

tU8 dispvidctrl_tclClientVcan::u8GetFapSettingState(tU8 u8SettingType) const
{
   tU8 u8ReturnVal = 0;

   // Use the CAN data only if the CAN Frame is valid
   if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
   {
      switch(u8SettingType)
      {
         case FAP_SETTING_TYPE__FAP_SETTING_AVAILABLE:
            if ( m_Value_Camerasetting_availability == 0x01 || m_Value_Camerasetting_availability == 0x03 )
               u8ReturnVal = 1;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING01:
            u8ReturnVal = m_Value_FAP_Setting01;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING02:
            u8ReturnVal = m_Value_FAP_Setting02;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING03:
            u8ReturnVal = m_Value_FAP_Setting03;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING04:
            u8ReturnVal = m_Value_FAP_Setting04;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING05:
            u8ReturnVal = m_Value_FAP_Setting05;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING06:
            u8ReturnVal = m_Value_FAP_Setting06;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING07:
            u8ReturnVal = m_Value_FAP_Setting07;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING08:
            u8ReturnVal = m_Value_FAP_Setting08;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING09:
            u8ReturnVal = m_Value_FAP_Setting09;
            break;
         case FAP_SETTING_TYPE__FAP_SETTING10:
            u8ReturnVal = m_Value_FAP_Setting10;
            break;
         default:
            break;
      }
   }
   
   return u8ReturnVal;
}

tU8 dispvidctrl_tclClientVcan::u8GetAvmSettingState(tU8 u8SettingType) const
{
   tU8 u8ReturnVal = 0;

   // Use the CAN data only if the CAN Frame is valid
   if (m_enFapCanMsgTimeOutState == TIMEOUT_FALSE)
   {
      switch(u8SettingType)
      {
         case FAP_SETTING_TYPE__AVM_SETTING_AVAILABLE:
            if ( m_Value_Camerasetting_availability == 0x02 || m_Value_Camerasetting_availability == 0x03 )
               u8ReturnVal = 1;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING01:
            u8ReturnVal = m_Value_AVM_Setting_1;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING02:
            u8ReturnVal = m_Value_AVM_Setting_2;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING03:
            u8ReturnVal = m_Value_AVM_Setting_3;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING04:
            u8ReturnVal = m_Value_AVM_Setting_4;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING05:
            u8ReturnVal = m_Value_AVM_Setting_5;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING06:
            u8ReturnVal = m_Value_AVM_Setting_6;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING07:
            u8ReturnVal = m_Value_AVM_Setting_7;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING08:
            u8ReturnVal = m_Value_AVM_Setting_8;
            break;
         case FAP_SETTING_TYPE__AVM_SETTING09:
            u8ReturnVal = m_Value_AVM_Setting_9;
            break;
         default:
            break;
      }
   }
   
   return u8ReturnVal;
}

tU8 dispvidctrl_tclClientVcan::u8GetAvmViewStatus() const
{
   if (CSM_C_SIGNAL_ARRIVED == (m_Status_u32AVM_ChangeViewStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) )
   {
      return m_value_u8AVM_ChangeViewStatus;
   }
   else 
   {
      return 0;
   }
}

tBool dispvidctrl_tclClientVcan::bGetBciStatus(tU8& u8BciStatus) const
{
    u8BciStatus = m_Value_u8BciStatus;
    if ( CSM_C_SIGNAL_ARRIVED == (m_Status_u32BciStatus & (CSM_C_SIGNAL_ARRIVED | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_DATA_INVALID )) ) {
       return TRUE;
    } else {
       return FALSE;
    }
}

tVoid dispvidctrl_tclClientVcan::vWriteDriver_Assistance_SW_flag(tU8 u8SwitchId)
{
    TDriver_Assistance_SW_flag  oBciSwitchSignal;
    
    oBciSwitchSignal.Driver_Assistance_SW_flag = u8SwitchId;
    oBciSwitchSignal.u8TxType                  = CSM_C_TX_AS_CONFIGURED;
    
    vSendDriver_Assistance_SW_flag(oBciSwitchSignal);
}

// dispvidctrl_tclClientVcan::ClassImplementation: user specific code end
//EOF
