/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Idispvidctrl_ClientVcan.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     ICsmClient.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm client interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_VCANCAN_CLIENT_H_
#define _I_VCANCAN_CLIENT_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "dispvidctrl_AppMain.h"

#include "I_dispvidctrl_ClientVcanCanAdaptor.h"

class I_dispvidctrl_tclClientVcan : public dispvidctrl_tclBaseIf
{
public:
   I_dispvidctrl_tclClientVcan(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
   virtual ~I_dispvidctrl_tclClientVcan() {;}

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientVcan"; };

    virtual tVoid vGetUPA_RX_Initializing() = 0;
    virtual tVoid vGetUPA_View_Change_Request() = 0;
    virtual tVoid vGetUPA_BEEP_Sound_Request() = 0;
    virtual tVoid vGetUPA_AOD_Beep1_Request() = 0;
    virtual tVoid vGetUPA_Setting_ITS() = 0;
    virtual tVoid vGetUPA_MOD_Status() = 0;
    virtual tVoid vGetUPA_BEEP_Sound_Type() = 0;
    virtual tVoid vGetSteering_Angle() = 0;
    virtual tVoid vGetCalibration_Flag() = 0;
    virtual tVoid vGetSteering_Sensor_Fail_Flag() = 0;
    virtual tVoid vGetSwaSensorInternalStatus() = 0;
    virtual tVoid vGetFRONT_STEER_PINION_ANGLE() = 0;
    virtual tVoid vGetACTIVE_STEER_FAIL() = 0;
    virtual tVoid vGetVehicleSpeed() = 0;
    virtual tVoid vGetIPA_Mode_Change_Request() = 0;
    virtual tVoid vGetIPA_Switch_Display_Request() = 0;
    virtual tVoid vGetIPA_Switch_mask_Request() = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_01() = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_02() = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_03() = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_04() = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_05() = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_06() = 0;
    virtual tVoid vGetIPA_mode_selection() = 0;
    virtual tVoid vGetIPA_Message_Display_Request() = 0;
    virtual tVoid vGetIPA_Sound_Output_Request() = 0;
    virtual tVoid vGetIPA_Voice_Output_Request() = 0;
    virtual tVoid vGetIPA_region_selection() = 0;
    virtual tVoid vGetIPA_Camera_Indicator_Request() = 0;
    virtual tVoid vGetIPA_Mulfunction() = 0;
    virtual tVoid vGetRearGearEngaged() = 0;
    virtual tVoid vGetMVC_ViewModeStatus() = 0;
    virtual tVoid vGetMVC_WarningDisplayRequest() = 0;
    virtual tVoid vGetTailGateStatus() = 0;
    virtual tVoid vGetAVM_ChangeViewStatus() = 0;
    virtual tVoid vGetAVM_ClosingAuthorization() = 0;
    virtual tVoid vGetMOD_ActivationState() = 0;
    virtual tVoid vGetFAP_ModeChangeRequest() = 0;
    virtual tVoid vGetCamerasetting_availability() = 0;
    virtual tVoid vGetFAP_Setting01() = 0;
    virtual tVoid vGetFAP_Setting02() = 0;
    virtual tVoid vGetFAP_Setting03() = 0;
    virtual tVoid vGetFAP_Setting04() = 0;
    virtual tVoid vGetFAP_Setting05() = 0;
    virtual tVoid vGetFAP_Setting06() = 0;
    virtual tVoid vGetFAP_Setting07() = 0;
    virtual tVoid vGetFAP_Setting08() = 0;
    virtual tVoid vGetFAP_Setting09() = 0;
    virtual tVoid vGetFAP_Setting10() = 0;
    virtual tVoid vGetAVM_Setting_1() = 0;
    virtual tVoid vGetAVM_Setting_2() = 0;
    virtual tVoid vGetAVM_Setting_3() = 0;
    virtual tVoid vGetAVM_Setting_4() = 0;
    virtual tVoid vGetAVM_Setting_5() = 0;
    virtual tVoid vGetAVM_Setting_6() = 0;
    virtual tVoid vGetAVM_Setting_7() = 0;
    virtual tVoid vGetAVM_Setting_8() = 0;
    virtual tVoid vGetAVM_Setting_9() = 0;
    virtual tVoid vGetFAP_PurposeSwitchAvailability() = 0;
    virtual tVoid vGetFAP_ChangeViewRequest() = 0;
    virtual tVoid vGetFAP_SoundDirection() = 0;
    virtual tVoid vGetFAP_SoundLevelControl() = 0;
    virtual tVoid vGetFAP_SoundPatternRequest() = 0;
    virtual tVoid vGetFAP_VoicePatternRequest() = 0;
    virtual tVoid vGetDayRheostatedLightMaxPercent() = 0;
    virtual tVoid vGetNightRheostatedLightMaxPercent() = 0;
    virtual tVoid vGetDimmingState() = 0;
    virtual tVoid vGetSTATUS_DYNAMIC_REAR() = 0;

    virtual tVoid vSendUPA_TX_Initializing(TUPA_TX_Initializing tTxSignal) = 0;
    virtual tVoid vSendUPA_Camera_Switch_Press(TUPA_Camera_Switch_Press tTxSignal) = 0;
    virtual tVoid vSendUPA_Camera_Switch_Keep(TUPA_Camera_Switch_Keep tTxSignal) = 0;
    virtual tVoid vSendUPA_Camera_OFF_Request(TUPA_Camera_OFF_Request tTxSignal) = 0;
    virtual tVoid vSendUPA_Setting_Language_Request(TUPA_Setting_Language_Request tTxSignal) = 0;
    virtual tVoid vSendUPA_MOD_Switch_Press(TUPA_MOD_Switch_Press tTxSignal) = 0;
    virtual tVoid vSendIPA_Activation_flug(TIPA_Activation_flug tTxSignal) = 0;
    virtual tVoid vSendIPA_SW_Long_Press(TIPA_SW_Long_Press tTxSignal) = 0;
    virtual tVoid vSendIPA_SW_Operation_Status(TIPA_SW_Operation_Status tTxSignal) = 0;
    virtual tVoid vSendMVC_ViewModeRequest(TMVC_ViewModeRequest tTxSignal) = 0;
    virtual tVoid vSendFAP_SwitchOperationStatus(TFAP_SwitchOperationStatus tTxSignal) = 0;
    virtual tVoid vSendFAP_Screen_Activation_flag(TFAP_Screen_Activation_flag tTxSignal) = 0;
    virtual tVoid vSendFAP_ScreenPressCoordinateX(TFAP_ScreenPressCoordinateX tTxSignal) = 0;
    virtual tVoid vSendFAP_ScreenPressCoordinateY(TFAP_ScreenPressCoordinateY tTxSignal) = 0;
    virtual tVoid vSendFAP_ScreenPressDetected(TFAP_ScreenPressDetected tTxSignal) = 0;
    virtual tVoid vSendHorizontalDilutionOfPrecision(THorizontalDilutionOfPrecision tTxSignal) = 0;
    virtual tVoid vSendVerticalDilutionOfPrecision(TVerticalDilutionOfPrecision tTxSignal) = 0;
    virtual tVoid vSendSatNUM(TSatNUM tTxSignal) = 0;
    virtual tVoid vSendGroundSpeed(TGroundSpeed tTxSignal) = 0;
    virtual tVoid vSendSatelliteGPSCount(TSatelliteGPSCount tTxSignal) = 0;
    virtual tVoid vSendFAP_ActivationRequest(TFAP_ActivationRequest tTxSignal) = 0;
    virtual tVoid vSendSwitchRequest_AVM(TSwitchRequest_AVM tTxSignal) = 0;
    virtual tVoid vSendChangeViewRequest_AVM(TChangeViewRequest_AVM tTxSignal) = 0;
    virtual tVoid vSendMOD_ActivationRequest2(TMOD_ActivationRequest2 tTxSignal) = 0;
    virtual tVoid vSendDimmingReq(TDimmingReq tTxSignal) = 0;
    virtual tVoid vSendDriver_Assistance_SW_flag(TDriver_Assistance_SW_flag tTxSignal) = 0;

   // I_dispvidctrl_tclClientVcan::ClassImplementation: user specific code start
   // enumeration of user action events.
   enum tenControl_ClientCsm
   {
      EN_CONTROL_CLIENT_CSM__NONE  = 0,
      EN_CONTROL_CLIENT_CSM__SYSPWRMODE_RUN
      //------------------------------------
   };

    virtual tVoid vHandleControl(tenControl_ClientCsm enControl, tU32 u32Value = 0) = 0;
    virtual tVoid vCheckInitialisingSignal(tVoid) const = 0;
    virtual tVoid vCheckViewChangeRequestSignal(tVoid) const = 0;
    virtual tVoid vWriteUPA_TX_Initializing(tU8 u8SignalValue) = 0;
    virtual tVoid vWriteUPA_Setting_Language_Request(tU8 u8AvmLanguage) = 0;
    virtual tVoid vWriteUPA_Camera_OFF_Request(tBool bReinit) = 0;
    virtual tVoid vWriteUPA_Camera_Switch_Keep(tBool bReinit) = 0;
    virtual tVoid vWriteUPA_Camera_Switch_Press(tBool bReinit) = 0;
    virtual tVoid vWriteUPA_MOD_Switch_Press(tBool bReinit) = 0;
    virtual tVoid vWriteIPA_Activation_Flag(tBool bFlag) = 0;
    virtual tVoid vWriteIPA_SW_Long_Press(tBool bSWLongPress) = 0;
    virtual tVoid vWriteIPA_SW_Operation_Status(tU8 u8Status) = 0;
    virtual tVoid vWriteAVM_Switch_Request(tU8 u8Request) = 0;
    virtual tVoid vWriteAVM_View_Change_Request(tU8 u8Request) = 0;
    virtual tVoid vWriteMVC_ViewModeRequest(tU8 u8Request) = 0;
    virtual tVoid vWriteAVM_MOD_Activation_Request(tU8 u8Request) = 0;
    
    virtual tVoid vWriteFAP_ScreenPressCoordinateX(tU8 u8Data) = 0;
    virtual tVoid vWriteFAP_ScreenPressCoordinateY(tU8 u8Data) = 0;
    virtual tVoid vWriteFAP_ScreenPressDetected(tU8 u8Data) = 0;
    virtual tVoid vWriteFAP_Screen_Activation_flag(tU8 u8Data) = 0;

    //virtual tVoid vWriteLDW_PRESS_5FE(tBool bReinit) = 0;
    //virtual tVoid vWriteBSW_PRESS_5FE(tBool bReinit) = 0;
    virtual tVoid vInvalidateCsmRx(tVoid) = 0;
    virtual tBool bGetViewChangeRequestSignal(tU8& u8ViewChangeSignalValue) = 0;
    virtual tBool bGetAffordableItsSignals(tBool& bItsMod, tBool& bItsAvailable) = 0;
    virtual tBool bGet_MVC_ViewModeStatus(tU8& u8ViewStatus) = 0;
    virtual tBool bGet_MVC_WarningDisplayRequest(tU32& u32Request) = 0;
    //virtual tBool bGetAffordableItsSignals(tBool& bItsMod, tBool& bItsBsw, tBool& bItsLdw, tBool& bItsAvailable) = 0;
    virtual tBool bGet_VehicleSpeedSignal(tU32& u32VehicleSpeedValue) = 0;
    virtual tBool bGet_SteeringAngleSignal(tS32& s32SteeringAngleDeg) = 0;
    virtual tBool bGet_FrontSteerPinionAngleSignal(tS32& s32FrontSteerPinionAngleDeg) = 0;
    virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues) = 0;
    virtual tBool bIsSteeringAngleInfoValid() const = 0;
    
    virtual tU8   u8GetFapSettingState(tU8 u8SettingType) const = 0;
    virtual tU8   u8GetAvmSettingState(tU8 u8SettingType) const = 0;
    
    virtual tU8   u8GetAvmViewStatus() const = 0;
    
    // IPA related
    virtual tBool bGet_IPA_SwitchesSignals(tU8& u8SwitchesSignalsValue) = 0;
    virtual tBool bGet_IPA_PatternDisplayStatus(tU8& u8SwitchDisplayValue) = 0;
    virtual tBool bGet_IPA_MessageDisplaySignals(tU8& u8MessageDisplayValue) = 0;
    virtual tBool bGet_IPA_ConfigurationStatus(tU8& u8RegionSelection) = 0;
    virtual tBool bGet_IPA_OperationStatus(tU8& u8OperationStatus, tU8& u8RequestedStatus) = 0;
    virtual tBool bGet_IPA_SwitchMaskStatus(tU8& u8SwitchMaskStatus) = 0;
    virtual tBool bGet_IPA_DirectionStatus(tU8& u8DirectionStatus) = 0;

    virtual tBool bGet_ReverseGearEngagedStatus(tVoid) = 0;
    virtual tBool bGet_TailgateStatus(tBool& bTailgateOpen) const = 0;
    virtual tU8  u8getDayRheostatedLightMaxPercent(tVoid)=0;
    virtual tU8  u8getRheostatedLightMaxPercent(tVoid)=0;

    virtual tVoid vCheck_Fap_ViewChangeRequestSignal(tVoid) const = 0;
    virtual tBool bGet_Fap_ViewChangeRequestSignal(tU8& u8ViewChangeSignalValue) = 0;
    
    virtual tBool bGetBciStatus(tU8& bBciStatus) const = 0;
    virtual tVoid vWriteDriver_Assistance_SW_flag(tU8 u8SwitchId) = 0;
    
   // I_dispvidctrl_tclClientVcan::ClassImplementation: user specific code end
};

#endif // _I_VCANCAN_CLIENT_H_
