/******************************************************************************/
/**
* \file    dispvidctrl_tclVideoPlayer.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/

#include "dispvidctrl_tclVideoPlayer.h"
#include "dispvidctrl_tclGstAnimation.h"
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
#include "dispvidctrl_tclGstDualAnimation.h"
#endif
#include "dispvidctrl_tclGstRvc.h"

#include "I_dispvidctrl_tclSyncHandler.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VIDEOPLAYER
#include "trcGenProj/Header/dispvidctrl_tclVideoPlayer.cpp.trc.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/

#define VIDEOPLAYER_STACKSIZE 2048
#define VIDEOPLAYER_PRIORITY   100

GMainLoop *mainloop=NULL;


dispvidctrl_tclVideoPlayer* dispvidctrl_tclVideoPlayer::_poMyStaticRef = NULL;
/******************************************************************************/
/* FUNCTION     dispvidctrl_tclVideoPlayer()                                  */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclVideoPlayer::dispvidctrl_tclVideoPlayer(dispvidctrl_tclAppMain* poMainAppl)
: I_dispvidctrl_tclVideoPlayer(poMainAppl)
, m_s32SteeringWheelAngle(0)
, m_s32RearWheelAngle(0)
, m_u8Night(VIDEOPLAYER_DAY)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::dispvidctrl_tclVideoPlayer() entered.", OSAL_ClockGetElapsedTime()));

   _poMyStaticRef           = this;
   _pVideoPlayer            = NULL;
   _poAnimationPipeline     = NULL;
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
   _poDualAnimationPipeline = NULL;
#endif   
   _poRvcPipeline           = NULL;

   _poSyncHandler           = NULL;

   m_Config_u8CameraConnectionType = 0;
   _poVideoManager          = NULL;
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclVideoPlayer                                   */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclVideoPlayer::~dispvidctrl_tclVideoPlayer(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] ~dispvidctrl_tclVideoPlayer() entered.", OSAL_ClockGetElapsedTime()));

   _poSyncHandler           = NULL;
   _pVideoPlayer            = NULL;
   _poAnimationPipeline     = NULL;
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
   _poDualAnimationPipeline = NULL;
#endif
   _poRvcPipeline           = NULL;
   _poVideoManager          = NULL;
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vGetReferences(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vGetReferences() entered.", OSAL_ClockGetElapsedTime()));
}


/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vStartCommunication(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vStartCommunication() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vGetReferencesEarly() entered.", OSAL_ClockGetElapsedTime()));

   _poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_poMyStaticRef->_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poSyncHandler);

   _poVideoManager = dynamic_cast<Idispvidctrl_tclClientVideomanager*>(_poMyStaticRef->_cpoMain->getHandler("Idispvidctrl_tclClientVideomanager"));
   if(_poVideoManager == NULL) {
      ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vGetReferencesEarly() ERROR - _poVideomanager is NULL", OSAL_ClockGetElapsedTime()));
   }
}


/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));

   vStartVideoPlayer();
}


/******************************************************************************/
/* FUNCTION     vHandleMessage(TMsg* pMsg)                                    */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vHandleMessage() entered %u -> data: %d.", OSAL_ClockGetElapsedTime(), ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

   switch (pMsg->eCmd)
   {
      case dispvidctrl_tclBaseIf::eVideoStatus:
        {
           DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
           _poRvcPipeline->vHandleLVDSSignalLoss();
        }
         break;
      default:
         break;
   }   
}

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclVideoPlayer::vHandleTraceMessage(): trace command %d", u32MsgCode ));
   
   switch (u32MsgCode)
   {
    case DISPVIDCTRL_DISPVIDCTRL_SET_DEFAULT_EARLY_CONFIG:
        {
            dispvidctrl_tclAppMain::theServer()->vSetDefaultEarlyConfig();
        }
        break;
    default:
        break;
   }
}


/******************************************************************************/
/* FUNCTION     vTraceInfo()                                                  */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vTraceInfo()
{
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
   _poRvcPipeline->vTraceDebugInformation();
   DISPVIDCTRL_NULL_POINTER_CHECK(_poAnimationPipeline);
   _poAnimationPipeline->vTraceDebugInformation();
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
   DISPVIDCTRL_NULL_POINTER_CHECK(_poDualAnimationPipeline);
   _poDualAnimationPipeline->vTraceDebugInformation();   
#endif
}

tVoid dispvidctrl_tclVideoPlayer::vStartVideoPlayer() {
   OSAL_trThreadAttribute rAttr;
   tC8                    szThreadName[] = "dispvidctrlvidplayer";

   rAttr.szName       = szThreadName;

   rAttr.s32StackSize = VIDEOPLAYER_STACKSIZE;
   rAttr.u32Priority  = VIDEOPLAYER_PRIORITY;

   rAttr.pfEntry      = (OSAL_tpfThreadEntry)vVideoPlayerThread;
   rAttr.pvArg        = ( tPVoid ) this;

   OSAL_tThreadID hThreadId = OSAL_ThreadSpawn(&rAttr);

   if ( hThreadId == OSAL_ERROR ){
       ETG_TRACE_ERR( ( "[%d ms] dispvidctrl_tclVideoPlayer::vStartVideoPlayer(): Failed to spawn thread!", OSAL_ClockGetElapsedTime() ) );
   }
}


/******************************************************************************/
/* FUNCTION     vGetConfiguration                                             */
/******************************************************************************/
/**
*  \brief       Function to get all configuration values needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclVideoPlayer::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   m_Config_u8CameraConnectionType = pStConfigurationValues->u8CameraConnectionType;
   ETG_TRACE_FATAL(("dispvidctrl_tclVideoPlayer::vGetConfiguration() CameraConnectionType %d", m_Config_u8CameraConnectionType));
}


tVoid dispvidctrl_tclVideoPlayer::vVideoPlayerInit() {

   int myargc = 2;
   const char* argument[2]= {(const char*)"--gst-disable-registry-update", (const char*)"--gst-debug-disable"};
   char** myargv =(char**)argument;

   tU32 u32Start = OSAL_ClockGetElapsedTime();
   gst_init(&myargc, &myargv);

   dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: GST init done", OSAL_ClockGetElapsedTime() - u32Start);

   mainloop = g_main_loop_new (NULL, false);

   DISPVIDCTRL_NULL_POINTER_CHECK(_cpoMain);
   _cpoMain->vGetEarlyConfig(_tEarlyConfig);

   _poAnimationPipeline = new dispvidctrl_tclGstAnimation(_tEarlyConfig, mainloop);
   DISPVIDCTRL_NULL_POINTER_CHECK(_poAnimationPipeline);

#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
   _poDualAnimationPipeline = new dispvidctrl_tclGstDualAnimation(_tEarlyConfig, mainloop);
   DISPVIDCTRL_NULL_POINTER_CHECK(_poDualAnimationPipeline);
#endif
   
   _poRvcPipeline       = new dispvidctrl_tclGstRvc(_tEarlyConfig, _poVideoManager);
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);

   _poRvcPipeline->bInit(mainloop);
   vSetNight(m_u8Night); // by default "VIDEOPLAYER_DAY" if it was not set to "Night" during startup

   DISPVIDCTRL_NULL_POINTER_CHECK(_poSyncHandler);
   _poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerLayerMgrRdy, TRUE);
   _poSyncHandler->vNewTrigger(I_dispvidctrl_tclSyncHandler::eSyncTriggerVideoPlayerRdy, TRUE);

   // update steering angle information in graphics control in case the angle was set already
   vSetSteeringWheelAngle(m_s32SteeringWheelAngle);

   g_main_loop_run(mainloop);
}

tVoid dispvidctrl_tclVideoPlayer::vVideoPlayerThread(tVoid *pvArg) {
    dispvidctrl_tclVideoPlayer* poVidPlayer = (dispvidctrl_tclVideoPlayer*)pvArg;
    DISPVIDCTRL_NULL_POINTER_CHECK(poVidPlayer);

    poVidPlayer->vVideoPlayerInit();
    OSAL_vThreadExit();
    return;
}

tVoid dispvidctrl_tclVideoPlayer::vStartAnimation(tBool bActivationState, tBool bOnlyLastFrame) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vStartAnimation() bActivationState [%d] bOnlyLastFrame [%d]", OSAL_ClockGetElapsedTime(), bActivationState, bOnlyLastFrame));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poAnimationPipeline);
    if (bActivationState) {
		dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Start animation.");
        _poAnimationPipeline->vStart(bOnlyLastFrame);
    } else {
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Stop animation.");
        _poAnimationPipeline->vStop();
    }
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
	DISPVIDCTRL_NULL_POINTER_CHECK(_poDualAnimationPipeline);
    if (bActivationState) {
		dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY-DUAL]: Start animation.");
        _poDualAnimationPipeline->vStart(bOnlyLastFrame);
    } else {
		dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY-DUAL]: Stop animation.");
		_poDualAnimationPipeline->vStop();
    }
#endif	
}

tVoid dispvidctrl_tclVideoPlayer::vPrepareAnimation(tVoid) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vPrepareAnimation() entered.", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poAnimationPipeline);
	_poAnimationPipeline->bInit(mainloop);
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
    DISPVIDCTRL_NULL_POINTER_CHECK(_poDualAnimationPipeline);
    _poDualAnimationPipeline->bInit(mainloop);	
#endif
}

tVoid dispvidctrl_tclVideoPlayer::vActivateRvc(tBool bActivationState) {
    ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclVideoPlayer::vActivateRvc(): %d!", OSAL_ClockGetElapsedTime(), bActivationState) );

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    DISPVIDCTRL_NULL_POINTER_CHECK(_cpoMain);
    if (bActivationState) {
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Start RVC.");
        _poRvcPipeline->vStart();
    } else {
        _poRvcPipeline->vStop();
        tChar strIfName[] = "dispvidctrl_tclControl_Video";
        _cpoMain->theServer()->vPostMsgRvcCameraState(strIfName);
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Stop RVC.");
    }
}

tVoid dispvidctrl_tclVideoPlayer::vShowRvc() {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vShowRvc() - calling _poRvcPipeline->vShowRvc()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vShowRvc();
};

tVoid dispvidctrl_tclVideoPlayer::vShowBlackScreen(tU8 u8BlackScreenType) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vShowBlackScreen() - calling _poRvcPipeline->vShowBlackScreen()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vShowBlackScreen(u8BlackScreenType);
};

tVoid dispvidctrl_tclVideoPlayer::vPreInitGraphics() {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vPreInitGraphics() - calling _poRvcPipeline->vPreInitGraphics()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vPreInitGraphics();
};

tVoid dispvidctrl_tclVideoPlayer::vFirstFrame() {
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyStaticRef);
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyStaticRef->_cpoMain);
    {
        tChar strIfName[] = "I_dispvidctrl_tclSyncHandler";
        _poMyStaticRef->_cpoMain->theServer()->vPostMsgSyncFirstFrame(strIfName);
    }
    {
        tChar strIfName[] = "dispvidctrl_tclControl_Video";
        _poMyStaticRef->_cpoMain->theServer()->vPostMsgRvcCameraState(strIfName);
    }
}

tVoid dispvidctrl_tclVideoPlayer::vNewVideoStatus() {
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyStaticRef);
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyStaticRef->_cpoMain);
    tChar strIfName[] = "dispvidctrl_tclControl_Video";
    _poMyStaticRef->_cpoMain->theServer()->vPostMsgRvcCameraState(strIfName);
}

tVoid dispvidctrl_tclVideoPlayer::vSetWarningTextLanguage(tU8 u8Language) {
    if(u8Language > VIDEOPLAYER_WARNINGTEXTLANGUAGE_MAX) {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetWarningTextLanguage [%d] ERROR - OUT OF RANGE", OSAL_ClockGetElapsedTime(), u8Language));
        return;
    } else {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetWarningTextLanguage [%d]", OSAL_ClockGetElapsedTime(), u8Language));
    }

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetWarningTextLanguage(u8Language);
};

tVoid dispvidctrl_tclVideoPlayer::vSetGuideLineVisibility(tU32 u32Visibility) {
    if(u32Visibility > VIDEOPLAYER_GUIDELINEVISIBILITY_MAX) {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetGuideLineVisibility [%d] ERROR - OUT OF RANGE", OSAL_ClockGetElapsedTime(), u32Visibility));
        return;
    } else {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetGuideLineVisibility [%d]", OSAL_ClockGetElapsedTime(), u32Visibility));
    }

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetGuideLineVisibility(u32Visibility);
};

tVoid dispvidctrl_tclVideoPlayer::vSetWarningTextVisibility(tU32 u32Visibility) {
    if(u32Visibility > VIDEOPLAYER_WARNINGTEXTVISIBILITY_MAX) {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetWarningTextVisibility [%d] ERROR - OUT OF RANGE", OSAL_ClockGetElapsedTime(), u32Visibility));
        return;
    } else {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetWarningTextVisibility [%d]", OSAL_ClockGetElapsedTime(), u32Visibility));
    }

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetWarningTextVisibility(u32Visibility);
};

tVoid dispvidctrl_tclVideoPlayer::vSetSteeringWheelAngle(tS32 s32SteeringWheelAngle) {
// the following is not needed because the guideline drawing algorithm does it on a per-vehicle base anyway:
//    if((s32SteeringWheelAngle < VIDEOPLAYER_STEERINGWHEELANGLE_MIN) || (s32SteeringWheelAngle > VIDEOPLAYER_STEERINGWHEELANGLE_MAX)) {
//        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetSteeringWheelAngle [%d] ERROR - OUT OF RANGE", OSAL_ClockGetElapsedTime(), s32SteeringWheelAngle));
//        return;
//    } else {
//        ETG_TRACE_USR4(("[%d ms] dispvidctrl_tclVideoPlayer::vSetSteeringWheelAngle [%d]", OSAL_ClockGetElapsedTime(), s32SteeringWheelAngle));
//    }

    m_s32SteeringWheelAngle = s32SteeringWheelAngle;
    if (_poRvcPipeline) {
       _poRvcPipeline->vSetSteeringWheelAngle(s32SteeringWheelAngle);
    }
};

tVoid dispvidctrl_tclVideoPlayer::vSetRearWheelAngle(tS32 s32RearWheelAngle) {
    if((s32RearWheelAngle < VIDEOPLAYER_REARWHEELANGLE_MIN) || (s32RearWheelAngle > VIDEOPLAYER_REARWHEELANGLE_MAX)) {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetRearWheelAngle [%d] ERROR - OUT OF RANGE", OSAL_ClockGetElapsedTime(), s32RearWheelAngle));
        return;
    } else {
        ETG_TRACE_USR4(("[%d ms] dispvidctrl_tclVideoPlayer::vSetRearWheelAngle [%d]", OSAL_ClockGetElapsedTime(), s32RearWheelAngle));
    }

    m_s32RearWheelAngle = s32RearWheelAngle;
    if (_poRvcPipeline) {
       _poRvcPipeline->vSetRearWheelAngle(s32RearWheelAngle);
    }
};

tVoid dispvidctrl_tclVideoPlayer::vSetNight(tU8 u8Night) {
    if(u8Night > VIDEOPLAYER_NIGHT_MAX) {
        ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetNight [%d] - ERROR - OUT OF RANGE", OSAL_ClockGetElapsedTime(), u8Night));
        return;
    }

    m_u8Night = u8Night;
    if (_poRvcPipeline) {
        if(u8Night == VIDEOPLAYER_DAY) {
            ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetNight [%d] - Camera set to Day settings", OSAL_ClockGetElapsedTime(), u8Night));
            _poRvcPipeline->vSetBrightness(_tEarlyConfig.tEarlyNor.u32RvcBrightnessDay, _tEarlyConfig.tEarlyNor.u32RvcBlackLevelDay);
            _poRvcPipeline->vSetColour(_tEarlyConfig.tEarlyNor.u32RvcColourDay);
            _poRvcPipeline->vSetContrast(_tEarlyConfig.tEarlyNor.u32RvcContrastDay);
            _poRvcPipeline->vSetHue(_tEarlyConfig.tEarlyNor.u32RvcHueDay);
        } else {
            ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetNight [%d] - Camera set to Night settings", OSAL_ClockGetElapsedTime(), u8Night));
            _poRvcPipeline->vSetBrightness(_tEarlyConfig.tEarlyNor.u32RvcBrightnessNight, _tEarlyConfig.tEarlyNor.u32RvcBlackLevelNight);
            _poRvcPipeline->vSetColour(_tEarlyConfig.tEarlyNor.u32RvcColourNight);
            _poRvcPipeline->vSetContrast(_tEarlyConfig.tEarlyNor.u32RvcContrastNight);
            _poRvcPipeline->vSetHue(_tEarlyConfig.tEarlyNor.u32RvcHueNight);
        }
    }
};

tVoid dispvidctrl_tclVideoPlayer::vSetHandoverReady() {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetHandoverReady()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetHandoverReady();
};

tVoid dispvidctrl_tclVideoPlayer::vSetCropping(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetCropping() - CropUp [%d] CropDown [%d] CropLeft [%d] CropRight [%d]", OSAL_ClockGetElapsedTime(), u32CropUp, u32CropDown, u32CropLeft, u32CropRight));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    if(_poRvcPipeline->bCroppingParametersInRange(u32CropUp, u32CropDown, u32CropLeft, u32CropRight) == TRUE) {
        _poRvcPipeline->vSetCropping(u32CropUp, u32CropDown, u32CropLeft, u32CropRight);
    }
};

tBool dispvidctrl_tclVideoPlayer::bCroppingParametersInRange(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::bCroppingParametersInRange() - CropUp [%d] CropDown [%d] CropLeft [%d] CropRight [%d]", OSAL_ClockGetElapsedTime(), u32CropUp, u32CropDown, u32CropLeft, u32CropRight));

    if(_poRvcPipeline != 0)
    {
       if(_poRvcPipeline->bCroppingParametersInRange(u32CropUp, u32CropDown, u32CropLeft, u32CropRight) == TRUE) {
           ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::bCroppingParametersInRange() - Parameters in Range", OSAL_ClockGetElapsedTime()));
           return TRUE;
       }
       else 
       {
          ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::bCroppingParametersInRange() - ERROR - parameters out of range", OSAL_ClockGetElapsedTime()));
          return FALSE;
       }
    }
    else
    {
       ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::bCroppingParametersInRange() - ERROR - _poRvcPipeline is NULL", OSAL_ClockGetElapsedTime()));
       return FALSE;
    }
};

tVoid dispvidctrl_tclVideoPlayer::vSetCameraImageMirror(tU32 u32CameraImageMirror) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetCameraImageMirror() - CameraImageMirror [%d]", OSAL_ClockGetElapsedTime(), u32CameraImageMirror));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetCameraImageMirror(u32CameraImageMirror);
};

//TTFis command handling
tVoid dispvidctrl_tclVideoPlayer::vSetLayerOrSurfaceSettings(tU8 u8Setting, tU16 u16LayerOrSurfaceId, tU32 u32ParamA, tU32 u32ParamB, tU32 u32ParamC, tU32 u32ParamD, tBool bCommit)
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    switch (u8Setting)
    {
       case COMMIT_CHANGES:
          _poRvcPipeline->vCommitChanges();
          break;
       case LAYER_VISIBILITY:
          _poRvcPipeline->vSetLayerVisibility(u16LayerOrSurfaceId, (tBool) u32ParamA);
          break;
       case LAYER_OPACITY:
          _poRvcPipeline->vSetLayerOpacity(u16LayerOrSurfaceId, (tBool) u32ParamA);
          break;
       case LAYER_SOURCE_RECTANGLE:
          _poRvcPipeline->vSetLayerSourceRectangle(u16LayerOrSurfaceId, u32ParamA, u32ParamB, u32ParamC, u32ParamD, bCommit);
          break;
       case LAYER_DESTINATION_RECTANGLE:
          _poRvcPipeline->vSetLayerDestinationRectangle(u16LayerOrSurfaceId, u32ParamA, u32ParamB, u32ParamC, u32ParamD, bCommit);
          break;
       case SURFACE_VISIBILITY:
          _poRvcPipeline->vSetSurfaceVisibility(u16LayerOrSurfaceId, (tBool) u32ParamA);
          break;
       case SURFACE_OPACITY:
          _poRvcPipeline->vSetSurfaceOpacity(u16LayerOrSurfaceId, (tBool) u32ParamA);
          break;
       case SURFACE_SOURCE_RECTANGLE:
          _poRvcPipeline->vSetSurfaceSourceRectangle(u16LayerOrSurfaceId, u32ParamA, u32ParamB, u32ParamC, u32ParamD, bCommit);
          break;
       case SURFACE_DESTINATION_RECTANGLE:
          _poRvcPipeline->vSetSurfaceDestinationRectangle(u16LayerOrSurfaceId, u32ParamA, u32ParamB, u32ParamC, u32ParamD, bCommit);
          break;
       default:
          break;
    }
}

tVoid dispvidctrl_tclVideoPlayer::vReConfigGuidelineParams(tU8 u8VideoType, tU8 u8VideoParamIndex)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
   _poRvcPipeline->vReConfigGuidelineParams(u8VideoType, u8VideoParamIndex);
}

tVoid dispvidctrl_tclVideoPlayer::vSetHmiAvailable()
{
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
   _poRvcPipeline->vSetHmiAvailable();
}

tBool dispvidctrl_tclVideoPlayer::bIsVideoSourceFound() const
{
#ifndef GEN3X86
   if(_poRvcPipeline != 0)
   {
      return (_poRvcPipeline->bIsVideoSourceFound());
   }
   else
   {
      ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::bIsVideoSourceFound() ERROR - _poRvcPipeline is NULL", OSAL_ClockGetElapsedTime()));
      return FALSE;
   }
#else
   return TRUE; // no check needed for LSIM
#endif // GEN3X86
}

tBool dispvidctrl_tclVideoPlayer::bFindVideoSource() const
{
   DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poRvcPipeline);
#ifndef GEN3X86
   return (_poRvcPipeline->bFindCameraVideoSource());
#else
   return TRUE; // no check needed for LSIM
#endif // GEN3X86
}

tVoid dispvidctrl_tclVideoPlayer::vGetRvcState(tBool& bVideoActive, tBool& bRvcErrorVal) {
   if(_poRvcPipeline != 0)
   {
      _poRvcPipeline->vGetRvcState(bVideoActive, bRvcErrorVal);
   }
   else
   {
      ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vGetRvcState() ERROR - _poRvcPipeline is NULL", OSAL_ClockGetElapsedTime()));
   }
};

tU8 dispvidctrl_tclVideoPlayer::u8GetCameraConnectionType() {
    return m_Config_u8CameraConnectionType;
}

tVoid dispvidctrl_tclVideoPlayer::vIndVehicleConfigChanged_DynGuideline(tVoid)
{
   if (_poRvcPipeline)
   {
      _poRvcPipeline->vIndVehicleConfigChanged_DynGuideline();
   }
}

vd_rvc_tstVehicleParams* dispvidctrl_tclVideoPlayer::vGetVehicleConfigPtr_DynGuideline(tVoid)
{
   if (_poRvcPipeline)
   {
      return _poRvcPipeline->vGetVehicleConfigPtr_DynGuideline();
   }
   else
   {
      return NULL;
   }
}

tVoid dispvidctrl_tclVideoPlayer::vSetVehicleConfig_DynGuideline(tVoid)
{
   if (_poRvcPipeline)
   {
      _poRvcPipeline->vSetVehicleConfig_DynGuideline();
   }
}

tVoid dispvidctrl_tclVideoPlayer::vSetTemporaryCalibGuidelnStyle(tBool bActive)
{
   if (_poRvcPipeline)
   {
      _poRvcPipeline->vSetTemporaryCalibGuidelnStyle(bActive);
   }
}

tVoid dispvidctrl_tclVideoPlayer::vHandleFirstFrameRendered(tVoid) {
    if (_poRvcPipeline) _poRvcPipeline->vHandleFirstFrameRendered();
}

tVoid dispvidctrl_tclVideoPlayer::vSetLVDSBrightness(tU16 u16Brightness, tU16 u16BlackLevel) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetLVDSBrightness() - calling _poRvcPipeline->vSetLVDSBrightness()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetLVDSBrightness(u16Brightness, u16BlackLevel);
};


tVoid dispvidctrl_tclVideoPlayer::GraphicslayerVisibility(unsigned int visibility)
{
    ETG_TRACE_USR4(("Recieved GraphicslayerVisiblity %d", visibility));
	_poRvcPipeline->setGraphicslayerVisibility(visibility);
}
tVoid dispvidctrl_tclVideoPlayer::vSetLVDSColour(tU16 u16Colour) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetLVDSColour() - calling _poRvcPipeline->vSetLVDSColour()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetLVDSColour(u16Colour);
};

tVoid dispvidctrl_tclVideoPlayer::vSetLVDSContrast(tU16 u16Contrast) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetLVDSContrast() - calling _poRvcPipeline->vSetLVDSContrast()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetLVDSColour(u16Contrast);
};

tVoid dispvidctrl_tclVideoPlayer::vSetLVDSHue(tU16 u16Hue) {
    ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetLVDSHue() - calling _poRvcPipeline->vSetLVDSHue()", OSAL_ClockGetElapsedTime()));

    DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
    _poRvcPipeline->vSetLVDSHue(u16Hue);
};

tVoid dispvidctrl_tclVideoPlayer::vSetAllRvcObjects()
{
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
   _poRvcPipeline->vSetAllRvcObjects();
}

tVoid dispvidctrl_tclVideoPlayer::vStartRVCPlaying()
{
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
   _poRvcPipeline->vStartRVCPlaying();
}

tVoid dispvidctrl_tclVideoPlayer::vSetInitialblackscreen(tU8 u8camConfigType)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclVideoPlayer::vSetInitialblackscreen() ", OSAL_ClockGetElapsedTime()));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poRvcPipeline);
   _poRvcPipeline->vSetInitialblackscreen(u8camConfigType);
}
