/************************************************************************
* FILE:        dispvidctrl_tclGstRvc.h
* PROJECT:
* SW-COMPONENT:videoplayer
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef _dispvidctrl_tclGstRvc_H_
#define _dispvidctrl_tclGstRvc_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclGstPipeline.h"
#include "Idispvidctrl_ClientVideomanager.h"

class dispvidctrl_tclControlGraphic;
class Idispvidctrl_tclClientVideomanager;

class dispvidctrl_tclGstRvc : public dispvidctrl_tclGstPipeline
{
private:
    static tVoid    vFirstFrameRendered(GstElement * element, GstPad *pad, gpointer user_data);

    static gboolean bBusCall(GstBus *bus, GstMessage *msg,gpointer data);

    static tVoid    vBufferErrorCB(GstElement*, GstPad*, gpointer);
    static tVoid    vBufferErrorDoneCB(GstElement*, GstPad*, gpointer);

    static dispvidctrl_tclGstRvc* _pMyStaticRef;

    dispvidctrl_tclControlGraphic*  _poControlGraphic;
    Idispvidctrl_tclClientVideomanager* _povideomanager;

    tU16 _u16LayerNumber;
    tU16 _u16GraphicsLayerNumber;
    tU16 _u16SurfaceNumber;
    tU16 _u16GuidelineSurfaceNumber;
    tU16 _u16ScreenWidth;
    tU16 _u16ScreenHeight;
    tU16 _u16PixFmt;
    tU16 _u16CropUp;
    tU16 _u16CropDown;
    tU16 _u16CropLeft;
    tU16 _u16CropRight;
    tU16 _u16LayerSourceRectangle_X;
    tU16 _u16LayerSourceRectangle_Y;
    tU16 _u16LayerSourceRectangle_Width;
    tU16 _u16LayerSourceRectangle_Height;
    tU16 _u16LayerDestinationRectangle_X;
    tU16 _u16LayerDestinationRectangle_Y;
    tU16 _u16LayerDestinationRectangle_Width;
    tU16 _u16LayerDestinationRectangle_Height;
    tU8  _u8CameraConnectionType;
    tU16 _u16CameraWidth;
    tU16 _u16CameraHeight;
    tU8  _u8CameraImageMirror;
    
    tU8  _u8AnalogInputChannel;
    tU8  _u8DigitalInputChannel;
    tU8  _u8DigitalMediaInInputChannel;
    
    tU32 _u32StartPlayTime;

    const tChar* _strVideoSourceName;
    const tChar* _strVideoOutName;
    const tChar* _strMediaInSourceName;

    tBool _bRvcActive;
    tBool _bRvcVisible;
    tBool _bRvcBlackInComplete;
    tBool _bRvcRendered;
    tBool _bVideoSignalError; // TRUE = Error, False = OK
    tBool _bPipelineActive;
    tBool _bHandoverReady;
    tBool _bCroppingSet;
    tBool _bLayerSourceRectangleSet;
    tBool _bLeftHandDrive;
    
    tBool _bVideoSourceFound;
    tBool _bVideoOutFound;
    tBool _bMediaInSourceFound;

    tVoid vSetBlackScreenOnCameraDisconnection();
#ifndef GEN3X86
    tVoid vSetAce(tBool bEnable);
#endif //GEN3X86

public:
    // constructor
    dispvidctrl_tclGstRvc(tVoid);
    dispvidctrl_tclGstRvc(const TEarlyConfiguration& tEarlyConfig, Idispvidctrl_tclClientVideomanager* poClientVideoManager);

    // destructor
    virtual ~dispvidctrl_tclGstRvc();

private:
    // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
    dispvidctrl_tclGstRvc(const dispvidctrl_tclGstRvc&);
    dispvidctrl_tclGstRvc& operator=(const dispvidctrl_tclGstRvc&);
public:
    
    virtual tBool bInit(GMainLoop *pGstMainLoop);
    virtual tVoid vSetAllRvcObjects();

    virtual tVoid vStart(tU8 u8Type = 0);
    virtual tVoid vStartRVCPlaying();

    virtual tVoid vPause();
    virtual tVoid vStop();

    virtual tVoid vShowRvc();
    virtual tVoid vShowBlackScreen(tU8 u8BlackScreenType);
    virtual tVoid vShowGreenScreen(tU8 u8BlackScreenType);
    virtual tVoid vPreInitGraphics();
	void setGraphicslayerVisibility(unsigned int visibility);

    virtual tVoid vSetWarningTextLanguage(tU8 u8Language);
    virtual tVoid vSetGuideLineVisibility(tU32 u32Visibility);
    virtual tVoid vSetWarningTextVisibility(tU32 u32Visibility);

    virtual tVoid vSetSteeringWheelAngle(tS32 s32SteeringWheelAngle);
    virtual tVoid vSetRearWheelAngle(tS32 s32RearWheelAngle);

    virtual tVoid vSetHandoverReady();

    virtual tVoid vSetCropping(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight);
    virtual tBool bCroppingParametersInRange(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight);
    virtual tVoid vSetCameraImageMirror(tU32 u32CameraImageMirror);
    virtual tVoid vCommitChanges(tVoid);
    virtual tVoid vSetLayerVisibility(tU16 u16LayerId, tBool bVisible);
    virtual tVoid vSetLayerOpacity(tU16 u16LayerId, tBool bOpacity);
    virtual tVoid vSetLayerSourceRectangle(tU16 u16LayerId, tU32 u32X, tU32 u32Y, tU32 u32Width, tU32 u32Height, tBool bCommit = TRUE);
    virtual tVoid vSetLayerDestinationRectangle(tU16 u16LayerId, tU32 u32X, tU32 u32Y, tU32 u32Width, tU32 u32Height, tBool bCommit = TRUE);
    virtual tVoid vSetSurfaceVisibility(tU16 u16SurfaceId, tBool bVisible);
    virtual tVoid vSetSurfaceOpacity(tU16 u16SurfaceId, tBool bOpacity);
    virtual tVoid vSetSurfaceSourceRectangle(tU16 u16SurfaceId, tU32 u32X, tU32 u32Y, tU32 u32Width, tU32 u32Height, tBool bCommit = TRUE);
    virtual tVoid vSetSurfaceDestinationRectangle(tU16 u16SurfaceId, tU32 u32X, tU32 u32Y, tU32 u32Width, tU32 u32Height, tBool bCommit = TRUE);
    virtual tVoid vReConfigGuidelineParams(tU8 u8VideoType, tU8 u8VideoParamIndex);
    
    virtual tVoid vSetHmiAvailable();
    
    virtual inline tBool bIsVideoSourceFound() const { return _bVideoSourceFound; }

    virtual tVoid vSetCscObjects();
    virtual tVoid vSetMirroring();
	
    virtual tVoid vCompleteCVBSPipelineCsc();
    virtual tVoid vCompleteCVBSPipelineNoCsc();
    virtual tVoid vCompleteLVDSPipeline();
#ifdef ENABLE_60_TO_30_REDUCTION
    virtual tVoid vSetVideoRateObjects();
#endif //ENABLE_60_TO_30_REDUCTION
	
#ifndef GEN3X86
    // It is necessary to check the device naming as it cannot be guaranteed by platform
    // To find the video source name (video0, video1 or video2)
    tBool bFindCameraVideoSource(tVoid);
#endif //GEN3X86

    virtual tVoid vGetRvcState(tBool& bVideoActive, tBool& bRvcErrorVal) {bVideoActive = _bRvcActive; bRvcErrorVal = _bVideoSignalError;};

    virtual tVoid vHandleFirstFrameRendered(tVoid);

    virtual tVoid vTraceDebugInformation(tVoid);

    virtual tVoid vIndVehicleConfigChanged_DynGuideline(tVoid);
    virtual vd_rvc_tstVehicleParams* vGetVehicleConfigPtr_DynGuideline(tVoid);
    virtual tVoid vSetVehicleConfig_DynGuideline(tVoid);
    virtual tVoid vSetTemporaryCalibGuidelnStyle(tBool bActive);
    virtual tVoid vSetInitialblackscreen(tU8 u8BlackScreenType);

    virtual tVoid vHandleLVDSSignalLoss(tVoid);
};

#endif /* _dispvidctrl_tclGstRvc_H_ */
