/******************************************************************************/
/**
* \file    dispvidctrl_tclGstPipeline.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : 
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclGstPipeline.h"
#include "dispvidctrl_datapool.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VIDEOPLAYER
#include "trcGenProj/Header/dispvidctrl_tclGstPipeline.cpp.trc.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclGstPipeline()                                     */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application
*  \return      none
*/
/******************************************************************************/

dispvidctrl_tclGstPipeline::dispvidctrl_tclGstPipeline() {
    ETG_TRACE_FATAL(("dispvidctrl_tclGstPipeline::dispvidctrl_tclGstPipeline() entered."));

    _pGstMainLoop  = NULL;

    _pGstPipeline  = NULL;
    _pGstQueue     = NULL;
    _pGstQueue_Csc = NULL;
    _pGstSource    = NULL;
    _pGstCsc       = NULL;
    _pGstSink      = NULL;
    _pGstBus       = NULL;
    _u8CameraConnection = 0;
}

/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclGstPipeline                                      */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstPipeline::~dispvidctrl_tclGstPipeline(tVoid)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclGstPipeline::~dispvidctrl_tclGstPipeline() entered."));

    _pGstMainLoop  = NULL;

    _pGstPipeline  = NULL;
    _pGstQueue     = NULL;
    _pGstQueue_Csc = NULL;
    _pGstSource    = NULL;
    _pGstCsc       = NULL;
    _pGstSink      = NULL;
    _pGstBus       = NULL;
}

//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetBrightness(tU16 u16Brightness, tU16 u16BlackLevel)

//!            Set New Brightness (including Black Level offset)

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetBrightness(tU16 u16Brightness, tU16 u16BlackLevel)
{
   if (_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      vSetLVDSBrightness(u16Brightness, u16BlackLevel);
   }
   else {
      tU8 u8ApiValue_Brightness;
      unsigned int range_adjusted;
      tU16 u16CombinedBrightness = u16Brightness + u16BlackLevel;

      if(u16CombinedBrightness > 100) {
         ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetBrightness() Combined brightness (0-90 [%d]) and black level (0-10 [%d]) limited to 100", OSAL_ClockGetElapsedTime(), (int)u16Brightness, (int)u16BlackLevel));
         u16CombinedBrightness = 100;
      }

      // to get 0x00 for two's complement register value after scaling
      if (u16CombinedBrightness == SCALE_INPUT_RANGE_MID) {
         range_adjusted = SCALE_OUTPUT_RANGE_MID;
      } else {
         range_adjusted = (u16Brightness * SCALE_OUTPUT_RANGE_MAX) / SCALE_INPUT_RANGE_MAX;
      }

      //if (range_adjusted >= 128) {
      //   // API value 0..127 for increase (0x00..0x7F)
      //   u8ApiValue_Brightness = range_adjusted - (tU8) 128;
      //} else {
      //   // API value from -1 to -128 for decrease (0xFF..0x80)
      //   u8ApiValue_Brightness = range_adjusted + (tU8) 128;
      //}
      u8ApiValue_Brightness = range_adjusted;

      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetBrightness() brightness(0-90 [%d]), black level (0-10 [%d]) range adjusted (0-255) [%d], 2's complement [%x]", OSAL_ClockGetElapsedTime(), (int)u16Brightness, (int)u16BlackLevel, range_adjusted, u8ApiValue_Brightness));
      if(_pGstSource != NULL) {
         g_object_set (G_OBJECT (_pGstSource), "brightness", u8ApiValue_Brightness, NULL); //lint !e826 PQM_authorized_multi_415
      }
   }
}

//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetColour(unsigned int colour)

//!            Set New Colour

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetColour(tU16 u16Colour)
{
   if (_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      vSetLVDSColour(u16Colour);
   }
   else {
      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetColour() colour [%d, scaled %d] _pGstSource [%x]", OSAL_ClockGetElapsedTime(), (int)u16Colour, ((u16Colour * SCALE_OUTPUT_RANGE_MAX) / SCALE_INPUT_RANGE_MAX), _pGstSource));

      if(_pGstSource != 0) {
         g_object_set (G_OBJECT (_pGstSource), "saturation", ((u16Colour * SCALE_OUTPUT_RANGE_MAX) / SCALE_INPUT_RANGE_MAX), NULL); //lint !e826 PQM_authorized_multi_415
      }
   }
}


//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetContrast(unsigned int contrast)

//!            Set New Contrast

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetContrast(tU16 u16Contrast)
{
   if (_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      vSetLVDSContrast(u16Contrast);
   }
   else {
      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetContrast() contrast [%d, scaled %d] _pGstSource [%x]", OSAL_ClockGetElapsedTime(), (int)u16Contrast, ((u16Contrast * SCALE_OUTPUT_RANGE_MAX) / SCALE_INPUT_RANGE_MAX), _pGstSource));

      if(_pGstSource != 0) {
         g_object_set (G_OBJECT (_pGstSource), "contrast", ((u16Contrast * SCALE_OUTPUT_RANGE_MAX) / SCALE_INPUT_RANGE_MAX), NULL); //lint !e826 PQM_authorized_multi_415
      }
   }
}


//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetHue(unsigned int hue)

//!            Set New Hue

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetHue(tU16 u16Hue)
{
   if (_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      vSetLVDSContrast(u16Hue);
   }
   else {
      tS32 s32ScaledValue;

      s32ScaledValue = (tS32) u16Hue;
      s32ScaledValue = s32ScaledValue - 127;

      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vgstreamerSetNewHue() hue (0..255) [%d], range adjusted (-127..128) [%d]", OSAL_ClockGetElapsedTime(), (int)u16Hue, s32ScaledValue));
      if(_pGstSource != 0) {
         g_object_set (G_OBJECT (_pGstSource), "hue", s32ScaledValue, NULL); //lint !e826 PQM_authorized_multi_415
      }
   }
}

//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetLVDSBrightness(tU16 u16Brightness, tU16 u16BlackLevel)

//!            Set New Brightness (including Black Level offset)

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetLVDSBrightness(tU16 u16Brightness, tU16 u16BlackLevel)
{
   if(_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      tU8 u8ApiValue_Brightness;
      unsigned int range_adjusted;
      tU16 u16CombinedBrightness = u16Brightness + u16BlackLevel;

      if(u16CombinedBrightness > 100) {
         ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSBrightness() Combined brightness (0-90 [%d]) and black level (0-10 [%d]) limited to 100", OSAL_ClockGetElapsedTime(), (int)u16Brightness, (int)u16BlackLevel));
         u16CombinedBrightness = 100;
      }

      tS32 s32ScaledValue;

      s32ScaledValue = (tS32) u16CombinedBrightness;
      s32ScaledValue = s32ScaledValue * LVDS_SCALE_OUTPUT_RANGE_MAX / SCALE_INPUT_RANGE_MAX;

      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSBrightness() contrast (0..100) [%d], range adjusted (0..200) [%d]", OSAL_ClockGetElapsedTime(), (int)u16CombinedBrightness, s32ScaledValue));
      if(_pGstCsc != 0) {
         g_object_set (G_OBJECT (_pGstCsc), "brightness", s32ScaledValue, NULL); //lint !e826 PQM_authorized_multi_415
      }
      else {
         ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSBrightness() _pGstCsc is NULL", OSAL_ClockGetElapsedTime()));
      }
   }
   else {
      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSBrightness() Called when not LVDS", OSAL_ClockGetElapsedTime()));
   }
}

//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetLVDSColour(unsigned int colour)

//!            Set New Colour

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetLVDSColour(tU16 u16Colour)
{
   if(_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      tS32 s32ScaledValue;

      s32ScaledValue = (tS32) u16Colour;
      s32ScaledValue = s32ScaledValue * LVDS_SCALE_OUTPUT_RANGE_MAX / SCALE_INPUT_RANGE_MAX;

      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSColour() contrast (0..100) [%d], range adjusted (0..200) [%d]", OSAL_ClockGetElapsedTime(), (int)u16Colour, s32ScaledValue));
      if(_pGstCsc != 0) {
         g_object_set (G_OBJECT (_pGstCsc), "saturation", s32ScaledValue, NULL); //lint !e826 PQM_authorized_multi_415
      }
      else {
         ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSColour() _pGstCsc is NULL", OSAL_ClockGetElapsedTime()));
      }
   }
   else {
      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSColour() Called when not LVDS", OSAL_ClockGetElapsedTime()));
   }
}


//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetLVDSContrast(unsigned int contrast)

//!            Set New Contrast

//!

//PARAMETER:   None

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetLVDSContrast(tU16 u16Contrast)
{
   if(_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      tS32 s32ScaledValue;

      s32ScaledValue = (tS32) u16Contrast;
      s32ScaledValue = s32ScaledValue * LVDS_SCALE_OUTPUT_RANGE_MAX / SCALE_INPUT_RANGE_MAX;

      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSContrast() contrast (0..100) [%d], range adjusted (0..200) [%d]", OSAL_ClockGetElapsedTime(), (int)u16Contrast, s32ScaledValue));
      if(_pGstCsc != 0) {
         g_object_set (G_OBJECT (_pGstCsc), "contrast", s32ScaledValue, NULL); //lint !e826 PQM_authorized_multi_415
      }
      else {
         ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSContrast() _pGstCsc is NULL", OSAL_ClockGetElapsedTime()));
      }
   }
   else {
      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSContrast() Called when not LVDS", OSAL_ClockGetElapsedTime()));
   }
}


//******************************************************************************

//FUNCTION:    tVoid dispvidctrl_tclGstPipeline::vSetLVDSHue(unsigned int hue)

//!            Set New Hue (only for LVDS with v4l_csc)

//!

//PARAMETER:   int hue - 0-100

//RETURNVALUE: None

//******************************************************************************
tVoid dispvidctrl_tclGstPipeline::vSetLVDSHue(tU16 u16Hue)
{
   if(_u8CameraConnection == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
      tS32 s32ScaledValue;

      s32ScaledValue = (tS32) u16Hue;
      s32ScaledValue = (s32ScaledValue * LVDS_HUE_SCALE_OUTPUT_RANGE_MAX / SCALE_INPUT_RANGE_MAX) - LVDS_SCALE_OUTPUT_OFFSET;

      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSHue() hue (0..100) [%d], range adjusted (-180..180) [%d]", OSAL_ClockGetElapsedTime(), (int)u16Hue, s32ScaledValue));
      if(_pGstCsc != 0) {
         g_object_set (G_OBJECT (_pGstCsc), "hue", s32ScaledValue, NULL); //lint !e826 PQM_authorized_multi_415
      }
      else {
         ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSHue() _pGstCsc is NULL", OSAL_ClockGetElapsedTime()));
      }
   }
   else {
      ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclGstPipeline::vSetLVDSHue() Called when not LVDS", OSAL_ClockGetElapsedTime()));
   }
}
