#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
/******************************************************************************/
/**
* \file    dispvidctrl_tclGstDualAnimation.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2017 Robert Bosch GmbH, Hildesheim
* \remark  Author    : 
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclGstDualAnimation.h"
#include "dispvidctrl_datapool.h"

#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>

//#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_hmi_01_if.h"
#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VIDEOPLAYER
#include "trcGenProj/Header/dispvidctrl_tclGstDualAnimation.cpp.trc.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/
//Note - this must be updated if more opening animation types are handled
#define OPENING_ANIMATION_TYPE_COUNT                      4

#define OPENING_ANIMATION_TYPE_RENAULT_END_FRAME          4
#define OPENING_ANIMATION_TYPE_NISSAN_END_FRAME           5
#define OPENING_ANIMATION_TYPE_INFINITI_END_FRAME         6
#define OPENING_ANIMATION_TYPE_EV_NISSAN_END_FRAME        7

dispvidctrl_tclGstDualAnimation* dispvidctrl_tclGstDualAnimation::_pMyStaticRef = NULL;

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclGstDualAnimation()                                 */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstDualAnimation() : dispvidctrl_tclGstPipeline() {
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstDualAnimation() entered.", OSAL_ClockGetElapsedTime()));
    _pMyStaticRef     = this;

    _u16LayerNumber   = 0;
    _u16SurfaceNumber = 0;
    _u16ScreenWidth   = 0;
    _u16ScreenHeight  = 0;
    _u32StartPlayTime = 0;
    _u8OpeningAnimation = 0;
    _u8DisplayAspectRatio = 0;
    _u16DestinationRegion = 0;
}

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclGstDualAnimation()                                 */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstDualAnimation(TEarlyConfiguration tEarlyConfig, GMainLoop *pGstMainLoop) : dispvidctrl_tclGstPipeline() {
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstDualAnimation() entered.", OSAL_ClockGetElapsedTime()));
    _pMyStaticRef     = this;

    _u16LayerNumber   = tEarlyConfig.u32AnimationLayer2;
    _u16SurfaceNumber = tEarlyConfig.u32AnimationSurface2;
    _u16ScreenWidth   = tEarlyConfig.tEarlyNorForce.u16Display2Width;
    // In case reading of Nor has failed - default width
    if(_u16ScreenWidth == 0) {
        _u16ScreenWidth = DEFAULT_DISPLAY2WIDTH;
    }
    _u16ScreenHeight  = tEarlyConfig.tEarlyNorForce.u16Display2Height;
    _u8OpeningAnimation = tEarlyConfig.tEarlyNorForce.u8EarlyOpeningAnimation;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    // In case reading of Nor has failed - default to Nissan Animation
    if(_u8OpeningAnimation == 0) {
        _u8OpeningAnimation = DISPVIDCTRL_AllianceOpeningAnimation_Type_Nissan;
    }
#endif //VARIANT_S_FTR_ENABLE_AIVI_SCOPE2

    _u8DisplayAspectRatio = tEarlyConfig.tEarlyNorForce.u8EarlyDisplayAspectRatio;
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstDualAnimation() Opening Animation [%d] Display Aspect Ratio [%d]", OSAL_ClockGetElapsedTime(), _u8OpeningAnimation, _u8DisplayAspectRatio));
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstDualAnimation() Layer [%d] Surface [%d] Screen Width [%d] Screen Height [%d]", OSAL_ClockGetElapsedTime(), _u16LayerNumber, _u16SurfaceNumber, _u16ScreenWidth, _u16ScreenHeight));
    _u16DestinationRegion = tEarlyConfig.tEarlyNorForce.u16EarlyDestinationRegion;
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::dispvidctrl_tclGstAnimation() DestinationRegion [%d]", OSAL_ClockGetElapsedTime(), _u16DestinationRegion));

    _pGstMainLoop = pGstMainLoop;

    _u32StartPlayTime = 0;
}

/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclGstDualAnimation                                      */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstDualAnimation::~dispvidctrl_tclGstDualAnimation(tVoid) {
   ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::~dispvidctrl_tclGstDualAnimation() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vStart(tU8 u8MainOrEnd)                                       */
/******************************************************************************/
/**
*  \brief       Start the Animation
*
*  \param       u8MainOrEnd = 0 - full animation, = 1 - last frame only
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstDualAnimation::vStart(tU8 u8MainOrEnd) {
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart(%d)", OSAL_ClockGetElapsedTime(), u8MainOrEnd));

    _u32StartPlayTime = OSAL_ClockGetElapsedTime();

    tU8 u8Type;
    if(u8MainOrEnd == 0) {
        u8Type = _u8OpeningAnimation;
    }
    else {
        u8Type = _u8OpeningAnimation + OPENING_ANIMATION_TYPE_COUNT;
    }

    if(_pGstSource == 0) { 
       ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - Animation not yet initialised - calling bInit()", OSAL_ClockGetElapsedTime()));
       bInit(_pGstMainLoop);
              ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - _pGstSource is zero - end of bInit()", OSAL_ClockGetElapsedTime()));
    }

    switch (u8Type) {
    case DISPVIDCTRL_AllianceOpeningAnimation_Type_Infiniti:
        {
            //Infiniti
		    switch (_u16DestinationRegion)
	        {
	            case DISPVIDCTRL_REGION_JPN:
                    {
                        g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/OP_Dual_3_Upper_Japan.mkv", NULL); //lint !e826 PQM_authorized_multi_415
                        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - Japan Region - Selected Video %s", OSAL_ClockGetElapsedTime(), "file:///opt/bosch/early/videos/OP_Dual_3_Upper_Japan.mkv"));
                        break;
                    }
	            case DISPVIDCTRL_REGION_CAN:
                    {
                        g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/OP_Dual_1_Upper_USCAN.mkv", NULL); //lint !e826 PQM_authorized_multi_415
                        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - Canada Region - Selected Video %s", OSAL_ClockGetElapsedTime(), "file:///opt/bosch/early/videos/OP_Dual_1_Upper_USCAN.mkv"));
                        break;
                    }
	            case DISPVIDCTRL_REGION_US:
                    {
                        g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/OP_Dual_1_Upper_USCAN.mkv", NULL); //lint !e826 PQM_authorized_multi_415
                        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - US Region - Selected Video %s", OSAL_ClockGetElapsedTime(), "file:///opt/bosch/early/videos/OP_Dual_1_Upper_USCAN.mkv"));
                        break;
                    }
                default:
                   {
                        g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/OP_Dual_2_Upper_other.mkv", NULL); //lint !e826 PQM_authorized_multi_415
                        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - Selected Video (Default) %s", OSAL_ClockGetElapsedTime(), "file:///opt/bosch/early/videos/OP_Dual_2_Upper_other.mkv"));
                        break;
                   }	                
			}
            break;
        }

    case OPENING_ANIMATION_TYPE_INFINITI_END_FRAME:
        {
            //Infiniti End Frame - No end frame for INFINITI
            //g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/Infiniti_end_frame_vp8.mkv", NULL); //lint !e826 PQM_authorized_multi_415
            ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - Selected Video %s", OSAL_ClockGetElapsedTime(), "file:///opt/bosch/early/videos/Infiniti_end_frame_vp8.mkv"));
            break;
        }
    default:
        {
            ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - Error - Animation Type [%d] Not Recognized", OSAL_ClockGetElapsedTime(), u8Type));
            break;
        }
    }

    //Set the layer visibility
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - LayerManagerControl Layer %d visibility -> 1", OSAL_ClockGetElapsedTime(), _u16LayerNumber));

    bool lRc = (ILM_SUCCESS == ilm_layerSetVisibility((unsigned int)_u16LayerNumber,1));

    // Commit changes to ILM
    lRc = lRc && (ILM_SUCCESS == ilm_commitChanges());
    if(lRc != TRUE) {
        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStart() - LayerManagerControl Commit Failed [%d]", OSAL_ClockGetElapsedTime(), lRc));
    }

    gst_element_set_state(_pGstSource, GST_STATE_PLAYING);
}

/******************************************************************************/
/* FUNCTION     vPause()                                                      */
/******************************************************************************/
/**
*  \brief       Pause the Animation
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstDualAnimation::vPause() {
    DISPVIDCTRL_NULL_POINTER_CHECK(_pGstSource);
    gst_element_set_state(_pGstSource, GST_STATE_PAUSED);
}

/******************************************************************************/
/* FUNCTION     vStop( )                                                      */
/******************************************************************************/
/**
*  \brief       Stop the Animation
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstDualAnimation::vStop() {
    //Set the layer visibility
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStop() - LayerManagerControl Layer %d visibility -> 0", OSAL_ClockGetElapsedTime(), _u16LayerNumber));
    bool lRc = (ILM_SUCCESS == ilm_layerSetVisibility((unsigned int)_u16LayerNumber,0));

    // Commit changes to ILM
    lRc = lRc && (ILM_SUCCESS == ilm_commitChanges());
    if(lRc != TRUE) {
        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::vStop() - LayerManagerControl Commit Failed [%d]", OSAL_ClockGetElapsedTime(), lRc));
    }

    DISPVIDCTRL_NULL_POINTER_CHECK(_pGstSource);
    gst_element_set_state(_pGstSource, GST_STATE_NULL);
}

/******************************************************************************/
/* FUNCTION     bInit(GMainLoop *pGstMainLoop)                                */
/******************************************************************************/
/**
*  \brief       Initialise the Animation GStreamer Pipeline
*
*  \param       GMainLoop *pGstMainLoop - Pointer to GStreamer
*  \return      none
*/
/******************************************************************************/
tBool dispvidctrl_tclGstDualAnimation::bInit(GMainLoop *pGstMainLoop) {

    if (_pGstSource != NULL && _pGstSink != NULL) {
        // we are already initialized
        return TRUE;
    }

    tU32 u32StartTime = OSAL_ClockGetElapsedTime();

    _pGstMainLoop = pGstMainLoop;
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstMainLoop);

    _pGstSource   = gst_element_factory_make("playbin2","video-player");
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstSource);

    // Select video only and use only native video formats
    g_object_set (G_OBJECT (_pGstSource), "flags", 0x41 , NULL); //lint !e826 PQM_authorized_multi_415

    _pGstSink     = gst_element_factory_make("gst_apx_sink", "animationVideoSink");
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstSink);

    g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/Nissan_17_9_vp8.mkv", NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "layer-id", _u16LayerNumber, NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "surface-id", _u16SurfaceNumber, NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "display-width", _u16ScreenWidth, NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "display-height", _u16ScreenHeight , NULL); //lint !e826 PQM_authorized_multi_415

    g_signal_connect(_pGstSink,"first-videoframe-rendered",G_CALLBACK (dispvidctrl_tclGstDualAnimation::vFirstFrameRendered), NULL);

    _pGstBus = gst_pipeline_get_bus (GST_PIPELINE (_pGstSource)); //lint !e826 PQM_authorized_multi_415
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstBus);

    gst_bus_add_watch (_pGstBus, dispvidctrl_tclGstDualAnimation::bBusCall, _pGstMainLoop);

    //Set the layer visibility
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::bInit() - LayerManagerControl Layer %d visibility -> 1", OSAL_ClockGetElapsedTime(), _u16LayerNumber));
    bool lRc = (ILM_SUCCESS == ilm_layerSetVisibility((unsigned int)_u16LayerNumber,1));

    // Commit changes to ILM
    lRc = lRc && (ILM_SUCCESS == ilm_commitChanges());
    if(lRc != TRUE) {
        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstDualAnimation::bInit() - LayerManagerControl Commit Failed [%d]", OSAL_ClockGetElapsedTime(), lRc));
    }

    g_object_set(G_OBJECT(_pGstSource),"video-sink",_pGstSink,NULL); //lint !e826 PQM_authorized_multi_415

    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Animation pipeline init complete", OSAL_ClockGetElapsedTime() - u32StartTime);
    return TRUE;
}

/********************************************************************************************/
/* FUNCTION     vFirstFrameRendered(GstElement * element, GstPad *pad, gpointer user_data)  */
/********************************************************************************************/
/**
*  \brief       GStreamer callback when first frame is visible
*
*  \param       GstElement * element, GstPad *pad, gpointer user_data
*  \return      none
*/
/********************************************************************************************/
tVoid dispvidctrl_tclGstDualAnimation::vFirstFrameRendered(GstElement * element, GstPad *pad, gpointer user_data)
{
	(void)element;
	(void)pad;
	(void)user_data;

    DISPVIDCTRL_NULL_POINTER_CHECK(_pMyStaticRef);
    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Animation FirstFrameRendered", OSAL_ClockGetElapsedTime() - _pMyStaticRef->_u32StartPlayTime);
}

/******************************************************************************/
/* FUNCTION     bBusCall(GstBus *bus, GstMessage *msg,gpointer data)          */
/******************************************************************************/
/**
*  \brief       GStreamer bus handler
*
*  \param       GstBus *bus, GstMessage *msg,gpointer data
*  \return      none
*/
/******************************************************************************/
gboolean dispvidctrl_tclGstDualAnimation::bBusCall(GstBus *bus, GstMessage *msg,gpointer data)
{
    (void)data;
    (void)bus;

    switch (GST_MESSAGE_TYPE (msg)) {

    case GST_MESSAGE_EOS:
        {
            //tell hmi we are done
            dispvidctrl_tclAppMain::theServer()->vPostMsgStoptAnimation("I_dispvidctrl_tclSyncHandler");
            dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Animation done.");

            break;
        }

    case GST_MESSAGE_ERROR:
        {
            //tell hmi we are done
            break;
        }

    default:
        break;
    }

    return TRUE;
}

/******************************************************************************/
/* FUNCTION     vTraceDebugInformation(tVoid)                                 */
/******************************************************************************/
/**
*  \brief       TTFiS Trace for Animation
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstDualAnimation::vTraceDebugInformation(tVoid)
{
   ETG_TRACE_FATAL((" CA-ANIM  :: Animation Configuration"));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16LayerNumber = ................ %d", _u16LayerNumber));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16SurfaceNumber = .............. %d", _u16SurfaceNumber));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16ScreenWidth = ................ %d", _u16ScreenWidth));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16ScreenHeight = ............... %d", _u16ScreenHeight));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u8OpeningAnimation = ............ %d", _u8OpeningAnimation));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u8DisplayAspectRatio = .......... %d", _u8DisplayAspectRatio));

   t_ilm_bool layer_visible = FALSE;
   t_ilm_bool surface_visible = FALSE;
   bool lRc = (ILM_SUCCESS == ilm_layerGetVisibility((unsigned int)_u16LayerNumber,&layer_visible));
   lRc = lRc && (ILM_SUCCESS == ilm_surfaceGetVisibility((unsigned int)_u16SurfaceNumber,&surface_visible));
   ETG_TRACE_FATAL((" CA-ANIM  :: Layer [%d] visibility = .......... %d", _u16LayerNumber, layer_visible));
   ETG_TRACE_FATAL((" CA-ANIM  :: Surface [%d] visibility = ........ %d", _u16SurfaceNumber, surface_visible));
}
#endif //VARIANT_S_FTR_ENABLE_AIVI_NPIVI
