/************************************************************************
* FILE:        dispvidctrl_tclGstAnimation.h
* PROJECT:
* SW-COMPONENT:videoplayer
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of dispvidctrl_tclGstAnimation class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef _dispvidctrl_tclGstAnimation_H_
#define _dispvidctrl_tclGstAnimation_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclGstPipeline.h"

class dispvidctrl_tclGstAnimation : public dispvidctrl_tclGstPipeline
{
private:
    static tVoid    vFirstFrameRendered(GstElement * element, GstPad *pad, gpointer user_data);
    static gboolean bBusCall(GstBus *bus, GstMessage *msg,gpointer data);
   const char *getSpecialWcs(tUInt uIntType, bool useStartFrame, std::string &dirname);
   char const *getAnimationFileName(tUInt uIntType, bool useStartFrame, bool &errRatioDefault, bool &errRatioNotConfigured);
   tVoid setAnimation(std::string pathAndName);



    static dispvidctrl_tclGstAnimation* _pMyStaticRef;

    tU16 _u16LayerNumber;
    tU16 _u16SurfaceNumber;
    tU16 _u16ScreenWidth;
    tU16 _u16ScreenHeight;
    tU32 _u32StartPlayTime;
    tU8 _u8OpeningAnimation;
    tU8 _u8DisplayAspectRatio;
    tU16 _u16DestinationRegion;
    tU8 _u8DisplayOrientation;
    tU8 _u8Brand;
    tU8 _u8WelcomeSequence;

public:
    // constructor
    dispvidctrl_tclGstAnimation(tVoid);
    dispvidctrl_tclGstAnimation(const TEarlyConfiguration& tEarlyConfig, GMainLoop *pGstMainLoop);

    // destructor
    virtual ~dispvidctrl_tclGstAnimation();

    virtual tBool bInit(GMainLoop *pGstMainLoop);
    virtual tVoid vStart(tU8 u8MainOrEnd = 0);
    virtual tVoid vPause();
    virtual tVoid vStop();
    virtual tVoid vTraceDebugInformation(tVoid);
};

#endif /* _dispvidctrl_tclGstAnimation_H_ */
