/******************************************************************************/
/**
* \file    dispvidctrl_tclGstAnimation.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclGstAnimation.h"
#include "dispvidctrl_datapool.h"

#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>

#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VIDEOPLAYER
#include "trcGenProj/Header/dispvidctrl_tclGstAnimation.cpp.trc.h"
#endif
//#define VARIANT_S_FTR_ENABLE_SMART
#define DP_INF4CV_OPENANIMATION_GENERIC_TYPE 0
#define DP_INF4CV_OPENANIMATION_EVOBUS_TYPE 1
#define DP_INF4CV_OPENANIMATION_SMART_TYPE 2
#define DP_INF4CV_CAR_BRAND_SMART_ONLY_TYPE 0
#define DP_INF4CV_CAR_BRAND_SMART_JBL_TYPE 1
#define DP_INF4CV_CAR_BRAND_SMART_CAR2GO_TYPE 2
/*******************************************************************************
                        Defines
*******************************************************************************/

dispvidctrl_tclGstAnimation* dispvidctrl_tclGstAnimation::_pMyStaticRef = NULL;

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclGstAnimation()                                 */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation() : dispvidctrl_tclGstPipeline() {
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation() entered.", OSAL_ClockGetElapsedTime()));
    _pMyStaticRef     = this;

    _u16LayerNumber   = 0;
    _u16SurfaceNumber = 0;
    _u16ScreenWidth   = 0;
    _u16ScreenHeight  = 0;
    _u32StartPlayTime = 0;
    _u8OpeningAnimation = 0;
    _u8DisplayAspectRatio = 0;
    _u16DestinationRegion = 0;
    _u8DisplayOrientation = 0;
    _u8Brand          = 0;
    _u8WelcomeSequence = 0;
}

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclGstAnimation()                                 */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation(const TEarlyConfiguration& tEarlyConfig, GMainLoop *pGstMainLoop): dispvidctrl_tclGstPipeline() {
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation() entered.", OSAL_ClockGetElapsedTime()));
    _pMyStaticRef     = this;

    _u16LayerNumber   = tEarlyConfig.u32AnimationLayer;;
    _u16SurfaceNumber = tEarlyConfig.u32AnimationSurface;
    _u16ScreenWidth   = tEarlyConfig.tEarlyNorForce.u16Display1Width;
    _u16ScreenHeight  = tEarlyConfig.tEarlyNorForce.u16Display1Height;
    _u8OpeningAnimation = tEarlyConfig.tEarlyNorForce.u8EarlyOpeningAnimation;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
    // In case reading of Nor has failed - default to Nissan Animation
    // Note - checking DisplayAspectratio as zero means unconfigured (zero for Brand and OpeningAnimation are valid values for Renault)
    if(_u8DisplayAspectRatio == 0) {
        _u8OpeningAnimation = DISPVIDCTRL_AllianceOpeningAnimation_Type_Nissan;
    }
#endif //VARIANT_S_FTR_ENABLE_AIVI_SCOPE2

    _u8DisplayAspectRatio = tEarlyConfig.tEarlyNorForce.u8EarlyDisplayAspectRatio;
    _u8DisplayOrientation = tEarlyConfig.tEarlyNorForce.u8EarlyDisplayOrientation;

    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation() Opening Animation [%d] Display Aspect Ratio [%d] Display Orientation [%d]", OSAL_ClockGetElapsedTime(), _u8OpeningAnimation, _u8DisplayAspectRatio, _u8DisplayOrientation));
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation() Layer [%d] Surface [%d] Screen Width [%d] Screen Height [%d]", OSAL_ClockGetElapsedTime(), _u16LayerNumber, _u16SurfaceNumber, _u16ScreenWidth, _u16ScreenHeight));

    _u16DestinationRegion = tEarlyConfig.tEarlyNorForce.u16EarlyDestinationRegion;

    _u8Brand           = tEarlyConfig.tEarlyNorForce.u8EarlyBrand;
    _u8WelcomeSequence = tEarlyConfig.tEarlyNorForce.u8EarlyWelcomeSequence;
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::dispvidctrl_tclGstAnimation() DestinationRegion [%d] Brand[%d] WelcomeSequence[%d]", OSAL_ClockGetElapsedTime(), _u16DestinationRegion, _u8Brand, _u8WelcomeSequence));

    _pGstMainLoop = pGstMainLoop;

    _u32StartPlayTime = 0;
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclGstAnimation                                      */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclGstAnimation::~dispvidctrl_tclGstAnimation(tVoid) {
   ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::~dispvidctrl_tclGstAnimation() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vStart(tU8 u8MainOrEnd)                                       */
/******************************************************************************/
/**
*  \brief       Start the Animation
*
*  \param       u8MainOrEnd = 0 - full animation, = 1 - last frame only
*  \return      none
*/
/******************************************************************************/

const char *dispvidctrl_tclGstAnimation::getSpecialWcs(tUInt uIntType, bool useEndFrame, std::string &dirname) {
   const char *res= 0;
   return res;

   /*
    Below code is not commented out because special WCS should be activated through DESMO via config manager.
    */
   // dirname="/var/opt/bosch/persistent/swupdate/activations/ivi_wcs_application/";
   // char const *fileName=(useEndFrame ? "wcs_end_frame_vp8.mkv" : "wcs_vp8.mkv");
   // std::string pathAndName(dirname + fileName);
   // struct stat path_stat;
   // memset(&path_stat, 0, sizeof(path_stat));
   // int r = stat(pathAndName.c_str(), &path_stat);
   // if (r == 0) {
   //    res = fileName;
   // } else if (errno == ENOENT) {
   //    // do nothing
   // } else {
   //    ETG_TRACE_FATAL(("error trying to get stat (errno %8d)of file %s", errno, pathAndName.c_str()));
   // }
   // ETG_TRACE_FATAL(("dispvidctrl_tclGstAnimation::existsInFs( ) r=%i file %s, ", r, pathAndName.c_str()));
   // return res;
}

char const *dispvidctrl_tclGstAnimation::getAnimationFileName(tUInt uIntType, bool useEndFrame, bool &errRatioDefault, bool &errRatioNotConfigured) {
   errRatioDefault=true;
   errRatioNotConfigured=true;

ETG_TRACE_FATAL(("dispvidctrl_tclGstAnimation::getAnimationFileName"));

	tU8 u8AnimationType;
	char *filename = "bosch_logo.mp4"; //default Bosch logo

	dp_tclKdsSystemConfiguration1 systemConfiguration1;
	systemConfiguration1.u8GetOpeningAnimation(u8AnimationType);

	ETG_TRACE_ERRMEM(("Kds value for u8AnimationType is: %d", u8AnimationType));
	
	if(u8AnimationType == DP_INF4CV_OPENANIMATION_EVOBUS_TYPE)//evobus
	{
		filename =  "bosch_logo.mp4";
	}
	else if(u8AnimationType == DP_INF4CV_OPENANIMATION_GENERIC_TYPE)//generic
	{
		filename =  "bosch_logo.mp4";
	}
	else if(u8AnimationType == DP_INF4CV_OPENANIMATION_SMART_TYPE)//smart
	{
		
		tU8 u8Car_brand[2] = {0};
		int u16Car_brand = 0;
		
		if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "CarBrand", &u8Car_brand[0], 2))
		{
			u16Car_brand = static_cast<int>((u8Car_brand[0] << 8) | u8Car_brand[1]);
		}

		ETG_TRACE_ERRMEM(("Kds value for u8Car_brand is: %d", u16Car_brand));
		
		switch(u16Car_brand)
		{
		case DP_INF4CV_CAR_BRAND_SMART_ONLY_TYPE:
			{
				filename =  "smart_logo.mp4";
				break;
			}
		case DP_INF4CV_CAR_BRAND_SMART_JBL_TYPE:
			{
				filename =  "smart_logo_JBL.mp4";
				break;
			}
		case DP_INF4CV_CAR_BRAND_SMART_CAR2GO_TYPE:
			{
				filename =  "smart_logo_Car2Go.mp4";
				break;
			}
		default:
			{
				filename =  "smart_logo.mp4";
				break;
			}	
		}
		
	}
	//#endif

	struct stat sb;
	const char *oemlogofilename = "/var/opt/bosch/persistent/avdecc/oem_logo.mp4";
	if(stat(oemlogofilename, &sb) == 0)
	{
		if(S_ISREG(sb.st_mode))
		{
			// updated OEM logo exists, take this instead
			filename = "oem_logo.mp4";
			ETG_TRACE_ERRMEM(("Overriding u8AnimationType as OEM logo is present at %s", oemlogofilename));
		}
	}

return filename;
/*    //Temporary Code to be used until Welcome Sequence is fully adopted
   if ( (_u8Brand == DISPVIDCTRL_AllianceBrand_Renault) && (_u8WelcomeSequence != DISPVIDCTRL_AllianceWelcomeSequence_None) )
   {
	   switch (_u8WelcomeSequence) {
		   case DISPVIDCTRL_AllianceWelcomeSequence_WS_1: //Dacia
		   {
               switch (_u8DisplayOrientation)
               {
                   case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
                       return !useEndFrame ? "DACIA_Landscape_vp8.mkv" : "DACIA_Landscape_end_frame_vp8.mkv";
                   case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
                       return !useEndFrame ? "DACIA_Portrait_vp8.mkv" : "DACIA_Portrait_end_frame_vp8.mkv";
                   default:
                       return !useEndFrame ? "DACIA_Landscape_vp8.mkv" : "DACIA_Landscape_end_frame_vp8.mkv";
               }
		   }
		   case DISPVIDCTRL_AllianceWelcomeSequence_WS_2: //Initiale
		   {
               switch (_u8DisplayOrientation)
               {
                   case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
                       return !useEndFrame ? "Initiale_Landscape_vp8.mkv" : "Initiale_Landscape_end_frame_vp8.mkv";
                   case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
                       return !useEndFrame ? "Initiale_Portrait_vp8.mkv" : "Initiale_Portrait_end_frame_vp8.mkv";
                   default:
                       return !useEndFrame ? "Initiale_Landscape_vp8.mkv" : "Initiale_Landscape_end_frame_vp8.mkv";
               }
		   }
		   case DISPVIDCTRL_AllianceWelcomeSequence_WS_3: //Initiale 2
		   {
               switch (_u8DisplayOrientation)
               {
                   case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
                       return !useEndFrame ? "Initiale_2_Landscape_vp8.mkv" : "Initiale_2_Landscape_end_frame_vp8.mkv";
                   case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
                       return !useEndFrame ? "Initiale_2_Portrait_vp8.mkv" : "Initiale_2_Portrait_end_frame_vp8.mkv";
                   default:
                       return !useEndFrame ? "Initiale_2_Landscape_vp8.mkv" : "Initiale_2_Landscape_end_frame_vp8.mkv";
               }
		   }
		   case DISPVIDCTRL_AllianceWelcomeSequence_WS_4: //Renault
		   {
               switch (_u8DisplayOrientation)
               {
                   case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
                       return !useEndFrame ? "Renault_Landscape_vp8.mkv" : "Renault_Landscape_end_frame_vp8.mkv";
                   case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
                       return !useEndFrame ? "Renault_Portrait_vp8.mkv" : "Renault_Portrait_end_frame_vp8.mkv";
                   default:
                       return !useEndFrame ? "Renault_Landscape_vp8.mkv" : "Renault_Landscape_end_frame_vp8.mkv";
               }
		   }
		   case DISPVIDCTRL_AllianceWelcomeSequence_WS_5: //RS
		   {
               switch (_u8DisplayOrientation)
               {
                   case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
                       return !useEndFrame ? "RS_Landscape_vp8.mkv" : "RS_Landscape_end_frame_vp8.mkv";
                   case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
                       return !useEndFrame ? "RS_Portrait_vp8.mkv" : "RS_Portrait_end_frame_vp8.mkv";
                   default:
                       return !useEndFrame ? "RS_Landscape_vp8.mkv" : "RS_Landscape_end_frame_vp8.mkv";
               }
		   }
		   case DISPVIDCTRL_AllianceWelcomeSequence_WS_6: //ZE
		   {
               switch (_u8DisplayOrientation)
               {
                   case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
                       return !useEndFrame ? "ZE_Landscape_vp8.mkv" : "ZE_Landscape_end_frame_vp8.mkv";
                   case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
                       return !useEndFrame ? "ZE_Portrait_vp8.mkv" : "ZE_Portrait_end_frame_vp8.mkv";
                   default:
                       return !useEndFrame ? "ZE_Landscape_vp8.mkv" : "ZE_Landscape_end_frame_vp8.mkv";
               }
		   }
		   //case DISPVIDCTRL_AllianceWelcomeSequence_WS_7:
		   //case DISPVIDCTRL_AllianceWelcomeSequence_WS_8:
	   }
   }

   switch (_u8Brand) {
      case DISPVIDCTRL_AllianceBrand_Dacia:
         switch (_u8DisplayOrientation)
         {
            case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
               return !useEndFrame ? "DACIA_Landscape_vp8.mkv" : "DACIA_Landscape_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
               return !useEndFrame ? "DACIA_Portrait_vp8.mkv" : "DACIA_Portrait_end_frame_vp8.mkv";
            default:
               return !useEndFrame ? "DACIA_Landscape_vp8.mkv" : "DACIA_Landscape_end_frame_vp8.mkv";
         }
   }

   switch (uIntType) {
      case DISPVIDCTRL_AllianceOpeningAnimation_Type_Renault:
         switch (_u8DisplayOrientation)
         {
            case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
               return !useEndFrame ? "Renault_Landscape_vp8.mkv" : "Renault_Landscape_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
               return !useEndFrame ? "Renault_Portrait_vp8.mkv" : "Renault_Portrait_end_frame_vp8.mkv";
            default:
               return !useEndFrame ? "Renault_Landscape_vp8.mkv" : "Renault_Landscape_end_frame_vp8.mkv";
         }

      case DISPVIDCTRL_AllianceOpeningAnimation_Type_Nissan:
         switch (_u8DisplayAspectRatio)
         {
            case DISPVIDCTRL_AllianceDisplayAspectRatio_Not_Configured:
               errRatioNotConfigured=true;
               return !useEndFrame ? "Nissan_17_9_vp8.mkv" : "Nissan_17_9_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplayAspectRatio_15_9:
               return !useEndFrame ? "Nissan_15_9_vp8.mkv" : "Nissan_15_9_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplayAspectRatio_17_9:
               return !useEndFrame ? "Nissan_17_9_vp8.mkv" : "Nissan_17_9_end_frame_vp8.mkv";
            default:
               errRatioDefault=true;
               return !useEndFrame ? "Nissan_17_9_vp8.mkv" : "Nissan_17_9_end_frame_vp8.mkv";
         }

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
      case DISPVIDCTRL_AllianceOpeningAnimation_Type_Infiniti:
         switch (_u16DestinationRegion)
         {
            case DISPVIDCTRL_REGION_JPN:
               return !useEndFrame ? "OP_Dual_3_Lower_Japan.mkv" : 0;
            case DISPVIDCTRL_REGION_CAN:
               return !useEndFrame ? "OP_Dual_1_Lower_USCAN.mkv" : 0;
            case DISPVIDCTRL_REGION_US:
               return !useEndFrame ? "OP_Dual_1_Lower_USCAN.mkv" : 0;
            default:
               errRatioDefault=true;
               return !useEndFrame ? "OP_Dual_2_Lower_other.mkv" : 0;
         }
#endif //VARIANT_S_FTR_ENABLE_AIVI_NPIVI

      case DISPVIDCTRL_AllianceOpeningAnimation_Type_EV_Nissan:
         switch (_u8DisplayAspectRatio)
         {
            case DISPVIDCTRL_AllianceDisplayAspectRatio_Not_Configured:
               errRatioNotConfigured=true;
               return !useEndFrame ? "EV_Nissan_17_9_vp8.mkv" : "EV_Nissan_17_9_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplayAspectRatio_15_9:
               return !useEndFrame ? "EV_Nissan_15_9_vp8.mkv" : "EV_Nissan_15_9_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplayAspectRatio_17_9:
               return !useEndFrame ? "EV_Nissan_17_9_vp8.mkv" : "EV_Nissan_17_9_end_frame_vp8.mkv";
            default:
               errRatioDefault=true;
               return !useEndFrame ? "EV_Nissan_17_9_vp8.mkv" : "EV_Nissan_17_9_end_frame_vp8.mkv";
         }

      case DISPVIDCTRL_AllianceOpeningAnimation_Type_RSM:
         return !useEndFrame ? "RSM_vp8.mkv" : "RSM_end_frame_vp8.mkv";
      case DISPVIDCTRL_AllianceOpeningAnimation_Type_GT_line:
         return !useEndFrame ? "GT_line_vp8.mkv" : "GT_line_end_frame_vp8.mkv";
      case DISPVIDCTRL_AllianceOpeningAnimation_Type_Initiale:
         switch (_u8DisplayOrientation)
         {
            case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
               return !useEndFrame ? "Initiale_Landscape_vp8.mkv" : "Initiale_Landscape_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
               return !useEndFrame ? "Initiale_Portrait_vp8.mkv" : "Initiale_Portrait_end_frame_vp8.mkv";
            default:
               return !useEndFrame ? "Initiale_Landscape_vp8.mkv" : "Initiale_Landscape_end_frame_vp8.mkv";
         }
      case DISPVIDCTRL_AllianceOpeningAnimation_Type_RS:
         switch (_u8DisplayOrientation)
         {
            case DISPVIDCTRL_AllianceDisplay_Format_Landscape:
               return !useEndFrame ? "RS_Landscape_vp8.mkv" : "RS_Landscape_end_frame_vp8.mkv";
            case DISPVIDCTRL_AllianceDisplay_Format_Portrait:
               return !useEndFrame ? "RS_Portrait_vp8.mkv" : "RS_Portrait_end_frame_vp8.mkv";
            default:
               return !useEndFrame ? "RS_Landscape_vp8.mkv" : "RS_Landscape_end_frame_vp8.mkv";
         }
      default:
         return 0;
   } */
}



tVoid dispvidctrl_tclGstAnimation::setAnimation(std::string pathAndName) {

   g_object_set (G_OBJECT (_pGstSource), "uri", (std::string("file://") + pathAndName).c_str(), NULL); //lint !e826 PQM_authorized_multi_415
   ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::setAnimation() - Selected Video %s", OSAL_ClockGetElapsedTime(), pathAndName.c_str()));

}

tVoid dispvidctrl_tclGstAnimation::vStart(tU8 bOnlyLastFrame) {
   ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart(_u8OpeningAnimation=%u bOnlyLastFrame=%d)", _u8OpeningAnimation, bOnlyLastFrame,  OSAL_ClockGetElapsedTime()));

    _u32StartPlayTime = OSAL_ClockGetElapsedTime();
    if(_pGstSource == 0) {
       ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - Animation not yet initialised - calling bInit()", OSAL_ClockGetElapsedTime()));
       bInit(_pGstMainLoop);
              ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - _pGstSource is zero - end of bInit()", OSAL_ClockGetElapsedTime()));
    }

    std::string filesPath;
    bool errRatioDefault=false;
    bool errRatioNotConfigured=false;
    const char *animationFileName=0;
    if (animationFileName=getSpecialWcs(_u8OpeningAnimation, bOnlyLastFrame, filesPath)) {
       ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclGstAnimation::vStart() - Using special Welcome Sequence", OSAL_ClockGetElapsedTime()));
    } else if (animationFileName=getAnimationFileName(_u8OpeningAnimation, bOnlyLastFrame, errRatioDefault, errRatioNotConfigured)) {
       filesPath="/opt/bosch/early/videos/";
       if (errRatioDefault) {
          ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - Selected Video (Default) %s", OSAL_ClockGetElapsedTime(), animationFileName));
       }
       else if (errRatioNotConfigured) {
          ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - Aspect ratio not configured - Select Video %s", OSAL_ClockGetElapsedTime(), animationFileName));
       }
    } else {
       ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - Error - Animation Type [%d] Not Recognized", OSAL_ClockGetElapsedTime(), _u8OpeningAnimation));
    }

    if (animationFileName) {
       setAnimation(filesPath + animationFileName);
    }

    //Set the layer visibility
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - LayerManagerControl Layer %d visibility -> 1", OSAL_ClockGetElapsedTime(), _u16LayerNumber));

    bool lRc = (ILM_SUCCESS == ilm_layerSetVisibility((unsigned int)_u16LayerNumber,1));

    // Commit changes to ILM
    lRc = lRc && (ILM_SUCCESS == ilm_commitChanges());
    if(lRc != TRUE) {
        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStart() - LayerManagerControl Commit Failed [%d]", OSAL_ClockGetElapsedTime(), lRc));
    }

    gst_element_set_state(_pGstSource, GST_STATE_PLAYING);
}

/******************************************************************************/
/* FUNCTION     vPause()                                                      */
/******************************************************************************/
/**
*  \brief       Pause the Animation
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstAnimation::vPause() {
    DISPVIDCTRL_NULL_POINTER_CHECK(_pGstSource);
    gst_element_set_state(_pGstSource, GST_STATE_PAUSED);
}

/******************************************************************************/
/* FUNCTION     vStop( )                                                      */
/******************************************************************************/
/**
*  \brief       Stop the Animation
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstAnimation::vStop() {
    //Set the layer visibility
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStop() - LayerManagerControl Layer %d visibility -> 0", OSAL_ClockGetElapsedTime(), _u16LayerNumber));
    bool lRc = (ILM_SUCCESS == ilm_layerSetVisibility((unsigned int)_u16LayerNumber,0));

    // Commit changes to ILM
    lRc = lRc && (ILM_SUCCESS == ilm_commitChanges());
    if(lRc != TRUE) {
        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::vStop() - LayerManagerControl Commit Failed [%d]", OSAL_ClockGetElapsedTime(), lRc));
    }

    DISPVIDCTRL_NULL_POINTER_CHECK(_pGstSource);
    gst_element_set_state(_pGstSource, GST_STATE_NULL);
}

/******************************************************************************/
/* FUNCTION     bInit(GMainLoop *pGstMainLoop)                                */
/******************************************************************************/
/**
*  \brief       Initialise the Animation GStreamer Pipeline
*
*  \param       GMainLoop *pGstMainLoop - Pointer to GStreamer
*  \return      none
*/
/******************************************************************************/
tBool dispvidctrl_tclGstAnimation::bInit(GMainLoop *pGstMainLoop) {

    if (_pGstSource != NULL && _pGstSink != NULL) {
        // we are already initialized
        return TRUE;
    }

    tU32 u32StartTime = OSAL_ClockGetElapsedTime();

    _pGstMainLoop = pGstMainLoop;
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstMainLoop);

    _pGstSource   = gst_element_factory_make("playbin2","video-player");
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstSource);

    // Select video only and use only native video formats
    g_object_set (G_OBJECT (_pGstSource), "flags", 0x41 , NULL); //lint !e826 PQM_authorized_multi_415

    _pGstSink     = gst_element_factory_make("gst_apx_sink", "animationVideoSink");
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstSink);

    g_object_set (G_OBJECT (_pGstSource), "uri", "file:///opt/bosch/early/videos/bosch_logo-HD.mkv", NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "layer-id", _u16LayerNumber, NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "surface-id", _u16SurfaceNumber, NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "display-width", _u16ScreenWidth, NULL); //lint !e826 PQM_authorized_multi_415
    g_object_set (G_OBJECT (_pGstSink), "display-height", _u16ScreenHeight , NULL); //lint !e826 PQM_authorized_multi_415

    g_signal_connect(_pGstSink,"first-videoframe-rendered",G_CALLBACK (dispvidctrl_tclGstAnimation::vFirstFrameRendered), NULL);

    _pGstBus = gst_pipeline_get_bus (GST_PIPELINE (_pGstSource)); //lint !e826 PQM_authorized_multi_415
    DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_pGstBus);

    gst_bus_add_watch (_pGstBus, dispvidctrl_tclGstAnimation::bBusCall, _pGstMainLoop);

    //Set the layer visibility
    ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::bInit() - LayerManagerControl Layer %d visibility -> 1", OSAL_ClockGetElapsedTime(), _u16LayerNumber));
    bool lRc = (ILM_SUCCESS == ilm_layerSetVisibility((unsigned int)_u16LayerNumber,1));

    // Commit changes to ILM
    lRc = lRc && (ILM_SUCCESS == ilm_commitChanges());
    if(lRc != TRUE) {
        ETG_TRACE_FATAL (("[%d ms] dispvidctrl_tclGstAnimation::bInit() - LayerManagerControl Commit Failed [%d]", OSAL_ClockGetElapsedTime(), lRc));
    }

    g_object_set(G_OBJECT(_pGstSource),"video-sink",_pGstSink,NULL); //lint !e826 PQM_authorized_multi_415

    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Animation pipeline init complete", OSAL_ClockGetElapsedTime() - u32StartTime);
    return TRUE;
}

/********************************************************************************************/
/* FUNCTION     vFirstFrameRendered(GstElement * element, GstPad *pad, gpointer user_data)  */
/********************************************************************************************/
/**
*  \brief       GStreamer callback when first frame is visible
*
*  \param       GstElement * element, GstPad *pad, gpointer user_data
*  \return      none
*/
/********************************************************************************************/
tVoid dispvidctrl_tclGstAnimation::vFirstFrameRendered(GstElement * element, GstPad *pad, gpointer user_data)
{
	(void)element;
	(void)pad;
	(void)user_data;

    DISPVIDCTRL_NULL_POINTER_CHECK(_pMyStaticRef);
    dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Animation FirstFrameRendered", OSAL_ClockGetElapsedTime() - _pMyStaticRef->_u32StartPlayTime);
}

/******************************************************************************/
/* FUNCTION     bBusCall(GstBus *bus, GstMessage *msg,gpointer data)          */
/******************************************************************************/
/**
*  \brief       GStreamer bus handler
*
*  \param       GstBus *bus, GstMessage *msg,gpointer data
*  \return      none
*/
/******************************************************************************/
gboolean dispvidctrl_tclGstAnimation::bBusCall(GstBus *bus, GstMessage *msg,gpointer data)
{
    (void)data;
    (void)bus;

    switch (GST_MESSAGE_TYPE (msg)) {

    case GST_MESSAGE_EOS:
        {
            //tell hmi we are done
            dispvidctrl_tclAppMain::theServer()->vPostMsgStoptAnimation("I_dispvidctrl_tclSyncHandler");
            dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Animation done.");

            break;
        }

    case GST_MESSAGE_ERROR:
        {
            //tell hmi we are done
            break;
        }

    default:
        break;
    }

    return TRUE;
}

/******************************************************************************/
/* FUNCTION     vTraceDebugInformation(tVoid)                                 */
/******************************************************************************/
/**
*  \brief       TTFiS Trace for Animation
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclGstAnimation::vTraceDebugInformation(tVoid)
{
   ETG_TRACE_FATAL((" CA-ANIM  :: Animation Configuration"));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16LayerNumber = ................ %d", _u16LayerNumber));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16SurfaceNumber = .............. %d", _u16SurfaceNumber));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16ScreenWidth = ................ %d", _u16ScreenWidth));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u16ScreenHeight = ............... %d", _u16ScreenHeight));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u8OpeningAnimation = ............ %d", _u8OpeningAnimation));
   ETG_TRACE_FATAL((" CA-ANIM  :: _u8DisplayAspectRatio = .......... %d", _u8DisplayAspectRatio));

   t_ilm_bool layer_visible = FALSE;
   t_ilm_bool surface_visible = FALSE;
   bool lRc = (ILM_SUCCESS == ilm_layerGetVisibility((unsigned int)_u16LayerNumber,&layer_visible));
   lRc = lRc && (ILM_SUCCESS == ilm_surfaceGetVisibility((unsigned int)_u16SurfaceNumber,&surface_visible));
   ETG_TRACE_FATAL((" CA-ANIM  :: Layer [%d] visibility = .......... %d", _u16LayerNumber, layer_visible));
   ETG_TRACE_FATAL((" CA-ANIM  :: Surface [%d] visibility = ........ %d", _u16SurfaceNumber, surface_visible));
}
