/******************************************************************************/
/**
* \file    dispvidctrl_tclControlGraphic.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VIDEO_PLAYER_CONTROL_GRAPHIC_H_
#define _VIDEO_PLAYER_CONTROL_GRAPHIC_H_

/*******************************************************************************
                        Includes
*******************************************************************************/

#include <signal.h>
#include <sys/time.h>

#include <ilm/ilm_common.h>
#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_datapool.h"
#include "vd_rvc_tclGraphics_DynGuideline.h"

// enumeration of user action events.
enum tenControlActionEvent_Control_Graphic
{
   EN_ACTION_CONTROL_GRAPHIC_NONE = 0,
   EN_ACTION_CONTROL_GRAPHIC_BLACKSCREEN_ON,
   EN_ACTION_CONTROL_GRAPHIC_BLACKSCREEN_OFF,
   EN_ACTION_CONTROL_GRAPHIC_GUIDELINE_AND_WARNINGTEXT_OFF,
   EN_ACTION_CONTROL_GRAPHIC_GUIDELINE_AND_WARNINGTEXT_ON,
   EN_ACTION_CONTROL_GRAPHIC_GUIDELINE_WARNINGTEXT_TOGGLE,
   EN_ACTION_CONTROL_GRAPHIC__LANGUAGE_UPDATE
};

// enumeration of user action events.
enum tenControlEvent_Control_Graphic
{
   EN_EVENT_CONTROL_GRAPHIC__NONE = 0,
   EN_EVENT_CONTROL_GRAPHIC__DYN_GUIDELINE_UPDATE
};

/*******************************************************************************
                        Defines
*******************************************************************************/

/* ------------------------------------------------------------------------- */
/* graphic configurations                                                    */
/* ------------------------------------------------------------------------- */
#define RVC_DISPLAY_RESOLUTION_5_8_INCH_WIDTH    (tU16) 480
#define RVC_DISPLAY_RESOLUTION_5_8_INCH_HEIGHT   (tU16) 272
#define RVC_DISPLAY_RESOLUTION_7_INCH_WIDTH      (tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1WIDTH
#define RVC_DISPLAY_RESOLUTION_7_INCH_HEIGHT     (tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1HEIGHT
#define RVC_DISPLAY_RESOLUTION_3_5_INCH_WIDTH    (tU16) 400
#define RVC_DISPLAY_RESOLUTION_3_5_INCH_HEIGHT   (tU16) 240
#define RVC_WARNINGTEXT_7_INCH_HIGH   (tU16) 56
#define RVC_ZONE3_LANDSCAPE_HIGH      (tU16) 78
#define RVC_WARNINGTEXT_7_INCH_WIDE   (tU16) 800
#define RVC_WARNINGTEXT_5_8_INCH_HIGH (tU16) 30
#define RVC_WARNINGTEXT_3_5_INCH_HIGH (tU16) 27

#define RVC_BITMAP_PATH_RESOLUTION_800_480 "/rearview/800x480"
#define RVC_BITMAP_PATH_RESOLUTION_480_272 "/rearview/480x272"
#define RVC_BITMAP_PATH_RESOLUTION_400_240 "/rearview/400x240"

#define IPA_DISPLAY_RESOLUTION_7_INCH_WIDTH      (tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1WIDTH
#define IPA_DISPLAY_RESOLUTION_7_INCH_HEIGHT     (tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1HEIGHT
#define IPA_WARNINGTEXT_7_INCH_HIGH   (tU16) 56
#define IPA_WARNINGTEXT_7_INCH_WIDE   (tU16) 480

#define VIDEO_IMAGE_X_PIXELS 1440
#define VIDEO_IMAGE_Y_PIXELS 525

/*******************************************************************************
   dispvidctrl_tclControlGraphic Class
*******************************************************************************/

struct sDecodedImageData;

class dispvidctrl_tclControlGraphic
{
public:

   dispvidctrl_tclControlGraphic(const TEarlyConfiguration& tEarlyConfig);
   virtual ~dispvidctrl_tclControlGraphic(void);

private:
   // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
   dispvidctrl_tclControlGraphic(const dispvidctrl_tclControlGraphic&);
   dispvidctrl_tclControlGraphic& operator=(const dispvidctrl_tclControlGraphic&);
public:
    
   void vStartGuidelines(void);
   void vStopGuidelines(void);
   
   void vOnPreInit();
   void vOnSetupGuidelineParams(unsigned char u8VideoType, unsigned char u8VideoResizeParamIndex);

   tVoid vSetWarningTextLanguage(tU8 u8Language);
   tVoid vSetGuideLineVisibility(tU32 u32Visibility);
   tVoid vSetWarningTextVisibility(tU32 u32Visibility);
   tVoid vSetDefalutLanguage();
   tVoid vSetSteeringWheelAngle(tS32 s32SteeringWheelAngle);
   tVoid vSetRearWheelAngle(tS32 s32RearWheelAngle);

   tVoid vSwitchToBlackScreen(tU8 u8BlackScreenType);
   tVoid vSwitchToGuidelinesDisplay(void);
   
   tVoid vRemoveEarlyOnlyGraphics(void);

   tVoid vTraceDebugInformation(tVoid);

   tVoid vIndVehicleConfigChanged_DynGuideline(tVoid);
   vd_rvc_tstVehicleParams* vGetVehicleConfigPtr_DynGuideline(tVoid);
   tVoid vSetVehicleConfig_DynGuideline(tVoid);
   tVoid vSetTemporaryCalibGuidelnStyle(tBool bActive);
   tVoid vSetInitialblackscreenMask(tU8 u8BlackScreenType);
   tVoid vDrawBlackscreen(int width, int height, int top_buffer_offset, int left_buffer_offset);

private:
   static void* vGuidelineThread(void* arg) {
      return ((dispvidctrl_tclControlGraphic*)arg)->vGuidelineThreadMainLoop();
   }
   void* vGuidelineThreadMainLoop(void);

   void vDrawGuidelines(void);
   void vUpdateGuidelinesDisplay(tU8 u8BlackScreenType);
   void vOnInit();

   // to handle control actions
   void vOnControlAction(tenControlActionEvent_Control_Graphic enControlAction, unsigned int u32Value = 0);
   void vOnControlEvent(unsigned int u32Value = 0);

   unsigned char*                    m_pU8Buffer_DynGuideline;
   unsigned int                      m_ScreenWidth;
   unsigned int                      m_ScreenHeight;
   unsigned int                      m_RVCLayer;
   unsigned int                      m_RVCGraphicsLayer;
   unsigned int                      m_GuidelineSurface;
   unsigned int                      m_RVCSurface;
   unsigned int                      m_GuidelineWarningLanguage;
   unsigned int                      m_GuidelineVisibility;
   unsigned int                      m_GuidelineBlackWarningTextBackground;
   unsigned int                      m_GuidelineWarningText;
   unsigned int                      m_GuidelineDrawingWidth;
   unsigned int                      m_GuidelineDrawingHeight;
   unsigned int                      m_DisplayOrientation;
   bool                              m_GuidelinesDisplaying;
   bool                              m_GuidelinesCurrentlyVisible;
   bool                              m_LeftHandSteeringPosition;
   uint8_t                            m_warningTextPosition;


   void _vUpdateDrawings_Rvc(void);

private:
   void _vConfiguration(void);
   void _vUpdateDrawings_IpaMask(const tU8 u8Pattern);
   void _vUpdateDrawings_IpaWarningText(void);
   void _vDetermineWarningTextPostion();
   void _vUpdateDrawings_WarningText(sDecodedImageData* l_pngDecodedImageData, int width, int height, int buffer_offset, int left_buffer_offset);

   int _intDecodePNGIntoBuffer(const char* f_fname,  //!< file name
                               struct sDecodedImageData& f_decodedData, //!< decoded Data
                               const bool& f_corfbFlipImage,  //! flip image
                               const bool& f_corfbPadImage,
                               bool bSwapBGR = false);  //! swap BGR<=>RGB byte order

   dispvidctrl_tclControlGraphic*    m_po_dispvidctrl_tclControlGraphic;
   bool                              m_bInitialized;
   vd_rvc_tclGraphics_DynGuideline*  m_poGraphics_DynGuideline;
   bool                              m_bGraphicAvailable;
   tCString                          m_szBasePath_Bitmap;
   bool                              m_bFirstDraw;
   bool                              m_bHmiAvailable;

   unsigned int                      m_ScreenXOffset;
   unsigned int                      m_ScreenYOffset;

   tDouble                           _dSteeringWheelAngle;
   tDouble                           _dRearWheelAngle;

   tBool                             _bSteeringWheelAngleChanged;
   tBool                             _bRearWheelAngleChanged;

   tBool                             _bThreadActive;
   tBool                             _bBlackScreenActive;

   unsigned char                     m_au8GuidelineVehicleParameter[80];
   unsigned int                      m_GuidelineCameraType;
   unsigned int                      m_GuidelineCameraSystemType;

   pthread_t                         guideline_thread;
};

#endif // _VIDEO_PLAYER_CONTROL_GRAPHIC_H_
