/*****************************************************************************************
* FILE         : VideoPlayer_PNG_Decoder.h
*
* SW-COMPONENT :
* DESCRIPTION  : PNG Decoder using libpng
*
* AUTHOR       : RBIN/ECM1-Thomas, with extensions from CM-AI/EAR Steffen Abraham
* COPYRIGHT    : (c) 2007 Robert Bosch India
*
* HISTORY      : 18/06/2007 Initial Revision
****************************************************************************************/
/**
* \file VideoPlayer_PNG_Decoder.h
*
* PNG Decoder using libpng
*
* Initial Version: 18/06/2007  RBIN/ECM1-Thomas
*/

#ifndef VIDEOPLAYER_PNG_DECODER_H
#define VIDEOPLAYER_PNG_DECODER_H

#define PNG_USER_MEM_SUPPORTED
#include "png.h"

//! function to read and decode png from file
int readPNGAndDecodeFromFile(const char* f_fname,  //!< file name
                             struct sDecodedImageData& f_decodedData, //!< decoded Data
                             const bool& f_corfbFlipImage,  //! flip image
                             const bool& f_corfbPadImage,
                             bool bSwapBGR = false);  //! swap BGR<=>RGB byte order

//! function to read the raw png data from file
int readPngDataFromFile(const char* f_fname,            //!< file name
                        struct sPNGData& f_pngData      //!< struct holding the file contents
                       );

//! helper function to get nearest power of 2 value;
unsigned int u32GetNearestPowerOfTwoValue(unsigned int u32Value);

//! struct to store raw-data from png file
struct sPNGData
{
   //! c'tor
   sPNGData(): m_pu8Data(0L), m_u32Size(0), m_u32DataAlreadyRead(0) {}

   unsigned char* m_pu8Data;               //!< ptr to internal buffer
   unsigned int m_u32Size;                 //!< number of bytes in buffer
   unsigned int m_u32DataAlreadyRead;      //!< bytes already read from the PNG-Reader
};

//! struct to store decoded image data in RGBA-Format
struct sDecodedImageData
{
   //! c'tor
   sDecodedImageData() : m_u32Height(0),m_u32Width(0),m_pu8Data(0L),m_u8NoOfChannels(0), m_u8BitsPerPixel(0), m_bAlpha(false)
   {

   }

   //! d'tor
   ~sDecodedImageData()
   {
      if (0L != m_pu8Data)
      {
         free(m_pu8Data);
         m_pu8Data = 0L;
      }
   }

   unsigned int m_u32Height;               //!< height of png-image
   unsigned int m_u32Width;                //!< width of png-image
   unsigned char* m_pu8Data;               //!< buffer with image data in RGBA format
   unsigned char m_u8NoOfChannels;         //!< number of channels (4)
   unsigned char m_u8BitsPerPixel;         //!< number of bits per channel (32)
   bool m_bAlpha;                          //!< activation of alpha channel

private:
   // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
   sDecodedImageData(const sDecodedImageData&);
   sDecodedImageData& operator=(const sDecodedImageData&);
};

//! class from map-project with the png-decoder (every method itself is a function)
class rl_tclPNG_Decoder
{
private:

   /**
   * \brief rl_tclPNG_Decoder
   *
   *  Constructor (private so that an object is never created)
   *
   * @param tVoid
   * @return None
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   rl_tclPNG_Decoder() {};


   /**
   * \brief ~rl_tclPNG_Decoder
   *
   *  Destructor
   *
   * @param None
   * @return None
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   ~rl_tclPNG_Decoder() {}; //lint !e1704 Info 1704: prio3: Constructor 'rl_tclPNG_Decoder::rl_tclPNG_Decoder(void)' has private access specification

public:


   /**
   * \brief pvMemoryAllocator
   *
   *  The memory allocator function to be handed over to libpng
   *
   * @param png_ptr png_structp
   * @param size png_size_t
   * @return tVoid*
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   static void* pvMemoryAllocator(png_structp png_ptr, png_size_t size);


   /**
   * \brief vMemoryDeallocator
   *
   *  The memory deallocator function to be handed over to libpng
   *
   * @param png_ptr png_structp
   * @param ptr png_voidp
   * @return tVoid
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   static void vMemoryDeallocator(png_structp png_ptr, void* ptr);


   /**
   * \brief vRead_Function
   *
   *  The read function that reads data from the sPNGData structure. Handed over to libpng
   *
   * @param png_ptr png_structp
   * @param data png_bytep
   * @param length png_size_t
   * @return tVoid
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   static void vRead_Function(png_structp png_ptr, png_bytep data, png_size_t length);


   /**
   * \brief vError_Function
   *
   *  The error function that reports errors. Handed over to libpng
   *
   * @param png_ptr png_structp
   * @param warning_msg png_const_charp
   * @return tVoid
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   static void vError_Function(png_structp png_ptr, png_const_charp error_msg);


   /**
   * \brief vWarning_Function
   *
   *  The warning function that reports warnings. Handed over to libpng
   *
   * @param png_ptr png_structp
   * @param warning_msg png_const_charp
   * @return tVoid
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   static void vWarning_Function(png_structp png_ptr, png_const_charp warning_msg);


   /**
   * \brief bDecodePNG
   *
   *  Decodes the PNG data in roPNGFileData to fill the roDecodedImage object
   *
   * @param roDecodedImage struct sDecodedImageData&
   * @param roPNGFileData const struct sPNGData&
   * @param corfbFlipImage const tBool&
   * @return tBool
   *
   * \author Anish Thomas (RBIN/ECM1)
   */
   static int bDecodePNG(struct sDecodedImageData& roDecodedImage, struct sPNGData& roPNGFileData,
                         const bool& corfbFlipImage = false, const bool& corfbPadImage = false,
                         bool bSwapBGR = false);

};

#endif //VIDEOPLAYER_PNG_DECODER_H
