/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_Util.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2014 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_UTIL_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_UTIL_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif


/*******************************************************************************
                        Macros
*******************************************************************************/

#define GET_U16_FROM_U8_ARRAY(arr,idx)  ((tU16)( (((arr)[(idx)+0])<<8) + ((arr)[(idx)+1]) ))
#define GET_S16_FROM_U8_ARRAY(arr,idx)  ((tS16)( (((arr)[(idx)+0])<<8) + ((arr)[(idx)+1]) ))


/*******************************************************************************
                        Class declarations
*******************************************************************************/


class vd_rvc_t2Vector;


class vd_rvc_t3Vector
{
   private:
      tDouble _x, _y, _z;

   public:
      inline tDouble x(tVoid) const { return _x; }
      inline tDouble y(tVoid) const { return _y; }
      inline tDouble z(tVoid) const { return _z; }
      
      vd_rvc_t3Vector(tVoid);
      vd_rvc_t3Vector(tDouble dX, tDouble dY, tDouble dZ);
      vd_rvc_t3Vector(const vd_rvc_t2Vector & oVec2D);     // z coordinate of constructed vector will be set to 0.0

      const vd_rvc_t3Vector & operator*= (tDouble dFact);
      const vd_rvc_t3Vector & operator+= (const vd_rvc_t3Vector & oVec);
      const vd_rvc_t3Vector & operator-= (const vd_rvc_t3Vector & oVec);
      vd_rvc_t3Vector operator* (tDouble dFact) const;
      vd_rvc_t3Vector operator+ (const vd_rvc_t3Vector & oVec) const;
      vd_rvc_t3Vector operator- (const vd_rvc_t3Vector & oVec) const;
};


class vd_rvc_t2Vector
{
   private:
      tDouble _x, _y;

   public:
      inline tDouble x(tVoid) const { return _x; }
      inline tDouble y(tVoid) const { return _y; }
      
      vd_rvc_t2Vector(tVoid);
      vd_rvc_t2Vector(tDouble dX, tDouble dY);
      vd_rvc_t2Vector(const vd_rvc_t3Vector & oVec3D);    // z coordinate of input 3D vector will be ignored
      
      const vd_rvc_t2Vector & operator*= (tDouble dFact);
      const vd_rvc_t2Vector & operator+= (const vd_rvc_t2Vector & oVec);
      const vd_rvc_t2Vector & operator-= (const vd_rvc_t2Vector & oVec);
      vd_rvc_t2Vector operator* (tDouble dFact) const;
      vd_rvc_t2Vector operator+ (const vd_rvc_t2Vector & oVec) const;
      vd_rvc_t2Vector operator- (const vd_rvc_t2Vector & oVec) const;
      tDouble operator* (const vd_rvc_t2Vector & oVec) const;  // scalar product of two vectors
};


class vd_rvc_t2IntVect
{
   private:
      tS32 _x, _y;

   public:
      inline tS32 x(tVoid)              const { return _x;  }
      inline tS32 y(tVoid)              const { return _y;  }
      
      inline tVoid vSet(tS32 x_  , tS32 y_  ) { _x=x_; _y=y_; }
      tVoid        vSet(tFloat x_, tS32 y_  );
      tVoid        vSet(tS32 x_  , tFloat y_);
      
      vd_rvc_t2IntVect(tVoid);
      vd_rvc_t2IntVect(tS32 s32X, tS32 s32Y);
      vd_rvc_t2IntVect(const vd_rvc_t2Vector & oP2D);
};


class vd_rvc_tcl2x2Matrix
{
   /********** properties **********/
   
   private:
      tDouble _A[2][2];
   
   /********** methods **********/
   
   public:
#ifdef EIS2HI_DEB_TEST_ENV
      inline tDouble A(tU32 i, tU32 j) const { return _A[i][j]; }
#endif
   
      vd_rvc_tcl2x2Matrix(tVoid);
      vd_rvc_tcl2x2Matrix(tDouble A00, tDouble A01,   tDouble A10, tDouble A11);
      
      const vd_rvc_tcl2x2Matrix & operator*= (const vd_rvc_tcl2x2Matrix & oRight);
      vd_rvc_tcl2x2Matrix operator* (const vd_rvc_tcl2x2Matrix & oRight) const;
      vd_rvc_t2Vector operator* (const vd_rvc_t2Vector & oVec) const;
      tDouble dDet(void) const;
      tBool   bInvert(vd_rvc_tcl2x2Matrix * poInv);
};


class vd_rvc_tcl3x3Matrix
{
   /********** properties **********/
   
   private:
      tDouble _A[3][3];
      
   /********** methods **********/
   
   public:
#ifdef EIS2HI_DEB_TEST_ENV
      inline tDouble A(tU32 i, tU32 j) const { return _A[i][j]; }
#endif

      vd_rvc_tcl3x3Matrix(tVoid);
      vd_rvc_tcl3x3Matrix(tDouble A00, tDouble A01, tDouble A02,   tDouble A10, tDouble A11, tDouble A12,   tDouble A20, tDouble A21, tDouble A22);
      
      const vd_rvc_tcl3x3Matrix & operator*= (const vd_rvc_tcl3x3Matrix & mRight);
      vd_rvc_tcl3x3Matrix operator* (const vd_rvc_tcl3x3Matrix & mRight) const;
      vd_rvc_t3Vector operator* (const vd_rvc_t3Vector & p) const;
      tDouble dDet(void) const;
      tBool   bInvert(vd_rvc_tcl3x3Matrix * poInv);
};


class vd_rvc_tclFlexFloat
{
   private:
      static const tDouble s_dInfValue;  // value representing "Infinity"
      static const tDouble s_dNaNValue;  // value representing "NaN"
   
      tU8     m_u8NumBits;     // total number of bits used (3...32) to code a value
      tU8     m_u8NumExpBits;  // number of bits of the (binary) exponent in the code
      tS16    m_s16ExpBias;    // the exponent's user-defined "logical extra bias" to shift the value range towards higher or lower exponents
      tBool   m_bSigned;       // whether or not a sig bit is present in the code (<=> signed/unsigned float)
      
      tU8     m_u8NumBytes;    // number of bytes needed to hold one FlexFloat of current type
      tU8     m_u8NumMantBits; // number of mantissa bits stored in the code
      
      tU32    m_u32SignBit;    // bitmask for the sign bit, if any
      tU32    m_u32HiddenBit;  // minimum mantissa bit string (consisting of only the hidden MSbit which will not be stored in the code => is a pure power of 2)
      tU32    m_u32ExpMask;    // mask for the exponent in the code *after* shifting it down to bit0
      tU32    m_u32MantMask;   // mask for the mantissa in the code *without* the hidden MSbit (LSB bit of mantissa is bit0 in the code)
      tU32    m_u32AbsValMask; // mask for all relevant bits in the code value except the sign bit (if any)

      tS16    m_s16ExpBase;    // exponent base value used for coding
      tS16    m_s16ExpMax;     // maximum logical exponent value
      tS16    m_s16ExpMin;     // minimum logical exponent value

      tU32    m_u32InfCode;    // code value for "Infinity"
      tU32    m_u32NaNCode;    // code value for "NaN"
      
      tDouble m_dEpsVal;           // epsilon value (relative distance of two consecutive numbers is always >epsilon and <=2*epsilon) 
      tDouble m_dCenAbsVal;        // "central" codable value (e.g. of 1.0/4.0/0.25 if expBias==0/+2/-2)
      tDouble m_dMaxAbsVal;        // largest codable value
      tDouble m_dMinAbsVal;        // smallest (absolute) value codable in normalized form
      tDouble m_dMinAbsValDenorm;  // smallest (absolute) value codable in denormalized form
      
      tBool   m_bSetupOk;
      
   public:
      vd_rvc_tclFlexFloat(tVoid);
      vd_rvc_tclFlexFloat(tU8 u8NumBits, tU8 u8NumExpBits, tS16 s16ExponentBias=0, tBool bWithSignBit=true);
      vd_rvc_tclFlexFloat(tU8 u8NumBits, tDouble dMinAbsVal, tDouble dMaxAbsVal, tBool bWithSignBit=true);
      ~vd_rvc_tclFlexFloat();
      // tell lint that the method vSetup() declared below will initialize all member variables which are not initialized directly by the constructor(s):
      //lint -sem(vd_rvc_tclFlexFloat::vSetup,initializer)
      tVoid vSetup(tU8 u8NumBits, tU8 u8NumExpBits, tS16 s16ExponentBias=0, tBool bWithSignBit=true);
      
      tBool   bFormatValid(tVoid)           { return m_bSetupOk; }

      tDouble dEPS(tVoid)                   { return m_bSetupOk ? m_dEpsVal          : s_dNaNValue; }
      tDouble dCEN(tVoid)                   { return m_bSetupOk ? m_dCenAbsVal       : s_dNaNValue; }
      tDouble dMAX(tVoid)                   { return m_bSetupOk ? m_dMaxAbsVal       : s_dNaNValue; }
      tDouble dMIN(tVoid)                   { return m_bSetupOk ? m_dMinAbsVal       : s_dNaNValue; }
      tDouble dMIN_DENORM(tVoid)            { return m_bSetupOk ? m_dMinAbsValDenorm : s_dNaNValue; }
      
      tBool   bIsInf   (tU32 u32CodeValue) const;
      tBool   bIsNaN   (tU32 u32CodeValue) const;
      tBool   bIsDenorm(tU32 u32CodeValue) const;

      tDouble dDecode(tU32 u32CodeValue) const;
      tDouble dDecode(const tU8 *pu8CodeBytes, tBool bLittleEndian=true) const;

      tU32 u32Encode(tDouble dValue) const;
      tVoid  vEncode(tDouble dValue, tU8 *pu8CodeBytes, tBool bLittleEndian=true) const;      
};


class vd_rvc_tclCrc32
{      
   private:
      tU32 m_u32CrcMask;
      tU32 m_u32MagicValue;
      
   public:
      enum vd_rvc_tclCrc32Type
      {
         CRC32_IEEE_802_3,
         CRC32_CASTAGNOLI,
         CRC32_KOOPMAN,
         CRC32_AIXM,
         CRC32_CM_CR
      };
   
      vd_rvc_tclCrc32(vd_rvc_tclCrc32::vd_rvc_tclCrc32Type enCrcType=CRC32_KOOPMAN);
      ~vd_rvc_tclCrc32();
      tU32  u32Calc(const tU8* pu8Bytes, tU32 u32NumBytes, tBool bInvertCrc=true,     tU32 u32StartVal=0xFFFFFFFF) const;  // to calculate and return the CRC of a byte stream
      tBool bCheck (const tU8* pu8Bytes, tU32 u32NumBytes, tBool bCrcIsInverted=true, tU32 u32StartVal=0xFFFFFFFF) const;  // to check the CRC of a byte stream containing that CRC in its last 4 bytes
};


#endif
