/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_Plotter.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2014 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_PLOTTER_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_PLOTTER_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif


/*******************************************************************************
                        Defines
*******************************************************************************/

#define LINEPLOTTER_ALPHA_MAXVAL                          0xFF
//#define LINEPLOTTER_GREATER_ALPHA_MEANS_MORE_TRANSPARENT  // comment out this #define if a greater Alpha channel value means 'more opaque'

#define LINEPLOTTER_NUM_BYTES_PER_PIX                     4                                                    // 1 byte each for R, G, B and Alpha
#define LINEPLOTTER_COLOR_RGB_AS_U32(r,g,b)               (((tU32)(r)<<16) | ((tU32)(g)<<8) | ((tU32)(b)<<0))  // leaving the Alpha byte as 0x00


#ifdef LINEPLOTTER_GREATER_ALPHA_MEANS_MORE_TRANSPARENT
   #define LINEPLOTTER_COLOR_RGBA_VALUE(RgbColor,TranspByte)   ( (tU32)(RgbColor) | ((tU32)(                           (TranspByte)) << 24) )
   #define LINEPLOTTER_FULLY_TRANSPARENT                       (LINEPLOTTER_ALPHA_MAXVAL)
#else
   #define LINEPLOTTER_COLOR_RGBA_VALUE(RgbColor,TranspByte)   ( (tU32)(RgbColor) | ((tU32)((LINEPLOTTER_ALPHA_MAXVAL)-(TranspByte)) << 24) )
   #define LINEPLOTTER_FULLY_TRANSPARENT                       0x00   
#endif


/*******************************************************************************
   Class vd_rvc_tclGraphics_DynGuideline_Plotter
*******************************************************************************/

// forward declarations
class  vd_rvc_t2IntVect;
struct vd_rvc_tstOutputBufferParams;
struct vd_rvc_tstImageAreaParams;

class vd_rvc_tclGraphics_DynGuideline_Plotter
{
   /********** properties **********/
   
   private:
   
      tU32* m_pu32OutBuf;
      tS32  m_s32NumBufXpix;
      tS32  m_s32NumBufYpix;
      tU32  m_u32Color;
      
      tBool m_bAntiAliasOn;
      tBool m_bEraseModeOn;

      tS32  m_s32BbXmin, m_s32BbXmax, m_s32BbYmin, m_s32BbYmax;
      tBool m_bIsBoundingBoxSet;
      
   public:

      // constructor and destructor   
      vd_rvc_tclGraphics_DynGuideline_Plotter(tVoid);
      ~vd_rvc_tclGraphics_DynGuideline_Plotter();
      
      // methods to set up the plotting output buffer, line color, ... for the subsequent vPlotXyz() calls
      tVoid vSetOutBuffer(const vd_rvc_tstOutputBufferParams *pstBufParams);
      inline tVoid vSetColor(tU8 u8Red, tU8 u8Green, tU8 u8Blue)  { m_u32Color     = LINEPLOTTER_COLOR_RGB_AS_U32(u8Red,u8Green,u8Blue); }
      inline tVoid vSetAntiAliasing(tBool bAntiAliasOn)           { m_bAntiAliasOn = bAntiAliasOn; }
      inline tVoid vSetEraseMode(tBool bEraseModeOn)              { m_bEraseModeOn = bEraseModeOn; }

      // method to clear the output buffer content
      tVoid vClearOutBufferContent(const vd_rvc_tstImageAreaParams *pstImgParams);
      
      // methods to set the bounding box for clipping
      tVoid vSetBoundingBox(tS32 s32BbXmin, tS32 s32BbXmax, tS32 s32BbYmin, tS32 s32BbYmax);
      
      // general API method to draw a line
      tVoid vPlotLine(const vd_rvc_t2IntVect * poPsta, const vd_rvc_t2IntVect * poPend,  tFloat fLineWidth=1.0);
      
   /********** private methods **********/

   // methods to do the bounding-box clipping
#ifndef EIS2HI_DEB_TEST_ENV
   private:
#endif
      tBool bClipToBoundingBox(vd_rvc_t2IntVect * poPsta, vd_rvc_t2IntVect * poPend) const;
#ifdef  EIS2HI_DEB_TEST_ENV
   private:
#endif
      tU32  u32GetPosFlags(const vd_rvc_t2IntVect * poP) const;
      tU32  u32ShiftToBoundingBoxBorders(vd_rvc_t2IntVect * poP, tU32 u32PosFlags,  tFloat fDx, tFloat fDy) const;
   
      // specialized methods to draw lines 1 or N pixels wide, with or without anti-aliasing
      tVoid vPlotLine_1   (tS32 s32Xsta, tS32 s32Ysta,  tS32 s32Xend, tS32 s32Yend);
      tVoid vPlotLine_1_AA(tS32 s32Xsta, tS32 s32Ysta,  tS32 s32Xend, tS32 s32Yend);
      tVoid vPlotLine_N   (tS32 s32Xsta, tS32 s32Ysta,  tS32 s32Xend, tS32 s32Yend,  tFloat fLineWidth);
      tVoid vPlotLine_N_AA(tS32 s32Xsta, tS32 s32Ysta,  tS32 s32Xend, tS32 s32Yend,  tFloat fLineWidth);
      
      // central workhorse method to set a buffer pixel to a certain color+transparency - inline for the sake of efficiency
      inline tVoid vSetPixel(tS32 s32X, tS32 s32Y, tFloat fTransparency=0.0)
      {
         // for performance reasons, (a) this method is inline, and (b) m_pu32OutBuf and m_bIsBoundingBoxSet are both not checked here
         // (gets done in method vPlotLine() "further up" the call stack)
         if ( s32X>=m_s32BbXmin && s32X<=m_s32BbXmax  && s32Y>=m_s32BbYmin && s32Y<=m_s32BbYmax )
         {
            // cope with possible round-off errors of transparency:
            if      (0   > fTransparency)
               fTransparency = 0.0;
            else if (255 < fTransparency)
               fTransparency = 255.0;
            // write the pixel's RGBA to the screen buffer:
            *(m_pu32OutBuf + s32Y*m_s32NumBufXpix + s32X) = LINEPLOTTER_COLOR_RGBA_VALUE(m_u32Color,(tU8)fTransparency);
         }

#ifdef EIS2HI_DEB_TEST_ENV
         Pixel(s32X,s32Y,(tU8)fTransparency);
         PlotterCntPix++;
         if ( m_bIsBoundingBoxSet && ! (s32X>=m_s32BbXmin && s32X<=m_s32BbXmax     && s32Y>=m_s32BbYmin && s32Y<=m_s32BbYmax ) )
            PlotterCntBad++;
         if (                        ! (s32X>=0           && s32X< m_s32NumBufXpix && s32Y>=0           && s32Y< m_s32NumBufYpix) )
            PlotterCntErr++;
#endif
      }
      
      inline tVoid vClrPixel(tS32 s32X, tS32 s32Y)
      {
         if ( s32X>=m_s32BbXmin && s32X<=m_s32BbXmax  && s32Y>=m_s32BbYmin && s32Y<=m_s32BbYmax )
         {
            // set the pixel's RGBA value in the screen buffer to "fully transparent":
            *(m_pu32OutBuf + s32Y*m_s32NumBufXpix + s32X) = LINEPLOTTER_COLOR_RGBA_VALUE(0xFFFFFF,0xFF);
         }
      }
};


#endif
